/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.indexer.report.TaskReport;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.druid.msq.guice.MSQIndexingModule;
import org.apache.druid.msq.indexing.report.MSQResultsReport;
import org.apache.druid.msq.indexing.report.MSQTaskReport;
import org.apache.druid.msq.indexing.report.MSQTaskReportPayload;
import org.apache.druid.query.http.SqlTaskStatus;
import org.apache.druid.sql.http.SqlQuery;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.clients.OverlordResourceTestClient;
import org.apache.druid.testing.clients.SqlResourceTestClient;
import org.apache.druid.testing.utils.AbstractTestQueryHelper;
import org.apache.druid.testing.utils.MsqQueryWithResults;
import org.apache.druid.testing.utils.QueryResultVerifier;
import org.apache.druid.testing.utils.TestQueryHelper;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.testng.Assert;

public class MsqTestQueryHelper
extends AbstractTestQueryHelper<MsqQueryWithResults> {
    private final ObjectMapper jsonMapper;
    private final IntegrationTestingConfig config;
    private final OverlordResourceTestClient overlordClient;
    private final SqlResourceTestClient msqClient;

    @Inject
    MsqTestQueryHelper(ObjectMapper jsonMapper, SqlResourceTestClient queryClient, IntegrationTestingConfig config, OverlordResourceTestClient overlordClient, SqlResourceTestClient msqClient) {
        super(jsonMapper, queryClient, config);
        this.jsonMapper = jsonMapper;
        this.config = config;
        this.overlordClient = overlordClient;
        this.msqClient = msqClient;
        this.jsonMapper.registerModules((Iterable)new MSQIndexingModule().getJacksonModules());
    }

    @Override
    public String getQueryURL(String schemeAndHost) {
        return StringUtils.format((String)"%s/druid/v2/sql/task", (Object[])new Object[]{schemeAndHost});
    }

    public SqlTaskStatus submitMsqTaskSuccesfully(String sqlQueryString) throws ExecutionException, InterruptedException {
        return this.submitMsqTaskSuccesfully(sqlQueryString, (Map<String, Object>)ImmutableMap.of());
    }

    public SqlTaskStatus submitMsqTaskSuccesfully(String sqlQueryString, Map<String, Object> context) throws ExecutionException, InterruptedException {
        return this.submitMsqTaskSuccesfully(new SqlQuery(sqlQueryString, null, false, false, false, context, null), null, null);
    }

    public SqlTaskStatus submitMsqTaskSuccesfully(SqlQuery sqlQuery) throws ExecutionException, InterruptedException {
        return this.submitMsqTaskSuccesfully(sqlQuery, null, null);
    }

    public SqlTaskStatus submitMsqTaskSuccesfully(SqlQuery sqlQuery, String username, String password) throws ExecutionException, InterruptedException {
        return this.submitMsqTaskWithExpectedStatusCode(sqlQuery, username, password, HttpResponseStatus.ACCEPTED);
    }

    public SqlTaskStatus submitMsqTaskWithExpectedStatusCode(SqlQuery sqlQuery, String username, String password, HttpResponseStatus expectedResponseStatus) throws ExecutionException, InterruptedException {
        SqlTaskStatus sqlTaskStatus;
        StatusResponseHolder statusResponseHolder = this.submitMsqTask(sqlQuery, username, password);
        HttpResponseStatus httpResponseStatus = statusResponseHolder.getStatus();
        if (!httpResponseStatus.equals((Object)expectedResponseStatus)) {
            throw new ISE(StringUtils.format((String)"Expected response status code [%d] when submitting task. Received response status code [%d], and response content:\n[%s]", (Object[])new Object[]{expectedResponseStatus.getCode(), httpResponseStatus.getCode(), statusResponseHolder.getContent()}), new Object[0]);
        }
        String content = statusResponseHolder.getContent();
        try {
            sqlTaskStatus = (SqlTaskStatus)this.jsonMapper.readValue(content, SqlTaskStatus.class);
        }
        catch (JsonProcessingException e) {
            throw new ISE("Unable to parse the response", new Object[0]);
        }
        return sqlTaskStatus;
    }

    public StatusResponseHolder submitMsqTask(SqlQuery sqlQuery, String username, String password) throws ExecutionException, InterruptedException {
        String queryUrl = this.getQueryURL(this.config.getBrokerUrl());
        Future<StatusResponseHolder> responseHolderFuture = this.msqClient.queryAsync(queryUrl, sqlQuery, username, password);
        try {
            return responseHolderFuture.get(5L, TimeUnit.MINUTES);
        }
        catch (TimeoutException e) {
            throw new ISE((Throwable)e, "Unable to fetch the task id for the submitted task in time.", new Object[0]);
        }
    }

    public TaskState pollTaskIdForCompletion(String taskId) throws Exception {
        return (TaskState)RetryUtils.retry(() -> {
            TaskStatusPlus taskStatusPlus = this.overlordClient.getTaskStatus(taskId);
            TaskState statusCode = taskStatusPlus.getStatusCode();
            if (statusCode != null && statusCode.isComplete()) {
                return taskStatusPlus.getStatusCode();
            }
            throw new TaskStillRunningException();
        }, t -> t instanceof TaskStillRunningException, (int)99, (int)100);
    }

    public void pollTaskIdForSuccess(String taskId) throws Exception {
        Assert.assertEquals((Object)this.pollTaskIdForCompletion(taskId), (Object)TaskState.SUCCESS);
    }

    public TaskReport.ReportMap fetchStatusReports(String taskId) {
        return this.overlordClient.getTaskReport(taskId);
    }

    public List<Map<String, Object>> getTaskResult(String taskId) {
        TaskReport.ReportMap statusReport = this.fetchStatusReports(taskId);
        MSQTaskReport taskReport = (MSQTaskReport)statusReport.get("multiStageQuery");
        if (taskReport == null) {
            throw new ISE("Unable to fetch the status report for the task [%]", new Object[]{taskId});
        }
        MSQTaskReportPayload taskReportPayload = (MSQTaskReportPayload)Preconditions.checkNotNull((Object)taskReport.getPayload(), (Object)"payload");
        MSQResultsReport resultsReport = (MSQResultsReport)Preconditions.checkNotNull((Object)taskReportPayload.getResults(), (Object)"Results report for the task id is empty");
        ArrayList<Map<String, Object>> actualResults = new ArrayList<Map<String, Object>>();
        List rowSignature = resultsReport.getSignature();
        for (Object[] row : resultsReport.getResults()) {
            LinkedHashMap<String, Object> rowWithFieldNames = new LinkedHashMap<String, Object>();
            for (int i = 0; i < row.length; ++i) {
                rowWithFieldNames.put(((MSQResultsReport.ColumnAndType)rowSignature.get(i)).getName(), row[i]);
            }
            actualResults.add(rowWithFieldNames);
        }
        return actualResults;
    }

    private void compareResults(String taskId, MsqQueryWithResults expectedQueryWithResults) {
        List<Map<String, Object>> actualResults = this.getTaskResult(taskId);
        QueryResultVerifier.ResultVerificationObject resultsComparison = QueryResultVerifier.compareResults(actualResults, expectedQueryWithResults.getExpectedResults(), Collections.emptyList());
        if (!resultsComparison.isSuccess()) {
            throw new IAE("Expected query result is different from the actual result.\nQuery: %s\nActual Result: %s\nExpected Result: %s\nMismatch Error: %s\n", new Object[]{expectedQueryWithResults.getQuery(), actualResults, expectedQueryWithResults.getExpectedResults(), resultsComparison.getErrorMessage()});
        }
    }

    @Override
    public void testQueriesFromFile(String filePath, String fullDatasourcePath) throws Exception {
        LOG.info("Starting query tests for [%s]", new Object[]{filePath});
        List queries = (List)this.jsonMapper.readValue(TestQueryHelper.class.getResourceAsStream(filePath), (TypeReference)new TypeReference<List<MsqQueryWithResults>>(){});
        for (MsqQueryWithResults queryWithResults : queries) {
            String queryString = (String)queryWithResults.getQuery();
            String queryWithDatasource = StringUtils.replace((String)queryString, (String)"%%DATASOURCE%%", (String)fullDatasourcePath);
            SqlTaskStatus sqlTaskStatus = this.submitMsqTaskSuccesfully(queryWithDatasource);
            if (sqlTaskStatus.getState().isFailure()) {
                throw new ISE("Unable to start the task successfully.\nPossible exception: %s", new Object[]{sqlTaskStatus.getError()});
            }
            String taskId = sqlTaskStatus.getTaskId();
            this.pollTaskIdForSuccess(taskId);
            this.compareResults(taskId, queryWithResults);
        }
    }

    public void submitMsqTaskAndWaitForCompletion(String sqlQueryString, Map<String, Object> context) throws Exception {
        SqlTaskStatus sqlTaskStatus = this.submitMsqTaskSuccesfully(sqlQueryString, context);
        LOG.info("Sql Task submitted with task Id - %s", new Object[]{sqlTaskStatus.getTaskId()});
        if (sqlTaskStatus.getState().isFailure()) {
            Assert.fail((String)StringUtils.format((String)"Unable to start the task successfully.\nPossible exception: %s", (Object[])new Object[]{sqlTaskStatus.getError()}));
        }
        this.pollTaskIdForCompletion(sqlTaskStatus.getTaskId());
    }

    private static class TaskStillRunningException
    extends Exception {
        private TaskStillRunningException() {
        }
    }
}

