/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.utils;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.security.TLSCertificateChecker;

public class ITTLSCertificateChecker
implements TLSCertificateChecker {
    private static final Logger log = new Logger(ITTLSCertificateChecker.class);

    public void checkClient(X509Certificate[] chain, String authType, SSLEngine engine, X509ExtendedTrustManager baseTrustManager) throws CertificateException {
        if (!chain[0].toString().contains("thisisprobablynottherighthostname") || !engine.getPeerHost().contains("172.172.172.1")) {
            throw new CertificateException("Custom check rejected request from client.");
        }
    }

    public void checkServer(X509Certificate[] chain, String authType, SSLEngine engine, X509ExtendedTrustManager baseTrustManager) throws CertificateException {
        baseTrustManager.checkServerTrusted(chain, authType, engine);
        if (chain[0].toString().contains("172.172.172.60")) {
            throw new CertificateException("Custom check intentionally terminated request to broker.");
        }
    }
}

