/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.utils;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.testing.utils.EventSerializer;

public class AvroEventSerializer
implements EventSerializer {
    public static final String TYPE = "avro";
    static final Schema SCHEMA = (Schema)((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"wikipedia").namespace("org.apache.druid")).fields().requiredString("timestamp").requiredString("page").requiredString("language").requiredString("user").requiredString("unpatrolled").requiredString("newPage").requiredString("robot").requiredString("anonymous").requiredString("namespace").requiredString("continent").requiredString("country").requiredString("region").requiredString("city").requiredInt("added").requiredInt("deleted").requiredInt("delta").endRecord();
    protected final DatumWriter<Object> writer = new GenericDatumWriter(SCHEMA);

    @Override
    public byte[] serialize(List<Pair<String, Object>> event) throws IOException {
        WikipediaRecord record = new WikipediaRecord(SCHEMA);
        event.forEach(pair -> record.put((String)pair.lhs, pair.rhs));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)out, null);
        this.writer.write((Object)record, (Encoder)encoder);
        encoder.flush();
        out.close();
        return out.toByteArray();
    }

    @Override
    public void close() {
    }

    static class WikipediaRecord
    implements GenericRecord {
        private final Map<String, Object> event = new HashMap<String, Object>();
        private final BiMap<Integer, String> indexes = HashBiMap.create((int)SCHEMA.getFields().size());
        private int nextIndex = 0;
        private final Schema schema;

        public WikipediaRecord(Schema schema) {
            this.schema = schema;
        }

        public void put(String key, Object v) {
            this.event.put(key, v);
            this.indexes.inverse().computeIfAbsent((Object)key, k -> this.nextIndex++);
        }

        public Object get(String key) {
            return this.event.get(key);
        }

        public void put(int i, Object v) {
            String key = (String)this.indexes.get((Object)i);
            if (key == null) {
                throw new IndexOutOfBoundsException();
            }
            this.put(key, v);
        }

        public Object get(int i) {
            String key = (String)this.indexes.get((Object)i);
            if (key == null) {
                throw new IndexOutOfBoundsException();
            }
            return this.get(key);
        }

        public Schema getSchema() {
            return this.schema;
        }
    }
}

