/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.clients;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.apache.druid.indexing.overlord.http.CompactionConfigsResponse;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.druid.server.compaction.CompactionSimulateResult;
import org.apache.druid.server.compaction.CompactionStatusResponse;
import org.apache.druid.server.coordinator.AutoCompactionSnapshot;
import org.apache.druid.server.coordinator.ClusterCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.DruidCompactionConfig;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.guice.TestClient;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class CompactionResourceTestClient {
    private static final Logger log = new Logger(CompactionResourceTestClient.class);
    private final ObjectMapper jsonMapper;
    private final HttpClient httpClient;
    private final String coordinator;
    private final String overlord;
    private final StatusResponseHandler responseHandler;

    @Inject
    CompactionResourceTestClient(ObjectMapper jsonMapper, @TestClient HttpClient httpClient, IntegrationTestingConfig config) {
        this.jsonMapper = jsonMapper;
        this.httpClient = httpClient;
        this.coordinator = config.getCoordinatorUrl();
        this.overlord = config.getOverlordUrl();
        this.responseHandler = StatusResponseHandler.getInstance();
    }

    private String getCoordinatorURL() {
        return StringUtils.format((String)"%s/druid/coordinator/v1/", (Object[])new Object[]{this.coordinator});
    }

    private String getOverlordURL() {
        return StringUtils.format((String)"%s/druid/indexer/v1", (Object[])new Object[]{this.overlord});
    }

    public void submitCompactionConfig(DataSourceCompactionConfig dataSourceCompactionConfig) throws Exception {
        String dataSource = dataSourceCompactionConfig.getDataSource();
        String url = StringUtils.format((String)"%s/compaction/config/datasources/%s", (Object[])new Object[]{this.getOverlordURL(), StringUtils.urlEncode((String)dataSource)});
        StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(url)).setContent("application/json", this.jsonMapper.writeValueAsBytes((Object)dataSourceCompactionConfig)), (HttpResponseHandler)this.responseHandler).get();
        if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
            throw new ISE("Error while submiting compaction config status[%s] content[%s]", new Object[]{response.getStatus(), response.getContent()});
        }
        log.info("Submitted compaction config for datasource[%s] with response[%s]", new Object[]{dataSource, response.getContent()});
    }

    public void deleteDataSourceCompactionConfig(String dataSource) throws Exception {
        String url = StringUtils.format((String)"%s/compaction/config/datasources/%s", (Object[])new Object[]{this.getOverlordURL(), StringUtils.urlEncode((String)dataSource)});
        StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.DELETE, new URL(url)), (HttpResponseHandler)this.responseHandler).get();
        if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
            throw new ISE("Error while deleting compaction config status[%s] content[%s]", new Object[]{response.getStatus(), response.getContent()});
        }
    }

    @Deprecated
    public DruidCompactionConfig getCoordinatorCompactionConfig() throws Exception {
        String url = StringUtils.format((String)"%sconfig/compaction", (Object[])new Object[]{this.getCoordinatorURL()});
        StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.GET, new URL(url)), (HttpResponseHandler)this.responseHandler).get();
        if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
            throw new ISE("Error while getting compaction config status[%s] content[%s]", new Object[]{response.getStatus(), response.getContent()});
        }
        return (DruidCompactionConfig)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<DruidCompactionConfig>(){});
    }

    public List<DataSourceCompactionConfig> getAllCompactionConfigs() throws Exception {
        String url = StringUtils.format((String)"%s/compaction/config/datasources", (Object[])new Object[]{this.getOverlordURL()});
        StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.GET, new URL(url)), (HttpResponseHandler)this.responseHandler).get();
        if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
            throw new ISE("Error while getting compaction config status[%s] content[%s]", new Object[]{response.getStatus(), response.getContent()});
        }
        CompactionConfigsResponse payload = (CompactionConfigsResponse)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<CompactionConfigsResponse>(){});
        return payload.getCompactionConfigs();
    }

    public DataSourceCompactionConfig getDataSourceCompactionConfig(String dataSource) throws Exception {
        String url = StringUtils.format((String)"%s/compaction/config/datasources/%s", (Object[])new Object[]{this.getOverlordURL(), StringUtils.urlEncode((String)dataSource)});
        StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.GET, new URL(url)), (HttpResponseHandler)this.responseHandler).get();
        if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
            throw new ISE("Error while getting compaction config status[%s] content[%s]", new Object[]{response.getStatus(), response.getContent()});
        }
        return (DataSourceCompactionConfig)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<DataSourceCompactionConfig>(){});
    }

    public void forceTriggerAutoCompaction() throws Exception {
        ClusterCompactionConfig clusterConfig = this.getClusterConfig();
        this.updateCompactionTaskSlot(clusterConfig.getCompactionTaskSlotRatio(), clusterConfig.getMaxCompactionTaskSlots() + 10);
        this.updateCompactionTaskSlot(clusterConfig.getCompactionTaskSlotRatio(), clusterConfig.getMaxCompactionTaskSlots());
        CompactionSimulateResult simulateResult = this.simulateRunOnCoordinator();
        log.info("Triggering compaction duty on Coordinator. Expected jobs: %s", new Object[]{simulateResult.getCompactionStates()});
        String url = StringUtils.format((String)"%scompaction/compact", (Object[])new Object[]{this.getCoordinatorURL()});
        StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(url)), (HttpResponseHandler)this.responseHandler).get();
        if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
            throw new ISE("Error while force trigger auto compaction status[%s] content[%s]", new Object[]{response.getStatus(), response.getContent()});
        }
    }

    public void updateClusterConfig(ClusterCompactionConfig config) throws Exception {
        String url = StringUtils.format((String)"%s/compaction/config/cluster", (Object[])new Object[]{this.getOverlordURL()});
        StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(url)).setContent("application/json", this.jsonMapper.writeValueAsBytes((Object)config)), (HttpResponseHandler)this.responseHandler).get();
        if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
            throw new ISE("Error while updating cluster compaction config, status[%s], content[%s]", new Object[]{response.getStatus(), response.getContent()});
        }
    }

    public ClusterCompactionConfig getClusterConfig() throws Exception {
        String url = StringUtils.format((String)"%s/compaction/config/cluster", (Object[])new Object[]{this.getOverlordURL()});
        StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.GET, new URL(url)), (HttpResponseHandler)this.responseHandler).get();
        if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
            throw new ISE("Error while getting compaction config status[%s] content[%s]", new Object[]{response.getStatus(), response.getContent()});
        }
        return (ClusterCompactionConfig)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<ClusterCompactionConfig>(){});
    }

    @Deprecated
    private void updateCompactionTaskSlot(Double compactionTaskSlotRatio, Integer maxCompactionTaskSlots) throws Exception {
        String url = StringUtils.format((String)"%sconfig/compaction/taskslots?ratio=%s&max=%s", (Object[])new Object[]{this.getCoordinatorURL(), StringUtils.urlEncode((String)compactionTaskSlotRatio.toString()), StringUtils.urlEncode((String)maxCompactionTaskSlots.toString())});
        StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(url)), (HttpResponseHandler)this.responseHandler).get();
        if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
            throw new ISE("Error while updating compaction task slot status[%s] content[%s]", new Object[]{response.getStatus(), response.getContent()});
        }
    }

    public Map<String, String> getCompactionProgress(String dataSource) throws Exception {
        String url = StringUtils.format((String)"%scompaction/progress?dataSource=%s", (Object[])new Object[]{this.getCoordinatorURL(), StringUtils.urlEncode((String)dataSource)});
        StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.GET, new URL(url)), (HttpResponseHandler)this.responseHandler).get();
        if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
            throw new ISE("Error while getting compaction progress status[%s] content[%s]", new Object[]{response.getStatus(), response.getContent()});
        }
        return (Map)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<Map<String, String>>(){});
    }

    public AutoCompactionSnapshot getCompactionStatus(String dataSource) throws Exception {
        String url = StringUtils.format((String)"%scompaction/status?dataSource=%s", (Object[])new Object[]{this.getCoordinatorURL(), StringUtils.urlEncode((String)dataSource)});
        StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.GET, new URL(url)), (HttpResponseHandler)this.responseHandler).get();
        if (response.getStatus().equals((Object)HttpResponseStatus.NOT_FOUND)) {
            return null;
        }
        if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
            throw new ISE("Error while getting compaction status status[%s] content[%s]", new Object[]{response.getStatus(), response.getContent()});
        }
        CompactionStatusResponse latestSnapshots = (CompactionStatusResponse)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<CompactionStatusResponse>(){});
        return (AutoCompactionSnapshot)latestSnapshots.getLatestStatus().get(0);
    }

    public CompactionSimulateResult simulateRunOnCoordinator() throws Exception {
        ClusterCompactionConfig clusterConfig = this.getClusterConfig();
        String url = StringUtils.format((String)"%scompaction/simulate", (Object[])new Object[]{this.getCoordinatorURL()});
        StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, new URL(url)).setContent("application/json", this.jsonMapper.writeValueAsBytes((Object)clusterConfig)), (HttpResponseHandler)this.responseHandler).get();
        if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
            throw new ISE("Error while running simulation on Coordinator: status[%s], content[%s]", new Object[]{response.getStatus(), response.getContent()});
        }
        return (CompactionSimulateResult)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<CompactionSimulateResult>(){});
    }
}

