/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.offheapstore.paging;

import java.nio.ByteBuffer;
import org.terracotta.offheapstore.buffersource.BufferSource;
import org.terracotta.offheapstore.paging.OffHeapStorageArea;
import org.terracotta.offheapstore.paging.Page;
import org.terracotta.offheapstore.paging.PageSource;

public class UnlimitedPageSource
implements PageSource {
    private final BufferSource source;

    public UnlimitedPageSource(BufferSource source2) {
        this.source = source2;
    }

    @Override
    public Page allocate(int size, boolean thief, boolean victim, OffHeapStorageArea owner) {
        ByteBuffer buffer = this.source.allocateBuffer(size);
        if (buffer == null) {
            return null;
        }
        return new Page(buffer, owner);
    }

    @Override
    public void free(Page page) {
    }
}

