/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.offheapstore.concurrent;

import java.util.Arrays;
import java.util.Comparator;
import org.terracotta.offheapstore.Segment;
import org.terracotta.offheapstore.concurrent.AbstractConcurrentOffHeapMap;
import org.terracotta.offheapstore.exceptions.OversizeMappingException;
import org.terracotta.offheapstore.pinning.PinnableCache;
import org.terracotta.offheapstore.pinning.PinnableSegment;
import org.terracotta.offheapstore.util.Factory;

public abstract class AbstractConcurrentOffHeapCache<K, V>
extends AbstractConcurrentOffHeapMap<K, V>
implements PinnableCache<K, V> {
    private static final Comparator<Segment<?, ?>> SIZE_COMPARATOR = new Comparator<Segment<?, ?>>(){

        @Override
        public int compare(Segment<?, ?> o1, Segment<?, ?> o2) {
            return (int)(o2.getSize() - o1.getSize());
        }
    };

    public AbstractConcurrentOffHeapCache(Factory<? extends PinnableSegment<K, V>> segmentFactory) {
        super(segmentFactory);
    }

    public AbstractConcurrentOffHeapCache(Factory<? extends Segment<K, V>> segmentFactory, int concurrency) {
        super(segmentFactory, concurrency);
    }

    @Override
    public V fill(K key, V value) {
        try {
            return super.fill(key, value);
        }
        catch (OversizeMappingException e) {
            return null;
        }
    }

    @Override
    public V getAndPin(K key) {
        return this.segmentFor(key).getValueAndSetMetadata(key, 0x40000000, 0x40000000);
    }

    @Override
    public V putPinned(K key, V value) {
        try {
            return this.segmentFor(key).putPinned(key, value);
        }
        catch (OversizeMappingException e) {
            if (this.handleOversizeMappingException(key.hashCode())) {
                try {
                    return this.segmentFor(key).putPinned(key, value);
                }
                catch (OversizeMappingException ex) {
                    // empty catch block
                }
            }
            this.writeLockAll();
            while (true) {
                try {
                    V ex = this.segmentFor(key).putPinned(key, value);
                    return ex;
                }
                catch (OversizeMappingException ex) {
                    e = ex;
                    if (this.handleOversizeMappingException(key.hashCode())) continue;
                    throw e;
                }
                break;
            }
            finally {
                this.writeUnlockAll();
            }
        }
    }

    @Override
    public boolean isPinned(Object key) {
        return this.segmentFor(key).isPinned(key);
    }

    @Override
    public void setPinning(K key, boolean pinned) {
        this.segmentFor(key).setPinning(key, pinned);
    }

    @Override
    protected PinnableSegment<K, V> segmentFor(Object key) {
        return (PinnableSegment)super.segmentFor(key);
    }

    public boolean shrink() {
        Segment[] sorted2 = (Segment[])this.segments.clone();
        Arrays.sort(sorted2, SIZE_COMPARATOR);
        for (Segment s2 : sorted2) {
            if (!s2.shrink()) continue;
            return true;
        }
        return false;
    }

    public boolean shrinkOthers(int excludedHash) {
        boolean evicted = false;
        Segment target = this.segmentFor(excludedHash);
        for (Segment s2 : this.segments) {
            if (s2 == target) continue;
            evicted |= s2.shrink();
        }
        return evicted;
    }
}

