/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mortbay.util.LazyList;

public class MultiMap
extends HashMap
implements Cloneable {
    public MultiMap() {
    }

    public MultiMap(int size) {
        super(size);
    }

    public MultiMap(Map map) {
        super(map.size() * 3 / 2);
        this.putAll(map);
    }

    public List getValues(Object name) {
        return LazyList.getList(super.get(name), true);
    }

    public Object getValue(Object name, int i) {
        Object l = super.get(name);
        if (i == 0 && LazyList.size(l) == 0) {
            return null;
        }
        return LazyList.get(l, i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(Object name) {
        StringBuffer values2;
        Object l = super.get(name);
        switch (LazyList.size(l)) {
            case 0: {
                return null;
            }
            case 1: {
                Object o = LazyList.get(l, 0);
                return o == null ? null : o.toString();
            }
        }
        StringBuffer stringBuffer = values2 = new StringBuffer(128);
        synchronized (stringBuffer) {
            for (int i = 0; i < LazyList.size(l); ++i) {
                Object e = LazyList.get(l, i);
                if (e == null) continue;
                if (values2.length() > 0) {
                    values2.append(',');
                }
                values2.append(e.toString());
            }
            return values2.toString();
        }
    }

    public Object get(Object name) {
        Object l = super.get(name);
        switch (LazyList.size(l)) {
            case 0: {
                return null;
            }
            case 1: {
                Object o = LazyList.get(l, 0);
                return o;
            }
        }
        return LazyList.getList(l, true);
    }

    public Object put(Object name, Object value) {
        return super.put(name, LazyList.add(null, value));
    }

    public Object putValues(Object name, List values2) {
        return super.put(name, values2);
    }

    public Object putValues(Object name, String[] values2) {
        Object list = null;
        for (int i = 0; i < values2.length; ++i) {
            list = LazyList.add(list, values2[i]);
        }
        return this.put(name, list);
    }

    public void add(Object name, Object value) {
        Object ln;
        Object lo = super.get(name);
        if (lo != (ln = LazyList.add(lo, value))) {
            super.put(name, ln);
        }
    }

    public void addValues(Object name, List values2) {
        Object ln;
        Object lo = super.get(name);
        if (lo != (ln = LazyList.addCollection(lo, values2))) {
            super.put(name, ln);
        }
    }

    public void addValues(Object name, String[] values2) {
        Object ln;
        Object lo = super.get(name);
        if (lo != (ln = LazyList.addCollection(lo, Arrays.asList(values2)))) {
            super.put(name, ln);
        }
    }

    public boolean removeValue(Object name, Object value) {
        Object lo;
        Object ln = lo = super.get(name);
        int s2 = LazyList.size(lo);
        if (s2 > 0) {
            ln = LazyList.remove(lo, value);
            if (ln == null) {
                super.remove(name);
            } else {
                super.put(name, ln);
            }
        }
        return LazyList.size(ln) != s2;
    }

    public void putAll(Map m3) {
        Iterator i = m3.entrySet().iterator();
        boolean multi = m3 instanceof MultiMap;
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (multi) {
                super.put(entry.getKey(), LazyList.clone(entry.getValue()));
                continue;
            }
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Map toStringArrayMap() {
        HashMap map = new HashMap(this.size() * 3 / 2);
        Iterator i = super.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Object l = entry.getValue();
            String[] a = LazyList.toStringArray(l);
            map.put(entry.getKey(), a);
        }
        return map;
    }

    public Object clone() {
        MultiMap mm3 = (MultiMap)super.clone();
        Iterator iter = mm3.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            entry.setValue(LazyList.clone(entry.getValue()));
        }
        return mm3;
    }
}

