/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.core;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.ehcache.Cache;
import org.ehcache.Status;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.CacheRuntimeConfiguration;
import org.ehcache.core.EhcacheRuntimeConfiguration;
import org.ehcache.core.InternalCache;
import org.ehcache.core.Jsr107Cache;
import org.ehcache.core.SpecIterator;
import org.ehcache.core.StatusTransitioner;
import org.ehcache.core.events.CacheEventDispatcher;
import org.ehcache.core.exceptions.ExceptionFactory;
import org.ehcache.core.internal.resilience.LoggingRobustResilienceStrategy;
import org.ehcache.core.internal.resilience.RecoveryCache;
import org.ehcache.core.internal.resilience.ResilienceStrategy;
import org.ehcache.core.internal.util.ValueSuppliers;
import org.ehcache.core.spi.LifeCycled;
import org.ehcache.core.spi.function.BiFunction;
import org.ehcache.core.spi.function.Function;
import org.ehcache.core.spi.function.NullaryFunction;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.StoreAccessException;
import org.ehcache.core.statistics.BulkOps;
import org.ehcache.core.statistics.CacheOperationOutcomes;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expiry;
import org.ehcache.spi.loaderwriter.BulkCacheLoadingException;
import org.ehcache.spi.loaderwriter.BulkCacheWritingException;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.slf4j.Logger;
import org.terracotta.statistics.StatisticBuilder;
import org.terracotta.statistics.StatisticsManager;
import org.terracotta.statistics.jsr166e.LongAdder;
import org.terracotta.statistics.observer.OperationObserver;

public class Ehcache<K, V>
implements InternalCache<K, V> {
    private final StatusTransitioner statusTransitioner;
    private final Store<K, V> store;
    private final ResilienceStrategy<K, V> resilienceStrategy;
    private final EhcacheRuntimeConfiguration<K, V> runtimeConfiguration;
    private final Jsr107CacheImpl jsr107Cache;
    protected final Logger logger;
    private final OperationObserver<CacheOperationOutcomes.GetOutcome> getObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.GetOutcome.class).named("get")).of(this)).tag("cache")).build();
    private final OperationObserver<CacheOperationOutcomes.GetAllOutcome> getAllObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.GetAllOutcome.class).named("getAll")).of(this)).tag("cache")).build();
    private final OperationObserver<CacheOperationOutcomes.PutOutcome> putObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.PutOutcome.class).named("put")).of(this)).tag("cache")).build();
    private final OperationObserver<CacheOperationOutcomes.PutAllOutcome> putAllObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.PutAllOutcome.class).named("putAll")).of(this)).tag("cache")).build();
    private final OperationObserver<CacheOperationOutcomes.RemoveOutcome> removeObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.RemoveOutcome.class).named("remove")).of(this)).tag("cache")).build();
    private final OperationObserver<CacheOperationOutcomes.RemoveAllOutcome> removeAllObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.RemoveAllOutcome.class).named("removeAll")).of(this)).tag("cache")).build();
    private final OperationObserver<CacheOperationOutcomes.ConditionalRemoveOutcome> conditionalRemoveObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.ConditionalRemoveOutcome.class).named("conditionalRemove")).of(this)).tag("cache")).build();
    private final OperationObserver<CacheOperationOutcomes.PutIfAbsentOutcome> putIfAbsentObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.PutIfAbsentOutcome.class).named("putIfAbsent")).of(this)).tag("cache")).build();
    private final OperationObserver<CacheOperationOutcomes.ReplaceOutcome> replaceObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.ReplaceOutcome.class).named("replace")).of(this)).tag("cache")).build();
    private final Map<BulkOps, LongAdder> bulkMethodEntries = new EnumMap<BulkOps, LongAdder>(BulkOps.class);
    private final OperationObserver<CacheOperationOutcomes.ClearOutcome> clearObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(CacheOperationOutcomes.ClearOutcome.class).named("clear")).of(this)).tag("cache")).build();

    public Ehcache(CacheConfiguration<K, V> configuration, Store<K, V> store, CacheEventDispatcher<K, V> eventDispatcher, Logger logger) {
        this(new EhcacheRuntimeConfiguration<K, V>(configuration), store, eventDispatcher, logger, new StatusTransitioner(logger));
    }

    Ehcache(EhcacheRuntimeConfiguration<K, V> runtimeConfiguration, Store<K, V> store, CacheEventDispatcher<K, V> eventDispatcher, Logger logger, StatusTransitioner statusTransitioner) {
        this.store = store;
        runtimeConfiguration.addCacheConfigurationListener(store.getConfigurationChangeListeners());
        StatisticsManager.associate(store).withParent(this);
        this.resilienceStrategy = store instanceof RecoveryCache ? new LoggingRobustResilienceStrategy(this.castToRecoveryCache(store)) : new LoggingRobustResilienceStrategy(Ehcache.recoveryCache(store));
        this.runtimeConfiguration = runtimeConfiguration;
        runtimeConfiguration.addCacheConfigurationListener(eventDispatcher.getConfigurationChangeListeners());
        this.jsr107Cache = new Jsr107CacheImpl();
        this.logger = logger;
        this.statusTransitioner = statusTransitioner;
        for (BulkOps bulkOp : BulkOps.values()) {
            this.bulkMethodEntries.put(bulkOp, new LongAdder());
        }
    }

    @Override
    public Map<BulkOps, LongAdder> getBulkMethodEntries() {
        return this.bulkMethodEntries;
    }

    private RecoveryCache<K> castToRecoveryCache(Store<K, V> store) {
        return (RecoveryCache)((Object)store);
    }

    private V getNoLoader(K key) {
        return this.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        this.getObserver.begin();
        this.statusTransitioner.checkAvailable();
        Ehcache.checkNonNull(key);
        try {
            Store.ValueHolder<V> valueHolder = this.store.get(key);
            if (valueHolder == null) {
                this.getObserver.end(CacheOperationOutcomes.GetOutcome.MISS);
                return null;
            }
            this.getObserver.end(CacheOperationOutcomes.GetOutcome.HIT);
            return valueHolder.value();
        }
        catch (StoreAccessException e) {
            try {
                V v = this.resilienceStrategy.getFailure(key, e);
                return v;
            }
            finally {
                this.getObserver.end(CacheOperationOutcomes.GetOutcome.FAILURE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value) {
        this.putObserver.begin();
        this.statusTransitioner.checkAvailable();
        Ehcache.checkNonNull(key, value);
        try {
            Store.PutStatus status = this.store.put(key, value);
            switch (status) {
                case PUT: {
                    this.putObserver.end(CacheOperationOutcomes.PutOutcome.PUT);
                    break;
                }
                case UPDATE: {
                    this.putObserver.end(CacheOperationOutcomes.PutOutcome.UPDATED);
                    break;
                }
                case NOOP: {
                    this.putObserver.end(CacheOperationOutcomes.PutOutcome.NOOP);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Invalid Status.");
                }
            }
        }
        catch (StoreAccessException e) {
            try {
                this.resilienceStrategy.putFailure(key, value, e);
            }
            finally {
                this.putObserver.end(CacheOperationOutcomes.PutOutcome.FAILURE);
            }
        }
    }

    private boolean newValueAlreadyExpired(K key, V oldValue, V newValue) {
        return Ehcache.newValueAlreadyExpired(this.logger, this.runtimeConfiguration.getExpiry(), key, oldValue, newValue);
    }

    @Override
    public boolean containsKey(K key) {
        this.statusTransitioner.checkAvailable();
        Ehcache.checkNonNull(key);
        try {
            return this.store.containsKey(key);
        }
        catch (StoreAccessException e) {
            return this.resilienceStrategy.containsKeyFailure(key, e);
        }
    }

    @Override
    public void remove(K key) {
        this.removeInternal(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeInternal(K key) {
        this.removeObserver.begin();
        this.statusTransitioner.checkAvailable();
        Ehcache.checkNonNull(key);
        boolean removed = false;
        try {
            removed = this.store.remove(key);
            if (removed) {
                this.removeObserver.end(CacheOperationOutcomes.RemoveOutcome.SUCCESS);
            } else {
                this.removeObserver.end(CacheOperationOutcomes.RemoveOutcome.NOOP);
            }
        }
        catch (StoreAccessException e) {
            try {
                this.resilienceStrategy.removeFailure(key, e);
            }
            finally {
                this.removeObserver.end(CacheOperationOutcomes.RemoveOutcome.FAILURE);
            }
        }
        return removed;
    }

    @Override
    public void clear() {
        this.clearObserver.begin();
        this.statusTransitioner.checkAvailable();
        try {
            this.store.clear();
            this.clearObserver.end(CacheOperationOutcomes.ClearOutcome.SUCCESS);
        }
        catch (StoreAccessException e) {
            this.clearObserver.end(CacheOperationOutcomes.ClearOutcome.FAILURE);
            this.resilienceStrategy.clearFailure(e);
        }
    }

    @Override
    public Iterator<Cache.Entry<K, V>> iterator() {
        this.statusTransitioner.checkAvailable();
        return new CacheEntryIterator(false);
    }

    @Override
    public Map<K, V> getAll(Set<? extends K> keys2) throws BulkCacheLoadingException {
        return this.getAllInternal(keys2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<K, V> getAllInternal(Set<? extends K> keys2, boolean includeNulls) throws BulkCacheLoadingException {
        this.getAllObserver.begin();
        this.statusTransitioner.checkAvailable();
        this.checkNonNullContent(keys2);
        if (keys2.isEmpty()) {
            this.getAllObserver.end(CacheOperationOutcomes.GetAllOutcome.SUCCESS);
            return Collections.emptyMap();
        }
        HashMap result = new HashMap();
        try {
            Map<K, Store.ValueHolder<V>> computedMap = this.store.bulkComputeIfAbsent(keys2, new GetAllFunction());
            int hits = 0;
            int keyCount = 0;
            for (Map.Entry<K, Store.ValueHolder<V>> entry : computedMap.entrySet()) {
                ++keyCount;
                if (entry.getValue() != null) {
                    result.put(entry.getKey(), entry.getValue().value());
                    ++hits;
                    continue;
                }
                if (!includeNulls) continue;
                result.put(entry.getKey(), null);
            }
            this.addBulkMethodEntriesCount(BulkOps.GET_ALL_HITS, hits);
            this.addBulkMethodEntriesCount(BulkOps.GET_ALL_MISS, keyCount - hits);
            this.getAllObserver.end(CacheOperationOutcomes.GetAllOutcome.SUCCESS);
            return result;
        }
        catch (StoreAccessException e) {
            try {
                Map<? extends K, V> map = this.resilienceStrategy.getAllFailure(keys2, e);
                return map;
            }
            finally {
                this.getAllObserver.end(CacheOperationOutcomes.GetAllOutcome.FAILURE);
            }
        }
    }

    LinkedHashSet<Map.Entry<? extends K, ? extends V>> nullValuesForKeys(Iterable<? extends K> keys2) {
        LinkedHashSet<Map.Entry<K, V>> entries = new LinkedHashSet<Map.Entry<K, V>>();
        for (K key : keys2) {
            entries.add(new AbstractMap.SimpleEntry<K, Object>(key, null));
        }
        return entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> entries) throws BulkCacheWritingException {
        this.putAllObserver.begin();
        this.statusTransitioner.checkAvailable();
        Ehcache.checkNonNull(entries);
        if (entries.isEmpty()) {
            this.putAllObserver.end(CacheOperationOutcomes.PutAllOutcome.SUCCESS);
            return;
        }
        HashMap<K, V> entriesToRemap = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : entries.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) {
                throw new NullPointerException();
            }
            entriesToRemap.put(entry.getKey(), entry.getValue());
        }
        try {
            PutAllFunction putAllFunction = new PutAllFunction(this.logger, entriesToRemap, this.runtimeConfiguration.getExpiry());
            this.store.bulkCompute(entries.keySet(), putAllFunction);
            this.addBulkMethodEntriesCount(BulkOps.PUT_ALL, putAllFunction.getActualPutCount().get());
            this.addBulkMethodEntriesCount(BulkOps.UPDATE_ALL, putAllFunction.getActualUpdateCount().get());
            this.putAllObserver.end(CacheOperationOutcomes.PutAllOutcome.SUCCESS);
        }
        catch (StoreAccessException e) {
            try {
                this.resilienceStrategy.putAllFailure(entries, e);
            }
            finally {
                this.putAllObserver.end(CacheOperationOutcomes.PutAllOutcome.FAILURE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll(Set<? extends K> keys2) throws BulkCacheWritingException {
        this.removeAllObserver.begin();
        this.statusTransitioner.checkAvailable();
        Ehcache.checkNonNull(keys2);
        if (keys2.isEmpty()) {
            this.removeAllObserver.end(CacheOperationOutcomes.RemoveAllOutcome.SUCCESS);
            return;
        }
        for (K key : keys2) {
            if (key != null) continue;
            throw new NullPointerException();
        }
        try {
            RemoveAllFunction removeAllFunction = new RemoveAllFunction();
            this.store.bulkCompute(keys2, removeAllFunction);
            this.addBulkMethodEntriesCount(BulkOps.REMOVE_ALL, removeAllFunction.getActualRemoveCount().get());
            this.removeAllObserver.end(CacheOperationOutcomes.RemoveAllOutcome.SUCCESS);
        }
        catch (StoreAccessException e) {
            try {
                this.resilienceStrategy.removeAllFailure(keys2, e);
            }
            finally {
                this.removeAllObserver.end(CacheOperationOutcomes.RemoveAllOutcome.FAILURE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        this.putIfAbsentObserver.begin();
        this.statusTransitioner.checkAvailable();
        Ehcache.checkNonNull(key, value);
        boolean absent = false;
        try {
            Store.ValueHolder<V> inCache = this.store.putIfAbsent(key, value);
            boolean bl = absent = inCache == null;
            if (absent) {
                this.putIfAbsentObserver.end(CacheOperationOutcomes.PutIfAbsentOutcome.PUT);
                return null;
            }
            this.putIfAbsentObserver.end(CacheOperationOutcomes.PutIfAbsentOutcome.HIT);
            return inCache.value();
        }
        catch (StoreAccessException e) {
            try {
                V v = this.resilienceStrategy.putIfAbsentFailure(key, value, null, e, absent);
                return v;
            }
            finally {
                this.putIfAbsentObserver.end(CacheOperationOutcomes.PutIfAbsentOutcome.FAILURE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(K key, V value) {
        this.conditionalRemoveObserver.begin();
        this.statusTransitioner.checkAvailable();
        Ehcache.checkNonNull(key, value);
        Store.RemoveStatus status = null;
        boolean removed = false;
        try {
            status = this.store.remove(key, value);
            switch (status) {
                case REMOVED: {
                    removed = true;
                    this.conditionalRemoveObserver.end(CacheOperationOutcomes.ConditionalRemoveOutcome.SUCCESS);
                    break;
                }
                case KEY_MISSING: {
                    this.conditionalRemoveObserver.end(CacheOperationOutcomes.ConditionalRemoveOutcome.FAILURE_KEY_MISSING);
                    break;
                }
                case KEY_PRESENT: {
                    this.conditionalRemoveObserver.end(CacheOperationOutcomes.ConditionalRemoveOutcome.FAILURE_KEY_PRESENT);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Invalid Status.");
                }
            }
        }
        catch (StoreAccessException e) {
            try {
                boolean bl = this.resilienceStrategy.removeFailure(key, value, e, removed);
                return bl;
            }
            finally {
                this.conditionalRemoveObserver.end(CacheOperationOutcomes.ConditionalRemoveOutcome.FAILURE);
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        this.replaceObserver.begin();
        this.statusTransitioner.checkAvailable();
        Ehcache.checkNonNull(key, value);
        try {
            Store.ValueHolder<V> old = this.store.replace(key, value);
            if (old != null) {
                this.replaceObserver.end(CacheOperationOutcomes.ReplaceOutcome.HIT);
            } else {
                this.replaceObserver.end(CacheOperationOutcomes.ReplaceOutcome.MISS_NOT_PRESENT);
            }
            return old == null ? null : (V)old.value();
        }
        catch (StoreAccessException e) {
            try {
                V v = this.resilienceStrategy.replaceFailure(key, value, e);
                return v;
            }
            finally {
                this.replaceObserver.end(CacheOperationOutcomes.ReplaceOutcome.FAILURE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        this.replaceObserver.begin();
        this.statusTransitioner.checkAvailable();
        Ehcache.checkNonNull(key, oldValue, newValue);
        Store.ReplaceStatus status = null;
        boolean success = false;
        try {
            status = this.store.replace(key, oldValue, newValue);
            switch (status) {
                case HIT: {
                    success = true;
                    this.replaceObserver.end(CacheOperationOutcomes.ReplaceOutcome.HIT);
                    break;
                }
                case MISS_PRESENT: {
                    this.replaceObserver.end(CacheOperationOutcomes.ReplaceOutcome.MISS_PRESENT);
                    break;
                }
                case MISS_NOT_PRESENT: {
                    this.replaceObserver.end(CacheOperationOutcomes.ReplaceOutcome.MISS_NOT_PRESENT);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Invalid Status.");
                }
            }
            return success;
        }
        catch (StoreAccessException e) {
            try {
                boolean bl = this.resilienceStrategy.replaceFailure(key, oldValue, newValue, e, success);
                return bl;
            }
            finally {
                this.replaceObserver.end(CacheOperationOutcomes.ReplaceOutcome.FAILURE);
            }
        }
    }

    @Override
    public CacheRuntimeConfiguration<K, V> getRuntimeConfiguration() {
        return this.runtimeConfiguration;
    }

    @Override
    public void init() {
        this.statusTransitioner.init().succeeded();
    }

    @Override
    public void close() {
        this.statusTransitioner.close().succeeded();
    }

    @Override
    public Status getStatus() {
        return this.statusTransitioner.currentStatus();
    }

    @Override
    public void addHook(LifeCycled hook) {
        this.statusTransitioner.addHook(hook);
    }

    void removeHook(LifeCycled hook) {
        this.statusTransitioner.removeHook(hook);
    }

    private static void checkNonNull(Object thing) {
        if (thing == null) {
            throw new NullPointerException();
        }
    }

    private static void checkNonNull(Object ... things) {
        for (Object thing : things) {
            Ehcache.checkNonNull(thing);
        }
    }

    private void checkNonNullContent(Collection<?> collectionOfThings) {
        Ehcache.checkNonNull(collectionOfThings);
        for (Object thing : collectionOfThings) {
            Ehcache.checkNonNull(thing);
        }
    }

    private void addBulkMethodEntriesCount(BulkOps op, long count) {
        this.bulkMethodEntries.get((Object)op).add(count);
    }

    @Override
    public Jsr107Cache<K, V> getJsr107Cache() {
        return this.jsr107Cache;
    }

    @Override
    public CacheLoaderWriter<? super K, V> getCacheLoaderWriter() {
        return null;
    }

    private static <K> RecoveryCache<K> recoveryCache(final Store<K, ?> store) {
        return new RecoveryCache<K>(){

            @Override
            public void obliterate() throws StoreAccessException {
                store.clear();
            }

            @Override
            public void obliterate(K key) throws StoreAccessException {
                store.remove(key);
            }

            @Override
            public void obliterate(Iterable<? extends K> keys2) throws StoreAccessException {
                for (Object key : keys2) {
                    this.obliterate(key);
                }
            }
        };
    }

    private static <K, V> boolean newValueAlreadyExpired(Logger logger, Expiry<? super K, ? super V> expiry, K key, V oldValue, V newValue) {
        Duration duration;
        if (newValue == null) {
            return false;
        }
        try {
            duration = oldValue == null ? expiry.getExpiryForCreation(key, newValue) : expiry.getExpiryForUpdate(key, ValueSuppliers.supplierOf(oldValue), newValue);
        }
        catch (RuntimeException re) {
            logger.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)re);
            return true;
        }
        return Duration.ZERO.equals(duration);
    }

    public static class GetAllFunction<K, V>
    implements Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> {
        @Override
        public Iterable<? extends Map.Entry<? extends K, ? extends V>> apply(Iterable<? extends K> keys2) {
            LinkedHashMap computeResult = new LinkedHashMap();
            for (K key : keys2) {
                computeResult.put(key, null);
            }
            return computeResult.entrySet();
        }
    }

    public static class RemoveAllFunction<K, V>
    implements Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> {
        private final AtomicInteger actualRemoveCount = new AtomicInteger();

        @Override
        public Iterable<? extends Map.Entry<? extends K, ? extends V>> apply(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
            LinkedHashMap results = new LinkedHashMap();
            for (Map.Entry<K, V> entry : entries) {
                K key = entry.getKey();
                V existingValue = entry.getValue();
                if (existingValue != null) {
                    this.actualRemoveCount.incrementAndGet();
                }
                results.put(key, null);
            }
            return results.entrySet();
        }

        public AtomicInteger getActualRemoveCount() {
            return this.actualRemoveCount;
        }
    }

    public static class PutAllFunction<K, V>
    implements Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> {
        private final Logger logger;
        private final Map<K, V> entriesToRemap;
        private final Expiry<? super K, ? super V> expiry;
        private final AtomicInteger actualPutCount = new AtomicInteger();
        private final AtomicInteger actualUpdateCount = new AtomicInteger();

        public PutAllFunction(Logger logger, Map<K, V> entriesToRemap, Expiry<? super K, ? super V> expiry) {
            this.logger = logger;
            this.entriesToRemap = entriesToRemap;
            this.expiry = expiry;
        }

        @Override
        public Iterable<? extends Map.Entry<? extends K, ? extends V>> apply(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
            LinkedHashMap<K, V> mutations = new LinkedHashMap<K, V>();
            for (Map.Entry<K, V> entry : entries) {
                V newValue;
                V existingValue;
                K key = entry.getKey();
                if (this.newValueAlreadyExpired(key, existingValue = entry.getValue(), newValue = this.entriesToRemap.remove(key))) {
                    mutations.put(key, null);
                    continue;
                }
                this.actualPutCount.incrementAndGet();
                if (existingValue != null) {
                    this.actualUpdateCount.incrementAndGet();
                }
                mutations.put(key, newValue);
            }
            return mutations.entrySet();
        }

        public Map<K, V> getEntriesToRemap() {
            return this.entriesToRemap;
        }

        private boolean newValueAlreadyExpired(K key, V oldValue, V newValue) {
            return Ehcache.newValueAlreadyExpired(this.logger, this.expiry, key, oldValue, newValue);
        }

        public AtomicInteger getActualPutCount() {
            return this.actualPutCount;
        }

        public AtomicInteger getActualUpdateCount() {
            return this.actualUpdateCount;
        }
    }

    private static class ValueHolderBasedEntry<K, V>
    implements Cache.Entry<K, V> {
        private final Cache.Entry<K, Store.ValueHolder<V>> storeEntry;

        ValueHolderBasedEntry(Cache.Entry<K, Store.ValueHolder<V>> storeEntry) {
            this.storeEntry = storeEntry;
        }

        @Override
        public K getKey() {
            return this.storeEntry.getKey();
        }

        @Override
        public V getValue() {
            return this.storeEntry.getValue().value();
        }
    }

    private class CacheEntryIterator
    implements Iterator<Cache.Entry<K, V>> {
        private final Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> iterator;
        private final boolean quiet;
        private Cache.Entry<K, Store.ValueHolder<V>> current;
        private Cache.Entry<K, Store.ValueHolder<V>> next;
        private StoreAccessException nextException;

        public CacheEntryIterator(boolean quiet) {
            this.quiet = quiet;
            this.iterator = Ehcache.this.store.iterator();
            this.advance();
        }

        private void advance() {
            try {
                while (this.iterator.hasNext()) {
                    this.next = this.iterator.next();
                    if (Ehcache.this.getNoLoader(this.next.getKey()) == null) continue;
                    return;
                }
                this.next = null;
            }
            catch (RuntimeException re) {
                this.nextException = new StoreAccessException(re);
                this.next = null;
            }
            catch (StoreAccessException cae) {
                this.nextException = cae;
                this.next = null;
            }
        }

        @Override
        public boolean hasNext() {
            Ehcache.this.statusTransitioner.checkAvailable();
            return this.nextException != null || this.next != null;
        }

        @Override
        public Cache.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.quiet) {
                Ehcache.this.getObserver.begin();
            }
            if (this.nextException == null) {
                if (!this.quiet) {
                    Ehcache.this.getObserver.end(CacheOperationOutcomes.GetOutcome.HIT);
                }
                this.current = this.next;
                this.advance();
                return new ValueHolderBasedEntry(this.current);
            }
            if (!this.quiet) {
                Ehcache.this.getObserver.end(CacheOperationOutcomes.GetOutcome.FAILURE);
            }
            StoreAccessException cae = this.nextException;
            this.nextException = null;
            return Ehcache.this.resilienceStrategy.iteratorFailure(cae);
        }

        @Override
        public void remove() {
            Ehcache.this.statusTransitioner.checkAvailable();
            if (this.current == null) {
                throw new IllegalStateException("No current element");
            }
            Ehcache.this.remove(this.current.getKey(), this.current.getValue().value());
            this.current = null;
        }
    }

    private final class Jsr107CacheImpl
    implements Jsr107Cache<K, V> {
        private Jsr107CacheImpl() {
        }

        @Override
        public void loadAll(Set<? extends K> keys2, boolean replaceExistingValues, Function<Iterable<? extends K>, Map<K, V>> loadFunction) {
            if (keys2.isEmpty()) {
                return;
            }
            if (replaceExistingValues) {
                this.loadAllReplace(keys2, loadFunction);
            } else {
                this.loadAllAbsent(keys2, loadFunction);
            }
        }

        @Override
        public Iterator<Cache.Entry<K, V>> specIterator() {
            return new SpecIterator(this, Ehcache.this.store);
        }

        @Override
        public V getNoLoader(K key) {
            return Ehcache.this.getNoLoader(key);
        }

        @Override
        public Map<K, V> getAll(Set<? extends K> keys2) {
            return Ehcache.this.getAllInternal(keys2, false);
        }

        private void loadAllAbsent(Set<? extends K> keys2, final Function<Iterable<? extends K>, Map<K, V>> loadFunction) {
            try {
                Ehcache.this.store.bulkComputeIfAbsent(keys2, new Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>>(){

                    @Override
                    public Iterable<? extends Map.Entry<? extends K, ? extends V>> apply(Iterable<? extends K> absentKeys) {
                        return Jsr107CacheImpl.this.cacheLoaderWriterLoadAllForKeys(absentKeys, loadFunction).entrySet();
                    }
                });
            }
            catch (StoreAccessException e) {
                throw ExceptionFactory.newCacheLoadingException(e);
            }
        }

        Map<K, V> cacheLoaderWriterLoadAllForKeys(Iterable<? extends K> keys2, Function<Iterable<? extends K>, Map<K, V>> loadFunction) {
            try {
                Map loaded = loadFunction.apply(keys2);
                LinkedHashMap rv = new LinkedHashMap();
                for (Object key : keys2) {
                    rv.put(key, loaded.get(key));
                }
                return rv;
            }
            catch (Exception e) {
                throw ExceptionFactory.newCacheLoadingException(e);
            }
        }

        private void loadAllReplace(Set<? extends K> keys2, final Function<Iterable<? extends K>, Map<K, V>> loadFunction) {
            try {
                Ehcache.this.store.bulkCompute(keys2, new Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>>(){

                    @Override
                    public Iterable<? extends Map.Entry<? extends K, ? extends V>> apply(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
                        ArrayList keys2 = new ArrayList();
                        for (Map.Entry entry : entries) {
                            keys2.add(entry.getKey());
                        }
                        return Jsr107CacheImpl.this.cacheLoaderWriterLoadAllForKeys(keys2, loadFunction).entrySet();
                    }
                });
            }
            catch (StoreAccessException e) {
                throw ExceptionFactory.newCacheLoadingException(e);
            }
        }

        @Override
        public void compute(K key, final BiFunction<? super K, ? super V, ? extends V> computeFunction, final NullaryFunction<Boolean> replaceEqual, NullaryFunction<Boolean> invokeWriter, final NullaryFunction<Boolean> withStatsAndEvents) {
            Ehcache.this.putObserver.begin();
            Ehcache.this.removeObserver.begin();
            Ehcache.this.getObserver.begin();
            try {
                BiFunction fn = new BiFunction<K, V, V>(){

                    @Override
                    public V apply(K mappedKey, V mappedValue) {
                        if (mappedValue == null) {
                            Ehcache.this.getObserver.end(CacheOperationOutcomes.GetOutcome.MISS);
                        } else {
                            Ehcache.this.getObserver.end(CacheOperationOutcomes.GetOutcome.HIT);
                        }
                        Object newValue = computeFunction.apply(mappedKey, mappedValue);
                        if (newValue == mappedValue && !((Boolean)replaceEqual.apply()).booleanValue()) {
                            return mappedValue;
                        }
                        if (Ehcache.this.newValueAlreadyExpired(mappedKey, mappedValue, newValue)) {
                            return null;
                        }
                        if (((Boolean)withStatsAndEvents.apply()).booleanValue()) {
                            if (newValue == null) {
                                Ehcache.this.removeObserver.end(CacheOperationOutcomes.RemoveOutcome.SUCCESS);
                            } else {
                                Ehcache.this.putObserver.end(mappedValue == null ? CacheOperationOutcomes.PutOutcome.PUT : CacheOperationOutcomes.PutOutcome.UPDATED);
                            }
                        }
                        return newValue;
                    }
                };
                Ehcache.this.store.compute(key, fn, replaceEqual);
            }
            catch (StoreAccessException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public V getAndRemove(K key) {
            Ehcache.this.getObserver.begin();
            Ehcache.this.removeObserver.begin();
            final AtomicReference existingValue = new AtomicReference();
            try {
                Ehcache.this.store.compute(key, new BiFunction<K, V, V>(){

                    @Override
                    public V apply(K mappedKey, V mappedValue) {
                        existingValue.set(mappedValue);
                        return null;
                    }
                });
            }
            catch (StoreAccessException e) {
                Ehcache.this.getObserver.end(CacheOperationOutcomes.GetOutcome.FAILURE);
                Ehcache.this.removeObserver.end(CacheOperationOutcomes.RemoveOutcome.FAILURE);
                throw new RuntimeException(e);
            }
            Object returnValue = existingValue.get();
            if (returnValue != null) {
                Ehcache.this.getObserver.end(CacheOperationOutcomes.GetOutcome.HIT);
                Ehcache.this.removeObserver.end(CacheOperationOutcomes.RemoveOutcome.SUCCESS);
            } else {
                Ehcache.this.getObserver.end(CacheOperationOutcomes.GetOutcome.MISS);
            }
            return returnValue;
        }

        @Override
        public V getAndPut(K key, final V value) {
            Ehcache.this.getObserver.begin();
            Ehcache.this.putObserver.begin();
            final AtomicReference existingValue = new AtomicReference();
            try {
                Ehcache.this.store.compute(key, new BiFunction<K, V, V>(){

                    @Override
                    public V apply(K mappedKey, V mappedValue) {
                        existingValue.set(mappedValue);
                        if (Ehcache.this.newValueAlreadyExpired(mappedKey, mappedValue, value)) {
                            return null;
                        }
                        return value;
                    }
                });
            }
            catch (StoreAccessException e) {
                Ehcache.this.getObserver.end(CacheOperationOutcomes.GetOutcome.FAILURE);
                Ehcache.this.putObserver.end(CacheOperationOutcomes.PutOutcome.FAILURE);
                throw new RuntimeException(e);
            }
            Object returnValue = existingValue.get();
            if (returnValue != null) {
                Ehcache.this.getObserver.end(CacheOperationOutcomes.GetOutcome.HIT);
                Ehcache.this.putObserver.end(CacheOperationOutcomes.PutOutcome.UPDATED);
            } else {
                Ehcache.this.getObserver.end(CacheOperationOutcomes.GetOutcome.MISS);
                Ehcache.this.putObserver.end(CacheOperationOutcomes.PutOutcome.PUT);
            }
            return returnValue;
        }

        @Override
        public boolean remove(K key) {
            return Ehcache.this.removeInternal(key);
        }

        @Override
        public void removeAll() {
            Store.Iterator iterator2 = Ehcache.this.store.iterator();
            while (iterator2.hasNext()) {
                try {
                    Cache.Entry next = iterator2.next();
                    this.remove(next.getKey());
                }
                catch (StoreAccessException storeAccessException) {}
            }
        }
    }
}

