/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.format;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.parquet.format.ColumnChunk;
import org.apache.parquet.format.SortingColumn;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;

public class RowGroup
implements TBase<RowGroup, _Fields>,
Serializable,
Cloneable,
Comparable<RowGroup> {
    private static final TStruct STRUCT_DESC = new TStruct("RowGroup");
    private static final TField COLUMNS_FIELD_DESC = new TField("columns", 15, 1);
    private static final TField TOTAL_BYTE_SIZE_FIELD_DESC = new TField("total_byte_size", 10, 2);
    private static final TField NUM_ROWS_FIELD_DESC = new TField("num_rows", 10, 3);
    private static final TField SORTING_COLUMNS_FIELD_DESC = new TField("sorting_columns", 15, 4);
    private static final TField FILE_OFFSET_FIELD_DESC = new TField("file_offset", 10, 5);
    private static final TField TOTAL_COMPRESSED_SIZE_FIELD_DESC = new TField("total_compressed_size", 10, 6);
    private static final TField ORDINAL_FIELD_DESC = new TField("ordinal", 6, 7);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new RowGroupStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new RowGroupTupleSchemeFactory();
    @Nullable
    public List<ColumnChunk> columns;
    public long total_byte_size;
    public long num_rows;
    @Nullable
    public List<SortingColumn> sorting_columns;
    public long file_offset;
    public long total_compressed_size;
    public short ordinal;
    private static final int __TOTAL_BYTE_SIZE_ISSET_ID = 0;
    private static final int __NUM_ROWS_ISSET_ID = 1;
    private static final int __FILE_OFFSET_ISSET_ID = 2;
    private static final int __TOTAL_COMPRESSED_SIZE_ISSET_ID = 3;
    private static final int __ORDINAL_ISSET_ID = 4;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.SORTING_COLUMNS, _Fields.FILE_OFFSET, _Fields.TOTAL_COMPRESSED_SIZE, _Fields.ORDINAL};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public RowGroup() {
    }

    public RowGroup(List<ColumnChunk> columns, long total_byte_size, long num_rows) {
        this();
        this.columns = columns;
        this.total_byte_size = total_byte_size;
        this.setTotalByteSizeIsSet(true);
        this.num_rows = num_rows;
        this.setNumRowsIsSet(true);
    }

    public RowGroup(RowGroup other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetColumns()) {
            ArrayList<ColumnChunk> __this__columns = new ArrayList<ColumnChunk>(other.columns.size());
            for (ColumnChunk columnChunk : other.columns) {
                __this__columns.add(new ColumnChunk(columnChunk));
            }
            this.columns = __this__columns;
        }
        this.total_byte_size = other.total_byte_size;
        this.num_rows = other.num_rows;
        if (other.isSetSortingColumns()) {
            ArrayList<SortingColumn> __this__sorting_columns = new ArrayList<SortingColumn>(other.sorting_columns.size());
            for (SortingColumn sortingColumn : other.sorting_columns) {
                __this__sorting_columns.add(new SortingColumn(sortingColumn));
            }
            this.sorting_columns = __this__sorting_columns;
        }
        this.file_offset = other.file_offset;
        this.total_compressed_size = other.total_compressed_size;
        this.ordinal = other.ordinal;
    }

    @Override
    public RowGroup deepCopy() {
        return new RowGroup(this);
    }

    @Override
    public void clear() {
        this.columns = null;
        this.setTotalByteSizeIsSet(false);
        this.total_byte_size = 0L;
        this.setNumRowsIsSet(false);
        this.num_rows = 0L;
        this.sorting_columns = null;
        this.setFileOffsetIsSet(false);
        this.file_offset = 0L;
        this.setTotalCompressedSizeIsSet(false);
        this.total_compressed_size = 0L;
        this.setOrdinalIsSet(false);
        this.ordinal = 0;
    }

    public int getColumnsSize() {
        return this.columns == null ? 0 : this.columns.size();
    }

    @Nullable
    public Iterator<ColumnChunk> getColumnsIterator() {
        return this.columns == null ? null : this.columns.iterator();
    }

    public void addToColumns(ColumnChunk elem) {
        if (this.columns == null) {
            this.columns = new ArrayList<ColumnChunk>();
        }
        this.columns.add(elem);
    }

    @Nullable
    public List<ColumnChunk> getColumns() {
        return this.columns;
    }

    public RowGroup setColumns(@Nullable List<ColumnChunk> columns) {
        this.columns = columns;
        return this;
    }

    public void unsetColumns() {
        this.columns = null;
    }

    public boolean isSetColumns() {
        return this.columns != null;
    }

    public void setColumnsIsSet(boolean value) {
        if (!value) {
            this.columns = null;
        }
    }

    public long getTotalByteSize() {
        return this.total_byte_size;
    }

    public RowGroup setTotalByteSize(long total_byte_size) {
        this.total_byte_size = total_byte_size;
        this.setTotalByteSizeIsSet(true);
        return this;
    }

    public void unsetTotalByteSize() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 0);
    }

    public boolean isSetTotalByteSize() {
        return EncodingUtils.testBit(this.__isset_bitfield, 0);
    }

    public void setTotalByteSizeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 0, value);
    }

    public long getNumRows() {
        return this.num_rows;
    }

    public RowGroup setNumRows(long num_rows) {
        this.num_rows = num_rows;
        this.setNumRowsIsSet(true);
        return this;
    }

    public void unsetNumRows() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 1);
    }

    public boolean isSetNumRows() {
        return EncodingUtils.testBit(this.__isset_bitfield, 1);
    }

    public void setNumRowsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 1, value);
    }

    public int getSortingColumnsSize() {
        return this.sorting_columns == null ? 0 : this.sorting_columns.size();
    }

    @Nullable
    public Iterator<SortingColumn> getSortingColumnsIterator() {
        return this.sorting_columns == null ? null : this.sorting_columns.iterator();
    }

    public void addToSortingColumns(SortingColumn elem) {
        if (this.sorting_columns == null) {
            this.sorting_columns = new ArrayList<SortingColumn>();
        }
        this.sorting_columns.add(elem);
    }

    @Nullable
    public List<SortingColumn> getSortingColumns() {
        return this.sorting_columns;
    }

    public RowGroup setSortingColumns(@Nullable List<SortingColumn> sorting_columns) {
        this.sorting_columns = sorting_columns;
        return this;
    }

    public void unsetSortingColumns() {
        this.sorting_columns = null;
    }

    public boolean isSetSortingColumns() {
        return this.sorting_columns != null;
    }

    public void setSortingColumnsIsSet(boolean value) {
        if (!value) {
            this.sorting_columns = null;
        }
    }

    public long getFileOffset() {
        return this.file_offset;
    }

    public RowGroup setFileOffset(long file_offset) {
        this.file_offset = file_offset;
        this.setFileOffsetIsSet(true);
        return this;
    }

    public void unsetFileOffset() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 2);
    }

    public boolean isSetFileOffset() {
        return EncodingUtils.testBit(this.__isset_bitfield, 2);
    }

    public void setFileOffsetIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 2, value);
    }

    public long getTotalCompressedSize() {
        return this.total_compressed_size;
    }

    public RowGroup setTotalCompressedSize(long total_compressed_size) {
        this.total_compressed_size = total_compressed_size;
        this.setTotalCompressedSizeIsSet(true);
        return this;
    }

    public void unsetTotalCompressedSize() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 3);
    }

    public boolean isSetTotalCompressedSize() {
        return EncodingUtils.testBit(this.__isset_bitfield, 3);
    }

    public void setTotalCompressedSizeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 3, value);
    }

    public short getOrdinal() {
        return this.ordinal;
    }

    public RowGroup setOrdinal(short ordinal) {
        this.ordinal = ordinal;
        this.setOrdinalIsSet(true);
        return this;
    }

    public void unsetOrdinal() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 4);
    }

    public boolean isSetOrdinal() {
        return EncodingUtils.testBit(this.__isset_bitfield, 4);
    }

    public void setOrdinalIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 4, value);
    }

    @Override
    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case COLUMNS: {
                if (value == null) {
                    this.unsetColumns();
                    break;
                }
                this.setColumns((List)value);
                break;
            }
            case TOTAL_BYTE_SIZE: {
                if (value == null) {
                    this.unsetTotalByteSize();
                    break;
                }
                this.setTotalByteSize((Long)value);
                break;
            }
            case NUM_ROWS: {
                if (value == null) {
                    this.unsetNumRows();
                    break;
                }
                this.setNumRows((Long)value);
                break;
            }
            case SORTING_COLUMNS: {
                if (value == null) {
                    this.unsetSortingColumns();
                    break;
                }
                this.setSortingColumns((List)value);
                break;
            }
            case FILE_OFFSET: {
                if (value == null) {
                    this.unsetFileOffset();
                    break;
                }
                this.setFileOffset((Long)value);
                break;
            }
            case TOTAL_COMPRESSED_SIZE: {
                if (value == null) {
                    this.unsetTotalCompressedSize();
                    break;
                }
                this.setTotalCompressedSize((Long)value);
                break;
            }
            case ORDINAL: {
                if (value == null) {
                    this.unsetOrdinal();
                    break;
                }
                this.setOrdinal((Short)value);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case COLUMNS: {
                return this.getColumns();
            }
            case TOTAL_BYTE_SIZE: {
                return this.getTotalByteSize();
            }
            case NUM_ROWS: {
                return this.getNumRows();
            }
            case SORTING_COLUMNS: {
                return this.getSortingColumns();
            }
            case FILE_OFFSET: {
                return this.getFileOffset();
            }
            case TOTAL_COMPRESSED_SIZE: {
                return this.getTotalCompressedSize();
            }
            case ORDINAL: {
                return this.getOrdinal();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case COLUMNS: {
                return this.isSetColumns();
            }
            case TOTAL_BYTE_SIZE: {
                return this.isSetTotalByteSize();
            }
            case NUM_ROWS: {
                return this.isSetNumRows();
            }
            case SORTING_COLUMNS: {
                return this.isSetSortingColumns();
            }
            case FILE_OFFSET: {
                return this.isSetFileOffset();
            }
            case TOTAL_COMPRESSED_SIZE: {
                return this.isSetTotalCompressedSize();
            }
            case ORDINAL: {
                return this.isSetOrdinal();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof RowGroup) {
            return this.equals((RowGroup)that);
        }
        return false;
    }

    public boolean equals(RowGroup that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_columns = this.isSetColumns();
        boolean that_present_columns = that.isSetColumns();
        if (this_present_columns || that_present_columns) {
            if (!this_present_columns || !that_present_columns) {
                return false;
            }
            if (!this.columns.equals(that.columns)) {
                return false;
            }
        }
        boolean this_present_total_byte_size = true;
        boolean that_present_total_byte_size = true;
        if (this_present_total_byte_size || that_present_total_byte_size) {
            if (!this_present_total_byte_size || !that_present_total_byte_size) {
                return false;
            }
            if (this.total_byte_size != that.total_byte_size) {
                return false;
            }
        }
        boolean this_present_num_rows = true;
        boolean that_present_num_rows = true;
        if (this_present_num_rows || that_present_num_rows) {
            if (!this_present_num_rows || !that_present_num_rows) {
                return false;
            }
            if (this.num_rows != that.num_rows) {
                return false;
            }
        }
        boolean this_present_sorting_columns = this.isSetSortingColumns();
        boolean that_present_sorting_columns = that.isSetSortingColumns();
        if (this_present_sorting_columns || that_present_sorting_columns) {
            if (!this_present_sorting_columns || !that_present_sorting_columns) {
                return false;
            }
            if (!this.sorting_columns.equals(that.sorting_columns)) {
                return false;
            }
        }
        boolean this_present_file_offset = this.isSetFileOffset();
        boolean that_present_file_offset = that.isSetFileOffset();
        if (this_present_file_offset || that_present_file_offset) {
            if (!this_present_file_offset || !that_present_file_offset) {
                return false;
            }
            if (this.file_offset != that.file_offset) {
                return false;
            }
        }
        boolean this_present_total_compressed_size = this.isSetTotalCompressedSize();
        boolean that_present_total_compressed_size = that.isSetTotalCompressedSize();
        if (this_present_total_compressed_size || that_present_total_compressed_size) {
            if (!this_present_total_compressed_size || !that_present_total_compressed_size) {
                return false;
            }
            if (this.total_compressed_size != that.total_compressed_size) {
                return false;
            }
        }
        boolean this_present_ordinal = this.isSetOrdinal();
        boolean that_present_ordinal = that.isSetOrdinal();
        if (this_present_ordinal || that_present_ordinal) {
            if (!this_present_ordinal || !that_present_ordinal) {
                return false;
            }
            if (this.ordinal != that.ordinal) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetColumns() ? 131071 : 524287);
        if (this.isSetColumns()) {
            hashCode = hashCode * 8191 + this.columns.hashCode();
        }
        hashCode = hashCode * 8191 + TBaseHelper.hashCode(this.total_byte_size);
        hashCode = hashCode * 8191 + TBaseHelper.hashCode(this.num_rows);
        hashCode = hashCode * 8191 + (this.isSetSortingColumns() ? 131071 : 524287);
        if (this.isSetSortingColumns()) {
            hashCode = hashCode * 8191 + this.sorting_columns.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetFileOffset() ? 131071 : 524287);
        if (this.isSetFileOffset()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode(this.file_offset);
        }
        hashCode = hashCode * 8191 + (this.isSetTotalCompressedSize() ? 131071 : 524287);
        if (this.isSetTotalCompressedSize()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode(this.total_compressed_size);
        }
        hashCode = hashCode * 8191 + (this.isSetOrdinal() ? 131071 : 524287);
        if (this.isSetOrdinal()) {
            hashCode = hashCode * 8191 + this.ordinal;
        }
        return hashCode;
    }

    @Override
    public int compareTo(RowGroup other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetColumns()).compareTo(other.isSetColumns());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumns() && (lastComparison = TBaseHelper.compareTo(this.columns, other.columns)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTotalByteSize()).compareTo(other.isSetTotalByteSize());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTotalByteSize() && (lastComparison = TBaseHelper.compareTo(this.total_byte_size, other.total_byte_size)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetNumRows()).compareTo(other.isSetNumRows());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNumRows() && (lastComparison = TBaseHelper.compareTo(this.num_rows, other.num_rows)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSortingColumns()).compareTo(other.isSetSortingColumns());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSortingColumns() && (lastComparison = TBaseHelper.compareTo(this.sorting_columns, other.sorting_columns)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetFileOffset()).compareTo(other.isSetFileOffset());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFileOffset() && (lastComparison = TBaseHelper.compareTo(this.file_offset, other.file_offset)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTotalCompressedSize()).compareTo(other.isSetTotalCompressedSize());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTotalCompressedSize() && (lastComparison = TBaseHelper.compareTo(this.total_compressed_size, other.total_compressed_size)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetOrdinal()).compareTo(other.isSetOrdinal());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOrdinal() && (lastComparison = TBaseHelper.compareTo(this.ordinal, other.ordinal)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        RowGroup.scheme(iprot).read(iprot, (RowGroup)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        RowGroup.scheme(oprot).write(oprot, (RowGroup)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RowGroup(");
        boolean first = true;
        sb.append("columns:");
        if (this.columns == null) {
            sb.append("null");
        } else {
            sb.append(this.columns);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("total_byte_size:");
        sb.append(this.total_byte_size);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("num_rows:");
        sb.append(this.num_rows);
        first = false;
        if (this.isSetSortingColumns()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("sorting_columns:");
            if (this.sorting_columns == null) {
                sb.append("null");
            } else {
                sb.append(this.sorting_columns);
            }
            first = false;
        }
        if (this.isSetFileOffset()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("file_offset:");
            sb.append(this.file_offset);
            first = false;
        }
        if (this.isSetTotalCompressedSize()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("total_compressed_size:");
            sb.append(this.total_compressed_size);
            first = false;
        }
        if (this.isSetOrdinal()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("ordinal:");
            sb.append(this.ordinal);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.columns == null) {
            throw new TProtocolException("Required field 'columns' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.COLUMNS, new FieldMetaData("columns", 1, new ListMetaData(15, new StructMetaData(12, ColumnChunk.class))));
        tmpMap.put(_Fields.TOTAL_BYTE_SIZE, new FieldMetaData("total_byte_size", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.NUM_ROWS, new FieldMetaData("num_rows", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.SORTING_COLUMNS, new FieldMetaData("sorting_columns", 2, new ListMetaData(15, new StructMetaData(12, SortingColumn.class))));
        tmpMap.put(_Fields.FILE_OFFSET, new FieldMetaData("file_offset", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.TOTAL_COMPRESSED_SIZE, new FieldMetaData("total_compressed_size", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.ORDINAL, new FieldMetaData("ordinal", 2, new FieldValueMetaData(6)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(RowGroup.class, metaDataMap);
    }

    private static class RowGroupTupleScheme
    extends TupleScheme<RowGroup> {
        private RowGroupTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, RowGroup struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.columns.size());
            for (ColumnChunk _iter48 : struct.columns) {
                _iter48.write(oprot);
            }
            oprot.writeI64(struct.total_byte_size);
            oprot.writeI64(struct.num_rows);
            BitSet optionals = new BitSet();
            if (struct.isSetSortingColumns()) {
                optionals.set(0);
            }
            if (struct.isSetFileOffset()) {
                optionals.set(1);
            }
            if (struct.isSetTotalCompressedSize()) {
                optionals.set(2);
            }
            if (struct.isSetOrdinal()) {
                optionals.set(3);
            }
            oprot.writeBitSet(optionals, 4);
            if (struct.isSetSortingColumns()) {
                oprot.writeI32(struct.sorting_columns.size());
                for (SortingColumn _iter49 : struct.sorting_columns) {
                    _iter49.write(oprot);
                }
            }
            if (struct.isSetFileOffset()) {
                oprot.writeI64(struct.file_offset);
            }
            if (struct.isSetTotalCompressedSize()) {
                oprot.writeI64(struct.total_compressed_size);
            }
            if (struct.isSetOrdinal()) {
                oprot.writeI16(struct.ordinal);
            }
        }

        @Override
        public void read(TProtocol prot, RowGroup struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            TList _list50 = new TList(12, iprot.readI32());
            struct.columns = new ArrayList<ColumnChunk>(_list50.size);
            for (int _i52 = 0; _i52 < _list50.size; ++_i52) {
                ColumnChunk _elem51 = new ColumnChunk();
                _elem51.read(iprot);
                struct.columns.add(_elem51);
            }
            struct.setColumnsIsSet(true);
            struct.total_byte_size = iprot.readI64();
            struct.setTotalByteSizeIsSet(true);
            struct.num_rows = iprot.readI64();
            struct.setNumRowsIsSet(true);
            BitSet incoming = iprot.readBitSet(4);
            if (incoming.get(0)) {
                TList _list53 = new TList(12, iprot.readI32());
                struct.sorting_columns = new ArrayList<SortingColumn>(_list53.size);
                for (int _i55 = 0; _i55 < _list53.size; ++_i55) {
                    SortingColumn _elem54 = new SortingColumn();
                    _elem54.read(iprot);
                    struct.sorting_columns.add(_elem54);
                }
                struct.setSortingColumnsIsSet(true);
            }
            if (incoming.get(1)) {
                struct.file_offset = iprot.readI64();
                struct.setFileOffsetIsSet(true);
            }
            if (incoming.get(2)) {
                struct.total_compressed_size = iprot.readI64();
                struct.setTotalCompressedSizeIsSet(true);
            }
            if (incoming.get(3)) {
                struct.ordinal = iprot.readI16();
                struct.setOrdinalIsSet(true);
            }
        }
    }

    private static class RowGroupTupleSchemeFactory
    implements SchemeFactory {
        private RowGroupTupleSchemeFactory() {
        }

        public RowGroupTupleScheme getScheme() {
            return new RowGroupTupleScheme();
        }
    }

    private static class RowGroupStandardScheme
    extends StandardScheme<RowGroup> {
        private RowGroupStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, RowGroup struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 15) {
                            TList _list40 = iprot.readListBegin();
                            struct.columns = new ArrayList<ColumnChunk>(_list40.size);
                            for (int _i42 = 0; _i42 < _list40.size; ++_i42) {
                                ColumnChunk _elem41 = new ColumnChunk();
                                _elem41.read(iprot);
                                struct.columns.add(_elem41);
                            }
                            iprot.readListEnd();
                            struct.setColumnsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 10) {
                            struct.total_byte_size = iprot.readI64();
                            struct.setTotalByteSizeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 10) {
                            struct.num_rows = iprot.readI64();
                            struct.setNumRowsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 15) {
                            TList _list43 = iprot.readListBegin();
                            struct.sorting_columns = new ArrayList<SortingColumn>(_list43.size);
                            for (int _i45 = 0; _i45 < _list43.size; ++_i45) {
                                SortingColumn _elem44 = new SortingColumn();
                                _elem44.read(iprot);
                                struct.sorting_columns.add(_elem44);
                            }
                            iprot.readListEnd();
                            struct.setSortingColumnsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 10) {
                            struct.file_offset = iprot.readI64();
                            struct.setFileOffsetIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 10) {
                            struct.total_compressed_size = iprot.readI64();
                            struct.setTotalCompressedSizeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 6) {
                            struct.ordinal = iprot.readI16();
                            struct.setOrdinalIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetTotalByteSize()) {
                throw new TProtocolException("Required field 'total_byte_size' was not found in serialized data! Struct: " + this.toString());
            }
            if (!struct.isSetNumRows()) {
                throw new TProtocolException("Required field 'num_rows' was not found in serialized data! Struct: " + this.toString());
            }
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, RowGroup struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.columns != null) {
                oprot.writeFieldBegin(COLUMNS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.columns.size()));
                for (ColumnChunk _iter46 : struct.columns) {
                    _iter46.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(TOTAL_BYTE_SIZE_FIELD_DESC);
            oprot.writeI64(struct.total_byte_size);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(NUM_ROWS_FIELD_DESC);
            oprot.writeI64(struct.num_rows);
            oprot.writeFieldEnd();
            if (struct.sorting_columns != null && struct.isSetSortingColumns()) {
                oprot.writeFieldBegin(SORTING_COLUMNS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.sorting_columns.size()));
                for (SortingColumn _iter47 : struct.sorting_columns) {
                    _iter47.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.isSetFileOffset()) {
                oprot.writeFieldBegin(FILE_OFFSET_FIELD_DESC);
                oprot.writeI64(struct.file_offset);
                oprot.writeFieldEnd();
            }
            if (struct.isSetTotalCompressedSize()) {
                oprot.writeFieldBegin(TOTAL_COMPRESSED_SIZE_FIELD_DESC);
                oprot.writeI64(struct.total_compressed_size);
                oprot.writeFieldEnd();
            }
            if (struct.isSetOrdinal()) {
                oprot.writeFieldBegin(ORDINAL_FIELD_DESC);
                oprot.writeI16(struct.ordinal);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class RowGroupStandardSchemeFactory
    implements SchemeFactory {
        private RowGroupStandardSchemeFactory() {
        }

        public RowGroupStandardScheme getScheme() {
            return new RowGroupStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        COLUMNS(1, "columns"),
        TOTAL_BYTE_SIZE(2, "total_byte_size"),
        NUM_ROWS(3, "num_rows"),
        SORTING_COLUMNS(4, "sorting_columns"),
        FILE_OFFSET(5, "file_offset"),
        TOTAL_COMPRESSED_SIZE(6, "total_compressed_size"),
        ORDINAL(7, "ordinal");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return COLUMNS;
                }
                case 2: {
                    return TOTAL_BYTE_SIZE;
                }
                case 3: {
                    return NUM_ROWS;
                }
                case 4: {
                    return SORTING_COLUMNS;
                }
                case 5: {
                    return FILE_OFFSET;
                }
                case 6: {
                    return TOTAL_COMPRESSED_SIZE;
                }
                case 7: {
                    return ORDINAL;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

