/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.format;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.parquet.format.ColumnOrder;
import org.apache.parquet.format.EncryptionAlgorithm;
import org.apache.parquet.format.KeyValue;
import org.apache.parquet.format.RowGroup;
import org.apache.parquet.format.SchemaElement;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;

public class FileMetaData
implements TBase<FileMetaData, _Fields>,
Serializable,
Cloneable,
Comparable<FileMetaData> {
    private static final TStruct STRUCT_DESC = new TStruct("FileMetaData");
    private static final TField VERSION_FIELD_DESC = new TField("version", 8, 1);
    private static final TField SCHEMA_FIELD_DESC = new TField("schema", 15, 2);
    private static final TField NUM_ROWS_FIELD_DESC = new TField("num_rows", 10, 3);
    private static final TField ROW_GROUPS_FIELD_DESC = new TField("row_groups", 15, 4);
    private static final TField KEY_VALUE_METADATA_FIELD_DESC = new TField("key_value_metadata", 15, 5);
    private static final TField CREATED_BY_FIELD_DESC = new TField("created_by", 11, 6);
    private static final TField COLUMN_ORDERS_FIELD_DESC = new TField("column_orders", 15, 7);
    private static final TField ENCRYPTION_ALGORITHM_FIELD_DESC = new TField("encryption_algorithm", 12, 8);
    private static final TField FOOTER_SIGNING_KEY_METADATA_FIELD_DESC = new TField("footer_signing_key_metadata", 11, 9);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new FileMetaDataStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new FileMetaDataTupleSchemeFactory();
    public int version;
    @Nullable
    public List<SchemaElement> schema;
    public long num_rows;
    @Nullable
    public List<RowGroup> row_groups;
    @Nullable
    public List<KeyValue> key_value_metadata;
    @Nullable
    public String created_by;
    @Nullable
    public List<ColumnOrder> column_orders;
    @Nullable
    public EncryptionAlgorithm encryption_algorithm;
    @Nullable
    public ByteBuffer footer_signing_key_metadata;
    private static final int __VERSION_ISSET_ID = 0;
    private static final int __NUM_ROWS_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.KEY_VALUE_METADATA, _Fields.CREATED_BY, _Fields.COLUMN_ORDERS, _Fields.ENCRYPTION_ALGORITHM, _Fields.FOOTER_SIGNING_KEY_METADATA};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public FileMetaData() {
    }

    public FileMetaData(int version, List<SchemaElement> schema, long num_rows, List<RowGroup> row_groups) {
        this();
        this.version = version;
        this.setVersionIsSet(true);
        this.schema = schema;
        this.num_rows = num_rows;
        this.setNumRowsIsSet(true);
        this.row_groups = row_groups;
    }

    public FileMetaData(FileMetaData other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.version = other.version;
        if (other.isSetSchema()) {
            ArrayList<SchemaElement> __this__schema = new ArrayList<SchemaElement>(other.schema.size());
            for (SchemaElement schemaElement : other.schema) {
                __this__schema.add(new SchemaElement(schemaElement));
            }
            this.schema = __this__schema;
        }
        this.num_rows = other.num_rows;
        if (other.isSetRowGroups()) {
            ArrayList<RowGroup> __this__row_groups = new ArrayList<RowGroup>(other.row_groups.size());
            for (RowGroup rowGroup : other.row_groups) {
                __this__row_groups.add(new RowGroup(rowGroup));
            }
            this.row_groups = __this__row_groups;
        }
        if (other.isSetKeyValueMetadata()) {
            ArrayList<KeyValue> __this__key_value_metadata = new ArrayList<KeyValue>(other.key_value_metadata.size());
            for (KeyValue keyValue : other.key_value_metadata) {
                __this__key_value_metadata.add(new KeyValue(keyValue));
            }
            this.key_value_metadata = __this__key_value_metadata;
        }
        if (other.isSetCreatedBy()) {
            this.created_by = other.created_by;
        }
        if (other.isSetColumnOrders()) {
            ArrayList<ColumnOrder> __this__column_orders = new ArrayList<ColumnOrder>(other.column_orders.size());
            for (ColumnOrder columnOrder : other.column_orders) {
                __this__column_orders.add(new ColumnOrder(columnOrder));
            }
            this.column_orders = __this__column_orders;
        }
        if (other.isSetEncryptionAlgorithm()) {
            this.encryption_algorithm = new EncryptionAlgorithm(other.encryption_algorithm);
        }
        if (other.isSetFooterSigningKeyMetadata()) {
            this.footer_signing_key_metadata = TBaseHelper.copyBinary(other.footer_signing_key_metadata);
        }
    }

    @Override
    public FileMetaData deepCopy() {
        return new FileMetaData(this);
    }

    @Override
    public void clear() {
        this.setVersionIsSet(false);
        this.version = 0;
        this.schema = null;
        this.setNumRowsIsSet(false);
        this.num_rows = 0L;
        this.row_groups = null;
        this.key_value_metadata = null;
        this.created_by = null;
        this.column_orders = null;
        this.encryption_algorithm = null;
        this.footer_signing_key_metadata = null;
    }

    public int getVersion() {
        return this.version;
    }

    public FileMetaData setVersion(int version) {
        this.version = version;
        this.setVersionIsSet(true);
        return this;
    }

    public void unsetVersion() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 0);
    }

    public boolean isSetVersion() {
        return EncodingUtils.testBit(this.__isset_bitfield, 0);
    }

    public void setVersionIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 0, value);
    }

    public int getSchemaSize() {
        return this.schema == null ? 0 : this.schema.size();
    }

    @Nullable
    public Iterator<SchemaElement> getSchemaIterator() {
        return this.schema == null ? null : this.schema.iterator();
    }

    public void addToSchema(SchemaElement elem) {
        if (this.schema == null) {
            this.schema = new ArrayList<SchemaElement>();
        }
        this.schema.add(elem);
    }

    @Nullable
    public List<SchemaElement> getSchema() {
        return this.schema;
    }

    public FileMetaData setSchema(@Nullable List<SchemaElement> schema) {
        this.schema = schema;
        return this;
    }

    public void unsetSchema() {
        this.schema = null;
    }

    public boolean isSetSchema() {
        return this.schema != null;
    }

    public void setSchemaIsSet(boolean value) {
        if (!value) {
            this.schema = null;
        }
    }

    public long getNumRows() {
        return this.num_rows;
    }

    public FileMetaData setNumRows(long num_rows) {
        this.num_rows = num_rows;
        this.setNumRowsIsSet(true);
        return this;
    }

    public void unsetNumRows() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 1);
    }

    public boolean isSetNumRows() {
        return EncodingUtils.testBit(this.__isset_bitfield, 1);
    }

    public void setNumRowsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 1, value);
    }

    public int getRowGroupsSize() {
        return this.row_groups == null ? 0 : this.row_groups.size();
    }

    @Nullable
    public Iterator<RowGroup> getRowGroupsIterator() {
        return this.row_groups == null ? null : this.row_groups.iterator();
    }

    public void addToRowGroups(RowGroup elem) {
        if (this.row_groups == null) {
            this.row_groups = new ArrayList<RowGroup>();
        }
        this.row_groups.add(elem);
    }

    @Nullable
    public List<RowGroup> getRowGroups() {
        return this.row_groups;
    }

    public FileMetaData setRowGroups(@Nullable List<RowGroup> row_groups) {
        this.row_groups = row_groups;
        return this;
    }

    public void unsetRowGroups() {
        this.row_groups = null;
    }

    public boolean isSetRowGroups() {
        return this.row_groups != null;
    }

    public void setRowGroupsIsSet(boolean value) {
        if (!value) {
            this.row_groups = null;
        }
    }

    public int getKeyValueMetadataSize() {
        return this.key_value_metadata == null ? 0 : this.key_value_metadata.size();
    }

    @Nullable
    public Iterator<KeyValue> getKeyValueMetadataIterator() {
        return this.key_value_metadata == null ? null : this.key_value_metadata.iterator();
    }

    public void addToKeyValueMetadata(KeyValue elem) {
        if (this.key_value_metadata == null) {
            this.key_value_metadata = new ArrayList<KeyValue>();
        }
        this.key_value_metadata.add(elem);
    }

    @Nullable
    public List<KeyValue> getKeyValueMetadata() {
        return this.key_value_metadata;
    }

    public FileMetaData setKeyValueMetadata(@Nullable List<KeyValue> key_value_metadata) {
        this.key_value_metadata = key_value_metadata;
        return this;
    }

    public void unsetKeyValueMetadata() {
        this.key_value_metadata = null;
    }

    public boolean isSetKeyValueMetadata() {
        return this.key_value_metadata != null;
    }

    public void setKeyValueMetadataIsSet(boolean value) {
        if (!value) {
            this.key_value_metadata = null;
        }
    }

    @Nullable
    public String getCreatedBy() {
        return this.created_by;
    }

    public FileMetaData setCreatedBy(@Nullable String created_by) {
        this.created_by = created_by;
        return this;
    }

    public void unsetCreatedBy() {
        this.created_by = null;
    }

    public boolean isSetCreatedBy() {
        return this.created_by != null;
    }

    public void setCreatedByIsSet(boolean value) {
        if (!value) {
            this.created_by = null;
        }
    }

    public int getColumnOrdersSize() {
        return this.column_orders == null ? 0 : this.column_orders.size();
    }

    @Nullable
    public Iterator<ColumnOrder> getColumnOrdersIterator() {
        return this.column_orders == null ? null : this.column_orders.iterator();
    }

    public void addToColumnOrders(ColumnOrder elem) {
        if (this.column_orders == null) {
            this.column_orders = new ArrayList<ColumnOrder>();
        }
        this.column_orders.add(elem);
    }

    @Nullable
    public List<ColumnOrder> getColumnOrders() {
        return this.column_orders;
    }

    public FileMetaData setColumnOrders(@Nullable List<ColumnOrder> column_orders) {
        this.column_orders = column_orders;
        return this;
    }

    public void unsetColumnOrders() {
        this.column_orders = null;
    }

    public boolean isSetColumnOrders() {
        return this.column_orders != null;
    }

    public void setColumnOrdersIsSet(boolean value) {
        if (!value) {
            this.column_orders = null;
        }
    }

    @Nullable
    public EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryption_algorithm;
    }

    public FileMetaData setEncryptionAlgorithm(@Nullable EncryptionAlgorithm encryption_algorithm) {
        this.encryption_algorithm = encryption_algorithm;
        return this;
    }

    public void unsetEncryptionAlgorithm() {
        this.encryption_algorithm = null;
    }

    public boolean isSetEncryptionAlgorithm() {
        return this.encryption_algorithm != null;
    }

    public void setEncryptionAlgorithmIsSet(boolean value) {
        if (!value) {
            this.encryption_algorithm = null;
        }
    }

    public byte[] getFooterSigningKeyMetadata() {
        this.setFooterSigningKeyMetadata(TBaseHelper.rightSize(this.footer_signing_key_metadata));
        return this.footer_signing_key_metadata == null ? null : this.footer_signing_key_metadata.array();
    }

    public ByteBuffer bufferForFooterSigningKeyMetadata() {
        return TBaseHelper.copyBinary(this.footer_signing_key_metadata);
    }

    public FileMetaData setFooterSigningKeyMetadata(byte[] footer_signing_key_metadata) {
        this.footer_signing_key_metadata = footer_signing_key_metadata == null ? (ByteBuffer)null : ByteBuffer.wrap((byte[])footer_signing_key_metadata.clone());
        return this;
    }

    public FileMetaData setFooterSigningKeyMetadata(@Nullable ByteBuffer footer_signing_key_metadata) {
        this.footer_signing_key_metadata = TBaseHelper.copyBinary(footer_signing_key_metadata);
        return this;
    }

    public void unsetFooterSigningKeyMetadata() {
        this.footer_signing_key_metadata = null;
    }

    public boolean isSetFooterSigningKeyMetadata() {
        return this.footer_signing_key_metadata != null;
    }

    public void setFooterSigningKeyMetadataIsSet(boolean value) {
        if (!value) {
            this.footer_signing_key_metadata = null;
        }
    }

    @Override
    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case VERSION: {
                if (value == null) {
                    this.unsetVersion();
                    break;
                }
                this.setVersion((Integer)value);
                break;
            }
            case SCHEMA: {
                if (value == null) {
                    this.unsetSchema();
                    break;
                }
                this.setSchema((List)value);
                break;
            }
            case NUM_ROWS: {
                if (value == null) {
                    this.unsetNumRows();
                    break;
                }
                this.setNumRows((Long)value);
                break;
            }
            case ROW_GROUPS: {
                if (value == null) {
                    this.unsetRowGroups();
                    break;
                }
                this.setRowGroups((List)value);
                break;
            }
            case KEY_VALUE_METADATA: {
                if (value == null) {
                    this.unsetKeyValueMetadata();
                    break;
                }
                this.setKeyValueMetadata((List)value);
                break;
            }
            case CREATED_BY: {
                if (value == null) {
                    this.unsetCreatedBy();
                    break;
                }
                this.setCreatedBy((String)value);
                break;
            }
            case COLUMN_ORDERS: {
                if (value == null) {
                    this.unsetColumnOrders();
                    break;
                }
                this.setColumnOrders((List)value);
                break;
            }
            case ENCRYPTION_ALGORITHM: {
                if (value == null) {
                    this.unsetEncryptionAlgorithm();
                    break;
                }
                this.setEncryptionAlgorithm((EncryptionAlgorithm)value);
                break;
            }
            case FOOTER_SIGNING_KEY_METADATA: {
                if (value == null) {
                    this.unsetFooterSigningKeyMetadata();
                    break;
                }
                if (value instanceof byte[]) {
                    this.setFooterSigningKeyMetadata((byte[])value);
                    break;
                }
                this.setFooterSigningKeyMetadata((ByteBuffer)value);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case VERSION: {
                return this.getVersion();
            }
            case SCHEMA: {
                return this.getSchema();
            }
            case NUM_ROWS: {
                return this.getNumRows();
            }
            case ROW_GROUPS: {
                return this.getRowGroups();
            }
            case KEY_VALUE_METADATA: {
                return this.getKeyValueMetadata();
            }
            case CREATED_BY: {
                return this.getCreatedBy();
            }
            case COLUMN_ORDERS: {
                return this.getColumnOrders();
            }
            case ENCRYPTION_ALGORITHM: {
                return this.getEncryptionAlgorithm();
            }
            case FOOTER_SIGNING_KEY_METADATA: {
                return this.getFooterSigningKeyMetadata();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case VERSION: {
                return this.isSetVersion();
            }
            case SCHEMA: {
                return this.isSetSchema();
            }
            case NUM_ROWS: {
                return this.isSetNumRows();
            }
            case ROW_GROUPS: {
                return this.isSetRowGroups();
            }
            case KEY_VALUE_METADATA: {
                return this.isSetKeyValueMetadata();
            }
            case CREATED_BY: {
                return this.isSetCreatedBy();
            }
            case COLUMN_ORDERS: {
                return this.isSetColumnOrders();
            }
            case ENCRYPTION_ALGORITHM: {
                return this.isSetEncryptionAlgorithm();
            }
            case FOOTER_SIGNING_KEY_METADATA: {
                return this.isSetFooterSigningKeyMetadata();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof FileMetaData) {
            return this.equals((FileMetaData)that);
        }
        return false;
    }

    public boolean equals(FileMetaData that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_version = true;
        boolean that_present_version = true;
        if (this_present_version || that_present_version) {
            if (!this_present_version || !that_present_version) {
                return false;
            }
            if (this.version != that.version) {
                return false;
            }
        }
        boolean this_present_schema = this.isSetSchema();
        boolean that_present_schema = that.isSetSchema();
        if (this_present_schema || that_present_schema) {
            if (!this_present_schema || !that_present_schema) {
                return false;
            }
            if (!this.schema.equals(that.schema)) {
                return false;
            }
        }
        boolean this_present_num_rows = true;
        boolean that_present_num_rows = true;
        if (this_present_num_rows || that_present_num_rows) {
            if (!this_present_num_rows || !that_present_num_rows) {
                return false;
            }
            if (this.num_rows != that.num_rows) {
                return false;
            }
        }
        boolean this_present_row_groups = this.isSetRowGroups();
        boolean that_present_row_groups = that.isSetRowGroups();
        if (this_present_row_groups || that_present_row_groups) {
            if (!this_present_row_groups || !that_present_row_groups) {
                return false;
            }
            if (!this.row_groups.equals(that.row_groups)) {
                return false;
            }
        }
        boolean this_present_key_value_metadata = this.isSetKeyValueMetadata();
        boolean that_present_key_value_metadata = that.isSetKeyValueMetadata();
        if (this_present_key_value_metadata || that_present_key_value_metadata) {
            if (!this_present_key_value_metadata || !that_present_key_value_metadata) {
                return false;
            }
            if (!this.key_value_metadata.equals(that.key_value_metadata)) {
                return false;
            }
        }
        boolean this_present_created_by = this.isSetCreatedBy();
        boolean that_present_created_by = that.isSetCreatedBy();
        if (this_present_created_by || that_present_created_by) {
            if (!this_present_created_by || !that_present_created_by) {
                return false;
            }
            if (!this.created_by.equals(that.created_by)) {
                return false;
            }
        }
        boolean this_present_column_orders = this.isSetColumnOrders();
        boolean that_present_column_orders = that.isSetColumnOrders();
        if (this_present_column_orders || that_present_column_orders) {
            if (!this_present_column_orders || !that_present_column_orders) {
                return false;
            }
            if (!this.column_orders.equals(that.column_orders)) {
                return false;
            }
        }
        boolean this_present_encryption_algorithm = this.isSetEncryptionAlgorithm();
        boolean that_present_encryption_algorithm = that.isSetEncryptionAlgorithm();
        if (this_present_encryption_algorithm || that_present_encryption_algorithm) {
            if (!this_present_encryption_algorithm || !that_present_encryption_algorithm) {
                return false;
            }
            if (!this.encryption_algorithm.equals(that.encryption_algorithm)) {
                return false;
            }
        }
        boolean this_present_footer_signing_key_metadata = this.isSetFooterSigningKeyMetadata();
        boolean that_present_footer_signing_key_metadata = that.isSetFooterSigningKeyMetadata();
        if (this_present_footer_signing_key_metadata || that_present_footer_signing_key_metadata) {
            if (!this_present_footer_signing_key_metadata || !that_present_footer_signing_key_metadata) {
                return false;
            }
            if (!this.footer_signing_key_metadata.equals(that.footer_signing_key_metadata)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + this.version;
        hashCode = hashCode * 8191 + (this.isSetSchema() ? 131071 : 524287);
        if (this.isSetSchema()) {
            hashCode = hashCode * 8191 + this.schema.hashCode();
        }
        hashCode = hashCode * 8191 + TBaseHelper.hashCode(this.num_rows);
        hashCode = hashCode * 8191 + (this.isSetRowGroups() ? 131071 : 524287);
        if (this.isSetRowGroups()) {
            hashCode = hashCode * 8191 + this.row_groups.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetKeyValueMetadata() ? 131071 : 524287);
        if (this.isSetKeyValueMetadata()) {
            hashCode = hashCode * 8191 + this.key_value_metadata.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetCreatedBy() ? 131071 : 524287);
        if (this.isSetCreatedBy()) {
            hashCode = hashCode * 8191 + this.created_by.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetColumnOrders() ? 131071 : 524287);
        if (this.isSetColumnOrders()) {
            hashCode = hashCode * 8191 + this.column_orders.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetEncryptionAlgorithm() ? 131071 : 524287);
        if (this.isSetEncryptionAlgorithm()) {
            hashCode = hashCode * 8191 + this.encryption_algorithm.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetFooterSigningKeyMetadata() ? 131071 : 524287);
        if (this.isSetFooterSigningKeyMetadata()) {
            hashCode = hashCode * 8191 + this.footer_signing_key_metadata.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(FileMetaData other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetVersion()).compareTo(other.isSetVersion());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetVersion() && (lastComparison = TBaseHelper.compareTo(this.version, other.version)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSchema()).compareTo(other.isSetSchema());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSchema() && (lastComparison = TBaseHelper.compareTo(this.schema, other.schema)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetNumRows()).compareTo(other.isSetNumRows());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNumRows() && (lastComparison = TBaseHelper.compareTo(this.num_rows, other.num_rows)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRowGroups()).compareTo(other.isSetRowGroups());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRowGroups() && (lastComparison = TBaseHelper.compareTo(this.row_groups, other.row_groups)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetKeyValueMetadata()).compareTo(other.isSetKeyValueMetadata());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetKeyValueMetadata() && (lastComparison = TBaseHelper.compareTo(this.key_value_metadata, other.key_value_metadata)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCreatedBy()).compareTo(other.isSetCreatedBy());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCreatedBy() && (lastComparison = TBaseHelper.compareTo(this.created_by, other.created_by)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumnOrders()).compareTo(other.isSetColumnOrders());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumnOrders() && (lastComparison = TBaseHelper.compareTo(this.column_orders, other.column_orders)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetEncryptionAlgorithm()).compareTo(other.isSetEncryptionAlgorithm());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEncryptionAlgorithm() && (lastComparison = TBaseHelper.compareTo(this.encryption_algorithm, other.encryption_algorithm)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetFooterSigningKeyMetadata()).compareTo(other.isSetFooterSigningKeyMetadata());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFooterSigningKeyMetadata() && (lastComparison = TBaseHelper.compareTo(this.footer_signing_key_metadata, other.footer_signing_key_metadata)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        FileMetaData.scheme(iprot).read(iprot, (FileMetaData)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        FileMetaData.scheme(oprot).write(oprot, (FileMetaData)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FileMetaData(");
        boolean first = true;
        sb.append("version:");
        sb.append(this.version);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("schema:");
        if (this.schema == null) {
            sb.append("null");
        } else {
            sb.append(this.schema);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("num_rows:");
        sb.append(this.num_rows);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("row_groups:");
        if (this.row_groups == null) {
            sb.append("null");
        } else {
            sb.append(this.row_groups);
        }
        first = false;
        if (this.isSetKeyValueMetadata()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("key_value_metadata:");
            if (this.key_value_metadata == null) {
                sb.append("null");
            } else {
                sb.append(this.key_value_metadata);
            }
            first = false;
        }
        if (this.isSetCreatedBy()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("created_by:");
            if (this.created_by == null) {
                sb.append("null");
            } else {
                sb.append(this.created_by);
            }
            first = false;
        }
        if (this.isSetColumnOrders()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("column_orders:");
            if (this.column_orders == null) {
                sb.append("null");
            } else {
                sb.append(this.column_orders);
            }
            first = false;
        }
        if (this.isSetEncryptionAlgorithm()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("encryption_algorithm:");
            if (this.encryption_algorithm == null) {
                sb.append("null");
            } else {
                sb.append(this.encryption_algorithm);
            }
            first = false;
        }
        if (this.isSetFooterSigningKeyMetadata()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("footer_signing_key_metadata:");
            if (this.footer_signing_key_metadata == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString(this.footer_signing_key_metadata, sb);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.schema == null) {
            throw new TProtocolException("Required field 'schema' was not present! Struct: " + this.toString());
        }
        if (this.row_groups == null) {
            throw new TProtocolException("Required field 'row_groups' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.VERSION, new FieldMetaData("version", 1, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.SCHEMA, new FieldMetaData("schema", 1, new ListMetaData(15, new StructMetaData(12, SchemaElement.class))));
        tmpMap.put(_Fields.NUM_ROWS, new FieldMetaData("num_rows", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.ROW_GROUPS, new FieldMetaData("row_groups", 1, new ListMetaData(15, new StructMetaData(12, RowGroup.class))));
        tmpMap.put(_Fields.KEY_VALUE_METADATA, new FieldMetaData("key_value_metadata", 2, new ListMetaData(15, new StructMetaData(12, KeyValue.class))));
        tmpMap.put(_Fields.CREATED_BY, new FieldMetaData("created_by", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.COLUMN_ORDERS, new FieldMetaData("column_orders", 2, new ListMetaData(15, new StructMetaData(12, ColumnOrder.class))));
        tmpMap.put(_Fields.ENCRYPTION_ALGORITHM, new FieldMetaData("encryption_algorithm", 2, new StructMetaData(12, EncryptionAlgorithm.class)));
        tmpMap.put(_Fields.FOOTER_SIGNING_KEY_METADATA, new FieldMetaData("footer_signing_key_metadata", 2, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(FileMetaData.class, metaDataMap);
    }

    private static class FileMetaDataTupleScheme
    extends TupleScheme<FileMetaData> {
        private FileMetaDataTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, FileMetaData struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.version);
            oprot.writeI32(struct.schema.size());
            for (SchemaElement _iter112 : struct.schema) {
                _iter112.write(oprot);
            }
            oprot.writeI64(struct.num_rows);
            oprot.writeI32(struct.row_groups.size());
            for (RowGroup _iter113 : struct.row_groups) {
                _iter113.write(oprot);
            }
            BitSet optionals = new BitSet();
            if (struct.isSetKeyValueMetadata()) {
                optionals.set(0);
            }
            if (struct.isSetCreatedBy()) {
                optionals.set(1);
            }
            if (struct.isSetColumnOrders()) {
                optionals.set(2);
            }
            if (struct.isSetEncryptionAlgorithm()) {
                optionals.set(3);
            }
            if (struct.isSetFooterSigningKeyMetadata()) {
                optionals.set(4);
            }
            oprot.writeBitSet(optionals, 5);
            if (struct.isSetKeyValueMetadata()) {
                oprot.writeI32(struct.key_value_metadata.size());
                for (KeyValue _iter114 : struct.key_value_metadata) {
                    _iter114.write(oprot);
                }
            }
            if (struct.isSetCreatedBy()) {
                oprot.writeString(struct.created_by);
            }
            if (struct.isSetColumnOrders()) {
                oprot.writeI32(struct.column_orders.size());
                for (ColumnOrder _iter115 : struct.column_orders) {
                    _iter115.write(oprot);
                }
            }
            if (struct.isSetEncryptionAlgorithm()) {
                struct.encryption_algorithm.write(oprot);
            }
            if (struct.isSetFooterSigningKeyMetadata()) {
                oprot.writeBinary(struct.footer_signing_key_metadata);
            }
        }

        @Override
        public void read(TProtocol prot, FileMetaData struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.version = iprot.readI32();
            struct.setVersionIsSet(true);
            TList _list116 = new TList(12, iprot.readI32());
            struct.schema = new ArrayList<SchemaElement>(_list116.size);
            for (int _i118 = 0; _i118 < _list116.size; ++_i118) {
                SchemaElement _elem117 = new SchemaElement();
                _elem117.read(iprot);
                struct.schema.add(_elem117);
            }
            struct.setSchemaIsSet(true);
            struct.num_rows = iprot.readI64();
            struct.setNumRowsIsSet(true);
            TList _list119 = new TList(12, iprot.readI32());
            struct.row_groups = new ArrayList<RowGroup>(_list119.size);
            for (int _i121 = 0; _i121 < _list119.size; ++_i121) {
                RowGroup _elem120 = new RowGroup();
                _elem120.read(iprot);
                struct.row_groups.add(_elem120);
            }
            struct.setRowGroupsIsSet(true);
            BitSet incoming = iprot.readBitSet(5);
            if (incoming.get(0)) {
                TList _list122 = new TList(12, iprot.readI32());
                struct.key_value_metadata = new ArrayList<KeyValue>(_list122.size);
                for (int _i124 = 0; _i124 < _list122.size; ++_i124) {
                    KeyValue _elem123 = new KeyValue();
                    _elem123.read(iprot);
                    struct.key_value_metadata.add(_elem123);
                }
                struct.setKeyValueMetadataIsSet(true);
            }
            if (incoming.get(1)) {
                struct.created_by = iprot.readString();
                struct.setCreatedByIsSet(true);
            }
            if (incoming.get(2)) {
                TList _list125 = new TList(12, iprot.readI32());
                struct.column_orders = new ArrayList<ColumnOrder>(_list125.size);
                for (int _i127 = 0; _i127 < _list125.size; ++_i127) {
                    ColumnOrder _elem126 = new ColumnOrder();
                    _elem126.read(iprot);
                    struct.column_orders.add(_elem126);
                }
                struct.setColumnOrdersIsSet(true);
            }
            if (incoming.get(3)) {
                struct.encryption_algorithm = new EncryptionAlgorithm();
                struct.encryption_algorithm.read(iprot);
                struct.setEncryptionAlgorithmIsSet(true);
            }
            if (incoming.get(4)) {
                struct.footer_signing_key_metadata = iprot.readBinary();
                struct.setFooterSigningKeyMetadataIsSet(true);
            }
        }
    }

    private static class FileMetaDataTupleSchemeFactory
    implements SchemeFactory {
        private FileMetaDataTupleSchemeFactory() {
        }

        public FileMetaDataTupleScheme getScheme() {
            return new FileMetaDataTupleScheme();
        }
    }

    private static class FileMetaDataStandardScheme
    extends StandardScheme<FileMetaData> {
        private FileMetaDataStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, FileMetaData struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 8) {
                            struct.version = iprot.readI32();
                            struct.setVersionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 15) {
                            TList _list96 = iprot.readListBegin();
                            struct.schema = new ArrayList<SchemaElement>(_list96.size);
                            for (int _i98 = 0; _i98 < _list96.size; ++_i98) {
                                SchemaElement _elem97 = new SchemaElement();
                                _elem97.read(iprot);
                                struct.schema.add(_elem97);
                            }
                            iprot.readListEnd();
                            struct.setSchemaIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 10) {
                            struct.num_rows = iprot.readI64();
                            struct.setNumRowsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 15) {
                            TList _list99 = iprot.readListBegin();
                            struct.row_groups = new ArrayList<RowGroup>(_list99.size);
                            for (int _i101 = 0; _i101 < _list99.size; ++_i101) {
                                RowGroup _elem100 = new RowGroup();
                                _elem100.read(iprot);
                                struct.row_groups.add(_elem100);
                            }
                            iprot.readListEnd();
                            struct.setRowGroupsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 15) {
                            TList _list102 = iprot.readListBegin();
                            struct.key_value_metadata = new ArrayList<KeyValue>(_list102.size);
                            for (int _i104 = 0; _i104 < _list102.size; ++_i104) {
                                KeyValue _elem103 = new KeyValue();
                                _elem103.read(iprot);
                                struct.key_value_metadata.add(_elem103);
                            }
                            iprot.readListEnd();
                            struct.setKeyValueMetadataIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 11) {
                            struct.created_by = iprot.readString();
                            struct.setCreatedByIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 15) {
                            TList _list105 = iprot.readListBegin();
                            struct.column_orders = new ArrayList<ColumnOrder>(_list105.size);
                            for (int _i107 = 0; _i107 < _list105.size; ++_i107) {
                                ColumnOrder _elem106 = new ColumnOrder();
                                _elem106.read(iprot);
                                struct.column_orders.add(_elem106);
                            }
                            iprot.readListEnd();
                            struct.setColumnOrdersIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 12) {
                            struct.encryption_algorithm = new EncryptionAlgorithm();
                            struct.encryption_algorithm.read(iprot);
                            struct.setEncryptionAlgorithmIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 11) {
                            struct.footer_signing_key_metadata = iprot.readBinary();
                            struct.setFooterSigningKeyMetadataIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetVersion()) {
                throw new TProtocolException("Required field 'version' was not found in serialized data! Struct: " + this.toString());
            }
            if (!struct.isSetNumRows()) {
                throw new TProtocolException("Required field 'num_rows' was not found in serialized data! Struct: " + this.toString());
            }
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, FileMetaData struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(VERSION_FIELD_DESC);
            oprot.writeI32(struct.version);
            oprot.writeFieldEnd();
            if (struct.schema != null) {
                oprot.writeFieldBegin(SCHEMA_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.schema.size()));
                for (SchemaElement _iter108 : struct.schema) {
                    _iter108.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(NUM_ROWS_FIELD_DESC);
            oprot.writeI64(struct.num_rows);
            oprot.writeFieldEnd();
            if (struct.row_groups != null) {
                oprot.writeFieldBegin(ROW_GROUPS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.row_groups.size()));
                for (RowGroup _iter109 : struct.row_groups) {
                    _iter109.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.key_value_metadata != null && struct.isSetKeyValueMetadata()) {
                oprot.writeFieldBegin(KEY_VALUE_METADATA_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.key_value_metadata.size()));
                for (KeyValue _iter110 : struct.key_value_metadata) {
                    _iter110.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.created_by != null && struct.isSetCreatedBy()) {
                oprot.writeFieldBegin(CREATED_BY_FIELD_DESC);
                oprot.writeString(struct.created_by);
                oprot.writeFieldEnd();
            }
            if (struct.column_orders != null && struct.isSetColumnOrders()) {
                oprot.writeFieldBegin(COLUMN_ORDERS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.column_orders.size()));
                for (ColumnOrder _iter111 : struct.column_orders) {
                    _iter111.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.encryption_algorithm != null && struct.isSetEncryptionAlgorithm()) {
                oprot.writeFieldBegin(ENCRYPTION_ALGORITHM_FIELD_DESC);
                struct.encryption_algorithm.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.footer_signing_key_metadata != null && struct.isSetFooterSigningKeyMetadata()) {
                oprot.writeFieldBegin(FOOTER_SIGNING_KEY_METADATA_FIELD_DESC);
                oprot.writeBinary(struct.footer_signing_key_metadata);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class FileMetaDataStandardSchemeFactory
    implements SchemeFactory {
        private FileMetaDataStandardSchemeFactory() {
        }

        public FileMetaDataStandardScheme getScheme() {
            return new FileMetaDataStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        VERSION(1, "version"),
        SCHEMA(2, "schema"),
        NUM_ROWS(3, "num_rows"),
        ROW_GROUPS(4, "row_groups"),
        KEY_VALUE_METADATA(5, "key_value_metadata"),
        CREATED_BY(6, "created_by"),
        COLUMN_ORDERS(7, "column_orders"),
        ENCRYPTION_ALGORITHM(8, "encryption_algorithm"),
        FOOTER_SIGNING_KEY_METADATA(9, "footer_signing_key_metadata");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return VERSION;
                }
                case 2: {
                    return SCHEMA;
                }
                case 3: {
                    return NUM_ROWS;
                }
                case 4: {
                    return ROW_GROUPS;
                }
                case 5: {
                    return KEY_VALUE_METADATA;
                }
                case 6: {
                    return CREATED_BY;
                }
                case 7: {
                    return COLUMN_ORDERS;
                }
                case 8: {
                    return ENCRYPTION_ALGORITHM;
                }
                case 9: {
                    return FOOTER_SIGNING_KEY_METADATA;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

