/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.resource;

import com.google.common.annotations.VisibleForTesting;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.protocolrecords.ResourceTypes;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.ResourceTypeInfo;
import org.apache.hadoop.yarn.conf.ConfigurationProvider;
import org.apache.hadoop.yarn.conf.ConfigurationProviderFactory;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;

public class ResourceUtils {
    public static final String UNITS = ".units";
    public static final String TYPE = ".type";
    public static final String MINIMUM_ALLOCATION = ".minimum-allocation";
    public static final String MAXIMUM_ALLOCATION = ".maximum-allocation";
    private static final String MEMORY = ResourceInformation.MEMORY_MB.getName();
    private static final String VCORES = ResourceInformation.VCORES.getName();
    private static final Pattern RESOURCE_REQUEST_VALUE_PATTERN = Pattern.compile("^([0-9]+) ?([a-zA-Z]*)$");
    public static final String YARN_IO_OPTIONAL = "(yarn\\.io/)?";
    private static volatile boolean initializedResources = false;
    private static final Map<String, Integer> RESOURCE_NAME_TO_INDEX = new ConcurrentHashMap<String, Integer>();
    private static volatile Map<String, ResourceInformation> resourceTypes;
    private static volatile ResourceInformation[] resourceTypesArray;
    private static volatile boolean initializedNodeResources;
    private static volatile Map<String, ResourceInformation> readOnlyNodeResources;
    private static volatile int numKnownResourceTypes;
    static final Log LOG;

    private ResourceUtils() {
    }

    private static void checkMandatoryResources(Map<String, ResourceInformation> resourceInformationMap) throws YarnRuntimeException {
        String key = "memory";
        if (resourceInformationMap.containsKey(key)) {
            LOG.warn("Attempt to define resource '" + key + "', but it is not allowed.");
            throw new YarnRuntimeException("Attempt to re-define mandatory resource '" + key + "'.");
        }
        for (Map.Entry<String, ResourceInformation> mandatoryResourceEntry : ResourceInformation.MANDATORY_RESOURCES.entrySet()) {
            key = mandatoryResourceEntry.getKey();
            ResourceInformation mandatoryRI = mandatoryResourceEntry.getValue();
            ResourceInformation newDefinedRI = resourceInformationMap.get(key);
            if (newDefinedRI == null) continue;
            String expectedUnit = mandatoryRI.getUnits();
            ResourceTypes expectedType = mandatoryRI.getResourceType();
            String actualUnit = newDefinedRI.getUnits();
            ResourceTypes actualType = newDefinedRI.getResourceType();
            if (expectedUnit.equals(actualUnit) && expectedType.equals((Object)actualType)) continue;
            throw new YarnRuntimeException("Defined mandatory resource type=" + key + " inside resource-types.xml, however its type or " + "unit is conflict to mandatory resource types, expected type=" + (Object)((Object)expectedType) + ", unit=" + expectedUnit + "; actual type=" + (Object)((Object)actualType) + " actual unit=" + actualUnit);
        }
    }

    private static void addMandatoryResources(Map<String, ResourceInformation> res) {
        ResourceInformation ri;
        if (!res.containsKey(MEMORY)) {
            LOG.info("Adding resource type - name = " + MEMORY + ", units = " + ResourceInformation.MEMORY_MB.getUnits() + ", type = " + (Object)((Object)ResourceTypes.COUNTABLE));
            ri = ResourceInformation.newInstance(MEMORY, ResourceInformation.MEMORY_MB.getUnits());
            res.put(MEMORY, ri);
        }
        if (!res.containsKey(VCORES)) {
            LOG.info("Adding resource type - name = " + VCORES + ", units = , type = " + (Object)((Object)ResourceTypes.COUNTABLE));
            ri = ResourceInformation.newInstance(VCORES);
            res.put(VCORES, ri);
        }
    }

    private static void setMinimumAllocationForMandatoryResources(Map<String, ResourceInformation> res, Configuration conf) {
        String[][] resourceTypesKeys;
        for (String[] arr : resourceTypesKeys = new String[][]{{ResourceInformation.MEMORY_MB.getName(), "yarn.scheduler.minimum-allocation-mb", String.valueOf(1024), ResourceInformation.MEMORY_MB.getName()}, {ResourceInformation.VCORES.getName(), "yarn.scheduler.minimum-allocation-vcores", String.valueOf(1), ResourceInformation.VCORES.getName()}}) {
            long minimum;
            String resourceTypesKey = "yarn.resource-types." + arr[0] + MINIMUM_ALLOCATION;
            long minimumResourceTypes = conf.getLong(resourceTypesKey, -1L);
            long minimumConf = conf.getLong(arr[1], -1L);
            if (minimumResourceTypes != -1L) {
                minimum = minimumResourceTypes;
                if (minimumConf != -1L) {
                    LOG.warn("Using minimum allocation for memory specified in resource-types config file with key " + minimumResourceTypes + ", ignoring minimum specified using " + arr[1]);
                }
            } else {
                minimum = conf.getLong(arr[1], Long.parseLong(arr[2]));
            }
            ResourceInformation ri = res.get(arr[3]);
            ri.setMinimumAllocation(minimum);
        }
    }

    private static void setMaximumAllocationForMandatoryResources(Map<String, ResourceInformation> res, Configuration conf) {
        String[][] resourceTypesKeys;
        for (String[] arr : resourceTypesKeys = new String[][]{{ResourceInformation.MEMORY_MB.getName(), "yarn.scheduler.maximum-allocation-mb", String.valueOf(8192), ResourceInformation.MEMORY_MB.getName()}, {ResourceInformation.VCORES.getName(), "yarn.scheduler.maximum-allocation-vcores", String.valueOf(4), ResourceInformation.VCORES.getName()}}) {
            long maximum;
            String resourceTypesKey = "yarn.resource-types." + arr[0] + MAXIMUM_ALLOCATION;
            long maximumResourceTypes = conf.getLong(resourceTypesKey, -1L);
            long maximumConf = conf.getLong(arr[1], -1L);
            if (maximumResourceTypes != -1L) {
                maximum = maximumResourceTypes;
                if (maximumConf != -1L) {
                    LOG.warn("Using maximum allocation for memory specified in resource-types config file with key " + maximumResourceTypes + ", ignoring maximum specified using " + arr[1]);
                }
            } else {
                maximum = conf.getLong(arr[1], Long.parseLong(arr[2]));
            }
            ResourceInformation ri = res.get(arr[3]);
            ri.setMaximumAllocation(maximum);
        }
    }

    public static Resource fetchMaximumAllocationFromConfig(Configuration conf) {
        Map<String, ResourceInformation> resourceInformationMap = ResourceUtils.getResourceInformationMapFromConfig(conf);
        Resource ret = Resource.newInstance(0, 0);
        for (ResourceInformation entry : resourceInformationMap.values()) {
            ret.setResourceValue(entry.getName(), entry.getMaximumAllocation());
        }
        return ret;
    }

    private static Map<String, ResourceInformation> getResourceInformationMapFromConfig(Configuration conf) {
        HashMap<String, ResourceInformation> resourceInformationMap = new HashMap<String, ResourceInformation>();
        String[] resourceNames = conf.getStrings("yarn.resource-types");
        if (resourceNames != null && resourceNames.length != 0) {
            for (String resourceName : resourceNames) {
                String resourceUnits = conf.get("yarn.resource-types." + resourceName + UNITS, "");
                String resourceTypeName = conf.get("yarn.resource-types." + resourceName + TYPE, ResourceTypes.COUNTABLE.toString());
                Long minimumAllocation = conf.getLong("yarn.resource-types." + resourceName + MINIMUM_ALLOCATION, 0L);
                Long maximumAllocation = conf.getLong("yarn.resource-types." + resourceName + MAXIMUM_ALLOCATION, Long.MAX_VALUE);
                if (resourceName == null || resourceName.isEmpty() || resourceUnits == null || resourceTypeName == null) {
                    throw new YarnRuntimeException("Incomplete configuration for resource type '" + resourceName + "'. One of name, units or type is configured incorrectly.");
                }
                ResourceTypes resourceType = ResourceTypes.valueOf(resourceTypeName);
                LOG.info("Adding resource type - name = " + resourceName + ", units = " + resourceUnits + ", type = " + resourceTypeName);
                if (resourceInformationMap.containsKey(resourceName)) {
                    throw new YarnRuntimeException("Error in config, key '" + resourceName + "' specified twice");
                }
                resourceInformationMap.put(resourceName, ResourceInformation.newInstance(resourceName, resourceUnits, 0L, resourceType, minimumAllocation, maximumAllocation));
            }
        }
        ResourceUtils.checkMandatoryResources(resourceInformationMap);
        ResourceUtils.addMandatoryResources(resourceInformationMap);
        ResourceUtils.setMinimumAllocationForMandatoryResources(resourceInformationMap, conf);
        ResourceUtils.setMaximumAllocationForMandatoryResources(resourceInformationMap, conf);
        return resourceInformationMap;
    }

    @VisibleForTesting
    static void initializeResourcesMap(Configuration conf) {
        Map<String, ResourceInformation> resourceInformationMap = ResourceUtils.getResourceInformationMapFromConfig(conf);
        ResourceUtils.initializeResourcesFromResourceInformationMap(resourceInformationMap);
    }

    @VisibleForTesting
    public static void initializeResourcesFromResourceInformationMap(Map<String, ResourceInformation> resourceInformationMap) {
        resourceTypes = Collections.unmodifiableMap(resourceInformationMap);
        ResourceUtils.updateKnownResources();
        ResourceUtils.updateResourceTypeIndex();
        initializedResources = true;
        numKnownResourceTypes = resourceTypes.size();
    }

    private static void updateKnownResources() {
        resourceTypesArray = new ResourceInformation[resourceTypes.size()];
        int index = 2;
        for (ResourceInformation resInfo : resourceTypes.values()) {
            if (resInfo.getName().equals(MEMORY)) {
                ResourceUtils.resourceTypesArray[0] = ResourceInformation.newInstance(resourceTypes.get(MEMORY));
                continue;
            }
            if (resInfo.getName().equals(VCORES)) {
                ResourceUtils.resourceTypesArray[1] = ResourceInformation.newInstance(resourceTypes.get(VCORES));
                continue;
            }
            ResourceUtils.resourceTypesArray[index] = ResourceInformation.newInstance(resInfo);
            ++index;
        }
    }

    private static void updateResourceTypeIndex() {
        RESOURCE_NAME_TO_INDEX.clear();
        for (int index = 0; index < resourceTypesArray.length; ++index) {
            ResourceInformation resInfo = resourceTypesArray[index];
            RESOURCE_NAME_TO_INDEX.put(resInfo.getName(), index);
        }
    }

    public static Map<String, Integer> getResourceTypeIndex() {
        return RESOURCE_NAME_TO_INDEX;
    }

    public static Map<String, ResourceInformation> getResourceTypes() {
        return ResourceUtils.getResourceTypes(null, "resource-types.xml");
    }

    public static ResourceInformation[] getResourceTypesArray() {
        ResourceUtils.initializeResourceTypesIfNeeded();
        return resourceTypesArray;
    }

    public static int getNumberOfKnownResourceTypes() {
        if (numKnownResourceTypes < 0) {
            ResourceUtils.initializeResourceTypesIfNeeded();
        }
        return numKnownResourceTypes;
    }

    private static Map<String, ResourceInformation> getResourceTypes(Configuration conf) {
        return ResourceUtils.getResourceTypes(conf, "resource-types.xml");
    }

    private static void initializeResourceTypesIfNeeded() {
        ResourceUtils.initializeResourceTypesIfNeeded(null, "resource-types.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void initializeResourceTypesIfNeeded(Configuration conf, String resourceFile) {
        if (!initializedResources) {
            Class<ResourceUtils> clazz = ResourceUtils.class;
            // MONITORENTER : org.apache.hadoop.yarn.util.resource.ResourceUtils.class
            if (!initializedResources) {
                Configuration resConf = conf;
                if (resConf == null) {
                    resConf = new YarnConfiguration();
                }
                ResourceUtils.addResourcesFileToConf(resourceFile, resConf);
                ResourceUtils.initializeResourcesMap(resConf);
            }
            // MONITOREXIT : clazz
        }
        numKnownResourceTypes = resourceTypes.size();
    }

    private static Map<String, ResourceInformation> getResourceTypes(Configuration conf, String resourceFile) {
        ResourceUtils.initializeResourceTypesIfNeeded(conf, resourceFile);
        return resourceTypes;
    }

    private static InputStream getConfInputStream(String resourceFile, Configuration conf) throws IOException, YarnException {
        ConfigurationProvider provider = ConfigurationProviderFactory.getConfigurationProvider(conf);
        try {
            provider.init(conf);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        InputStream ris = provider.getConfigurationInputStream(conf, resourceFile);
        if (ris == null) {
            if (conf.getResource(resourceFile) == null) {
                throw new FileNotFoundException("Unable to find " + resourceFile);
            }
            throw new IOException("Unable to open resource types file '" + resourceFile + "'. Using provider " + provider);
        }
        return ris;
    }

    private static void addResourcesFileToConf(String resourceFile, Configuration conf) {
        try {
            InputStream ris = ResourceUtils.getConfInputStream(resourceFile, conf);
            LOG.debug("Found " + resourceFile + ", adding to configuration");
            conf.addResource(ris);
        }
        catch (FileNotFoundException fe) {
            LOG.info("Unable to find '" + resourceFile + "'.");
        }
        catch (IOException | YarnException ex) {
            LOG.fatal("Exception trying to read resource types configuration '" + resourceFile + "'.", ex);
            throw new YarnRuntimeException(ex);
        }
    }

    @VisibleForTesting
    public static synchronized void resetResourceTypes() {
        initializedResources = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static Map<String, ResourceInformation> resetResourceTypes(Configuration conf) {
        Class<ResourceUtils> clazz = ResourceUtils.class;
        synchronized (ResourceUtils.class) {
            initializedResources = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return ResourceUtils.getResourceTypes(conf);
        }
    }

    public static String getUnits(String resourceValue) {
        for (int i = 0; i < resourceValue.length(); ++i) {
            String units;
            if (!Character.isAlphabetic(resourceValue.charAt(i)) || !StringUtils.isAlpha(units = resourceValue.substring(i))) continue;
            return units;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, ResourceInformation> getNodeResourceInformation(Configuration conf) {
        if (initializedNodeResources) return readOnlyNodeResources;
        Class<ResourceUtils> clazz = ResourceUtils.class;
        synchronized (ResourceUtils.class) {
            if (initializedNodeResources) return readOnlyNodeResources;
            Map<String, ResourceInformation> nodeResources = ResourceUtils.initializeNodeResourceInformation(conf);
            ResourceUtils.addMandatoryResources(nodeResources);
            ResourceUtils.checkMandatoryResources(nodeResources);
            ResourceUtils.setMinimumAllocationForMandatoryResources(nodeResources, conf);
            ResourceUtils.setMaximumAllocationForMandatoryResources(nodeResources, conf);
            readOnlyNodeResources = Collections.unmodifiableMap(nodeResources);
            initializedNodeResources = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return readOnlyNodeResources;
        }
    }

    private static Map<String, ResourceInformation> initializeNodeResourceInformation(Configuration conf) {
        HashMap<String, ResourceInformation> nodeResources = new HashMap<String, ResourceInformation>();
        ResourceUtils.addResourcesFileToConf("node-resources.xml", conf);
        for (Map.Entry entry : conf) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            ResourceUtils.addResourceTypeInformation(key, value, nodeResources);
        }
        return nodeResources;
    }

    private static void addResourceTypeInformation(String prop, String value, Map<String, ResourceInformation> nodeResources) {
        if (prop.startsWith("yarn.nodemanager.resource-type.")) {
            LOG.info("Found resource entry " + prop);
            String resourceType = prop.substring("yarn.nodemanager.resource-type.".length());
            if (!nodeResources.containsKey(resourceType)) {
                nodeResources.put(resourceType, ResourceInformation.newInstance(resourceType));
            }
            String units = ResourceUtils.getUnits(value);
            Long resourceValue = Long.valueOf(value.substring(0, value.length() - units.length()));
            nodeResources.get(resourceType).setValue(resourceValue);
            nodeResources.get(resourceType).setUnits(units);
            LOG.debug("Setting value for resource type " + resourceType + " to " + resourceValue + " with units " + units);
        }
    }

    @VisibleForTesting
    public static synchronized void resetNodeResources() {
        initializedNodeResources = false;
    }

    public static Resource getResourceTypesMinimumAllocation() {
        Resource ret = Resource.newInstance(0, 0);
        for (ResourceInformation entry : resourceTypesArray) {
            String name = entry.getName();
            if (name.equals(ResourceInformation.MEMORY_MB.getName())) {
                ret.setMemorySize(entry.getMinimumAllocation());
                continue;
            }
            if (name.equals(ResourceInformation.VCORES.getName())) {
                Long tmp = entry.getMinimumAllocation();
                if (tmp > Integer.MAX_VALUE) {
                    tmp = Integer.MAX_VALUE;
                }
                ret.setVirtualCores(tmp.intValue());
                continue;
            }
            ret.setResourceValue(name, entry.getMinimumAllocation());
        }
        return ret;
    }

    public static Resource getResourceTypesMaximumAllocation() {
        Resource ret = Resource.newInstance(0, 0);
        for (ResourceInformation entry : resourceTypesArray) {
            ret.setResourceValue(entry.getName(), entry.getMaximumAllocation());
        }
        return ret;
    }

    public static String getDefaultUnit(String resourceType) {
        ResourceInformation ri = ResourceUtils.getResourceTypes().get(resourceType);
        if (ri != null) {
            return ri.getUnits();
        }
        return "";
    }

    public static List<ResourceTypeInfo> getResourcesTypeInfo() {
        ArrayList<ResourceTypeInfo> array = new ArrayList<ResourceTypeInfo>();
        Collection<ResourceInformation> resourcesInfo = ResourceUtils.getResourceTypes().values();
        for (ResourceInformation resourceInfo : resourcesInfo) {
            array.add(ResourceTypeInfo.newInstance(resourceInfo.getName(), resourceInfo.getUnits(), resourceInfo.getResourceType()));
        }
        return array;
    }

    public static List<ResourceInformation> getRequestedResourcesFromConfig(Configuration configuration, String prefix) {
        ArrayList<ResourceInformation> result = new ArrayList<ResourceInformation>();
        Map customResourcesMap = configuration.getValByRegex("^" + Pattern.quote(prefix) + YARN_IO_OPTIONAL + "[^.]+$");
        for (Map.Entry resource : customResourcesMap.entrySet()) {
            String resourceName = ((String)resource.getKey()).substring(prefix.length());
            Matcher matcher = RESOURCE_REQUEST_VALUE_PATTERN.matcher((CharSequence)resource.getValue());
            if (!matcher.matches()) {
                String errorMsg = "Invalid resource request specified for property " + (String)resource.getKey() + ": \"" + (String)resource.getValue() + "\", expected format is: value[ ][units]";
                LOG.error(errorMsg);
                throw new IllegalArgumentException(errorMsg);
            }
            long value = Long.parseLong(matcher.group(1));
            String unit = matcher.group(2);
            if (unit.isEmpty()) {
                unit = ResourceUtils.getDefaultUnit(resourceName);
            }
            ResourceInformation resourceInformation = new ResourceInformation();
            resourceInformation.setName(resourceName);
            resourceInformation.setValue(value);
            resourceInformation.setUnits(unit);
            result.add(resourceInformation);
        }
        return result;
    }

    public static ResourceInformation[] createResourceTypesArray(Map<String, Long> res) {
        ResourceUtils.initializeResourceTypesIfNeeded();
        ResourceInformation[] info = new ResourceInformation[resourceTypes.size()];
        for (Map.Entry<String, Integer> entry : RESOURCE_NAME_TO_INDEX.entrySet()) {
            int index = entry.getValue();
            Long value = res.get(entry.getKey());
            if (value == null) {
                value = 0L;
            }
            info[index] = new ResourceInformation();
            ResourceInformation.copy(resourceTypesArray[index], info[index]);
            info[index].setValue(value);
        }
        return info;
    }

    public static void reinitializeResources(List<ResourceTypeInfo> resourceTypeInfo) {
        HashMap<String, ResourceInformation> resourceInformationMap = new HashMap<String, ResourceInformation>();
        for (ResourceTypeInfo resourceType : resourceTypeInfo) {
            resourceInformationMap.put(resourceType.getName(), ResourceInformation.newInstance(resourceType.getName(), resourceType.getDefaultUnit(), resourceType.getResourceType()));
        }
        ResourceUtils.initializeResourcesFromResourceInformationMap(resourceInformationMap);
    }

    static {
        initializedNodeResources = false;
        numKnownResourceTypes = -1;
        LOG = LogFactory.getLog(ResourceUtils.class);
    }
}

