/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.util.VersionInfo;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class YarnVersionInfo
extends VersionInfo {
    private static final Log LOG = LogFactory.getLog(YarnVersionInfo.class);
    private static YarnVersionInfo YARN_VERSION_INFO = new YarnVersionInfo();

    protected YarnVersionInfo() {
        super("yarn");
    }

    public static String getVersion() {
        return YARN_VERSION_INFO._getVersion();
    }

    public static String getRevision() {
        return YARN_VERSION_INFO._getRevision();
    }

    public static String getBranch() {
        return YARN_VERSION_INFO._getBranch();
    }

    public static String getDate() {
        return YARN_VERSION_INFO._getDate();
    }

    public static String getUser() {
        return YARN_VERSION_INFO._getUser();
    }

    public static String getUrl() {
        return YARN_VERSION_INFO._getUrl();
    }

    public static String getSrcChecksum() {
        return YARN_VERSION_INFO._getSrcChecksum();
    }

    public static String getBuildVersion() {
        return YARN_VERSION_INFO._getBuildVersion();
    }

    public static void main(String[] args2) {
        LOG.debug("version: " + YarnVersionInfo.getVersion());
        System.out.println("Yarn " + YarnVersionInfo.getVersion());
        System.out.println("Subversion " + YarnVersionInfo.getUrl() + " -r " + YarnVersionInfo.getRevision());
        System.out.println("Compiled by " + YarnVersionInfo.getUser() + " on " + YarnVersionInfo.getDate());
        System.out.println("From source with checksum " + YarnVersionInfo.getSrcChecksum());
    }
}

