/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.records;

import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class SubClusterPolicyConfiguration {
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static SubClusterPolicyConfiguration newInstance(String queue, String policyType, ByteBuffer policyParams) {
        SubClusterPolicyConfiguration policy = Records.newRecord(SubClusterPolicyConfiguration.class);
        policy.setQueue(queue);
        policy.setType(policyType);
        policy.setParams(policyParams);
        return policy;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static SubClusterPolicyConfiguration newInstance(SubClusterPolicyConfiguration conf) {
        SubClusterPolicyConfiguration policy = Records.newRecord(SubClusterPolicyConfiguration.class);
        policy.setQueue(conf.getQueue());
        policy.setType(conf.getType());
        policy.setParams(conf.getParams());
        return policy;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract String getQueue();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setQueue(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract String getType();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setType(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract ByteBuffer getParams();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setParams(ByteBuffer var1);

    public int hashCode() {
        return 31 * this.getParams().hashCode() + this.getType().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubClusterPolicyConfiguration other = (SubClusterPolicyConfiguration)obj;
        if (!this.getType().equals(other.getType())) {
            return false;
        }
        return this.getParams().equals(other.getParams());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getType());
        sb.append(" : ");
        sb.append(this.getParams());
        return sb.toString();
    }
}

