/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.security;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenSelector;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class AMRMTokenSelector
implements TokenSelector<AMRMTokenIdentifier> {
    private static final Log LOG = LogFactory.getLog(AMRMTokenSelector.class);

    public Token<AMRMTokenIdentifier> selectToken(Text service, Collection<Token<? extends TokenIdentifier>> tokens) {
        if (service == null) {
            return null;
        }
        LOG.debug("Looking for a token with service " + service.toString());
        for (Token<? extends TokenIdentifier> token : tokens) {
            LOG.debug("Token kind is " + token.getKind().toString() + " and the token's service name is " + token.getService());
            if (!AMRMTokenIdentifier.KIND_NAME.equals((Object)token.getKind()) || !this.checkService(service, token)) continue;
            return token;
        }
        return null;
    }

    private boolean checkService(Text service, Token<? extends TokenIdentifier> token) {
        if (service == null || token.getService() == null) {
            return false;
        }
        return token.getService().toString().contains(service.toString());
    }
}

