/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class ApplicationResourceUsageReport {
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static ApplicationResourceUsageReport newInstance(int numUsedContainers, int numReservedContainers, Resource usedResources, Resource reservedResources, Resource neededResources, Map<String, Long> resourceSecondsMap, float queueUsagePerc, float clusterUsagePerc, Map<String, Long> preemtedResourceSecondsMap) {
        ApplicationResourceUsageReport report2 = Records.newRecord(ApplicationResourceUsageReport.class);
        report2.setNumUsedContainers(numUsedContainers);
        report2.setNumReservedContainers(numReservedContainers);
        report2.setUsedResources(usedResources);
        report2.setReservedResources(reservedResources);
        report2.setNeededResources(neededResources);
        report2.setResourceSecondsMap(resourceSecondsMap);
        report2.setQueueUsagePercentage(queueUsagePerc);
        report2.setClusterUsagePercentage(clusterUsagePerc);
        report2.setPreemptedResourceSecondsMap(preemtedResourceSecondsMap);
        return report2;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract int getNumUsedContainers();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setNumUsedContainers(int var1);

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract int getNumReservedContainers();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setNumReservedContainers(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Resource getUsedResources();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setUsedResources(Resource var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Resource getReservedResources();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setReservedResources(Resource var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Resource getNeededResources();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setNeededResources(Resource var1);

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setMemorySeconds(long var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract long getMemorySeconds();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setVcoreSeconds(long var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract long getVcoreSeconds();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract float getQueueUsagePercentage();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setQueueUsagePercentage(float var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract float getClusterUsagePercentage();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setClusterUsagePercentage(float var1);

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setPreemptedMemorySeconds(long var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract long getPreemptedMemorySeconds();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setPreemptedVcoreSeconds(long var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract long getPreemptedVcoreSeconds();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract Map<String, Long> getResourceSecondsMap();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setResourceSecondsMap(Map<String, Long> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract Map<String, Long> getPreemptedResourceSecondsMap();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setPreemptedResourceSecondsMap(Map<String, Long> var1);
}

