/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp.dao;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.hadoop.mapreduce.v2.api.records.TaskAttemptState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskReport;
import org.apache.hadoop.mapreduce.v2.api.records.TaskState;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.job.TaskAttempt;
import org.apache.hadoop.mapreduce.v2.util.MRApps;
import org.apache.hadoop.yarn.util.Times;

@XmlRootElement(name="task")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TaskInfo {
    protected long startTime;
    protected long finishTime;
    protected long elapsedTime;
    protected float progress;
    protected String id;
    protected TaskState state;
    protected String type;
    protected String successfulAttempt;
    protected String status;
    @XmlTransient
    int taskNum;
    @XmlTransient
    TaskAttempt successful;

    public TaskInfo() {
    }

    public TaskInfo(Task task) {
        TaskType ttype = task.getType();
        this.type = ttype.toString();
        TaskReport report2 = task.getReport();
        this.startTime = report2.getStartTime();
        this.finishTime = report2.getFinishTime();
        this.state = report2.getTaskState();
        this.elapsedTime = Times.elapsed(this.startTime, this.finishTime, this.state == TaskState.RUNNING);
        if (this.elapsedTime == -1L) {
            this.elapsedTime = 0L;
        }
        this.progress = report2.getProgress() * 100.0f;
        this.status = report2.getStatus();
        this.id = MRApps.toString(task.getID());
        this.taskNum = task.getID().getId();
        this.successful = this.getSuccessfulAttempt(task);
        this.successfulAttempt = this.successful != null ? MRApps.toString(this.successful.getID()) : "";
    }

    public float getProgress() {
        return this.progress;
    }

    public String getState() {
        return this.state.toString();
    }

    public String getId() {
        return this.id;
    }

    public int getTaskNum() {
        return this.taskNum;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public String getSuccessfulAttempt() {
        return this.successfulAttempt;
    }

    public TaskAttempt getSuccessful() {
        return this.successful;
    }

    private TaskAttempt getSuccessfulAttempt(Task task) {
        for (TaskAttempt attempt : task.getAttempts().values()) {
            if (attempt.getState() != TaskAttemptState.SUCCEEDED) continue;
            return attempt;
        }
        return null;
    }

    public String getStatus() {
        return this.status;
    }
}

