/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.webapp.dao;

import java.util.ArrayList;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.v2.api.records.TaskId;
import org.apache.hadoop.mapreduce.v2.app.AppContext;
import org.apache.hadoop.mapreduce.v2.app.job.Job;
import org.apache.hadoop.mapreduce.v2.app.job.Task;
import org.apache.hadoop.mapreduce.v2.app.webapp.dao.CounterGroupInfo;
import org.apache.hadoop.mapreduce.v2.util.MRApps;

@XmlRootElement(name="jobCounters")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class JobCounterInfo {
    @XmlTransient
    protected Counters total = null;
    @XmlTransient
    protected Counters map = null;
    @XmlTransient
    protected Counters reduce = null;
    protected String id;
    protected ArrayList<CounterGroupInfo> counterGroup;

    public JobCounterInfo() {
    }

    public JobCounterInfo(AppContext ctx, Job job) {
        this.getCounters(ctx, job);
        this.counterGroup = new ArrayList();
        this.id = MRApps.toString(job.getID());
        if (this.total != null) {
            for (CounterGroup g2 : this.total) {
                if (g2 == null) continue;
                CounterGroup mg = this.map == null ? null : (CounterGroup)this.map.getGroup(g2.getName());
                CounterGroup rg = this.reduce == null ? null : (CounterGroup)this.reduce.getGroup(g2.getName());
                CounterGroupInfo cginfo = new CounterGroupInfo(g2.getName(), g2, mg, rg);
                this.counterGroup.add(cginfo);
            }
        }
    }

    private void getCounters(AppContext ctx, Job job) {
        if (job == null) {
            return;
        }
        this.total = job.getAllCounters();
        boolean needTotalCounters = false;
        if (this.total == null) {
            this.total = new Counters();
            needTotalCounters = true;
        }
        this.map = new Counters();
        this.reduce = new Counters();
        Map<TaskId, Task> tasks = job.getTasks();
        for (Task t : tasks.values()) {
            Counters counters = t.getCounters();
            if (counters == null) continue;
            switch (t.getType()) {
                case MAP: {
                    this.map.incrAllCounters(counters);
                    break;
                }
                case REDUCE: {
                    this.reduce.incrAllCounters(counters);
                }
            }
            if (!needTotalCounters) continue;
            this.total.incrAllCounters(counters);
        }
    }
}

