/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.aggregate;

import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregator;
import org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregatorCombiner;
import org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregatorDescriptor;
import org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregatorMapper;
import org.apache.hadoop.mapreduce.lib.aggregate.ValueAggregatorReducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.jobcontrol.ControlledJob;
import org.apache.hadoop.mapreduce.lib.jobcontrol.JobControl;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ValueAggregatorJob {
    public static JobControl createValueAggregatorJobs(String[] args2, Class<? extends ValueAggregatorDescriptor>[] descriptors) throws IOException {
        JobControl theControl = new JobControl("ValueAggregatorJobs");
        ArrayList<ControlledJob> dependingJobs = new ArrayList<ControlledJob>();
        Configuration conf = new Configuration();
        if (descriptors != null) {
            conf = ValueAggregatorJob.setAggregatorDescriptors(descriptors);
        }
        Job job = ValueAggregatorJob.createValueAggregatorJob(conf, args2);
        ControlledJob cjob = new ControlledJob(job, dependingJobs);
        theControl.addJob(cjob);
        return theControl;
    }

    public static JobControl createValueAggregatorJobs(String[] args2) throws IOException {
        return ValueAggregatorJob.createValueAggregatorJobs(args2, null);
    }

    public static Job createValueAggregatorJob(Configuration conf, String[] args2) throws IOException {
        String userJarFile;
        GenericOptionsParser genericParser = new GenericOptionsParser(conf, args2);
        if ((args2 = genericParser.getRemainingArgs()).length < 2) {
            System.out.println("usage: inputDirs outDir [numOfReducer [textinputformat|seq [specfile [jobName]]]]");
            GenericOptionsParser.printGenericCommandUsage((PrintStream)System.out);
            System.exit(2);
        }
        String inputDir = args2[0];
        String outputDir = args2[1];
        int numOfReducers = 1;
        if (args2.length > 2) {
            numOfReducers = Integer.parseInt(args2[2]);
        }
        Class theInputFormat = null;
        theInputFormat = args2.length > 3 && args2[3].compareToIgnoreCase("textinputformat") == 0 ? TextInputFormat.class : SequenceFileInputFormat.class;
        Path specFile = null;
        if (args2.length > 4) {
            specFile = new Path(args2[4]);
        }
        String jobName = "";
        if (args2.length > 5) {
            jobName = args2[5];
        }
        if (specFile != null) {
            conf.addResource(specFile);
        }
        if ((userJarFile = conf.get("mapreduce.aggregate.user.jar.file")) != null) {
            conf.set("mapreduce.job.jar", userJarFile);
        }
        Job theJob = Job.getInstance(conf);
        if (userJarFile == null) {
            theJob.setJarByClass(ValueAggregator.class);
        }
        theJob.setJobName("ValueAggregatorJob: " + jobName);
        FileInputFormat.addInputPaths(theJob, inputDir);
        theJob.setInputFormatClass(theInputFormat);
        theJob.setMapperClass(ValueAggregatorMapper.class);
        FileOutputFormat.setOutputPath(theJob, new Path(outputDir));
        theJob.setOutputFormatClass(TextOutputFormat.class);
        theJob.setMapOutputKeyClass(Text.class);
        theJob.setMapOutputValueClass(Text.class);
        theJob.setOutputKeyClass(Text.class);
        theJob.setOutputValueClass(Text.class);
        theJob.setReducerClass(ValueAggregatorReducer.class);
        theJob.setCombinerClass(ValueAggregatorCombiner.class);
        theJob.setNumReduceTasks(numOfReducers);
        return theJob;
    }

    public static Job createValueAggregatorJob(String[] args2, Class<? extends ValueAggregatorDescriptor>[] descriptors) throws IOException {
        return ValueAggregatorJob.createValueAggregatorJob(ValueAggregatorJob.setAggregatorDescriptors(descriptors), args2);
    }

    public static Configuration setAggregatorDescriptors(Class<? extends ValueAggregatorDescriptor>[] descriptors) {
        Configuration conf = new Configuration();
        conf.setInt("mapreduce.aggregate.descriptor.num", descriptors.length);
        for (int i = 0; i < descriptors.length; ++i) {
            conf.set("mapreduce.aggregate.descriptor" + i, "UserDefined," + descriptors[i].getName());
        }
        return conf;
    }

    public static void main(String[] args2) throws IOException, InterruptedException, ClassNotFoundException {
        Job job = ValueAggregatorJob.createValueAggregatorJob(new Configuration(), args2);
        int ret = job.waitForCompletion(true) ? 0 : 1;
        System.exit(ret);
    }
}

