/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TaskTrackerInfo
implements Writable {
    String name;
    boolean isBlacklisted = false;
    String reasonForBlacklist = "";
    String blacklistReport = "";

    public TaskTrackerInfo() {
    }

    public TaskTrackerInfo(String name) {
        this.name = name;
    }

    public TaskTrackerInfo(String name, String reasonForBlacklist, String report2) {
        this.name = name;
        this.isBlacklisted = true;
        this.reasonForBlacklist = reasonForBlacklist;
        this.blacklistReport = report2;
    }

    public String getTaskTrackerName() {
        return this.name;
    }

    public boolean isBlacklisted() {
        return this.isBlacklisted;
    }

    public String getReasonForBlacklist() {
        return this.reasonForBlacklist;
    }

    public String getBlacklistReport() {
        return this.blacklistReport;
    }

    public void readFields(DataInput in) throws IOException {
        this.name = Text.readString((DataInput)in);
        this.isBlacklisted = in.readBoolean();
        this.reasonForBlacklist = Text.readString((DataInput)in);
        this.blacklistReport = Text.readString((DataInput)in);
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.name);
        out.writeBoolean(this.isBlacklisted);
        Text.writeString((DataOutput)out, (String)this.reasonForBlacklist);
        Text.writeString((DataOutput)out, (String)this.blacklistReport);
    }
}

