/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce;

import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.mapreduce.ReduceContext;
import org.apache.hadoop.mapreduce.task.annotation.Checkpointable;

@Checkpointable
@InterfaceAudience.Public
@InterfaceStability.Stable
public class Reducer<KEYIN, VALUEIN, KEYOUT, VALUEOUT> {
    protected void setup(Context context) throws IOException, InterruptedException {
    }

    protected void reduce(KEYIN key, Iterable<VALUEIN> values2, Context context) throws IOException, InterruptedException {
        for (VALUEIN value : values2) {
            context.write(key, value);
        }
    }

    protected void cleanup(Context context) throws IOException, InterruptedException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context context) throws IOException, InterruptedException {
        this.setup(context);
        try {
            while (context.nextKey()) {
                this.reduce(context.getCurrentKey(), context.getValues(), context);
                Iterator iter = context.getValues().iterator();
                if (!(iter instanceof ReduceContext.ValueIterator)) continue;
                ((ReduceContext.ValueIterator)iter).resetBackupStore();
            }
        }
        finally {
            this.cleanup(context);
        }
    }

    public abstract class Context
    implements ReduceContext<KEYIN, VALUEIN, KEYOUT, VALUEOUT> {
    }
}

