/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.MD5MD5CRC32CastagnoliFileChecksum;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.MD5MD5CRC32GzipFileChecksum;
import org.apache.hadoop.fs.QuotaUsage;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.XAttrCodec;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.FsPermissionExtension;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.web.WebHdfsConstants;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hadoop.util.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectReader;

class JsonUtilClient {
    static final DatanodeInfo[] EMPTY_DATANODE_INFO_ARRAY = new DatanodeInfo[0];
    static final String UNSUPPPORTED_EXCEPTION_STR = UnsupportedOperationException.class.getName();

    JsonUtilClient() {
    }

    static RemoteException toRemoteException(Map<?, ?> json) {
        Map m3 = (Map)json.get(RemoteException.class.getSimpleName());
        String message = (String)m3.get("message");
        String javaClassName = (String)m3.get("javaClassName");
        if (UNSUPPPORTED_EXCEPTION_STR.equals(javaClassName)) {
            throw new UnsupportedOperationException(message);
        }
        return new RemoteException(javaClassName, message);
    }

    static Token<? extends TokenIdentifier> toToken(Map<?, ?> m3) throws IOException {
        if (m3 == null) {
            return null;
        }
        Token token = new Token();
        token.decodeFromUrlString((String)m3.get("urlString"));
        return token;
    }

    static Token<BlockTokenIdentifier> toBlockToken(Map<?, ?> m3) throws IOException {
        return JsonUtilClient.toToken(m3);
    }

    static FsPermission toFsPermission(String s2, Boolean aclBit, Boolean encBit) {
        boolean eBit;
        FsPermission perm = new FsPermission(Short.parseShort(s2, 8));
        boolean aBit = aclBit != null ? aclBit : false;
        boolean bl = eBit = encBit != null ? encBit : false;
        if (aBit || eBit) {
            return new FsPermissionExtension(perm, aBit, eBit);
        }
        return perm;
    }

    static HdfsFileStatus toFileStatus(Map<?, ?> json, boolean includesType) {
        if (json == null) {
            return null;
        }
        Map m3 = includesType ? (Map)json.get(FileStatus.class.getSimpleName()) : json;
        String localName = (String)m3.get("pathSuffix");
        WebHdfsConstants.PathType type = WebHdfsConstants.PathType.valueOf((String)m3.get("type"));
        byte[] symlink = type != WebHdfsConstants.PathType.SYMLINK ? null : DFSUtilClient.string2Bytes((String)m3.get("symlink"));
        long len = ((Number)m3.get("length")).longValue();
        String owner = (String)m3.get("owner");
        String group = (String)m3.get("group");
        FsPermission permission = JsonUtilClient.toFsPermission((String)m3.get("permission"), (Boolean)m3.get("aclBit"), (Boolean)m3.get("encBit"));
        long aTime = ((Number)m3.get("accessTime")).longValue();
        long mTime = ((Number)m3.get("modificationTime")).longValue();
        long blockSize = ((Number)m3.get("blockSize")).longValue();
        short replication = ((Number)m3.get("replication")).shortValue();
        long fileId = m3.containsKey("fileId") ? ((Number)m3.get("fileId")).longValue() : 0L;
        int childrenNum = JsonUtilClient.getInt(m3, "childrenNum", -1);
        byte storagePolicy = m3.containsKey("storagePolicy") ? (byte)((Number)m3.get("storagePolicy")).longValue() : (byte)0;
        return new HdfsFileStatus(len, type == WebHdfsConstants.PathType.DIRECTORY, replication, blockSize, mTime, aTime, permission, owner, group, symlink, DFSUtilClient.string2Bytes(localName), fileId, childrenNum, null, storagePolicy);
    }

    static HdfsFileStatus[] toHdfsFileStatusArray(Map<?, ?> json) {
        Preconditions.checkNotNull(json);
        Map rootmap = (Map)json.get(FileStatus.class.getSimpleName() + "es");
        List<?> array = JsonUtilClient.getList(rootmap, FileStatus.class.getSimpleName());
        Preconditions.checkNotNull(array);
        HdfsFileStatus[] statuses = new HdfsFileStatus[array.size()];
        int i = 0;
        for (Object object : array) {
            Map m3 = (Map)object;
            statuses[i++] = JsonUtilClient.toFileStatus(m3, false);
        }
        return statuses;
    }

    static DirectoryListing toDirectoryListing(Map<?, ?> json) {
        if (json == null) {
            return null;
        }
        Map<?, ?> listing = JsonUtilClient.getMap(json, "DirectoryListing");
        Map<?, ?> partialListing = JsonUtilClient.getMap(listing, "partialListing");
        HdfsFileStatus[] fileStatuses = JsonUtilClient.toHdfsFileStatusArray(partialListing);
        int remainingEntries = JsonUtilClient.getInt(listing, "remainingEntries", -1);
        Preconditions.checkState(remainingEntries != -1, "remainingEntries was not set");
        return new DirectoryListing(fileStatuses, remainingEntries);
    }

    static ExtendedBlock toExtendedBlock(Map<?, ?> m3) {
        if (m3 == null) {
            return null;
        }
        String blockPoolId = (String)m3.get("blockPoolId");
        long blockId = ((Number)m3.get("blockId")).longValue();
        long numBytes = ((Number)m3.get("numBytes")).longValue();
        long generationStamp = ((Number)m3.get("generationStamp")).longValue();
        return new ExtendedBlock(blockPoolId, blockId, numBytes, generationStamp);
    }

    static int getInt(Map<?, ?> m3, String key, int defaultValue) {
        Object value = m3.get(key);
        if (value == null) {
            return defaultValue;
        }
        return ((Number)value).intValue();
    }

    static long getLong(Map<?, ?> m3, String key, long defaultValue) {
        Object value = m3.get(key);
        if (value == null) {
            return defaultValue;
        }
        return ((Number)value).longValue();
    }

    static String getString(Map<?, ?> m3, String key, String defaultValue) {
        Object value = m3.get(key);
        if (value == null) {
            return defaultValue;
        }
        return (String)value;
    }

    static List<?> getList(Map<?, ?> m3, String key) {
        Object list = m3.get(key);
        if (list instanceof List) {
            return (List)list;
        }
        return null;
    }

    static Map<?, ?> getMap(Map<?, ?> m3, String key) {
        Object map = m3.get(key);
        if (map instanceof Map) {
            return (Map)map;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static DatanodeInfo toDatanodeInfo(Map<?, ?> m3) throws IOException {
        if (m3 == null) {
            return null;
        }
        String ipAddr = JsonUtilClient.getString(m3, "ipAddr", null);
        int xferPort = JsonUtilClient.getInt(m3, "xferPort", -1);
        if (ipAddr == null) {
            String name = JsonUtilClient.getString(m3, "name", null);
            if (name == null) throw new IOException("Missing both 'ipAddr' and 'name' in server response.");
            int colonIdx = name.indexOf(58);
            if (colonIdx <= 0) throw new IOException("Invalid value in server response: name=[" + name + "]");
            ipAddr = name.substring(0, colonIdx);
            xferPort = Integer.parseInt(name.substring(colonIdx + 1));
        }
        if (xferPort != -1) return new DatanodeInfo.DatanodeInfoBuilder().setIpAddr(ipAddr).setHostName((String)m3.get("hostName")).setDatanodeUuid((String)m3.get("storageID")).setXferPort(xferPort).setInfoPort(((Number)m3.get("infoPort")).intValue()).setInfoSecurePort(JsonUtilClient.getInt(m3, "infoSecurePort", 0)).setIpcPort(((Number)m3.get("ipcPort")).intValue()).setCapacity(JsonUtilClient.getLong(m3, "capacity", 0L)).setDfsUsed(JsonUtilClient.getLong(m3, "dfsUsed", 0L)).setRemaining(JsonUtilClient.getLong(m3, "remaining", 0L)).setBlockPoolUsed(JsonUtilClient.getLong(m3, "blockPoolUsed", 0L)).setCacheCapacity(JsonUtilClient.getLong(m3, "cacheCapacity", 0L)).setCacheUsed(JsonUtilClient.getLong(m3, "cacheUsed", 0L)).setLastUpdate(JsonUtilClient.getLong(m3, "lastUpdate", 0L)).setLastUpdateMonotonic(JsonUtilClient.getLong(m3, "lastUpdateMonotonic", 0L)).setXceiverCount(JsonUtilClient.getInt(m3, "xceiverCount", 0)).setNetworkLocation(JsonUtilClient.getString(m3, "networkLocation", "")).setAdminState(DatanodeInfo.AdminStates.valueOf(JsonUtilClient.getString(m3, "adminState", "NORMAL"))).setUpgradeDomain(JsonUtilClient.getString(m3, "upgradeDomain", "")).setLastBlockReportTime(JsonUtilClient.getLong(m3, "lastBlockReportTime", 0L)).setLastBlockReportMonotonic(JsonUtilClient.getLong(m3, "lastBlockReportMonotonic", 0L)).build();
        throw new IOException("Invalid or missing 'xferPort' in server response.");
    }

    static DatanodeInfo[] toDatanodeInfoArray(List<?> objects) throws IOException {
        if (objects == null) {
            return null;
        }
        if (objects.isEmpty()) {
            return EMPTY_DATANODE_INFO_ARRAY;
        }
        DatanodeInfo[] array = new DatanodeInfo[objects.size()];
        int i = 0;
        for (Object object : objects) {
            array[i++] = JsonUtilClient.toDatanodeInfo((Map)object);
        }
        return array;
    }

    static StorageType[] toStorageTypeArray(List<?> objects) throws IOException {
        if (objects == null) {
            return null;
        }
        if (objects.isEmpty()) {
            return StorageType.EMPTY_ARRAY;
        }
        StorageType[] array = new StorageType[objects.size()];
        int i = 0;
        for (Object object : objects) {
            array[i++] = StorageType.parseStorageType((String)object.toString());
        }
        return array;
    }

    static LocatedBlock toLocatedBlock(Map<?, ?> m3) throws IOException {
        if (m3 == null) {
            return null;
        }
        ExtendedBlock b = JsonUtilClient.toExtendedBlock((Map)m3.get("block"));
        DatanodeInfo[] locations = JsonUtilClient.toDatanodeInfoArray(JsonUtilClient.getList(m3, "locations"));
        long startOffset = ((Number)m3.get("startOffset")).longValue();
        boolean isCorrupt = (Boolean)m3.get("isCorrupt");
        DatanodeInfo[] cachedLocations = JsonUtilClient.toDatanodeInfoArray(JsonUtilClient.getList(m3, "cachedLocations"));
        StorageType[] storageTypes = JsonUtilClient.toStorageTypeArray(JsonUtilClient.getList(m3, "storageTypes"));
        LocatedBlock locatedblock = new LocatedBlock(b, locations, null, storageTypes, startOffset, isCorrupt, cachedLocations);
        locatedblock.setBlockToken(JsonUtilClient.toBlockToken((Map)m3.get("blockToken")));
        return locatedblock;
    }

    static List<LocatedBlock> toLocatedBlockList(List<?> objects) throws IOException {
        if (objects == null) {
            return null;
        }
        if (objects.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<LocatedBlock> list = new ArrayList<LocatedBlock>(objects.size());
        for (Object object : objects) {
            list.add(JsonUtilClient.toLocatedBlock((Map)object));
        }
        return list;
    }

    static ContentSummary toContentSummary(Map<?, ?> json) {
        if (json == null) {
            return null;
        }
        Map m3 = (Map)json.get(ContentSummary.class.getSimpleName());
        long length = ((Number)m3.get("length")).longValue();
        long fileCount = ((Number)m3.get("fileCount")).longValue();
        long directoryCount = ((Number)m3.get("directoryCount")).longValue();
        ContentSummary.Builder builder = new ContentSummary.Builder().length(length).fileCount(fileCount).directoryCount(directoryCount);
        builder = JsonUtilClient.buildQuotaUsage(builder, m3, ContentSummary.Builder.class);
        return builder.build();
    }

    static QuotaUsage toQuotaUsage(Map<?, ?> json) {
        if (json == null) {
            return null;
        }
        Map m3 = (Map)json.get(QuotaUsage.class.getSimpleName());
        QuotaUsage.Builder builder = new QuotaUsage.Builder();
        builder = JsonUtilClient.buildQuotaUsage(builder, m3, QuotaUsage.Builder.class);
        return builder.build();
    }

    private static <T extends QuotaUsage.Builder> T buildQuotaUsage(T builder, Map<?, ?> m3, Class<T> type) {
        long quota = ((Number)m3.get("quota")).longValue();
        long spaceConsumed = ((Number)m3.get("spaceConsumed")).longValue();
        long spaceQuota = ((Number)m3.get("spaceQuota")).longValue();
        Map typem = (Map)m3.get("typeQuota");
        QuotaUsage.Builder result = (QuotaUsage.Builder)type.cast(builder.quota(quota).spaceConsumed(spaceConsumed).spaceQuota(spaceQuota));
        if (m3.get("fileAndDirectoryCount") != null) {
            long fileAndDirectoryCount = ((Number)m3.get("fileAndDirectoryCount")).longValue();
            result = (QuotaUsage.Builder)type.cast(result.fileAndDirectoryCount(fileAndDirectoryCount));
        }
        if (typem != null) {
            for (StorageType t : StorageType.getTypesSupportingQuota()) {
                Map typeQuota = (Map)typem.get(t.toString());
                if (typeQuota == null) continue;
                result = (QuotaUsage.Builder)type.cast(result.typeQuota(t, ((Number)typeQuota.get("quota")).longValue()).typeConsumed(t, ((Number)typeQuota.get("consumed")).longValue()));
            }
        }
        return (T)result;
    }

    static MD5MD5CRC32FileChecksum toMD5MD5CRC32FileChecksum(Map<?, ?> json) throws IOException {
        MD5MD5CRC32GzipFileChecksum checksum;
        if (json == null) {
            return null;
        }
        Map m3 = (Map)json.get(FileChecksum.class.getSimpleName());
        String algorithm = (String)m3.get("algorithm");
        int length = ((Number)m3.get("length")).intValue();
        byte[] bytes = StringUtils.hexStringToByte((String)((String)m3.get("bytes")));
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        DataChecksum.Type crcType = MD5MD5CRC32FileChecksum.getCrcTypeFromAlgorithmName((String)algorithm);
        switch (crcType) {
            case CRC32: {
                checksum = new MD5MD5CRC32GzipFileChecksum();
                break;
            }
            case CRC32C: {
                checksum = new MD5MD5CRC32CastagnoliFileChecksum();
                break;
            }
            default: {
                throw new IOException("Unknown algorithm: " + algorithm);
            }
        }
        checksum.readFields((DataInput)in);
        if (!checksum.getAlgorithmName().equals(algorithm)) {
            throw new IOException("Algorithm not matched. Expected " + algorithm + ", Received " + checksum.getAlgorithmName());
        }
        if (length != checksum.getLength()) {
            throw new IOException("Length not matched: length=" + length + ", checksum.getLength()=" + checksum.getLength());
        }
        return checksum;
    }

    static AclStatus toAclStatus(Map<?, ?> json) {
        if (json == null) {
            return null;
        }
        Map m3 = (Map)json.get(AclStatus.class.getSimpleName());
        AclStatus.Builder aclStatusBuilder = new AclStatus.Builder();
        aclStatusBuilder.owner((String)m3.get("owner"));
        aclStatusBuilder.group((String)m3.get("group"));
        aclStatusBuilder.stickyBit(((Boolean)m3.get("stickyBit")).booleanValue());
        String permString = (String)m3.get("permission");
        if (permString != null) {
            FsPermission permission = JsonUtilClient.toFsPermission(permString, (Boolean)m3.get("aclBit"), (Boolean)m3.get("encBit"));
            aclStatusBuilder.setPermission(permission);
        }
        List entries = (List)m3.get("entries");
        ArrayList<AclEntry> aclEntryList = new ArrayList<AclEntry>();
        for (Object entry : entries) {
            AclEntry aclEntry = AclEntry.parseAclEntry((String)((String)entry), (boolean)true);
            aclEntryList.add(aclEntry);
        }
        aclStatusBuilder.addEntries(aclEntryList);
        return aclStatusBuilder.build();
    }

    static String getPath(Map<?, ?> json) {
        if (json == null) {
            return null;
        }
        return (String)json.get("Path");
    }

    static byte[] getXAttr(Map<?, ?> json, String name) throws IOException {
        if (json == null) {
            return null;
        }
        Map<String, byte[]> xAttrs = JsonUtilClient.toXAttrs(json);
        if (xAttrs != null) {
            return xAttrs.get(name);
        }
        return null;
    }

    static byte[] getXAttr(Map<?, ?> json) throws IOException {
        if (json == null) {
            return null;
        }
        Map<String, byte[]> xAttrs = JsonUtilClient.toXAttrs(json);
        if (xAttrs != null && !xAttrs.values().isEmpty()) {
            return xAttrs.values().iterator().next();
        }
        return null;
    }

    static Map<String, byte[]> toXAttrs(Map<?, ?> json) throws IOException {
        if (json == null) {
            return null;
        }
        return JsonUtilClient.toXAttrMap(JsonUtilClient.getList(json, "XAttrs"));
    }

    static List<String> toXAttrNames(Map<?, ?> json) throws IOException {
        if (json == null) {
            return null;
        }
        String namesInJson = (String)json.get("XAttrNames");
        ObjectReader reader = new ObjectMapper().reader(List.class);
        List xattrs = (List)reader.readValue(namesInJson);
        ArrayList<String> names = Lists.newArrayListWithCapacity(json.keySet().size());
        for (Object xattr : xattrs) {
            names.add((String)xattr);
        }
        return names;
    }

    static Map<String, byte[]> toXAttrMap(List<?> objects) throws IOException {
        if (objects == null) {
            return null;
        }
        if (objects.isEmpty()) {
            return Maps.newHashMap();
        }
        HashMap<String, byte[]> xAttrs = Maps.newHashMap();
        for (Object object : objects) {
            Map m3 = (Map)object;
            String name = (String)m3.get("name");
            String value = (String)m3.get("value");
            xAttrs.put(name, JsonUtilClient.decodeXAttrValue(value));
        }
        return xAttrs;
    }

    static byte[] decodeXAttrValue(String value) throws IOException {
        if (value != null) {
            return XAttrCodec.decodeValue((String)value);
        }
        return new byte[0];
    }

    static Token<DelegationTokenIdentifier> toDelegationToken(Map<?, ?> json) throws IOException {
        Map m3 = (Map)json.get(Token.class.getSimpleName());
        return JsonUtilClient.toToken(m3);
    }

    static LocatedBlocks toLocatedBlocks(Map<?, ?> json) throws IOException {
        if (json == null) {
            return null;
        }
        Map m3 = (Map)json.get(LocatedBlocks.class.getSimpleName());
        long fileLength = ((Number)m3.get("fileLength")).longValue();
        boolean isUnderConstruction = (Boolean)m3.get("isUnderConstruction");
        List<LocatedBlock> locatedBlocks = JsonUtilClient.toLocatedBlockList(JsonUtilClient.getList(m3, "locatedBlocks"));
        LocatedBlock lastLocatedBlock = JsonUtilClient.toLocatedBlock((Map)m3.get("lastLocatedBlock"));
        boolean isLastBlockComplete = (Boolean)m3.get("isLastBlockComplete");
        return new LocatedBlocks(fileLength, isUnderConstruction, locatedBlocks, lastLocatedBlock, isLastBlockComplete, null);
    }

    public static Collection<BlockStoragePolicy> getStoragePolicies(Map<?, ?> json) {
        List objs;
        Map policiesJson = (Map)json.get("BlockStoragePolicies");
        if (policiesJson != null && (objs = (List)policiesJson.get(BlockStoragePolicy.class.getSimpleName())) != null) {
            BlockStoragePolicy[] storagePolicies = new BlockStoragePolicy[objs.size()];
            for (int i = 0; i < objs.size(); ++i) {
                BlockStoragePolicy blockStoragePolicy;
                Map m3 = (Map)objs.get(i);
                storagePolicies[i] = blockStoragePolicy = JsonUtilClient.toBlockStoragePolicy(m3);
            }
            return Arrays.asList(storagePolicies);
        }
        return new ArrayList<BlockStoragePolicy>(0);
    }

    public static BlockStoragePolicy toBlockStoragePolicy(Map<?, ?> m3) {
        byte id = ((Number)m3.get("id")).byteValue();
        String name = (String)m3.get("name");
        StorageType[] storageTypes = JsonUtilClient.toStorageTypes((List)m3.get("storageTypes"));
        StorageType[] creationFallbacks = JsonUtilClient.toStorageTypes((List)m3.get("creationFallbacks"));
        StorageType[] replicationFallbacks = JsonUtilClient.toStorageTypes((List)m3.get("replicationFallbacks"));
        Boolean copyOnCreateFile = (Boolean)m3.get("copyOnCreateFile");
        return new BlockStoragePolicy(id, name, storageTypes, creationFallbacks, replicationFallbacks, copyOnCreateFile);
    }

    private static StorageType[] toStorageTypes(List<?> list) {
        if (list == null) {
            return null;
        }
        StorageType[] storageTypes = new StorageType[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            storageTypes[i] = StorageType.parseStorageType((String)((String)list.get(i)));
        }
        return storageTypes;
    }

    public static FsServerDefaults toFsServerDefaults(Map<?, ?> json) {
        if (json == null) {
            return null;
        }
        Map m3 = (Map)json.get(FsServerDefaults.class.getSimpleName());
        long blockSize = JsonUtilClient.getLong(m3, "blockSize", -1L);
        int bytesPerChecksum = JsonUtilClient.getInt(m3, "bytesPerChecksum", -1);
        int writePacketSize = JsonUtilClient.getInt(m3, "writePacketSize", -1);
        short replication = (short)JsonUtilClient.getInt(m3, "replication", -1);
        int fileBufferSize = JsonUtilClient.getInt(m3, "fileBufferSize", -1);
        boolean encryptDataTransfer = m3.containsKey("encryptDataTransfer") ? (Boolean)m3.get("encryptDataTransfer") : false;
        long trashInterval = JsonUtilClient.getLong(m3, "trashInterval", 0L);
        DataChecksum.Type type = DataChecksum.Type.valueOf((int)JsonUtilClient.getInt(m3, "checksumType", 1));
        String keyProviderUri = (String)m3.get("keyProviderUri");
        byte storagepolicyId = m3.containsKey("defaultStoragePolicyId") ? ((Number)m3.get("defaultStoragePolicyId")).byteValue() : (byte)0;
        return new FsServerDefaults(blockSize, bytesPerChecksum, writePacketSize, replication, fileBufferSize, encryptDataTransfer, trashInterval, type, keyProviderUri, storagepolicyId);
    }
}

