/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.google.common.base.Preconditions;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.VolumeId;
import org.apache.hadoop.util.StringUtils;

@InterfaceStability.Unstable
@InterfaceAudience.Public
public class HdfsVolumeId
implements VolumeId {
    private final byte[] id;

    public HdfsVolumeId(byte[] id) {
        Preconditions.checkNotNull(id, "id cannot be null");
        this.id = id;
    }

    @Override
    public int compareTo(VolumeId arg0) {
        if (arg0 == null) {
            return 1;
        }
        return this.hashCode() - arg0.hashCode();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().append(this.id).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        HdfsVolumeId that = (HdfsVolumeId)obj;
        return new EqualsBuilder().append(this.id, that.id).isEquals();
    }

    public String toString() {
        return StringUtils.byteToHexString((byte[])this.id);
    }
}

