/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.thrift;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.doris.thrift.TBackend;
import org.apache.doris.thrift.TDisk;
import org.apache.doris.thrift.TTablet;
import org.apache.doris.thrift.TTaskType;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.SetMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;

public class TReportRequest
implements TBase<TReportRequest, _Fields>,
Serializable,
Cloneable,
Comparable<TReportRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("TReportRequest");
    private static final TField BACKEND_FIELD_DESC = new TField("backend", 12, 1);
    private static final TField REPORT_VERSION_FIELD_DESC = new TField("report_version", 10, 2);
    private static final TField TASKS_FIELD_DESC = new TField("tasks", 13, 3);
    private static final TField TABLETS_FIELD_DESC = new TField("tablets", 13, 4);
    private static final TField DISKS_FIELD_DESC = new TField("disks", 13, 5);
    private static final TField FORCE_RECOVERY_FIELD_DESC = new TField("force_recovery", 2, 6);
    private static final TField TABLET_LIST_FIELD_DESC = new TField("tablet_list", 15, 7);
    private static final TField TABLET_MAX_COMPACTION_SCORE_FIELD_DESC = new TField("tablet_max_compaction_score", 10, 8);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TReportRequestStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TReportRequestTupleSchemeFactory();
    @Nullable
    public TBackend backend;
    public long report_version;
    @Nullable
    public Map<TTaskType, Set<Long>> tasks;
    @Nullable
    public Map<Long, TTablet> tablets;
    @Nullable
    public Map<String, TDisk> disks;
    public boolean force_recovery;
    @Nullable
    public List<TTablet> tablet_list;
    public long tablet_max_compaction_score;
    private static final int __REPORT_VERSION_ISSET_ID = 0;
    private static final int __FORCE_RECOVERY_ISSET_ID = 1;
    private static final int __TABLET_MAX_COMPACTION_SCORE_ISSET_ID = 2;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.REPORT_VERSION, _Fields.TASKS, _Fields.TABLETS, _Fields.DISKS, _Fields.FORCE_RECOVERY, _Fields.TABLET_LIST, _Fields.TABLET_MAX_COMPACTION_SCORE};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TReportRequest() {
    }

    public TReportRequest(TBackend backend) {
        this();
        this.backend = backend;
    }

    public TReportRequest(TReportRequest other) {
        Object other_element_value;
        Object other_element_key;
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetBackend()) {
            this.backend = new TBackend(other.backend);
        }
        this.report_version = other.report_version;
        if (other.isSetTasks()) {
            EnumMap<TTaskType, Set<Long>> __this__tasks = new EnumMap<TTaskType, Set<Long>>(TTaskType.class);
            for (Map.Entry<TTaskType, Set<Long>> entry : other.tasks.entrySet()) {
                other_element_key = entry.getKey();
                other_element_value = entry.getValue();
                TTaskType __this__tasks_copy_key = other_element_key;
                HashSet<Long> __this__tasks_copy_value = new HashSet<Long>((Collection<Long>)other_element_value);
                __this__tasks.put(__this__tasks_copy_key, __this__tasks_copy_value);
            }
            this.tasks = __this__tasks;
        }
        if (other.isSetTablets()) {
            HashMap<Long, TTablet> __this__tablets = new HashMap<Long, TTablet>(other.tablets.size());
            for (Map.Entry<Object, Object> entry : other.tablets.entrySet()) {
                other_element_key = (Long)entry.getKey();
                other_element_value = (TTablet)entry.getValue();
                Object __this__tablets_copy_key = other_element_key;
                TTablet __this__tablets_copy_value = new TTablet((TTablet)other_element_value);
                __this__tablets.put((Long)__this__tablets_copy_key, __this__tablets_copy_value);
            }
            this.tablets = __this__tablets;
        }
        if (other.isSetDisks()) {
            HashMap<String, TDisk> __this__disks = new HashMap<String, TDisk>(other.disks.size());
            for (Map.Entry<Object, Object> entry : other.disks.entrySet()) {
                other_element_key = (String)entry.getKey();
                other_element_value = (TDisk)entry.getValue();
                Object __this__disks_copy_key = other_element_key;
                TDisk __this__disks_copy_value = new TDisk((TDisk)other_element_value);
                __this__disks.put((String)__this__disks_copy_key, __this__disks_copy_value);
            }
            this.disks = __this__disks;
        }
        this.force_recovery = other.force_recovery;
        if (other.isSetTabletList()) {
            ArrayList<TTablet> __this__tablet_list = new ArrayList<TTablet>(other.tablet_list.size());
            for (TTablet tTablet : other.tablet_list) {
                __this__tablet_list.add(new TTablet(tTablet));
            }
            this.tablet_list = __this__tablet_list;
        }
        this.tablet_max_compaction_score = other.tablet_max_compaction_score;
    }

    @Override
    public TReportRequest deepCopy() {
        return new TReportRequest(this);
    }

    @Override
    public void clear() {
        this.backend = null;
        this.setReportVersionIsSet(false);
        this.report_version = 0L;
        this.tasks = null;
        this.tablets = null;
        this.disks = null;
        this.setForceRecoveryIsSet(false);
        this.force_recovery = false;
        this.tablet_list = null;
        this.setTabletMaxCompactionScoreIsSet(false);
        this.tablet_max_compaction_score = 0L;
    }

    @Nullable
    public TBackend getBackend() {
        return this.backend;
    }

    public TReportRequest setBackend(@Nullable TBackend backend) {
        this.backend = backend;
        return this;
    }

    public void unsetBackend() {
        this.backend = null;
    }

    public boolean isSetBackend() {
        return this.backend != null;
    }

    public void setBackendIsSet(boolean value) {
        if (!value) {
            this.backend = null;
        }
    }

    public long getReportVersion() {
        return this.report_version;
    }

    public TReportRequest setReportVersion(long report_version) {
        this.report_version = report_version;
        this.setReportVersionIsSet(true);
        return this;
    }

    public void unsetReportVersion() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 0);
    }

    public boolean isSetReportVersion() {
        return EncodingUtils.testBit(this.__isset_bitfield, 0);
    }

    public void setReportVersionIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 0, value);
    }

    public int getTasksSize() {
        return this.tasks == null ? 0 : this.tasks.size();
    }

    public void putToTasks(TTaskType key, Set<Long> val) {
        if (this.tasks == null) {
            this.tasks = new EnumMap<TTaskType, Set<Long>>(TTaskType.class);
        }
        this.tasks.put(key, val);
    }

    @Nullable
    public Map<TTaskType, Set<Long>> getTasks() {
        return this.tasks;
    }

    public TReportRequest setTasks(@Nullable Map<TTaskType, Set<Long>> tasks) {
        this.tasks = tasks;
        return this;
    }

    public void unsetTasks() {
        this.tasks = null;
    }

    public boolean isSetTasks() {
        return this.tasks != null;
    }

    public void setTasksIsSet(boolean value) {
        if (!value) {
            this.tasks = null;
        }
    }

    public int getTabletsSize() {
        return this.tablets == null ? 0 : this.tablets.size();
    }

    public void putToTablets(long key, TTablet val) {
        if (this.tablets == null) {
            this.tablets = new HashMap<Long, TTablet>();
        }
        this.tablets.put(key, val);
    }

    @Nullable
    public Map<Long, TTablet> getTablets() {
        return this.tablets;
    }

    public TReportRequest setTablets(@Nullable Map<Long, TTablet> tablets) {
        this.tablets = tablets;
        return this;
    }

    public void unsetTablets() {
        this.tablets = null;
    }

    public boolean isSetTablets() {
        return this.tablets != null;
    }

    public void setTabletsIsSet(boolean value) {
        if (!value) {
            this.tablets = null;
        }
    }

    public int getDisksSize() {
        return this.disks == null ? 0 : this.disks.size();
    }

    public void putToDisks(String key, TDisk val) {
        if (this.disks == null) {
            this.disks = new HashMap<String, TDisk>();
        }
        this.disks.put(key, val);
    }

    @Nullable
    public Map<String, TDisk> getDisks() {
        return this.disks;
    }

    public TReportRequest setDisks(@Nullable Map<String, TDisk> disks) {
        this.disks = disks;
        return this;
    }

    public void unsetDisks() {
        this.disks = null;
    }

    public boolean isSetDisks() {
        return this.disks != null;
    }

    public void setDisksIsSet(boolean value) {
        if (!value) {
            this.disks = null;
        }
    }

    public boolean isForceRecovery() {
        return this.force_recovery;
    }

    public TReportRequest setForceRecovery(boolean force_recovery) {
        this.force_recovery = force_recovery;
        this.setForceRecoveryIsSet(true);
        return this;
    }

    public void unsetForceRecovery() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 1);
    }

    public boolean isSetForceRecovery() {
        return EncodingUtils.testBit(this.__isset_bitfield, 1);
    }

    public void setForceRecoveryIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 1, value);
    }

    public int getTabletListSize() {
        return this.tablet_list == null ? 0 : this.tablet_list.size();
    }

    @Nullable
    public Iterator<TTablet> getTabletListIterator() {
        return this.tablet_list == null ? null : this.tablet_list.iterator();
    }

    public void addToTabletList(TTablet elem) {
        if (this.tablet_list == null) {
            this.tablet_list = new ArrayList<TTablet>();
        }
        this.tablet_list.add(elem);
    }

    @Nullable
    public List<TTablet> getTabletList() {
        return this.tablet_list;
    }

    public TReportRequest setTabletList(@Nullable List<TTablet> tablet_list) {
        this.tablet_list = tablet_list;
        return this;
    }

    public void unsetTabletList() {
        this.tablet_list = null;
    }

    public boolean isSetTabletList() {
        return this.tablet_list != null;
    }

    public void setTabletListIsSet(boolean value) {
        if (!value) {
            this.tablet_list = null;
        }
    }

    public long getTabletMaxCompactionScore() {
        return this.tablet_max_compaction_score;
    }

    public TReportRequest setTabletMaxCompactionScore(long tablet_max_compaction_score) {
        this.tablet_max_compaction_score = tablet_max_compaction_score;
        this.setTabletMaxCompactionScoreIsSet(true);
        return this;
    }

    public void unsetTabletMaxCompactionScore() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 2);
    }

    public boolean isSetTabletMaxCompactionScore() {
        return EncodingUtils.testBit(this.__isset_bitfield, 2);
    }

    public void setTabletMaxCompactionScoreIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 2, value);
    }

    @Override
    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case BACKEND: {
                if (value == null) {
                    this.unsetBackend();
                    break;
                }
                this.setBackend((TBackend)value);
                break;
            }
            case REPORT_VERSION: {
                if (value == null) {
                    this.unsetReportVersion();
                    break;
                }
                this.setReportVersion((Long)value);
                break;
            }
            case TASKS: {
                if (value == null) {
                    this.unsetTasks();
                    break;
                }
                this.setTasks((Map)value);
                break;
            }
            case TABLETS: {
                if (value == null) {
                    this.unsetTablets();
                    break;
                }
                this.setTablets((Map)value);
                break;
            }
            case DISKS: {
                if (value == null) {
                    this.unsetDisks();
                    break;
                }
                this.setDisks((Map)value);
                break;
            }
            case FORCE_RECOVERY: {
                if (value == null) {
                    this.unsetForceRecovery();
                    break;
                }
                this.setForceRecovery((Boolean)value);
                break;
            }
            case TABLET_LIST: {
                if (value == null) {
                    this.unsetTabletList();
                    break;
                }
                this.setTabletList((List)value);
                break;
            }
            case TABLET_MAX_COMPACTION_SCORE: {
                if (value == null) {
                    this.unsetTabletMaxCompactionScore();
                    break;
                }
                this.setTabletMaxCompactionScore((Long)value);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case BACKEND: {
                return this.getBackend();
            }
            case REPORT_VERSION: {
                return this.getReportVersion();
            }
            case TASKS: {
                return this.getTasks();
            }
            case TABLETS: {
                return this.getTablets();
            }
            case DISKS: {
                return this.getDisks();
            }
            case FORCE_RECOVERY: {
                return this.isForceRecovery();
            }
            case TABLET_LIST: {
                return this.getTabletList();
            }
            case TABLET_MAX_COMPACTION_SCORE: {
                return this.getTabletMaxCompactionScore();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case BACKEND: {
                return this.isSetBackend();
            }
            case REPORT_VERSION: {
                return this.isSetReportVersion();
            }
            case TASKS: {
                return this.isSetTasks();
            }
            case TABLETS: {
                return this.isSetTablets();
            }
            case DISKS: {
                return this.isSetDisks();
            }
            case FORCE_RECOVERY: {
                return this.isSetForceRecovery();
            }
            case TABLET_LIST: {
                return this.isSetTabletList();
            }
            case TABLET_MAX_COMPACTION_SCORE: {
                return this.isSetTabletMaxCompactionScore();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TReportRequest) {
            return this.equals((TReportRequest)that);
        }
        return false;
    }

    public boolean equals(TReportRequest that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_backend = this.isSetBackend();
        boolean that_present_backend = that.isSetBackend();
        if (this_present_backend || that_present_backend) {
            if (!this_present_backend || !that_present_backend) {
                return false;
            }
            if (!this.backend.equals(that.backend)) {
                return false;
            }
        }
        boolean this_present_report_version = this.isSetReportVersion();
        boolean that_present_report_version = that.isSetReportVersion();
        if (this_present_report_version || that_present_report_version) {
            if (!this_present_report_version || !that_present_report_version) {
                return false;
            }
            if (this.report_version != that.report_version) {
                return false;
            }
        }
        boolean this_present_tasks = this.isSetTasks();
        boolean that_present_tasks = that.isSetTasks();
        if (this_present_tasks || that_present_tasks) {
            if (!this_present_tasks || !that_present_tasks) {
                return false;
            }
            if (!this.tasks.equals(that.tasks)) {
                return false;
            }
        }
        boolean this_present_tablets = this.isSetTablets();
        boolean that_present_tablets = that.isSetTablets();
        if (this_present_tablets || that_present_tablets) {
            if (!this_present_tablets || !that_present_tablets) {
                return false;
            }
            if (!this.tablets.equals(that.tablets)) {
                return false;
            }
        }
        boolean this_present_disks = this.isSetDisks();
        boolean that_present_disks = that.isSetDisks();
        if (this_present_disks || that_present_disks) {
            if (!this_present_disks || !that_present_disks) {
                return false;
            }
            if (!this.disks.equals(that.disks)) {
                return false;
            }
        }
        boolean this_present_force_recovery = this.isSetForceRecovery();
        boolean that_present_force_recovery = that.isSetForceRecovery();
        if (this_present_force_recovery || that_present_force_recovery) {
            if (!this_present_force_recovery || !that_present_force_recovery) {
                return false;
            }
            if (this.force_recovery != that.force_recovery) {
                return false;
            }
        }
        boolean this_present_tablet_list = this.isSetTabletList();
        boolean that_present_tablet_list = that.isSetTabletList();
        if (this_present_tablet_list || that_present_tablet_list) {
            if (!this_present_tablet_list || !that_present_tablet_list) {
                return false;
            }
            if (!this.tablet_list.equals(that.tablet_list)) {
                return false;
            }
        }
        boolean this_present_tablet_max_compaction_score = this.isSetTabletMaxCompactionScore();
        boolean that_present_tablet_max_compaction_score = that.isSetTabletMaxCompactionScore();
        if (this_present_tablet_max_compaction_score || that_present_tablet_max_compaction_score) {
            if (!this_present_tablet_max_compaction_score || !that_present_tablet_max_compaction_score) {
                return false;
            }
            if (this.tablet_max_compaction_score != that.tablet_max_compaction_score) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetBackend() ? 131071 : 524287);
        if (this.isSetBackend()) {
            hashCode = hashCode * 8191 + this.backend.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetReportVersion() ? 131071 : 524287);
        if (this.isSetReportVersion()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode(this.report_version);
        }
        hashCode = hashCode * 8191 + (this.isSetTasks() ? 131071 : 524287);
        if (this.isSetTasks()) {
            hashCode = hashCode * 8191 + this.tasks.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTablets() ? 131071 : 524287);
        if (this.isSetTablets()) {
            hashCode = hashCode * 8191 + this.tablets.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetDisks() ? 131071 : 524287);
        if (this.isSetDisks()) {
            hashCode = hashCode * 8191 + this.disks.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetForceRecovery() ? 131071 : 524287);
        if (this.isSetForceRecovery()) {
            hashCode = hashCode * 8191 + (this.force_recovery ? 131071 : 524287);
        }
        hashCode = hashCode * 8191 + (this.isSetTabletList() ? 131071 : 524287);
        if (this.isSetTabletList()) {
            hashCode = hashCode * 8191 + this.tablet_list.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTabletMaxCompactionScore() ? 131071 : 524287);
        if (this.isSetTabletMaxCompactionScore()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode(this.tablet_max_compaction_score);
        }
        return hashCode;
    }

    @Override
    public int compareTo(TReportRequest other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetBackend()).compareTo(other.isSetBackend());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBackend() && (lastComparison = TBaseHelper.compareTo(this.backend, other.backend)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetReportVersion()).compareTo(other.isSetReportVersion());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetReportVersion() && (lastComparison = TBaseHelper.compareTo(this.report_version, other.report_version)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTasks()).compareTo(other.isSetTasks());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTasks() && (lastComparison = TBaseHelper.compareTo(this.tasks, other.tasks)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTablets()).compareTo(other.isSetTablets());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTablets() && (lastComparison = TBaseHelper.compareTo(this.tablets, other.tablets)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDisks()).compareTo(other.isSetDisks());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDisks() && (lastComparison = TBaseHelper.compareTo(this.disks, other.disks)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetForceRecovery()).compareTo(other.isSetForceRecovery());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetForceRecovery() && (lastComparison = TBaseHelper.compareTo(this.force_recovery, other.force_recovery)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTabletList()).compareTo(other.isSetTabletList());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTabletList() && (lastComparison = TBaseHelper.compareTo(this.tablet_list, other.tablet_list)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTabletMaxCompactionScore()).compareTo(other.isSetTabletMaxCompactionScore());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTabletMaxCompactionScore() && (lastComparison = TBaseHelper.compareTo(this.tablet_max_compaction_score, other.tablet_max_compaction_score)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        TReportRequest.scheme(iprot).read(iprot, (TReportRequest)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        TReportRequest.scheme(oprot).write(oprot, (TReportRequest)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TReportRequest(");
        boolean first = true;
        sb.append("backend:");
        if (this.backend == null) {
            sb.append("null");
        } else {
            sb.append(this.backend);
        }
        first = false;
        if (this.isSetReportVersion()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("report_version:");
            sb.append(this.report_version);
            first = false;
        }
        if (this.isSetTasks()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("tasks:");
            if (this.tasks == null) {
                sb.append("null");
            } else {
                sb.append(this.tasks);
            }
            first = false;
        }
        if (this.isSetTablets()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("tablets:");
            if (this.tablets == null) {
                sb.append("null");
            } else {
                sb.append(this.tablets);
            }
            first = false;
        }
        if (this.isSetDisks()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("disks:");
            if (this.disks == null) {
                sb.append("null");
            } else {
                sb.append(this.disks);
            }
            first = false;
        }
        if (this.isSetForceRecovery()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("force_recovery:");
            sb.append(this.force_recovery);
            first = false;
        }
        if (this.isSetTabletList()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("tablet_list:");
            if (this.tablet_list == null) {
                sb.append("null");
            } else {
                sb.append(this.tablet_list);
            }
            first = false;
        }
        if (this.isSetTabletMaxCompactionScore()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("tablet_max_compaction_score:");
            sb.append(this.tablet_max_compaction_score);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.backend == null) {
            throw new TProtocolException("Required field 'backend' was not present! Struct: " + this.toString());
        }
        if (this.backend != null) {
            this.backend.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.BACKEND, new FieldMetaData("backend", 1, new StructMetaData(12, TBackend.class)));
        tmpMap.put(_Fields.REPORT_VERSION, new FieldMetaData("report_version", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.TASKS, new FieldMetaData("tasks", 2, new MapMetaData(13, new EnumMetaData(16, TTaskType.class), new SetMetaData(14, new FieldValueMetaData(10)))));
        tmpMap.put(_Fields.TABLETS, new FieldMetaData("tablets", 2, new MapMetaData(13, new FieldValueMetaData(10, "TTabletId"), new StructMetaData(12, TTablet.class))));
        tmpMap.put(_Fields.DISKS, new FieldMetaData("disks", 2, new MapMetaData(13, new FieldValueMetaData(11), new StructMetaData(12, TDisk.class))));
        tmpMap.put(_Fields.FORCE_RECOVERY, new FieldMetaData("force_recovery", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.TABLET_LIST, new FieldMetaData("tablet_list", 2, new ListMetaData(15, new StructMetaData(12, TTablet.class))));
        tmpMap.put(_Fields.TABLET_MAX_COMPACTION_SCORE, new FieldMetaData("tablet_max_compaction_score", 2, new FieldValueMetaData(10)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TReportRequest.class, metaDataMap);
    }

    private static class TReportRequestTupleScheme
    extends TupleScheme<TReportRequest> {
        private TReportRequestTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, TReportRequest struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            struct.backend.write(oprot);
            BitSet optionals = new BitSet();
            if (struct.isSetReportVersion()) {
                optionals.set(0);
            }
            if (struct.isSetTasks()) {
                optionals.set(1);
            }
            if (struct.isSetTablets()) {
                optionals.set(2);
            }
            if (struct.isSetDisks()) {
                optionals.set(3);
            }
            if (struct.isSetForceRecovery()) {
                optionals.set(4);
            }
            if (struct.isSetTabletList()) {
                optionals.set(5);
            }
            if (struct.isSetTabletMaxCompactionScore()) {
                optionals.set(6);
            }
            oprot.writeBitSet(optionals, 7);
            if (struct.isSetReportVersion()) {
                oprot.writeI64(struct.report_version);
            }
            if (struct.isSetTasks()) {
                oprot.writeI32(struct.tasks.size());
                for (Map.Entry<Object, Object> entry : struct.tasks.entrySet()) {
                    oprot.writeI32(((TTaskType)entry.getKey()).getValue());
                    oprot.writeI32(((Set)entry.getValue()).size());
                    Iterator iterator2 = ((Set)entry.getValue()).iterator();
                    while (iterator2.hasNext()) {
                        long _iter90 = (Long)iterator2.next();
                        oprot.writeI64(_iter90);
                    }
                }
            }
            if (struct.isSetTablets()) {
                oprot.writeI32(struct.tablets.size());
                for (Map.Entry<Object, Object> entry : struct.tablets.entrySet()) {
                    oprot.writeI64((Long)entry.getKey());
                    ((TTablet)entry.getValue()).write(oprot);
                }
            }
            if (struct.isSetDisks()) {
                oprot.writeI32(struct.disks.size());
                for (Map.Entry<Object, Object> entry : struct.disks.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    ((TDisk)entry.getValue()).write(oprot);
                }
            }
            if (struct.isSetForceRecovery()) {
                oprot.writeBool(struct.force_recovery);
            }
            if (struct.isSetTabletList()) {
                oprot.writeI32(struct.tablet_list.size());
                for (TTablet tTablet : struct.tablet_list) {
                    tTablet.write(oprot);
                }
            }
            if (struct.isSetTabletMaxCompactionScore()) {
                oprot.writeI64(struct.tablet_max_compaction_score);
            }
        }

        @Override
        public void read(TProtocol prot, TReportRequest struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.backend = new TBackend();
            struct.backend.read(iprot);
            struct.setBackendIsSet(true);
            BitSet incoming = iprot.readBitSet(7);
            if (incoming.get(0)) {
                struct.report_version = iprot.readI64();
                struct.setReportVersionIsSet(true);
            }
            if (incoming.get(1)) {
                TMap _map94 = new TMap(8, 14, iprot.readI32());
                struct.tasks = new EnumMap<TTaskType, Set<Long>>(TTaskType.class);
                for (int _i97 = 0; _i97 < _map94.size; ++_i97) {
                    TTaskType _key95 = TTaskType.findByValue(iprot.readI32());
                    TSet _set98 = new TSet(10, iprot.readI32());
                    HashSet<Long> _val96 = new HashSet<Long>(2 * _set98.size);
                    for (int _i100 = 0; _i100 < _set98.size; ++_i100) {
                        long _elem99 = iprot.readI64();
                        _val96.add(_elem99);
                    }
                    if (_key95 == null) continue;
                    struct.tasks.put(_key95, _val96);
                }
                struct.setTasksIsSet(true);
            }
            if (incoming.get(2)) {
                TMap _map101 = new TMap(10, 12, iprot.readI32());
                struct.tablets = new HashMap<Long, TTablet>(2 * _map101.size);
                for (int _i104 = 0; _i104 < _map101.size; ++_i104) {
                    long _key102 = iprot.readI64();
                    TTablet _val103 = new TTablet();
                    _val103.read(iprot);
                    struct.tablets.put(_key102, _val103);
                }
                struct.setTabletsIsSet(true);
            }
            if (incoming.get(3)) {
                TMap _map105 = new TMap(11, 12, iprot.readI32());
                struct.disks = new HashMap<String, TDisk>(2 * _map105.size);
                for (int _i108 = 0; _i108 < _map105.size; ++_i108) {
                    String _key106 = iprot.readString();
                    TDisk _val107 = new TDisk();
                    _val107.read(iprot);
                    struct.disks.put(_key106, _val107);
                }
                struct.setDisksIsSet(true);
            }
            if (incoming.get(4)) {
                struct.force_recovery = iprot.readBool();
                struct.setForceRecoveryIsSet(true);
            }
            if (incoming.get(5)) {
                TList _list109 = new TList(12, iprot.readI32());
                struct.tablet_list = new ArrayList<TTablet>(_list109.size);
                for (int _i111 = 0; _i111 < _list109.size; ++_i111) {
                    TTablet _elem110 = new TTablet();
                    _elem110.read(iprot);
                    struct.tablet_list.add(_elem110);
                }
                struct.setTabletListIsSet(true);
            }
            if (incoming.get(6)) {
                struct.tablet_max_compaction_score = iprot.readI64();
                struct.setTabletMaxCompactionScoreIsSet(true);
            }
        }
    }

    private static class TReportRequestTupleSchemeFactory
    implements SchemeFactory {
        private TReportRequestTupleSchemeFactory() {
        }

        public TReportRequestTupleScheme getScheme() {
            return new TReportRequestTupleScheme();
        }
    }

    private static class TReportRequestStandardScheme
    extends StandardScheme<TReportRequest> {
        private TReportRequestStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, TReportRequest struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 12) {
                            struct.backend = new TBackend();
                            struct.backend.read(iprot);
                            struct.setBackendIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 10) {
                            struct.report_version = iprot.readI64();
                            struct.setReportVersionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 13) {
                            TMap _map66 = iprot.readMapBegin();
                            struct.tasks = new EnumMap<TTaskType, Set<Long>>(TTaskType.class);
                            for (int _i69 = 0; _i69 < _map66.size; ++_i69) {
                                TTaskType _key67 = TTaskType.findByValue(iprot.readI32());
                                TSet _set70 = iprot.readSetBegin();
                                HashSet<Long> _val68 = new HashSet<Long>(2 * _set70.size);
                                for (int _i72 = 0; _i72 < _set70.size; ++_i72) {
                                    long _elem71 = iprot.readI64();
                                    _val68.add(_elem71);
                                }
                                iprot.readSetEnd();
                                if (_key67 == null) continue;
                                struct.tasks.put(_key67, _val68);
                            }
                            iprot.readMapEnd();
                            struct.setTasksIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 13) {
                            TMap _map73 = iprot.readMapBegin();
                            struct.tablets = new HashMap<Long, TTablet>(2 * _map73.size);
                            for (int _i76 = 0; _i76 < _map73.size; ++_i76) {
                                long _key74 = iprot.readI64();
                                TTablet _val75 = new TTablet();
                                _val75.read(iprot);
                                struct.tablets.put(_key74, _val75);
                            }
                            iprot.readMapEnd();
                            struct.setTabletsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 13) {
                            TMap _map77 = iprot.readMapBegin();
                            struct.disks = new HashMap<String, TDisk>(2 * _map77.size);
                            for (int _i80 = 0; _i80 < _map77.size; ++_i80) {
                                String _key78 = iprot.readString();
                                TDisk _val79 = new TDisk();
                                _val79.read(iprot);
                                struct.disks.put(_key78, _val79);
                            }
                            iprot.readMapEnd();
                            struct.setDisksIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 2) {
                            struct.force_recovery = iprot.readBool();
                            struct.setForceRecoveryIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 15) {
                            TList _list81 = iprot.readListBegin();
                            struct.tablet_list = new ArrayList<TTablet>(_list81.size);
                            for (int _i83 = 0; _i83 < _list81.size; ++_i83) {
                                TTablet _elem82 = new TTablet();
                                _elem82.read(iprot);
                                struct.tablet_list.add(_elem82);
                            }
                            iprot.readListEnd();
                            struct.setTabletListIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 10) {
                            struct.tablet_max_compaction_score = iprot.readI64();
                            struct.setTabletMaxCompactionScoreIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, TReportRequest struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.backend != null) {
                oprot.writeFieldBegin(BACKEND_FIELD_DESC);
                struct.backend.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.isSetReportVersion()) {
                oprot.writeFieldBegin(REPORT_VERSION_FIELD_DESC);
                oprot.writeI64(struct.report_version);
                oprot.writeFieldEnd();
            }
            if (struct.tasks != null && struct.isSetTasks()) {
                oprot.writeFieldBegin(TASKS_FIELD_DESC);
                oprot.writeMapBegin(new TMap(8, 14, struct.tasks.size()));
                for (Map.Entry<Object, Object> entry : struct.tasks.entrySet()) {
                    oprot.writeI32(((TTaskType)entry.getKey()).getValue());
                    oprot.writeSetBegin(new TSet(10, ((Set)entry.getValue()).size()));
                    Iterator iterator2 = ((Set)entry.getValue()).iterator();
                    while (iterator2.hasNext()) {
                        long _iter85 = (Long)iterator2.next();
                        oprot.writeI64(_iter85);
                    }
                    oprot.writeSetEnd();
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.tablets != null && struct.isSetTablets()) {
                oprot.writeFieldBegin(TABLETS_FIELD_DESC);
                oprot.writeMapBegin(new TMap(10, 12, struct.tablets.size()));
                for (Map.Entry<Object, Object> entry : struct.tablets.entrySet()) {
                    oprot.writeI64((Long)entry.getKey());
                    ((TTablet)entry.getValue()).write(oprot);
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.disks != null && struct.isSetDisks()) {
                oprot.writeFieldBegin(DISKS_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 12, struct.disks.size()));
                for (Map.Entry<Object, Object> entry : struct.disks.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    ((TDisk)entry.getValue()).write(oprot);
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.isSetForceRecovery()) {
                oprot.writeFieldBegin(FORCE_RECOVERY_FIELD_DESC);
                oprot.writeBool(struct.force_recovery);
                oprot.writeFieldEnd();
            }
            if (struct.tablet_list != null && struct.isSetTabletList()) {
                oprot.writeFieldBegin(TABLET_LIST_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.tablet_list.size()));
                for (TTablet tTablet : struct.tablet_list) {
                    tTablet.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.isSetTabletMaxCompactionScore()) {
                oprot.writeFieldBegin(TABLET_MAX_COMPACTION_SCORE_FIELD_DESC);
                oprot.writeI64(struct.tablet_max_compaction_score);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TReportRequestStandardSchemeFactory
    implements SchemeFactory {
        private TReportRequestStandardSchemeFactory() {
        }

        public TReportRequestStandardScheme getScheme() {
            return new TReportRequestStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        BACKEND(1, "backend"),
        REPORT_VERSION(2, "report_version"),
        TASKS(3, "tasks"),
        TABLETS(4, "tablets"),
        DISKS(5, "disks"),
        FORCE_RECOVERY(6, "force_recovery"),
        TABLET_LIST(7, "tablet_list"),
        TABLET_MAX_COMPACTION_SCORE(8, "tablet_max_compaction_score");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return BACKEND;
                }
                case 2: {
                    return REPORT_VERSION;
                }
                case 3: {
                    return TASKS;
                }
                case 4: {
                    return TABLETS;
                }
                case 5: {
                    return DISKS;
                }
                case 6: {
                    return FORCE_RECOVERY;
                }
                case 7: {
                    return TABLET_LIST;
                }
                case 8: {
                    return TABLET_MAX_COMPACTION_SCORE;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

