/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.thrift;

import org.apache.thrift.TEnum;
import org.apache.thrift.annotation.Nullable;

public enum TPaloQueryOptions implements TEnum
{
    ABORT_ON_ERROR(0),
    MAX_ERRORS(1),
    DISABLE_CODEGEN(2),
    BATCH_SIZE(3),
    MEM_LIMIT(4),
    NUM_NODES(5),
    MAX_SCAN_RANGE_LENGTH(6),
    MAX_IO_BUFFERS(7),
    NUM_SCANNER_THREADS(8),
    QUERY_TIMEOUT(9),
    ALLOW_UNSUPPORTED_FORMATS(10),
    DEFAULT_ORDER_BY_LIMIT(11),
    DEBUG_ACTION(12),
    ABORT_ON_DEFAULT_LIMIT_EXCEEDED(13),
    IS_REPORT_SUCCESS(14);

    private final int value;

    private TPaloQueryOptions(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Nullable
    public static TPaloQueryOptions findByValue(int value) {
        switch (value) {
            case 0: {
                return ABORT_ON_ERROR;
            }
            case 1: {
                return MAX_ERRORS;
            }
            case 2: {
                return DISABLE_CODEGEN;
            }
            case 3: {
                return BATCH_SIZE;
            }
            case 4: {
                return MEM_LIMIT;
            }
            case 5: {
                return NUM_NODES;
            }
            case 6: {
                return MAX_SCAN_RANGE_LENGTH;
            }
            case 7: {
                return MAX_IO_BUFFERS;
            }
            case 8: {
                return NUM_SCANNER_THREADS;
            }
            case 9: {
                return QUERY_TIMEOUT;
            }
            case 10: {
                return ALLOW_UNSUPPORTED_FORMATS;
            }
            case 11: {
                return DEFAULT_ORDER_BY_LIMIT;
            }
            case 12: {
                return DEBUG_ACTION;
            }
            case 13: {
                return ABORT_ON_DEFAULT_LIMIT_EXCEEDED;
            }
            case 14: {
                return IS_REPORT_SUCCESS;
            }
        }
        return null;
    }
}

