/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.thrift;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.doris.thrift.TBackend;
import org.apache.doris.thrift.TStatus;
import org.apache.doris.thrift.TTabletInfo;
import org.apache.doris.thrift.TTaskType;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;

public class TFinishTaskRequest
implements TBase<TFinishTaskRequest, _Fields>,
Serializable,
Cloneable,
Comparable<TFinishTaskRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("TFinishTaskRequest");
    private static final TField BACKEND_FIELD_DESC = new TField("backend", 12, 1);
    private static final TField TASK_TYPE_FIELD_DESC = new TField("task_type", 8, 2);
    private static final TField SIGNATURE_FIELD_DESC = new TField("signature", 10, 3);
    private static final TField TASK_STATUS_FIELD_DESC = new TField("task_status", 12, 4);
    private static final TField REPORT_VERSION_FIELD_DESC = new TField("report_version", 10, 5);
    private static final TField FINISH_TABLET_INFOS_FIELD_DESC = new TField("finish_tablet_infos", 15, 6);
    private static final TField TABLET_CHECKSUM_FIELD_DESC = new TField("tablet_checksum", 10, 7);
    private static final TField REQUEST_VERSION_FIELD_DESC = new TField("request_version", 10, 8);
    private static final TField REQUEST_VERSION_HASH_FIELD_DESC = new TField("request_version_hash", 10, 9);
    private static final TField SNAPSHOT_PATH_FIELD_DESC = new TField("snapshot_path", 11, 10);
    private static final TField ERROR_TABLET_IDS_FIELD_DESC = new TField("error_tablet_ids", 15, 11);
    private static final TField SNAPSHOT_FILES_FIELD_DESC = new TField("snapshot_files", 15, 12);
    private static final TField TABLET_FILES_FIELD_DESC = new TField("tablet_files", 13, 13);
    private static final TField DOWNLOADED_TABLET_IDS_FIELD_DESC = new TField("downloaded_tablet_ids", 15, 14);
    private static final TField COPY_SIZE_FIELD_DESC = new TField("copy_size", 10, 15);
    private static final TField COPY_TIME_MS_FIELD_DESC = new TField("copy_time_ms", 10, 16);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TFinishTaskRequestStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TFinishTaskRequestTupleSchemeFactory();
    @Nullable
    public TBackend backend;
    @Nullable
    public TTaskType task_type;
    public long signature;
    @Nullable
    public TStatus task_status;
    public long report_version;
    @Nullable
    public List<TTabletInfo> finish_tablet_infos;
    public long tablet_checksum;
    public long request_version;
    public long request_version_hash;
    @Nullable
    public String snapshot_path;
    @Nullable
    public List<Long> error_tablet_ids;
    @Nullable
    public List<String> snapshot_files;
    @Nullable
    public Map<Long, List<String>> tablet_files;
    @Nullable
    public List<Long> downloaded_tablet_ids;
    public long copy_size;
    public long copy_time_ms;
    private static final int __SIGNATURE_ISSET_ID = 0;
    private static final int __REPORT_VERSION_ISSET_ID = 1;
    private static final int __TABLET_CHECKSUM_ISSET_ID = 2;
    private static final int __REQUEST_VERSION_ISSET_ID = 3;
    private static final int __REQUEST_VERSION_HASH_ISSET_ID = 4;
    private static final int __COPY_SIZE_ISSET_ID = 5;
    private static final int __COPY_TIME_MS_ISSET_ID = 6;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.REPORT_VERSION, _Fields.FINISH_TABLET_INFOS, _Fields.TABLET_CHECKSUM, _Fields.REQUEST_VERSION, _Fields.REQUEST_VERSION_HASH, _Fields.SNAPSHOT_PATH, _Fields.ERROR_TABLET_IDS, _Fields.SNAPSHOT_FILES, _Fields.TABLET_FILES, _Fields.DOWNLOADED_TABLET_IDS, _Fields.COPY_SIZE, _Fields.COPY_TIME_MS};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TFinishTaskRequest() {
    }

    public TFinishTaskRequest(TBackend backend, TTaskType task_type, long signature, TStatus task_status) {
        this();
        this.backend = backend;
        this.task_type = task_type;
        this.signature = signature;
        this.setSignatureIsSet(true);
        this.task_status = task_status;
    }

    public TFinishTaskRequest(TFinishTaskRequest other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetBackend()) {
            this.backend = new TBackend(other.backend);
        }
        if (other.isSetTaskType()) {
            this.task_type = other.task_type;
        }
        this.signature = other.signature;
        if (other.isSetTaskStatus()) {
            this.task_status = new TStatus(other.task_status);
        }
        this.report_version = other.report_version;
        if (other.isSetFinishTabletInfos()) {
            ArrayList<TTabletInfo> __this__finish_tablet_infos = new ArrayList<TTabletInfo>(other.finish_tablet_infos.size());
            for (TTabletInfo tTabletInfo : other.finish_tablet_infos) {
                __this__finish_tablet_infos.add(new TTabletInfo(tTabletInfo));
            }
            this.finish_tablet_infos = __this__finish_tablet_infos;
        }
        this.tablet_checksum = other.tablet_checksum;
        this.request_version = other.request_version;
        this.request_version_hash = other.request_version_hash;
        if (other.isSetSnapshotPath()) {
            this.snapshot_path = other.snapshot_path;
        }
        if (other.isSetErrorTabletIds()) {
            ArrayList<Long> __this__error_tablet_ids = new ArrayList<Long>(other.error_tablet_ids.size());
            for (Long l : other.error_tablet_ids) {
                __this__error_tablet_ids.add(l);
            }
            this.error_tablet_ids = __this__error_tablet_ids;
        }
        if (other.isSetSnapshotFiles()) {
            ArrayList<String> __this__snapshot_files = new ArrayList<String>(other.snapshot_files);
            this.snapshot_files = __this__snapshot_files;
        }
        if (other.isSetTabletFiles()) {
            HashMap<Long, List<String>> __this__tablet_files = new HashMap<Long, List<String>>(other.tablet_files.size());
            for (Map.Entry entry : other.tablet_files.entrySet()) {
                Long other_element_key = (Long)entry.getKey();
                List other_element_value = (List)entry.getValue();
                Long __this__tablet_files_copy_key = other_element_key;
                ArrayList __this__tablet_files_copy_value = new ArrayList(other_element_value);
                __this__tablet_files.put(__this__tablet_files_copy_key, __this__tablet_files_copy_value);
            }
            this.tablet_files = __this__tablet_files;
        }
        if (other.isSetDownloadedTabletIds()) {
            ArrayList<Long> __this__downloaded_tablet_ids = new ArrayList<Long>(other.downloaded_tablet_ids.size());
            for (Long l : other.downloaded_tablet_ids) {
                __this__downloaded_tablet_ids.add(l);
            }
            this.downloaded_tablet_ids = __this__downloaded_tablet_ids;
        }
        this.copy_size = other.copy_size;
        this.copy_time_ms = other.copy_time_ms;
    }

    @Override
    public TFinishTaskRequest deepCopy() {
        return new TFinishTaskRequest(this);
    }

    @Override
    public void clear() {
        this.backend = null;
        this.task_type = null;
        this.setSignatureIsSet(false);
        this.signature = 0L;
        this.task_status = null;
        this.setReportVersionIsSet(false);
        this.report_version = 0L;
        this.finish_tablet_infos = null;
        this.setTabletChecksumIsSet(false);
        this.tablet_checksum = 0L;
        this.setRequestVersionIsSet(false);
        this.request_version = 0L;
        this.setRequestVersionHashIsSet(false);
        this.request_version_hash = 0L;
        this.snapshot_path = null;
        this.error_tablet_ids = null;
        this.snapshot_files = null;
        this.tablet_files = null;
        this.downloaded_tablet_ids = null;
        this.setCopySizeIsSet(false);
        this.copy_size = 0L;
        this.setCopyTimeMsIsSet(false);
        this.copy_time_ms = 0L;
    }

    @Nullable
    public TBackend getBackend() {
        return this.backend;
    }

    public TFinishTaskRequest setBackend(@Nullable TBackend backend) {
        this.backend = backend;
        return this;
    }

    public void unsetBackend() {
        this.backend = null;
    }

    public boolean isSetBackend() {
        return this.backend != null;
    }

    public void setBackendIsSet(boolean value) {
        if (!value) {
            this.backend = null;
        }
    }

    @Nullable
    public TTaskType getTaskType() {
        return this.task_type;
    }

    public TFinishTaskRequest setTaskType(@Nullable TTaskType task_type) {
        this.task_type = task_type;
        return this;
    }

    public void unsetTaskType() {
        this.task_type = null;
    }

    public boolean isSetTaskType() {
        return this.task_type != null;
    }

    public void setTaskTypeIsSet(boolean value) {
        if (!value) {
            this.task_type = null;
        }
    }

    public long getSignature() {
        return this.signature;
    }

    public TFinishTaskRequest setSignature(long signature) {
        this.signature = signature;
        this.setSignatureIsSet(true);
        return this;
    }

    public void unsetSignature() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 0);
    }

    public boolean isSetSignature() {
        return EncodingUtils.testBit(this.__isset_bitfield, 0);
    }

    public void setSignatureIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 0, value);
    }

    @Nullable
    public TStatus getTaskStatus() {
        return this.task_status;
    }

    public TFinishTaskRequest setTaskStatus(@Nullable TStatus task_status) {
        this.task_status = task_status;
        return this;
    }

    public void unsetTaskStatus() {
        this.task_status = null;
    }

    public boolean isSetTaskStatus() {
        return this.task_status != null;
    }

    public void setTaskStatusIsSet(boolean value) {
        if (!value) {
            this.task_status = null;
        }
    }

    public long getReportVersion() {
        return this.report_version;
    }

    public TFinishTaskRequest setReportVersion(long report_version) {
        this.report_version = report_version;
        this.setReportVersionIsSet(true);
        return this;
    }

    public void unsetReportVersion() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 1);
    }

    public boolean isSetReportVersion() {
        return EncodingUtils.testBit(this.__isset_bitfield, 1);
    }

    public void setReportVersionIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 1, value);
    }

    public int getFinishTabletInfosSize() {
        return this.finish_tablet_infos == null ? 0 : this.finish_tablet_infos.size();
    }

    @Nullable
    public Iterator<TTabletInfo> getFinishTabletInfosIterator() {
        return this.finish_tablet_infos == null ? null : this.finish_tablet_infos.iterator();
    }

    public void addToFinishTabletInfos(TTabletInfo elem) {
        if (this.finish_tablet_infos == null) {
            this.finish_tablet_infos = new ArrayList<TTabletInfo>();
        }
        this.finish_tablet_infos.add(elem);
    }

    @Nullable
    public List<TTabletInfo> getFinishTabletInfos() {
        return this.finish_tablet_infos;
    }

    public TFinishTaskRequest setFinishTabletInfos(@Nullable List<TTabletInfo> finish_tablet_infos) {
        this.finish_tablet_infos = finish_tablet_infos;
        return this;
    }

    public void unsetFinishTabletInfos() {
        this.finish_tablet_infos = null;
    }

    public boolean isSetFinishTabletInfos() {
        return this.finish_tablet_infos != null;
    }

    public void setFinishTabletInfosIsSet(boolean value) {
        if (!value) {
            this.finish_tablet_infos = null;
        }
    }

    public long getTabletChecksum() {
        return this.tablet_checksum;
    }

    public TFinishTaskRequest setTabletChecksum(long tablet_checksum) {
        this.tablet_checksum = tablet_checksum;
        this.setTabletChecksumIsSet(true);
        return this;
    }

    public void unsetTabletChecksum() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 2);
    }

    public boolean isSetTabletChecksum() {
        return EncodingUtils.testBit(this.__isset_bitfield, 2);
    }

    public void setTabletChecksumIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 2, value);
    }

    public long getRequestVersion() {
        return this.request_version;
    }

    public TFinishTaskRequest setRequestVersion(long request_version) {
        this.request_version = request_version;
        this.setRequestVersionIsSet(true);
        return this;
    }

    public void unsetRequestVersion() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 3);
    }

    public boolean isSetRequestVersion() {
        return EncodingUtils.testBit(this.__isset_bitfield, 3);
    }

    public void setRequestVersionIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 3, value);
    }

    public long getRequestVersionHash() {
        return this.request_version_hash;
    }

    public TFinishTaskRequest setRequestVersionHash(long request_version_hash) {
        this.request_version_hash = request_version_hash;
        this.setRequestVersionHashIsSet(true);
        return this;
    }

    public void unsetRequestVersionHash() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 4);
    }

    public boolean isSetRequestVersionHash() {
        return EncodingUtils.testBit(this.__isset_bitfield, 4);
    }

    public void setRequestVersionHashIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 4, value);
    }

    @Nullable
    public String getSnapshotPath() {
        return this.snapshot_path;
    }

    public TFinishTaskRequest setSnapshotPath(@Nullable String snapshot_path) {
        this.snapshot_path = snapshot_path;
        return this;
    }

    public void unsetSnapshotPath() {
        this.snapshot_path = null;
    }

    public boolean isSetSnapshotPath() {
        return this.snapshot_path != null;
    }

    public void setSnapshotPathIsSet(boolean value) {
        if (!value) {
            this.snapshot_path = null;
        }
    }

    public int getErrorTabletIdsSize() {
        return this.error_tablet_ids == null ? 0 : this.error_tablet_ids.size();
    }

    @Nullable
    public Iterator<Long> getErrorTabletIdsIterator() {
        return this.error_tablet_ids == null ? null : this.error_tablet_ids.iterator();
    }

    public void addToErrorTabletIds(long elem) {
        if (this.error_tablet_ids == null) {
            this.error_tablet_ids = new ArrayList<Long>();
        }
        this.error_tablet_ids.add(elem);
    }

    @Nullable
    public List<Long> getErrorTabletIds() {
        return this.error_tablet_ids;
    }

    public TFinishTaskRequest setErrorTabletIds(@Nullable List<Long> error_tablet_ids) {
        this.error_tablet_ids = error_tablet_ids;
        return this;
    }

    public void unsetErrorTabletIds() {
        this.error_tablet_ids = null;
    }

    public boolean isSetErrorTabletIds() {
        return this.error_tablet_ids != null;
    }

    public void setErrorTabletIdsIsSet(boolean value) {
        if (!value) {
            this.error_tablet_ids = null;
        }
    }

    public int getSnapshotFilesSize() {
        return this.snapshot_files == null ? 0 : this.snapshot_files.size();
    }

    @Nullable
    public Iterator<String> getSnapshotFilesIterator() {
        return this.snapshot_files == null ? null : this.snapshot_files.iterator();
    }

    public void addToSnapshotFiles(String elem) {
        if (this.snapshot_files == null) {
            this.snapshot_files = new ArrayList<String>();
        }
        this.snapshot_files.add(elem);
    }

    @Nullable
    public List<String> getSnapshotFiles() {
        return this.snapshot_files;
    }

    public TFinishTaskRequest setSnapshotFiles(@Nullable List<String> snapshot_files) {
        this.snapshot_files = snapshot_files;
        return this;
    }

    public void unsetSnapshotFiles() {
        this.snapshot_files = null;
    }

    public boolean isSetSnapshotFiles() {
        return this.snapshot_files != null;
    }

    public void setSnapshotFilesIsSet(boolean value) {
        if (!value) {
            this.snapshot_files = null;
        }
    }

    public int getTabletFilesSize() {
        return this.tablet_files == null ? 0 : this.tablet_files.size();
    }

    public void putToTabletFiles(long key, List<String> val) {
        if (this.tablet_files == null) {
            this.tablet_files = new HashMap<Long, List<String>>();
        }
        this.tablet_files.put(key, val);
    }

    @Nullable
    public Map<Long, List<String>> getTabletFiles() {
        return this.tablet_files;
    }

    public TFinishTaskRequest setTabletFiles(@Nullable Map<Long, List<String>> tablet_files) {
        this.tablet_files = tablet_files;
        return this;
    }

    public void unsetTabletFiles() {
        this.tablet_files = null;
    }

    public boolean isSetTabletFiles() {
        return this.tablet_files != null;
    }

    public void setTabletFilesIsSet(boolean value) {
        if (!value) {
            this.tablet_files = null;
        }
    }

    public int getDownloadedTabletIdsSize() {
        return this.downloaded_tablet_ids == null ? 0 : this.downloaded_tablet_ids.size();
    }

    @Nullable
    public Iterator<Long> getDownloadedTabletIdsIterator() {
        return this.downloaded_tablet_ids == null ? null : this.downloaded_tablet_ids.iterator();
    }

    public void addToDownloadedTabletIds(long elem) {
        if (this.downloaded_tablet_ids == null) {
            this.downloaded_tablet_ids = new ArrayList<Long>();
        }
        this.downloaded_tablet_ids.add(elem);
    }

    @Nullable
    public List<Long> getDownloadedTabletIds() {
        return this.downloaded_tablet_ids;
    }

    public TFinishTaskRequest setDownloadedTabletIds(@Nullable List<Long> downloaded_tablet_ids) {
        this.downloaded_tablet_ids = downloaded_tablet_ids;
        return this;
    }

    public void unsetDownloadedTabletIds() {
        this.downloaded_tablet_ids = null;
    }

    public boolean isSetDownloadedTabletIds() {
        return this.downloaded_tablet_ids != null;
    }

    public void setDownloadedTabletIdsIsSet(boolean value) {
        if (!value) {
            this.downloaded_tablet_ids = null;
        }
    }

    public long getCopySize() {
        return this.copy_size;
    }

    public TFinishTaskRequest setCopySize(long copy_size) {
        this.copy_size = copy_size;
        this.setCopySizeIsSet(true);
        return this;
    }

    public void unsetCopySize() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 5);
    }

    public boolean isSetCopySize() {
        return EncodingUtils.testBit(this.__isset_bitfield, 5);
    }

    public void setCopySizeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 5, value);
    }

    public long getCopyTimeMs() {
        return this.copy_time_ms;
    }

    public TFinishTaskRequest setCopyTimeMs(long copy_time_ms) {
        this.copy_time_ms = copy_time_ms;
        this.setCopyTimeMsIsSet(true);
        return this;
    }

    public void unsetCopyTimeMs() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 6);
    }

    public boolean isSetCopyTimeMs() {
        return EncodingUtils.testBit(this.__isset_bitfield, 6);
    }

    public void setCopyTimeMsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 6, value);
    }

    @Override
    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case BACKEND: {
                if (value == null) {
                    this.unsetBackend();
                    break;
                }
                this.setBackend((TBackend)value);
                break;
            }
            case TASK_TYPE: {
                if (value == null) {
                    this.unsetTaskType();
                    break;
                }
                this.setTaskType((TTaskType)value);
                break;
            }
            case SIGNATURE: {
                if (value == null) {
                    this.unsetSignature();
                    break;
                }
                this.setSignature((Long)value);
                break;
            }
            case TASK_STATUS: {
                if (value == null) {
                    this.unsetTaskStatus();
                    break;
                }
                this.setTaskStatus((TStatus)value);
                break;
            }
            case REPORT_VERSION: {
                if (value == null) {
                    this.unsetReportVersion();
                    break;
                }
                this.setReportVersion((Long)value);
                break;
            }
            case FINISH_TABLET_INFOS: {
                if (value == null) {
                    this.unsetFinishTabletInfos();
                    break;
                }
                this.setFinishTabletInfos((List)value);
                break;
            }
            case TABLET_CHECKSUM: {
                if (value == null) {
                    this.unsetTabletChecksum();
                    break;
                }
                this.setTabletChecksum((Long)value);
                break;
            }
            case REQUEST_VERSION: {
                if (value == null) {
                    this.unsetRequestVersion();
                    break;
                }
                this.setRequestVersion((Long)value);
                break;
            }
            case REQUEST_VERSION_HASH: {
                if (value == null) {
                    this.unsetRequestVersionHash();
                    break;
                }
                this.setRequestVersionHash((Long)value);
                break;
            }
            case SNAPSHOT_PATH: {
                if (value == null) {
                    this.unsetSnapshotPath();
                    break;
                }
                this.setSnapshotPath((String)value);
                break;
            }
            case ERROR_TABLET_IDS: {
                if (value == null) {
                    this.unsetErrorTabletIds();
                    break;
                }
                this.setErrorTabletIds((List)value);
                break;
            }
            case SNAPSHOT_FILES: {
                if (value == null) {
                    this.unsetSnapshotFiles();
                    break;
                }
                this.setSnapshotFiles((List)value);
                break;
            }
            case TABLET_FILES: {
                if (value == null) {
                    this.unsetTabletFiles();
                    break;
                }
                this.setTabletFiles((Map)value);
                break;
            }
            case DOWNLOADED_TABLET_IDS: {
                if (value == null) {
                    this.unsetDownloadedTabletIds();
                    break;
                }
                this.setDownloadedTabletIds((List)value);
                break;
            }
            case COPY_SIZE: {
                if (value == null) {
                    this.unsetCopySize();
                    break;
                }
                this.setCopySize((Long)value);
                break;
            }
            case COPY_TIME_MS: {
                if (value == null) {
                    this.unsetCopyTimeMs();
                    break;
                }
                this.setCopyTimeMs((Long)value);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case BACKEND: {
                return this.getBackend();
            }
            case TASK_TYPE: {
                return this.getTaskType();
            }
            case SIGNATURE: {
                return this.getSignature();
            }
            case TASK_STATUS: {
                return this.getTaskStatus();
            }
            case REPORT_VERSION: {
                return this.getReportVersion();
            }
            case FINISH_TABLET_INFOS: {
                return this.getFinishTabletInfos();
            }
            case TABLET_CHECKSUM: {
                return this.getTabletChecksum();
            }
            case REQUEST_VERSION: {
                return this.getRequestVersion();
            }
            case REQUEST_VERSION_HASH: {
                return this.getRequestVersionHash();
            }
            case SNAPSHOT_PATH: {
                return this.getSnapshotPath();
            }
            case ERROR_TABLET_IDS: {
                return this.getErrorTabletIds();
            }
            case SNAPSHOT_FILES: {
                return this.getSnapshotFiles();
            }
            case TABLET_FILES: {
                return this.getTabletFiles();
            }
            case DOWNLOADED_TABLET_IDS: {
                return this.getDownloadedTabletIds();
            }
            case COPY_SIZE: {
                return this.getCopySize();
            }
            case COPY_TIME_MS: {
                return this.getCopyTimeMs();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case BACKEND: {
                return this.isSetBackend();
            }
            case TASK_TYPE: {
                return this.isSetTaskType();
            }
            case SIGNATURE: {
                return this.isSetSignature();
            }
            case TASK_STATUS: {
                return this.isSetTaskStatus();
            }
            case REPORT_VERSION: {
                return this.isSetReportVersion();
            }
            case FINISH_TABLET_INFOS: {
                return this.isSetFinishTabletInfos();
            }
            case TABLET_CHECKSUM: {
                return this.isSetTabletChecksum();
            }
            case REQUEST_VERSION: {
                return this.isSetRequestVersion();
            }
            case REQUEST_VERSION_HASH: {
                return this.isSetRequestVersionHash();
            }
            case SNAPSHOT_PATH: {
                return this.isSetSnapshotPath();
            }
            case ERROR_TABLET_IDS: {
                return this.isSetErrorTabletIds();
            }
            case SNAPSHOT_FILES: {
                return this.isSetSnapshotFiles();
            }
            case TABLET_FILES: {
                return this.isSetTabletFiles();
            }
            case DOWNLOADED_TABLET_IDS: {
                return this.isSetDownloadedTabletIds();
            }
            case COPY_SIZE: {
                return this.isSetCopySize();
            }
            case COPY_TIME_MS: {
                return this.isSetCopyTimeMs();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TFinishTaskRequest) {
            return this.equals((TFinishTaskRequest)that);
        }
        return false;
    }

    public boolean equals(TFinishTaskRequest that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_backend = this.isSetBackend();
        boolean that_present_backend = that.isSetBackend();
        if (this_present_backend || that_present_backend) {
            if (!this_present_backend || !that_present_backend) {
                return false;
            }
            if (!this.backend.equals(that.backend)) {
                return false;
            }
        }
        boolean this_present_task_type = this.isSetTaskType();
        boolean that_present_task_type = that.isSetTaskType();
        if (this_present_task_type || that_present_task_type) {
            if (!this_present_task_type || !that_present_task_type) {
                return false;
            }
            if (!this.task_type.equals(that.task_type)) {
                return false;
            }
        }
        boolean this_present_signature = true;
        boolean that_present_signature = true;
        if (this_present_signature || that_present_signature) {
            if (!this_present_signature || !that_present_signature) {
                return false;
            }
            if (this.signature != that.signature) {
                return false;
            }
        }
        boolean this_present_task_status = this.isSetTaskStatus();
        boolean that_present_task_status = that.isSetTaskStatus();
        if (this_present_task_status || that_present_task_status) {
            if (!this_present_task_status || !that_present_task_status) {
                return false;
            }
            if (!this.task_status.equals(that.task_status)) {
                return false;
            }
        }
        boolean this_present_report_version = this.isSetReportVersion();
        boolean that_present_report_version = that.isSetReportVersion();
        if (this_present_report_version || that_present_report_version) {
            if (!this_present_report_version || !that_present_report_version) {
                return false;
            }
            if (this.report_version != that.report_version) {
                return false;
            }
        }
        boolean this_present_finish_tablet_infos = this.isSetFinishTabletInfos();
        boolean that_present_finish_tablet_infos = that.isSetFinishTabletInfos();
        if (this_present_finish_tablet_infos || that_present_finish_tablet_infos) {
            if (!this_present_finish_tablet_infos || !that_present_finish_tablet_infos) {
                return false;
            }
            if (!this.finish_tablet_infos.equals(that.finish_tablet_infos)) {
                return false;
            }
        }
        boolean this_present_tablet_checksum = this.isSetTabletChecksum();
        boolean that_present_tablet_checksum = that.isSetTabletChecksum();
        if (this_present_tablet_checksum || that_present_tablet_checksum) {
            if (!this_present_tablet_checksum || !that_present_tablet_checksum) {
                return false;
            }
            if (this.tablet_checksum != that.tablet_checksum) {
                return false;
            }
        }
        boolean this_present_request_version = this.isSetRequestVersion();
        boolean that_present_request_version = that.isSetRequestVersion();
        if (this_present_request_version || that_present_request_version) {
            if (!this_present_request_version || !that_present_request_version) {
                return false;
            }
            if (this.request_version != that.request_version) {
                return false;
            }
        }
        boolean this_present_request_version_hash = this.isSetRequestVersionHash();
        boolean that_present_request_version_hash = that.isSetRequestVersionHash();
        if (this_present_request_version_hash || that_present_request_version_hash) {
            if (!this_present_request_version_hash || !that_present_request_version_hash) {
                return false;
            }
            if (this.request_version_hash != that.request_version_hash) {
                return false;
            }
        }
        boolean this_present_snapshot_path = this.isSetSnapshotPath();
        boolean that_present_snapshot_path = that.isSetSnapshotPath();
        if (this_present_snapshot_path || that_present_snapshot_path) {
            if (!this_present_snapshot_path || !that_present_snapshot_path) {
                return false;
            }
            if (!this.snapshot_path.equals(that.snapshot_path)) {
                return false;
            }
        }
        boolean this_present_error_tablet_ids = this.isSetErrorTabletIds();
        boolean that_present_error_tablet_ids = that.isSetErrorTabletIds();
        if (this_present_error_tablet_ids || that_present_error_tablet_ids) {
            if (!this_present_error_tablet_ids || !that_present_error_tablet_ids) {
                return false;
            }
            if (!this.error_tablet_ids.equals(that.error_tablet_ids)) {
                return false;
            }
        }
        boolean this_present_snapshot_files = this.isSetSnapshotFiles();
        boolean that_present_snapshot_files = that.isSetSnapshotFiles();
        if (this_present_snapshot_files || that_present_snapshot_files) {
            if (!this_present_snapshot_files || !that_present_snapshot_files) {
                return false;
            }
            if (!this.snapshot_files.equals(that.snapshot_files)) {
                return false;
            }
        }
        boolean this_present_tablet_files = this.isSetTabletFiles();
        boolean that_present_tablet_files = that.isSetTabletFiles();
        if (this_present_tablet_files || that_present_tablet_files) {
            if (!this_present_tablet_files || !that_present_tablet_files) {
                return false;
            }
            if (!this.tablet_files.equals(that.tablet_files)) {
                return false;
            }
        }
        boolean this_present_downloaded_tablet_ids = this.isSetDownloadedTabletIds();
        boolean that_present_downloaded_tablet_ids = that.isSetDownloadedTabletIds();
        if (this_present_downloaded_tablet_ids || that_present_downloaded_tablet_ids) {
            if (!this_present_downloaded_tablet_ids || !that_present_downloaded_tablet_ids) {
                return false;
            }
            if (!this.downloaded_tablet_ids.equals(that.downloaded_tablet_ids)) {
                return false;
            }
        }
        boolean this_present_copy_size = this.isSetCopySize();
        boolean that_present_copy_size = that.isSetCopySize();
        if (this_present_copy_size || that_present_copy_size) {
            if (!this_present_copy_size || !that_present_copy_size) {
                return false;
            }
            if (this.copy_size != that.copy_size) {
                return false;
            }
        }
        boolean this_present_copy_time_ms = this.isSetCopyTimeMs();
        boolean that_present_copy_time_ms = that.isSetCopyTimeMs();
        if (this_present_copy_time_ms || that_present_copy_time_ms) {
            if (!this_present_copy_time_ms || !that_present_copy_time_ms) {
                return false;
            }
            if (this.copy_time_ms != that.copy_time_ms) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetBackend() ? 131071 : 524287);
        if (this.isSetBackend()) {
            hashCode = hashCode * 8191 + this.backend.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTaskType() ? 131071 : 524287);
        if (this.isSetTaskType()) {
            hashCode = hashCode * 8191 + this.task_type.getValue();
        }
        hashCode = hashCode * 8191 + TBaseHelper.hashCode(this.signature);
        hashCode = hashCode * 8191 + (this.isSetTaskStatus() ? 131071 : 524287);
        if (this.isSetTaskStatus()) {
            hashCode = hashCode * 8191 + this.task_status.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetReportVersion() ? 131071 : 524287);
        if (this.isSetReportVersion()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode(this.report_version);
        }
        hashCode = hashCode * 8191 + (this.isSetFinishTabletInfos() ? 131071 : 524287);
        if (this.isSetFinishTabletInfos()) {
            hashCode = hashCode * 8191 + this.finish_tablet_infos.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTabletChecksum() ? 131071 : 524287);
        if (this.isSetTabletChecksum()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode(this.tablet_checksum);
        }
        hashCode = hashCode * 8191 + (this.isSetRequestVersion() ? 131071 : 524287);
        if (this.isSetRequestVersion()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode(this.request_version);
        }
        hashCode = hashCode * 8191 + (this.isSetRequestVersionHash() ? 131071 : 524287);
        if (this.isSetRequestVersionHash()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode(this.request_version_hash);
        }
        hashCode = hashCode * 8191 + (this.isSetSnapshotPath() ? 131071 : 524287);
        if (this.isSetSnapshotPath()) {
            hashCode = hashCode * 8191 + this.snapshot_path.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetErrorTabletIds() ? 131071 : 524287);
        if (this.isSetErrorTabletIds()) {
            hashCode = hashCode * 8191 + this.error_tablet_ids.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetSnapshotFiles() ? 131071 : 524287);
        if (this.isSetSnapshotFiles()) {
            hashCode = hashCode * 8191 + this.snapshot_files.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTabletFiles() ? 131071 : 524287);
        if (this.isSetTabletFiles()) {
            hashCode = hashCode * 8191 + this.tablet_files.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetDownloadedTabletIds() ? 131071 : 524287);
        if (this.isSetDownloadedTabletIds()) {
            hashCode = hashCode * 8191 + this.downloaded_tablet_ids.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetCopySize() ? 131071 : 524287);
        if (this.isSetCopySize()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode(this.copy_size);
        }
        hashCode = hashCode * 8191 + (this.isSetCopyTimeMs() ? 131071 : 524287);
        if (this.isSetCopyTimeMs()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode(this.copy_time_ms);
        }
        return hashCode;
    }

    @Override
    public int compareTo(TFinishTaskRequest other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetBackend()).compareTo(other.isSetBackend());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBackend() && (lastComparison = TBaseHelper.compareTo(this.backend, other.backend)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTaskType()).compareTo(other.isSetTaskType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTaskType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.task_type), (Comparable)((Object)other.task_type))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSignature()).compareTo(other.isSetSignature());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSignature() && (lastComparison = TBaseHelper.compareTo(this.signature, other.signature)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTaskStatus()).compareTo(other.isSetTaskStatus());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTaskStatus() && (lastComparison = TBaseHelper.compareTo(this.task_status, other.task_status)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetReportVersion()).compareTo(other.isSetReportVersion());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetReportVersion() && (lastComparison = TBaseHelper.compareTo(this.report_version, other.report_version)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetFinishTabletInfos()).compareTo(other.isSetFinishTabletInfos());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFinishTabletInfos() && (lastComparison = TBaseHelper.compareTo(this.finish_tablet_infos, other.finish_tablet_infos)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTabletChecksum()).compareTo(other.isSetTabletChecksum());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTabletChecksum() && (lastComparison = TBaseHelper.compareTo(this.tablet_checksum, other.tablet_checksum)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRequestVersion()).compareTo(other.isSetRequestVersion());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRequestVersion() && (lastComparison = TBaseHelper.compareTo(this.request_version, other.request_version)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRequestVersionHash()).compareTo(other.isSetRequestVersionHash());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRequestVersionHash() && (lastComparison = TBaseHelper.compareTo(this.request_version_hash, other.request_version_hash)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSnapshotPath()).compareTo(other.isSetSnapshotPath());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSnapshotPath() && (lastComparison = TBaseHelper.compareTo(this.snapshot_path, other.snapshot_path)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetErrorTabletIds()).compareTo(other.isSetErrorTabletIds());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetErrorTabletIds() && (lastComparison = TBaseHelper.compareTo(this.error_tablet_ids, other.error_tablet_ids)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSnapshotFiles()).compareTo(other.isSetSnapshotFiles());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSnapshotFiles() && (lastComparison = TBaseHelper.compareTo(this.snapshot_files, other.snapshot_files)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTabletFiles()).compareTo(other.isSetTabletFiles());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTabletFiles() && (lastComparison = TBaseHelper.compareTo(this.tablet_files, other.tablet_files)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDownloadedTabletIds()).compareTo(other.isSetDownloadedTabletIds());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDownloadedTabletIds() && (lastComparison = TBaseHelper.compareTo(this.downloaded_tablet_ids, other.downloaded_tablet_ids)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCopySize()).compareTo(other.isSetCopySize());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCopySize() && (lastComparison = TBaseHelper.compareTo(this.copy_size, other.copy_size)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetCopyTimeMs()).compareTo(other.isSetCopyTimeMs());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCopyTimeMs() && (lastComparison = TBaseHelper.compareTo(this.copy_time_ms, other.copy_time_ms)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        TFinishTaskRequest.scheme(iprot).read(iprot, (TFinishTaskRequest)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        TFinishTaskRequest.scheme(oprot).write(oprot, (TFinishTaskRequest)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TFinishTaskRequest(");
        boolean first = true;
        sb.append("backend:");
        if (this.backend == null) {
            sb.append("null");
        } else {
            sb.append(this.backend);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("task_type:");
        if (this.task_type == null) {
            sb.append("null");
        } else {
            sb.append(this.task_type);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("signature:");
        sb.append(this.signature);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("task_status:");
        if (this.task_status == null) {
            sb.append("null");
        } else {
            sb.append(this.task_status);
        }
        first = false;
        if (this.isSetReportVersion()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("report_version:");
            sb.append(this.report_version);
            first = false;
        }
        if (this.isSetFinishTabletInfos()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("finish_tablet_infos:");
            if (this.finish_tablet_infos == null) {
                sb.append("null");
            } else {
                sb.append(this.finish_tablet_infos);
            }
            first = false;
        }
        if (this.isSetTabletChecksum()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("tablet_checksum:");
            sb.append(this.tablet_checksum);
            first = false;
        }
        if (this.isSetRequestVersion()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("request_version:");
            sb.append(this.request_version);
            first = false;
        }
        if (this.isSetRequestVersionHash()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("request_version_hash:");
            sb.append(this.request_version_hash);
            first = false;
        }
        if (this.isSetSnapshotPath()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("snapshot_path:");
            if (this.snapshot_path == null) {
                sb.append("null");
            } else {
                sb.append(this.snapshot_path);
            }
            first = false;
        }
        if (this.isSetErrorTabletIds()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("error_tablet_ids:");
            if (this.error_tablet_ids == null) {
                sb.append("null");
            } else {
                sb.append(this.error_tablet_ids);
            }
            first = false;
        }
        if (this.isSetSnapshotFiles()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("snapshot_files:");
            if (this.snapshot_files == null) {
                sb.append("null");
            } else {
                sb.append(this.snapshot_files);
            }
            first = false;
        }
        if (this.isSetTabletFiles()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("tablet_files:");
            if (this.tablet_files == null) {
                sb.append("null");
            } else {
                sb.append(this.tablet_files);
            }
            first = false;
        }
        if (this.isSetDownloadedTabletIds()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("downloaded_tablet_ids:");
            if (this.downloaded_tablet_ids == null) {
                sb.append("null");
            } else {
                sb.append(this.downloaded_tablet_ids);
            }
            first = false;
        }
        if (this.isSetCopySize()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("copy_size:");
            sb.append(this.copy_size);
            first = false;
        }
        if (this.isSetCopyTimeMs()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("copy_time_ms:");
            sb.append(this.copy_time_ms);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.backend == null) {
            throw new TProtocolException("Required field 'backend' was not present! Struct: " + this.toString());
        }
        if (this.task_type == null) {
            throw new TProtocolException("Required field 'task_type' was not present! Struct: " + this.toString());
        }
        if (this.task_status == null) {
            throw new TProtocolException("Required field 'task_status' was not present! Struct: " + this.toString());
        }
        if (this.backend != null) {
            this.backend.validate();
        }
        if (this.task_status != null) {
            this.task_status.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.BACKEND, new FieldMetaData("backend", 1, new StructMetaData(12, TBackend.class)));
        tmpMap.put(_Fields.TASK_TYPE, new FieldMetaData("task_type", 1, new EnumMetaData(16, TTaskType.class)));
        tmpMap.put(_Fields.SIGNATURE, new FieldMetaData("signature", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.TASK_STATUS, new FieldMetaData("task_status", 1, new StructMetaData(12, TStatus.class)));
        tmpMap.put(_Fields.REPORT_VERSION, new FieldMetaData("report_version", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.FINISH_TABLET_INFOS, new FieldMetaData("finish_tablet_infos", 2, new ListMetaData(15, new StructMetaData(12, TTabletInfo.class))));
        tmpMap.put(_Fields.TABLET_CHECKSUM, new FieldMetaData("tablet_checksum", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.REQUEST_VERSION, new FieldMetaData("request_version", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.REQUEST_VERSION_HASH, new FieldMetaData("request_version_hash", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.SNAPSHOT_PATH, new FieldMetaData("snapshot_path", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.ERROR_TABLET_IDS, new FieldMetaData("error_tablet_ids", 2, new ListMetaData(15, new FieldValueMetaData(10, "TTabletId"))));
        tmpMap.put(_Fields.SNAPSHOT_FILES, new FieldMetaData("snapshot_files", 2, new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.TABLET_FILES, new FieldMetaData("tablet_files", 2, new MapMetaData(13, new FieldValueMetaData(10, "TTabletId"), new ListMetaData(15, new FieldValueMetaData(11)))));
        tmpMap.put(_Fields.DOWNLOADED_TABLET_IDS, new FieldMetaData("downloaded_tablet_ids", 2, new ListMetaData(15, new FieldValueMetaData(10, "TTabletId"))));
        tmpMap.put(_Fields.COPY_SIZE, new FieldMetaData("copy_size", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.COPY_TIME_MS, new FieldMetaData("copy_time_ms", 2, new FieldValueMetaData(10)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TFinishTaskRequest.class, metaDataMap);
    }

    private static class TFinishTaskRequestTupleScheme
    extends TupleScheme<TFinishTaskRequest> {
        private TFinishTaskRequestTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, TFinishTaskRequest struct) throws TException {
            Iterator<Object> iterator2;
            TTupleProtocol oprot = (TTupleProtocol)prot;
            struct.backend.write(oprot);
            oprot.writeI32(struct.task_type.getValue());
            oprot.writeI64(struct.signature);
            struct.task_status.write(oprot);
            BitSet optionals = new BitSet();
            if (struct.isSetReportVersion()) {
                optionals.set(0);
            }
            if (struct.isSetFinishTabletInfos()) {
                optionals.set(1);
            }
            if (struct.isSetTabletChecksum()) {
                optionals.set(2);
            }
            if (struct.isSetRequestVersion()) {
                optionals.set(3);
            }
            if (struct.isSetRequestVersionHash()) {
                optionals.set(4);
            }
            if (struct.isSetSnapshotPath()) {
                optionals.set(5);
            }
            if (struct.isSetErrorTabletIds()) {
                optionals.set(6);
            }
            if (struct.isSetSnapshotFiles()) {
                optionals.set(7);
            }
            if (struct.isSetTabletFiles()) {
                optionals.set(8);
            }
            if (struct.isSetDownloadedTabletIds()) {
                optionals.set(9);
            }
            if (struct.isSetCopySize()) {
                optionals.set(10);
            }
            if (struct.isSetCopyTimeMs()) {
                optionals.set(11);
            }
            oprot.writeBitSet(optionals, 12);
            if (struct.isSetReportVersion()) {
                oprot.writeI64(struct.report_version);
            }
            if (struct.isSetFinishTabletInfos()) {
                oprot.writeI32(struct.finish_tablet_infos.size());
                for (TTabletInfo tTabletInfo : struct.finish_tablet_infos) {
                    tTabletInfo.write(oprot);
                }
            }
            if (struct.isSetTabletChecksum()) {
                oprot.writeI64(struct.tablet_checksum);
            }
            if (struct.isSetRequestVersion()) {
                oprot.writeI64(struct.request_version);
            }
            if (struct.isSetRequestVersionHash()) {
                oprot.writeI64(struct.request_version_hash);
            }
            if (struct.isSetSnapshotPath()) {
                oprot.writeString(struct.snapshot_path);
            }
            if (struct.isSetErrorTabletIds()) {
                oprot.writeI32(struct.error_tablet_ids.size());
                iterator2 = struct.error_tablet_ids.iterator();
                while (iterator2.hasNext()) {
                    long l = (Long)iterator2.next();
                    oprot.writeI64(l);
                }
            }
            if (struct.isSetSnapshotFiles()) {
                oprot.writeI32(struct.snapshot_files.size());
                for (String string : struct.snapshot_files) {
                    oprot.writeString(string);
                }
            }
            if (struct.isSetTabletFiles()) {
                oprot.writeI32(struct.tablet_files.size());
                for (Map.Entry entry : struct.tablet_files.entrySet()) {
                    oprot.writeI64((Long)entry.getKey());
                    oprot.writeI32(((List)entry.getValue()).size());
                    for (String _iter37 : (List)entry.getValue()) {
                        oprot.writeString(_iter37);
                    }
                }
            }
            if (struct.isSetDownloadedTabletIds()) {
                oprot.writeI32(struct.downloaded_tablet_ids.size());
                iterator2 = struct.downloaded_tablet_ids.iterator();
                while (iterator2.hasNext()) {
                    long l = (Long)iterator2.next();
                    oprot.writeI64(l);
                }
            }
            if (struct.isSetCopySize()) {
                oprot.writeI64(struct.copy_size);
            }
            if (struct.isSetCopyTimeMs()) {
                oprot.writeI64(struct.copy_time_ms);
            }
        }

        @Override
        public void read(TProtocol prot, TFinishTaskRequest struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.backend = new TBackend();
            struct.backend.read(iprot);
            struct.setBackendIsSet(true);
            struct.task_type = TTaskType.findByValue(iprot.readI32());
            struct.setTaskTypeIsSet(true);
            struct.signature = iprot.readI64();
            struct.setSignatureIsSet(true);
            struct.task_status = new TStatus();
            struct.task_status.read(iprot);
            struct.setTaskStatusIsSet(true);
            BitSet incoming = iprot.readBitSet(12);
            if (incoming.get(0)) {
                struct.report_version = iprot.readI64();
                struct.setReportVersionIsSet(true);
            }
            if (incoming.get(1)) {
                TList _list39 = new TList(12, iprot.readI32());
                struct.finish_tablet_infos = new ArrayList<TTabletInfo>(_list39.size);
                for (int _i41 = 0; _i41 < _list39.size; ++_i41) {
                    TTabletInfo _elem40 = new TTabletInfo();
                    _elem40.read(iprot);
                    struct.finish_tablet_infos.add(_elem40);
                }
                struct.setFinishTabletInfosIsSet(true);
            }
            if (incoming.get(2)) {
                struct.tablet_checksum = iprot.readI64();
                struct.setTabletChecksumIsSet(true);
            }
            if (incoming.get(3)) {
                struct.request_version = iprot.readI64();
                struct.setRequestVersionIsSet(true);
            }
            if (incoming.get(4)) {
                struct.request_version_hash = iprot.readI64();
                struct.setRequestVersionHashIsSet(true);
            }
            if (incoming.get(5)) {
                struct.snapshot_path = iprot.readString();
                struct.setSnapshotPathIsSet(true);
            }
            if (incoming.get(6)) {
                TList _list42 = new TList(10, iprot.readI32());
                struct.error_tablet_ids = new ArrayList<Long>(_list42.size);
                for (int _i44 = 0; _i44 < _list42.size; ++_i44) {
                    long _elem43 = iprot.readI64();
                    struct.error_tablet_ids.add(_elem43);
                }
                struct.setErrorTabletIdsIsSet(true);
            }
            if (incoming.get(7)) {
                TList _list45 = new TList(11, iprot.readI32());
                struct.snapshot_files = new ArrayList<String>(_list45.size);
                for (int _i47 = 0; _i47 < _list45.size; ++_i47) {
                    String _elem46 = iprot.readString();
                    struct.snapshot_files.add(_elem46);
                }
                struct.setSnapshotFilesIsSet(true);
            }
            if (incoming.get(8)) {
                TMap _map48 = new TMap(10, 15, iprot.readI32());
                struct.tablet_files = new HashMap<Long, List<String>>(2 * _map48.size);
                for (int _i51 = 0; _i51 < _map48.size; ++_i51) {
                    long _key49 = iprot.readI64();
                    TList _list52 = new TList(11, iprot.readI32());
                    ArrayList<String> _val50 = new ArrayList<String>(_list52.size);
                    for (int _i54 = 0; _i54 < _list52.size; ++_i54) {
                        String _elem53 = iprot.readString();
                        _val50.add(_elem53);
                    }
                    struct.tablet_files.put(_key49, _val50);
                }
                struct.setTabletFilesIsSet(true);
            }
            if (incoming.get(9)) {
                TList _list55 = new TList(10, iprot.readI32());
                struct.downloaded_tablet_ids = new ArrayList<Long>(_list55.size);
                for (int _i57 = 0; _i57 < _list55.size; ++_i57) {
                    long _elem56 = iprot.readI64();
                    struct.downloaded_tablet_ids.add(_elem56);
                }
                struct.setDownloadedTabletIdsIsSet(true);
            }
            if (incoming.get(10)) {
                struct.copy_size = iprot.readI64();
                struct.setCopySizeIsSet(true);
            }
            if (incoming.get(11)) {
                struct.copy_time_ms = iprot.readI64();
                struct.setCopyTimeMsIsSet(true);
            }
        }
    }

    private static class TFinishTaskRequestTupleSchemeFactory
    implements SchemeFactory {
        private TFinishTaskRequestTupleSchemeFactory() {
        }

        public TFinishTaskRequestTupleScheme getScheme() {
            return new TFinishTaskRequestTupleScheme();
        }
    }

    private static class TFinishTaskRequestStandardScheme
    extends StandardScheme<TFinishTaskRequest> {
        private TFinishTaskRequestStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, TFinishTaskRequest struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 12) {
                            struct.backend = new TBackend();
                            struct.backend.read(iprot);
                            struct.setBackendIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 8) {
                            struct.task_type = TTaskType.findByValue(iprot.readI32());
                            struct.setTaskTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 10) {
                            struct.signature = iprot.readI64();
                            struct.setSignatureIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 12) {
                            struct.task_status = new TStatus();
                            struct.task_status.read(iprot);
                            struct.setTaskStatusIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 10) {
                            struct.report_version = iprot.readI64();
                            struct.setReportVersionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 15) {
                            TList _list8 = iprot.readListBegin();
                            struct.finish_tablet_infos = new ArrayList<TTabletInfo>(_list8.size);
                            for (int _i10 = 0; _i10 < _list8.size; ++_i10) {
                                TTabletInfo _elem9 = new TTabletInfo();
                                _elem9.read(iprot);
                                struct.finish_tablet_infos.add(_elem9);
                            }
                            iprot.readListEnd();
                            struct.setFinishTabletInfosIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 10) {
                            struct.tablet_checksum = iprot.readI64();
                            struct.setTabletChecksumIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 10) {
                            struct.request_version = iprot.readI64();
                            struct.setRequestVersionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 10) {
                            struct.request_version_hash = iprot.readI64();
                            struct.setRequestVersionHashIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 11) {
                            struct.snapshot_path = iprot.readString();
                            struct.setSnapshotPathIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 15) {
                            TList _list11 = iprot.readListBegin();
                            struct.error_tablet_ids = new ArrayList<Long>(_list11.size);
                            for (int _i13 = 0; _i13 < _list11.size; ++_i13) {
                                long _elem12 = iprot.readI64();
                                struct.error_tablet_ids.add(_elem12);
                            }
                            iprot.readListEnd();
                            struct.setErrorTabletIdsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 15) {
                            TList _list14 = iprot.readListBegin();
                            struct.snapshot_files = new ArrayList<String>(_list14.size);
                            for (int _i16 = 0; _i16 < _list14.size; ++_i16) {
                                String _elem15 = iprot.readString();
                                struct.snapshot_files.add(_elem15);
                            }
                            iprot.readListEnd();
                            struct.setSnapshotFilesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 13: {
                        if (schemeField.type == 13) {
                            TMap _map17 = iprot.readMapBegin();
                            struct.tablet_files = new HashMap<Long, List<String>>(2 * _map17.size);
                            for (int _i20 = 0; _i20 < _map17.size; ++_i20) {
                                long _key18 = iprot.readI64();
                                TList _list21 = iprot.readListBegin();
                                ArrayList<String> _val19 = new ArrayList<String>(_list21.size);
                                for (int _i23 = 0; _i23 < _list21.size; ++_i23) {
                                    String _elem22 = iprot.readString();
                                    _val19.add(_elem22);
                                }
                                iprot.readListEnd();
                                struct.tablet_files.put(_key18, _val19);
                            }
                            iprot.readMapEnd();
                            struct.setTabletFilesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 14: {
                        if (schemeField.type == 15) {
                            TList _list24 = iprot.readListBegin();
                            struct.downloaded_tablet_ids = new ArrayList<Long>(_list24.size);
                            for (int _i26 = 0; _i26 < _list24.size; ++_i26) {
                                long _elem25 = iprot.readI64();
                                struct.downloaded_tablet_ids.add(_elem25);
                            }
                            iprot.readListEnd();
                            struct.setDownloadedTabletIdsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 15: {
                        if (schemeField.type == 10) {
                            struct.copy_size = iprot.readI64();
                            struct.setCopySizeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 16: {
                        if (schemeField.type == 10) {
                            struct.copy_time_ms = iprot.readI64();
                            struct.setCopyTimeMsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetSignature()) {
                throw new TProtocolException("Required field 'signature' was not found in serialized data! Struct: " + this.toString());
            }
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, TFinishTaskRequest struct) throws TException {
            Iterator<Object> iterator2;
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.backend != null) {
                oprot.writeFieldBegin(BACKEND_FIELD_DESC);
                struct.backend.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.task_type != null) {
                oprot.writeFieldBegin(TASK_TYPE_FIELD_DESC);
                oprot.writeI32(struct.task_type.getValue());
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(SIGNATURE_FIELD_DESC);
            oprot.writeI64(struct.signature);
            oprot.writeFieldEnd();
            if (struct.task_status != null) {
                oprot.writeFieldBegin(TASK_STATUS_FIELD_DESC);
                struct.task_status.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.isSetReportVersion()) {
                oprot.writeFieldBegin(REPORT_VERSION_FIELD_DESC);
                oprot.writeI64(struct.report_version);
                oprot.writeFieldEnd();
            }
            if (struct.finish_tablet_infos != null && struct.isSetFinishTabletInfos()) {
                oprot.writeFieldBegin(FINISH_TABLET_INFOS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.finish_tablet_infos.size()));
                for (TTabletInfo tTabletInfo : struct.finish_tablet_infos) {
                    tTabletInfo.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.isSetTabletChecksum()) {
                oprot.writeFieldBegin(TABLET_CHECKSUM_FIELD_DESC);
                oprot.writeI64(struct.tablet_checksum);
                oprot.writeFieldEnd();
            }
            if (struct.isSetRequestVersion()) {
                oprot.writeFieldBegin(REQUEST_VERSION_FIELD_DESC);
                oprot.writeI64(struct.request_version);
                oprot.writeFieldEnd();
            }
            if (struct.isSetRequestVersionHash()) {
                oprot.writeFieldBegin(REQUEST_VERSION_HASH_FIELD_DESC);
                oprot.writeI64(struct.request_version_hash);
                oprot.writeFieldEnd();
            }
            if (struct.snapshot_path != null && struct.isSetSnapshotPath()) {
                oprot.writeFieldBegin(SNAPSHOT_PATH_FIELD_DESC);
                oprot.writeString(struct.snapshot_path);
                oprot.writeFieldEnd();
            }
            if (struct.error_tablet_ids != null && struct.isSetErrorTabletIds()) {
                oprot.writeFieldBegin(ERROR_TABLET_IDS_FIELD_DESC);
                oprot.writeListBegin(new TList(10, struct.error_tablet_ids.size()));
                iterator2 = struct.error_tablet_ids.iterator();
                while (iterator2.hasNext()) {
                    long l = (Long)iterator2.next();
                    oprot.writeI64(l);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.snapshot_files != null && struct.isSetSnapshotFiles()) {
                oprot.writeFieldBegin(SNAPSHOT_FILES_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.snapshot_files.size()));
                for (String string : struct.snapshot_files) {
                    oprot.writeString(string);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.tablet_files != null && struct.isSetTabletFiles()) {
                oprot.writeFieldBegin(TABLET_FILES_FIELD_DESC);
                oprot.writeMapBegin(new TMap(10, 15, struct.tablet_files.size()));
                for (Map.Entry entry : struct.tablet_files.entrySet()) {
                    oprot.writeI64((Long)entry.getKey());
                    oprot.writeListBegin(new TList(11, ((List)entry.getValue()).size()));
                    for (String _iter31 : (List)entry.getValue()) {
                        oprot.writeString(_iter31);
                    }
                    oprot.writeListEnd();
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.downloaded_tablet_ids != null && struct.isSetDownloadedTabletIds()) {
                oprot.writeFieldBegin(DOWNLOADED_TABLET_IDS_FIELD_DESC);
                oprot.writeListBegin(new TList(10, struct.downloaded_tablet_ids.size()));
                iterator2 = struct.downloaded_tablet_ids.iterator();
                while (iterator2.hasNext()) {
                    long l = (Long)iterator2.next();
                    oprot.writeI64(l);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.isSetCopySize()) {
                oprot.writeFieldBegin(COPY_SIZE_FIELD_DESC);
                oprot.writeI64(struct.copy_size);
                oprot.writeFieldEnd();
            }
            if (struct.isSetCopyTimeMs()) {
                oprot.writeFieldBegin(COPY_TIME_MS_FIELD_DESC);
                oprot.writeI64(struct.copy_time_ms);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TFinishTaskRequestStandardSchemeFactory
    implements SchemeFactory {
        private TFinishTaskRequestStandardSchemeFactory() {
        }

        public TFinishTaskRequestStandardScheme getScheme() {
            return new TFinishTaskRequestStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        BACKEND(1, "backend"),
        TASK_TYPE(2, "task_type"),
        SIGNATURE(3, "signature"),
        TASK_STATUS(4, "task_status"),
        REPORT_VERSION(5, "report_version"),
        FINISH_TABLET_INFOS(6, "finish_tablet_infos"),
        TABLET_CHECKSUM(7, "tablet_checksum"),
        REQUEST_VERSION(8, "request_version"),
        REQUEST_VERSION_HASH(9, "request_version_hash"),
        SNAPSHOT_PATH(10, "snapshot_path"),
        ERROR_TABLET_IDS(11, "error_tablet_ids"),
        SNAPSHOT_FILES(12, "snapshot_files"),
        TABLET_FILES(13, "tablet_files"),
        DOWNLOADED_TABLET_IDS(14, "downloaded_tablet_ids"),
        COPY_SIZE(15, "copy_size"),
        COPY_TIME_MS(16, "copy_time_ms");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return BACKEND;
                }
                case 2: {
                    return TASK_TYPE;
                }
                case 3: {
                    return SIGNATURE;
                }
                case 4: {
                    return TASK_STATUS;
                }
                case 5: {
                    return REPORT_VERSION;
                }
                case 6: {
                    return FINISH_TABLET_INFOS;
                }
                case 7: {
                    return TABLET_CHECKSUM;
                }
                case 8: {
                    return REQUEST_VERSION;
                }
                case 9: {
                    return REQUEST_VERSION_HASH;
                }
                case 10: {
                    return SNAPSHOT_PATH;
                }
                case 11: {
                    return ERROR_TABLET_IDS;
                }
                case 12: {
                    return SNAPSHOT_FILES;
                }
                case 13: {
                    return TABLET_FILES;
                }
                case 14: {
                    return DOWNLOADED_TABLET_IDS;
                }
                case 15: {
                    return COPY_SIZE;
                }
                case 16: {
                    return COPY_TIME_MS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

