/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.thrift;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.doris.thrift.TExpr;
import org.apache.doris.thrift.TSortInfo;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;

public class TAggregationNode
implements TBase<TAggregationNode, _Fields>,
Serializable,
Cloneable,
Comparable<TAggregationNode> {
    private static final TStruct STRUCT_DESC = new TStruct("TAggregationNode");
    private static final TField GROUPING_EXPRS_FIELD_DESC = new TField("grouping_exprs", 15, 1);
    private static final TField AGGREGATE_FUNCTIONS_FIELD_DESC = new TField("aggregate_functions", 15, 2);
    private static final TField INTERMEDIATE_TUPLE_ID_FIELD_DESC = new TField("intermediate_tuple_id", 8, 3);
    private static final TField OUTPUT_TUPLE_ID_FIELD_DESC = new TField("output_tuple_id", 8, 4);
    private static final TField NEED_FINALIZE_FIELD_DESC = new TField("need_finalize", 2, 5);
    private static final TField USE_STREAMING_PREAGGREGATION_FIELD_DESC = new TField("use_streaming_preaggregation", 2, 6);
    private static final TField AGG_SORT_INFOS_FIELD_DESC = new TField("agg_sort_infos", 15, 7);
    private static final TField IS_FIRST_PHASE_FIELD_DESC = new TField("is_first_phase", 2, 8);
    private static final TField USE_FIXED_LENGTH_SERIALIZATION_OPT_FIELD_DESC = new TField("use_fixed_length_serialization_opt", 2, 9);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TAggregationNodeStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TAggregationNodeTupleSchemeFactory();
    @Nullable
    public List<TExpr> grouping_exprs;
    @Nullable
    public List<TExpr> aggregate_functions;
    public int intermediate_tuple_id;
    public int output_tuple_id;
    public boolean need_finalize;
    public boolean use_streaming_preaggregation;
    @Nullable
    public List<TSortInfo> agg_sort_infos;
    public boolean is_first_phase;
    public boolean use_fixed_length_serialization_opt;
    private static final int __INTERMEDIATE_TUPLE_ID_ISSET_ID = 0;
    private static final int __OUTPUT_TUPLE_ID_ISSET_ID = 1;
    private static final int __NEED_FINALIZE_ISSET_ID = 2;
    private static final int __USE_STREAMING_PREAGGREGATION_ISSET_ID = 3;
    private static final int __IS_FIRST_PHASE_ISSET_ID = 4;
    private static final int __USE_FIXED_LENGTH_SERIALIZATION_OPT_ISSET_ID = 5;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.GROUPING_EXPRS, _Fields.USE_STREAMING_PREAGGREGATION, _Fields.AGG_SORT_INFOS, _Fields.IS_FIRST_PHASE, _Fields.USE_FIXED_LENGTH_SERIALIZATION_OPT};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TAggregationNode() {
    }

    public TAggregationNode(List<TExpr> aggregate_functions, int intermediate_tuple_id, int output_tuple_id, boolean need_finalize) {
        this();
        this.aggregate_functions = aggregate_functions;
        this.intermediate_tuple_id = intermediate_tuple_id;
        this.setIntermediateTupleIdIsSet(true);
        this.output_tuple_id = output_tuple_id;
        this.setOutputTupleIdIsSet(true);
        this.need_finalize = need_finalize;
        this.setNeedFinalizeIsSet(true);
    }

    public TAggregationNode(TAggregationNode other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetGroupingExprs()) {
            ArrayList<TExpr> __this__grouping_exprs = new ArrayList<TExpr>(other.grouping_exprs.size());
            for (TExpr tExpr : other.grouping_exprs) {
                __this__grouping_exprs.add(new TExpr(tExpr));
            }
            this.grouping_exprs = __this__grouping_exprs;
        }
        if (other.isSetAggregateFunctions()) {
            ArrayList<TExpr> __this__aggregate_functions = new ArrayList<TExpr>(other.aggregate_functions.size());
            for (TExpr tExpr : other.aggregate_functions) {
                __this__aggregate_functions.add(new TExpr(tExpr));
            }
            this.aggregate_functions = __this__aggregate_functions;
        }
        this.intermediate_tuple_id = other.intermediate_tuple_id;
        this.output_tuple_id = other.output_tuple_id;
        this.need_finalize = other.need_finalize;
        this.use_streaming_preaggregation = other.use_streaming_preaggregation;
        if (other.isSetAggSortInfos()) {
            ArrayList<TSortInfo> __this__agg_sort_infos = new ArrayList<TSortInfo>(other.agg_sort_infos.size());
            for (TSortInfo tSortInfo : other.agg_sort_infos) {
                __this__agg_sort_infos.add(new TSortInfo(tSortInfo));
            }
            this.agg_sort_infos = __this__agg_sort_infos;
        }
        this.is_first_phase = other.is_first_phase;
        this.use_fixed_length_serialization_opt = other.use_fixed_length_serialization_opt;
    }

    @Override
    public TAggregationNode deepCopy() {
        return new TAggregationNode(this);
    }

    @Override
    public void clear() {
        this.grouping_exprs = null;
        this.aggregate_functions = null;
        this.setIntermediateTupleIdIsSet(false);
        this.intermediate_tuple_id = 0;
        this.setOutputTupleIdIsSet(false);
        this.output_tuple_id = 0;
        this.setNeedFinalizeIsSet(false);
        this.need_finalize = false;
        this.setUseStreamingPreaggregationIsSet(false);
        this.use_streaming_preaggregation = false;
        this.agg_sort_infos = null;
        this.setIsFirstPhaseIsSet(false);
        this.is_first_phase = false;
        this.setUseFixedLengthSerializationOptIsSet(false);
        this.use_fixed_length_serialization_opt = false;
    }

    public int getGroupingExprsSize() {
        return this.grouping_exprs == null ? 0 : this.grouping_exprs.size();
    }

    @Nullable
    public Iterator<TExpr> getGroupingExprsIterator() {
        return this.grouping_exprs == null ? null : this.grouping_exprs.iterator();
    }

    public void addToGroupingExprs(TExpr elem) {
        if (this.grouping_exprs == null) {
            this.grouping_exprs = new ArrayList<TExpr>();
        }
        this.grouping_exprs.add(elem);
    }

    @Nullable
    public List<TExpr> getGroupingExprs() {
        return this.grouping_exprs;
    }

    public TAggregationNode setGroupingExprs(@Nullable List<TExpr> grouping_exprs) {
        this.grouping_exprs = grouping_exprs;
        return this;
    }

    public void unsetGroupingExprs() {
        this.grouping_exprs = null;
    }

    public boolean isSetGroupingExprs() {
        return this.grouping_exprs != null;
    }

    public void setGroupingExprsIsSet(boolean value) {
        if (!value) {
            this.grouping_exprs = null;
        }
    }

    public int getAggregateFunctionsSize() {
        return this.aggregate_functions == null ? 0 : this.aggregate_functions.size();
    }

    @Nullable
    public Iterator<TExpr> getAggregateFunctionsIterator() {
        return this.aggregate_functions == null ? null : this.aggregate_functions.iterator();
    }

    public void addToAggregateFunctions(TExpr elem) {
        if (this.aggregate_functions == null) {
            this.aggregate_functions = new ArrayList<TExpr>();
        }
        this.aggregate_functions.add(elem);
    }

    @Nullable
    public List<TExpr> getAggregateFunctions() {
        return this.aggregate_functions;
    }

    public TAggregationNode setAggregateFunctions(@Nullable List<TExpr> aggregate_functions) {
        this.aggregate_functions = aggregate_functions;
        return this;
    }

    public void unsetAggregateFunctions() {
        this.aggregate_functions = null;
    }

    public boolean isSetAggregateFunctions() {
        return this.aggregate_functions != null;
    }

    public void setAggregateFunctionsIsSet(boolean value) {
        if (!value) {
            this.aggregate_functions = null;
        }
    }

    public int getIntermediateTupleId() {
        return this.intermediate_tuple_id;
    }

    public TAggregationNode setIntermediateTupleId(int intermediate_tuple_id) {
        this.intermediate_tuple_id = intermediate_tuple_id;
        this.setIntermediateTupleIdIsSet(true);
        return this;
    }

    public void unsetIntermediateTupleId() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 0);
    }

    public boolean isSetIntermediateTupleId() {
        return EncodingUtils.testBit(this.__isset_bitfield, 0);
    }

    public void setIntermediateTupleIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 0, value);
    }

    public int getOutputTupleId() {
        return this.output_tuple_id;
    }

    public TAggregationNode setOutputTupleId(int output_tuple_id) {
        this.output_tuple_id = output_tuple_id;
        this.setOutputTupleIdIsSet(true);
        return this;
    }

    public void unsetOutputTupleId() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 1);
    }

    public boolean isSetOutputTupleId() {
        return EncodingUtils.testBit(this.__isset_bitfield, 1);
    }

    public void setOutputTupleIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 1, value);
    }

    public boolean isNeedFinalize() {
        return this.need_finalize;
    }

    public TAggregationNode setNeedFinalize(boolean need_finalize) {
        this.need_finalize = need_finalize;
        this.setNeedFinalizeIsSet(true);
        return this;
    }

    public void unsetNeedFinalize() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 2);
    }

    public boolean isSetNeedFinalize() {
        return EncodingUtils.testBit(this.__isset_bitfield, 2);
    }

    public void setNeedFinalizeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 2, value);
    }

    public boolean isUseStreamingPreaggregation() {
        return this.use_streaming_preaggregation;
    }

    public TAggregationNode setUseStreamingPreaggregation(boolean use_streaming_preaggregation) {
        this.use_streaming_preaggregation = use_streaming_preaggregation;
        this.setUseStreamingPreaggregationIsSet(true);
        return this;
    }

    public void unsetUseStreamingPreaggregation() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 3);
    }

    public boolean isSetUseStreamingPreaggregation() {
        return EncodingUtils.testBit(this.__isset_bitfield, 3);
    }

    public void setUseStreamingPreaggregationIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 3, value);
    }

    public int getAggSortInfosSize() {
        return this.agg_sort_infos == null ? 0 : this.agg_sort_infos.size();
    }

    @Nullable
    public Iterator<TSortInfo> getAggSortInfosIterator() {
        return this.agg_sort_infos == null ? null : this.agg_sort_infos.iterator();
    }

    public void addToAggSortInfos(TSortInfo elem) {
        if (this.agg_sort_infos == null) {
            this.agg_sort_infos = new ArrayList<TSortInfo>();
        }
        this.agg_sort_infos.add(elem);
    }

    @Nullable
    public List<TSortInfo> getAggSortInfos() {
        return this.agg_sort_infos;
    }

    public TAggregationNode setAggSortInfos(@Nullable List<TSortInfo> agg_sort_infos) {
        this.agg_sort_infos = agg_sort_infos;
        return this;
    }

    public void unsetAggSortInfos() {
        this.agg_sort_infos = null;
    }

    public boolean isSetAggSortInfos() {
        return this.agg_sort_infos != null;
    }

    public void setAggSortInfosIsSet(boolean value) {
        if (!value) {
            this.agg_sort_infos = null;
        }
    }

    public boolean isIsFirstPhase() {
        return this.is_first_phase;
    }

    public TAggregationNode setIsFirstPhase(boolean is_first_phase) {
        this.is_first_phase = is_first_phase;
        this.setIsFirstPhaseIsSet(true);
        return this;
    }

    public void unsetIsFirstPhase() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 4);
    }

    public boolean isSetIsFirstPhase() {
        return EncodingUtils.testBit(this.__isset_bitfield, 4);
    }

    public void setIsFirstPhaseIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 4, value);
    }

    public boolean isUseFixedLengthSerializationOpt() {
        return this.use_fixed_length_serialization_opt;
    }

    public TAggregationNode setUseFixedLengthSerializationOpt(boolean use_fixed_length_serialization_opt) {
        this.use_fixed_length_serialization_opt = use_fixed_length_serialization_opt;
        this.setUseFixedLengthSerializationOptIsSet(true);
        return this;
    }

    public void unsetUseFixedLengthSerializationOpt() {
        this.__isset_bitfield = EncodingUtils.clearBit(this.__isset_bitfield, 5);
    }

    public boolean isSetUseFixedLengthSerializationOpt() {
        return EncodingUtils.testBit(this.__isset_bitfield, 5);
    }

    public void setUseFixedLengthSerializationOptIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit(this.__isset_bitfield, 5, value);
    }

    @Override
    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case GROUPING_EXPRS: {
                if (value == null) {
                    this.unsetGroupingExprs();
                    break;
                }
                this.setGroupingExprs((List)value);
                break;
            }
            case AGGREGATE_FUNCTIONS: {
                if (value == null) {
                    this.unsetAggregateFunctions();
                    break;
                }
                this.setAggregateFunctions((List)value);
                break;
            }
            case INTERMEDIATE_TUPLE_ID: {
                if (value == null) {
                    this.unsetIntermediateTupleId();
                    break;
                }
                this.setIntermediateTupleId((Integer)value);
                break;
            }
            case OUTPUT_TUPLE_ID: {
                if (value == null) {
                    this.unsetOutputTupleId();
                    break;
                }
                this.setOutputTupleId((Integer)value);
                break;
            }
            case NEED_FINALIZE: {
                if (value == null) {
                    this.unsetNeedFinalize();
                    break;
                }
                this.setNeedFinalize((Boolean)value);
                break;
            }
            case USE_STREAMING_PREAGGREGATION: {
                if (value == null) {
                    this.unsetUseStreamingPreaggregation();
                    break;
                }
                this.setUseStreamingPreaggregation((Boolean)value);
                break;
            }
            case AGG_SORT_INFOS: {
                if (value == null) {
                    this.unsetAggSortInfos();
                    break;
                }
                this.setAggSortInfos((List)value);
                break;
            }
            case IS_FIRST_PHASE: {
                if (value == null) {
                    this.unsetIsFirstPhase();
                    break;
                }
                this.setIsFirstPhase((Boolean)value);
                break;
            }
            case USE_FIXED_LENGTH_SERIALIZATION_OPT: {
                if (value == null) {
                    this.unsetUseFixedLengthSerializationOpt();
                    break;
                }
                this.setUseFixedLengthSerializationOpt((Boolean)value);
            }
        }
    }

    @Override
    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case GROUPING_EXPRS: {
                return this.getGroupingExprs();
            }
            case AGGREGATE_FUNCTIONS: {
                return this.getAggregateFunctions();
            }
            case INTERMEDIATE_TUPLE_ID: {
                return this.getIntermediateTupleId();
            }
            case OUTPUT_TUPLE_ID: {
                return this.getOutputTupleId();
            }
            case NEED_FINALIZE: {
                return this.isNeedFinalize();
            }
            case USE_STREAMING_PREAGGREGATION: {
                return this.isUseStreamingPreaggregation();
            }
            case AGG_SORT_INFOS: {
                return this.getAggSortInfos();
            }
            case IS_FIRST_PHASE: {
                return this.isIsFirstPhase();
            }
            case USE_FIXED_LENGTH_SERIALIZATION_OPT: {
                return this.isUseFixedLengthSerializationOpt();
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case GROUPING_EXPRS: {
                return this.isSetGroupingExprs();
            }
            case AGGREGATE_FUNCTIONS: {
                return this.isSetAggregateFunctions();
            }
            case INTERMEDIATE_TUPLE_ID: {
                return this.isSetIntermediateTupleId();
            }
            case OUTPUT_TUPLE_ID: {
                return this.isSetOutputTupleId();
            }
            case NEED_FINALIZE: {
                return this.isSetNeedFinalize();
            }
            case USE_STREAMING_PREAGGREGATION: {
                return this.isSetUseStreamingPreaggregation();
            }
            case AGG_SORT_INFOS: {
                return this.isSetAggSortInfos();
            }
            case IS_FIRST_PHASE: {
                return this.isSetIsFirstPhase();
            }
            case USE_FIXED_LENGTH_SERIALIZATION_OPT: {
                return this.isSetUseFixedLengthSerializationOpt();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof TAggregationNode) {
            return this.equals((TAggregationNode)that);
        }
        return false;
    }

    public boolean equals(TAggregationNode that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_grouping_exprs = this.isSetGroupingExprs();
        boolean that_present_grouping_exprs = that.isSetGroupingExprs();
        if (this_present_grouping_exprs || that_present_grouping_exprs) {
            if (!this_present_grouping_exprs || !that_present_grouping_exprs) {
                return false;
            }
            if (!this.grouping_exprs.equals(that.grouping_exprs)) {
                return false;
            }
        }
        boolean this_present_aggregate_functions = this.isSetAggregateFunctions();
        boolean that_present_aggregate_functions = that.isSetAggregateFunctions();
        if (this_present_aggregate_functions || that_present_aggregate_functions) {
            if (!this_present_aggregate_functions || !that_present_aggregate_functions) {
                return false;
            }
            if (!this.aggregate_functions.equals(that.aggregate_functions)) {
                return false;
            }
        }
        boolean this_present_intermediate_tuple_id = true;
        boolean that_present_intermediate_tuple_id = true;
        if (this_present_intermediate_tuple_id || that_present_intermediate_tuple_id) {
            if (!this_present_intermediate_tuple_id || !that_present_intermediate_tuple_id) {
                return false;
            }
            if (this.intermediate_tuple_id != that.intermediate_tuple_id) {
                return false;
            }
        }
        boolean this_present_output_tuple_id = true;
        boolean that_present_output_tuple_id = true;
        if (this_present_output_tuple_id || that_present_output_tuple_id) {
            if (!this_present_output_tuple_id || !that_present_output_tuple_id) {
                return false;
            }
            if (this.output_tuple_id != that.output_tuple_id) {
                return false;
            }
        }
        boolean this_present_need_finalize = true;
        boolean that_present_need_finalize = true;
        if (this_present_need_finalize || that_present_need_finalize) {
            if (!this_present_need_finalize || !that_present_need_finalize) {
                return false;
            }
            if (this.need_finalize != that.need_finalize) {
                return false;
            }
        }
        boolean this_present_use_streaming_preaggregation = this.isSetUseStreamingPreaggregation();
        boolean that_present_use_streaming_preaggregation = that.isSetUseStreamingPreaggregation();
        if (this_present_use_streaming_preaggregation || that_present_use_streaming_preaggregation) {
            if (!this_present_use_streaming_preaggregation || !that_present_use_streaming_preaggregation) {
                return false;
            }
            if (this.use_streaming_preaggregation != that.use_streaming_preaggregation) {
                return false;
            }
        }
        boolean this_present_agg_sort_infos = this.isSetAggSortInfos();
        boolean that_present_agg_sort_infos = that.isSetAggSortInfos();
        if (this_present_agg_sort_infos || that_present_agg_sort_infos) {
            if (!this_present_agg_sort_infos || !that_present_agg_sort_infos) {
                return false;
            }
            if (!this.agg_sort_infos.equals(that.agg_sort_infos)) {
                return false;
            }
        }
        boolean this_present_is_first_phase = this.isSetIsFirstPhase();
        boolean that_present_is_first_phase = that.isSetIsFirstPhase();
        if (this_present_is_first_phase || that_present_is_first_phase) {
            if (!this_present_is_first_phase || !that_present_is_first_phase) {
                return false;
            }
            if (this.is_first_phase != that.is_first_phase) {
                return false;
            }
        }
        boolean this_present_use_fixed_length_serialization_opt = this.isSetUseFixedLengthSerializationOpt();
        boolean that_present_use_fixed_length_serialization_opt = that.isSetUseFixedLengthSerializationOpt();
        if (this_present_use_fixed_length_serialization_opt || that_present_use_fixed_length_serialization_opt) {
            if (!this_present_use_fixed_length_serialization_opt || !that_present_use_fixed_length_serialization_opt) {
                return false;
            }
            if (this.use_fixed_length_serialization_opt != that.use_fixed_length_serialization_opt) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetGroupingExprs() ? 131071 : 524287);
        if (this.isSetGroupingExprs()) {
            hashCode = hashCode * 8191 + this.grouping_exprs.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetAggregateFunctions() ? 131071 : 524287);
        if (this.isSetAggregateFunctions()) {
            hashCode = hashCode * 8191 + this.aggregate_functions.hashCode();
        }
        hashCode = hashCode * 8191 + this.intermediate_tuple_id;
        hashCode = hashCode * 8191 + this.output_tuple_id;
        hashCode = hashCode * 8191 + (this.need_finalize ? 131071 : 524287);
        hashCode = hashCode * 8191 + (this.isSetUseStreamingPreaggregation() ? 131071 : 524287);
        if (this.isSetUseStreamingPreaggregation()) {
            hashCode = hashCode * 8191 + (this.use_streaming_preaggregation ? 131071 : 524287);
        }
        hashCode = hashCode * 8191 + (this.isSetAggSortInfos() ? 131071 : 524287);
        if (this.isSetAggSortInfos()) {
            hashCode = hashCode * 8191 + this.agg_sort_infos.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetIsFirstPhase() ? 131071 : 524287);
        if (this.isSetIsFirstPhase()) {
            hashCode = hashCode * 8191 + (this.is_first_phase ? 131071 : 524287);
        }
        hashCode = hashCode * 8191 + (this.isSetUseFixedLengthSerializationOpt() ? 131071 : 524287);
        if (this.isSetUseFixedLengthSerializationOpt()) {
            hashCode = hashCode * 8191 + (this.use_fixed_length_serialization_opt ? 131071 : 524287);
        }
        return hashCode;
    }

    @Override
    public int compareTo(TAggregationNode other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetGroupingExprs()).compareTo(other.isSetGroupingExprs());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetGroupingExprs() && (lastComparison = TBaseHelper.compareTo(this.grouping_exprs, other.grouping_exprs)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetAggregateFunctions()).compareTo(other.isSetAggregateFunctions());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAggregateFunctions() && (lastComparison = TBaseHelper.compareTo(this.aggregate_functions, other.aggregate_functions)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetIntermediateTupleId()).compareTo(other.isSetIntermediateTupleId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIntermediateTupleId() && (lastComparison = TBaseHelper.compareTo(this.intermediate_tuple_id, other.intermediate_tuple_id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetOutputTupleId()).compareTo(other.isSetOutputTupleId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOutputTupleId() && (lastComparison = TBaseHelper.compareTo(this.output_tuple_id, other.output_tuple_id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetNeedFinalize()).compareTo(other.isSetNeedFinalize());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNeedFinalize() && (lastComparison = TBaseHelper.compareTo(this.need_finalize, other.need_finalize)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetUseStreamingPreaggregation()).compareTo(other.isSetUseStreamingPreaggregation());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetUseStreamingPreaggregation() && (lastComparison = TBaseHelper.compareTo(this.use_streaming_preaggregation, other.use_streaming_preaggregation)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetAggSortInfos()).compareTo(other.isSetAggSortInfos());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAggSortInfos() && (lastComparison = TBaseHelper.compareTo(this.agg_sort_infos, other.agg_sort_infos)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetIsFirstPhase()).compareTo(other.isSetIsFirstPhase());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIsFirstPhase() && (lastComparison = TBaseHelper.compareTo(this.is_first_phase, other.is_first_phase)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetUseFixedLengthSerializationOpt()).compareTo(other.isSetUseFixedLengthSerializationOpt());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetUseFixedLengthSerializationOpt() && (lastComparison = TBaseHelper.compareTo(this.use_fixed_length_serialization_opt, other.use_fixed_length_serialization_opt)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        TAggregationNode.scheme(iprot).read(iprot, (TAggregationNode)this);
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        TAggregationNode.scheme(oprot).write(oprot, (TAggregationNode)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TAggregationNode(");
        boolean first = true;
        if (this.isSetGroupingExprs()) {
            sb.append("grouping_exprs:");
            if (this.grouping_exprs == null) {
                sb.append("null");
            } else {
                sb.append(this.grouping_exprs);
            }
            first = false;
        }
        if (!first) {
            sb.append(", ");
        }
        sb.append("aggregate_functions:");
        if (this.aggregate_functions == null) {
            sb.append("null");
        } else {
            sb.append(this.aggregate_functions);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("intermediate_tuple_id:");
        sb.append(this.intermediate_tuple_id);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("output_tuple_id:");
        sb.append(this.output_tuple_id);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("need_finalize:");
        sb.append(this.need_finalize);
        first = false;
        if (this.isSetUseStreamingPreaggregation()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("use_streaming_preaggregation:");
            sb.append(this.use_streaming_preaggregation);
            first = false;
        }
        if (this.isSetAggSortInfos()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("agg_sort_infos:");
            if (this.agg_sort_infos == null) {
                sb.append("null");
            } else {
                sb.append(this.agg_sort_infos);
            }
            first = false;
        }
        if (this.isSetIsFirstPhase()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("is_first_phase:");
            sb.append(this.is_first_phase);
            first = false;
        }
        if (this.isSetUseFixedLengthSerializationOpt()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("use_fixed_length_serialization_opt:");
            sb.append(this.use_fixed_length_serialization_opt);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.aggregate_functions == null) {
            throw new TProtocolException("Required field 'aggregate_functions' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write(new TCompactProtocol(new TIOStreamTransport(out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read(new TCompactProtocol(new TIOStreamTransport(in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (StandardScheme.class.equals(proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.GROUPING_EXPRS, new FieldMetaData("grouping_exprs", 2, new ListMetaData(15, new StructMetaData(12, TExpr.class))));
        tmpMap.put(_Fields.AGGREGATE_FUNCTIONS, new FieldMetaData("aggregate_functions", 1, new ListMetaData(15, new StructMetaData(12, TExpr.class))));
        tmpMap.put(_Fields.INTERMEDIATE_TUPLE_ID, new FieldMetaData("intermediate_tuple_id", 1, new FieldValueMetaData(8, "TTupleId")));
        tmpMap.put(_Fields.OUTPUT_TUPLE_ID, new FieldMetaData("output_tuple_id", 1, new FieldValueMetaData(8, "TTupleId")));
        tmpMap.put(_Fields.NEED_FINALIZE, new FieldMetaData("need_finalize", 1, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.USE_STREAMING_PREAGGREGATION, new FieldMetaData("use_streaming_preaggregation", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.AGG_SORT_INFOS, new FieldMetaData("agg_sort_infos", 2, new ListMetaData(15, new StructMetaData(12, TSortInfo.class))));
        tmpMap.put(_Fields.IS_FIRST_PHASE, new FieldMetaData("is_first_phase", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.USE_FIXED_LENGTH_SERIALIZATION_OPT, new FieldMetaData("use_fixed_length_serialization_opt", 2, new FieldValueMetaData(2)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TAggregationNode.class, metaDataMap);
    }

    private static class TAggregationNodeTupleScheme
    extends TupleScheme<TAggregationNode> {
        private TAggregationNodeTupleScheme() {
        }

        @Override
        public void write(TProtocol prot, TAggregationNode struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.aggregate_functions.size());
            for (TExpr _iter500 : struct.aggregate_functions) {
                _iter500.write(oprot);
            }
            oprot.writeI32(struct.intermediate_tuple_id);
            oprot.writeI32(struct.output_tuple_id);
            oprot.writeBool(struct.need_finalize);
            BitSet optionals = new BitSet();
            if (struct.isSetGroupingExprs()) {
                optionals.set(0);
            }
            if (struct.isSetUseStreamingPreaggregation()) {
                optionals.set(1);
            }
            if (struct.isSetAggSortInfos()) {
                optionals.set(2);
            }
            if (struct.isSetIsFirstPhase()) {
                optionals.set(3);
            }
            if (struct.isSetUseFixedLengthSerializationOpt()) {
                optionals.set(4);
            }
            oprot.writeBitSet(optionals, 5);
            if (struct.isSetGroupingExprs()) {
                oprot.writeI32(struct.grouping_exprs.size());
                for (TExpr _iter501 : struct.grouping_exprs) {
                    _iter501.write(oprot);
                }
            }
            if (struct.isSetUseStreamingPreaggregation()) {
                oprot.writeBool(struct.use_streaming_preaggregation);
            }
            if (struct.isSetAggSortInfos()) {
                oprot.writeI32(struct.agg_sort_infos.size());
                for (TSortInfo _iter502 : struct.agg_sort_infos) {
                    _iter502.write(oprot);
                }
            }
            if (struct.isSetIsFirstPhase()) {
                oprot.writeBool(struct.is_first_phase);
            }
            if (struct.isSetUseFixedLengthSerializationOpt()) {
                oprot.writeBool(struct.use_fixed_length_serialization_opt);
            }
        }

        @Override
        public void read(TProtocol prot, TAggregationNode struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            TList _list503 = new TList(12, iprot.readI32());
            struct.aggregate_functions = new ArrayList<TExpr>(_list503.size);
            for (int _i505 = 0; _i505 < _list503.size; ++_i505) {
                TExpr _elem504 = new TExpr();
                _elem504.read(iprot);
                struct.aggregate_functions.add(_elem504);
            }
            struct.setAggregateFunctionsIsSet(true);
            struct.intermediate_tuple_id = iprot.readI32();
            struct.setIntermediateTupleIdIsSet(true);
            struct.output_tuple_id = iprot.readI32();
            struct.setOutputTupleIdIsSet(true);
            struct.need_finalize = iprot.readBool();
            struct.setNeedFinalizeIsSet(true);
            BitSet incoming = iprot.readBitSet(5);
            if (incoming.get(0)) {
                TList _list506 = new TList(12, iprot.readI32());
                struct.grouping_exprs = new ArrayList<TExpr>(_list506.size);
                for (int _i508 = 0; _i508 < _list506.size; ++_i508) {
                    TExpr _elem507 = new TExpr();
                    _elem507.read(iprot);
                    struct.grouping_exprs.add(_elem507);
                }
                struct.setGroupingExprsIsSet(true);
            }
            if (incoming.get(1)) {
                struct.use_streaming_preaggregation = iprot.readBool();
                struct.setUseStreamingPreaggregationIsSet(true);
            }
            if (incoming.get(2)) {
                TList _list509 = new TList(12, iprot.readI32());
                struct.agg_sort_infos = new ArrayList<TSortInfo>(_list509.size);
                for (int _i511 = 0; _i511 < _list509.size; ++_i511) {
                    TSortInfo _elem510 = new TSortInfo();
                    _elem510.read(iprot);
                    struct.agg_sort_infos.add(_elem510);
                }
                struct.setAggSortInfosIsSet(true);
            }
            if (incoming.get(3)) {
                struct.is_first_phase = iprot.readBool();
                struct.setIsFirstPhaseIsSet(true);
            }
            if (incoming.get(4)) {
                struct.use_fixed_length_serialization_opt = iprot.readBool();
                struct.setUseFixedLengthSerializationOptIsSet(true);
            }
        }
    }

    private static class TAggregationNodeTupleSchemeFactory
    implements SchemeFactory {
        private TAggregationNodeTupleSchemeFactory() {
        }

        public TAggregationNodeTupleScheme getScheme() {
            return new TAggregationNodeTupleScheme();
        }
    }

    private static class TAggregationNodeStandardScheme
    extends StandardScheme<TAggregationNode> {
        private TAggregationNodeStandardScheme() {
        }

        @Override
        public void read(TProtocol iprot, TAggregationNode struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 15) {
                            TList _list488 = iprot.readListBegin();
                            struct.grouping_exprs = new ArrayList<TExpr>(_list488.size);
                            for (int _i490 = 0; _i490 < _list488.size; ++_i490) {
                                TExpr _elem489 = new TExpr();
                                _elem489.read(iprot);
                                struct.grouping_exprs.add(_elem489);
                            }
                            iprot.readListEnd();
                            struct.setGroupingExprsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 15) {
                            TList _list491 = iprot.readListBegin();
                            struct.aggregate_functions = new ArrayList<TExpr>(_list491.size);
                            for (int _i493 = 0; _i493 < _list491.size; ++_i493) {
                                TExpr _elem492 = new TExpr();
                                _elem492.read(iprot);
                                struct.aggregate_functions.add(_elem492);
                            }
                            iprot.readListEnd();
                            struct.setAggregateFunctionsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 8) {
                            struct.intermediate_tuple_id = iprot.readI32();
                            struct.setIntermediateTupleIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 8) {
                            struct.output_tuple_id = iprot.readI32();
                            struct.setOutputTupleIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 2) {
                            struct.need_finalize = iprot.readBool();
                            struct.setNeedFinalizeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 2) {
                            struct.use_streaming_preaggregation = iprot.readBool();
                            struct.setUseStreamingPreaggregationIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 15) {
                            TList _list494 = iprot.readListBegin();
                            struct.agg_sort_infos = new ArrayList<TSortInfo>(_list494.size);
                            for (int _i496 = 0; _i496 < _list494.size; ++_i496) {
                                TSortInfo _elem495 = new TSortInfo();
                                _elem495.read(iprot);
                                struct.agg_sort_infos.add(_elem495);
                            }
                            iprot.readListEnd();
                            struct.setAggSortInfosIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 2) {
                            struct.is_first_phase = iprot.readBool();
                            struct.setIsFirstPhaseIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 2) {
                            struct.use_fixed_length_serialization_opt = iprot.readBool();
                            struct.setUseFixedLengthSerializationOptIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip(iprot, schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip(iprot, schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetIntermediateTupleId()) {
                throw new TProtocolException("Required field 'intermediate_tuple_id' was not found in serialized data! Struct: " + this.toString());
            }
            if (!struct.isSetOutputTupleId()) {
                throw new TProtocolException("Required field 'output_tuple_id' was not found in serialized data! Struct: " + this.toString());
            }
            if (!struct.isSetNeedFinalize()) {
                throw new TProtocolException("Required field 'need_finalize' was not found in serialized data! Struct: " + this.toString());
            }
            struct.validate();
        }

        @Override
        public void write(TProtocol oprot, TAggregationNode struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.grouping_exprs != null && struct.isSetGroupingExprs()) {
                oprot.writeFieldBegin(GROUPING_EXPRS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.grouping_exprs.size()));
                for (TExpr _iter497 : struct.grouping_exprs) {
                    _iter497.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.aggregate_functions != null) {
                oprot.writeFieldBegin(AGGREGATE_FUNCTIONS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.aggregate_functions.size()));
                for (TExpr _iter498 : struct.aggregate_functions) {
                    _iter498.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(INTERMEDIATE_TUPLE_ID_FIELD_DESC);
            oprot.writeI32(struct.intermediate_tuple_id);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(OUTPUT_TUPLE_ID_FIELD_DESC);
            oprot.writeI32(struct.output_tuple_id);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(NEED_FINALIZE_FIELD_DESC);
            oprot.writeBool(struct.need_finalize);
            oprot.writeFieldEnd();
            if (struct.isSetUseStreamingPreaggregation()) {
                oprot.writeFieldBegin(USE_STREAMING_PREAGGREGATION_FIELD_DESC);
                oprot.writeBool(struct.use_streaming_preaggregation);
                oprot.writeFieldEnd();
            }
            if (struct.agg_sort_infos != null && struct.isSetAggSortInfos()) {
                oprot.writeFieldBegin(AGG_SORT_INFOS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.agg_sort_infos.size()));
                for (TSortInfo _iter499 : struct.agg_sort_infos) {
                    _iter499.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.isSetIsFirstPhase()) {
                oprot.writeFieldBegin(IS_FIRST_PHASE_FIELD_DESC);
                oprot.writeBool(struct.is_first_phase);
                oprot.writeFieldEnd();
            }
            if (struct.isSetUseFixedLengthSerializationOpt()) {
                oprot.writeFieldBegin(USE_FIXED_LENGTH_SERIALIZATION_OPT_FIELD_DESC);
                oprot.writeBool(struct.use_fixed_length_serialization_opt);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TAggregationNodeStandardSchemeFactory
    implements SchemeFactory {
        private TAggregationNodeStandardSchemeFactory() {
        }

        public TAggregationNodeStandardScheme getScheme() {
            return new TAggregationNodeStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        GROUPING_EXPRS(1, "grouping_exprs"),
        AGGREGATE_FUNCTIONS(2, "aggregate_functions"),
        INTERMEDIATE_TUPLE_ID(3, "intermediate_tuple_id"),
        OUTPUT_TUPLE_ID(4, "output_tuple_id"),
        NEED_FINALIZE(5, "need_finalize"),
        USE_STREAMING_PREAGGREGATION(6, "use_streaming_preaggregation"),
        AGG_SORT_INFOS(7, "agg_sort_infos"),
        IS_FIRST_PHASE(8, "is_first_phase"),
        USE_FIXED_LENGTH_SERIALIZATION_OPT(9, "use_fixed_length_serialization_opt");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return GROUPING_EXPRS;
                }
                case 2: {
                    return AGGREGATE_FUNCTIONS;
                }
                case 3: {
                    return INTERMEDIATE_TUPLE_ID;
                }
                case 4: {
                    return OUTPUT_TUPLE_ID;
                }
                case 5: {
                    return NEED_FINALIZE;
                }
                case 6: {
                    return USE_STREAMING_PREAGGREGATION;
                }
                case 7: {
                    return AGG_SORT_INFOS;
                }
                case 8: {
                    return IS_FIRST_PHASE;
                }
                case 9: {
                    return USE_FIXED_LENGTH_SERIALIZATION_OPT;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        @Override
        public short getThriftFieldId() {
            return this._thriftId;
        }

        @Override
        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

