/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2.dpp;

import java.math.BigInteger;
import org.apache.doris.load.loadv2.dpp.ColumnParser;

class LargeIntParser
extends ColumnParser {
    private BigInteger maxValue = new BigInteger("170141183460469231731687303715884105727");
    private BigInteger minValue = new BigInteger("-170141183460469231731687303715884105728");

    LargeIntParser() {
    }

    @Override
    public boolean parse(String value) {
        try {
            BigInteger inputValue = new BigInteger(value);
            return inputValue.compareTo(this.maxValue) < 0 && inputValue.compareTo(this.minValue) > 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
        catch (ArithmeticException e) {
            LOG.warn("int value is too big even for java BigInteger,value={}" + value);
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException("large int parse failed:" + value, e);
        }
    }
}

