/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.load.loadv2.dpp;

import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import org.apache.doris.common.SparkDppException;
import org.apache.doris.load.loadv2.dpp.BigIntParser;
import org.apache.doris.load.loadv2.dpp.BooleanParser;
import org.apache.doris.load.loadv2.dpp.DateParser;
import org.apache.doris.load.loadv2.dpp.DatetimeParser;
import org.apache.doris.load.loadv2.dpp.DecimalParser;
import org.apache.doris.load.loadv2.dpp.DoubleParser;
import org.apache.doris.load.loadv2.dpp.FloatParser;
import org.apache.doris.load.loadv2.dpp.IntParser;
import org.apache.doris.load.loadv2.dpp.LargeIntParser;
import org.apache.doris.load.loadv2.dpp.SmallIntParser;
import org.apache.doris.load.loadv2.dpp.StringParser;
import org.apache.doris.load.loadv2.dpp.StringTypeParser;
import org.apache.doris.load.loadv2.dpp.TinyIntParser;
import org.apache.doris.load.loadv2.etl.EtlJobConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ColumnParser
implements Serializable {
    protected static final Logger LOG = LoggerFactory.getLogger(ColumnParser.class);
    public static final DateTimeFormatter DATE_FORMATTER = new DateTimeFormatterBuilder().appendPattern("uuuu-MM-dd").toFormatter();
    public static final DateTimeFormatter DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("uuuu-MM-dd HH:mm:ss").toFormatter();

    public static ColumnParser create(EtlJobConfig.EtlColumn etlColumn) throws SparkDppException {
        String columnType = etlColumn.columnType;
        if (columnType.equalsIgnoreCase("TINYINT")) {
            return new TinyIntParser();
        }
        if (columnType.equalsIgnoreCase("SMALLINT")) {
            return new SmallIntParser();
        }
        if (columnType.equalsIgnoreCase("INT")) {
            return new IntParser();
        }
        if (columnType.equalsIgnoreCase("BIGINT")) {
            return new BigIntParser();
        }
        if (columnType.equalsIgnoreCase("FLOAT")) {
            return new FloatParser();
        }
        if (columnType.equalsIgnoreCase("DOUBLE")) {
            return new DoubleParser();
        }
        if (columnType.equalsIgnoreCase("BOOLEAN")) {
            return new BooleanParser();
        }
        if (columnType.equalsIgnoreCase("DATE")) {
            return new DateParser();
        }
        if (columnType.equalsIgnoreCase("DATETIME")) {
            return new DatetimeParser();
        }
        if (columnType.equalsIgnoreCase("STRING") || columnType.equalsIgnoreCase("TEXT")) {
            return new StringTypeParser(etlColumn);
        }
        if (columnType.equalsIgnoreCase("VARCHAR") || columnType.equalsIgnoreCase("CHAR") || columnType.equalsIgnoreCase("BITMAP") || columnType.equalsIgnoreCase("HLL")) {
            return new StringParser(etlColumn);
        }
        if (columnType.equalsIgnoreCase("DECIMALV2") || columnType.equalsIgnoreCase("DECIMAL32") || columnType.equalsIgnoreCase("DECIMAL64") || columnType.equalsIgnoreCase("DECIMAL128")) {
            return new DecimalParser(etlColumn);
        }
        if (columnType.equalsIgnoreCase("LARGEINT")) {
            return new LargeIntParser();
        }
        throw new SparkDppException("unsupported type:" + columnType);
    }

    public abstract boolean parse(String var1);
}

