/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.jmockit;

import java.util.regex.Pattern;
import org.apache.doris.common.jmockit.AutoType;
import org.apache.doris.common.jmockit.GeneratedClasses;

public final class ParameterReflection {
    public static final Class<?>[] NO_PARAMETERS = new Class[0];
    public static final Pattern JAVA_LANG = Pattern.compile("java.lang.", 16);

    private ParameterReflection() {
    }

    static boolean matchesParameterTypes(Class<?>[] declaredTypes, Class<?>[] specifiedTypes) {
        if (declaredTypes == null || specifiedTypes == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < declaredTypes.length; ++i) {
            Class<?> declaredType = declaredTypes[i];
            Class<?> specifiedType = specifiedTypes[i];
            if (ParameterReflection.isSameType(declaredType, specifiedType)) continue;
            return false;
        }
        return true;
    }

    static boolean acceptsArgumentTypes(Class<?>[] paramTypes, Class<?>[] argTypes) {
        if (paramTypes == null || argTypes == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> parType = paramTypes[i];
            Class<?> argType = argTypes[i];
            if (ParameterReflection.isSameType(parType, argType) || parType.isAssignableFrom(argType)) continue;
            return false;
        }
        return true;
    }

    static Class<?>[] getArgumentTypesFromArgumentValues(Object ... args2) {
        if (args2 == null) {
            throw new IllegalArgumentException();
        }
        if (args2.length == 0) {
            return NO_PARAMETERS;
        }
        Class[] argTypes = new Class[args2.length];
        for (int i = 0; i < args2.length; ++i) {
            argTypes[i] = ParameterReflection.getArgumentTypeFromArgumentValue(i, args2);
        }
        return argTypes;
    }

    static Class<?> getArgumentTypeFromArgumentValue(int i, Object[] args2) {
        Class<?> argType;
        Object arg = args2[i];
        if (arg == null) {
            throw new IllegalArgumentException("Invalid null value passed as argument " + i);
        }
        if (arg instanceof Class) {
            argType = (Class<?>)arg;
            args2[i] = null;
        } else {
            argType = GeneratedClasses.getMockedClass(arg);
        }
        return argType;
    }

    static boolean hasMoreSpecificTypes(Class<?>[] currentTypes, Class<?>[] previousTypes) {
        if (currentTypes == null || previousTypes == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < currentTypes.length; ++i) {
            Class<?> previous;
            Class<?> current = ParameterReflection.wrappedIfPrimitive(currentTypes[i]);
            if (current == (previous = ParameterReflection.wrappedIfPrimitive(previousTypes[i])) || !previous.isAssignableFrom(current)) continue;
            return true;
        }
        return false;
    }

    static String getParameterTypesDescription(Class<?>[] paramTypes) {
        if (paramTypes == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder paramTypesDesc = new StringBuilder(200);
        paramTypesDesc.append('(');
        String sep = "";
        for (Class<?> paramType : paramTypes) {
            String typeName = JAVA_LANG.matcher(paramType.getCanonicalName()).replaceAll("");
            paramTypesDesc.append(sep).append(typeName);
            sep = ", ";
        }
        paramTypesDesc.append(')');
        return paramTypesDesc.toString();
    }

    static Object[] argumentsWithExtraFirstValue(Object[] args2, Object firstValue) {
        Object[] args22 = new Object[1 + args2.length];
        args22[0] = firstValue;
        System.arraycopy(args2, 0, args22, 1, args2.length);
        return args22;
    }

    private static Class<?> wrappedIfPrimitive(Class<?> parameterType) {
        if (parameterType.isPrimitive()) {
            Class<?> wrapperType = AutoType.getWrapperType(parameterType);
            assert (wrapperType != null);
            return wrapperType;
        }
        return parameterType;
    }

    private static boolean isSameType(Class<?> firstType, Class<?> secondType) {
        return firstType == secondType || firstType.isPrimitive() && firstType == AutoType.getPrimitiveType(secondType) || secondType.isPrimitive() && secondType == AutoType.getPrimitiveType(firstType);
    }
}

