/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.jmockit;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.doris.common.jmockit.ParameterReflection;

public final class ConstructorReflection {
    private ConstructorReflection() {
    }

    public static <T> T invoke(Constructor<T> constructor, Object ... initArgs) {
        if (constructor == null || initArgs == null) {
            throw new IllegalArgumentException();
        }
        ConstructorReflection.makeAccessible(constructor);
        try {
            return constructor.newInstance(initArgs);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IllegalStateException("Should never get here", cause);
        }
    }

    public static <T> T newInstance(Class<? extends T> aClass, Object ... nonNullArgs) {
        if (aClass == null || nonNullArgs == null) {
            throw new IllegalArgumentException();
        }
        Class<?>[] argTypes = ParameterReflection.getArgumentTypesFromArgumentValues(nonNullArgs);
        Constructor<T> constructor = ConstructorReflection.findCompatibleConstructor(aClass, argTypes);
        return ConstructorReflection.invoke(constructor, nonNullArgs);
    }

    private static <T> T newInstance(Class<T> aClass) {
        return ConstructorReflection.newInstance(aClass, ParameterReflection.NO_PARAMETERS);
    }

    public static <T> T newInstanceUsingDefaultConstructor(Class<T> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException();
        }
        try {
            return aClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            return ConstructorReflection.newInstance(aClass);
        }
    }

    public static <T> T newInstanceUsingDefaultConstructorIfAvailable(Class<T> aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException();
        }
        try {
            return aClass.newInstance();
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static <T> T newInnerInstance(Class<? extends T> innerClass, Object outerInstance, Object ... nonNullArgs) {
        if (innerClass == null || outerInstance == null || nonNullArgs == null) {
            throw new IllegalArgumentException();
        }
        Object[] initArgs = ParameterReflection.argumentsWithExtraFirstValue(nonNullArgs, outerInstance);
        return ConstructorReflection.newInstance(innerClass, initArgs);
    }

    private static <T> Constructor<T> findCompatibleConstructor(Class<?> theClass, Class<?>[] argTypes) {
        Constructor<?>[] declaredConstructors;
        Constructor<?>[] declaredConstructorsArray;
        if (theClass == null || argTypes == null) {
            throw new IllegalArgumentException();
        }
        Constructor<?> found = null;
        Class<?>[] foundParameters = null;
        for (Constructor<?> declaredConstructor : declaredConstructorsArray = (declaredConstructors = theClass.getDeclaredConstructors())) {
            Class<?>[] declaredParamTypes = declaredConstructor.getParameterTypes();
            int gap = declaredParamTypes.length - argTypes.length;
            if (gap != 0 || !ParameterReflection.matchesParameterTypes(declaredParamTypes, argTypes) && !ParameterReflection.acceptsArgumentTypes(declaredParamTypes, argTypes) || found != null && !ParameterReflection.hasMoreSpecificTypes(declaredParamTypes, foundParameters)) continue;
            found = declaredConstructor;
            foundParameters = declaredParamTypes;
        }
        if (found != null) {
            return found;
        }
        Class<?> declaringClass = theClass.getDeclaringClass();
        Class<?>[] paramTypes = declaredConstructors[0].getParameterTypes();
        if (paramTypes[0] == declaringClass && paramTypes.length > argTypes.length) {
            throw new IllegalArgumentException("Invalid instantiation of inner class; use newInnerInstance instead");
        }
        String argTypesDesc = ParameterReflection.getParameterTypesDescription(argTypes);
        throw new IllegalArgumentException("No compatible constructor found: " + theClass.getSimpleName() + argTypesDesc);
    }

    public static void makeAccessible(AccessibleObject classMember) {
        if (!classMember.isAccessible()) {
            classMember.setAccessible(true);
        }
    }
}

