/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.format;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.parquet.format.ColumnCryptoMetaData;
import org.apache.parquet.format.ColumnMetaData;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class ColumnChunk
implements TBase<ColumnChunk, _Fields>,
Serializable,
Cloneable,
Comparable<ColumnChunk> {
    private static final TStruct STRUCT_DESC = new TStruct("ColumnChunk");
    private static final TField FILE_PATH_FIELD_DESC = new TField("file_path", 11, 1);
    private static final TField FILE_OFFSET_FIELD_DESC = new TField("file_offset", 10, 2);
    private static final TField META_DATA_FIELD_DESC = new TField("meta_data", 12, 3);
    private static final TField OFFSET_INDEX_OFFSET_FIELD_DESC = new TField("offset_index_offset", 10, 4);
    private static final TField OFFSET_INDEX_LENGTH_FIELD_DESC = new TField("offset_index_length", 8, 5);
    private static final TField COLUMN_INDEX_OFFSET_FIELD_DESC = new TField("column_index_offset", 10, 6);
    private static final TField COLUMN_INDEX_LENGTH_FIELD_DESC = new TField("column_index_length", 8, 7);
    private static final TField CRYPTO_METADATA_FIELD_DESC = new TField("crypto_metadata", 12, 8);
    private static final TField ENCRYPTED_COLUMN_METADATA_FIELD_DESC = new TField("encrypted_column_metadata", 11, 9);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new ColumnChunkStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new ColumnChunkTupleSchemeFactory();
    @Nullable
    public String file_path;
    public long file_offset;
    @Nullable
    public ColumnMetaData meta_data;
    public long offset_index_offset;
    public int offset_index_length;
    public long column_index_offset;
    public int column_index_length;
    @Nullable
    public ColumnCryptoMetaData crypto_metadata;
    @Nullable
    public ByteBuffer encrypted_column_metadata;
    private static final int __FILE_OFFSET_ISSET_ID = 0;
    private static final int __OFFSET_INDEX_OFFSET_ISSET_ID = 1;
    private static final int __OFFSET_INDEX_LENGTH_ISSET_ID = 2;
    private static final int __COLUMN_INDEX_OFFSET_ISSET_ID = 3;
    private static final int __COLUMN_INDEX_LENGTH_ISSET_ID = 4;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.FILE_PATH, _Fields.META_DATA, _Fields.OFFSET_INDEX_OFFSET, _Fields.OFFSET_INDEX_LENGTH, _Fields.COLUMN_INDEX_OFFSET, _Fields.COLUMN_INDEX_LENGTH, _Fields.CRYPTO_METADATA, _Fields.ENCRYPTED_COLUMN_METADATA};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public ColumnChunk() {
    }

    public ColumnChunk(long file_offset) {
        this();
        this.file_offset = file_offset;
        this.setFileOffsetIsSet(true);
    }

    public ColumnChunk(ColumnChunk other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetFilePath()) {
            this.file_path = other.file_path;
        }
        this.file_offset = other.file_offset;
        if (other.isSetMetaData()) {
            this.meta_data = new ColumnMetaData(other.meta_data);
        }
        this.offset_index_offset = other.offset_index_offset;
        this.offset_index_length = other.offset_index_length;
        this.column_index_offset = other.column_index_offset;
        this.column_index_length = other.column_index_length;
        if (other.isSetCryptoMetadata()) {
            this.crypto_metadata = new ColumnCryptoMetaData(other.crypto_metadata);
        }
        if (other.isSetEncryptedColumnMetadata()) {
            this.encrypted_column_metadata = TBaseHelper.copyBinary((ByteBuffer)other.encrypted_column_metadata);
        }
    }

    public ColumnChunk deepCopy() {
        return new ColumnChunk(this);
    }

    public void clear() {
        this.file_path = null;
        this.setFileOffsetIsSet(false);
        this.file_offset = 0L;
        this.meta_data = null;
        this.setOffsetIndexOffsetIsSet(false);
        this.offset_index_offset = 0L;
        this.setOffsetIndexLengthIsSet(false);
        this.offset_index_length = 0;
        this.setColumnIndexOffsetIsSet(false);
        this.column_index_offset = 0L;
        this.setColumnIndexLengthIsSet(false);
        this.column_index_length = 0;
        this.crypto_metadata = null;
        this.encrypted_column_metadata = null;
    }

    @Nullable
    public String getFilePath() {
        return this.file_path;
    }

    public ColumnChunk setFilePath(@Nullable String file_path) {
        this.file_path = file_path;
        return this;
    }

    public void unsetFilePath() {
        this.file_path = null;
    }

    public boolean isSetFilePath() {
        return this.file_path != null;
    }

    public void setFilePathIsSet(boolean value) {
        if (!value) {
            this.file_path = null;
        }
    }

    public long getFileOffset() {
        return this.file_offset;
    }

    public ColumnChunk setFileOffset(long file_offset) {
        this.file_offset = file_offset;
        this.setFileOffsetIsSet(true);
        return this;
    }

    public void unsetFileOffset() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetFileOffset() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setFileOffsetIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    @Nullable
    public ColumnMetaData getMetaData() {
        return this.meta_data;
    }

    public ColumnChunk setMetaData(@Nullable ColumnMetaData meta_data) {
        this.meta_data = meta_data;
        return this;
    }

    public void unsetMetaData() {
        this.meta_data = null;
    }

    public boolean isSetMetaData() {
        return this.meta_data != null;
    }

    public void setMetaDataIsSet(boolean value) {
        if (!value) {
            this.meta_data = null;
        }
    }

    public long getOffsetIndexOffset() {
        return this.offset_index_offset;
    }

    public ColumnChunk setOffsetIndexOffset(long offset_index_offset) {
        this.offset_index_offset = offset_index_offset;
        this.setOffsetIndexOffsetIsSet(true);
        return this;
    }

    public void unsetOffsetIndexOffset() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetOffsetIndexOffset() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setOffsetIndexOffsetIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public int getOffsetIndexLength() {
        return this.offset_index_length;
    }

    public ColumnChunk setOffsetIndexLength(int offset_index_length) {
        this.offset_index_length = offset_index_length;
        this.setOffsetIndexLengthIsSet(true);
        return this;
    }

    public void unsetOffsetIndexLength() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetOffsetIndexLength() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setOffsetIndexLengthIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public long getColumnIndexOffset() {
        return this.column_index_offset;
    }

    public ColumnChunk setColumnIndexOffset(long column_index_offset) {
        this.column_index_offset = column_index_offset;
        this.setColumnIndexOffsetIsSet(true);
        return this;
    }

    public void unsetColumnIndexOffset() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)3);
    }

    public boolean isSetColumnIndexOffset() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)3);
    }

    public void setColumnIndexOffsetIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)3, (boolean)value);
    }

    public int getColumnIndexLength() {
        return this.column_index_length;
    }

    public ColumnChunk setColumnIndexLength(int column_index_length) {
        this.column_index_length = column_index_length;
        this.setColumnIndexLengthIsSet(true);
        return this;
    }

    public void unsetColumnIndexLength() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)4);
    }

    public boolean isSetColumnIndexLength() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)4);
    }

    public void setColumnIndexLengthIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)4, (boolean)value);
    }

    @Nullable
    public ColumnCryptoMetaData getCryptoMetadata() {
        return this.crypto_metadata;
    }

    public ColumnChunk setCryptoMetadata(@Nullable ColumnCryptoMetaData crypto_metadata) {
        this.crypto_metadata = crypto_metadata;
        return this;
    }

    public void unsetCryptoMetadata() {
        this.crypto_metadata = null;
    }

    public boolean isSetCryptoMetadata() {
        return this.crypto_metadata != null;
    }

    public void setCryptoMetadataIsSet(boolean value) {
        if (!value) {
            this.crypto_metadata = null;
        }
    }

    public byte[] getEncryptedColumnMetadata() {
        this.setEncryptedColumnMetadata(TBaseHelper.rightSize((ByteBuffer)this.encrypted_column_metadata));
        return this.encrypted_column_metadata == null ? null : this.encrypted_column_metadata.array();
    }

    public ByteBuffer bufferForEncryptedColumnMetadata() {
        return TBaseHelper.copyBinary((ByteBuffer)this.encrypted_column_metadata);
    }

    public ColumnChunk setEncryptedColumnMetadata(byte[] encrypted_column_metadata) {
        this.encrypted_column_metadata = encrypted_column_metadata == null ? (ByteBuffer)null : ByteBuffer.wrap((byte[])encrypted_column_metadata.clone());
        return this;
    }

    public ColumnChunk setEncryptedColumnMetadata(@Nullable ByteBuffer encrypted_column_metadata) {
        this.encrypted_column_metadata = TBaseHelper.copyBinary((ByteBuffer)encrypted_column_metadata);
        return this;
    }

    public void unsetEncryptedColumnMetadata() {
        this.encrypted_column_metadata = null;
    }

    public boolean isSetEncryptedColumnMetadata() {
        return this.encrypted_column_metadata != null;
    }

    public void setEncryptedColumnMetadataIsSet(boolean value) {
        if (!value) {
            this.encrypted_column_metadata = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case FILE_PATH: {
                if (value == null) {
                    this.unsetFilePath();
                    break;
                }
                this.setFilePath((String)value);
                break;
            }
            case FILE_OFFSET: {
                if (value == null) {
                    this.unsetFileOffset();
                    break;
                }
                this.setFileOffset((Long)value);
                break;
            }
            case META_DATA: {
                if (value == null) {
                    this.unsetMetaData();
                    break;
                }
                this.setMetaData((ColumnMetaData)value);
                break;
            }
            case OFFSET_INDEX_OFFSET: {
                if (value == null) {
                    this.unsetOffsetIndexOffset();
                    break;
                }
                this.setOffsetIndexOffset((Long)value);
                break;
            }
            case OFFSET_INDEX_LENGTH: {
                if (value == null) {
                    this.unsetOffsetIndexLength();
                    break;
                }
                this.setOffsetIndexLength((Integer)value);
                break;
            }
            case COLUMN_INDEX_OFFSET: {
                if (value == null) {
                    this.unsetColumnIndexOffset();
                    break;
                }
                this.setColumnIndexOffset((Long)value);
                break;
            }
            case COLUMN_INDEX_LENGTH: {
                if (value == null) {
                    this.unsetColumnIndexLength();
                    break;
                }
                this.setColumnIndexLength((Integer)value);
                break;
            }
            case CRYPTO_METADATA: {
                if (value == null) {
                    this.unsetCryptoMetadata();
                    break;
                }
                this.setCryptoMetadata((ColumnCryptoMetaData)((Object)value));
                break;
            }
            case ENCRYPTED_COLUMN_METADATA: {
                if (value == null) {
                    this.unsetEncryptedColumnMetadata();
                    break;
                }
                if (value instanceof byte[]) {
                    this.setEncryptedColumnMetadata((byte[])value);
                    break;
                }
                this.setEncryptedColumnMetadata((ByteBuffer)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case FILE_PATH: {
                return this.getFilePath();
            }
            case FILE_OFFSET: {
                return this.getFileOffset();
            }
            case META_DATA: {
                return this.getMetaData();
            }
            case OFFSET_INDEX_OFFSET: {
                return this.getOffsetIndexOffset();
            }
            case OFFSET_INDEX_LENGTH: {
                return this.getOffsetIndexLength();
            }
            case COLUMN_INDEX_OFFSET: {
                return this.getColumnIndexOffset();
            }
            case COLUMN_INDEX_LENGTH: {
                return this.getColumnIndexLength();
            }
            case CRYPTO_METADATA: {
                return this.getCryptoMetadata();
            }
            case ENCRYPTED_COLUMN_METADATA: {
                return this.getEncryptedColumnMetadata();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case FILE_PATH: {
                return this.isSetFilePath();
            }
            case FILE_OFFSET: {
                return this.isSetFileOffset();
            }
            case META_DATA: {
                return this.isSetMetaData();
            }
            case OFFSET_INDEX_OFFSET: {
                return this.isSetOffsetIndexOffset();
            }
            case OFFSET_INDEX_LENGTH: {
                return this.isSetOffsetIndexLength();
            }
            case COLUMN_INDEX_OFFSET: {
                return this.isSetColumnIndexOffset();
            }
            case COLUMN_INDEX_LENGTH: {
                return this.isSetColumnIndexLength();
            }
            case CRYPTO_METADATA: {
                return this.isSetCryptoMetadata();
            }
            case ENCRYPTED_COLUMN_METADATA: {
                return this.isSetEncryptedColumnMetadata();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof ColumnChunk) {
            return this.equals((ColumnChunk)that);
        }
        return false;
    }

    public boolean equals(ColumnChunk that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_file_path = this.isSetFilePath();
        boolean that_present_file_path = that.isSetFilePath();
        if (this_present_file_path || that_present_file_path) {
            if (!this_present_file_path || !that_present_file_path) {
                return false;
            }
            if (!this.file_path.equals(that.file_path)) {
                return false;
            }
        }
        boolean this_present_file_offset = true;
        boolean that_present_file_offset = true;
        if (this_present_file_offset || that_present_file_offset) {
            if (!this_present_file_offset || !that_present_file_offset) {
                return false;
            }
            if (this.file_offset != that.file_offset) {
                return false;
            }
        }
        boolean this_present_meta_data = this.isSetMetaData();
        boolean that_present_meta_data = that.isSetMetaData();
        if (this_present_meta_data || that_present_meta_data) {
            if (!this_present_meta_data || !that_present_meta_data) {
                return false;
            }
            if (!this.meta_data.equals(that.meta_data)) {
                return false;
            }
        }
        boolean this_present_offset_index_offset = this.isSetOffsetIndexOffset();
        boolean that_present_offset_index_offset = that.isSetOffsetIndexOffset();
        if (this_present_offset_index_offset || that_present_offset_index_offset) {
            if (!this_present_offset_index_offset || !that_present_offset_index_offset) {
                return false;
            }
            if (this.offset_index_offset != that.offset_index_offset) {
                return false;
            }
        }
        boolean this_present_offset_index_length = this.isSetOffsetIndexLength();
        boolean that_present_offset_index_length = that.isSetOffsetIndexLength();
        if (this_present_offset_index_length || that_present_offset_index_length) {
            if (!this_present_offset_index_length || !that_present_offset_index_length) {
                return false;
            }
            if (this.offset_index_length != that.offset_index_length) {
                return false;
            }
        }
        boolean this_present_column_index_offset = this.isSetColumnIndexOffset();
        boolean that_present_column_index_offset = that.isSetColumnIndexOffset();
        if (this_present_column_index_offset || that_present_column_index_offset) {
            if (!this_present_column_index_offset || !that_present_column_index_offset) {
                return false;
            }
            if (this.column_index_offset != that.column_index_offset) {
                return false;
            }
        }
        boolean this_present_column_index_length = this.isSetColumnIndexLength();
        boolean that_present_column_index_length = that.isSetColumnIndexLength();
        if (this_present_column_index_length || that_present_column_index_length) {
            if (!this_present_column_index_length || !that_present_column_index_length) {
                return false;
            }
            if (this.column_index_length != that.column_index_length) {
                return false;
            }
        }
        boolean this_present_crypto_metadata = this.isSetCryptoMetadata();
        boolean that_present_crypto_metadata = that.isSetCryptoMetadata();
        if (this_present_crypto_metadata || that_present_crypto_metadata) {
            if (!this_present_crypto_metadata || !that_present_crypto_metadata) {
                return false;
            }
            if (!this.crypto_metadata.equals(that.crypto_metadata)) {
                return false;
            }
        }
        boolean this_present_encrypted_column_metadata = this.isSetEncryptedColumnMetadata();
        boolean that_present_encrypted_column_metadata = that.isSetEncryptedColumnMetadata();
        if (this_present_encrypted_column_metadata || that_present_encrypted_column_metadata) {
            if (!this_present_encrypted_column_metadata || !that_present_encrypted_column_metadata) {
                return false;
            }
            if (!this.encrypted_column_metadata.equals(that.encrypted_column_metadata)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetFilePath() ? 131071 : 524287);
        if (this.isSetFilePath()) {
            hashCode = hashCode * 8191 + this.file_path.hashCode();
        }
        hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.file_offset);
        hashCode = hashCode * 8191 + (this.isSetMetaData() ? 131071 : 524287);
        if (this.isSetMetaData()) {
            hashCode = hashCode * 8191 + this.meta_data.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetOffsetIndexOffset() ? 131071 : 524287);
        if (this.isSetOffsetIndexOffset()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.offset_index_offset);
        }
        hashCode = hashCode * 8191 + (this.isSetOffsetIndexLength() ? 131071 : 524287);
        if (this.isSetOffsetIndexLength()) {
            hashCode = hashCode * 8191 + this.offset_index_length;
        }
        hashCode = hashCode * 8191 + (this.isSetColumnIndexOffset() ? 131071 : 524287);
        if (this.isSetColumnIndexOffset()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.column_index_offset);
        }
        hashCode = hashCode * 8191 + (this.isSetColumnIndexLength() ? 131071 : 524287);
        if (this.isSetColumnIndexLength()) {
            hashCode = hashCode * 8191 + this.column_index_length;
        }
        hashCode = hashCode * 8191 + (this.isSetCryptoMetadata() ? 131071 : 524287);
        if (this.isSetCryptoMetadata()) {
            hashCode = hashCode * 8191 + this.crypto_metadata.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetEncryptedColumnMetadata() ? 131071 : 524287);
        if (this.isSetEncryptedColumnMetadata()) {
            hashCode = hashCode * 8191 + this.encrypted_column_metadata.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(ColumnChunk other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetFilePath(), other.isSetFilePath());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFilePath() && (lastComparison = TBaseHelper.compareTo((String)this.file_path, (String)other.file_path)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetFileOffset(), other.isSetFileOffset());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFileOffset() && (lastComparison = TBaseHelper.compareTo((long)this.file_offset, (long)other.file_offset)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetMetaData(), other.isSetMetaData());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMetaData() && (lastComparison = TBaseHelper.compareTo((Comparable)this.meta_data, (Comparable)other.meta_data)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetOffsetIndexOffset(), other.isSetOffsetIndexOffset());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOffsetIndexOffset() && (lastComparison = TBaseHelper.compareTo((long)this.offset_index_offset, (long)other.offset_index_offset)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetOffsetIndexLength(), other.isSetOffsetIndexLength());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetOffsetIndexLength() && (lastComparison = TBaseHelper.compareTo((int)this.offset_index_length, (int)other.offset_index_length)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetColumnIndexOffset(), other.isSetColumnIndexOffset());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumnIndexOffset() && (lastComparison = TBaseHelper.compareTo((long)this.column_index_offset, (long)other.column_index_offset)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetColumnIndexLength(), other.isSetColumnIndexLength());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumnIndexLength() && (lastComparison = TBaseHelper.compareTo((int)this.column_index_length, (int)other.column_index_length)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetCryptoMetadata(), other.isSetCryptoMetadata());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCryptoMetadata() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.crypto_metadata), (Comparable)((Object)other.crypto_metadata))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetEncryptedColumnMetadata(), other.isSetEncryptedColumnMetadata());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEncryptedColumnMetadata() && (lastComparison = TBaseHelper.compareTo((Comparable)this.encrypted_column_metadata, (Comparable)other.encrypted_column_metadata)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        ColumnChunk.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        ColumnChunk.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ColumnChunk(");
        boolean first = true;
        if (this.isSetFilePath()) {
            sb.append("file_path:");
            if (this.file_path == null) {
                sb.append("null");
            } else {
                sb.append(this.file_path);
            }
            first = false;
        }
        if (!first) {
            sb.append(", ");
        }
        sb.append("file_offset:");
        sb.append(this.file_offset);
        first = false;
        if (this.isSetMetaData()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("meta_data:");
            if (this.meta_data == null) {
                sb.append("null");
            } else {
                sb.append(this.meta_data);
            }
            first = false;
        }
        if (this.isSetOffsetIndexOffset()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("offset_index_offset:");
            sb.append(this.offset_index_offset);
            first = false;
        }
        if (this.isSetOffsetIndexLength()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("offset_index_length:");
            sb.append(this.offset_index_length);
            first = false;
        }
        if (this.isSetColumnIndexOffset()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("column_index_offset:");
            sb.append(this.column_index_offset);
            first = false;
        }
        if (this.isSetColumnIndexLength()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("column_index_length:");
            sb.append(this.column_index_length);
            first = false;
        }
        if (this.isSetCryptoMetadata()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("crypto_metadata:");
            if (this.crypto_metadata == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.crypto_metadata);
            }
            first = false;
        }
        if (this.isSetEncryptedColumnMetadata()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("encrypted_column_metadata:");
            if (this.encrypted_column_metadata == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString((ByteBuffer)this.encrypted_column_metadata, (StringBuilder)sb);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.meta_data != null) {
            this.meta_data.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.FILE_PATH, new FieldMetaData("file_path", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.FILE_OFFSET, new FieldMetaData("file_offset", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.META_DATA, new FieldMetaData("meta_data", 2, (FieldValueMetaData)new StructMetaData(12, ColumnMetaData.class)));
        tmpMap.put(_Fields.OFFSET_INDEX_OFFSET, new FieldMetaData("offset_index_offset", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.OFFSET_INDEX_LENGTH, new FieldMetaData("offset_index_length", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.COLUMN_INDEX_OFFSET, new FieldMetaData("column_index_offset", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.COLUMN_INDEX_LENGTH, new FieldMetaData("column_index_length", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.CRYPTO_METADATA, new FieldMetaData("crypto_metadata", 2, (FieldValueMetaData)new StructMetaData(12, ColumnCryptoMetaData.class)));
        tmpMap.put(_Fields.ENCRYPTED_COLUMN_METADATA, new FieldMetaData("encrypted_column_metadata", 2, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(ColumnChunk.class, metaDataMap);
    }

    private static class ColumnChunkTupleScheme
    extends TupleScheme<ColumnChunk> {
        private ColumnChunkTupleScheme() {
        }

        public void write(TProtocol prot, ColumnChunk struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI64(struct.file_offset);
            BitSet optionals = new BitSet();
            if (struct.isSetFilePath()) {
                optionals.set(0);
            }
            if (struct.isSetMetaData()) {
                optionals.set(1);
            }
            if (struct.isSetOffsetIndexOffset()) {
                optionals.set(2);
            }
            if (struct.isSetOffsetIndexLength()) {
                optionals.set(3);
            }
            if (struct.isSetColumnIndexOffset()) {
                optionals.set(4);
            }
            if (struct.isSetColumnIndexLength()) {
                optionals.set(5);
            }
            if (struct.isSetCryptoMetadata()) {
                optionals.set(6);
            }
            if (struct.isSetEncryptedColumnMetadata()) {
                optionals.set(7);
            }
            oprot.writeBitSet(optionals, 8);
            if (struct.isSetFilePath()) {
                oprot.writeString(struct.file_path);
            }
            if (struct.isSetMetaData()) {
                struct.meta_data.write((TProtocol)oprot);
            }
            if (struct.isSetOffsetIndexOffset()) {
                oprot.writeI64(struct.offset_index_offset);
            }
            if (struct.isSetOffsetIndexLength()) {
                oprot.writeI32(struct.offset_index_length);
            }
            if (struct.isSetColumnIndexOffset()) {
                oprot.writeI64(struct.column_index_offset);
            }
            if (struct.isSetColumnIndexLength()) {
                oprot.writeI32(struct.column_index_length);
            }
            if (struct.isSetCryptoMetadata()) {
                struct.crypto_metadata.write((TProtocol)oprot);
            }
            if (struct.isSetEncryptedColumnMetadata()) {
                oprot.writeBinary(struct.encrypted_column_metadata);
            }
        }

        public void read(TProtocol prot, ColumnChunk struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.file_offset = iprot.readI64();
            struct.setFileOffsetIsSet(true);
            BitSet incoming = iprot.readBitSet(8);
            if (incoming.get(0)) {
                struct.file_path = iprot.readString();
                struct.setFilePathIsSet(true);
            }
            if (incoming.get(1)) {
                struct.meta_data = new ColumnMetaData();
                struct.meta_data.read((TProtocol)iprot);
                struct.setMetaDataIsSet(true);
            }
            if (incoming.get(2)) {
                struct.offset_index_offset = iprot.readI64();
                struct.setOffsetIndexOffsetIsSet(true);
            }
            if (incoming.get(3)) {
                struct.offset_index_length = iprot.readI32();
                struct.setOffsetIndexLengthIsSet(true);
            }
            if (incoming.get(4)) {
                struct.column_index_offset = iprot.readI64();
                struct.setColumnIndexOffsetIsSet(true);
            }
            if (incoming.get(5)) {
                struct.column_index_length = iprot.readI32();
                struct.setColumnIndexLengthIsSet(true);
            }
            if (incoming.get(6)) {
                struct.crypto_metadata = new ColumnCryptoMetaData();
                struct.crypto_metadata.read((TProtocol)iprot);
                struct.setCryptoMetadataIsSet(true);
            }
            if (incoming.get(7)) {
                struct.encrypted_column_metadata = iprot.readBinary();
                struct.setEncryptedColumnMetadataIsSet(true);
            }
        }
    }

    private static class ColumnChunkTupleSchemeFactory
    implements SchemeFactory {
        private ColumnChunkTupleSchemeFactory() {
        }

        public ColumnChunkTupleScheme getScheme() {
            return new ColumnChunkTupleScheme();
        }
    }

    private static class ColumnChunkStandardScheme
    extends StandardScheme<ColumnChunk> {
        private ColumnChunkStandardScheme() {
        }

        public void read(TProtocol iprot, ColumnChunk struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.file_path = iprot.readString();
                            struct.setFilePathIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 10) {
                            struct.file_offset = iprot.readI64();
                            struct.setFileOffsetIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 12) {
                            struct.meta_data = new ColumnMetaData();
                            struct.meta_data.read(iprot);
                            struct.setMetaDataIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 10) {
                            struct.offset_index_offset = iprot.readI64();
                            struct.setOffsetIndexOffsetIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 8) {
                            struct.offset_index_length = iprot.readI32();
                            struct.setOffsetIndexLengthIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 10) {
                            struct.column_index_offset = iprot.readI64();
                            struct.setColumnIndexOffsetIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 8) {
                            struct.column_index_length = iprot.readI32();
                            struct.setColumnIndexLengthIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 12) {
                            struct.crypto_metadata = new ColumnCryptoMetaData();
                            struct.crypto_metadata.read(iprot);
                            struct.setCryptoMetadataIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 11) {
                            struct.encrypted_column_metadata = iprot.readBinary();
                            struct.setEncryptedColumnMetadataIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetFileOffset()) {
                throw new TProtocolException("Required field 'file_offset' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            struct.validate();
        }

        public void write(TProtocol oprot, ColumnChunk struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.file_path != null && struct.isSetFilePath()) {
                oprot.writeFieldBegin(FILE_PATH_FIELD_DESC);
                oprot.writeString(struct.file_path);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(FILE_OFFSET_FIELD_DESC);
            oprot.writeI64(struct.file_offset);
            oprot.writeFieldEnd();
            if (struct.meta_data != null && struct.isSetMetaData()) {
                oprot.writeFieldBegin(META_DATA_FIELD_DESC);
                struct.meta_data.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.isSetOffsetIndexOffset()) {
                oprot.writeFieldBegin(OFFSET_INDEX_OFFSET_FIELD_DESC);
                oprot.writeI64(struct.offset_index_offset);
                oprot.writeFieldEnd();
            }
            if (struct.isSetOffsetIndexLength()) {
                oprot.writeFieldBegin(OFFSET_INDEX_LENGTH_FIELD_DESC);
                oprot.writeI32(struct.offset_index_length);
                oprot.writeFieldEnd();
            }
            if (struct.isSetColumnIndexOffset()) {
                oprot.writeFieldBegin(COLUMN_INDEX_OFFSET_FIELD_DESC);
                oprot.writeI64(struct.column_index_offset);
                oprot.writeFieldEnd();
            }
            if (struct.isSetColumnIndexLength()) {
                oprot.writeFieldBegin(COLUMN_INDEX_LENGTH_FIELD_DESC);
                oprot.writeI32(struct.column_index_length);
                oprot.writeFieldEnd();
            }
            if (struct.crypto_metadata != null && struct.isSetCryptoMetadata()) {
                oprot.writeFieldBegin(CRYPTO_METADATA_FIELD_DESC);
                struct.crypto_metadata.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.encrypted_column_metadata != null && struct.isSetEncryptedColumnMetadata()) {
                oprot.writeFieldBegin(ENCRYPTED_COLUMN_METADATA_FIELD_DESC);
                oprot.writeBinary(struct.encrypted_column_metadata);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class ColumnChunkStandardSchemeFactory
    implements SchemeFactory {
        private ColumnChunkStandardSchemeFactory() {
        }

        public ColumnChunkStandardScheme getScheme() {
            return new ColumnChunkStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        FILE_PATH(1, "file_path"),
        FILE_OFFSET(2, "file_offset"),
        META_DATA(3, "meta_data"),
        OFFSET_INDEX_OFFSET(4, "offset_index_offset"),
        OFFSET_INDEX_LENGTH(5, "offset_index_length"),
        COLUMN_INDEX_OFFSET(6, "column_index_offset"),
        COLUMN_INDEX_LENGTH(7, "column_index_length"),
        CRYPTO_METADATA(8, "crypto_metadata"),
        ENCRYPTED_COLUMN_METADATA(9, "encrypted_column_metadata");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return FILE_PATH;
                }
                case 2: {
                    return FILE_OFFSET;
                }
                case 3: {
                    return META_DATA;
                }
                case 4: {
                    return OFFSET_INDEX_OFFSET;
                }
                case 5: {
                    return OFFSET_INDEX_LENGTH;
                }
                case 6: {
                    return COLUMN_INDEX_OFFSET;
                }
                case 7: {
                    return COLUMN_INDEX_LENGTH;
                }
                case 8: {
                    return CRYPTO_METADATA;
                }
                case 9: {
                    return ENCRYPTED_COLUMN_METADATA;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

