/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.doris.thrift.TBinlogConfig;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TTabletMetaInfo
implements TBase<TTabletMetaInfo, _Fields>,
Serializable,
Cloneable,
Comparable<TTabletMetaInfo> {
    private static final TStruct STRUCT_DESC = new TStruct("TTabletMetaInfo");
    private static final TField TABLET_ID_FIELD_DESC = new TField("tablet_id", 10, 1);
    private static final TField SCHEMA_HASH_FIELD_DESC = new TField("schema_hash", 8, 2);
    private static final TField PARTITION_ID_FIELD_DESC = new TField("partition_id", 10, 3);
    private static final TField IS_IN_MEMORY_FIELD_DESC = new TField("is_in_memory", 2, 5);
    private static final TField STORAGE_POLICY_ID_FIELD_DESC = new TField("storage_policy_id", 10, 7);
    private static final TField REPLICA_ID_FIELD_DESC = new TField("replica_id", 10, 8);
    private static final TField BINLOG_CONFIG_FIELD_DESC = new TField("binlog_config", 12, 9);
    private static final TField COMPACTION_POLICY_FIELD_DESC = new TField("compaction_policy", 11, 10);
    private static final TField TIME_SERIES_COMPACTION_GOAL_SIZE_MBYTES_FIELD_DESC = new TField("time_series_compaction_goal_size_mbytes", 10, 11);
    private static final TField TIME_SERIES_COMPACTION_FILE_COUNT_THRESHOLD_FIELD_DESC = new TField("time_series_compaction_file_count_threshold", 10, 12);
    private static final TField TIME_SERIES_COMPACTION_TIME_THRESHOLD_SECONDS_FIELD_DESC = new TField("time_series_compaction_time_threshold_seconds", 10, 13);
    private static final TField ENABLE_SINGLE_REPLICA_COMPACTION_FIELD_DESC = new TField("enable_single_replica_compaction", 2, 14);
    private static final TField SKIP_WRITE_INDEX_ON_LOAD_FIELD_DESC = new TField("skip_write_index_on_load", 2, 15);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TTabletMetaInfoStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TTabletMetaInfoTupleSchemeFactory();
    public long tablet_id;
    public int schema_hash;
    public long partition_id;
    public boolean is_in_memory;
    public long storage_policy_id;
    public long replica_id;
    @Nullable
    public TBinlogConfig binlog_config;
    @Nullable
    public String compaction_policy;
    public long time_series_compaction_goal_size_mbytes;
    public long time_series_compaction_file_count_threshold;
    public long time_series_compaction_time_threshold_seconds;
    public boolean enable_single_replica_compaction;
    public boolean skip_write_index_on_load;
    private static final int __TABLET_ID_ISSET_ID = 0;
    private static final int __SCHEMA_HASH_ISSET_ID = 1;
    private static final int __PARTITION_ID_ISSET_ID = 2;
    private static final int __IS_IN_MEMORY_ISSET_ID = 3;
    private static final int __STORAGE_POLICY_ID_ISSET_ID = 4;
    private static final int __REPLICA_ID_ISSET_ID = 5;
    private static final int __TIME_SERIES_COMPACTION_GOAL_SIZE_MBYTES_ISSET_ID = 6;
    private static final int __TIME_SERIES_COMPACTION_FILE_COUNT_THRESHOLD_ISSET_ID = 7;
    private static final int __TIME_SERIES_COMPACTION_TIME_THRESHOLD_SECONDS_ISSET_ID = 8;
    private static final int __ENABLE_SINGLE_REPLICA_COMPACTION_ISSET_ID = 9;
    private static final int __SKIP_WRITE_INDEX_ON_LOAD_ISSET_ID = 10;
    private short __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.TABLET_ID, _Fields.SCHEMA_HASH, _Fields.PARTITION_ID, _Fields.IS_IN_MEMORY, _Fields.STORAGE_POLICY_ID, _Fields.REPLICA_ID, _Fields.BINLOG_CONFIG, _Fields.COMPACTION_POLICY, _Fields.TIME_SERIES_COMPACTION_GOAL_SIZE_MBYTES, _Fields.TIME_SERIES_COMPACTION_FILE_COUNT_THRESHOLD, _Fields.TIME_SERIES_COMPACTION_TIME_THRESHOLD_SECONDS, _Fields.ENABLE_SINGLE_REPLICA_COMPACTION, _Fields.SKIP_WRITE_INDEX_ON_LOAD};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TTabletMetaInfo() {
    }

    public TTabletMetaInfo(TTabletMetaInfo other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.tablet_id = other.tablet_id;
        this.schema_hash = other.schema_hash;
        this.partition_id = other.partition_id;
        this.is_in_memory = other.is_in_memory;
        this.storage_policy_id = other.storage_policy_id;
        this.replica_id = other.replica_id;
        if (other.isSetBinlogConfig()) {
            this.binlog_config = new TBinlogConfig(other.binlog_config);
        }
        if (other.isSetCompactionPolicy()) {
            this.compaction_policy = other.compaction_policy;
        }
        this.time_series_compaction_goal_size_mbytes = other.time_series_compaction_goal_size_mbytes;
        this.time_series_compaction_file_count_threshold = other.time_series_compaction_file_count_threshold;
        this.time_series_compaction_time_threshold_seconds = other.time_series_compaction_time_threshold_seconds;
        this.enable_single_replica_compaction = other.enable_single_replica_compaction;
        this.skip_write_index_on_load = other.skip_write_index_on_load;
    }

    public TTabletMetaInfo deepCopy() {
        return new TTabletMetaInfo(this);
    }

    public void clear() {
        this.setTabletIdIsSet(false);
        this.tablet_id = 0L;
        this.setSchemaHashIsSet(false);
        this.schema_hash = 0;
        this.setPartitionIdIsSet(false);
        this.partition_id = 0L;
        this.setIsInMemoryIsSet(false);
        this.is_in_memory = false;
        this.setStoragePolicyIdIsSet(false);
        this.storage_policy_id = 0L;
        this.setReplicaIdIsSet(false);
        this.replica_id = 0L;
        this.binlog_config = null;
        this.compaction_policy = null;
        this.setTimeSeriesCompactionGoalSizeMbytesIsSet(false);
        this.time_series_compaction_goal_size_mbytes = 0L;
        this.setTimeSeriesCompactionFileCountThresholdIsSet(false);
        this.time_series_compaction_file_count_threshold = 0L;
        this.setTimeSeriesCompactionTimeThresholdSecondsIsSet(false);
        this.time_series_compaction_time_threshold_seconds = 0L;
        this.setEnableSingleReplicaCompactionIsSet(false);
        this.enable_single_replica_compaction = false;
        this.setSkipWriteIndexOnLoadIsSet(false);
        this.skip_write_index_on_load = false;
    }

    public long getTabletId() {
        return this.tablet_id;
    }

    public TTabletMetaInfo setTabletId(long tablet_id) {
        this.tablet_id = tablet_id;
        this.setTabletIdIsSet(true);
        return this;
    }

    public void unsetTabletId() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)0);
    }

    public boolean isSetTabletId() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)0);
    }

    public void setTabletIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public int getSchemaHash() {
        return this.schema_hash;
    }

    public TTabletMetaInfo setSchemaHash(int schema_hash) {
        this.schema_hash = schema_hash;
        this.setSchemaHashIsSet(true);
        return this;
    }

    public void unsetSchemaHash() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)1);
    }

    public boolean isSetSchemaHash() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)1);
    }

    public void setSchemaHashIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public long getPartitionId() {
        return this.partition_id;
    }

    public TTabletMetaInfo setPartitionId(long partition_id) {
        this.partition_id = partition_id;
        this.setPartitionIdIsSet(true);
        return this;
    }

    public void unsetPartitionId() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)2);
    }

    public boolean isSetPartitionId() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)2);
    }

    public void setPartitionIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public boolean isIsInMemory() {
        return this.is_in_memory;
    }

    public TTabletMetaInfo setIsInMemory(boolean is_in_memory) {
        this.is_in_memory = is_in_memory;
        this.setIsInMemoryIsSet(true);
        return this;
    }

    public void unsetIsInMemory() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)3);
    }

    public boolean isSetIsInMemory() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)3);
    }

    public void setIsInMemoryIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)3, (boolean)value);
    }

    public long getStoragePolicyId() {
        return this.storage_policy_id;
    }

    public TTabletMetaInfo setStoragePolicyId(long storage_policy_id) {
        this.storage_policy_id = storage_policy_id;
        this.setStoragePolicyIdIsSet(true);
        return this;
    }

    public void unsetStoragePolicyId() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)4);
    }

    public boolean isSetStoragePolicyId() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)4);
    }

    public void setStoragePolicyIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)4, (boolean)value);
    }

    public long getReplicaId() {
        return this.replica_id;
    }

    public TTabletMetaInfo setReplicaId(long replica_id) {
        this.replica_id = replica_id;
        this.setReplicaIdIsSet(true);
        return this;
    }

    public void unsetReplicaId() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)5);
    }

    public boolean isSetReplicaId() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)5);
    }

    public void setReplicaIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)5, (boolean)value);
    }

    @Nullable
    public TBinlogConfig getBinlogConfig() {
        return this.binlog_config;
    }

    public TTabletMetaInfo setBinlogConfig(@Nullable TBinlogConfig binlog_config) {
        this.binlog_config = binlog_config;
        return this;
    }

    public void unsetBinlogConfig() {
        this.binlog_config = null;
    }

    public boolean isSetBinlogConfig() {
        return this.binlog_config != null;
    }

    public void setBinlogConfigIsSet(boolean value) {
        if (!value) {
            this.binlog_config = null;
        }
    }

    @Nullable
    public String getCompactionPolicy() {
        return this.compaction_policy;
    }

    public TTabletMetaInfo setCompactionPolicy(@Nullable String compaction_policy) {
        this.compaction_policy = compaction_policy;
        return this;
    }

    public void unsetCompactionPolicy() {
        this.compaction_policy = null;
    }

    public boolean isSetCompactionPolicy() {
        return this.compaction_policy != null;
    }

    public void setCompactionPolicyIsSet(boolean value) {
        if (!value) {
            this.compaction_policy = null;
        }
    }

    public long getTimeSeriesCompactionGoalSizeMbytes() {
        return this.time_series_compaction_goal_size_mbytes;
    }

    public TTabletMetaInfo setTimeSeriesCompactionGoalSizeMbytes(long time_series_compaction_goal_size_mbytes) {
        this.time_series_compaction_goal_size_mbytes = time_series_compaction_goal_size_mbytes;
        this.setTimeSeriesCompactionGoalSizeMbytesIsSet(true);
        return this;
    }

    public void unsetTimeSeriesCompactionGoalSizeMbytes() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)6);
    }

    public boolean isSetTimeSeriesCompactionGoalSizeMbytes() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)6);
    }

    public void setTimeSeriesCompactionGoalSizeMbytesIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)6, (boolean)value);
    }

    public long getTimeSeriesCompactionFileCountThreshold() {
        return this.time_series_compaction_file_count_threshold;
    }

    public TTabletMetaInfo setTimeSeriesCompactionFileCountThreshold(long time_series_compaction_file_count_threshold) {
        this.time_series_compaction_file_count_threshold = time_series_compaction_file_count_threshold;
        this.setTimeSeriesCompactionFileCountThresholdIsSet(true);
        return this;
    }

    public void unsetTimeSeriesCompactionFileCountThreshold() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)7);
    }

    public boolean isSetTimeSeriesCompactionFileCountThreshold() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)7);
    }

    public void setTimeSeriesCompactionFileCountThresholdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)7, (boolean)value);
    }

    public long getTimeSeriesCompactionTimeThresholdSeconds() {
        return this.time_series_compaction_time_threshold_seconds;
    }

    public TTabletMetaInfo setTimeSeriesCompactionTimeThresholdSeconds(long time_series_compaction_time_threshold_seconds) {
        this.time_series_compaction_time_threshold_seconds = time_series_compaction_time_threshold_seconds;
        this.setTimeSeriesCompactionTimeThresholdSecondsIsSet(true);
        return this;
    }

    public void unsetTimeSeriesCompactionTimeThresholdSeconds() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)8);
    }

    public boolean isSetTimeSeriesCompactionTimeThresholdSeconds() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)8);
    }

    public void setTimeSeriesCompactionTimeThresholdSecondsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)8, (boolean)value);
    }

    public boolean isEnableSingleReplicaCompaction() {
        return this.enable_single_replica_compaction;
    }

    public TTabletMetaInfo setEnableSingleReplicaCompaction(boolean enable_single_replica_compaction) {
        this.enable_single_replica_compaction = enable_single_replica_compaction;
        this.setEnableSingleReplicaCompactionIsSet(true);
        return this;
    }

    public void unsetEnableSingleReplicaCompaction() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)9);
    }

    public boolean isSetEnableSingleReplicaCompaction() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)9);
    }

    public void setEnableSingleReplicaCompactionIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)9, (boolean)value);
    }

    public boolean isSkipWriteIndexOnLoad() {
        return this.skip_write_index_on_load;
    }

    public TTabletMetaInfo setSkipWriteIndexOnLoad(boolean skip_write_index_on_load) {
        this.skip_write_index_on_load = skip_write_index_on_load;
        this.setSkipWriteIndexOnLoadIsSet(true);
        return this;
    }

    public void unsetSkipWriteIndexOnLoad() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)10);
    }

    public boolean isSetSkipWriteIndexOnLoad() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)10);
    }

    public void setSkipWriteIndexOnLoadIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)10, (boolean)value);
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case TABLET_ID: {
                if (value == null) {
                    this.unsetTabletId();
                    break;
                }
                this.setTabletId((Long)value);
                break;
            }
            case SCHEMA_HASH: {
                if (value == null) {
                    this.unsetSchemaHash();
                    break;
                }
                this.setSchemaHash((Integer)value);
                break;
            }
            case PARTITION_ID: {
                if (value == null) {
                    this.unsetPartitionId();
                    break;
                }
                this.setPartitionId((Long)value);
                break;
            }
            case IS_IN_MEMORY: {
                if (value == null) {
                    this.unsetIsInMemory();
                    break;
                }
                this.setIsInMemory((Boolean)value);
                break;
            }
            case STORAGE_POLICY_ID: {
                if (value == null) {
                    this.unsetStoragePolicyId();
                    break;
                }
                this.setStoragePolicyId((Long)value);
                break;
            }
            case REPLICA_ID: {
                if (value == null) {
                    this.unsetReplicaId();
                    break;
                }
                this.setReplicaId((Long)value);
                break;
            }
            case BINLOG_CONFIG: {
                if (value == null) {
                    this.unsetBinlogConfig();
                    break;
                }
                this.setBinlogConfig((TBinlogConfig)value);
                break;
            }
            case COMPACTION_POLICY: {
                if (value == null) {
                    this.unsetCompactionPolicy();
                    break;
                }
                this.setCompactionPolicy((String)value);
                break;
            }
            case TIME_SERIES_COMPACTION_GOAL_SIZE_MBYTES: {
                if (value == null) {
                    this.unsetTimeSeriesCompactionGoalSizeMbytes();
                    break;
                }
                this.setTimeSeriesCompactionGoalSizeMbytes((Long)value);
                break;
            }
            case TIME_SERIES_COMPACTION_FILE_COUNT_THRESHOLD: {
                if (value == null) {
                    this.unsetTimeSeriesCompactionFileCountThreshold();
                    break;
                }
                this.setTimeSeriesCompactionFileCountThreshold((Long)value);
                break;
            }
            case TIME_SERIES_COMPACTION_TIME_THRESHOLD_SECONDS: {
                if (value == null) {
                    this.unsetTimeSeriesCompactionTimeThresholdSeconds();
                    break;
                }
                this.setTimeSeriesCompactionTimeThresholdSeconds((Long)value);
                break;
            }
            case ENABLE_SINGLE_REPLICA_COMPACTION: {
                if (value == null) {
                    this.unsetEnableSingleReplicaCompaction();
                    break;
                }
                this.setEnableSingleReplicaCompaction((Boolean)value);
                break;
            }
            case SKIP_WRITE_INDEX_ON_LOAD: {
                if (value == null) {
                    this.unsetSkipWriteIndexOnLoad();
                    break;
                }
                this.setSkipWriteIndexOnLoad((Boolean)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TABLET_ID: {
                return this.getTabletId();
            }
            case SCHEMA_HASH: {
                return this.getSchemaHash();
            }
            case PARTITION_ID: {
                return this.getPartitionId();
            }
            case IS_IN_MEMORY: {
                return this.isIsInMemory();
            }
            case STORAGE_POLICY_ID: {
                return this.getStoragePolicyId();
            }
            case REPLICA_ID: {
                return this.getReplicaId();
            }
            case BINLOG_CONFIG: {
                return this.getBinlogConfig();
            }
            case COMPACTION_POLICY: {
                return this.getCompactionPolicy();
            }
            case TIME_SERIES_COMPACTION_GOAL_SIZE_MBYTES: {
                return this.getTimeSeriesCompactionGoalSizeMbytes();
            }
            case TIME_SERIES_COMPACTION_FILE_COUNT_THRESHOLD: {
                return this.getTimeSeriesCompactionFileCountThreshold();
            }
            case TIME_SERIES_COMPACTION_TIME_THRESHOLD_SECONDS: {
                return this.getTimeSeriesCompactionTimeThresholdSeconds();
            }
            case ENABLE_SINGLE_REPLICA_COMPACTION: {
                return this.isEnableSingleReplicaCompaction();
            }
            case SKIP_WRITE_INDEX_ON_LOAD: {
                return this.isSkipWriteIndexOnLoad();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TABLET_ID: {
                return this.isSetTabletId();
            }
            case SCHEMA_HASH: {
                return this.isSetSchemaHash();
            }
            case PARTITION_ID: {
                return this.isSetPartitionId();
            }
            case IS_IN_MEMORY: {
                return this.isSetIsInMemory();
            }
            case STORAGE_POLICY_ID: {
                return this.isSetStoragePolicyId();
            }
            case REPLICA_ID: {
                return this.isSetReplicaId();
            }
            case BINLOG_CONFIG: {
                return this.isSetBinlogConfig();
            }
            case COMPACTION_POLICY: {
                return this.isSetCompactionPolicy();
            }
            case TIME_SERIES_COMPACTION_GOAL_SIZE_MBYTES: {
                return this.isSetTimeSeriesCompactionGoalSizeMbytes();
            }
            case TIME_SERIES_COMPACTION_FILE_COUNT_THRESHOLD: {
                return this.isSetTimeSeriesCompactionFileCountThreshold();
            }
            case TIME_SERIES_COMPACTION_TIME_THRESHOLD_SECONDS: {
                return this.isSetTimeSeriesCompactionTimeThresholdSeconds();
            }
            case ENABLE_SINGLE_REPLICA_COMPACTION: {
                return this.isSetEnableSingleReplicaCompaction();
            }
            case SKIP_WRITE_INDEX_ON_LOAD: {
                return this.isSetSkipWriteIndexOnLoad();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof TTabletMetaInfo) {
            return this.equals((TTabletMetaInfo)that);
        }
        return false;
    }

    public boolean equals(TTabletMetaInfo that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_tablet_id = this.isSetTabletId();
        boolean that_present_tablet_id = that.isSetTabletId();
        if (this_present_tablet_id || that_present_tablet_id) {
            if (!this_present_tablet_id || !that_present_tablet_id) {
                return false;
            }
            if (this.tablet_id != that.tablet_id) {
                return false;
            }
        }
        boolean this_present_schema_hash = this.isSetSchemaHash();
        boolean that_present_schema_hash = that.isSetSchemaHash();
        if (this_present_schema_hash || that_present_schema_hash) {
            if (!this_present_schema_hash || !that_present_schema_hash) {
                return false;
            }
            if (this.schema_hash != that.schema_hash) {
                return false;
            }
        }
        boolean this_present_partition_id = this.isSetPartitionId();
        boolean that_present_partition_id = that.isSetPartitionId();
        if (this_present_partition_id || that_present_partition_id) {
            if (!this_present_partition_id || !that_present_partition_id) {
                return false;
            }
            if (this.partition_id != that.partition_id) {
                return false;
            }
        }
        boolean this_present_is_in_memory = this.isSetIsInMemory();
        boolean that_present_is_in_memory = that.isSetIsInMemory();
        if (this_present_is_in_memory || that_present_is_in_memory) {
            if (!this_present_is_in_memory || !that_present_is_in_memory) {
                return false;
            }
            if (this.is_in_memory != that.is_in_memory) {
                return false;
            }
        }
        boolean this_present_storage_policy_id = this.isSetStoragePolicyId();
        boolean that_present_storage_policy_id = that.isSetStoragePolicyId();
        if (this_present_storage_policy_id || that_present_storage_policy_id) {
            if (!this_present_storage_policy_id || !that_present_storage_policy_id) {
                return false;
            }
            if (this.storage_policy_id != that.storage_policy_id) {
                return false;
            }
        }
        boolean this_present_replica_id = this.isSetReplicaId();
        boolean that_present_replica_id = that.isSetReplicaId();
        if (this_present_replica_id || that_present_replica_id) {
            if (!this_present_replica_id || !that_present_replica_id) {
                return false;
            }
            if (this.replica_id != that.replica_id) {
                return false;
            }
        }
        boolean this_present_binlog_config = this.isSetBinlogConfig();
        boolean that_present_binlog_config = that.isSetBinlogConfig();
        if (this_present_binlog_config || that_present_binlog_config) {
            if (!this_present_binlog_config || !that_present_binlog_config) {
                return false;
            }
            if (!this.binlog_config.equals(that.binlog_config)) {
                return false;
            }
        }
        boolean this_present_compaction_policy = this.isSetCompactionPolicy();
        boolean that_present_compaction_policy = that.isSetCompactionPolicy();
        if (this_present_compaction_policy || that_present_compaction_policy) {
            if (!this_present_compaction_policy || !that_present_compaction_policy) {
                return false;
            }
            if (!this.compaction_policy.equals(that.compaction_policy)) {
                return false;
            }
        }
        boolean this_present_time_series_compaction_goal_size_mbytes = this.isSetTimeSeriesCompactionGoalSizeMbytes();
        boolean that_present_time_series_compaction_goal_size_mbytes = that.isSetTimeSeriesCompactionGoalSizeMbytes();
        if (this_present_time_series_compaction_goal_size_mbytes || that_present_time_series_compaction_goal_size_mbytes) {
            if (!this_present_time_series_compaction_goal_size_mbytes || !that_present_time_series_compaction_goal_size_mbytes) {
                return false;
            }
            if (this.time_series_compaction_goal_size_mbytes != that.time_series_compaction_goal_size_mbytes) {
                return false;
            }
        }
        boolean this_present_time_series_compaction_file_count_threshold = this.isSetTimeSeriesCompactionFileCountThreshold();
        boolean that_present_time_series_compaction_file_count_threshold = that.isSetTimeSeriesCompactionFileCountThreshold();
        if (this_present_time_series_compaction_file_count_threshold || that_present_time_series_compaction_file_count_threshold) {
            if (!this_present_time_series_compaction_file_count_threshold || !that_present_time_series_compaction_file_count_threshold) {
                return false;
            }
            if (this.time_series_compaction_file_count_threshold != that.time_series_compaction_file_count_threshold) {
                return false;
            }
        }
        boolean this_present_time_series_compaction_time_threshold_seconds = this.isSetTimeSeriesCompactionTimeThresholdSeconds();
        boolean that_present_time_series_compaction_time_threshold_seconds = that.isSetTimeSeriesCompactionTimeThresholdSeconds();
        if (this_present_time_series_compaction_time_threshold_seconds || that_present_time_series_compaction_time_threshold_seconds) {
            if (!this_present_time_series_compaction_time_threshold_seconds || !that_present_time_series_compaction_time_threshold_seconds) {
                return false;
            }
            if (this.time_series_compaction_time_threshold_seconds != that.time_series_compaction_time_threshold_seconds) {
                return false;
            }
        }
        boolean this_present_enable_single_replica_compaction = this.isSetEnableSingleReplicaCompaction();
        boolean that_present_enable_single_replica_compaction = that.isSetEnableSingleReplicaCompaction();
        if (this_present_enable_single_replica_compaction || that_present_enable_single_replica_compaction) {
            if (!this_present_enable_single_replica_compaction || !that_present_enable_single_replica_compaction) {
                return false;
            }
            if (this.enable_single_replica_compaction != that.enable_single_replica_compaction) {
                return false;
            }
        }
        boolean this_present_skip_write_index_on_load = this.isSetSkipWriteIndexOnLoad();
        boolean that_present_skip_write_index_on_load = that.isSetSkipWriteIndexOnLoad();
        if (this_present_skip_write_index_on_load || that_present_skip_write_index_on_load) {
            if (!this_present_skip_write_index_on_load || !that_present_skip_write_index_on_load) {
                return false;
            }
            if (this.skip_write_index_on_load != that.skip_write_index_on_load) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetTabletId() ? 131071 : 524287);
        if (this.isSetTabletId()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.tablet_id);
        }
        hashCode = hashCode * 8191 + (this.isSetSchemaHash() ? 131071 : 524287);
        if (this.isSetSchemaHash()) {
            hashCode = hashCode * 8191 + this.schema_hash;
        }
        hashCode = hashCode * 8191 + (this.isSetPartitionId() ? 131071 : 524287);
        if (this.isSetPartitionId()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.partition_id);
        }
        hashCode = hashCode * 8191 + (this.isSetIsInMemory() ? 131071 : 524287);
        if (this.isSetIsInMemory()) {
            hashCode = hashCode * 8191 + (this.is_in_memory ? 131071 : 524287);
        }
        hashCode = hashCode * 8191 + (this.isSetStoragePolicyId() ? 131071 : 524287);
        if (this.isSetStoragePolicyId()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.storage_policy_id);
        }
        hashCode = hashCode * 8191 + (this.isSetReplicaId() ? 131071 : 524287);
        if (this.isSetReplicaId()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.replica_id);
        }
        hashCode = hashCode * 8191 + (this.isSetBinlogConfig() ? 131071 : 524287);
        if (this.isSetBinlogConfig()) {
            hashCode = hashCode * 8191 + this.binlog_config.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetCompactionPolicy() ? 131071 : 524287);
        if (this.isSetCompactionPolicy()) {
            hashCode = hashCode * 8191 + this.compaction_policy.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTimeSeriesCompactionGoalSizeMbytes() ? 131071 : 524287);
        if (this.isSetTimeSeriesCompactionGoalSizeMbytes()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.time_series_compaction_goal_size_mbytes);
        }
        hashCode = hashCode * 8191 + (this.isSetTimeSeriesCompactionFileCountThreshold() ? 131071 : 524287);
        if (this.isSetTimeSeriesCompactionFileCountThreshold()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.time_series_compaction_file_count_threshold);
        }
        hashCode = hashCode * 8191 + (this.isSetTimeSeriesCompactionTimeThresholdSeconds() ? 131071 : 524287);
        if (this.isSetTimeSeriesCompactionTimeThresholdSeconds()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.time_series_compaction_time_threshold_seconds);
        }
        hashCode = hashCode * 8191 + (this.isSetEnableSingleReplicaCompaction() ? 131071 : 524287);
        if (this.isSetEnableSingleReplicaCompaction()) {
            hashCode = hashCode * 8191 + (this.enable_single_replica_compaction ? 131071 : 524287);
        }
        hashCode = hashCode * 8191 + (this.isSetSkipWriteIndexOnLoad() ? 131071 : 524287);
        if (this.isSetSkipWriteIndexOnLoad()) {
            hashCode = hashCode * 8191 + (this.skip_write_index_on_load ? 131071 : 524287);
        }
        return hashCode;
    }

    @Override
    public int compareTo(TTabletMetaInfo other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetTabletId(), other.isSetTabletId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTabletId() && (lastComparison = TBaseHelper.compareTo((long)this.tablet_id, (long)other.tablet_id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetSchemaHash(), other.isSetSchemaHash());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSchemaHash() && (lastComparison = TBaseHelper.compareTo((int)this.schema_hash, (int)other.schema_hash)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPartitionId(), other.isSetPartitionId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPartitionId() && (lastComparison = TBaseHelper.compareTo((long)this.partition_id, (long)other.partition_id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetIsInMemory(), other.isSetIsInMemory());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIsInMemory() && (lastComparison = TBaseHelper.compareTo((boolean)this.is_in_memory, (boolean)other.is_in_memory)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetStoragePolicyId(), other.isSetStoragePolicyId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetStoragePolicyId() && (lastComparison = TBaseHelper.compareTo((long)this.storage_policy_id, (long)other.storage_policy_id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetReplicaId(), other.isSetReplicaId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetReplicaId() && (lastComparison = TBaseHelper.compareTo((long)this.replica_id, (long)other.replica_id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetBinlogConfig(), other.isSetBinlogConfig());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBinlogConfig() && (lastComparison = TBaseHelper.compareTo((Comparable)this.binlog_config, (Comparable)other.binlog_config)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetCompactionPolicy(), other.isSetCompactionPolicy());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCompactionPolicy() && (lastComparison = TBaseHelper.compareTo((String)this.compaction_policy, (String)other.compaction_policy)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTimeSeriesCompactionGoalSizeMbytes(), other.isSetTimeSeriesCompactionGoalSizeMbytes());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTimeSeriesCompactionGoalSizeMbytes() && (lastComparison = TBaseHelper.compareTo((long)this.time_series_compaction_goal_size_mbytes, (long)other.time_series_compaction_goal_size_mbytes)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTimeSeriesCompactionFileCountThreshold(), other.isSetTimeSeriesCompactionFileCountThreshold());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTimeSeriesCompactionFileCountThreshold() && (lastComparison = TBaseHelper.compareTo((long)this.time_series_compaction_file_count_threshold, (long)other.time_series_compaction_file_count_threshold)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTimeSeriesCompactionTimeThresholdSeconds(), other.isSetTimeSeriesCompactionTimeThresholdSeconds());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTimeSeriesCompactionTimeThresholdSeconds() && (lastComparison = TBaseHelper.compareTo((long)this.time_series_compaction_time_threshold_seconds, (long)other.time_series_compaction_time_threshold_seconds)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetEnableSingleReplicaCompaction(), other.isSetEnableSingleReplicaCompaction());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEnableSingleReplicaCompaction() && (lastComparison = TBaseHelper.compareTo((boolean)this.enable_single_replica_compaction, (boolean)other.enable_single_replica_compaction)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetSkipWriteIndexOnLoad(), other.isSetSkipWriteIndexOnLoad());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSkipWriteIndexOnLoad() && (lastComparison = TBaseHelper.compareTo((boolean)this.skip_write_index_on_load, (boolean)other.skip_write_index_on_load)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        TTabletMetaInfo.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        TTabletMetaInfo.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TTabletMetaInfo(");
        boolean first = true;
        if (this.isSetTabletId()) {
            sb.append("tablet_id:");
            sb.append(this.tablet_id);
            first = false;
        }
        if (this.isSetSchemaHash()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("schema_hash:");
            sb.append(this.schema_hash);
            first = false;
        }
        if (this.isSetPartitionId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("partition_id:");
            sb.append(this.partition_id);
            first = false;
        }
        if (this.isSetIsInMemory()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("is_in_memory:");
            sb.append(this.is_in_memory);
            first = false;
        }
        if (this.isSetStoragePolicyId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("storage_policy_id:");
            sb.append(this.storage_policy_id);
            first = false;
        }
        if (this.isSetReplicaId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("replica_id:");
            sb.append(this.replica_id);
            first = false;
        }
        if (this.isSetBinlogConfig()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("binlog_config:");
            if (this.binlog_config == null) {
                sb.append("null");
            } else {
                sb.append(this.binlog_config);
            }
            first = false;
        }
        if (this.isSetCompactionPolicy()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("compaction_policy:");
            if (this.compaction_policy == null) {
                sb.append("null");
            } else {
                sb.append(this.compaction_policy);
            }
            first = false;
        }
        if (this.isSetTimeSeriesCompactionGoalSizeMbytes()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("time_series_compaction_goal_size_mbytes:");
            sb.append(this.time_series_compaction_goal_size_mbytes);
            first = false;
        }
        if (this.isSetTimeSeriesCompactionFileCountThreshold()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("time_series_compaction_file_count_threshold:");
            sb.append(this.time_series_compaction_file_count_threshold);
            first = false;
        }
        if (this.isSetTimeSeriesCompactionTimeThresholdSeconds()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("time_series_compaction_time_threshold_seconds:");
            sb.append(this.time_series_compaction_time_threshold_seconds);
            first = false;
        }
        if (this.isSetEnableSingleReplicaCompaction()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("enable_single_replica_compaction:");
            sb.append(this.enable_single_replica_compaction);
            first = false;
        }
        if (this.isSetSkipWriteIndexOnLoad()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("skip_write_index_on_load:");
            sb.append(this.skip_write_index_on_load);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.binlog_config != null) {
            this.binlog_config.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TABLET_ID, new FieldMetaData("tablet_id", 2, new FieldValueMetaData(10, "TTabletId")));
        tmpMap.put(_Fields.SCHEMA_HASH, new FieldMetaData("schema_hash", 2, new FieldValueMetaData(8, "TSchemaHash")));
        tmpMap.put(_Fields.PARTITION_ID, new FieldMetaData("partition_id", 2, new FieldValueMetaData(10, "TPartitionId")));
        tmpMap.put(_Fields.IS_IN_MEMORY, new FieldMetaData("is_in_memory", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.STORAGE_POLICY_ID, new FieldMetaData("storage_policy_id", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.REPLICA_ID, new FieldMetaData("replica_id", 2, new FieldValueMetaData(10, "TReplicaId")));
        tmpMap.put(_Fields.BINLOG_CONFIG, new FieldMetaData("binlog_config", 2, (FieldValueMetaData)new StructMetaData(12, TBinlogConfig.class)));
        tmpMap.put(_Fields.COMPACTION_POLICY, new FieldMetaData("compaction_policy", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TIME_SERIES_COMPACTION_GOAL_SIZE_MBYTES, new FieldMetaData("time_series_compaction_goal_size_mbytes", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.TIME_SERIES_COMPACTION_FILE_COUNT_THRESHOLD, new FieldMetaData("time_series_compaction_file_count_threshold", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.TIME_SERIES_COMPACTION_TIME_THRESHOLD_SECONDS, new FieldMetaData("time_series_compaction_time_threshold_seconds", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.ENABLE_SINGLE_REPLICA_COMPACTION, new FieldMetaData("enable_single_replica_compaction", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.SKIP_WRITE_INDEX_ON_LOAD, new FieldMetaData("skip_write_index_on_load", 2, new FieldValueMetaData(2)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TTabletMetaInfo.class, metaDataMap);
    }

    private static class TTabletMetaInfoTupleScheme
    extends TupleScheme<TTabletMetaInfo> {
        private TTabletMetaInfoTupleScheme() {
        }

        public void write(TProtocol prot, TTabletMetaInfo struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetTabletId()) {
                optionals.set(0);
            }
            if (struct.isSetSchemaHash()) {
                optionals.set(1);
            }
            if (struct.isSetPartitionId()) {
                optionals.set(2);
            }
            if (struct.isSetIsInMemory()) {
                optionals.set(3);
            }
            if (struct.isSetStoragePolicyId()) {
                optionals.set(4);
            }
            if (struct.isSetReplicaId()) {
                optionals.set(5);
            }
            if (struct.isSetBinlogConfig()) {
                optionals.set(6);
            }
            if (struct.isSetCompactionPolicy()) {
                optionals.set(7);
            }
            if (struct.isSetTimeSeriesCompactionGoalSizeMbytes()) {
                optionals.set(8);
            }
            if (struct.isSetTimeSeriesCompactionFileCountThreshold()) {
                optionals.set(9);
            }
            if (struct.isSetTimeSeriesCompactionTimeThresholdSeconds()) {
                optionals.set(10);
            }
            if (struct.isSetEnableSingleReplicaCompaction()) {
                optionals.set(11);
            }
            if (struct.isSetSkipWriteIndexOnLoad()) {
                optionals.set(12);
            }
            oprot.writeBitSet(optionals, 13);
            if (struct.isSetTabletId()) {
                oprot.writeI64(struct.tablet_id);
            }
            if (struct.isSetSchemaHash()) {
                oprot.writeI32(struct.schema_hash);
            }
            if (struct.isSetPartitionId()) {
                oprot.writeI64(struct.partition_id);
            }
            if (struct.isSetIsInMemory()) {
                oprot.writeBool(struct.is_in_memory);
            }
            if (struct.isSetStoragePolicyId()) {
                oprot.writeI64(struct.storage_policy_id);
            }
            if (struct.isSetReplicaId()) {
                oprot.writeI64(struct.replica_id);
            }
            if (struct.isSetBinlogConfig()) {
                struct.binlog_config.write((TProtocol)oprot);
            }
            if (struct.isSetCompactionPolicy()) {
                oprot.writeString(struct.compaction_policy);
            }
            if (struct.isSetTimeSeriesCompactionGoalSizeMbytes()) {
                oprot.writeI64(struct.time_series_compaction_goal_size_mbytes);
            }
            if (struct.isSetTimeSeriesCompactionFileCountThreshold()) {
                oprot.writeI64(struct.time_series_compaction_file_count_threshold);
            }
            if (struct.isSetTimeSeriesCompactionTimeThresholdSeconds()) {
                oprot.writeI64(struct.time_series_compaction_time_threshold_seconds);
            }
            if (struct.isSetEnableSingleReplicaCompaction()) {
                oprot.writeBool(struct.enable_single_replica_compaction);
            }
            if (struct.isSetSkipWriteIndexOnLoad()) {
                oprot.writeBool(struct.skip_write_index_on_load);
            }
        }

        public void read(TProtocol prot, TTabletMetaInfo struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(13);
            if (incoming.get(0)) {
                struct.tablet_id = iprot.readI64();
                struct.setTabletIdIsSet(true);
            }
            if (incoming.get(1)) {
                struct.schema_hash = iprot.readI32();
                struct.setSchemaHashIsSet(true);
            }
            if (incoming.get(2)) {
                struct.partition_id = iprot.readI64();
                struct.setPartitionIdIsSet(true);
            }
            if (incoming.get(3)) {
                struct.is_in_memory = iprot.readBool();
                struct.setIsInMemoryIsSet(true);
            }
            if (incoming.get(4)) {
                struct.storage_policy_id = iprot.readI64();
                struct.setStoragePolicyIdIsSet(true);
            }
            if (incoming.get(5)) {
                struct.replica_id = iprot.readI64();
                struct.setReplicaIdIsSet(true);
            }
            if (incoming.get(6)) {
                struct.binlog_config = new TBinlogConfig();
                struct.binlog_config.read((TProtocol)iprot);
                struct.setBinlogConfigIsSet(true);
            }
            if (incoming.get(7)) {
                struct.compaction_policy = iprot.readString();
                struct.setCompactionPolicyIsSet(true);
            }
            if (incoming.get(8)) {
                struct.time_series_compaction_goal_size_mbytes = iprot.readI64();
                struct.setTimeSeriesCompactionGoalSizeMbytesIsSet(true);
            }
            if (incoming.get(9)) {
                struct.time_series_compaction_file_count_threshold = iprot.readI64();
                struct.setTimeSeriesCompactionFileCountThresholdIsSet(true);
            }
            if (incoming.get(10)) {
                struct.time_series_compaction_time_threshold_seconds = iprot.readI64();
                struct.setTimeSeriesCompactionTimeThresholdSecondsIsSet(true);
            }
            if (incoming.get(11)) {
                struct.enable_single_replica_compaction = iprot.readBool();
                struct.setEnableSingleReplicaCompactionIsSet(true);
            }
            if (incoming.get(12)) {
                struct.skip_write_index_on_load = iprot.readBool();
                struct.setSkipWriteIndexOnLoadIsSet(true);
            }
        }
    }

    private static class TTabletMetaInfoTupleSchemeFactory
    implements SchemeFactory {
        private TTabletMetaInfoTupleSchemeFactory() {
        }

        public TTabletMetaInfoTupleScheme getScheme() {
            return new TTabletMetaInfoTupleScheme();
        }
    }

    private static class TTabletMetaInfoStandardScheme
    extends StandardScheme<TTabletMetaInfo> {
        private TTabletMetaInfoStandardScheme() {
        }

        public void read(TProtocol iprot, TTabletMetaInfo struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 10) {
                            struct.tablet_id = iprot.readI64();
                            struct.setTabletIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 8) {
                            struct.schema_hash = iprot.readI32();
                            struct.setSchemaHashIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 10) {
                            struct.partition_id = iprot.readI64();
                            struct.setPartitionIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 2) {
                            struct.is_in_memory = iprot.readBool();
                            struct.setIsInMemoryIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 10) {
                            struct.storage_policy_id = iprot.readI64();
                            struct.setStoragePolicyIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 10) {
                            struct.replica_id = iprot.readI64();
                            struct.setReplicaIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 12) {
                            struct.binlog_config = new TBinlogConfig();
                            struct.binlog_config.read(iprot);
                            struct.setBinlogConfigIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 11) {
                            struct.compaction_policy = iprot.readString();
                            struct.setCompactionPolicyIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 10) {
                            struct.time_series_compaction_goal_size_mbytes = iprot.readI64();
                            struct.setTimeSeriesCompactionGoalSizeMbytesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 10) {
                            struct.time_series_compaction_file_count_threshold = iprot.readI64();
                            struct.setTimeSeriesCompactionFileCountThresholdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 13: {
                        if (schemeField.type == 10) {
                            struct.time_series_compaction_time_threshold_seconds = iprot.readI64();
                            struct.setTimeSeriesCompactionTimeThresholdSecondsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 14: {
                        if (schemeField.type == 2) {
                            struct.enable_single_replica_compaction = iprot.readBool();
                            struct.setEnableSingleReplicaCompactionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 15: {
                        if (schemeField.type == 2) {
                            struct.skip_write_index_on_load = iprot.readBool();
                            struct.setSkipWriteIndexOnLoadIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TTabletMetaInfo struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.isSetTabletId()) {
                oprot.writeFieldBegin(TABLET_ID_FIELD_DESC);
                oprot.writeI64(struct.tablet_id);
                oprot.writeFieldEnd();
            }
            if (struct.isSetSchemaHash()) {
                oprot.writeFieldBegin(SCHEMA_HASH_FIELD_DESC);
                oprot.writeI32(struct.schema_hash);
                oprot.writeFieldEnd();
            }
            if (struct.isSetPartitionId()) {
                oprot.writeFieldBegin(PARTITION_ID_FIELD_DESC);
                oprot.writeI64(struct.partition_id);
                oprot.writeFieldEnd();
            }
            if (struct.isSetIsInMemory()) {
                oprot.writeFieldBegin(IS_IN_MEMORY_FIELD_DESC);
                oprot.writeBool(struct.is_in_memory);
                oprot.writeFieldEnd();
            }
            if (struct.isSetStoragePolicyId()) {
                oprot.writeFieldBegin(STORAGE_POLICY_ID_FIELD_DESC);
                oprot.writeI64(struct.storage_policy_id);
                oprot.writeFieldEnd();
            }
            if (struct.isSetReplicaId()) {
                oprot.writeFieldBegin(REPLICA_ID_FIELD_DESC);
                oprot.writeI64(struct.replica_id);
                oprot.writeFieldEnd();
            }
            if (struct.binlog_config != null && struct.isSetBinlogConfig()) {
                oprot.writeFieldBegin(BINLOG_CONFIG_FIELD_DESC);
                struct.binlog_config.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.compaction_policy != null && struct.isSetCompactionPolicy()) {
                oprot.writeFieldBegin(COMPACTION_POLICY_FIELD_DESC);
                oprot.writeString(struct.compaction_policy);
                oprot.writeFieldEnd();
            }
            if (struct.isSetTimeSeriesCompactionGoalSizeMbytes()) {
                oprot.writeFieldBegin(TIME_SERIES_COMPACTION_GOAL_SIZE_MBYTES_FIELD_DESC);
                oprot.writeI64(struct.time_series_compaction_goal_size_mbytes);
                oprot.writeFieldEnd();
            }
            if (struct.isSetTimeSeriesCompactionFileCountThreshold()) {
                oprot.writeFieldBegin(TIME_SERIES_COMPACTION_FILE_COUNT_THRESHOLD_FIELD_DESC);
                oprot.writeI64(struct.time_series_compaction_file_count_threshold);
                oprot.writeFieldEnd();
            }
            if (struct.isSetTimeSeriesCompactionTimeThresholdSeconds()) {
                oprot.writeFieldBegin(TIME_SERIES_COMPACTION_TIME_THRESHOLD_SECONDS_FIELD_DESC);
                oprot.writeI64(struct.time_series_compaction_time_threshold_seconds);
                oprot.writeFieldEnd();
            }
            if (struct.isSetEnableSingleReplicaCompaction()) {
                oprot.writeFieldBegin(ENABLE_SINGLE_REPLICA_COMPACTION_FIELD_DESC);
                oprot.writeBool(struct.enable_single_replica_compaction);
                oprot.writeFieldEnd();
            }
            if (struct.isSetSkipWriteIndexOnLoad()) {
                oprot.writeFieldBegin(SKIP_WRITE_INDEX_ON_LOAD_FIELD_DESC);
                oprot.writeBool(struct.skip_write_index_on_load);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TTabletMetaInfoStandardSchemeFactory
    implements SchemeFactory {
        private TTabletMetaInfoStandardSchemeFactory() {
        }

        public TTabletMetaInfoStandardScheme getScheme() {
            return new TTabletMetaInfoStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TABLET_ID(1, "tablet_id"),
        SCHEMA_HASH(2, "schema_hash"),
        PARTITION_ID(3, "partition_id"),
        IS_IN_MEMORY(5, "is_in_memory"),
        STORAGE_POLICY_ID(7, "storage_policy_id"),
        REPLICA_ID(8, "replica_id"),
        BINLOG_CONFIG(9, "binlog_config"),
        COMPACTION_POLICY(10, "compaction_policy"),
        TIME_SERIES_COMPACTION_GOAL_SIZE_MBYTES(11, "time_series_compaction_goal_size_mbytes"),
        TIME_SERIES_COMPACTION_FILE_COUNT_THRESHOLD(12, "time_series_compaction_file_count_threshold"),
        TIME_SERIES_COMPACTION_TIME_THRESHOLD_SECONDS(13, "time_series_compaction_time_threshold_seconds"),
        ENABLE_SINGLE_REPLICA_COMPACTION(14, "enable_single_replica_compaction"),
        SKIP_WRITE_INDEX_ON_LOAD(15, "skip_write_index_on_load");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TABLET_ID;
                }
                case 2: {
                    return SCHEMA_HASH;
                }
                case 3: {
                    return PARTITION_ID;
                }
                case 5: {
                    return IS_IN_MEMORY;
                }
                case 7: {
                    return STORAGE_POLICY_ID;
                }
                case 8: {
                    return REPLICA_ID;
                }
                case 9: {
                    return BINLOG_CONFIG;
                }
                case 10: {
                    return COMPACTION_POLICY;
                }
                case 11: {
                    return TIME_SERIES_COMPACTION_GOAL_SIZE_MBYTES;
                }
                case 12: {
                    return TIME_SERIES_COMPACTION_FILE_COUNT_THRESHOLD;
                }
                case 13: {
                    return TIME_SERIES_COMPACTION_TIME_THRESHOLD_SECONDS;
                }
                case 14: {
                    return ENABLE_SINGLE_REPLICA_COMPACTION;
                }
                case 15: {
                    return SKIP_WRITE_INDEX_ON_LOAD;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

