/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TSnapshotRequest
implements TBase<TSnapshotRequest, _Fields>,
Serializable,
Cloneable,
Comparable<TSnapshotRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("TSnapshotRequest");
    private static final TField TABLET_ID_FIELD_DESC = new TField("tablet_id", 10, 1);
    private static final TField SCHEMA_HASH_FIELD_DESC = new TField("schema_hash", 8, 2);
    private static final TField VERSION_FIELD_DESC = new TField("version", 10, 3);
    private static final TField VERSION_HASH_FIELD_DESC = new TField("version_hash", 10, 4);
    private static final TField TIMEOUT_FIELD_DESC = new TField("timeout", 10, 5);
    private static final TField MISSING_VERSION_FIELD_DESC = new TField("missing_version", 15, 6);
    private static final TField LIST_FILES_FIELD_DESC = new TField("list_files", 2, 7);
    private static final TField ALLOW_INCREMENTAL_CLONE_FIELD_DESC = new TField("allow_incremental_clone", 2, 8);
    private static final TField PREFERRED_SNAPSHOT_VERSION_FIELD_DESC = new TField("preferred_snapshot_version", 8, 9);
    private static final TField IS_COPY_TABLET_TASK_FIELD_DESC = new TField("is_copy_tablet_task", 2, 10);
    private static final TField START_VERSION_FIELD_DESC = new TField("start_version", 10, 11);
    private static final TField END_VERSION_FIELD_DESC = new TField("end_version", 10, 12);
    private static final TField IS_COPY_BINLOG_FIELD_DESC = new TField("is_copy_binlog", 2, 13);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TSnapshotRequestStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TSnapshotRequestTupleSchemeFactory();
    public long tablet_id;
    public int schema_hash;
    public long version;
    public long version_hash;
    public long timeout;
    @Nullable
    public List<Long> missing_version;
    public boolean list_files;
    public boolean allow_incremental_clone;
    public int preferred_snapshot_version;
    public boolean is_copy_tablet_task;
    public long start_version;
    public long end_version;
    public boolean is_copy_binlog;
    private static final int __TABLET_ID_ISSET_ID = 0;
    private static final int __SCHEMA_HASH_ISSET_ID = 1;
    private static final int __VERSION_ISSET_ID = 2;
    private static final int __VERSION_HASH_ISSET_ID = 3;
    private static final int __TIMEOUT_ISSET_ID = 4;
    private static final int __LIST_FILES_ISSET_ID = 5;
    private static final int __ALLOW_INCREMENTAL_CLONE_ISSET_ID = 6;
    private static final int __PREFERRED_SNAPSHOT_VERSION_ISSET_ID = 7;
    private static final int __IS_COPY_TABLET_TASK_ISSET_ID = 8;
    private static final int __START_VERSION_ISSET_ID = 9;
    private static final int __END_VERSION_ISSET_ID = 10;
    private static final int __IS_COPY_BINLOG_ISSET_ID = 11;
    private short __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.VERSION, _Fields.VERSION_HASH, _Fields.TIMEOUT, _Fields.MISSING_VERSION, _Fields.LIST_FILES, _Fields.ALLOW_INCREMENTAL_CLONE, _Fields.PREFERRED_SNAPSHOT_VERSION, _Fields.IS_COPY_TABLET_TASK, _Fields.START_VERSION, _Fields.END_VERSION, _Fields.IS_COPY_BINLOG};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TSnapshotRequest() {
        this.preferred_snapshot_version = 4;
    }

    public TSnapshotRequest(long tablet_id, int schema_hash) {
        this();
        this.tablet_id = tablet_id;
        this.setTabletIdIsSet(true);
        this.schema_hash = schema_hash;
        this.setSchemaHashIsSet(true);
    }

    public TSnapshotRequest(TSnapshotRequest other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.tablet_id = other.tablet_id;
        this.schema_hash = other.schema_hash;
        this.version = other.version;
        this.version_hash = other.version_hash;
        this.timeout = other.timeout;
        if (other.isSetMissingVersion()) {
            ArrayList<Long> __this__missing_version = new ArrayList<Long>(other.missing_version.size());
            for (Long other_element : other.missing_version) {
                __this__missing_version.add(other_element);
            }
            this.missing_version = __this__missing_version;
        }
        this.list_files = other.list_files;
        this.allow_incremental_clone = other.allow_incremental_clone;
        this.preferred_snapshot_version = other.preferred_snapshot_version;
        this.is_copy_tablet_task = other.is_copy_tablet_task;
        this.start_version = other.start_version;
        this.end_version = other.end_version;
        this.is_copy_binlog = other.is_copy_binlog;
    }

    public TSnapshotRequest deepCopy() {
        return new TSnapshotRequest(this);
    }

    public void clear() {
        this.setTabletIdIsSet(false);
        this.tablet_id = 0L;
        this.setSchemaHashIsSet(false);
        this.schema_hash = 0;
        this.setVersionIsSet(false);
        this.version = 0L;
        this.setVersionHashIsSet(false);
        this.version_hash = 0L;
        this.setTimeoutIsSet(false);
        this.timeout = 0L;
        this.missing_version = null;
        this.setListFilesIsSet(false);
        this.list_files = false;
        this.setAllowIncrementalCloneIsSet(false);
        this.allow_incremental_clone = false;
        this.preferred_snapshot_version = 4;
        this.setIsCopyTabletTaskIsSet(false);
        this.is_copy_tablet_task = false;
        this.setStartVersionIsSet(false);
        this.start_version = 0L;
        this.setEndVersionIsSet(false);
        this.end_version = 0L;
        this.setIsCopyBinlogIsSet(false);
        this.is_copy_binlog = false;
    }

    public long getTabletId() {
        return this.tablet_id;
    }

    public TSnapshotRequest setTabletId(long tablet_id) {
        this.tablet_id = tablet_id;
        this.setTabletIdIsSet(true);
        return this;
    }

    public void unsetTabletId() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)0);
    }

    public boolean isSetTabletId() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)0);
    }

    public void setTabletIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public int getSchemaHash() {
        return this.schema_hash;
    }

    public TSnapshotRequest setSchemaHash(int schema_hash) {
        this.schema_hash = schema_hash;
        this.setSchemaHashIsSet(true);
        return this;
    }

    public void unsetSchemaHash() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)1);
    }

    public boolean isSetSchemaHash() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)1);
    }

    public void setSchemaHashIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public long getVersion() {
        return this.version;
    }

    public TSnapshotRequest setVersion(long version) {
        this.version = version;
        this.setVersionIsSet(true);
        return this;
    }

    public void unsetVersion() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)2);
    }

    public boolean isSetVersion() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)2);
    }

    public void setVersionIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public long getVersionHash() {
        return this.version_hash;
    }

    public TSnapshotRequest setVersionHash(long version_hash) {
        this.version_hash = version_hash;
        this.setVersionHashIsSet(true);
        return this;
    }

    public void unsetVersionHash() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)3);
    }

    public boolean isSetVersionHash() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)3);
    }

    public void setVersionHashIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)3, (boolean)value);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public TSnapshotRequest setTimeout(long timeout) {
        this.timeout = timeout;
        this.setTimeoutIsSet(true);
        return this;
    }

    public void unsetTimeout() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)4);
    }

    public boolean isSetTimeout() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)4);
    }

    public void setTimeoutIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)4, (boolean)value);
    }

    public int getMissingVersionSize() {
        return this.missing_version == null ? 0 : this.missing_version.size();
    }

    @Nullable
    public Iterator<Long> getMissingVersionIterator() {
        return this.missing_version == null ? null : this.missing_version.iterator();
    }

    public void addToMissingVersion(long elem) {
        if (this.missing_version == null) {
            this.missing_version = new ArrayList<Long>();
        }
        this.missing_version.add(elem);
    }

    @Nullable
    public List<Long> getMissingVersion() {
        return this.missing_version;
    }

    public TSnapshotRequest setMissingVersion(@Nullable List<Long> missing_version) {
        this.missing_version = missing_version;
        return this;
    }

    public void unsetMissingVersion() {
        this.missing_version = null;
    }

    public boolean isSetMissingVersion() {
        return this.missing_version != null;
    }

    public void setMissingVersionIsSet(boolean value) {
        if (!value) {
            this.missing_version = null;
        }
    }

    public boolean isListFiles() {
        return this.list_files;
    }

    public TSnapshotRequest setListFiles(boolean list_files) {
        this.list_files = list_files;
        this.setListFilesIsSet(true);
        return this;
    }

    public void unsetListFiles() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)5);
    }

    public boolean isSetListFiles() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)5);
    }

    public void setListFilesIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)5, (boolean)value);
    }

    public boolean isAllowIncrementalClone() {
        return this.allow_incremental_clone;
    }

    public TSnapshotRequest setAllowIncrementalClone(boolean allow_incremental_clone) {
        this.allow_incremental_clone = allow_incremental_clone;
        this.setAllowIncrementalCloneIsSet(true);
        return this;
    }

    public void unsetAllowIncrementalClone() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)6);
    }

    public boolean isSetAllowIncrementalClone() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)6);
    }

    public void setAllowIncrementalCloneIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)6, (boolean)value);
    }

    public int getPreferredSnapshotVersion() {
        return this.preferred_snapshot_version;
    }

    public TSnapshotRequest setPreferredSnapshotVersion(int preferred_snapshot_version) {
        this.preferred_snapshot_version = preferred_snapshot_version;
        this.setPreferredSnapshotVersionIsSet(true);
        return this;
    }

    public void unsetPreferredSnapshotVersion() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)7);
    }

    public boolean isSetPreferredSnapshotVersion() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)7);
    }

    public void setPreferredSnapshotVersionIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)7, (boolean)value);
    }

    public boolean isIsCopyTabletTask() {
        return this.is_copy_tablet_task;
    }

    public TSnapshotRequest setIsCopyTabletTask(boolean is_copy_tablet_task) {
        this.is_copy_tablet_task = is_copy_tablet_task;
        this.setIsCopyTabletTaskIsSet(true);
        return this;
    }

    public void unsetIsCopyTabletTask() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)8);
    }

    public boolean isSetIsCopyTabletTask() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)8);
    }

    public void setIsCopyTabletTaskIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)8, (boolean)value);
    }

    public long getStartVersion() {
        return this.start_version;
    }

    public TSnapshotRequest setStartVersion(long start_version) {
        this.start_version = start_version;
        this.setStartVersionIsSet(true);
        return this;
    }

    public void unsetStartVersion() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)9);
    }

    public boolean isSetStartVersion() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)9);
    }

    public void setStartVersionIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)9, (boolean)value);
    }

    public long getEndVersion() {
        return this.end_version;
    }

    public TSnapshotRequest setEndVersion(long end_version) {
        this.end_version = end_version;
        this.setEndVersionIsSet(true);
        return this;
    }

    public void unsetEndVersion() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)10);
    }

    public boolean isSetEndVersion() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)10);
    }

    public void setEndVersionIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)10, (boolean)value);
    }

    public boolean isIsCopyBinlog() {
        return this.is_copy_binlog;
    }

    public TSnapshotRequest setIsCopyBinlog(boolean is_copy_binlog) {
        this.is_copy_binlog = is_copy_binlog;
        this.setIsCopyBinlogIsSet(true);
        return this;
    }

    public void unsetIsCopyBinlog() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)11);
    }

    public boolean isSetIsCopyBinlog() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)11);
    }

    public void setIsCopyBinlogIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)11, (boolean)value);
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case TABLET_ID: {
                if (value == null) {
                    this.unsetTabletId();
                    break;
                }
                this.setTabletId((Long)value);
                break;
            }
            case SCHEMA_HASH: {
                if (value == null) {
                    this.unsetSchemaHash();
                    break;
                }
                this.setSchemaHash((Integer)value);
                break;
            }
            case VERSION: {
                if (value == null) {
                    this.unsetVersion();
                    break;
                }
                this.setVersion((Long)value);
                break;
            }
            case VERSION_HASH: {
                if (value == null) {
                    this.unsetVersionHash();
                    break;
                }
                this.setVersionHash((Long)value);
                break;
            }
            case TIMEOUT: {
                if (value == null) {
                    this.unsetTimeout();
                    break;
                }
                this.setTimeout((Long)value);
                break;
            }
            case MISSING_VERSION: {
                if (value == null) {
                    this.unsetMissingVersion();
                    break;
                }
                this.setMissingVersion((List)value);
                break;
            }
            case LIST_FILES: {
                if (value == null) {
                    this.unsetListFiles();
                    break;
                }
                this.setListFiles((Boolean)value);
                break;
            }
            case ALLOW_INCREMENTAL_CLONE: {
                if (value == null) {
                    this.unsetAllowIncrementalClone();
                    break;
                }
                this.setAllowIncrementalClone((Boolean)value);
                break;
            }
            case PREFERRED_SNAPSHOT_VERSION: {
                if (value == null) {
                    this.unsetPreferredSnapshotVersion();
                    break;
                }
                this.setPreferredSnapshotVersion((Integer)value);
                break;
            }
            case IS_COPY_TABLET_TASK: {
                if (value == null) {
                    this.unsetIsCopyTabletTask();
                    break;
                }
                this.setIsCopyTabletTask((Boolean)value);
                break;
            }
            case START_VERSION: {
                if (value == null) {
                    this.unsetStartVersion();
                    break;
                }
                this.setStartVersion((Long)value);
                break;
            }
            case END_VERSION: {
                if (value == null) {
                    this.unsetEndVersion();
                    break;
                }
                this.setEndVersion((Long)value);
                break;
            }
            case IS_COPY_BINLOG: {
                if (value == null) {
                    this.unsetIsCopyBinlog();
                    break;
                }
                this.setIsCopyBinlog((Boolean)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TABLET_ID: {
                return this.getTabletId();
            }
            case SCHEMA_HASH: {
                return this.getSchemaHash();
            }
            case VERSION: {
                return this.getVersion();
            }
            case VERSION_HASH: {
                return this.getVersionHash();
            }
            case TIMEOUT: {
                return this.getTimeout();
            }
            case MISSING_VERSION: {
                return this.getMissingVersion();
            }
            case LIST_FILES: {
                return this.isListFiles();
            }
            case ALLOW_INCREMENTAL_CLONE: {
                return this.isAllowIncrementalClone();
            }
            case PREFERRED_SNAPSHOT_VERSION: {
                return this.getPreferredSnapshotVersion();
            }
            case IS_COPY_TABLET_TASK: {
                return this.isIsCopyTabletTask();
            }
            case START_VERSION: {
                return this.getStartVersion();
            }
            case END_VERSION: {
                return this.getEndVersion();
            }
            case IS_COPY_BINLOG: {
                return this.isIsCopyBinlog();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TABLET_ID: {
                return this.isSetTabletId();
            }
            case SCHEMA_HASH: {
                return this.isSetSchemaHash();
            }
            case VERSION: {
                return this.isSetVersion();
            }
            case VERSION_HASH: {
                return this.isSetVersionHash();
            }
            case TIMEOUT: {
                return this.isSetTimeout();
            }
            case MISSING_VERSION: {
                return this.isSetMissingVersion();
            }
            case LIST_FILES: {
                return this.isSetListFiles();
            }
            case ALLOW_INCREMENTAL_CLONE: {
                return this.isSetAllowIncrementalClone();
            }
            case PREFERRED_SNAPSHOT_VERSION: {
                return this.isSetPreferredSnapshotVersion();
            }
            case IS_COPY_TABLET_TASK: {
                return this.isSetIsCopyTabletTask();
            }
            case START_VERSION: {
                return this.isSetStartVersion();
            }
            case END_VERSION: {
                return this.isSetEndVersion();
            }
            case IS_COPY_BINLOG: {
                return this.isSetIsCopyBinlog();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof TSnapshotRequest) {
            return this.equals((TSnapshotRequest)that);
        }
        return false;
    }

    public boolean equals(TSnapshotRequest that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_tablet_id = true;
        boolean that_present_tablet_id = true;
        if (this_present_tablet_id || that_present_tablet_id) {
            if (!this_present_tablet_id || !that_present_tablet_id) {
                return false;
            }
            if (this.tablet_id != that.tablet_id) {
                return false;
            }
        }
        boolean this_present_schema_hash = true;
        boolean that_present_schema_hash = true;
        if (this_present_schema_hash || that_present_schema_hash) {
            if (!this_present_schema_hash || !that_present_schema_hash) {
                return false;
            }
            if (this.schema_hash != that.schema_hash) {
                return false;
            }
        }
        boolean this_present_version = this.isSetVersion();
        boolean that_present_version = that.isSetVersion();
        if (this_present_version || that_present_version) {
            if (!this_present_version || !that_present_version) {
                return false;
            }
            if (this.version != that.version) {
                return false;
            }
        }
        boolean this_present_version_hash = this.isSetVersionHash();
        boolean that_present_version_hash = that.isSetVersionHash();
        if (this_present_version_hash || that_present_version_hash) {
            if (!this_present_version_hash || !that_present_version_hash) {
                return false;
            }
            if (this.version_hash != that.version_hash) {
                return false;
            }
        }
        boolean this_present_timeout = this.isSetTimeout();
        boolean that_present_timeout = that.isSetTimeout();
        if (this_present_timeout || that_present_timeout) {
            if (!this_present_timeout || !that_present_timeout) {
                return false;
            }
            if (this.timeout != that.timeout) {
                return false;
            }
        }
        boolean this_present_missing_version = this.isSetMissingVersion();
        boolean that_present_missing_version = that.isSetMissingVersion();
        if (this_present_missing_version || that_present_missing_version) {
            if (!this_present_missing_version || !that_present_missing_version) {
                return false;
            }
            if (!this.missing_version.equals(that.missing_version)) {
                return false;
            }
        }
        boolean this_present_list_files = this.isSetListFiles();
        boolean that_present_list_files = that.isSetListFiles();
        if (this_present_list_files || that_present_list_files) {
            if (!this_present_list_files || !that_present_list_files) {
                return false;
            }
            if (this.list_files != that.list_files) {
                return false;
            }
        }
        boolean this_present_allow_incremental_clone = this.isSetAllowIncrementalClone();
        boolean that_present_allow_incremental_clone = that.isSetAllowIncrementalClone();
        if (this_present_allow_incremental_clone || that_present_allow_incremental_clone) {
            if (!this_present_allow_incremental_clone || !that_present_allow_incremental_clone) {
                return false;
            }
            if (this.allow_incremental_clone != that.allow_incremental_clone) {
                return false;
            }
        }
        boolean this_present_preferred_snapshot_version = this.isSetPreferredSnapshotVersion();
        boolean that_present_preferred_snapshot_version = that.isSetPreferredSnapshotVersion();
        if (this_present_preferred_snapshot_version || that_present_preferred_snapshot_version) {
            if (!this_present_preferred_snapshot_version || !that_present_preferred_snapshot_version) {
                return false;
            }
            if (this.preferred_snapshot_version != that.preferred_snapshot_version) {
                return false;
            }
        }
        boolean this_present_is_copy_tablet_task = this.isSetIsCopyTabletTask();
        boolean that_present_is_copy_tablet_task = that.isSetIsCopyTabletTask();
        if (this_present_is_copy_tablet_task || that_present_is_copy_tablet_task) {
            if (!this_present_is_copy_tablet_task || !that_present_is_copy_tablet_task) {
                return false;
            }
            if (this.is_copy_tablet_task != that.is_copy_tablet_task) {
                return false;
            }
        }
        boolean this_present_start_version = this.isSetStartVersion();
        boolean that_present_start_version = that.isSetStartVersion();
        if (this_present_start_version || that_present_start_version) {
            if (!this_present_start_version || !that_present_start_version) {
                return false;
            }
            if (this.start_version != that.start_version) {
                return false;
            }
        }
        boolean this_present_end_version = this.isSetEndVersion();
        boolean that_present_end_version = that.isSetEndVersion();
        if (this_present_end_version || that_present_end_version) {
            if (!this_present_end_version || !that_present_end_version) {
                return false;
            }
            if (this.end_version != that.end_version) {
                return false;
            }
        }
        boolean this_present_is_copy_binlog = this.isSetIsCopyBinlog();
        boolean that_present_is_copy_binlog = that.isSetIsCopyBinlog();
        if (this_present_is_copy_binlog || that_present_is_copy_binlog) {
            if (!this_present_is_copy_binlog || !that_present_is_copy_binlog) {
                return false;
            }
            if (this.is_copy_binlog != that.is_copy_binlog) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.tablet_id);
        hashCode = hashCode * 8191 + this.schema_hash;
        hashCode = hashCode * 8191 + (this.isSetVersion() ? 131071 : 524287);
        if (this.isSetVersion()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.version);
        }
        hashCode = hashCode * 8191 + (this.isSetVersionHash() ? 131071 : 524287);
        if (this.isSetVersionHash()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.version_hash);
        }
        hashCode = hashCode * 8191 + (this.isSetTimeout() ? 131071 : 524287);
        if (this.isSetTimeout()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.timeout);
        }
        hashCode = hashCode * 8191 + (this.isSetMissingVersion() ? 131071 : 524287);
        if (this.isSetMissingVersion()) {
            hashCode = hashCode * 8191 + this.missing_version.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetListFiles() ? 131071 : 524287);
        if (this.isSetListFiles()) {
            hashCode = hashCode * 8191 + (this.list_files ? 131071 : 524287);
        }
        hashCode = hashCode * 8191 + (this.isSetAllowIncrementalClone() ? 131071 : 524287);
        if (this.isSetAllowIncrementalClone()) {
            hashCode = hashCode * 8191 + (this.allow_incremental_clone ? 131071 : 524287);
        }
        hashCode = hashCode * 8191 + (this.isSetPreferredSnapshotVersion() ? 131071 : 524287);
        if (this.isSetPreferredSnapshotVersion()) {
            hashCode = hashCode * 8191 + this.preferred_snapshot_version;
        }
        hashCode = hashCode * 8191 + (this.isSetIsCopyTabletTask() ? 131071 : 524287);
        if (this.isSetIsCopyTabletTask()) {
            hashCode = hashCode * 8191 + (this.is_copy_tablet_task ? 131071 : 524287);
        }
        hashCode = hashCode * 8191 + (this.isSetStartVersion() ? 131071 : 524287);
        if (this.isSetStartVersion()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.start_version);
        }
        hashCode = hashCode * 8191 + (this.isSetEndVersion() ? 131071 : 524287);
        if (this.isSetEndVersion()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.end_version);
        }
        hashCode = hashCode * 8191 + (this.isSetIsCopyBinlog() ? 131071 : 524287);
        if (this.isSetIsCopyBinlog()) {
            hashCode = hashCode * 8191 + (this.is_copy_binlog ? 131071 : 524287);
        }
        return hashCode;
    }

    @Override
    public int compareTo(TSnapshotRequest other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetTabletId(), other.isSetTabletId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTabletId() && (lastComparison = TBaseHelper.compareTo((long)this.tablet_id, (long)other.tablet_id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetSchemaHash(), other.isSetSchemaHash());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSchemaHash() && (lastComparison = TBaseHelper.compareTo((int)this.schema_hash, (int)other.schema_hash)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetVersion(), other.isSetVersion());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetVersion() && (lastComparison = TBaseHelper.compareTo((long)this.version, (long)other.version)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetVersionHash(), other.isSetVersionHash());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetVersionHash() && (lastComparison = TBaseHelper.compareTo((long)this.version_hash, (long)other.version_hash)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTimeout(), other.isSetTimeout());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTimeout() && (lastComparison = TBaseHelper.compareTo((long)this.timeout, (long)other.timeout)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetMissingVersion(), other.isSetMissingVersion());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMissingVersion() && (lastComparison = TBaseHelper.compareTo(this.missing_version, other.missing_version)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetListFiles(), other.isSetListFiles());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetListFiles() && (lastComparison = TBaseHelper.compareTo((boolean)this.list_files, (boolean)other.list_files)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetAllowIncrementalClone(), other.isSetAllowIncrementalClone());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAllowIncrementalClone() && (lastComparison = TBaseHelper.compareTo((boolean)this.allow_incremental_clone, (boolean)other.allow_incremental_clone)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPreferredSnapshotVersion(), other.isSetPreferredSnapshotVersion());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPreferredSnapshotVersion() && (lastComparison = TBaseHelper.compareTo((int)this.preferred_snapshot_version, (int)other.preferred_snapshot_version)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetIsCopyTabletTask(), other.isSetIsCopyTabletTask());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIsCopyTabletTask() && (lastComparison = TBaseHelper.compareTo((boolean)this.is_copy_tablet_task, (boolean)other.is_copy_tablet_task)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetStartVersion(), other.isSetStartVersion());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetStartVersion() && (lastComparison = TBaseHelper.compareTo((long)this.start_version, (long)other.start_version)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetEndVersion(), other.isSetEndVersion());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEndVersion() && (lastComparison = TBaseHelper.compareTo((long)this.end_version, (long)other.end_version)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetIsCopyBinlog(), other.isSetIsCopyBinlog());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIsCopyBinlog() && (lastComparison = TBaseHelper.compareTo((boolean)this.is_copy_binlog, (boolean)other.is_copy_binlog)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        TSnapshotRequest.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        TSnapshotRequest.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TSnapshotRequest(");
        boolean first = true;
        sb.append("tablet_id:");
        sb.append(this.tablet_id);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("schema_hash:");
        sb.append(this.schema_hash);
        first = false;
        if (this.isSetVersion()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("version:");
            sb.append(this.version);
            first = false;
        }
        if (this.isSetVersionHash()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("version_hash:");
            sb.append(this.version_hash);
            first = false;
        }
        if (this.isSetTimeout()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("timeout:");
            sb.append(this.timeout);
            first = false;
        }
        if (this.isSetMissingVersion()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("missing_version:");
            if (this.missing_version == null) {
                sb.append("null");
            } else {
                sb.append(this.missing_version);
            }
            first = false;
        }
        if (this.isSetListFiles()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("list_files:");
            sb.append(this.list_files);
            first = false;
        }
        if (this.isSetAllowIncrementalClone()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("allow_incremental_clone:");
            sb.append(this.allow_incremental_clone);
            first = false;
        }
        if (this.isSetPreferredSnapshotVersion()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("preferred_snapshot_version:");
            sb.append(this.preferred_snapshot_version);
            first = false;
        }
        if (this.isSetIsCopyTabletTask()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("is_copy_tablet_task:");
            sb.append(this.is_copy_tablet_task);
            first = false;
        }
        if (this.isSetStartVersion()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("start_version:");
            sb.append(this.start_version);
            first = false;
        }
        if (this.isSetEndVersion()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("end_version:");
            sb.append(this.end_version);
            first = false;
        }
        if (this.isSetIsCopyBinlog()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("is_copy_binlog:");
            sb.append(this.is_copy_binlog);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TABLET_ID, new FieldMetaData("tablet_id", 1, new FieldValueMetaData(10, "TTabletId")));
        tmpMap.put(_Fields.SCHEMA_HASH, new FieldMetaData("schema_hash", 1, new FieldValueMetaData(8, "TSchemaHash")));
        tmpMap.put(_Fields.VERSION, new FieldMetaData("version", 2, new FieldValueMetaData(10, "TVersion")));
        tmpMap.put(_Fields.VERSION_HASH, new FieldMetaData("version_hash", 2, new FieldValueMetaData(10, "TVersionHash")));
        tmpMap.put(_Fields.TIMEOUT, new FieldMetaData("timeout", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.MISSING_VERSION, new FieldMetaData("missing_version", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(10, "TVersion"))));
        tmpMap.put(_Fields.LIST_FILES, new FieldMetaData("list_files", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.ALLOW_INCREMENTAL_CLONE, new FieldMetaData("allow_incremental_clone", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.PREFERRED_SNAPSHOT_VERSION, new FieldMetaData("preferred_snapshot_version", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.IS_COPY_TABLET_TASK, new FieldMetaData("is_copy_tablet_task", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.START_VERSION, new FieldMetaData("start_version", 2, new FieldValueMetaData(10, "TVersion")));
        tmpMap.put(_Fields.END_VERSION, new FieldMetaData("end_version", 2, new FieldValueMetaData(10, "TVersion")));
        tmpMap.put(_Fields.IS_COPY_BINLOG, new FieldMetaData("is_copy_binlog", 2, new FieldValueMetaData(2)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TSnapshotRequest.class, metaDataMap);
    }

    private static class TSnapshotRequestTupleScheme
    extends TupleScheme<TSnapshotRequest> {
        private TSnapshotRequestTupleScheme() {
        }

        public void write(TProtocol prot, TSnapshotRequest struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI64(struct.tablet_id);
            oprot.writeI32(struct.schema_hash);
            BitSet optionals = new BitSet();
            if (struct.isSetVersion()) {
                optionals.set(0);
            }
            if (struct.isSetVersionHash()) {
                optionals.set(1);
            }
            if (struct.isSetTimeout()) {
                optionals.set(2);
            }
            if (struct.isSetMissingVersion()) {
                optionals.set(3);
            }
            if (struct.isSetListFiles()) {
                optionals.set(4);
            }
            if (struct.isSetAllowIncrementalClone()) {
                optionals.set(5);
            }
            if (struct.isSetPreferredSnapshotVersion()) {
                optionals.set(6);
            }
            if (struct.isSetIsCopyTabletTask()) {
                optionals.set(7);
            }
            if (struct.isSetStartVersion()) {
                optionals.set(8);
            }
            if (struct.isSetEndVersion()) {
                optionals.set(9);
            }
            if (struct.isSetIsCopyBinlog()) {
                optionals.set(10);
            }
            oprot.writeBitSet(optionals, 11);
            if (struct.isSetVersion()) {
                oprot.writeI64(struct.version);
            }
            if (struct.isSetVersionHash()) {
                oprot.writeI64(struct.version_hash);
            }
            if (struct.isSetTimeout()) {
                oprot.writeI64(struct.timeout);
            }
            if (struct.isSetMissingVersion()) {
                oprot.writeI32(struct.missing_version.size());
                for (long _iter164 : struct.missing_version) {
                    oprot.writeI64(_iter164);
                }
            }
            if (struct.isSetListFiles()) {
                oprot.writeBool(struct.list_files);
            }
            if (struct.isSetAllowIncrementalClone()) {
                oprot.writeBool(struct.allow_incremental_clone);
            }
            if (struct.isSetPreferredSnapshotVersion()) {
                oprot.writeI32(struct.preferred_snapshot_version);
            }
            if (struct.isSetIsCopyTabletTask()) {
                oprot.writeBool(struct.is_copy_tablet_task);
            }
            if (struct.isSetStartVersion()) {
                oprot.writeI64(struct.start_version);
            }
            if (struct.isSetEndVersion()) {
                oprot.writeI64(struct.end_version);
            }
            if (struct.isSetIsCopyBinlog()) {
                oprot.writeBool(struct.is_copy_binlog);
            }
        }

        public void read(TProtocol prot, TSnapshotRequest struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.tablet_id = iprot.readI64();
            struct.setTabletIdIsSet(true);
            struct.schema_hash = iprot.readI32();
            struct.setSchemaHashIsSet(true);
            BitSet incoming = iprot.readBitSet(11);
            if (incoming.get(0)) {
                struct.version = iprot.readI64();
                struct.setVersionIsSet(true);
            }
            if (incoming.get(1)) {
                struct.version_hash = iprot.readI64();
                struct.setVersionHashIsSet(true);
            }
            if (incoming.get(2)) {
                struct.timeout = iprot.readI64();
                struct.setTimeoutIsSet(true);
            }
            if (incoming.get(3)) {
                TList _list165 = iprot.readListBegin((byte)10);
                struct.missing_version = new ArrayList<Long>(_list165.size);
                for (int _i167 = 0; _i167 < _list165.size; ++_i167) {
                    long _elem166 = iprot.readI64();
                    struct.missing_version.add(_elem166);
                }
                struct.setMissingVersionIsSet(true);
            }
            if (incoming.get(4)) {
                struct.list_files = iprot.readBool();
                struct.setListFilesIsSet(true);
            }
            if (incoming.get(5)) {
                struct.allow_incremental_clone = iprot.readBool();
                struct.setAllowIncrementalCloneIsSet(true);
            }
            if (incoming.get(6)) {
                struct.preferred_snapshot_version = iprot.readI32();
                struct.setPreferredSnapshotVersionIsSet(true);
            }
            if (incoming.get(7)) {
                struct.is_copy_tablet_task = iprot.readBool();
                struct.setIsCopyTabletTaskIsSet(true);
            }
            if (incoming.get(8)) {
                struct.start_version = iprot.readI64();
                struct.setStartVersionIsSet(true);
            }
            if (incoming.get(9)) {
                struct.end_version = iprot.readI64();
                struct.setEndVersionIsSet(true);
            }
            if (incoming.get(10)) {
                struct.is_copy_binlog = iprot.readBool();
                struct.setIsCopyBinlogIsSet(true);
            }
        }
    }

    private static class TSnapshotRequestTupleSchemeFactory
    implements SchemeFactory {
        private TSnapshotRequestTupleSchemeFactory() {
        }

        public TSnapshotRequestTupleScheme getScheme() {
            return new TSnapshotRequestTupleScheme();
        }
    }

    private static class TSnapshotRequestStandardScheme
    extends StandardScheme<TSnapshotRequest> {
        private TSnapshotRequestStandardScheme() {
        }

        public void read(TProtocol iprot, TSnapshotRequest struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 10) {
                            struct.tablet_id = iprot.readI64();
                            struct.setTabletIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 8) {
                            struct.schema_hash = iprot.readI32();
                            struct.setSchemaHashIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 10) {
                            struct.version = iprot.readI64();
                            struct.setVersionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 10) {
                            struct.version_hash = iprot.readI64();
                            struct.setVersionHashIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 10) {
                            struct.timeout = iprot.readI64();
                            struct.setTimeoutIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 15) {
                            TList _list160 = iprot.readListBegin();
                            struct.missing_version = new ArrayList<Long>(_list160.size);
                            for (int _i162 = 0; _i162 < _list160.size; ++_i162) {
                                long _elem161 = iprot.readI64();
                                struct.missing_version.add(_elem161);
                            }
                            iprot.readListEnd();
                            struct.setMissingVersionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 2) {
                            struct.list_files = iprot.readBool();
                            struct.setListFilesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 2) {
                            struct.allow_incremental_clone = iprot.readBool();
                            struct.setAllowIncrementalCloneIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 8) {
                            struct.preferred_snapshot_version = iprot.readI32();
                            struct.setPreferredSnapshotVersionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 2) {
                            struct.is_copy_tablet_task = iprot.readBool();
                            struct.setIsCopyTabletTaskIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 10) {
                            struct.start_version = iprot.readI64();
                            struct.setStartVersionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 10) {
                            struct.end_version = iprot.readI64();
                            struct.setEndVersionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 13: {
                        if (schemeField.type == 2) {
                            struct.is_copy_binlog = iprot.readBool();
                            struct.setIsCopyBinlogIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetTabletId()) {
                throw new TProtocolException("Required field 'tablet_id' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetSchemaHash()) {
                throw new TProtocolException("Required field 'schema_hash' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            struct.validate();
        }

        public void write(TProtocol oprot, TSnapshotRequest struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(TABLET_ID_FIELD_DESC);
            oprot.writeI64(struct.tablet_id);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(SCHEMA_HASH_FIELD_DESC);
            oprot.writeI32(struct.schema_hash);
            oprot.writeFieldEnd();
            if (struct.isSetVersion()) {
                oprot.writeFieldBegin(VERSION_FIELD_DESC);
                oprot.writeI64(struct.version);
                oprot.writeFieldEnd();
            }
            if (struct.isSetVersionHash()) {
                oprot.writeFieldBegin(VERSION_HASH_FIELD_DESC);
                oprot.writeI64(struct.version_hash);
                oprot.writeFieldEnd();
            }
            if (struct.isSetTimeout()) {
                oprot.writeFieldBegin(TIMEOUT_FIELD_DESC);
                oprot.writeI64(struct.timeout);
                oprot.writeFieldEnd();
            }
            if (struct.missing_version != null && struct.isSetMissingVersion()) {
                oprot.writeFieldBegin(MISSING_VERSION_FIELD_DESC);
                oprot.writeListBegin(new TList(10, struct.missing_version.size()));
                for (long _iter163 : struct.missing_version) {
                    oprot.writeI64(_iter163);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.isSetListFiles()) {
                oprot.writeFieldBegin(LIST_FILES_FIELD_DESC);
                oprot.writeBool(struct.list_files);
                oprot.writeFieldEnd();
            }
            if (struct.isSetAllowIncrementalClone()) {
                oprot.writeFieldBegin(ALLOW_INCREMENTAL_CLONE_FIELD_DESC);
                oprot.writeBool(struct.allow_incremental_clone);
                oprot.writeFieldEnd();
            }
            if (struct.isSetPreferredSnapshotVersion()) {
                oprot.writeFieldBegin(PREFERRED_SNAPSHOT_VERSION_FIELD_DESC);
                oprot.writeI32(struct.preferred_snapshot_version);
                oprot.writeFieldEnd();
            }
            if (struct.isSetIsCopyTabletTask()) {
                oprot.writeFieldBegin(IS_COPY_TABLET_TASK_FIELD_DESC);
                oprot.writeBool(struct.is_copy_tablet_task);
                oprot.writeFieldEnd();
            }
            if (struct.isSetStartVersion()) {
                oprot.writeFieldBegin(START_VERSION_FIELD_DESC);
                oprot.writeI64(struct.start_version);
                oprot.writeFieldEnd();
            }
            if (struct.isSetEndVersion()) {
                oprot.writeFieldBegin(END_VERSION_FIELD_DESC);
                oprot.writeI64(struct.end_version);
                oprot.writeFieldEnd();
            }
            if (struct.isSetIsCopyBinlog()) {
                oprot.writeFieldBegin(IS_COPY_BINLOG_FIELD_DESC);
                oprot.writeBool(struct.is_copy_binlog);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TSnapshotRequestStandardSchemeFactory
    implements SchemeFactory {
        private TSnapshotRequestStandardSchemeFactory() {
        }

        public TSnapshotRequestStandardScheme getScheme() {
            return new TSnapshotRequestStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TABLET_ID(1, "tablet_id"),
        SCHEMA_HASH(2, "schema_hash"),
        VERSION(3, "version"),
        VERSION_HASH(4, "version_hash"),
        TIMEOUT(5, "timeout"),
        MISSING_VERSION(6, "missing_version"),
        LIST_FILES(7, "list_files"),
        ALLOW_INCREMENTAL_CLONE(8, "allow_incremental_clone"),
        PREFERRED_SNAPSHOT_VERSION(9, "preferred_snapshot_version"),
        IS_COPY_TABLET_TASK(10, "is_copy_tablet_task"),
        START_VERSION(11, "start_version"),
        END_VERSION(12, "end_version"),
        IS_COPY_BINLOG(13, "is_copy_binlog");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TABLET_ID;
                }
                case 2: {
                    return SCHEMA_HASH;
                }
                case 3: {
                    return VERSION;
                }
                case 4: {
                    return VERSION_HASH;
                }
                case 5: {
                    return TIMEOUT;
                }
                case 6: {
                    return MISSING_VERSION;
                }
                case 7: {
                    return LIST_FILES;
                }
                case 8: {
                    return ALLOW_INCREMENTAL_CLONE;
                }
                case 9: {
                    return PREFERRED_SNAPSHOT_VERSION;
                }
                case 10: {
                    return IS_COPY_TABLET_TASK;
                }
                case 11: {
                    return START_VERSION;
                }
                case 12: {
                    return END_VERSION;
                }
                case 13: {
                    return IS_COPY_BINLOG;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

