/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.doris.thrift.TExecPlanFragmentParams;
import org.apache.doris.thrift.TFileFormatType;
import org.apache.doris.thrift.TKafkaLoadInfo;
import org.apache.doris.thrift.TLoadSourceType;
import org.apache.doris.thrift.TPipelineFragmentParams;
import org.apache.doris.thrift.TUniqueId;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TRoutineLoadTask
implements TBase<TRoutineLoadTask, _Fields>,
Serializable,
Cloneable,
Comparable<TRoutineLoadTask> {
    private static final TStruct STRUCT_DESC = new TStruct("TRoutineLoadTask");
    private static final TField TYPE_FIELD_DESC = new TField("type", 8, 1);
    private static final TField JOB_ID_FIELD_DESC = new TField("job_id", 10, 2);
    private static final TField ID_FIELD_DESC = new TField("id", 12, 3);
    private static final TField TXN_ID_FIELD_DESC = new TField("txn_id", 10, 4);
    private static final TField AUTH_CODE_FIELD_DESC = new TField("auth_code", 10, 5);
    private static final TField DB_FIELD_DESC = new TField("db", 11, 6);
    private static final TField TBL_FIELD_DESC = new TField("tbl", 11, 7);
    private static final TField LABEL_FIELD_DESC = new TField("label", 11, 8);
    private static final TField MAX_INTERVAL_S_FIELD_DESC = new TField("max_interval_s", 10, 9);
    private static final TField MAX_BATCH_ROWS_FIELD_DESC = new TField("max_batch_rows", 10, 10);
    private static final TField MAX_BATCH_SIZE_FIELD_DESC = new TField("max_batch_size", 10, 11);
    private static final TField KAFKA_LOAD_INFO_FIELD_DESC = new TField("kafka_load_info", 12, 12);
    private static final TField PARAMS_FIELD_DESC = new TField("params", 12, 13);
    private static final TField FORMAT_FIELD_DESC = new TField("format", 8, 14);
    private static final TField PIPELINE_PARAMS_FIELD_DESC = new TField("pipeline_params", 12, 15);
    private static final TField IS_MULTI_TABLE_FIELD_DESC = new TField("is_multi_table", 2, 16);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TRoutineLoadTaskStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TRoutineLoadTaskTupleSchemeFactory();
    @Nullable
    public TLoadSourceType type;
    public long job_id;
    @Nullable
    public TUniqueId id;
    public long txn_id;
    public long auth_code;
    @Nullable
    public String db;
    @Nullable
    public String tbl;
    @Nullable
    public String label;
    public long max_interval_s;
    public long max_batch_rows;
    public long max_batch_size;
    @Nullable
    public TKafkaLoadInfo kafka_load_info;
    @Nullable
    public TExecPlanFragmentParams params;
    @Nullable
    public TFileFormatType format;
    @Nullable
    public TPipelineFragmentParams pipeline_params;
    public boolean is_multi_table;
    private static final int __JOB_ID_ISSET_ID = 0;
    private static final int __TXN_ID_ISSET_ID = 1;
    private static final int __AUTH_CODE_ISSET_ID = 2;
    private static final int __MAX_INTERVAL_S_ISSET_ID = 3;
    private static final int __MAX_BATCH_ROWS_ISSET_ID = 4;
    private static final int __MAX_BATCH_SIZE_ISSET_ID = 5;
    private static final int __IS_MULTI_TABLE_ISSET_ID = 6;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.DB, _Fields.TBL, _Fields.LABEL, _Fields.MAX_INTERVAL_S, _Fields.MAX_BATCH_ROWS, _Fields.MAX_BATCH_SIZE, _Fields.KAFKA_LOAD_INFO, _Fields.PARAMS, _Fields.FORMAT, _Fields.PIPELINE_PARAMS, _Fields.IS_MULTI_TABLE};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TRoutineLoadTask() {
    }

    public TRoutineLoadTask(TLoadSourceType type, long job_id, TUniqueId id, long txn_id, long auth_code) {
        this();
        this.type = type;
        this.job_id = job_id;
        this.setJobIdIsSet(true);
        this.id = id;
        this.txn_id = txn_id;
        this.setTxnIdIsSet(true);
        this.auth_code = auth_code;
        this.setAuthCodeIsSet(true);
    }

    public TRoutineLoadTask(TRoutineLoadTask other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetType()) {
            this.type = other.type;
        }
        this.job_id = other.job_id;
        if (other.isSetId()) {
            this.id = new TUniqueId(other.id);
        }
        this.txn_id = other.txn_id;
        this.auth_code = other.auth_code;
        if (other.isSetDb()) {
            this.db = other.db;
        }
        if (other.isSetTbl()) {
            this.tbl = other.tbl;
        }
        if (other.isSetLabel()) {
            this.label = other.label;
        }
        this.max_interval_s = other.max_interval_s;
        this.max_batch_rows = other.max_batch_rows;
        this.max_batch_size = other.max_batch_size;
        if (other.isSetKafkaLoadInfo()) {
            this.kafka_load_info = new TKafkaLoadInfo(other.kafka_load_info);
        }
        if (other.isSetParams()) {
            this.params = new TExecPlanFragmentParams(other.params);
        }
        if (other.isSetFormat()) {
            this.format = other.format;
        }
        if (other.isSetPipelineParams()) {
            this.pipeline_params = new TPipelineFragmentParams(other.pipeline_params);
        }
        this.is_multi_table = other.is_multi_table;
    }

    public TRoutineLoadTask deepCopy() {
        return new TRoutineLoadTask(this);
    }

    public void clear() {
        this.type = null;
        this.setJobIdIsSet(false);
        this.job_id = 0L;
        this.id = null;
        this.setTxnIdIsSet(false);
        this.txn_id = 0L;
        this.setAuthCodeIsSet(false);
        this.auth_code = 0L;
        this.db = null;
        this.tbl = null;
        this.label = null;
        this.setMaxIntervalSIsSet(false);
        this.max_interval_s = 0L;
        this.setMaxBatchRowsIsSet(false);
        this.max_batch_rows = 0L;
        this.setMaxBatchSizeIsSet(false);
        this.max_batch_size = 0L;
        this.kafka_load_info = null;
        this.params = null;
        this.format = null;
        this.pipeline_params = null;
        this.setIsMultiTableIsSet(false);
        this.is_multi_table = false;
    }

    @Nullable
    public TLoadSourceType getType() {
        return this.type;
    }

    public TRoutineLoadTask setType(@Nullable TLoadSourceType type) {
        this.type = type;
        return this;
    }

    public void unsetType() {
        this.type = null;
    }

    public boolean isSetType() {
        return this.type != null;
    }

    public void setTypeIsSet(boolean value) {
        if (!value) {
            this.type = null;
        }
    }

    public long getJobId() {
        return this.job_id;
    }

    public TRoutineLoadTask setJobId(long job_id) {
        this.job_id = job_id;
        this.setJobIdIsSet(true);
        return this;
    }

    public void unsetJobId() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetJobId() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setJobIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    @Nullable
    public TUniqueId getId() {
        return this.id;
    }

    public TRoutineLoadTask setId(@Nullable TUniqueId id) {
        this.id = id;
        return this;
    }

    public void unsetId() {
        this.id = null;
    }

    public boolean isSetId() {
        return this.id != null;
    }

    public void setIdIsSet(boolean value) {
        if (!value) {
            this.id = null;
        }
    }

    public long getTxnId() {
        return this.txn_id;
    }

    public TRoutineLoadTask setTxnId(long txn_id) {
        this.txn_id = txn_id;
        this.setTxnIdIsSet(true);
        return this;
    }

    public void unsetTxnId() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetTxnId() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setTxnIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public long getAuthCode() {
        return this.auth_code;
    }

    public TRoutineLoadTask setAuthCode(long auth_code) {
        this.auth_code = auth_code;
        this.setAuthCodeIsSet(true);
        return this;
    }

    public void unsetAuthCode() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetAuthCode() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setAuthCodeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    @Nullable
    public String getDb() {
        return this.db;
    }

    public TRoutineLoadTask setDb(@Nullable String db) {
        this.db = db;
        return this;
    }

    public void unsetDb() {
        this.db = null;
    }

    public boolean isSetDb() {
        return this.db != null;
    }

    public void setDbIsSet(boolean value) {
        if (!value) {
            this.db = null;
        }
    }

    @Nullable
    public String getTbl() {
        return this.tbl;
    }

    public TRoutineLoadTask setTbl(@Nullable String tbl) {
        this.tbl = tbl;
        return this;
    }

    public void unsetTbl() {
        this.tbl = null;
    }

    public boolean isSetTbl() {
        return this.tbl != null;
    }

    public void setTblIsSet(boolean value) {
        if (!value) {
            this.tbl = null;
        }
    }

    @Nullable
    public String getLabel() {
        return this.label;
    }

    public TRoutineLoadTask setLabel(@Nullable String label) {
        this.label = label;
        return this;
    }

    public void unsetLabel() {
        this.label = null;
    }

    public boolean isSetLabel() {
        return this.label != null;
    }

    public void setLabelIsSet(boolean value) {
        if (!value) {
            this.label = null;
        }
    }

    public long getMaxIntervalS() {
        return this.max_interval_s;
    }

    public TRoutineLoadTask setMaxIntervalS(long max_interval_s) {
        this.max_interval_s = max_interval_s;
        this.setMaxIntervalSIsSet(true);
        return this;
    }

    public void unsetMaxIntervalS() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)3);
    }

    public boolean isSetMaxIntervalS() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)3);
    }

    public void setMaxIntervalSIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)3, (boolean)value);
    }

    public long getMaxBatchRows() {
        return this.max_batch_rows;
    }

    public TRoutineLoadTask setMaxBatchRows(long max_batch_rows) {
        this.max_batch_rows = max_batch_rows;
        this.setMaxBatchRowsIsSet(true);
        return this;
    }

    public void unsetMaxBatchRows() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)4);
    }

    public boolean isSetMaxBatchRows() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)4);
    }

    public void setMaxBatchRowsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)4, (boolean)value);
    }

    public long getMaxBatchSize() {
        return this.max_batch_size;
    }

    public TRoutineLoadTask setMaxBatchSize(long max_batch_size) {
        this.max_batch_size = max_batch_size;
        this.setMaxBatchSizeIsSet(true);
        return this;
    }

    public void unsetMaxBatchSize() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)5);
    }

    public boolean isSetMaxBatchSize() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)5);
    }

    public void setMaxBatchSizeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)5, (boolean)value);
    }

    @Nullable
    public TKafkaLoadInfo getKafkaLoadInfo() {
        return this.kafka_load_info;
    }

    public TRoutineLoadTask setKafkaLoadInfo(@Nullable TKafkaLoadInfo kafka_load_info) {
        this.kafka_load_info = kafka_load_info;
        return this;
    }

    public void unsetKafkaLoadInfo() {
        this.kafka_load_info = null;
    }

    public boolean isSetKafkaLoadInfo() {
        return this.kafka_load_info != null;
    }

    public void setKafkaLoadInfoIsSet(boolean value) {
        if (!value) {
            this.kafka_load_info = null;
        }
    }

    @Nullable
    public TExecPlanFragmentParams getParams() {
        return this.params;
    }

    public TRoutineLoadTask setParams(@Nullable TExecPlanFragmentParams params) {
        this.params = params;
        return this;
    }

    public void unsetParams() {
        this.params = null;
    }

    public boolean isSetParams() {
        return this.params != null;
    }

    public void setParamsIsSet(boolean value) {
        if (!value) {
            this.params = null;
        }
    }

    @Nullable
    public TFileFormatType getFormat() {
        return this.format;
    }

    public TRoutineLoadTask setFormat(@Nullable TFileFormatType format) {
        this.format = format;
        return this;
    }

    public void unsetFormat() {
        this.format = null;
    }

    public boolean isSetFormat() {
        return this.format != null;
    }

    public void setFormatIsSet(boolean value) {
        if (!value) {
            this.format = null;
        }
    }

    @Nullable
    public TPipelineFragmentParams getPipelineParams() {
        return this.pipeline_params;
    }

    public TRoutineLoadTask setPipelineParams(@Nullable TPipelineFragmentParams pipeline_params) {
        this.pipeline_params = pipeline_params;
        return this;
    }

    public void unsetPipelineParams() {
        this.pipeline_params = null;
    }

    public boolean isSetPipelineParams() {
        return this.pipeline_params != null;
    }

    public void setPipelineParamsIsSet(boolean value) {
        if (!value) {
            this.pipeline_params = null;
        }
    }

    public boolean isIsMultiTable() {
        return this.is_multi_table;
    }

    public TRoutineLoadTask setIsMultiTable(boolean is_multi_table) {
        this.is_multi_table = is_multi_table;
        this.setIsMultiTableIsSet(true);
        return this;
    }

    public void unsetIsMultiTable() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)6);
    }

    public boolean isSetIsMultiTable() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)6);
    }

    public void setIsMultiTableIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)6, (boolean)value);
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case TYPE: {
                if (value == null) {
                    this.unsetType();
                    break;
                }
                this.setType((TLoadSourceType)((Object)value));
                break;
            }
            case JOB_ID: {
                if (value == null) {
                    this.unsetJobId();
                    break;
                }
                this.setJobId((Long)value);
                break;
            }
            case ID: {
                if (value == null) {
                    this.unsetId();
                    break;
                }
                this.setId((TUniqueId)value);
                break;
            }
            case TXN_ID: {
                if (value == null) {
                    this.unsetTxnId();
                    break;
                }
                this.setTxnId((Long)value);
                break;
            }
            case AUTH_CODE: {
                if (value == null) {
                    this.unsetAuthCode();
                    break;
                }
                this.setAuthCode((Long)value);
                break;
            }
            case DB: {
                if (value == null) {
                    this.unsetDb();
                    break;
                }
                this.setDb((String)value);
                break;
            }
            case TBL: {
                if (value == null) {
                    this.unsetTbl();
                    break;
                }
                this.setTbl((String)value);
                break;
            }
            case LABEL: {
                if (value == null) {
                    this.unsetLabel();
                    break;
                }
                this.setLabel((String)value);
                break;
            }
            case MAX_INTERVAL_S: {
                if (value == null) {
                    this.unsetMaxIntervalS();
                    break;
                }
                this.setMaxIntervalS((Long)value);
                break;
            }
            case MAX_BATCH_ROWS: {
                if (value == null) {
                    this.unsetMaxBatchRows();
                    break;
                }
                this.setMaxBatchRows((Long)value);
                break;
            }
            case MAX_BATCH_SIZE: {
                if (value == null) {
                    this.unsetMaxBatchSize();
                    break;
                }
                this.setMaxBatchSize((Long)value);
                break;
            }
            case KAFKA_LOAD_INFO: {
                if (value == null) {
                    this.unsetKafkaLoadInfo();
                    break;
                }
                this.setKafkaLoadInfo((TKafkaLoadInfo)value);
                break;
            }
            case PARAMS: {
                if (value == null) {
                    this.unsetParams();
                    break;
                }
                this.setParams((TExecPlanFragmentParams)value);
                break;
            }
            case FORMAT: {
                if (value == null) {
                    this.unsetFormat();
                    break;
                }
                this.setFormat((TFileFormatType)((Object)value));
                break;
            }
            case PIPELINE_PARAMS: {
                if (value == null) {
                    this.unsetPipelineParams();
                    break;
                }
                this.setPipelineParams((TPipelineFragmentParams)value);
                break;
            }
            case IS_MULTI_TABLE: {
                if (value == null) {
                    this.unsetIsMultiTable();
                    break;
                }
                this.setIsMultiTable((Boolean)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TYPE: {
                return this.getType();
            }
            case JOB_ID: {
                return this.getJobId();
            }
            case ID: {
                return this.getId();
            }
            case TXN_ID: {
                return this.getTxnId();
            }
            case AUTH_CODE: {
                return this.getAuthCode();
            }
            case DB: {
                return this.getDb();
            }
            case TBL: {
                return this.getTbl();
            }
            case LABEL: {
                return this.getLabel();
            }
            case MAX_INTERVAL_S: {
                return this.getMaxIntervalS();
            }
            case MAX_BATCH_ROWS: {
                return this.getMaxBatchRows();
            }
            case MAX_BATCH_SIZE: {
                return this.getMaxBatchSize();
            }
            case KAFKA_LOAD_INFO: {
                return this.getKafkaLoadInfo();
            }
            case PARAMS: {
                return this.getParams();
            }
            case FORMAT: {
                return this.getFormat();
            }
            case PIPELINE_PARAMS: {
                return this.getPipelineParams();
            }
            case IS_MULTI_TABLE: {
                return this.isIsMultiTable();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TYPE: {
                return this.isSetType();
            }
            case JOB_ID: {
                return this.isSetJobId();
            }
            case ID: {
                return this.isSetId();
            }
            case TXN_ID: {
                return this.isSetTxnId();
            }
            case AUTH_CODE: {
                return this.isSetAuthCode();
            }
            case DB: {
                return this.isSetDb();
            }
            case TBL: {
                return this.isSetTbl();
            }
            case LABEL: {
                return this.isSetLabel();
            }
            case MAX_INTERVAL_S: {
                return this.isSetMaxIntervalS();
            }
            case MAX_BATCH_ROWS: {
                return this.isSetMaxBatchRows();
            }
            case MAX_BATCH_SIZE: {
                return this.isSetMaxBatchSize();
            }
            case KAFKA_LOAD_INFO: {
                return this.isSetKafkaLoadInfo();
            }
            case PARAMS: {
                return this.isSetParams();
            }
            case FORMAT: {
                return this.isSetFormat();
            }
            case PIPELINE_PARAMS: {
                return this.isSetPipelineParams();
            }
            case IS_MULTI_TABLE: {
                return this.isSetIsMultiTable();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof TRoutineLoadTask) {
            return this.equals((TRoutineLoadTask)that);
        }
        return false;
    }

    public boolean equals(TRoutineLoadTask that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_type = this.isSetType();
        boolean that_present_type = that.isSetType();
        if (this_present_type || that_present_type) {
            if (!this_present_type || !that_present_type) {
                return false;
            }
            if (!this.type.equals((Object)that.type)) {
                return false;
            }
        }
        boolean this_present_job_id = true;
        boolean that_present_job_id = true;
        if (this_present_job_id || that_present_job_id) {
            if (!this_present_job_id || !that_present_job_id) {
                return false;
            }
            if (this.job_id != that.job_id) {
                return false;
            }
        }
        boolean this_present_id = this.isSetId();
        boolean that_present_id = that.isSetId();
        if (this_present_id || that_present_id) {
            if (!this_present_id || !that_present_id) {
                return false;
            }
            if (!this.id.equals(that.id)) {
                return false;
            }
        }
        boolean this_present_txn_id = true;
        boolean that_present_txn_id = true;
        if (this_present_txn_id || that_present_txn_id) {
            if (!this_present_txn_id || !that_present_txn_id) {
                return false;
            }
            if (this.txn_id != that.txn_id) {
                return false;
            }
        }
        boolean this_present_auth_code = true;
        boolean that_present_auth_code = true;
        if (this_present_auth_code || that_present_auth_code) {
            if (!this_present_auth_code || !that_present_auth_code) {
                return false;
            }
            if (this.auth_code != that.auth_code) {
                return false;
            }
        }
        boolean this_present_db = this.isSetDb();
        boolean that_present_db = that.isSetDb();
        if (this_present_db || that_present_db) {
            if (!this_present_db || !that_present_db) {
                return false;
            }
            if (!this.db.equals(that.db)) {
                return false;
            }
        }
        boolean this_present_tbl = this.isSetTbl();
        boolean that_present_tbl = that.isSetTbl();
        if (this_present_tbl || that_present_tbl) {
            if (!this_present_tbl || !that_present_tbl) {
                return false;
            }
            if (!this.tbl.equals(that.tbl)) {
                return false;
            }
        }
        boolean this_present_label = this.isSetLabel();
        boolean that_present_label = that.isSetLabel();
        if (this_present_label || that_present_label) {
            if (!this_present_label || !that_present_label) {
                return false;
            }
            if (!this.label.equals(that.label)) {
                return false;
            }
        }
        boolean this_present_max_interval_s = this.isSetMaxIntervalS();
        boolean that_present_max_interval_s = that.isSetMaxIntervalS();
        if (this_present_max_interval_s || that_present_max_interval_s) {
            if (!this_present_max_interval_s || !that_present_max_interval_s) {
                return false;
            }
            if (this.max_interval_s != that.max_interval_s) {
                return false;
            }
        }
        boolean this_present_max_batch_rows = this.isSetMaxBatchRows();
        boolean that_present_max_batch_rows = that.isSetMaxBatchRows();
        if (this_present_max_batch_rows || that_present_max_batch_rows) {
            if (!this_present_max_batch_rows || !that_present_max_batch_rows) {
                return false;
            }
            if (this.max_batch_rows != that.max_batch_rows) {
                return false;
            }
        }
        boolean this_present_max_batch_size = this.isSetMaxBatchSize();
        boolean that_present_max_batch_size = that.isSetMaxBatchSize();
        if (this_present_max_batch_size || that_present_max_batch_size) {
            if (!this_present_max_batch_size || !that_present_max_batch_size) {
                return false;
            }
            if (this.max_batch_size != that.max_batch_size) {
                return false;
            }
        }
        boolean this_present_kafka_load_info = this.isSetKafkaLoadInfo();
        boolean that_present_kafka_load_info = that.isSetKafkaLoadInfo();
        if (this_present_kafka_load_info || that_present_kafka_load_info) {
            if (!this_present_kafka_load_info || !that_present_kafka_load_info) {
                return false;
            }
            if (!this.kafka_load_info.equals(that.kafka_load_info)) {
                return false;
            }
        }
        boolean this_present_params = this.isSetParams();
        boolean that_present_params = that.isSetParams();
        if (this_present_params || that_present_params) {
            if (!this_present_params || !that_present_params) {
                return false;
            }
            if (!this.params.equals(that.params)) {
                return false;
            }
        }
        boolean this_present_format = this.isSetFormat();
        boolean that_present_format = that.isSetFormat();
        if (this_present_format || that_present_format) {
            if (!this_present_format || !that_present_format) {
                return false;
            }
            if (!this.format.equals((Object)that.format)) {
                return false;
            }
        }
        boolean this_present_pipeline_params = this.isSetPipelineParams();
        boolean that_present_pipeline_params = that.isSetPipelineParams();
        if (this_present_pipeline_params || that_present_pipeline_params) {
            if (!this_present_pipeline_params || !that_present_pipeline_params) {
                return false;
            }
            if (!this.pipeline_params.equals(that.pipeline_params)) {
                return false;
            }
        }
        boolean this_present_is_multi_table = this.isSetIsMultiTable();
        boolean that_present_is_multi_table = that.isSetIsMultiTable();
        if (this_present_is_multi_table || that_present_is_multi_table) {
            if (!this_present_is_multi_table || !that_present_is_multi_table) {
                return false;
            }
            if (this.is_multi_table != that.is_multi_table) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetType() ? 131071 : 524287);
        if (this.isSetType()) {
            hashCode = hashCode * 8191 + this.type.getValue();
        }
        hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.job_id);
        hashCode = hashCode * 8191 + (this.isSetId() ? 131071 : 524287);
        if (this.isSetId()) {
            hashCode = hashCode * 8191 + this.id.hashCode();
        }
        hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.txn_id);
        hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.auth_code);
        hashCode = hashCode * 8191 + (this.isSetDb() ? 131071 : 524287);
        if (this.isSetDb()) {
            hashCode = hashCode * 8191 + this.db.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTbl() ? 131071 : 524287);
        if (this.isSetTbl()) {
            hashCode = hashCode * 8191 + this.tbl.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetLabel() ? 131071 : 524287);
        if (this.isSetLabel()) {
            hashCode = hashCode * 8191 + this.label.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetMaxIntervalS() ? 131071 : 524287);
        if (this.isSetMaxIntervalS()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.max_interval_s);
        }
        hashCode = hashCode * 8191 + (this.isSetMaxBatchRows() ? 131071 : 524287);
        if (this.isSetMaxBatchRows()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.max_batch_rows);
        }
        hashCode = hashCode * 8191 + (this.isSetMaxBatchSize() ? 131071 : 524287);
        if (this.isSetMaxBatchSize()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.max_batch_size);
        }
        hashCode = hashCode * 8191 + (this.isSetKafkaLoadInfo() ? 131071 : 524287);
        if (this.isSetKafkaLoadInfo()) {
            hashCode = hashCode * 8191 + this.kafka_load_info.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetParams() ? 131071 : 524287);
        if (this.isSetParams()) {
            hashCode = hashCode * 8191 + this.params.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetFormat() ? 131071 : 524287);
        if (this.isSetFormat()) {
            hashCode = hashCode * 8191 + this.format.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetPipelineParams() ? 131071 : 524287);
        if (this.isSetPipelineParams()) {
            hashCode = hashCode * 8191 + this.pipeline_params.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetIsMultiTable() ? 131071 : 524287);
        if (this.isSetIsMultiTable()) {
            hashCode = hashCode * 8191 + (this.is_multi_table ? 131071 : 524287);
        }
        return hashCode;
    }

    @Override
    public int compareTo(TRoutineLoadTask other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetType(), other.isSetType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.type), (Comparable)((Object)other.type))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetJobId(), other.isSetJobId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetJobId() && (lastComparison = TBaseHelper.compareTo((long)this.job_id, (long)other.job_id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetId(), other.isSetId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetId() && (lastComparison = TBaseHelper.compareTo((Comparable)this.id, (Comparable)other.id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTxnId(), other.isSetTxnId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTxnId() && (lastComparison = TBaseHelper.compareTo((long)this.txn_id, (long)other.txn_id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetAuthCode(), other.isSetAuthCode());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAuthCode() && (lastComparison = TBaseHelper.compareTo((long)this.auth_code, (long)other.auth_code)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetDb(), other.isSetDb());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDb() && (lastComparison = TBaseHelper.compareTo((String)this.db, (String)other.db)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTbl(), other.isSetTbl());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTbl() && (lastComparison = TBaseHelper.compareTo((String)this.tbl, (String)other.tbl)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetLabel(), other.isSetLabel());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLabel() && (lastComparison = TBaseHelper.compareTo((String)this.label, (String)other.label)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetMaxIntervalS(), other.isSetMaxIntervalS());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMaxIntervalS() && (lastComparison = TBaseHelper.compareTo((long)this.max_interval_s, (long)other.max_interval_s)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetMaxBatchRows(), other.isSetMaxBatchRows());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMaxBatchRows() && (lastComparison = TBaseHelper.compareTo((long)this.max_batch_rows, (long)other.max_batch_rows)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetMaxBatchSize(), other.isSetMaxBatchSize());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMaxBatchSize() && (lastComparison = TBaseHelper.compareTo((long)this.max_batch_size, (long)other.max_batch_size)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetKafkaLoadInfo(), other.isSetKafkaLoadInfo());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetKafkaLoadInfo() && (lastComparison = TBaseHelper.compareTo((Comparable)this.kafka_load_info, (Comparable)other.kafka_load_info)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetParams(), other.isSetParams());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetParams() && (lastComparison = TBaseHelper.compareTo((Comparable)this.params, (Comparable)other.params)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetFormat(), other.isSetFormat());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFormat() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.format), (Comparable)((Object)other.format))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPipelineParams(), other.isSetPipelineParams());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPipelineParams() && (lastComparison = TBaseHelper.compareTo((Comparable)this.pipeline_params, (Comparable)other.pipeline_params)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetIsMultiTable(), other.isSetIsMultiTable());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIsMultiTable() && (lastComparison = TBaseHelper.compareTo((boolean)this.is_multi_table, (boolean)other.is_multi_table)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        TRoutineLoadTask.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        TRoutineLoadTask.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TRoutineLoadTask(");
        boolean first = true;
        sb.append("type:");
        if (this.type == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.type);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("job_id:");
        sb.append(this.job_id);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("id:");
        if (this.id == null) {
            sb.append("null");
        } else {
            sb.append(this.id);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("txn_id:");
        sb.append(this.txn_id);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("auth_code:");
        sb.append(this.auth_code);
        first = false;
        if (this.isSetDb()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("db:");
            if (this.db == null) {
                sb.append("null");
            } else {
                sb.append(this.db);
            }
            first = false;
        }
        if (this.isSetTbl()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("tbl:");
            if (this.tbl == null) {
                sb.append("null");
            } else {
                sb.append(this.tbl);
            }
            first = false;
        }
        if (this.isSetLabel()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("label:");
            if (this.label == null) {
                sb.append("null");
            } else {
                sb.append(this.label);
            }
            first = false;
        }
        if (this.isSetMaxIntervalS()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("max_interval_s:");
            sb.append(this.max_interval_s);
            first = false;
        }
        if (this.isSetMaxBatchRows()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("max_batch_rows:");
            sb.append(this.max_batch_rows);
            first = false;
        }
        if (this.isSetMaxBatchSize()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("max_batch_size:");
            sb.append(this.max_batch_size);
            first = false;
        }
        if (this.isSetKafkaLoadInfo()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("kafka_load_info:");
            if (this.kafka_load_info == null) {
                sb.append("null");
            } else {
                sb.append(this.kafka_load_info);
            }
            first = false;
        }
        if (this.isSetParams()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("params:");
            if (this.params == null) {
                sb.append("null");
            } else {
                sb.append(this.params);
            }
            first = false;
        }
        if (this.isSetFormat()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("format:");
            if (this.format == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.format);
            }
            first = false;
        }
        if (this.isSetPipelineParams()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("pipeline_params:");
            if (this.pipeline_params == null) {
                sb.append("null");
            } else {
                sb.append(this.pipeline_params);
            }
            first = false;
        }
        if (this.isSetIsMultiTable()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("is_multi_table:");
            sb.append(this.is_multi_table);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.type == null) {
            throw new TProtocolException("Required field 'type' was not present! Struct: " + this.toString());
        }
        if (this.id == null) {
            throw new TProtocolException("Required field 'id' was not present! Struct: " + this.toString());
        }
        if (this.id != null) {
            this.id.validate();
        }
        if (this.kafka_load_info != null) {
            this.kafka_load_info.validate();
        }
        if (this.params != null) {
            this.params.validate();
        }
        if (this.pipeline_params != null) {
            this.pipeline_params.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TYPE, new FieldMetaData("type", 1, (FieldValueMetaData)new EnumMetaData(16, TLoadSourceType.class)));
        tmpMap.put(_Fields.JOB_ID, new FieldMetaData("job_id", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.ID, new FieldMetaData("id", 1, (FieldValueMetaData)new StructMetaData(12, TUniqueId.class)));
        tmpMap.put(_Fields.TXN_ID, new FieldMetaData("txn_id", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.AUTH_CODE, new FieldMetaData("auth_code", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.DB, new FieldMetaData("db", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TBL, new FieldMetaData("tbl", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.LABEL, new FieldMetaData("label", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.MAX_INTERVAL_S, new FieldMetaData("max_interval_s", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.MAX_BATCH_ROWS, new FieldMetaData("max_batch_rows", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.MAX_BATCH_SIZE, new FieldMetaData("max_batch_size", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.KAFKA_LOAD_INFO, new FieldMetaData("kafka_load_info", 2, (FieldValueMetaData)new StructMetaData(12, TKafkaLoadInfo.class)));
        tmpMap.put(_Fields.PARAMS, new FieldMetaData("params", 2, (FieldValueMetaData)new StructMetaData(12, TExecPlanFragmentParams.class)));
        tmpMap.put(_Fields.FORMAT, new FieldMetaData("format", 2, (FieldValueMetaData)new EnumMetaData(16, TFileFormatType.class)));
        tmpMap.put(_Fields.PIPELINE_PARAMS, new FieldMetaData("pipeline_params", 2, (FieldValueMetaData)new StructMetaData(12, TPipelineFragmentParams.class)));
        tmpMap.put(_Fields.IS_MULTI_TABLE, new FieldMetaData("is_multi_table", 2, new FieldValueMetaData(2)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TRoutineLoadTask.class, metaDataMap);
    }

    private static class TRoutineLoadTaskTupleScheme
    extends TupleScheme<TRoutineLoadTask> {
        private TRoutineLoadTaskTupleScheme() {
        }

        public void write(TProtocol prot, TRoutineLoadTask struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.type.getValue());
            oprot.writeI64(struct.job_id);
            struct.id.write((TProtocol)oprot);
            oprot.writeI64(struct.txn_id);
            oprot.writeI64(struct.auth_code);
            BitSet optionals = new BitSet();
            if (struct.isSetDb()) {
                optionals.set(0);
            }
            if (struct.isSetTbl()) {
                optionals.set(1);
            }
            if (struct.isSetLabel()) {
                optionals.set(2);
            }
            if (struct.isSetMaxIntervalS()) {
                optionals.set(3);
            }
            if (struct.isSetMaxBatchRows()) {
                optionals.set(4);
            }
            if (struct.isSetMaxBatchSize()) {
                optionals.set(5);
            }
            if (struct.isSetKafkaLoadInfo()) {
                optionals.set(6);
            }
            if (struct.isSetParams()) {
                optionals.set(7);
            }
            if (struct.isSetFormat()) {
                optionals.set(8);
            }
            if (struct.isSetPipelineParams()) {
                optionals.set(9);
            }
            if (struct.isSetIsMultiTable()) {
                optionals.set(10);
            }
            oprot.writeBitSet(optionals, 11);
            if (struct.isSetDb()) {
                oprot.writeString(struct.db);
            }
            if (struct.isSetTbl()) {
                oprot.writeString(struct.tbl);
            }
            if (struct.isSetLabel()) {
                oprot.writeString(struct.label);
            }
            if (struct.isSetMaxIntervalS()) {
                oprot.writeI64(struct.max_interval_s);
            }
            if (struct.isSetMaxBatchRows()) {
                oprot.writeI64(struct.max_batch_rows);
            }
            if (struct.isSetMaxBatchSize()) {
                oprot.writeI64(struct.max_batch_size);
            }
            if (struct.isSetKafkaLoadInfo()) {
                struct.kafka_load_info.write((TProtocol)oprot);
            }
            if (struct.isSetParams()) {
                struct.params.write((TProtocol)oprot);
            }
            if (struct.isSetFormat()) {
                oprot.writeI32(struct.format.getValue());
            }
            if (struct.isSetPipelineParams()) {
                struct.pipeline_params.write((TProtocol)oprot);
            }
            if (struct.isSetIsMultiTable()) {
                oprot.writeBool(struct.is_multi_table);
            }
        }

        public void read(TProtocol prot, TRoutineLoadTask struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.type = TLoadSourceType.findByValue(iprot.readI32());
            struct.setTypeIsSet(true);
            struct.job_id = iprot.readI64();
            struct.setJobIdIsSet(true);
            struct.id = new TUniqueId();
            struct.id.read((TProtocol)iprot);
            struct.setIdIsSet(true);
            struct.txn_id = iprot.readI64();
            struct.setTxnIdIsSet(true);
            struct.auth_code = iprot.readI64();
            struct.setAuthCodeIsSet(true);
            BitSet incoming = iprot.readBitSet(11);
            if (incoming.get(0)) {
                struct.db = iprot.readString();
                struct.setDbIsSet(true);
            }
            if (incoming.get(1)) {
                struct.tbl = iprot.readString();
                struct.setTblIsSet(true);
            }
            if (incoming.get(2)) {
                struct.label = iprot.readString();
                struct.setLabelIsSet(true);
            }
            if (incoming.get(3)) {
                struct.max_interval_s = iprot.readI64();
                struct.setMaxIntervalSIsSet(true);
            }
            if (incoming.get(4)) {
                struct.max_batch_rows = iprot.readI64();
                struct.setMaxBatchRowsIsSet(true);
            }
            if (incoming.get(5)) {
                struct.max_batch_size = iprot.readI64();
                struct.setMaxBatchSizeIsSet(true);
            }
            if (incoming.get(6)) {
                struct.kafka_load_info = new TKafkaLoadInfo();
                struct.kafka_load_info.read((TProtocol)iprot);
                struct.setKafkaLoadInfoIsSet(true);
            }
            if (incoming.get(7)) {
                struct.params = new TExecPlanFragmentParams();
                struct.params.read((TProtocol)iprot);
                struct.setParamsIsSet(true);
            }
            if (incoming.get(8)) {
                struct.format = TFileFormatType.findByValue(iprot.readI32());
                struct.setFormatIsSet(true);
            }
            if (incoming.get(9)) {
                struct.pipeline_params = new TPipelineFragmentParams();
                struct.pipeline_params.read((TProtocol)iprot);
                struct.setPipelineParamsIsSet(true);
            }
            if (incoming.get(10)) {
                struct.is_multi_table = iprot.readBool();
                struct.setIsMultiTableIsSet(true);
            }
        }
    }

    private static class TRoutineLoadTaskTupleSchemeFactory
    implements SchemeFactory {
        private TRoutineLoadTaskTupleSchemeFactory() {
        }

        public TRoutineLoadTaskTupleScheme getScheme() {
            return new TRoutineLoadTaskTupleScheme();
        }
    }

    private static class TRoutineLoadTaskStandardScheme
    extends StandardScheme<TRoutineLoadTask> {
        private TRoutineLoadTaskStandardScheme() {
        }

        public void read(TProtocol iprot, TRoutineLoadTask struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 8) {
                            struct.type = TLoadSourceType.findByValue(iprot.readI32());
                            struct.setTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 10) {
                            struct.job_id = iprot.readI64();
                            struct.setJobIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 12) {
                            struct.id = new TUniqueId();
                            struct.id.read(iprot);
                            struct.setIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 10) {
                            struct.txn_id = iprot.readI64();
                            struct.setTxnIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 10) {
                            struct.auth_code = iprot.readI64();
                            struct.setAuthCodeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 11) {
                            struct.db = iprot.readString();
                            struct.setDbIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 11) {
                            struct.tbl = iprot.readString();
                            struct.setTblIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 11) {
                            struct.label = iprot.readString();
                            struct.setLabelIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 10) {
                            struct.max_interval_s = iprot.readI64();
                            struct.setMaxIntervalSIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 10) {
                            struct.max_batch_rows = iprot.readI64();
                            struct.setMaxBatchRowsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 10) {
                            struct.max_batch_size = iprot.readI64();
                            struct.setMaxBatchSizeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 12) {
                            struct.kafka_load_info = new TKafkaLoadInfo();
                            struct.kafka_load_info.read(iprot);
                            struct.setKafkaLoadInfoIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 13: {
                        if (schemeField.type == 12) {
                            struct.params = new TExecPlanFragmentParams();
                            struct.params.read(iprot);
                            struct.setParamsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 14: {
                        if (schemeField.type == 8) {
                            struct.format = TFileFormatType.findByValue(iprot.readI32());
                            struct.setFormatIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 15: {
                        if (schemeField.type == 12) {
                            struct.pipeline_params = new TPipelineFragmentParams();
                            struct.pipeline_params.read(iprot);
                            struct.setPipelineParamsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 16: {
                        if (schemeField.type == 2) {
                            struct.is_multi_table = iprot.readBool();
                            struct.setIsMultiTableIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetJobId()) {
                throw new TProtocolException("Required field 'job_id' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetTxnId()) {
                throw new TProtocolException("Required field 'txn_id' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetAuthCode()) {
                throw new TProtocolException("Required field 'auth_code' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            struct.validate();
        }

        public void write(TProtocol oprot, TRoutineLoadTask struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.type != null) {
                oprot.writeFieldBegin(TYPE_FIELD_DESC);
                oprot.writeI32(struct.type.getValue());
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(JOB_ID_FIELD_DESC);
            oprot.writeI64(struct.job_id);
            oprot.writeFieldEnd();
            if (struct.id != null) {
                oprot.writeFieldBegin(ID_FIELD_DESC);
                struct.id.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(TXN_ID_FIELD_DESC);
            oprot.writeI64(struct.txn_id);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(AUTH_CODE_FIELD_DESC);
            oprot.writeI64(struct.auth_code);
            oprot.writeFieldEnd();
            if (struct.db != null && struct.isSetDb()) {
                oprot.writeFieldBegin(DB_FIELD_DESC);
                oprot.writeString(struct.db);
                oprot.writeFieldEnd();
            }
            if (struct.tbl != null && struct.isSetTbl()) {
                oprot.writeFieldBegin(TBL_FIELD_DESC);
                oprot.writeString(struct.tbl);
                oprot.writeFieldEnd();
            }
            if (struct.label != null && struct.isSetLabel()) {
                oprot.writeFieldBegin(LABEL_FIELD_DESC);
                oprot.writeString(struct.label);
                oprot.writeFieldEnd();
            }
            if (struct.isSetMaxIntervalS()) {
                oprot.writeFieldBegin(MAX_INTERVAL_S_FIELD_DESC);
                oprot.writeI64(struct.max_interval_s);
                oprot.writeFieldEnd();
            }
            if (struct.isSetMaxBatchRows()) {
                oprot.writeFieldBegin(MAX_BATCH_ROWS_FIELD_DESC);
                oprot.writeI64(struct.max_batch_rows);
                oprot.writeFieldEnd();
            }
            if (struct.isSetMaxBatchSize()) {
                oprot.writeFieldBegin(MAX_BATCH_SIZE_FIELD_DESC);
                oprot.writeI64(struct.max_batch_size);
                oprot.writeFieldEnd();
            }
            if (struct.kafka_load_info != null && struct.isSetKafkaLoadInfo()) {
                oprot.writeFieldBegin(KAFKA_LOAD_INFO_FIELD_DESC);
                struct.kafka_load_info.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.params != null && struct.isSetParams()) {
                oprot.writeFieldBegin(PARAMS_FIELD_DESC);
                struct.params.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.format != null && struct.isSetFormat()) {
                oprot.writeFieldBegin(FORMAT_FIELD_DESC);
                oprot.writeI32(struct.format.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.pipeline_params != null && struct.isSetPipelineParams()) {
                oprot.writeFieldBegin(PIPELINE_PARAMS_FIELD_DESC);
                struct.pipeline_params.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.isSetIsMultiTable()) {
                oprot.writeFieldBegin(IS_MULTI_TABLE_FIELD_DESC);
                oprot.writeBool(struct.is_multi_table);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TRoutineLoadTaskStandardSchemeFactory
    implements SchemeFactory {
        private TRoutineLoadTaskStandardSchemeFactory() {
        }

        public TRoutineLoadTaskStandardScheme getScheme() {
            return new TRoutineLoadTaskStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TYPE(1, "type"),
        JOB_ID(2, "job_id"),
        ID(3, "id"),
        TXN_ID(4, "txn_id"),
        AUTH_CODE(5, "auth_code"),
        DB(6, "db"),
        TBL(7, "tbl"),
        LABEL(8, "label"),
        MAX_INTERVAL_S(9, "max_interval_s"),
        MAX_BATCH_ROWS(10, "max_batch_rows"),
        MAX_BATCH_SIZE(11, "max_batch_size"),
        KAFKA_LOAD_INFO(12, "kafka_load_info"),
        PARAMS(13, "params"),
        FORMAT(14, "format"),
        PIPELINE_PARAMS(15, "pipeline_params"),
        IS_MULTI_TABLE(16, "is_multi_table");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TYPE;
                }
                case 2: {
                    return JOB_ID;
                }
                case 3: {
                    return ID;
                }
                case 4: {
                    return TXN_ID;
                }
                case 5: {
                    return AUTH_CODE;
                }
                case 6: {
                    return DB;
                }
                case 7: {
                    return TBL;
                }
                case 8: {
                    return LABEL;
                }
                case 9: {
                    return MAX_INTERVAL_S;
                }
                case 10: {
                    return MAX_BATCH_ROWS;
                }
                case 11: {
                    return MAX_BATCH_SIZE;
                }
                case 12: {
                    return KAFKA_LOAD_INFO;
                }
                case 13: {
                    return PARAMS;
                }
                case 14: {
                    return FORMAT;
                }
                case 15: {
                    return PIPELINE_PARAMS;
                }
                case 16: {
                    return IS_MULTI_TABLE;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

