/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.doris.thrift.TTableRef;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TRestoreSnapshotRequest
implements TBase<TRestoreSnapshotRequest, _Fields>,
Serializable,
Cloneable,
Comparable<TRestoreSnapshotRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("TRestoreSnapshotRequest");
    private static final TField CLUSTER_FIELD_DESC = new TField("cluster", 11, 1);
    private static final TField USER_FIELD_DESC = new TField("user", 11, 2);
    private static final TField PASSWD_FIELD_DESC = new TField("passwd", 11, 3);
    private static final TField DB_FIELD_DESC = new TField("db", 11, 4);
    private static final TField TABLE_FIELD_DESC = new TField("table", 11, 5);
    private static final TField TOKEN_FIELD_DESC = new TField("token", 11, 6);
    private static final TField LABEL_NAME_FIELD_DESC = new TField("label_name", 11, 7);
    private static final TField REPO_NAME_FIELD_DESC = new TField("repo_name", 11, 8);
    private static final TField TABLE_REFS_FIELD_DESC = new TField("table_refs", 15, 9);
    private static final TField PROPERTIES_FIELD_DESC = new TField("properties", 13, 10);
    private static final TField META_FIELD_DESC = new TField("meta", 11, 11);
    private static final TField JOB_INFO_FIELD_DESC = new TField("job_info", 11, 12);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TRestoreSnapshotRequestStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TRestoreSnapshotRequestTupleSchemeFactory();
    @Nullable
    public String cluster;
    @Nullable
    public String user;
    @Nullable
    public String passwd;
    @Nullable
    public String db;
    @Nullable
    public String table;
    @Nullable
    public String token;
    @Nullable
    public String label_name;
    @Nullable
    public String repo_name;
    @Nullable
    public List<TTableRef> table_refs;
    @Nullable
    public Map<String, String> properties;
    @Nullable
    public ByteBuffer meta;
    @Nullable
    public ByteBuffer job_info;
    private static final _Fields[] optionals = new _Fields[]{_Fields.CLUSTER, _Fields.USER, _Fields.PASSWD, _Fields.DB, _Fields.TABLE, _Fields.TOKEN, _Fields.LABEL_NAME, _Fields.REPO_NAME, _Fields.TABLE_REFS, _Fields.PROPERTIES, _Fields.META, _Fields.JOB_INFO};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TRestoreSnapshotRequest() {
    }

    public TRestoreSnapshotRequest(TRestoreSnapshotRequest other) {
        if (other.isSetCluster()) {
            this.cluster = other.cluster;
        }
        if (other.isSetUser()) {
            this.user = other.user;
        }
        if (other.isSetPasswd()) {
            this.passwd = other.passwd;
        }
        if (other.isSetDb()) {
            this.db = other.db;
        }
        if (other.isSetTable()) {
            this.table = other.table;
        }
        if (other.isSetToken()) {
            this.token = other.token;
        }
        if (other.isSetLabelName()) {
            this.label_name = other.label_name;
        }
        if (other.isSetRepoName()) {
            this.repo_name = other.repo_name;
        }
        if (other.isSetTableRefs()) {
            ArrayList<TTableRef> __this__table_refs = new ArrayList<TTableRef>(other.table_refs.size());
            for (TTableRef other_element : other.table_refs) {
                __this__table_refs.add(new TTableRef(other_element));
            }
            this.table_refs = __this__table_refs;
        }
        if (other.isSetProperties()) {
            HashMap<String, String> __this__properties = new HashMap<String, String>(other.properties);
            this.properties = __this__properties;
        }
        if (other.isSetMeta()) {
            this.meta = TBaseHelper.copyBinary((ByteBuffer)other.meta);
        }
        if (other.isSetJobInfo()) {
            this.job_info = TBaseHelper.copyBinary((ByteBuffer)other.job_info);
        }
    }

    public TRestoreSnapshotRequest deepCopy() {
        return new TRestoreSnapshotRequest(this);
    }

    public void clear() {
        this.cluster = null;
        this.user = null;
        this.passwd = null;
        this.db = null;
        this.table = null;
        this.token = null;
        this.label_name = null;
        this.repo_name = null;
        this.table_refs = null;
        this.properties = null;
        this.meta = null;
        this.job_info = null;
    }

    @Nullable
    public String getCluster() {
        return this.cluster;
    }

    public TRestoreSnapshotRequest setCluster(@Nullable String cluster) {
        this.cluster = cluster;
        return this;
    }

    public void unsetCluster() {
        this.cluster = null;
    }

    public boolean isSetCluster() {
        return this.cluster != null;
    }

    public void setClusterIsSet(boolean value) {
        if (!value) {
            this.cluster = null;
        }
    }

    @Nullable
    public String getUser() {
        return this.user;
    }

    public TRestoreSnapshotRequest setUser(@Nullable String user) {
        this.user = user;
        return this;
    }

    public void unsetUser() {
        this.user = null;
    }

    public boolean isSetUser() {
        return this.user != null;
    }

    public void setUserIsSet(boolean value) {
        if (!value) {
            this.user = null;
        }
    }

    @Nullable
    public String getPasswd() {
        return this.passwd;
    }

    public TRestoreSnapshotRequest setPasswd(@Nullable String passwd) {
        this.passwd = passwd;
        return this;
    }

    public void unsetPasswd() {
        this.passwd = null;
    }

    public boolean isSetPasswd() {
        return this.passwd != null;
    }

    public void setPasswdIsSet(boolean value) {
        if (!value) {
            this.passwd = null;
        }
    }

    @Nullable
    public String getDb() {
        return this.db;
    }

    public TRestoreSnapshotRequest setDb(@Nullable String db) {
        this.db = db;
        return this;
    }

    public void unsetDb() {
        this.db = null;
    }

    public boolean isSetDb() {
        return this.db != null;
    }

    public void setDbIsSet(boolean value) {
        if (!value) {
            this.db = null;
        }
    }

    @Nullable
    public String getTable() {
        return this.table;
    }

    public TRestoreSnapshotRequest setTable(@Nullable String table) {
        this.table = table;
        return this;
    }

    public void unsetTable() {
        this.table = null;
    }

    public boolean isSetTable() {
        return this.table != null;
    }

    public void setTableIsSet(boolean value) {
        if (!value) {
            this.table = null;
        }
    }

    @Nullable
    public String getToken() {
        return this.token;
    }

    public TRestoreSnapshotRequest setToken(@Nullable String token) {
        this.token = token;
        return this;
    }

    public void unsetToken() {
        this.token = null;
    }

    public boolean isSetToken() {
        return this.token != null;
    }

    public void setTokenIsSet(boolean value) {
        if (!value) {
            this.token = null;
        }
    }

    @Nullable
    public String getLabelName() {
        return this.label_name;
    }

    public TRestoreSnapshotRequest setLabelName(@Nullable String label_name) {
        this.label_name = label_name;
        return this;
    }

    public void unsetLabelName() {
        this.label_name = null;
    }

    public boolean isSetLabelName() {
        return this.label_name != null;
    }

    public void setLabelNameIsSet(boolean value) {
        if (!value) {
            this.label_name = null;
        }
    }

    @Nullable
    public String getRepoName() {
        return this.repo_name;
    }

    public TRestoreSnapshotRequest setRepoName(@Nullable String repo_name) {
        this.repo_name = repo_name;
        return this;
    }

    public void unsetRepoName() {
        this.repo_name = null;
    }

    public boolean isSetRepoName() {
        return this.repo_name != null;
    }

    public void setRepoNameIsSet(boolean value) {
        if (!value) {
            this.repo_name = null;
        }
    }

    public int getTableRefsSize() {
        return this.table_refs == null ? 0 : this.table_refs.size();
    }

    @Nullable
    public Iterator<TTableRef> getTableRefsIterator() {
        return this.table_refs == null ? null : this.table_refs.iterator();
    }

    public void addToTableRefs(TTableRef elem) {
        if (this.table_refs == null) {
            this.table_refs = new ArrayList<TTableRef>();
        }
        this.table_refs.add(elem);
    }

    @Nullable
    public List<TTableRef> getTableRefs() {
        return this.table_refs;
    }

    public TRestoreSnapshotRequest setTableRefs(@Nullable List<TTableRef> table_refs) {
        this.table_refs = table_refs;
        return this;
    }

    public void unsetTableRefs() {
        this.table_refs = null;
    }

    public boolean isSetTableRefs() {
        return this.table_refs != null;
    }

    public void setTableRefsIsSet(boolean value) {
        if (!value) {
            this.table_refs = null;
        }
    }

    public int getPropertiesSize() {
        return this.properties == null ? 0 : this.properties.size();
    }

    public void putToProperties(String key, String val) {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(key, val);
    }

    @Nullable
    public Map<String, String> getProperties() {
        return this.properties;
    }

    public TRestoreSnapshotRequest setProperties(@Nullable Map<String, String> properties) {
        this.properties = properties;
        return this;
    }

    public void unsetProperties() {
        this.properties = null;
    }

    public boolean isSetProperties() {
        return this.properties != null;
    }

    public void setPropertiesIsSet(boolean value) {
        if (!value) {
            this.properties = null;
        }
    }

    public byte[] getMeta() {
        this.setMeta(TBaseHelper.rightSize((ByteBuffer)this.meta));
        return this.meta == null ? null : this.meta.array();
    }

    public ByteBuffer bufferForMeta() {
        return TBaseHelper.copyBinary((ByteBuffer)this.meta);
    }

    public TRestoreSnapshotRequest setMeta(byte[] meta) {
        this.meta = meta == null ? (ByteBuffer)null : ByteBuffer.wrap((byte[])meta.clone());
        return this;
    }

    public TRestoreSnapshotRequest setMeta(@Nullable ByteBuffer meta) {
        this.meta = TBaseHelper.copyBinary((ByteBuffer)meta);
        return this;
    }

    public void unsetMeta() {
        this.meta = null;
    }

    public boolean isSetMeta() {
        return this.meta != null;
    }

    public void setMetaIsSet(boolean value) {
        if (!value) {
            this.meta = null;
        }
    }

    public byte[] getJobInfo() {
        this.setJobInfo(TBaseHelper.rightSize((ByteBuffer)this.job_info));
        return this.job_info == null ? null : this.job_info.array();
    }

    public ByteBuffer bufferForJobInfo() {
        return TBaseHelper.copyBinary((ByteBuffer)this.job_info);
    }

    public TRestoreSnapshotRequest setJobInfo(byte[] job_info) {
        this.job_info = job_info == null ? (ByteBuffer)null : ByteBuffer.wrap((byte[])job_info.clone());
        return this;
    }

    public TRestoreSnapshotRequest setJobInfo(@Nullable ByteBuffer job_info) {
        this.job_info = TBaseHelper.copyBinary((ByteBuffer)job_info);
        return this;
    }

    public void unsetJobInfo() {
        this.job_info = null;
    }

    public boolean isSetJobInfo() {
        return this.job_info != null;
    }

    public void setJobInfoIsSet(boolean value) {
        if (!value) {
            this.job_info = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case CLUSTER: {
                if (value == null) {
                    this.unsetCluster();
                    break;
                }
                this.setCluster((String)value);
                break;
            }
            case USER: {
                if (value == null) {
                    this.unsetUser();
                    break;
                }
                this.setUser((String)value);
                break;
            }
            case PASSWD: {
                if (value == null) {
                    this.unsetPasswd();
                    break;
                }
                this.setPasswd((String)value);
                break;
            }
            case DB: {
                if (value == null) {
                    this.unsetDb();
                    break;
                }
                this.setDb((String)value);
                break;
            }
            case TABLE: {
                if (value == null) {
                    this.unsetTable();
                    break;
                }
                this.setTable((String)value);
                break;
            }
            case TOKEN: {
                if (value == null) {
                    this.unsetToken();
                    break;
                }
                this.setToken((String)value);
                break;
            }
            case LABEL_NAME: {
                if (value == null) {
                    this.unsetLabelName();
                    break;
                }
                this.setLabelName((String)value);
                break;
            }
            case REPO_NAME: {
                if (value == null) {
                    this.unsetRepoName();
                    break;
                }
                this.setRepoName((String)value);
                break;
            }
            case TABLE_REFS: {
                if (value == null) {
                    this.unsetTableRefs();
                    break;
                }
                this.setTableRefs((List)value);
                break;
            }
            case PROPERTIES: {
                if (value == null) {
                    this.unsetProperties();
                    break;
                }
                this.setProperties((Map)value);
                break;
            }
            case META: {
                if (value == null) {
                    this.unsetMeta();
                    break;
                }
                if (value instanceof byte[]) {
                    this.setMeta((byte[])value);
                    break;
                }
                this.setMeta((ByteBuffer)value);
                break;
            }
            case JOB_INFO: {
                if (value == null) {
                    this.unsetJobInfo();
                    break;
                }
                if (value instanceof byte[]) {
                    this.setJobInfo((byte[])value);
                    break;
                }
                this.setJobInfo((ByteBuffer)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case CLUSTER: {
                return this.getCluster();
            }
            case USER: {
                return this.getUser();
            }
            case PASSWD: {
                return this.getPasswd();
            }
            case DB: {
                return this.getDb();
            }
            case TABLE: {
                return this.getTable();
            }
            case TOKEN: {
                return this.getToken();
            }
            case LABEL_NAME: {
                return this.getLabelName();
            }
            case REPO_NAME: {
                return this.getRepoName();
            }
            case TABLE_REFS: {
                return this.getTableRefs();
            }
            case PROPERTIES: {
                return this.getProperties();
            }
            case META: {
                return this.getMeta();
            }
            case JOB_INFO: {
                return this.getJobInfo();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case CLUSTER: {
                return this.isSetCluster();
            }
            case USER: {
                return this.isSetUser();
            }
            case PASSWD: {
                return this.isSetPasswd();
            }
            case DB: {
                return this.isSetDb();
            }
            case TABLE: {
                return this.isSetTable();
            }
            case TOKEN: {
                return this.isSetToken();
            }
            case LABEL_NAME: {
                return this.isSetLabelName();
            }
            case REPO_NAME: {
                return this.isSetRepoName();
            }
            case TABLE_REFS: {
                return this.isSetTableRefs();
            }
            case PROPERTIES: {
                return this.isSetProperties();
            }
            case META: {
                return this.isSetMeta();
            }
            case JOB_INFO: {
                return this.isSetJobInfo();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof TRestoreSnapshotRequest) {
            return this.equals((TRestoreSnapshotRequest)that);
        }
        return false;
    }

    public boolean equals(TRestoreSnapshotRequest that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_cluster = this.isSetCluster();
        boolean that_present_cluster = that.isSetCluster();
        if (this_present_cluster || that_present_cluster) {
            if (!this_present_cluster || !that_present_cluster) {
                return false;
            }
            if (!this.cluster.equals(that.cluster)) {
                return false;
            }
        }
        boolean this_present_user = this.isSetUser();
        boolean that_present_user = that.isSetUser();
        if (this_present_user || that_present_user) {
            if (!this_present_user || !that_present_user) {
                return false;
            }
            if (!this.user.equals(that.user)) {
                return false;
            }
        }
        boolean this_present_passwd = this.isSetPasswd();
        boolean that_present_passwd = that.isSetPasswd();
        if (this_present_passwd || that_present_passwd) {
            if (!this_present_passwd || !that_present_passwd) {
                return false;
            }
            if (!this.passwd.equals(that.passwd)) {
                return false;
            }
        }
        boolean this_present_db = this.isSetDb();
        boolean that_present_db = that.isSetDb();
        if (this_present_db || that_present_db) {
            if (!this_present_db || !that_present_db) {
                return false;
            }
            if (!this.db.equals(that.db)) {
                return false;
            }
        }
        boolean this_present_table = this.isSetTable();
        boolean that_present_table = that.isSetTable();
        if (this_present_table || that_present_table) {
            if (!this_present_table || !that_present_table) {
                return false;
            }
            if (!this.table.equals(that.table)) {
                return false;
            }
        }
        boolean this_present_token = this.isSetToken();
        boolean that_present_token = that.isSetToken();
        if (this_present_token || that_present_token) {
            if (!this_present_token || !that_present_token) {
                return false;
            }
            if (!this.token.equals(that.token)) {
                return false;
            }
        }
        boolean this_present_label_name = this.isSetLabelName();
        boolean that_present_label_name = that.isSetLabelName();
        if (this_present_label_name || that_present_label_name) {
            if (!this_present_label_name || !that_present_label_name) {
                return false;
            }
            if (!this.label_name.equals(that.label_name)) {
                return false;
            }
        }
        boolean this_present_repo_name = this.isSetRepoName();
        boolean that_present_repo_name = that.isSetRepoName();
        if (this_present_repo_name || that_present_repo_name) {
            if (!this_present_repo_name || !that_present_repo_name) {
                return false;
            }
            if (!this.repo_name.equals(that.repo_name)) {
                return false;
            }
        }
        boolean this_present_table_refs = this.isSetTableRefs();
        boolean that_present_table_refs = that.isSetTableRefs();
        if (this_present_table_refs || that_present_table_refs) {
            if (!this_present_table_refs || !that_present_table_refs) {
                return false;
            }
            if (!this.table_refs.equals(that.table_refs)) {
                return false;
            }
        }
        boolean this_present_properties = this.isSetProperties();
        boolean that_present_properties = that.isSetProperties();
        if (this_present_properties || that_present_properties) {
            if (!this_present_properties || !that_present_properties) {
                return false;
            }
            if (!this.properties.equals(that.properties)) {
                return false;
            }
        }
        boolean this_present_meta = this.isSetMeta();
        boolean that_present_meta = that.isSetMeta();
        if (this_present_meta || that_present_meta) {
            if (!this_present_meta || !that_present_meta) {
                return false;
            }
            if (!this.meta.equals(that.meta)) {
                return false;
            }
        }
        boolean this_present_job_info = this.isSetJobInfo();
        boolean that_present_job_info = that.isSetJobInfo();
        if (this_present_job_info || that_present_job_info) {
            if (!this_present_job_info || !that_present_job_info) {
                return false;
            }
            if (!this.job_info.equals(that.job_info)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetCluster() ? 131071 : 524287);
        if (this.isSetCluster()) {
            hashCode = hashCode * 8191 + this.cluster.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetUser() ? 131071 : 524287);
        if (this.isSetUser()) {
            hashCode = hashCode * 8191 + this.user.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetPasswd() ? 131071 : 524287);
        if (this.isSetPasswd()) {
            hashCode = hashCode * 8191 + this.passwd.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetDb() ? 131071 : 524287);
        if (this.isSetDb()) {
            hashCode = hashCode * 8191 + this.db.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTable() ? 131071 : 524287);
        if (this.isSetTable()) {
            hashCode = hashCode * 8191 + this.table.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetToken() ? 131071 : 524287);
        if (this.isSetToken()) {
            hashCode = hashCode * 8191 + this.token.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetLabelName() ? 131071 : 524287);
        if (this.isSetLabelName()) {
            hashCode = hashCode * 8191 + this.label_name.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetRepoName() ? 131071 : 524287);
        if (this.isSetRepoName()) {
            hashCode = hashCode * 8191 + this.repo_name.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTableRefs() ? 131071 : 524287);
        if (this.isSetTableRefs()) {
            hashCode = hashCode * 8191 + this.table_refs.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetProperties() ? 131071 : 524287);
        if (this.isSetProperties()) {
            hashCode = hashCode * 8191 + this.properties.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetMeta() ? 131071 : 524287);
        if (this.isSetMeta()) {
            hashCode = hashCode * 8191 + this.meta.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetJobInfo() ? 131071 : 524287);
        if (this.isSetJobInfo()) {
            hashCode = hashCode * 8191 + this.job_info.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(TRestoreSnapshotRequest other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetCluster(), other.isSetCluster());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCluster() && (lastComparison = TBaseHelper.compareTo((String)this.cluster, (String)other.cluster)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetUser(), other.isSetUser());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetUser() && (lastComparison = TBaseHelper.compareTo((String)this.user, (String)other.user)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPasswd(), other.isSetPasswd());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPasswd() && (lastComparison = TBaseHelper.compareTo((String)this.passwd, (String)other.passwd)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetDb(), other.isSetDb());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDb() && (lastComparison = TBaseHelper.compareTo((String)this.db, (String)other.db)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTable(), other.isSetTable());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTable() && (lastComparison = TBaseHelper.compareTo((String)this.table, (String)other.table)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetToken(), other.isSetToken());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetToken() && (lastComparison = TBaseHelper.compareTo((String)this.token, (String)other.token)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetLabelName(), other.isSetLabelName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLabelName() && (lastComparison = TBaseHelper.compareTo((String)this.label_name, (String)other.label_name)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetRepoName(), other.isSetRepoName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRepoName() && (lastComparison = TBaseHelper.compareTo((String)this.repo_name, (String)other.repo_name)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTableRefs(), other.isSetTableRefs());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTableRefs() && (lastComparison = TBaseHelper.compareTo(this.table_refs, other.table_refs)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetProperties(), other.isSetProperties());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetProperties() && (lastComparison = TBaseHelper.compareTo(this.properties, other.properties)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetMeta(), other.isSetMeta());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetMeta() && (lastComparison = TBaseHelper.compareTo((Comparable)this.meta, (Comparable)other.meta)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetJobInfo(), other.isSetJobInfo());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetJobInfo() && (lastComparison = TBaseHelper.compareTo((Comparable)this.job_info, (Comparable)other.job_info)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        TRestoreSnapshotRequest.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        TRestoreSnapshotRequest.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TRestoreSnapshotRequest(");
        boolean first = true;
        if (this.isSetCluster()) {
            sb.append("cluster:");
            if (this.cluster == null) {
                sb.append("null");
            } else {
                sb.append(this.cluster);
            }
            first = false;
        }
        if (this.isSetUser()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("user:");
            if (this.user == null) {
                sb.append("null");
            } else {
                sb.append(this.user);
            }
            first = false;
        }
        if (this.isSetPasswd()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("passwd:");
            if (this.passwd == null) {
                sb.append("null");
            } else {
                sb.append(this.passwd);
            }
            first = false;
        }
        if (this.isSetDb()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("db:");
            if (this.db == null) {
                sb.append("null");
            } else {
                sb.append(this.db);
            }
            first = false;
        }
        if (this.isSetTable()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("table:");
            if (this.table == null) {
                sb.append("null");
            } else {
                sb.append(this.table);
            }
            first = false;
        }
        if (this.isSetToken()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("token:");
            if (this.token == null) {
                sb.append("null");
            } else {
                sb.append(this.token);
            }
            first = false;
        }
        if (this.isSetLabelName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("label_name:");
            if (this.label_name == null) {
                sb.append("null");
            } else {
                sb.append(this.label_name);
            }
            first = false;
        }
        if (this.isSetRepoName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("repo_name:");
            if (this.repo_name == null) {
                sb.append("null");
            } else {
                sb.append(this.repo_name);
            }
            first = false;
        }
        if (this.isSetTableRefs()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("table_refs:");
            if (this.table_refs == null) {
                sb.append("null");
            } else {
                sb.append(this.table_refs);
            }
            first = false;
        }
        if (this.isSetProperties()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("properties:");
            if (this.properties == null) {
                sb.append("null");
            } else {
                sb.append(this.properties);
            }
            first = false;
        }
        if (this.isSetMeta()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("meta:");
            if (this.meta == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString((ByteBuffer)this.meta, (StringBuilder)sb);
            }
            first = false;
        }
        if (this.isSetJobInfo()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("job_info:");
            if (this.job_info == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString((ByteBuffer)this.job_info, (StringBuilder)sb);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.CLUSTER, new FieldMetaData("cluster", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.USER, new FieldMetaData("user", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PASSWD, new FieldMetaData("passwd", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.DB, new FieldMetaData("db", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TABLE, new FieldMetaData("table", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TOKEN, new FieldMetaData("token", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.LABEL_NAME, new FieldMetaData("label_name", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.REPO_NAME, new FieldMetaData("repo_name", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.TABLE_REFS, new FieldMetaData("table_refs", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, TTableRef.class))));
        tmpMap.put(_Fields.PROPERTIES, new FieldMetaData("properties", 2, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        tmpMap.put(_Fields.META, new FieldMetaData("meta", 2, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.JOB_INFO, new FieldMetaData("job_info", 2, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TRestoreSnapshotRequest.class, metaDataMap);
    }

    private static class TRestoreSnapshotRequestTupleScheme
    extends TupleScheme<TRestoreSnapshotRequest> {
        private TRestoreSnapshotRequestTupleScheme() {
        }

        public void write(TProtocol prot, TRestoreSnapshotRequest struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetCluster()) {
                optionals.set(0);
            }
            if (struct.isSetUser()) {
                optionals.set(1);
            }
            if (struct.isSetPasswd()) {
                optionals.set(2);
            }
            if (struct.isSetDb()) {
                optionals.set(3);
            }
            if (struct.isSetTable()) {
                optionals.set(4);
            }
            if (struct.isSetToken()) {
                optionals.set(5);
            }
            if (struct.isSetLabelName()) {
                optionals.set(6);
            }
            if (struct.isSetRepoName()) {
                optionals.set(7);
            }
            if (struct.isSetTableRefs()) {
                optionals.set(8);
            }
            if (struct.isSetProperties()) {
                optionals.set(9);
            }
            if (struct.isSetMeta()) {
                optionals.set(10);
            }
            if (struct.isSetJobInfo()) {
                optionals.set(11);
            }
            oprot.writeBitSet(optionals, 12);
            if (struct.isSetCluster()) {
                oprot.writeString(struct.cluster);
            }
            if (struct.isSetUser()) {
                oprot.writeString(struct.user);
            }
            if (struct.isSetPasswd()) {
                oprot.writeString(struct.passwd);
            }
            if (struct.isSetDb()) {
                oprot.writeString(struct.db);
            }
            if (struct.isSetTable()) {
                oprot.writeString(struct.table);
            }
            if (struct.isSetToken()) {
                oprot.writeString(struct.token);
            }
            if (struct.isSetLabelName()) {
                oprot.writeString(struct.label_name);
            }
            if (struct.isSetRepoName()) {
                oprot.writeString(struct.repo_name);
            }
            if (struct.isSetTableRefs()) {
                oprot.writeI32(struct.table_refs.size());
                for (TTableRef tTableRef : struct.table_refs) {
                    tTableRef.write((TProtocol)oprot);
                }
            }
            if (struct.isSetProperties()) {
                oprot.writeI32(struct.properties.size());
                for (Map.Entry entry : struct.properties.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeString((String)entry.getValue());
                }
            }
            if (struct.isSetMeta()) {
                oprot.writeBinary(struct.meta);
            }
            if (struct.isSetJobInfo()) {
                oprot.writeBinary(struct.job_info);
            }
        }

        public void read(TProtocol prot, TRestoreSnapshotRequest struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(12);
            if (incoming.get(0)) {
                struct.cluster = iprot.readString();
                struct.setClusterIsSet(true);
            }
            if (incoming.get(1)) {
                struct.user = iprot.readString();
                struct.setUserIsSet(true);
            }
            if (incoming.get(2)) {
                struct.passwd = iprot.readString();
                struct.setPasswdIsSet(true);
            }
            if (incoming.get(3)) {
                struct.db = iprot.readString();
                struct.setDbIsSet(true);
            }
            if (incoming.get(4)) {
                struct.table = iprot.readString();
                struct.setTableIsSet(true);
            }
            if (incoming.get(5)) {
                struct.token = iprot.readString();
                struct.setTokenIsSet(true);
            }
            if (incoming.get(6)) {
                struct.label_name = iprot.readString();
                struct.setLabelNameIsSet(true);
            }
            if (incoming.get(7)) {
                struct.repo_name = iprot.readString();
                struct.setRepoNameIsSet(true);
            }
            if (incoming.get(8)) {
                TList _list501 = iprot.readListBegin((byte)12);
                struct.table_refs = new ArrayList<TTableRef>(_list501.size);
                for (int _i503 = 0; _i503 < _list501.size; ++_i503) {
                    TTableRef _elem502 = new TTableRef();
                    _elem502.read((TProtocol)iprot);
                    struct.table_refs.add(_elem502);
                }
                struct.setTableRefsIsSet(true);
            }
            if (incoming.get(9)) {
                TMap _map504 = iprot.readMapBegin((byte)11, (byte)11);
                struct.properties = new HashMap<String, String>(2 * _map504.size);
                for (int _i507 = 0; _i507 < _map504.size; ++_i507) {
                    String _key505 = iprot.readString();
                    String _val506 = iprot.readString();
                    struct.properties.put(_key505, _val506);
                }
                struct.setPropertiesIsSet(true);
            }
            if (incoming.get(10)) {
                struct.meta = iprot.readBinary();
                struct.setMetaIsSet(true);
            }
            if (incoming.get(11)) {
                struct.job_info = iprot.readBinary();
                struct.setJobInfoIsSet(true);
            }
        }
    }

    private static class TRestoreSnapshotRequestTupleSchemeFactory
    implements SchemeFactory {
        private TRestoreSnapshotRequestTupleSchemeFactory() {
        }

        public TRestoreSnapshotRequestTupleScheme getScheme() {
            return new TRestoreSnapshotRequestTupleScheme();
        }
    }

    private static class TRestoreSnapshotRequestStandardScheme
    extends StandardScheme<TRestoreSnapshotRequest> {
        private TRestoreSnapshotRequestStandardScheme() {
        }

        public void read(TProtocol iprot, TRestoreSnapshotRequest struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 11) {
                            struct.cluster = iprot.readString();
                            struct.setClusterIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.user = iprot.readString();
                            struct.setUserIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.passwd = iprot.readString();
                            struct.setPasswdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 11) {
                            struct.db = iprot.readString();
                            struct.setDbIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 11) {
                            struct.table = iprot.readString();
                            struct.setTableIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 11) {
                            struct.token = iprot.readString();
                            struct.setTokenIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 11) {
                            struct.label_name = iprot.readString();
                            struct.setLabelNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 11) {
                            struct.repo_name = iprot.readString();
                            struct.setRepoNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 15) {
                            TList _list490 = iprot.readListBegin();
                            struct.table_refs = new ArrayList<TTableRef>(_list490.size);
                            for (int _i492 = 0; _i492 < _list490.size; ++_i492) {
                                TTableRef _elem491 = new TTableRef();
                                _elem491.read(iprot);
                                struct.table_refs.add(_elem491);
                            }
                            iprot.readListEnd();
                            struct.setTableRefsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 13) {
                            TMap _map493 = iprot.readMapBegin();
                            struct.properties = new HashMap<String, String>(2 * _map493.size);
                            for (int _i496 = 0; _i496 < _map493.size; ++_i496) {
                                String _key494 = iprot.readString();
                                String _val495 = iprot.readString();
                                struct.properties.put(_key494, _val495);
                            }
                            iprot.readMapEnd();
                            struct.setPropertiesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 11) {
                            struct.meta = iprot.readBinary();
                            struct.setMetaIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 11) {
                            struct.job_info = iprot.readBinary();
                            struct.setJobInfoIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TRestoreSnapshotRequest struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.cluster != null && struct.isSetCluster()) {
                oprot.writeFieldBegin(CLUSTER_FIELD_DESC);
                oprot.writeString(struct.cluster);
                oprot.writeFieldEnd();
            }
            if (struct.user != null && struct.isSetUser()) {
                oprot.writeFieldBegin(USER_FIELD_DESC);
                oprot.writeString(struct.user);
                oprot.writeFieldEnd();
            }
            if (struct.passwd != null && struct.isSetPasswd()) {
                oprot.writeFieldBegin(PASSWD_FIELD_DESC);
                oprot.writeString(struct.passwd);
                oprot.writeFieldEnd();
            }
            if (struct.db != null && struct.isSetDb()) {
                oprot.writeFieldBegin(DB_FIELD_DESC);
                oprot.writeString(struct.db);
                oprot.writeFieldEnd();
            }
            if (struct.table != null && struct.isSetTable()) {
                oprot.writeFieldBegin(TABLE_FIELD_DESC);
                oprot.writeString(struct.table);
                oprot.writeFieldEnd();
            }
            if (struct.token != null && struct.isSetToken()) {
                oprot.writeFieldBegin(TOKEN_FIELD_DESC);
                oprot.writeString(struct.token);
                oprot.writeFieldEnd();
            }
            if (struct.label_name != null && struct.isSetLabelName()) {
                oprot.writeFieldBegin(LABEL_NAME_FIELD_DESC);
                oprot.writeString(struct.label_name);
                oprot.writeFieldEnd();
            }
            if (struct.repo_name != null && struct.isSetRepoName()) {
                oprot.writeFieldBegin(REPO_NAME_FIELD_DESC);
                oprot.writeString(struct.repo_name);
                oprot.writeFieldEnd();
            }
            if (struct.table_refs != null && struct.isSetTableRefs()) {
                oprot.writeFieldBegin(TABLE_REFS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.table_refs.size()));
                for (TTableRef tTableRef : struct.table_refs) {
                    tTableRef.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.properties != null && struct.isSetProperties()) {
                oprot.writeFieldBegin(PROPERTIES_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 11, struct.properties.size()));
                for (Map.Entry entry : struct.properties.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeString((String)entry.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.meta != null && struct.isSetMeta()) {
                oprot.writeFieldBegin(META_FIELD_DESC);
                oprot.writeBinary(struct.meta);
                oprot.writeFieldEnd();
            }
            if (struct.job_info != null && struct.isSetJobInfo()) {
                oprot.writeFieldBegin(JOB_INFO_FIELD_DESC);
                oprot.writeBinary(struct.job_info);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TRestoreSnapshotRequestStandardSchemeFactory
    implements SchemeFactory {
        private TRestoreSnapshotRequestStandardSchemeFactory() {
        }

        public TRestoreSnapshotRequestStandardScheme getScheme() {
            return new TRestoreSnapshotRequestStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        CLUSTER(1, "cluster"),
        USER(2, "user"),
        PASSWD(3, "passwd"),
        DB(4, "db"),
        TABLE(5, "table"),
        TOKEN(6, "token"),
        LABEL_NAME(7, "label_name"),
        REPO_NAME(8, "repo_name"),
        TABLE_REFS(9, "table_refs"),
        PROPERTIES(10, "properties"),
        META(11, "meta"),
        JOB_INFO(12, "job_info");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return CLUSTER;
                }
                case 2: {
                    return USER;
                }
                case 3: {
                    return PASSWD;
                }
                case 4: {
                    return DB;
                }
                case 5: {
                    return TABLE;
                }
                case 6: {
                    return TOKEN;
                }
                case 7: {
                    return LABEL_NAME;
                }
                case 8: {
                    return REPO_NAME;
                }
                case 9: {
                    return TABLE_REFS;
                }
                case 10: {
                    return PROPERTIES;
                }
                case 11: {
                    return META;
                }
                case 12: {
                    return JOB_INFO;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

