/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.thrift;

import org.apache.thrift.TEnum;
import org.apache.thrift.annotation.Nullable;

public enum TResourceType implements TEnum
{
    TRESOURCE_CPU_SHARE(0),
    TRESOURCE_IO_SHARE(1),
    TRESOURCE_SSD_READ_IOPS(2),
    TRESOURCE_SSD_WRITE_IOPS(3),
    TRESOURCE_SSD_READ_MBPS(4),
    TRESOURCE_SSD_WRITE_MBPS(5),
    TRESOURCE_HDD_READ_IOPS(6),
    TRESOURCE_HDD_WRITE_IOPS(7),
    TRESOURCE_HDD_READ_MBPS(8),
    TRESOURCE_HDD_WRITE_MBPS(9);

    private final int value;

    private TResourceType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    @Nullable
    public static TResourceType findByValue(int value) {
        switch (value) {
            case 0: {
                return TRESOURCE_CPU_SHARE;
            }
            case 1: {
                return TRESOURCE_IO_SHARE;
            }
            case 2: {
                return TRESOURCE_SSD_READ_IOPS;
            }
            case 3: {
                return TRESOURCE_SSD_WRITE_IOPS;
            }
            case 4: {
                return TRESOURCE_SSD_READ_MBPS;
            }
            case 5: {
                return TRESOURCE_SSD_WRITE_MBPS;
            }
            case 6: {
                return TRESOURCE_HDD_READ_IOPS;
            }
            case 7: {
                return TRESOURCE_HDD_WRITE_IOPS;
            }
            case 8: {
                return TRESOURCE_HDD_READ_MBPS;
            }
            case 9: {
                return TRESOURCE_HDD_WRITE_MBPS;
            }
        }
        return null;
    }
}

