/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.doris.thrift.TDescriptorTable;
import org.apache.doris.thrift.TPlanFragment;
import org.apache.doris.thrift.TQueryGlobals;
import org.apache.doris.thrift.TResultSetMetadata;
import org.apache.doris.thrift.TScanRangeLocations;
import org.apache.doris.thrift.TStmtType;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TQueryExecRequest
implements TBase<TQueryExecRequest, _Fields>,
Serializable,
Cloneable,
Comparable<TQueryExecRequest> {
    private static final TStruct STRUCT_DESC = new TStruct("TQueryExecRequest");
    private static final TField DESC_TBL_FIELD_DESC = new TField("desc_tbl", 12, 1);
    private static final TField FRAGMENTS_FIELD_DESC = new TField("fragments", 15, 2);
    private static final TField DEST_FRAGMENT_IDX_FIELD_DESC = new TField("dest_fragment_idx", 15, 3);
    private static final TField PER_NODE_SCAN_RANGES_FIELD_DESC = new TField("per_node_scan_ranges", 13, 4);
    private static final TField RESULT_SET_METADATA_FIELD_DESC = new TField("result_set_metadata", 12, 5);
    private static final TField QUERY_GLOBALS_FIELD_DESC = new TField("query_globals", 12, 7);
    private static final TField STMT_TYPE_FIELD_DESC = new TField("stmt_type", 8, 9);
    private static final TField IS_BLOCK_QUERY_FIELD_DESC = new TField("is_block_query", 2, 10);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TQueryExecRequestStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TQueryExecRequestTupleSchemeFactory();
    @Nullable
    public TDescriptorTable desc_tbl;
    @Nullable
    public List<TPlanFragment> fragments;
    @Nullable
    public List<Integer> dest_fragment_idx;
    @Nullable
    public Map<Integer, List<TScanRangeLocations>> per_node_scan_ranges;
    @Nullable
    public TResultSetMetadata result_set_metadata;
    @Nullable
    public TQueryGlobals query_globals;
    @Nullable
    public TStmtType stmt_type;
    public boolean is_block_query;
    private static final int __IS_BLOCK_QUERY_ISSET_ID = 0;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.DESC_TBL, _Fields.DEST_FRAGMENT_IDX, _Fields.PER_NODE_SCAN_RANGES, _Fields.RESULT_SET_METADATA, _Fields.IS_BLOCK_QUERY};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TQueryExecRequest() {
    }

    public TQueryExecRequest(List<TPlanFragment> fragments, TQueryGlobals query_globals, TStmtType stmt_type) {
        this();
        this.fragments = fragments;
        this.query_globals = query_globals;
        this.stmt_type = stmt_type;
    }

    public TQueryExecRequest(TQueryExecRequest other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetDescTbl()) {
            this.desc_tbl = new TDescriptorTable(other.desc_tbl);
        }
        if (other.isSetFragments()) {
            ArrayList<TPlanFragment> __this__fragments = new ArrayList<TPlanFragment>(other.fragments.size());
            for (TPlanFragment tPlanFragment : other.fragments) {
                __this__fragments.add(new TPlanFragment(tPlanFragment));
            }
            this.fragments = __this__fragments;
        }
        if (other.isSetDestFragmentIdx()) {
            ArrayList<Integer> __this__dest_fragment_idx = new ArrayList<Integer>(other.dest_fragment_idx);
            this.dest_fragment_idx = __this__dest_fragment_idx;
        }
        if (other.isSetPerNodeScanRanges()) {
            HashMap<Integer, List<TScanRangeLocations>> __this__per_node_scan_ranges = new HashMap<Integer, List<TScanRangeLocations>>(other.per_node_scan_ranges.size());
            for (Map.Entry entry : other.per_node_scan_ranges.entrySet()) {
                Integer other_element_key = (Integer)entry.getKey();
                List other_element_value = (List)entry.getValue();
                Integer __this__per_node_scan_ranges_copy_key = other_element_key;
                ArrayList<TScanRangeLocations> __this__per_node_scan_ranges_copy_value = new ArrayList<TScanRangeLocations>(other_element_value.size());
                for (TScanRangeLocations other_element_value_element : other_element_value) {
                    __this__per_node_scan_ranges_copy_value.add(new TScanRangeLocations(other_element_value_element));
                }
                __this__per_node_scan_ranges.put(__this__per_node_scan_ranges_copy_key, __this__per_node_scan_ranges_copy_value);
            }
            this.per_node_scan_ranges = __this__per_node_scan_ranges;
        }
        if (other.isSetResultSetMetadata()) {
            this.result_set_metadata = new TResultSetMetadata(other.result_set_metadata);
        }
        if (other.isSetQueryGlobals()) {
            this.query_globals = new TQueryGlobals(other.query_globals);
        }
        if (other.isSetStmtType()) {
            this.stmt_type = other.stmt_type;
        }
        this.is_block_query = other.is_block_query;
    }

    public TQueryExecRequest deepCopy() {
        return new TQueryExecRequest(this);
    }

    public void clear() {
        this.desc_tbl = null;
        this.fragments = null;
        this.dest_fragment_idx = null;
        this.per_node_scan_ranges = null;
        this.result_set_metadata = null;
        this.query_globals = null;
        this.stmt_type = null;
        this.setIsBlockQueryIsSet(false);
        this.is_block_query = false;
    }

    @Nullable
    public TDescriptorTable getDescTbl() {
        return this.desc_tbl;
    }

    public TQueryExecRequest setDescTbl(@Nullable TDescriptorTable desc_tbl) {
        this.desc_tbl = desc_tbl;
        return this;
    }

    public void unsetDescTbl() {
        this.desc_tbl = null;
    }

    public boolean isSetDescTbl() {
        return this.desc_tbl != null;
    }

    public void setDescTblIsSet(boolean value) {
        if (!value) {
            this.desc_tbl = null;
        }
    }

    public int getFragmentsSize() {
        return this.fragments == null ? 0 : this.fragments.size();
    }

    @Nullable
    public Iterator<TPlanFragment> getFragmentsIterator() {
        return this.fragments == null ? null : this.fragments.iterator();
    }

    public void addToFragments(TPlanFragment elem) {
        if (this.fragments == null) {
            this.fragments = new ArrayList<TPlanFragment>();
        }
        this.fragments.add(elem);
    }

    @Nullable
    public List<TPlanFragment> getFragments() {
        return this.fragments;
    }

    public TQueryExecRequest setFragments(@Nullable List<TPlanFragment> fragments) {
        this.fragments = fragments;
        return this;
    }

    public void unsetFragments() {
        this.fragments = null;
    }

    public boolean isSetFragments() {
        return this.fragments != null;
    }

    public void setFragmentsIsSet(boolean value) {
        if (!value) {
            this.fragments = null;
        }
    }

    public int getDestFragmentIdxSize() {
        return this.dest_fragment_idx == null ? 0 : this.dest_fragment_idx.size();
    }

    @Nullable
    public Iterator<Integer> getDestFragmentIdxIterator() {
        return this.dest_fragment_idx == null ? null : this.dest_fragment_idx.iterator();
    }

    public void addToDestFragmentIdx(int elem) {
        if (this.dest_fragment_idx == null) {
            this.dest_fragment_idx = new ArrayList<Integer>();
        }
        this.dest_fragment_idx.add(elem);
    }

    @Nullable
    public List<Integer> getDestFragmentIdx() {
        return this.dest_fragment_idx;
    }

    public TQueryExecRequest setDestFragmentIdx(@Nullable List<Integer> dest_fragment_idx) {
        this.dest_fragment_idx = dest_fragment_idx;
        return this;
    }

    public void unsetDestFragmentIdx() {
        this.dest_fragment_idx = null;
    }

    public boolean isSetDestFragmentIdx() {
        return this.dest_fragment_idx != null;
    }

    public void setDestFragmentIdxIsSet(boolean value) {
        if (!value) {
            this.dest_fragment_idx = null;
        }
    }

    public int getPerNodeScanRangesSize() {
        return this.per_node_scan_ranges == null ? 0 : this.per_node_scan_ranges.size();
    }

    public void putToPerNodeScanRanges(int key, List<TScanRangeLocations> val) {
        if (this.per_node_scan_ranges == null) {
            this.per_node_scan_ranges = new HashMap<Integer, List<TScanRangeLocations>>();
        }
        this.per_node_scan_ranges.put(key, val);
    }

    @Nullable
    public Map<Integer, List<TScanRangeLocations>> getPerNodeScanRanges() {
        return this.per_node_scan_ranges;
    }

    public TQueryExecRequest setPerNodeScanRanges(@Nullable Map<Integer, List<TScanRangeLocations>> per_node_scan_ranges) {
        this.per_node_scan_ranges = per_node_scan_ranges;
        return this;
    }

    public void unsetPerNodeScanRanges() {
        this.per_node_scan_ranges = null;
    }

    public boolean isSetPerNodeScanRanges() {
        return this.per_node_scan_ranges != null;
    }

    public void setPerNodeScanRangesIsSet(boolean value) {
        if (!value) {
            this.per_node_scan_ranges = null;
        }
    }

    @Nullable
    public TResultSetMetadata getResultSetMetadata() {
        return this.result_set_metadata;
    }

    public TQueryExecRequest setResultSetMetadata(@Nullable TResultSetMetadata result_set_metadata) {
        this.result_set_metadata = result_set_metadata;
        return this;
    }

    public void unsetResultSetMetadata() {
        this.result_set_metadata = null;
    }

    public boolean isSetResultSetMetadata() {
        return this.result_set_metadata != null;
    }

    public void setResultSetMetadataIsSet(boolean value) {
        if (!value) {
            this.result_set_metadata = null;
        }
    }

    @Nullable
    public TQueryGlobals getQueryGlobals() {
        return this.query_globals;
    }

    public TQueryExecRequest setQueryGlobals(@Nullable TQueryGlobals query_globals) {
        this.query_globals = query_globals;
        return this;
    }

    public void unsetQueryGlobals() {
        this.query_globals = null;
    }

    public boolean isSetQueryGlobals() {
        return this.query_globals != null;
    }

    public void setQueryGlobalsIsSet(boolean value) {
        if (!value) {
            this.query_globals = null;
        }
    }

    @Nullable
    public TStmtType getStmtType() {
        return this.stmt_type;
    }

    public TQueryExecRequest setStmtType(@Nullable TStmtType stmt_type) {
        this.stmt_type = stmt_type;
        return this;
    }

    public void unsetStmtType() {
        this.stmt_type = null;
    }

    public boolean isSetStmtType() {
        return this.stmt_type != null;
    }

    public void setStmtTypeIsSet(boolean value) {
        if (!value) {
            this.stmt_type = null;
        }
    }

    public boolean isIsBlockQuery() {
        return this.is_block_query;
    }

    public TQueryExecRequest setIsBlockQuery(boolean is_block_query) {
        this.is_block_query = is_block_query;
        this.setIsBlockQueryIsSet(true);
        return this;
    }

    public void unsetIsBlockQuery() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetIsBlockQuery() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setIsBlockQueryIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case DESC_TBL: {
                if (value == null) {
                    this.unsetDescTbl();
                    break;
                }
                this.setDescTbl((TDescriptorTable)value);
                break;
            }
            case FRAGMENTS: {
                if (value == null) {
                    this.unsetFragments();
                    break;
                }
                this.setFragments((List)value);
                break;
            }
            case DEST_FRAGMENT_IDX: {
                if (value == null) {
                    this.unsetDestFragmentIdx();
                    break;
                }
                this.setDestFragmentIdx((List)value);
                break;
            }
            case PER_NODE_SCAN_RANGES: {
                if (value == null) {
                    this.unsetPerNodeScanRanges();
                    break;
                }
                this.setPerNodeScanRanges((Map)value);
                break;
            }
            case RESULT_SET_METADATA: {
                if (value == null) {
                    this.unsetResultSetMetadata();
                    break;
                }
                this.setResultSetMetadata((TResultSetMetadata)value);
                break;
            }
            case QUERY_GLOBALS: {
                if (value == null) {
                    this.unsetQueryGlobals();
                    break;
                }
                this.setQueryGlobals((TQueryGlobals)value);
                break;
            }
            case STMT_TYPE: {
                if (value == null) {
                    this.unsetStmtType();
                    break;
                }
                this.setStmtType((TStmtType)((Object)value));
                break;
            }
            case IS_BLOCK_QUERY: {
                if (value == null) {
                    this.unsetIsBlockQuery();
                    break;
                }
                this.setIsBlockQuery((Boolean)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case DESC_TBL: {
                return this.getDescTbl();
            }
            case FRAGMENTS: {
                return this.getFragments();
            }
            case DEST_FRAGMENT_IDX: {
                return this.getDestFragmentIdx();
            }
            case PER_NODE_SCAN_RANGES: {
                return this.getPerNodeScanRanges();
            }
            case RESULT_SET_METADATA: {
                return this.getResultSetMetadata();
            }
            case QUERY_GLOBALS: {
                return this.getQueryGlobals();
            }
            case STMT_TYPE: {
                return this.getStmtType();
            }
            case IS_BLOCK_QUERY: {
                return this.isIsBlockQuery();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case DESC_TBL: {
                return this.isSetDescTbl();
            }
            case FRAGMENTS: {
                return this.isSetFragments();
            }
            case DEST_FRAGMENT_IDX: {
                return this.isSetDestFragmentIdx();
            }
            case PER_NODE_SCAN_RANGES: {
                return this.isSetPerNodeScanRanges();
            }
            case RESULT_SET_METADATA: {
                return this.isSetResultSetMetadata();
            }
            case QUERY_GLOBALS: {
                return this.isSetQueryGlobals();
            }
            case STMT_TYPE: {
                return this.isSetStmtType();
            }
            case IS_BLOCK_QUERY: {
                return this.isSetIsBlockQuery();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof TQueryExecRequest) {
            return this.equals((TQueryExecRequest)that);
        }
        return false;
    }

    public boolean equals(TQueryExecRequest that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_desc_tbl = this.isSetDescTbl();
        boolean that_present_desc_tbl = that.isSetDescTbl();
        if (this_present_desc_tbl || that_present_desc_tbl) {
            if (!this_present_desc_tbl || !that_present_desc_tbl) {
                return false;
            }
            if (!this.desc_tbl.equals(that.desc_tbl)) {
                return false;
            }
        }
        boolean this_present_fragments = this.isSetFragments();
        boolean that_present_fragments = that.isSetFragments();
        if (this_present_fragments || that_present_fragments) {
            if (!this_present_fragments || !that_present_fragments) {
                return false;
            }
            if (!this.fragments.equals(that.fragments)) {
                return false;
            }
        }
        boolean this_present_dest_fragment_idx = this.isSetDestFragmentIdx();
        boolean that_present_dest_fragment_idx = that.isSetDestFragmentIdx();
        if (this_present_dest_fragment_idx || that_present_dest_fragment_idx) {
            if (!this_present_dest_fragment_idx || !that_present_dest_fragment_idx) {
                return false;
            }
            if (!this.dest_fragment_idx.equals(that.dest_fragment_idx)) {
                return false;
            }
        }
        boolean this_present_per_node_scan_ranges = this.isSetPerNodeScanRanges();
        boolean that_present_per_node_scan_ranges = that.isSetPerNodeScanRanges();
        if (this_present_per_node_scan_ranges || that_present_per_node_scan_ranges) {
            if (!this_present_per_node_scan_ranges || !that_present_per_node_scan_ranges) {
                return false;
            }
            if (!this.per_node_scan_ranges.equals(that.per_node_scan_ranges)) {
                return false;
            }
        }
        boolean this_present_result_set_metadata = this.isSetResultSetMetadata();
        boolean that_present_result_set_metadata = that.isSetResultSetMetadata();
        if (this_present_result_set_metadata || that_present_result_set_metadata) {
            if (!this_present_result_set_metadata || !that_present_result_set_metadata) {
                return false;
            }
            if (!this.result_set_metadata.equals(that.result_set_metadata)) {
                return false;
            }
        }
        boolean this_present_query_globals = this.isSetQueryGlobals();
        boolean that_present_query_globals = that.isSetQueryGlobals();
        if (this_present_query_globals || that_present_query_globals) {
            if (!this_present_query_globals || !that_present_query_globals) {
                return false;
            }
            if (!this.query_globals.equals(that.query_globals)) {
                return false;
            }
        }
        boolean this_present_stmt_type = this.isSetStmtType();
        boolean that_present_stmt_type = that.isSetStmtType();
        if (this_present_stmt_type || that_present_stmt_type) {
            if (!this_present_stmt_type || !that_present_stmt_type) {
                return false;
            }
            if (!this.stmt_type.equals((Object)that.stmt_type)) {
                return false;
            }
        }
        boolean this_present_is_block_query = this.isSetIsBlockQuery();
        boolean that_present_is_block_query = that.isSetIsBlockQuery();
        if (this_present_is_block_query || that_present_is_block_query) {
            if (!this_present_is_block_query || !that_present_is_block_query) {
                return false;
            }
            if (this.is_block_query != that.is_block_query) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetDescTbl() ? 131071 : 524287);
        if (this.isSetDescTbl()) {
            hashCode = hashCode * 8191 + this.desc_tbl.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetFragments() ? 131071 : 524287);
        if (this.isSetFragments()) {
            hashCode = hashCode * 8191 + this.fragments.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetDestFragmentIdx() ? 131071 : 524287);
        if (this.isSetDestFragmentIdx()) {
            hashCode = hashCode * 8191 + this.dest_fragment_idx.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetPerNodeScanRanges() ? 131071 : 524287);
        if (this.isSetPerNodeScanRanges()) {
            hashCode = hashCode * 8191 + this.per_node_scan_ranges.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetResultSetMetadata() ? 131071 : 524287);
        if (this.isSetResultSetMetadata()) {
            hashCode = hashCode * 8191 + this.result_set_metadata.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetQueryGlobals() ? 131071 : 524287);
        if (this.isSetQueryGlobals()) {
            hashCode = hashCode * 8191 + this.query_globals.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetStmtType() ? 131071 : 524287);
        if (this.isSetStmtType()) {
            hashCode = hashCode * 8191 + this.stmt_type.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetIsBlockQuery() ? 131071 : 524287);
        if (this.isSetIsBlockQuery()) {
            hashCode = hashCode * 8191 + (this.is_block_query ? 131071 : 524287);
        }
        return hashCode;
    }

    @Override
    public int compareTo(TQueryExecRequest other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetDescTbl(), other.isSetDescTbl());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDescTbl() && (lastComparison = TBaseHelper.compareTo((Comparable)this.desc_tbl, (Comparable)other.desc_tbl)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetFragments(), other.isSetFragments());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFragments() && (lastComparison = TBaseHelper.compareTo(this.fragments, other.fragments)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetDestFragmentIdx(), other.isSetDestFragmentIdx());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDestFragmentIdx() && (lastComparison = TBaseHelper.compareTo(this.dest_fragment_idx, other.dest_fragment_idx)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPerNodeScanRanges(), other.isSetPerNodeScanRanges());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPerNodeScanRanges() && (lastComparison = TBaseHelper.compareTo(this.per_node_scan_ranges, other.per_node_scan_ranges)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetResultSetMetadata(), other.isSetResultSetMetadata());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetResultSetMetadata() && (lastComparison = TBaseHelper.compareTo((Comparable)this.result_set_metadata, (Comparable)other.result_set_metadata)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetQueryGlobals(), other.isSetQueryGlobals());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetQueryGlobals() && (lastComparison = TBaseHelper.compareTo((Comparable)this.query_globals, (Comparable)other.query_globals)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetStmtType(), other.isSetStmtType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetStmtType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.stmt_type), (Comparable)((Object)other.stmt_type))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetIsBlockQuery(), other.isSetIsBlockQuery());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIsBlockQuery() && (lastComparison = TBaseHelper.compareTo((boolean)this.is_block_query, (boolean)other.is_block_query)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        TQueryExecRequest.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        TQueryExecRequest.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TQueryExecRequest(");
        boolean first = true;
        if (this.isSetDescTbl()) {
            sb.append("desc_tbl:");
            if (this.desc_tbl == null) {
                sb.append("null");
            } else {
                sb.append(this.desc_tbl);
            }
            first = false;
        }
        if (!first) {
            sb.append(", ");
        }
        sb.append("fragments:");
        if (this.fragments == null) {
            sb.append("null");
        } else {
            sb.append(this.fragments);
        }
        first = false;
        if (this.isSetDestFragmentIdx()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("dest_fragment_idx:");
            if (this.dest_fragment_idx == null) {
                sb.append("null");
            } else {
                sb.append(this.dest_fragment_idx);
            }
            first = false;
        }
        if (this.isSetPerNodeScanRanges()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("per_node_scan_ranges:");
            if (this.per_node_scan_ranges == null) {
                sb.append("null");
            } else {
                sb.append(this.per_node_scan_ranges);
            }
            first = false;
        }
        if (this.isSetResultSetMetadata()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("result_set_metadata:");
            if (this.result_set_metadata == null) {
                sb.append("null");
            } else {
                sb.append(this.result_set_metadata);
            }
            first = false;
        }
        if (!first) {
            sb.append(", ");
        }
        sb.append("query_globals:");
        if (this.query_globals == null) {
            sb.append("null");
        } else {
            sb.append(this.query_globals);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("stmt_type:");
        if (this.stmt_type == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.stmt_type);
        }
        first = false;
        if (this.isSetIsBlockQuery()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("is_block_query:");
            sb.append(this.is_block_query);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.fragments == null) {
            throw new TProtocolException("Required field 'fragments' was not present! Struct: " + this.toString());
        }
        if (this.query_globals == null) {
            throw new TProtocolException("Required field 'query_globals' was not present! Struct: " + this.toString());
        }
        if (this.stmt_type == null) {
            throw new TProtocolException("Required field 'stmt_type' was not present! Struct: " + this.toString());
        }
        if (this.desc_tbl != null) {
            this.desc_tbl.validate();
        }
        if (this.result_set_metadata != null) {
            this.result_set_metadata.validate();
        }
        if (this.query_globals != null) {
            this.query_globals.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.DESC_TBL, new FieldMetaData("desc_tbl", 2, (FieldValueMetaData)new StructMetaData(12, TDescriptorTable.class)));
        tmpMap.put(_Fields.FRAGMENTS, new FieldMetaData("fragments", 1, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, TPlanFragment.class))));
        tmpMap.put(_Fields.DEST_FRAGMENT_IDX, new FieldMetaData("dest_fragment_idx", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(8))));
        tmpMap.put(_Fields.PER_NODE_SCAN_RANGES, new FieldMetaData("per_node_scan_ranges", 2, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(8, "TPlanNodeId"), (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, TScanRangeLocations.class)))));
        tmpMap.put(_Fields.RESULT_SET_METADATA, new FieldMetaData("result_set_metadata", 2, (FieldValueMetaData)new StructMetaData(12, TResultSetMetadata.class)));
        tmpMap.put(_Fields.QUERY_GLOBALS, new FieldMetaData("query_globals", 1, (FieldValueMetaData)new StructMetaData(12, TQueryGlobals.class)));
        tmpMap.put(_Fields.STMT_TYPE, new FieldMetaData("stmt_type", 1, (FieldValueMetaData)new EnumMetaData(16, TStmtType.class)));
        tmpMap.put(_Fields.IS_BLOCK_QUERY, new FieldMetaData("is_block_query", 2, new FieldValueMetaData(2)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TQueryExecRequest.class, metaDataMap);
    }

    private static class TQueryExecRequestTupleScheme
    extends TupleScheme<TQueryExecRequest> {
        private TQueryExecRequestTupleScheme() {
        }

        public void write(TProtocol prot, TQueryExecRequest struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.fragments.size());
            for (TPlanFragment _iter83 : struct.fragments) {
                _iter83.write((TProtocol)oprot);
            }
            struct.query_globals.write((TProtocol)oprot);
            oprot.writeI32(struct.stmt_type.getValue());
            BitSet optionals = new BitSet();
            if (struct.isSetDescTbl()) {
                optionals.set(0);
            }
            if (struct.isSetDestFragmentIdx()) {
                optionals.set(1);
            }
            if (struct.isSetPerNodeScanRanges()) {
                optionals.set(2);
            }
            if (struct.isSetResultSetMetadata()) {
                optionals.set(3);
            }
            if (struct.isSetIsBlockQuery()) {
                optionals.set(4);
            }
            oprot.writeBitSet(optionals, 5);
            if (struct.isSetDescTbl()) {
                struct.desc_tbl.write((TProtocol)oprot);
            }
            if (struct.isSetDestFragmentIdx()) {
                oprot.writeI32(struct.dest_fragment_idx.size());
                Iterator<Object> iterator = struct.dest_fragment_idx.iterator();
                while (iterator.hasNext()) {
                    int n = iterator.next();
                    oprot.writeI32(n);
                }
            }
            if (struct.isSetPerNodeScanRanges()) {
                oprot.writeI32(struct.per_node_scan_ranges.size());
                for (Map.Entry entry : struct.per_node_scan_ranges.entrySet()) {
                    oprot.writeI32(((Integer)entry.getKey()).intValue());
                    oprot.writeI32(((List)entry.getValue()).size());
                    for (TScanRangeLocations _iter86 : (List)entry.getValue()) {
                        _iter86.write((TProtocol)oprot);
                    }
                }
            }
            if (struct.isSetResultSetMetadata()) {
                struct.result_set_metadata.write((TProtocol)oprot);
            }
            if (struct.isSetIsBlockQuery()) {
                oprot.writeBool(struct.is_block_query);
            }
        }

        public void read(TProtocol prot, TQueryExecRequest struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            TList _list87 = iprot.readListBegin((byte)12);
            struct.fragments = new ArrayList<TPlanFragment>(_list87.size);
            for (int _i89 = 0; _i89 < _list87.size; ++_i89) {
                TPlanFragment _elem88 = new TPlanFragment();
                _elem88.read((TProtocol)iprot);
                struct.fragments.add(_elem88);
            }
            struct.setFragmentsIsSet(true);
            struct.query_globals = new TQueryGlobals();
            struct.query_globals.read((TProtocol)iprot);
            struct.setQueryGlobalsIsSet(true);
            struct.stmt_type = TStmtType.findByValue(iprot.readI32());
            struct.setStmtTypeIsSet(true);
            BitSet incoming = iprot.readBitSet(5);
            if (incoming.get(0)) {
                struct.desc_tbl = new TDescriptorTable();
                struct.desc_tbl.read((TProtocol)iprot);
                struct.setDescTblIsSet(true);
            }
            if (incoming.get(1)) {
                TList _list90 = iprot.readListBegin((byte)8);
                struct.dest_fragment_idx = new ArrayList<Integer>(_list90.size);
                for (int _i92 = 0; _i92 < _list90.size; ++_i92) {
                    int _elem91 = iprot.readI32();
                    struct.dest_fragment_idx.add(_elem91);
                }
                struct.setDestFragmentIdxIsSet(true);
            }
            if (incoming.get(2)) {
                TMap _map93 = iprot.readMapBegin((byte)8, (byte)15);
                struct.per_node_scan_ranges = new HashMap<Integer, List<TScanRangeLocations>>(2 * _map93.size);
                for (int _i96 = 0; _i96 < _map93.size; ++_i96) {
                    int _key94 = iprot.readI32();
                    TList _list97 = iprot.readListBegin((byte)12);
                    ArrayList<TScanRangeLocations> _val95 = new ArrayList<TScanRangeLocations>(_list97.size);
                    for (int _i99 = 0; _i99 < _list97.size; ++_i99) {
                        TScanRangeLocations _elem98 = new TScanRangeLocations();
                        _elem98.read((TProtocol)iprot);
                        _val95.add(_elem98);
                    }
                    struct.per_node_scan_ranges.put(_key94, _val95);
                }
                struct.setPerNodeScanRangesIsSet(true);
            }
            if (incoming.get(3)) {
                struct.result_set_metadata = new TResultSetMetadata();
                struct.result_set_metadata.read((TProtocol)iprot);
                struct.setResultSetMetadataIsSet(true);
            }
            if (incoming.get(4)) {
                struct.is_block_query = iprot.readBool();
                struct.setIsBlockQueryIsSet(true);
            }
        }
    }

    private static class TQueryExecRequestTupleSchemeFactory
    implements SchemeFactory {
        private TQueryExecRequestTupleSchemeFactory() {
        }

        public TQueryExecRequestTupleScheme getScheme() {
            return new TQueryExecRequestTupleScheme();
        }
    }

    private static class TQueryExecRequestStandardScheme
    extends StandardScheme<TQueryExecRequest> {
        private TQueryExecRequestStandardScheme() {
        }

        public void read(TProtocol iprot, TQueryExecRequest struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 12) {
                            struct.desc_tbl = new TDescriptorTable();
                            struct.desc_tbl.read(iprot);
                            struct.setDescTblIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 15) {
                            TList _list66 = iprot.readListBegin();
                            struct.fragments = new ArrayList<TPlanFragment>(_list66.size);
                            for (int _i68 = 0; _i68 < _list66.size; ++_i68) {
                                TPlanFragment _elem67 = new TPlanFragment();
                                _elem67.read(iprot);
                                struct.fragments.add(_elem67);
                            }
                            iprot.readListEnd();
                            struct.setFragmentsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 15) {
                            TList _list69 = iprot.readListBegin();
                            struct.dest_fragment_idx = new ArrayList<Integer>(_list69.size);
                            for (int _i71 = 0; _i71 < _list69.size; ++_i71) {
                                int _elem70 = iprot.readI32();
                                struct.dest_fragment_idx.add(_elem70);
                            }
                            iprot.readListEnd();
                            struct.setDestFragmentIdxIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 13) {
                            TMap _map72 = iprot.readMapBegin();
                            struct.per_node_scan_ranges = new HashMap<Integer, List<TScanRangeLocations>>(2 * _map72.size);
                            for (int _i75 = 0; _i75 < _map72.size; ++_i75) {
                                int _key73 = iprot.readI32();
                                TList _list76 = iprot.readListBegin();
                                ArrayList<TScanRangeLocations> _val74 = new ArrayList<TScanRangeLocations>(_list76.size);
                                for (int _i78 = 0; _i78 < _list76.size; ++_i78) {
                                    TScanRangeLocations _elem77 = new TScanRangeLocations();
                                    _elem77.read(iprot);
                                    _val74.add(_elem77);
                                }
                                iprot.readListEnd();
                                struct.per_node_scan_ranges.put(_key73, _val74);
                            }
                            iprot.readMapEnd();
                            struct.setPerNodeScanRangesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 12) {
                            struct.result_set_metadata = new TResultSetMetadata();
                            struct.result_set_metadata.read(iprot);
                            struct.setResultSetMetadataIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 12) {
                            struct.query_globals = new TQueryGlobals();
                            struct.query_globals.read(iprot);
                            struct.setQueryGlobalsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 8) {
                            struct.stmt_type = TStmtType.findByValue(iprot.readI32());
                            struct.setStmtTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 2) {
                            struct.is_block_query = iprot.readBool();
                            struct.setIsBlockQueryIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TQueryExecRequest struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.desc_tbl != null && struct.isSetDescTbl()) {
                oprot.writeFieldBegin(DESC_TBL_FIELD_DESC);
                struct.desc_tbl.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.fragments != null) {
                oprot.writeFieldBegin(FRAGMENTS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.fragments.size()));
                for (TPlanFragment tPlanFragment : struct.fragments) {
                    tPlanFragment.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.dest_fragment_idx != null && struct.isSetDestFragmentIdx()) {
                oprot.writeFieldBegin(DEST_FRAGMENT_IDX_FIELD_DESC);
                oprot.writeListBegin(new TList(8, struct.dest_fragment_idx.size()));
                Iterator<Object> iterator = struct.dest_fragment_idx.iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    oprot.writeI32(n);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.per_node_scan_ranges != null && struct.isSetPerNodeScanRanges()) {
                oprot.writeFieldBegin(PER_NODE_SCAN_RANGES_FIELD_DESC);
                oprot.writeMapBegin(new TMap(8, 15, struct.per_node_scan_ranges.size()));
                for (Map.Entry entry : struct.per_node_scan_ranges.entrySet()) {
                    oprot.writeI32(((Integer)entry.getKey()).intValue());
                    oprot.writeListBegin(new TList(12, ((List)entry.getValue()).size()));
                    for (TScanRangeLocations _iter82 : (List)entry.getValue()) {
                        _iter82.write(oprot);
                    }
                    oprot.writeListEnd();
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.result_set_metadata != null && struct.isSetResultSetMetadata()) {
                oprot.writeFieldBegin(RESULT_SET_METADATA_FIELD_DESC);
                struct.result_set_metadata.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.query_globals != null) {
                oprot.writeFieldBegin(QUERY_GLOBALS_FIELD_DESC);
                struct.query_globals.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.stmt_type != null) {
                oprot.writeFieldBegin(STMT_TYPE_FIELD_DESC);
                oprot.writeI32(struct.stmt_type.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.isSetIsBlockQuery()) {
                oprot.writeFieldBegin(IS_BLOCK_QUERY_FIELD_DESC);
                oprot.writeBool(struct.is_block_query);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TQueryExecRequestStandardSchemeFactory
    implements SchemeFactory {
        private TQueryExecRequestStandardSchemeFactory() {
        }

        public TQueryExecRequestStandardScheme getScheme() {
            return new TQueryExecRequestStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        DESC_TBL(1, "desc_tbl"),
        FRAGMENTS(2, "fragments"),
        DEST_FRAGMENT_IDX(3, "dest_fragment_idx"),
        PER_NODE_SCAN_RANGES(4, "per_node_scan_ranges"),
        RESULT_SET_METADATA(5, "result_set_metadata"),
        QUERY_GLOBALS(7, "query_globals"),
        STMT_TYPE(9, "stmt_type"),
        IS_BLOCK_QUERY(10, "is_block_query");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return DESC_TBL;
                }
                case 2: {
                    return FRAGMENTS;
                }
                case 3: {
                    return DEST_FRAGMENT_IDX;
                }
                case 4: {
                    return PER_NODE_SCAN_RANGES;
                }
                case 5: {
                    return RESULT_SET_METADATA;
                }
                case 7: {
                    return QUERY_GLOBALS;
                }
                case 9: {
                    return STMT_TYPE;
                }
                case 10: {
                    return IS_BLOCK_QUERY;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

