/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.doris.thrift.TPlanFragmentDestination;
import org.apache.doris.thrift.TRuntimeFilterParams;
import org.apache.doris.thrift.TScanRangeParams;
import org.apache.doris.thrift.TUniqueId;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TPlanFragmentExecParams
implements TBase<TPlanFragmentExecParams, _Fields>,
Serializable,
Cloneable,
Comparable<TPlanFragmentExecParams> {
    private static final TStruct STRUCT_DESC = new TStruct("TPlanFragmentExecParams");
    private static final TField QUERY_ID_FIELD_DESC = new TField("query_id", 12, 1);
    private static final TField FRAGMENT_INSTANCE_ID_FIELD_DESC = new TField("fragment_instance_id", 12, 2);
    private static final TField PER_NODE_SCAN_RANGES_FIELD_DESC = new TField("per_node_scan_ranges", 13, 3);
    private static final TField PER_EXCH_NUM_SENDERS_FIELD_DESC = new TField("per_exch_num_senders", 13, 4);
    private static final TField DESTINATIONS_FIELD_DESC = new TField("destinations", 15, 5);
    private static final TField SENDER_ID_FIELD_DESC = new TField("sender_id", 8, 9);
    private static final TField NUM_SENDERS_FIELD_DESC = new TField("num_senders", 8, 10);
    private static final TField SEND_QUERY_STATISTICS_WITH_EVERY_BATCH_FIELD_DESC = new TField("send_query_statistics_with_every_batch", 2, 11);
    private static final TField RUNTIME_FILTER_PARAMS_FIELD_DESC = new TField("runtime_filter_params", 12, 12);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TPlanFragmentExecParamsStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TPlanFragmentExecParamsTupleSchemeFactory();
    @Nullable
    public TUniqueId query_id;
    @Nullable
    public TUniqueId fragment_instance_id;
    @Nullable
    public Map<Integer, List<TScanRangeParams>> per_node_scan_ranges;
    @Nullable
    public Map<Integer, Integer> per_exch_num_senders;
    @Nullable
    public List<TPlanFragmentDestination> destinations;
    public int sender_id;
    public int num_senders;
    public boolean send_query_statistics_with_every_batch;
    @Nullable
    public TRuntimeFilterParams runtime_filter_params;
    private static final int __SENDER_ID_ISSET_ID = 0;
    private static final int __NUM_SENDERS_ISSET_ID = 1;
    private static final int __SEND_QUERY_STATISTICS_WITH_EVERY_BATCH_ISSET_ID = 2;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.SENDER_ID, _Fields.NUM_SENDERS, _Fields.SEND_QUERY_STATISTICS_WITH_EVERY_BATCH, _Fields.RUNTIME_FILTER_PARAMS};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TPlanFragmentExecParams() {
    }

    public TPlanFragmentExecParams(TUniqueId query_id, TUniqueId fragment_instance_id, Map<Integer, List<TScanRangeParams>> per_node_scan_ranges, Map<Integer, Integer> per_exch_num_senders, List<TPlanFragmentDestination> destinations) {
        this();
        this.query_id = query_id;
        this.fragment_instance_id = fragment_instance_id;
        this.per_node_scan_ranges = per_node_scan_ranges;
        this.per_exch_num_senders = per_exch_num_senders;
        this.destinations = destinations;
    }

    public TPlanFragmentExecParams(TPlanFragmentExecParams other) {
        Object other_element_value;
        Integer other_element_key;
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetQueryId()) {
            this.query_id = new TUniqueId(other.query_id);
        }
        if (other.isSetFragmentInstanceId()) {
            this.fragment_instance_id = new TUniqueId(other.fragment_instance_id);
        }
        if (other.isSetPerNodeScanRanges()) {
            HashMap<Integer, List<TScanRangeParams>> __this__per_node_scan_ranges = new HashMap<Integer, List<TScanRangeParams>>(other.per_node_scan_ranges.size());
            for (Map.Entry<Integer, Object> entry : other.per_node_scan_ranges.entrySet()) {
                other_element_key = entry.getKey();
                other_element_value = (List)entry.getValue();
                Integer __this__per_node_scan_ranges_copy_key = other_element_key;
                ArrayList<TScanRangeParams> __this__per_node_scan_ranges_copy_value = new ArrayList<TScanRangeParams>(other_element_value.size());
                Iterator iterator = other_element_value.iterator();
                while (iterator.hasNext()) {
                    TScanRangeParams other_element_value_element = (TScanRangeParams)iterator.next();
                    __this__per_node_scan_ranges_copy_value.add(new TScanRangeParams(other_element_value_element));
                }
                __this__per_node_scan_ranges.put(__this__per_node_scan_ranges_copy_key, __this__per_node_scan_ranges_copy_value);
            }
            this.per_node_scan_ranges = __this__per_node_scan_ranges;
        }
        if (other.isSetPerExchNumSenders()) {
            HashMap<Integer, Integer> __this__per_exch_num_senders = new HashMap<Integer, Integer>(other.per_exch_num_senders.size());
            for (Map.Entry entry : other.per_exch_num_senders.entrySet()) {
                other_element_key = (Integer)entry.getKey();
                other_element_value = (Integer)entry.getValue();
                Integer __this__per_exch_num_senders_copy_key = other_element_key;
                Object __this__per_exch_num_senders_copy_value = other_element_value;
                __this__per_exch_num_senders.put(__this__per_exch_num_senders_copy_key, (Integer)__this__per_exch_num_senders_copy_value);
            }
            this.per_exch_num_senders = __this__per_exch_num_senders;
        }
        if (other.isSetDestinations()) {
            ArrayList<TPlanFragmentDestination> __this__destinations = new ArrayList<TPlanFragmentDestination>(other.destinations.size());
            for (TPlanFragmentDestination tPlanFragmentDestination : other.destinations) {
                __this__destinations.add(new TPlanFragmentDestination(tPlanFragmentDestination));
            }
            this.destinations = __this__destinations;
        }
        this.sender_id = other.sender_id;
        this.num_senders = other.num_senders;
        this.send_query_statistics_with_every_batch = other.send_query_statistics_with_every_batch;
        if (other.isSetRuntimeFilterParams()) {
            this.runtime_filter_params = new TRuntimeFilterParams(other.runtime_filter_params);
        }
    }

    public TPlanFragmentExecParams deepCopy() {
        return new TPlanFragmentExecParams(this);
    }

    public void clear() {
        this.query_id = null;
        this.fragment_instance_id = null;
        this.per_node_scan_ranges = null;
        this.per_exch_num_senders = null;
        this.destinations = null;
        this.setSenderIdIsSet(false);
        this.sender_id = 0;
        this.setNumSendersIsSet(false);
        this.num_senders = 0;
        this.setSendQueryStatisticsWithEveryBatchIsSet(false);
        this.send_query_statistics_with_every_batch = false;
        this.runtime_filter_params = null;
    }

    @Nullable
    public TUniqueId getQueryId() {
        return this.query_id;
    }

    public TPlanFragmentExecParams setQueryId(@Nullable TUniqueId query_id) {
        this.query_id = query_id;
        return this;
    }

    public void unsetQueryId() {
        this.query_id = null;
    }

    public boolean isSetQueryId() {
        return this.query_id != null;
    }

    public void setQueryIdIsSet(boolean value) {
        if (!value) {
            this.query_id = null;
        }
    }

    @Nullable
    public TUniqueId getFragmentInstanceId() {
        return this.fragment_instance_id;
    }

    public TPlanFragmentExecParams setFragmentInstanceId(@Nullable TUniqueId fragment_instance_id) {
        this.fragment_instance_id = fragment_instance_id;
        return this;
    }

    public void unsetFragmentInstanceId() {
        this.fragment_instance_id = null;
    }

    public boolean isSetFragmentInstanceId() {
        return this.fragment_instance_id != null;
    }

    public void setFragmentInstanceIdIsSet(boolean value) {
        if (!value) {
            this.fragment_instance_id = null;
        }
    }

    public int getPerNodeScanRangesSize() {
        return this.per_node_scan_ranges == null ? 0 : this.per_node_scan_ranges.size();
    }

    public void putToPerNodeScanRanges(int key, List<TScanRangeParams> val) {
        if (this.per_node_scan_ranges == null) {
            this.per_node_scan_ranges = new HashMap<Integer, List<TScanRangeParams>>();
        }
        this.per_node_scan_ranges.put(key, val);
    }

    @Nullable
    public Map<Integer, List<TScanRangeParams>> getPerNodeScanRanges() {
        return this.per_node_scan_ranges;
    }

    public TPlanFragmentExecParams setPerNodeScanRanges(@Nullable Map<Integer, List<TScanRangeParams>> per_node_scan_ranges) {
        this.per_node_scan_ranges = per_node_scan_ranges;
        return this;
    }

    public void unsetPerNodeScanRanges() {
        this.per_node_scan_ranges = null;
    }

    public boolean isSetPerNodeScanRanges() {
        return this.per_node_scan_ranges != null;
    }

    public void setPerNodeScanRangesIsSet(boolean value) {
        if (!value) {
            this.per_node_scan_ranges = null;
        }
    }

    public int getPerExchNumSendersSize() {
        return this.per_exch_num_senders == null ? 0 : this.per_exch_num_senders.size();
    }

    public void putToPerExchNumSenders(int key, int val) {
        if (this.per_exch_num_senders == null) {
            this.per_exch_num_senders = new HashMap<Integer, Integer>();
        }
        this.per_exch_num_senders.put(key, val);
    }

    @Nullable
    public Map<Integer, Integer> getPerExchNumSenders() {
        return this.per_exch_num_senders;
    }

    public TPlanFragmentExecParams setPerExchNumSenders(@Nullable Map<Integer, Integer> per_exch_num_senders) {
        this.per_exch_num_senders = per_exch_num_senders;
        return this;
    }

    public void unsetPerExchNumSenders() {
        this.per_exch_num_senders = null;
    }

    public boolean isSetPerExchNumSenders() {
        return this.per_exch_num_senders != null;
    }

    public void setPerExchNumSendersIsSet(boolean value) {
        if (!value) {
            this.per_exch_num_senders = null;
        }
    }

    public int getDestinationsSize() {
        return this.destinations == null ? 0 : this.destinations.size();
    }

    @Nullable
    public Iterator<TPlanFragmentDestination> getDestinationsIterator() {
        return this.destinations == null ? null : this.destinations.iterator();
    }

    public void addToDestinations(TPlanFragmentDestination elem) {
        if (this.destinations == null) {
            this.destinations = new ArrayList<TPlanFragmentDestination>();
        }
        this.destinations.add(elem);
    }

    @Nullable
    public List<TPlanFragmentDestination> getDestinations() {
        return this.destinations;
    }

    public TPlanFragmentExecParams setDestinations(@Nullable List<TPlanFragmentDestination> destinations) {
        this.destinations = destinations;
        return this;
    }

    public void unsetDestinations() {
        this.destinations = null;
    }

    public boolean isSetDestinations() {
        return this.destinations != null;
    }

    public void setDestinationsIsSet(boolean value) {
        if (!value) {
            this.destinations = null;
        }
    }

    public int getSenderId() {
        return this.sender_id;
    }

    public TPlanFragmentExecParams setSenderId(int sender_id) {
        this.sender_id = sender_id;
        this.setSenderIdIsSet(true);
        return this;
    }

    public void unsetSenderId() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetSenderId() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setSenderIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public int getNumSenders() {
        return this.num_senders;
    }

    public TPlanFragmentExecParams setNumSenders(int num_senders) {
        this.num_senders = num_senders;
        this.setNumSendersIsSet(true);
        return this;
    }

    public void unsetNumSenders() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetNumSenders() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setNumSendersIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public boolean isSendQueryStatisticsWithEveryBatch() {
        return this.send_query_statistics_with_every_batch;
    }

    public TPlanFragmentExecParams setSendQueryStatisticsWithEveryBatch(boolean send_query_statistics_with_every_batch) {
        this.send_query_statistics_with_every_batch = send_query_statistics_with_every_batch;
        this.setSendQueryStatisticsWithEveryBatchIsSet(true);
        return this;
    }

    public void unsetSendQueryStatisticsWithEveryBatch() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetSendQueryStatisticsWithEveryBatch() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setSendQueryStatisticsWithEveryBatchIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    @Nullable
    public TRuntimeFilterParams getRuntimeFilterParams() {
        return this.runtime_filter_params;
    }

    public TPlanFragmentExecParams setRuntimeFilterParams(@Nullable TRuntimeFilterParams runtime_filter_params) {
        this.runtime_filter_params = runtime_filter_params;
        return this;
    }

    public void unsetRuntimeFilterParams() {
        this.runtime_filter_params = null;
    }

    public boolean isSetRuntimeFilterParams() {
        return this.runtime_filter_params != null;
    }

    public void setRuntimeFilterParamsIsSet(boolean value) {
        if (!value) {
            this.runtime_filter_params = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case QUERY_ID: {
                if (value == null) {
                    this.unsetQueryId();
                    break;
                }
                this.setQueryId((TUniqueId)value);
                break;
            }
            case FRAGMENT_INSTANCE_ID: {
                if (value == null) {
                    this.unsetFragmentInstanceId();
                    break;
                }
                this.setFragmentInstanceId((TUniqueId)value);
                break;
            }
            case PER_NODE_SCAN_RANGES: {
                if (value == null) {
                    this.unsetPerNodeScanRanges();
                    break;
                }
                this.setPerNodeScanRanges((Map)value);
                break;
            }
            case PER_EXCH_NUM_SENDERS: {
                if (value == null) {
                    this.unsetPerExchNumSenders();
                    break;
                }
                this.setPerExchNumSenders((Map)value);
                break;
            }
            case DESTINATIONS: {
                if (value == null) {
                    this.unsetDestinations();
                    break;
                }
                this.setDestinations((List)value);
                break;
            }
            case SENDER_ID: {
                if (value == null) {
                    this.unsetSenderId();
                    break;
                }
                this.setSenderId((Integer)value);
                break;
            }
            case NUM_SENDERS: {
                if (value == null) {
                    this.unsetNumSenders();
                    break;
                }
                this.setNumSenders((Integer)value);
                break;
            }
            case SEND_QUERY_STATISTICS_WITH_EVERY_BATCH: {
                if (value == null) {
                    this.unsetSendQueryStatisticsWithEveryBatch();
                    break;
                }
                this.setSendQueryStatisticsWithEveryBatch((Boolean)value);
                break;
            }
            case RUNTIME_FILTER_PARAMS: {
                if (value == null) {
                    this.unsetRuntimeFilterParams();
                    break;
                }
                this.setRuntimeFilterParams((TRuntimeFilterParams)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case QUERY_ID: {
                return this.getQueryId();
            }
            case FRAGMENT_INSTANCE_ID: {
                return this.getFragmentInstanceId();
            }
            case PER_NODE_SCAN_RANGES: {
                return this.getPerNodeScanRanges();
            }
            case PER_EXCH_NUM_SENDERS: {
                return this.getPerExchNumSenders();
            }
            case DESTINATIONS: {
                return this.getDestinations();
            }
            case SENDER_ID: {
                return this.getSenderId();
            }
            case NUM_SENDERS: {
                return this.getNumSenders();
            }
            case SEND_QUERY_STATISTICS_WITH_EVERY_BATCH: {
                return this.isSendQueryStatisticsWithEveryBatch();
            }
            case RUNTIME_FILTER_PARAMS: {
                return this.getRuntimeFilterParams();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case QUERY_ID: {
                return this.isSetQueryId();
            }
            case FRAGMENT_INSTANCE_ID: {
                return this.isSetFragmentInstanceId();
            }
            case PER_NODE_SCAN_RANGES: {
                return this.isSetPerNodeScanRanges();
            }
            case PER_EXCH_NUM_SENDERS: {
                return this.isSetPerExchNumSenders();
            }
            case DESTINATIONS: {
                return this.isSetDestinations();
            }
            case SENDER_ID: {
                return this.isSetSenderId();
            }
            case NUM_SENDERS: {
                return this.isSetNumSenders();
            }
            case SEND_QUERY_STATISTICS_WITH_EVERY_BATCH: {
                return this.isSetSendQueryStatisticsWithEveryBatch();
            }
            case RUNTIME_FILTER_PARAMS: {
                return this.isSetRuntimeFilterParams();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof TPlanFragmentExecParams) {
            return this.equals((TPlanFragmentExecParams)that);
        }
        return false;
    }

    public boolean equals(TPlanFragmentExecParams that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_query_id = this.isSetQueryId();
        boolean that_present_query_id = that.isSetQueryId();
        if (this_present_query_id || that_present_query_id) {
            if (!this_present_query_id || !that_present_query_id) {
                return false;
            }
            if (!this.query_id.equals(that.query_id)) {
                return false;
            }
        }
        boolean this_present_fragment_instance_id = this.isSetFragmentInstanceId();
        boolean that_present_fragment_instance_id = that.isSetFragmentInstanceId();
        if (this_present_fragment_instance_id || that_present_fragment_instance_id) {
            if (!this_present_fragment_instance_id || !that_present_fragment_instance_id) {
                return false;
            }
            if (!this.fragment_instance_id.equals(that.fragment_instance_id)) {
                return false;
            }
        }
        boolean this_present_per_node_scan_ranges = this.isSetPerNodeScanRanges();
        boolean that_present_per_node_scan_ranges = that.isSetPerNodeScanRanges();
        if (this_present_per_node_scan_ranges || that_present_per_node_scan_ranges) {
            if (!this_present_per_node_scan_ranges || !that_present_per_node_scan_ranges) {
                return false;
            }
            if (!this.per_node_scan_ranges.equals(that.per_node_scan_ranges)) {
                return false;
            }
        }
        boolean this_present_per_exch_num_senders = this.isSetPerExchNumSenders();
        boolean that_present_per_exch_num_senders = that.isSetPerExchNumSenders();
        if (this_present_per_exch_num_senders || that_present_per_exch_num_senders) {
            if (!this_present_per_exch_num_senders || !that_present_per_exch_num_senders) {
                return false;
            }
            if (!this.per_exch_num_senders.equals(that.per_exch_num_senders)) {
                return false;
            }
        }
        boolean this_present_destinations = this.isSetDestinations();
        boolean that_present_destinations = that.isSetDestinations();
        if (this_present_destinations || that_present_destinations) {
            if (!this_present_destinations || !that_present_destinations) {
                return false;
            }
            if (!this.destinations.equals(that.destinations)) {
                return false;
            }
        }
        boolean this_present_sender_id = this.isSetSenderId();
        boolean that_present_sender_id = that.isSetSenderId();
        if (this_present_sender_id || that_present_sender_id) {
            if (!this_present_sender_id || !that_present_sender_id) {
                return false;
            }
            if (this.sender_id != that.sender_id) {
                return false;
            }
        }
        boolean this_present_num_senders = this.isSetNumSenders();
        boolean that_present_num_senders = that.isSetNumSenders();
        if (this_present_num_senders || that_present_num_senders) {
            if (!this_present_num_senders || !that_present_num_senders) {
                return false;
            }
            if (this.num_senders != that.num_senders) {
                return false;
            }
        }
        boolean this_present_send_query_statistics_with_every_batch = this.isSetSendQueryStatisticsWithEveryBatch();
        boolean that_present_send_query_statistics_with_every_batch = that.isSetSendQueryStatisticsWithEveryBatch();
        if (this_present_send_query_statistics_with_every_batch || that_present_send_query_statistics_with_every_batch) {
            if (!this_present_send_query_statistics_with_every_batch || !that_present_send_query_statistics_with_every_batch) {
                return false;
            }
            if (this.send_query_statistics_with_every_batch != that.send_query_statistics_with_every_batch) {
                return false;
            }
        }
        boolean this_present_runtime_filter_params = this.isSetRuntimeFilterParams();
        boolean that_present_runtime_filter_params = that.isSetRuntimeFilterParams();
        if (this_present_runtime_filter_params || that_present_runtime_filter_params) {
            if (!this_present_runtime_filter_params || !that_present_runtime_filter_params) {
                return false;
            }
            if (!this.runtime_filter_params.equals(that.runtime_filter_params)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetQueryId() ? 131071 : 524287);
        if (this.isSetQueryId()) {
            hashCode = hashCode * 8191 + this.query_id.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetFragmentInstanceId() ? 131071 : 524287);
        if (this.isSetFragmentInstanceId()) {
            hashCode = hashCode * 8191 + this.fragment_instance_id.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetPerNodeScanRanges() ? 131071 : 524287);
        if (this.isSetPerNodeScanRanges()) {
            hashCode = hashCode * 8191 + this.per_node_scan_ranges.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetPerExchNumSenders() ? 131071 : 524287);
        if (this.isSetPerExchNumSenders()) {
            hashCode = hashCode * 8191 + this.per_exch_num_senders.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetDestinations() ? 131071 : 524287);
        if (this.isSetDestinations()) {
            hashCode = hashCode * 8191 + this.destinations.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetSenderId() ? 131071 : 524287);
        if (this.isSetSenderId()) {
            hashCode = hashCode * 8191 + this.sender_id;
        }
        hashCode = hashCode * 8191 + (this.isSetNumSenders() ? 131071 : 524287);
        if (this.isSetNumSenders()) {
            hashCode = hashCode * 8191 + this.num_senders;
        }
        hashCode = hashCode * 8191 + (this.isSetSendQueryStatisticsWithEveryBatch() ? 131071 : 524287);
        if (this.isSetSendQueryStatisticsWithEveryBatch()) {
            hashCode = hashCode * 8191 + (this.send_query_statistics_with_every_batch ? 131071 : 524287);
        }
        hashCode = hashCode * 8191 + (this.isSetRuntimeFilterParams() ? 131071 : 524287);
        if (this.isSetRuntimeFilterParams()) {
            hashCode = hashCode * 8191 + this.runtime_filter_params.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(TPlanFragmentExecParams other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetQueryId(), other.isSetQueryId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetQueryId() && (lastComparison = TBaseHelper.compareTo((Comparable)this.query_id, (Comparable)other.query_id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetFragmentInstanceId(), other.isSetFragmentInstanceId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFragmentInstanceId() && (lastComparison = TBaseHelper.compareTo((Comparable)this.fragment_instance_id, (Comparable)other.fragment_instance_id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPerNodeScanRanges(), other.isSetPerNodeScanRanges());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPerNodeScanRanges() && (lastComparison = TBaseHelper.compareTo(this.per_node_scan_ranges, other.per_node_scan_ranges)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPerExchNumSenders(), other.isSetPerExchNumSenders());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPerExchNumSenders() && (lastComparison = TBaseHelper.compareTo(this.per_exch_num_senders, other.per_exch_num_senders)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetDestinations(), other.isSetDestinations());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDestinations() && (lastComparison = TBaseHelper.compareTo(this.destinations, other.destinations)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetSenderId(), other.isSetSenderId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSenderId() && (lastComparison = TBaseHelper.compareTo((int)this.sender_id, (int)other.sender_id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetNumSenders(), other.isSetNumSenders());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNumSenders() && (lastComparison = TBaseHelper.compareTo((int)this.num_senders, (int)other.num_senders)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetSendQueryStatisticsWithEveryBatch(), other.isSetSendQueryStatisticsWithEveryBatch());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSendQueryStatisticsWithEveryBatch() && (lastComparison = TBaseHelper.compareTo((boolean)this.send_query_statistics_with_every_batch, (boolean)other.send_query_statistics_with_every_batch)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetRuntimeFilterParams(), other.isSetRuntimeFilterParams());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRuntimeFilterParams() && (lastComparison = TBaseHelper.compareTo((Comparable)this.runtime_filter_params, (Comparable)other.runtime_filter_params)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        TPlanFragmentExecParams.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        TPlanFragmentExecParams.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TPlanFragmentExecParams(");
        boolean first = true;
        sb.append("query_id:");
        if (this.query_id == null) {
            sb.append("null");
        } else {
            sb.append(this.query_id);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("fragment_instance_id:");
        if (this.fragment_instance_id == null) {
            sb.append("null");
        } else {
            sb.append(this.fragment_instance_id);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("per_node_scan_ranges:");
        if (this.per_node_scan_ranges == null) {
            sb.append("null");
        } else {
            sb.append(this.per_node_scan_ranges);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("per_exch_num_senders:");
        if (this.per_exch_num_senders == null) {
            sb.append("null");
        } else {
            sb.append(this.per_exch_num_senders);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("destinations:");
        if (this.destinations == null) {
            sb.append("null");
        } else {
            sb.append(this.destinations);
        }
        first = false;
        if (this.isSetSenderId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("sender_id:");
            sb.append(this.sender_id);
            first = false;
        }
        if (this.isSetNumSenders()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("num_senders:");
            sb.append(this.num_senders);
            first = false;
        }
        if (this.isSetSendQueryStatisticsWithEveryBatch()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("send_query_statistics_with_every_batch:");
            sb.append(this.send_query_statistics_with_every_batch);
            first = false;
        }
        if (this.isSetRuntimeFilterParams()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("runtime_filter_params:");
            if (this.runtime_filter_params == null) {
                sb.append("null");
            } else {
                sb.append(this.runtime_filter_params);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.query_id == null) {
            throw new TProtocolException("Required field 'query_id' was not present! Struct: " + this.toString());
        }
        if (this.fragment_instance_id == null) {
            throw new TProtocolException("Required field 'fragment_instance_id' was not present! Struct: " + this.toString());
        }
        if (this.per_node_scan_ranges == null) {
            throw new TProtocolException("Required field 'per_node_scan_ranges' was not present! Struct: " + this.toString());
        }
        if (this.per_exch_num_senders == null) {
            throw new TProtocolException("Required field 'per_exch_num_senders' was not present! Struct: " + this.toString());
        }
        if (this.query_id != null) {
            this.query_id.validate();
        }
        if (this.fragment_instance_id != null) {
            this.fragment_instance_id.validate();
        }
        if (this.runtime_filter_params != null) {
            this.runtime_filter_params.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.QUERY_ID, new FieldMetaData("query_id", 1, (FieldValueMetaData)new StructMetaData(12, TUniqueId.class)));
        tmpMap.put(_Fields.FRAGMENT_INSTANCE_ID, new FieldMetaData("fragment_instance_id", 1, (FieldValueMetaData)new StructMetaData(12, TUniqueId.class)));
        tmpMap.put(_Fields.PER_NODE_SCAN_RANGES, new FieldMetaData("per_node_scan_ranges", 1, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(8, "TPlanNodeId"), (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, TScanRangeParams.class)))));
        tmpMap.put(_Fields.PER_EXCH_NUM_SENDERS, new FieldMetaData("per_exch_num_senders", 1, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(8, "TPlanNodeId"), new FieldValueMetaData(8))));
        tmpMap.put(_Fields.DESTINATIONS, new FieldMetaData("destinations", 3, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, TPlanFragmentDestination.class))));
        tmpMap.put(_Fields.SENDER_ID, new FieldMetaData("sender_id", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.NUM_SENDERS, new FieldMetaData("num_senders", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.SEND_QUERY_STATISTICS_WITH_EVERY_BATCH, new FieldMetaData("send_query_statistics_with_every_batch", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.RUNTIME_FILTER_PARAMS, new FieldMetaData("runtime_filter_params", 2, (FieldValueMetaData)new StructMetaData(12, TRuntimeFilterParams.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TPlanFragmentExecParams.class, metaDataMap);
    }

    private static class TPlanFragmentExecParamsTupleScheme
    extends TupleScheme<TPlanFragmentExecParams> {
        private TPlanFragmentExecParamsTupleScheme() {
        }

        public void write(TProtocol prot, TPlanFragmentExecParams struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            struct.query_id.write((TProtocol)oprot);
            struct.fragment_instance_id.write((TProtocol)oprot);
            oprot.writeI32(struct.per_node_scan_ranges.size());
            for (Map.Entry<Integer, List<TScanRangeParams>> entry : struct.per_node_scan_ranges.entrySet()) {
                oprot.writeI32(entry.getKey().intValue());
                oprot.writeI32(entry.getValue().size());
                for (TScanRangeParams _iter93 : entry.getValue()) {
                    _iter93.write((TProtocol)oprot);
                }
            }
            oprot.writeI32(struct.per_exch_num_senders.size());
            for (Map.Entry<Integer, Object> entry : struct.per_exch_num_senders.entrySet()) {
                oprot.writeI32(entry.getKey().intValue());
                oprot.writeI32(((Integer)entry.getValue()).intValue());
            }
            BitSet optionals = new BitSet();
            if (struct.isSetDestinations()) {
                optionals.set(0);
            }
            if (struct.isSetSenderId()) {
                optionals.set(1);
            }
            if (struct.isSetNumSenders()) {
                optionals.set(2);
            }
            if (struct.isSetSendQueryStatisticsWithEveryBatch()) {
                optionals.set(3);
            }
            if (struct.isSetRuntimeFilterParams()) {
                optionals.set(4);
            }
            oprot.writeBitSet(optionals, 5);
            if (struct.isSetDestinations()) {
                oprot.writeI32(struct.destinations.size());
                for (TPlanFragmentDestination _iter95 : struct.destinations) {
                    _iter95.write((TProtocol)oprot);
                }
            }
            if (struct.isSetSenderId()) {
                oprot.writeI32(struct.sender_id);
            }
            if (struct.isSetNumSenders()) {
                oprot.writeI32(struct.num_senders);
            }
            if (struct.isSetSendQueryStatisticsWithEveryBatch()) {
                oprot.writeBool(struct.send_query_statistics_with_every_batch);
            }
            if (struct.isSetRuntimeFilterParams()) {
                struct.runtime_filter_params.write((TProtocol)oprot);
            }
        }

        public void read(TProtocol prot, TPlanFragmentExecParams struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.query_id = new TUniqueId();
            struct.query_id.read((TProtocol)iprot);
            struct.setQueryIdIsSet(true);
            struct.fragment_instance_id = new TUniqueId();
            struct.fragment_instance_id.read((TProtocol)iprot);
            struct.setFragmentInstanceIdIsSet(true);
            TMap _map96 = iprot.readMapBegin((byte)8, (byte)15);
            struct.per_node_scan_ranges = new HashMap<Integer, List<TScanRangeParams>>(2 * _map96.size);
            for (int _i99 = 0; _i99 < _map96.size; ++_i99) {
                int _key97 = iprot.readI32();
                TList _list100 = iprot.readListBegin((byte)12);
                ArrayList<TScanRangeParams> _val98 = new ArrayList<TScanRangeParams>(_list100.size);
                for (int _i102 = 0; _i102 < _list100.size; ++_i102) {
                    TScanRangeParams _elem101 = new TScanRangeParams();
                    _elem101.read((TProtocol)iprot);
                    _val98.add(_elem101);
                }
                struct.per_node_scan_ranges.put(_key97, _val98);
            }
            struct.setPerNodeScanRangesIsSet(true);
            TMap _map103 = iprot.readMapBegin((byte)8, (byte)8);
            struct.per_exch_num_senders = new HashMap<Integer, Integer>(2 * _map103.size);
            for (int _i106 = 0; _i106 < _map103.size; ++_i106) {
                int _key104 = iprot.readI32();
                int _val105 = iprot.readI32();
                struct.per_exch_num_senders.put(_key104, _val105);
            }
            struct.setPerExchNumSendersIsSet(true);
            BitSet incoming = iprot.readBitSet(5);
            if (incoming.get(0)) {
                TList _list107 = iprot.readListBegin((byte)12);
                struct.destinations = new ArrayList<TPlanFragmentDestination>(_list107.size);
                for (int _i109 = 0; _i109 < _list107.size; ++_i109) {
                    TPlanFragmentDestination _elem108 = new TPlanFragmentDestination();
                    _elem108.read((TProtocol)iprot);
                    struct.destinations.add(_elem108);
                }
                struct.setDestinationsIsSet(true);
            }
            if (incoming.get(1)) {
                struct.sender_id = iprot.readI32();
                struct.setSenderIdIsSet(true);
            }
            if (incoming.get(2)) {
                struct.num_senders = iprot.readI32();
                struct.setNumSendersIsSet(true);
            }
            if (incoming.get(3)) {
                struct.send_query_statistics_with_every_batch = iprot.readBool();
                struct.setSendQueryStatisticsWithEveryBatchIsSet(true);
            }
            if (incoming.get(4)) {
                struct.runtime_filter_params = new TRuntimeFilterParams();
                struct.runtime_filter_params.read((TProtocol)iprot);
                struct.setRuntimeFilterParamsIsSet(true);
            }
        }
    }

    private static class TPlanFragmentExecParamsTupleSchemeFactory
    implements SchemeFactory {
        private TPlanFragmentExecParamsTupleSchemeFactory() {
        }

        public TPlanFragmentExecParamsTupleScheme getScheme() {
            return new TPlanFragmentExecParamsTupleScheme();
        }
    }

    private static class TPlanFragmentExecParamsStandardScheme
    extends StandardScheme<TPlanFragmentExecParams> {
        private TPlanFragmentExecParamsStandardScheme() {
        }

        public void read(TProtocol iprot, TPlanFragmentExecParams struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 12) {
                            struct.query_id = new TUniqueId();
                            struct.query_id.read(iprot);
                            struct.setQueryIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 12) {
                            struct.fragment_instance_id = new TUniqueId();
                            struct.fragment_instance_id.read(iprot);
                            struct.setFragmentInstanceIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 13) {
                            TMap _map74 = iprot.readMapBegin();
                            struct.per_node_scan_ranges = new HashMap<Integer, List<TScanRangeParams>>(2 * _map74.size);
                            for (int _i77 = 0; _i77 < _map74.size; ++_i77) {
                                int _key75 = iprot.readI32();
                                TList _list78 = iprot.readListBegin();
                                ArrayList<TScanRangeParams> _val76 = new ArrayList<TScanRangeParams>(_list78.size);
                                for (int _i80 = 0; _i80 < _list78.size; ++_i80) {
                                    TScanRangeParams _elem79 = new TScanRangeParams();
                                    _elem79.read(iprot);
                                    _val76.add(_elem79);
                                }
                                iprot.readListEnd();
                                struct.per_node_scan_ranges.put(_key75, _val76);
                            }
                            iprot.readMapEnd();
                            struct.setPerNodeScanRangesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 13) {
                            TMap _map81 = iprot.readMapBegin();
                            struct.per_exch_num_senders = new HashMap<Integer, Integer>(2 * _map81.size);
                            for (int _i84 = 0; _i84 < _map81.size; ++_i84) {
                                int _key82 = iprot.readI32();
                                int _val83 = iprot.readI32();
                                struct.per_exch_num_senders.put(_key82, _val83);
                            }
                            iprot.readMapEnd();
                            struct.setPerExchNumSendersIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 15) {
                            TList _list85 = iprot.readListBegin();
                            struct.destinations = new ArrayList<TPlanFragmentDestination>(_list85.size);
                            for (int _i87 = 0; _i87 < _list85.size; ++_i87) {
                                TPlanFragmentDestination _elem86 = new TPlanFragmentDestination();
                                _elem86.read(iprot);
                                struct.destinations.add(_elem86);
                            }
                            iprot.readListEnd();
                            struct.setDestinationsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 8) {
                            struct.sender_id = iprot.readI32();
                            struct.setSenderIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 8) {
                            struct.num_senders = iprot.readI32();
                            struct.setNumSendersIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 2) {
                            struct.send_query_statistics_with_every_batch = iprot.readBool();
                            struct.setSendQueryStatisticsWithEveryBatchIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 12) {
                            struct.runtime_filter_params = new TRuntimeFilterParams();
                            struct.runtime_filter_params.read(iprot);
                            struct.setRuntimeFilterParamsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TPlanFragmentExecParams struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.query_id != null) {
                oprot.writeFieldBegin(QUERY_ID_FIELD_DESC);
                struct.query_id.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.fragment_instance_id != null) {
                oprot.writeFieldBegin(FRAGMENT_INSTANCE_ID_FIELD_DESC);
                struct.fragment_instance_id.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.per_node_scan_ranges != null) {
                oprot.writeFieldBegin(PER_NODE_SCAN_RANGES_FIELD_DESC);
                oprot.writeMapBegin(new TMap(8, 15, struct.per_node_scan_ranges.size()));
                for (Map.Entry<Integer, Object> entry : struct.per_node_scan_ranges.entrySet()) {
                    oprot.writeI32(entry.getKey().intValue());
                    oprot.writeListBegin(new TList(12, ((List)entry.getValue()).size()));
                    for (TScanRangeParams _iter89 : (List)entry.getValue()) {
                        _iter89.write(oprot);
                    }
                    oprot.writeListEnd();
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.per_exch_num_senders != null) {
                oprot.writeFieldBegin(PER_EXCH_NUM_SENDERS_FIELD_DESC);
                oprot.writeMapBegin(new TMap(8, 8, struct.per_exch_num_senders.size()));
                for (Map.Entry entry : struct.per_exch_num_senders.entrySet()) {
                    oprot.writeI32(((Integer)entry.getKey()).intValue());
                    oprot.writeI32(((Integer)entry.getValue()).intValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.destinations != null) {
                oprot.writeFieldBegin(DESTINATIONS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.destinations.size()));
                for (TPlanFragmentDestination tPlanFragmentDestination : struct.destinations) {
                    tPlanFragmentDestination.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.isSetSenderId()) {
                oprot.writeFieldBegin(SENDER_ID_FIELD_DESC);
                oprot.writeI32(struct.sender_id);
                oprot.writeFieldEnd();
            }
            if (struct.isSetNumSenders()) {
                oprot.writeFieldBegin(NUM_SENDERS_FIELD_DESC);
                oprot.writeI32(struct.num_senders);
                oprot.writeFieldEnd();
            }
            if (struct.isSetSendQueryStatisticsWithEveryBatch()) {
                oprot.writeFieldBegin(SEND_QUERY_STATISTICS_WITH_EVERY_BATCH_FIELD_DESC);
                oprot.writeBool(struct.send_query_statistics_with_every_batch);
                oprot.writeFieldEnd();
            }
            if (struct.runtime_filter_params != null && struct.isSetRuntimeFilterParams()) {
                oprot.writeFieldBegin(RUNTIME_FILTER_PARAMS_FIELD_DESC);
                struct.runtime_filter_params.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TPlanFragmentExecParamsStandardSchemeFactory
    implements SchemeFactory {
        private TPlanFragmentExecParamsStandardSchemeFactory() {
        }

        public TPlanFragmentExecParamsStandardScheme getScheme() {
            return new TPlanFragmentExecParamsStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        QUERY_ID(1, "query_id"),
        FRAGMENT_INSTANCE_ID(2, "fragment_instance_id"),
        PER_NODE_SCAN_RANGES(3, "per_node_scan_ranges"),
        PER_EXCH_NUM_SENDERS(4, "per_exch_num_senders"),
        DESTINATIONS(5, "destinations"),
        SENDER_ID(9, "sender_id"),
        NUM_SENDERS(10, "num_senders"),
        SEND_QUERY_STATISTICS_WITH_EVERY_BATCH(11, "send_query_statistics_with_every_batch"),
        RUNTIME_FILTER_PARAMS(12, "runtime_filter_params");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return QUERY_ID;
                }
                case 2: {
                    return FRAGMENT_INSTANCE_ID;
                }
                case 3: {
                    return PER_NODE_SCAN_RANGES;
                }
                case 4: {
                    return PER_EXCH_NUM_SENDERS;
                }
                case 5: {
                    return DESTINATIONS;
                }
                case 9: {
                    return SENDER_ID;
                }
                case 10: {
                    return NUM_SENDERS;
                }
                case 11: {
                    return SEND_QUERY_STATISTICS_WITH_EVERY_BATCH;
                }
                case 12: {
                    return RUNTIME_FILTER_PARAMS;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

