/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.doris.thrift.TAggregateFunction;
import org.apache.doris.thrift.TFunctionBinaryType;
import org.apache.doris.thrift.TFunctionName;
import org.apache.doris.thrift.TScalarFunction;
import org.apache.doris.thrift.TTypeDesc;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TFunction
implements TBase<TFunction, _Fields>,
Serializable,
Cloneable,
Comparable<TFunction> {
    private static final TStruct STRUCT_DESC = new TStruct("TFunction");
    private static final TField NAME_FIELD_DESC = new TField("name", 12, 1);
    private static final TField BINARY_TYPE_FIELD_DESC = new TField("binary_type", 8, 2);
    private static final TField ARG_TYPES_FIELD_DESC = new TField("arg_types", 15, 3);
    private static final TField RET_TYPE_FIELD_DESC = new TField("ret_type", 12, 4);
    private static final TField HAS_VAR_ARGS_FIELD_DESC = new TField("has_var_args", 2, 5);
    private static final TField COMMENT_FIELD_DESC = new TField("comment", 11, 6);
    private static final TField SIGNATURE_FIELD_DESC = new TField("signature", 11, 7);
    private static final TField HDFS_LOCATION_FIELD_DESC = new TField("hdfs_location", 11, 8);
    private static final TField SCALAR_FN_FIELD_DESC = new TField("scalar_fn", 12, 9);
    private static final TField AGGREGATE_FN_FIELD_DESC = new TField("aggregate_fn", 12, 10);
    private static final TField ID_FIELD_DESC = new TField("id", 10, 11);
    private static final TField CHECKSUM_FIELD_DESC = new TField("checksum", 11, 12);
    private static final TField VECTORIZED_FIELD_DESC = new TField("vectorized", 2, 13);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TFunctionStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TFunctionTupleSchemeFactory();
    @Nullable
    public TFunctionName name;
    @Nullable
    public TFunctionBinaryType binary_type;
    @Nullable
    public List<TTypeDesc> arg_types;
    @Nullable
    public TTypeDesc ret_type;
    public boolean has_var_args;
    @Nullable
    public String comment;
    @Nullable
    public String signature;
    @Nullable
    public String hdfs_location;
    @Nullable
    public TScalarFunction scalar_fn;
    @Nullable
    public TAggregateFunction aggregate_fn;
    public long id;
    @Nullable
    public String checksum;
    public boolean vectorized;
    private static final int __HAS_VAR_ARGS_ISSET_ID = 0;
    private static final int __ID_ISSET_ID = 1;
    private static final int __VECTORIZED_ISSET_ID = 2;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.COMMENT, _Fields.SIGNATURE, _Fields.HDFS_LOCATION, _Fields.SCALAR_FN, _Fields.AGGREGATE_FN, _Fields.ID, _Fields.CHECKSUM, _Fields.VECTORIZED};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TFunction() {
        this.vectorized = false;
    }

    public TFunction(TFunctionName name, TFunctionBinaryType binary_type, List<TTypeDesc> arg_types, TTypeDesc ret_type, boolean has_var_args) {
        this();
        this.name = name;
        this.binary_type = binary_type;
        this.arg_types = arg_types;
        this.ret_type = ret_type;
        this.has_var_args = has_var_args;
        this.setHasVarArgsIsSet(true);
    }

    public TFunction(TFunction other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetName()) {
            this.name = new TFunctionName(other.name);
        }
        if (other.isSetBinaryType()) {
            this.binary_type = other.binary_type;
        }
        if (other.isSetArgTypes()) {
            ArrayList<TTypeDesc> __this__arg_types = new ArrayList<TTypeDesc>(other.arg_types.size());
            for (TTypeDesc other_element : other.arg_types) {
                __this__arg_types.add(new TTypeDesc(other_element));
            }
            this.arg_types = __this__arg_types;
        }
        if (other.isSetRetType()) {
            this.ret_type = new TTypeDesc(other.ret_type);
        }
        this.has_var_args = other.has_var_args;
        if (other.isSetComment()) {
            this.comment = other.comment;
        }
        if (other.isSetSignature()) {
            this.signature = other.signature;
        }
        if (other.isSetHdfsLocation()) {
            this.hdfs_location = other.hdfs_location;
        }
        if (other.isSetScalarFn()) {
            this.scalar_fn = new TScalarFunction(other.scalar_fn);
        }
        if (other.isSetAggregateFn()) {
            this.aggregate_fn = new TAggregateFunction(other.aggregate_fn);
        }
        this.id = other.id;
        if (other.isSetChecksum()) {
            this.checksum = other.checksum;
        }
        this.vectorized = other.vectorized;
    }

    public TFunction deepCopy() {
        return new TFunction(this);
    }

    public void clear() {
        this.name = null;
        this.binary_type = null;
        this.arg_types = null;
        this.ret_type = null;
        this.setHasVarArgsIsSet(false);
        this.has_var_args = false;
        this.comment = null;
        this.signature = null;
        this.hdfs_location = null;
        this.scalar_fn = null;
        this.aggregate_fn = null;
        this.setIdIsSet(false);
        this.id = 0L;
        this.checksum = null;
        this.vectorized = false;
    }

    @Nullable
    public TFunctionName getName() {
        return this.name;
    }

    public TFunction setName(@Nullable TFunctionName name) {
        this.name = name;
        return this;
    }

    public void unsetName() {
        this.name = null;
    }

    public boolean isSetName() {
        return this.name != null;
    }

    public void setNameIsSet(boolean value) {
        if (!value) {
            this.name = null;
        }
    }

    @Nullable
    public TFunctionBinaryType getBinaryType() {
        return this.binary_type;
    }

    public TFunction setBinaryType(@Nullable TFunctionBinaryType binary_type) {
        this.binary_type = binary_type;
        return this;
    }

    public void unsetBinaryType() {
        this.binary_type = null;
    }

    public boolean isSetBinaryType() {
        return this.binary_type != null;
    }

    public void setBinaryTypeIsSet(boolean value) {
        if (!value) {
            this.binary_type = null;
        }
    }

    public int getArgTypesSize() {
        return this.arg_types == null ? 0 : this.arg_types.size();
    }

    @Nullable
    public Iterator<TTypeDesc> getArgTypesIterator() {
        return this.arg_types == null ? null : this.arg_types.iterator();
    }

    public void addToArgTypes(TTypeDesc elem) {
        if (this.arg_types == null) {
            this.arg_types = new ArrayList<TTypeDesc>();
        }
        this.arg_types.add(elem);
    }

    @Nullable
    public List<TTypeDesc> getArgTypes() {
        return this.arg_types;
    }

    public TFunction setArgTypes(@Nullable List<TTypeDesc> arg_types) {
        this.arg_types = arg_types;
        return this;
    }

    public void unsetArgTypes() {
        this.arg_types = null;
    }

    public boolean isSetArgTypes() {
        return this.arg_types != null;
    }

    public void setArgTypesIsSet(boolean value) {
        if (!value) {
            this.arg_types = null;
        }
    }

    @Nullable
    public TTypeDesc getRetType() {
        return this.ret_type;
    }

    public TFunction setRetType(@Nullable TTypeDesc ret_type) {
        this.ret_type = ret_type;
        return this;
    }

    public void unsetRetType() {
        this.ret_type = null;
    }

    public boolean isSetRetType() {
        return this.ret_type != null;
    }

    public void setRetTypeIsSet(boolean value) {
        if (!value) {
            this.ret_type = null;
        }
    }

    public boolean isHasVarArgs() {
        return this.has_var_args;
    }

    public TFunction setHasVarArgs(boolean has_var_args) {
        this.has_var_args = has_var_args;
        this.setHasVarArgsIsSet(true);
        return this;
    }

    public void unsetHasVarArgs() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetHasVarArgs() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setHasVarArgsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    public TFunction setComment(@Nullable String comment) {
        this.comment = comment;
        return this;
    }

    public void unsetComment() {
        this.comment = null;
    }

    public boolean isSetComment() {
        return this.comment != null;
    }

    public void setCommentIsSet(boolean value) {
        if (!value) {
            this.comment = null;
        }
    }

    @Nullable
    public String getSignature() {
        return this.signature;
    }

    public TFunction setSignature(@Nullable String signature) {
        this.signature = signature;
        return this;
    }

    public void unsetSignature() {
        this.signature = null;
    }

    public boolean isSetSignature() {
        return this.signature != null;
    }

    public void setSignatureIsSet(boolean value) {
        if (!value) {
            this.signature = null;
        }
    }

    @Nullable
    public String getHdfsLocation() {
        return this.hdfs_location;
    }

    public TFunction setHdfsLocation(@Nullable String hdfs_location) {
        this.hdfs_location = hdfs_location;
        return this;
    }

    public void unsetHdfsLocation() {
        this.hdfs_location = null;
    }

    public boolean isSetHdfsLocation() {
        return this.hdfs_location != null;
    }

    public void setHdfsLocationIsSet(boolean value) {
        if (!value) {
            this.hdfs_location = null;
        }
    }

    @Nullable
    public TScalarFunction getScalarFn() {
        return this.scalar_fn;
    }

    public TFunction setScalarFn(@Nullable TScalarFunction scalar_fn) {
        this.scalar_fn = scalar_fn;
        return this;
    }

    public void unsetScalarFn() {
        this.scalar_fn = null;
    }

    public boolean isSetScalarFn() {
        return this.scalar_fn != null;
    }

    public void setScalarFnIsSet(boolean value) {
        if (!value) {
            this.scalar_fn = null;
        }
    }

    @Nullable
    public TAggregateFunction getAggregateFn() {
        return this.aggregate_fn;
    }

    public TFunction setAggregateFn(@Nullable TAggregateFunction aggregate_fn) {
        this.aggregate_fn = aggregate_fn;
        return this;
    }

    public void unsetAggregateFn() {
        this.aggregate_fn = null;
    }

    public boolean isSetAggregateFn() {
        return this.aggregate_fn != null;
    }

    public void setAggregateFnIsSet(boolean value) {
        if (!value) {
            this.aggregate_fn = null;
        }
    }

    public long getId() {
        return this.id;
    }

    public TFunction setId(long id) {
        this.id = id;
        this.setIdIsSet(true);
        return this;
    }

    public void unsetId() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetId() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    @Nullable
    public String getChecksum() {
        return this.checksum;
    }

    public TFunction setChecksum(@Nullable String checksum) {
        this.checksum = checksum;
        return this;
    }

    public void unsetChecksum() {
        this.checksum = null;
    }

    public boolean isSetChecksum() {
        return this.checksum != null;
    }

    public void setChecksumIsSet(boolean value) {
        if (!value) {
            this.checksum = null;
        }
    }

    public boolean isVectorized() {
        return this.vectorized;
    }

    public TFunction setVectorized(boolean vectorized) {
        this.vectorized = vectorized;
        this.setVectorizedIsSet(true);
        return this;
    }

    public void unsetVectorized() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetVectorized() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setVectorizedIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case NAME: {
                if (value == null) {
                    this.unsetName();
                    break;
                }
                this.setName((TFunctionName)value);
                break;
            }
            case BINARY_TYPE: {
                if (value == null) {
                    this.unsetBinaryType();
                    break;
                }
                this.setBinaryType((TFunctionBinaryType)((Object)value));
                break;
            }
            case ARG_TYPES: {
                if (value == null) {
                    this.unsetArgTypes();
                    break;
                }
                this.setArgTypes((List)value);
                break;
            }
            case RET_TYPE: {
                if (value == null) {
                    this.unsetRetType();
                    break;
                }
                this.setRetType((TTypeDesc)value);
                break;
            }
            case HAS_VAR_ARGS: {
                if (value == null) {
                    this.unsetHasVarArgs();
                    break;
                }
                this.setHasVarArgs((Boolean)value);
                break;
            }
            case COMMENT: {
                if (value == null) {
                    this.unsetComment();
                    break;
                }
                this.setComment((String)value);
                break;
            }
            case SIGNATURE: {
                if (value == null) {
                    this.unsetSignature();
                    break;
                }
                this.setSignature((String)value);
                break;
            }
            case HDFS_LOCATION: {
                if (value == null) {
                    this.unsetHdfsLocation();
                    break;
                }
                this.setHdfsLocation((String)value);
                break;
            }
            case SCALAR_FN: {
                if (value == null) {
                    this.unsetScalarFn();
                    break;
                }
                this.setScalarFn((TScalarFunction)value);
                break;
            }
            case AGGREGATE_FN: {
                if (value == null) {
                    this.unsetAggregateFn();
                    break;
                }
                this.setAggregateFn((TAggregateFunction)value);
                break;
            }
            case ID: {
                if (value == null) {
                    this.unsetId();
                    break;
                }
                this.setId((Long)value);
                break;
            }
            case CHECKSUM: {
                if (value == null) {
                    this.unsetChecksum();
                    break;
                }
                this.setChecksum((String)value);
                break;
            }
            case VECTORIZED: {
                if (value == null) {
                    this.unsetVectorized();
                    break;
                }
                this.setVectorized((Boolean)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case NAME: {
                return this.getName();
            }
            case BINARY_TYPE: {
                return this.getBinaryType();
            }
            case ARG_TYPES: {
                return this.getArgTypes();
            }
            case RET_TYPE: {
                return this.getRetType();
            }
            case HAS_VAR_ARGS: {
                return this.isHasVarArgs();
            }
            case COMMENT: {
                return this.getComment();
            }
            case SIGNATURE: {
                return this.getSignature();
            }
            case HDFS_LOCATION: {
                return this.getHdfsLocation();
            }
            case SCALAR_FN: {
                return this.getScalarFn();
            }
            case AGGREGATE_FN: {
                return this.getAggregateFn();
            }
            case ID: {
                return this.getId();
            }
            case CHECKSUM: {
                return this.getChecksum();
            }
            case VECTORIZED: {
                return this.isVectorized();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case NAME: {
                return this.isSetName();
            }
            case BINARY_TYPE: {
                return this.isSetBinaryType();
            }
            case ARG_TYPES: {
                return this.isSetArgTypes();
            }
            case RET_TYPE: {
                return this.isSetRetType();
            }
            case HAS_VAR_ARGS: {
                return this.isSetHasVarArgs();
            }
            case COMMENT: {
                return this.isSetComment();
            }
            case SIGNATURE: {
                return this.isSetSignature();
            }
            case HDFS_LOCATION: {
                return this.isSetHdfsLocation();
            }
            case SCALAR_FN: {
                return this.isSetScalarFn();
            }
            case AGGREGATE_FN: {
                return this.isSetAggregateFn();
            }
            case ID: {
                return this.isSetId();
            }
            case CHECKSUM: {
                return this.isSetChecksum();
            }
            case VECTORIZED: {
                return this.isSetVectorized();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof TFunction) {
            return this.equals((TFunction)that);
        }
        return false;
    }

    public boolean equals(TFunction that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_name = this.isSetName();
        boolean that_present_name = that.isSetName();
        if (this_present_name || that_present_name) {
            if (!this_present_name || !that_present_name) {
                return false;
            }
            if (!this.name.equals(that.name)) {
                return false;
            }
        }
        boolean this_present_binary_type = this.isSetBinaryType();
        boolean that_present_binary_type = that.isSetBinaryType();
        if (this_present_binary_type || that_present_binary_type) {
            if (!this_present_binary_type || !that_present_binary_type) {
                return false;
            }
            if (!this.binary_type.equals((Object)that.binary_type)) {
                return false;
            }
        }
        boolean this_present_arg_types = this.isSetArgTypes();
        boolean that_present_arg_types = that.isSetArgTypes();
        if (this_present_arg_types || that_present_arg_types) {
            if (!this_present_arg_types || !that_present_arg_types) {
                return false;
            }
            if (!this.arg_types.equals(that.arg_types)) {
                return false;
            }
        }
        boolean this_present_ret_type = this.isSetRetType();
        boolean that_present_ret_type = that.isSetRetType();
        if (this_present_ret_type || that_present_ret_type) {
            if (!this_present_ret_type || !that_present_ret_type) {
                return false;
            }
            if (!this.ret_type.equals(that.ret_type)) {
                return false;
            }
        }
        boolean this_present_has_var_args = true;
        boolean that_present_has_var_args = true;
        if (this_present_has_var_args || that_present_has_var_args) {
            if (!this_present_has_var_args || !that_present_has_var_args) {
                return false;
            }
            if (this.has_var_args != that.has_var_args) {
                return false;
            }
        }
        boolean this_present_comment = this.isSetComment();
        boolean that_present_comment = that.isSetComment();
        if (this_present_comment || that_present_comment) {
            if (!this_present_comment || !that_present_comment) {
                return false;
            }
            if (!this.comment.equals(that.comment)) {
                return false;
            }
        }
        boolean this_present_signature = this.isSetSignature();
        boolean that_present_signature = that.isSetSignature();
        if (this_present_signature || that_present_signature) {
            if (!this_present_signature || !that_present_signature) {
                return false;
            }
            if (!this.signature.equals(that.signature)) {
                return false;
            }
        }
        boolean this_present_hdfs_location = this.isSetHdfsLocation();
        boolean that_present_hdfs_location = that.isSetHdfsLocation();
        if (this_present_hdfs_location || that_present_hdfs_location) {
            if (!this_present_hdfs_location || !that_present_hdfs_location) {
                return false;
            }
            if (!this.hdfs_location.equals(that.hdfs_location)) {
                return false;
            }
        }
        boolean this_present_scalar_fn = this.isSetScalarFn();
        boolean that_present_scalar_fn = that.isSetScalarFn();
        if (this_present_scalar_fn || that_present_scalar_fn) {
            if (!this_present_scalar_fn || !that_present_scalar_fn) {
                return false;
            }
            if (!this.scalar_fn.equals(that.scalar_fn)) {
                return false;
            }
        }
        boolean this_present_aggregate_fn = this.isSetAggregateFn();
        boolean that_present_aggregate_fn = that.isSetAggregateFn();
        if (this_present_aggregate_fn || that_present_aggregate_fn) {
            if (!this_present_aggregate_fn || !that_present_aggregate_fn) {
                return false;
            }
            if (!this.aggregate_fn.equals(that.aggregate_fn)) {
                return false;
            }
        }
        boolean this_present_id = this.isSetId();
        boolean that_present_id = that.isSetId();
        if (this_present_id || that_present_id) {
            if (!this_present_id || !that_present_id) {
                return false;
            }
            if (this.id != that.id) {
                return false;
            }
        }
        boolean this_present_checksum = this.isSetChecksum();
        boolean that_present_checksum = that.isSetChecksum();
        if (this_present_checksum || that_present_checksum) {
            if (!this_present_checksum || !that_present_checksum) {
                return false;
            }
            if (!this.checksum.equals(that.checksum)) {
                return false;
            }
        }
        boolean this_present_vectorized = this.isSetVectorized();
        boolean that_present_vectorized = that.isSetVectorized();
        if (this_present_vectorized || that_present_vectorized) {
            if (!this_present_vectorized || !that_present_vectorized) {
                return false;
            }
            if (this.vectorized != that.vectorized) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetName() ? 131071 : 524287);
        if (this.isSetName()) {
            hashCode = hashCode * 8191 + this.name.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetBinaryType() ? 131071 : 524287);
        if (this.isSetBinaryType()) {
            hashCode = hashCode * 8191 + this.binary_type.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetArgTypes() ? 131071 : 524287);
        if (this.isSetArgTypes()) {
            hashCode = hashCode * 8191 + this.arg_types.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetRetType() ? 131071 : 524287);
        if (this.isSetRetType()) {
            hashCode = hashCode * 8191 + this.ret_type.hashCode();
        }
        hashCode = hashCode * 8191 + (this.has_var_args ? 131071 : 524287);
        hashCode = hashCode * 8191 + (this.isSetComment() ? 131071 : 524287);
        if (this.isSetComment()) {
            hashCode = hashCode * 8191 + this.comment.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetSignature() ? 131071 : 524287);
        if (this.isSetSignature()) {
            hashCode = hashCode * 8191 + this.signature.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetHdfsLocation() ? 131071 : 524287);
        if (this.isSetHdfsLocation()) {
            hashCode = hashCode * 8191 + this.hdfs_location.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetScalarFn() ? 131071 : 524287);
        if (this.isSetScalarFn()) {
            hashCode = hashCode * 8191 + this.scalar_fn.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetAggregateFn() ? 131071 : 524287);
        if (this.isSetAggregateFn()) {
            hashCode = hashCode * 8191 + this.aggregate_fn.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetId() ? 131071 : 524287);
        if (this.isSetId()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.id);
        }
        hashCode = hashCode * 8191 + (this.isSetChecksum() ? 131071 : 524287);
        if (this.isSetChecksum()) {
            hashCode = hashCode * 8191 + this.checksum.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetVectorized() ? 131071 : 524287);
        if (this.isSetVectorized()) {
            hashCode = hashCode * 8191 + (this.vectorized ? 131071 : 524287);
        }
        return hashCode;
    }

    @Override
    public int compareTo(TFunction other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetName(), other.isSetName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetName() && (lastComparison = TBaseHelper.compareTo((Comparable)this.name, (Comparable)other.name)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetBinaryType(), other.isSetBinaryType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBinaryType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.binary_type), (Comparable)((Object)other.binary_type))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetArgTypes(), other.isSetArgTypes());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetArgTypes() && (lastComparison = TBaseHelper.compareTo(this.arg_types, other.arg_types)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetRetType(), other.isSetRetType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetRetType() && (lastComparison = TBaseHelper.compareTo((Comparable)this.ret_type, (Comparable)other.ret_type)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetHasVarArgs(), other.isSetHasVarArgs());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetHasVarArgs() && (lastComparison = TBaseHelper.compareTo((boolean)this.has_var_args, (boolean)other.has_var_args)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetComment(), other.isSetComment());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetComment() && (lastComparison = TBaseHelper.compareTo((String)this.comment, (String)other.comment)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetSignature(), other.isSetSignature());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSignature() && (lastComparison = TBaseHelper.compareTo((String)this.signature, (String)other.signature)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetHdfsLocation(), other.isSetHdfsLocation());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetHdfsLocation() && (lastComparison = TBaseHelper.compareTo((String)this.hdfs_location, (String)other.hdfs_location)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetScalarFn(), other.isSetScalarFn());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetScalarFn() && (lastComparison = TBaseHelper.compareTo((Comparable)this.scalar_fn, (Comparable)other.scalar_fn)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetAggregateFn(), other.isSetAggregateFn());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAggregateFn() && (lastComparison = TBaseHelper.compareTo((Comparable)this.aggregate_fn, (Comparable)other.aggregate_fn)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetId(), other.isSetId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetId() && (lastComparison = TBaseHelper.compareTo((long)this.id, (long)other.id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetChecksum(), other.isSetChecksum());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetChecksum() && (lastComparison = TBaseHelper.compareTo((String)this.checksum, (String)other.checksum)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetVectorized(), other.isSetVectorized());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetVectorized() && (lastComparison = TBaseHelper.compareTo((boolean)this.vectorized, (boolean)other.vectorized)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        TFunction.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        TFunction.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TFunction(");
        boolean first = true;
        sb.append("name:");
        if (this.name == null) {
            sb.append("null");
        } else {
            sb.append(this.name);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("binary_type:");
        if (this.binary_type == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.binary_type);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("arg_types:");
        if (this.arg_types == null) {
            sb.append("null");
        } else {
            sb.append(this.arg_types);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("ret_type:");
        if (this.ret_type == null) {
            sb.append("null");
        } else {
            sb.append(this.ret_type);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("has_var_args:");
        sb.append(this.has_var_args);
        first = false;
        if (this.isSetComment()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("comment:");
            if (this.comment == null) {
                sb.append("null");
            } else {
                sb.append(this.comment);
            }
            first = false;
        }
        if (this.isSetSignature()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("signature:");
            if (this.signature == null) {
                sb.append("null");
            } else {
                sb.append(this.signature);
            }
            first = false;
        }
        if (this.isSetHdfsLocation()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("hdfs_location:");
            if (this.hdfs_location == null) {
                sb.append("null");
            } else {
                sb.append(this.hdfs_location);
            }
            first = false;
        }
        if (this.isSetScalarFn()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("scalar_fn:");
            if (this.scalar_fn == null) {
                sb.append("null");
            } else {
                sb.append(this.scalar_fn);
            }
            first = false;
        }
        if (this.isSetAggregateFn()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("aggregate_fn:");
            if (this.aggregate_fn == null) {
                sb.append("null");
            } else {
                sb.append(this.aggregate_fn);
            }
            first = false;
        }
        if (this.isSetId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("id:");
            sb.append(this.id);
            first = false;
        }
        if (this.isSetChecksum()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("checksum:");
            if (this.checksum == null) {
                sb.append("null");
            } else {
                sb.append(this.checksum);
            }
            first = false;
        }
        if (this.isSetVectorized()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("vectorized:");
            sb.append(this.vectorized);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.name == null) {
            throw new TProtocolException("Required field 'name' was not present! Struct: " + this.toString());
        }
        if (this.binary_type == null) {
            throw new TProtocolException("Required field 'binary_type' was not present! Struct: " + this.toString());
        }
        if (this.arg_types == null) {
            throw new TProtocolException("Required field 'arg_types' was not present! Struct: " + this.toString());
        }
        if (this.ret_type == null) {
            throw new TProtocolException("Required field 'ret_type' was not present! Struct: " + this.toString());
        }
        if (this.name != null) {
            this.name.validate();
        }
        if (this.ret_type != null) {
            this.ret_type.validate();
        }
        if (this.scalar_fn != null) {
            this.scalar_fn.validate();
        }
        if (this.aggregate_fn != null) {
            this.aggregate_fn.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.NAME, new FieldMetaData("name", 1, (FieldValueMetaData)new StructMetaData(12, TFunctionName.class)));
        tmpMap.put(_Fields.BINARY_TYPE, new FieldMetaData("binary_type", 1, (FieldValueMetaData)new EnumMetaData(16, TFunctionBinaryType.class)));
        tmpMap.put(_Fields.ARG_TYPES, new FieldMetaData("arg_types", 1, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, TTypeDesc.class))));
        tmpMap.put(_Fields.RET_TYPE, new FieldMetaData("ret_type", 1, (FieldValueMetaData)new StructMetaData(12, TTypeDesc.class)));
        tmpMap.put(_Fields.HAS_VAR_ARGS, new FieldMetaData("has_var_args", 1, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.COMMENT, new FieldMetaData("comment", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.SIGNATURE, new FieldMetaData("signature", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.HDFS_LOCATION, new FieldMetaData("hdfs_location", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.SCALAR_FN, new FieldMetaData("scalar_fn", 2, (FieldValueMetaData)new StructMetaData(12, TScalarFunction.class)));
        tmpMap.put(_Fields.AGGREGATE_FN, new FieldMetaData("aggregate_fn", 2, (FieldValueMetaData)new StructMetaData(12, TAggregateFunction.class)));
        tmpMap.put(_Fields.ID, new FieldMetaData("id", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.CHECKSUM, new FieldMetaData("checksum", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.VECTORIZED, new FieldMetaData("vectorized", 2, new FieldValueMetaData(2)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TFunction.class, metaDataMap);
    }

    private static class TFunctionTupleScheme
    extends TupleScheme<TFunction> {
        private TFunctionTupleScheme() {
        }

        public void write(TProtocol prot, TFunction struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            struct.name.write((TProtocol)oprot);
            oprot.writeI32(struct.binary_type.getValue());
            oprot.writeI32(struct.arg_types.size());
            for (TTypeDesc _iter36 : struct.arg_types) {
                _iter36.write((TProtocol)oprot);
            }
            struct.ret_type.write((TProtocol)oprot);
            oprot.writeBool(struct.has_var_args);
            BitSet optionals = new BitSet();
            if (struct.isSetComment()) {
                optionals.set(0);
            }
            if (struct.isSetSignature()) {
                optionals.set(1);
            }
            if (struct.isSetHdfsLocation()) {
                optionals.set(2);
            }
            if (struct.isSetScalarFn()) {
                optionals.set(3);
            }
            if (struct.isSetAggregateFn()) {
                optionals.set(4);
            }
            if (struct.isSetId()) {
                optionals.set(5);
            }
            if (struct.isSetChecksum()) {
                optionals.set(6);
            }
            if (struct.isSetVectorized()) {
                optionals.set(7);
            }
            oprot.writeBitSet(optionals, 8);
            if (struct.isSetComment()) {
                oprot.writeString(struct.comment);
            }
            if (struct.isSetSignature()) {
                oprot.writeString(struct.signature);
            }
            if (struct.isSetHdfsLocation()) {
                oprot.writeString(struct.hdfs_location);
            }
            if (struct.isSetScalarFn()) {
                struct.scalar_fn.write((TProtocol)oprot);
            }
            if (struct.isSetAggregateFn()) {
                struct.aggregate_fn.write((TProtocol)oprot);
            }
            if (struct.isSetId()) {
                oprot.writeI64(struct.id);
            }
            if (struct.isSetChecksum()) {
                oprot.writeString(struct.checksum);
            }
            if (struct.isSetVectorized()) {
                oprot.writeBool(struct.vectorized);
            }
        }

        public void read(TProtocol prot, TFunction struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.name = new TFunctionName();
            struct.name.read((TProtocol)iprot);
            struct.setNameIsSet(true);
            struct.binary_type = TFunctionBinaryType.findByValue(iprot.readI32());
            struct.setBinaryTypeIsSet(true);
            TList _list37 = iprot.readListBegin((byte)12);
            struct.arg_types = new ArrayList<TTypeDesc>(_list37.size);
            for (int _i39 = 0; _i39 < _list37.size; ++_i39) {
                TTypeDesc _elem38 = new TTypeDesc();
                _elem38.read((TProtocol)iprot);
                struct.arg_types.add(_elem38);
            }
            struct.setArgTypesIsSet(true);
            struct.ret_type = new TTypeDesc();
            struct.ret_type.read((TProtocol)iprot);
            struct.setRetTypeIsSet(true);
            struct.has_var_args = iprot.readBool();
            struct.setHasVarArgsIsSet(true);
            BitSet incoming = iprot.readBitSet(8);
            if (incoming.get(0)) {
                struct.comment = iprot.readString();
                struct.setCommentIsSet(true);
            }
            if (incoming.get(1)) {
                struct.signature = iprot.readString();
                struct.setSignatureIsSet(true);
            }
            if (incoming.get(2)) {
                struct.hdfs_location = iprot.readString();
                struct.setHdfsLocationIsSet(true);
            }
            if (incoming.get(3)) {
                struct.scalar_fn = new TScalarFunction();
                struct.scalar_fn.read((TProtocol)iprot);
                struct.setScalarFnIsSet(true);
            }
            if (incoming.get(4)) {
                struct.aggregate_fn = new TAggregateFunction();
                struct.aggregate_fn.read((TProtocol)iprot);
                struct.setAggregateFnIsSet(true);
            }
            if (incoming.get(5)) {
                struct.id = iprot.readI64();
                struct.setIdIsSet(true);
            }
            if (incoming.get(6)) {
                struct.checksum = iprot.readString();
                struct.setChecksumIsSet(true);
            }
            if (incoming.get(7)) {
                struct.vectorized = iprot.readBool();
                struct.setVectorizedIsSet(true);
            }
        }
    }

    private static class TFunctionTupleSchemeFactory
    implements SchemeFactory {
        private TFunctionTupleSchemeFactory() {
        }

        public TFunctionTupleScheme getScheme() {
            return new TFunctionTupleScheme();
        }
    }

    private static class TFunctionStandardScheme
    extends StandardScheme<TFunction> {
        private TFunctionStandardScheme() {
        }

        public void read(TProtocol iprot, TFunction struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 12) {
                            struct.name = new TFunctionName();
                            struct.name.read(iprot);
                            struct.setNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 8) {
                            struct.binary_type = TFunctionBinaryType.findByValue(iprot.readI32());
                            struct.setBinaryTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 15) {
                            TList _list32 = iprot.readListBegin();
                            struct.arg_types = new ArrayList<TTypeDesc>(_list32.size);
                            for (int _i34 = 0; _i34 < _list32.size; ++_i34) {
                                TTypeDesc _elem33 = new TTypeDesc();
                                _elem33.read(iprot);
                                struct.arg_types.add(_elem33);
                            }
                            iprot.readListEnd();
                            struct.setArgTypesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 12) {
                            struct.ret_type = new TTypeDesc();
                            struct.ret_type.read(iprot);
                            struct.setRetTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 2) {
                            struct.has_var_args = iprot.readBool();
                            struct.setHasVarArgsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 11) {
                            struct.comment = iprot.readString();
                            struct.setCommentIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 11) {
                            struct.signature = iprot.readString();
                            struct.setSignatureIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 11) {
                            struct.hdfs_location = iprot.readString();
                            struct.setHdfsLocationIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 12) {
                            struct.scalar_fn = new TScalarFunction();
                            struct.scalar_fn.read(iprot);
                            struct.setScalarFnIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 12) {
                            struct.aggregate_fn = new TAggregateFunction();
                            struct.aggregate_fn.read(iprot);
                            struct.setAggregateFnIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 10) {
                            struct.id = iprot.readI64();
                            struct.setIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 11) {
                            struct.checksum = iprot.readString();
                            struct.setChecksumIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 13: {
                        if (schemeField.type == 2) {
                            struct.vectorized = iprot.readBool();
                            struct.setVectorizedIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetHasVarArgs()) {
                throw new TProtocolException("Required field 'has_var_args' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            struct.validate();
        }

        public void write(TProtocol oprot, TFunction struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.name != null) {
                oprot.writeFieldBegin(NAME_FIELD_DESC);
                struct.name.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.binary_type != null) {
                oprot.writeFieldBegin(BINARY_TYPE_FIELD_DESC);
                oprot.writeI32(struct.binary_type.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.arg_types != null) {
                oprot.writeFieldBegin(ARG_TYPES_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.arg_types.size()));
                for (TTypeDesc _iter35 : struct.arg_types) {
                    _iter35.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.ret_type != null) {
                oprot.writeFieldBegin(RET_TYPE_FIELD_DESC);
                struct.ret_type.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(HAS_VAR_ARGS_FIELD_DESC);
            oprot.writeBool(struct.has_var_args);
            oprot.writeFieldEnd();
            if (struct.comment != null && struct.isSetComment()) {
                oprot.writeFieldBegin(COMMENT_FIELD_DESC);
                oprot.writeString(struct.comment);
                oprot.writeFieldEnd();
            }
            if (struct.signature != null && struct.isSetSignature()) {
                oprot.writeFieldBegin(SIGNATURE_FIELD_DESC);
                oprot.writeString(struct.signature);
                oprot.writeFieldEnd();
            }
            if (struct.hdfs_location != null && struct.isSetHdfsLocation()) {
                oprot.writeFieldBegin(HDFS_LOCATION_FIELD_DESC);
                oprot.writeString(struct.hdfs_location);
                oprot.writeFieldEnd();
            }
            if (struct.scalar_fn != null && struct.isSetScalarFn()) {
                oprot.writeFieldBegin(SCALAR_FN_FIELD_DESC);
                struct.scalar_fn.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.aggregate_fn != null && struct.isSetAggregateFn()) {
                oprot.writeFieldBegin(AGGREGATE_FN_FIELD_DESC);
                struct.aggregate_fn.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.isSetId()) {
                oprot.writeFieldBegin(ID_FIELD_DESC);
                oprot.writeI64(struct.id);
                oprot.writeFieldEnd();
            }
            if (struct.checksum != null && struct.isSetChecksum()) {
                oprot.writeFieldBegin(CHECKSUM_FIELD_DESC);
                oprot.writeString(struct.checksum);
                oprot.writeFieldEnd();
            }
            if (struct.isSetVectorized()) {
                oprot.writeFieldBegin(VECTORIZED_FIELD_DESC);
                oprot.writeBool(struct.vectorized);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TFunctionStandardSchemeFactory
    implements SchemeFactory {
        private TFunctionStandardSchemeFactory() {
        }

        public TFunctionStandardScheme getScheme() {
            return new TFunctionStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        NAME(1, "name"),
        BINARY_TYPE(2, "binary_type"),
        ARG_TYPES(3, "arg_types"),
        RET_TYPE(4, "ret_type"),
        HAS_VAR_ARGS(5, "has_var_args"),
        COMMENT(6, "comment"),
        SIGNATURE(7, "signature"),
        HDFS_LOCATION(8, "hdfs_location"),
        SCALAR_FN(9, "scalar_fn"),
        AGGREGATE_FN(10, "aggregate_fn"),
        ID(11, "id"),
        CHECKSUM(12, "checksum"),
        VECTORIZED(13, "vectorized");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return NAME;
                }
                case 2: {
                    return BINARY_TYPE;
                }
                case 3: {
                    return ARG_TYPES;
                }
                case 4: {
                    return RET_TYPE;
                }
                case 5: {
                    return HAS_VAR_ARGS;
                }
                case 6: {
                    return COMMENT;
                }
                case 7: {
                    return SIGNATURE;
                }
                case 8: {
                    return HDFS_LOCATION;
                }
                case 9: {
                    return SCALAR_FN;
                }
                case 10: {
                    return AGGREGATE_FN;
                }
                case 11: {
                    return ID;
                }
                case 12: {
                    return CHECKSUM;
                }
                case 13: {
                    return VECTORIZED;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

