/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.doris.thrift.TFileCompressType;
import org.apache.doris.thrift.TFileType;
import org.apache.doris.thrift.TTableFormatFileDesc;
import org.apache.doris.thrift.TUniqueId;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TFileRangeDesc
implements TBase<TFileRangeDesc, _Fields>,
Serializable,
Cloneable,
Comparable<TFileRangeDesc> {
    private static final TStruct STRUCT_DESC = new TStruct("TFileRangeDesc");
    private static final TField LOAD_ID_FIELD_DESC = new TField("load_id", 12, 1);
    private static final TField PATH_FIELD_DESC = new TField("path", 11, 2);
    private static final TField START_OFFSET_FIELD_DESC = new TField("start_offset", 10, 3);
    private static final TField SIZE_FIELD_DESC = new TField("size", 10, 4);
    private static final TField FILE_SIZE_FIELD_DESC = new TField("file_size", 10, 5);
    private static final TField COLUMNS_FROM_PATH_FIELD_DESC = new TField("columns_from_path", 15, 6);
    private static final TField COLUMNS_FROM_PATH_KEYS_FIELD_DESC = new TField("columns_from_path_keys", 15, 7);
    private static final TField TABLE_FORMAT_PARAMS_FIELD_DESC = new TField("table_format_params", 12, 8);
    private static final TField MODIFICATION_TIME_FIELD_DESC = new TField("modification_time", 10, 9);
    private static final TField FILE_TYPE_FIELD_DESC = new TField("file_type", 8, 10);
    private static final TField COMPRESS_TYPE_FIELD_DESC = new TField("compress_type", 8, 11);
    private static final TField FS_NAME_FIELD_DESC = new TField("fs_name", 11, 12);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TFileRangeDescStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TFileRangeDescTupleSchemeFactory();
    @Nullable
    public TUniqueId load_id;
    @Nullable
    public String path;
    public long start_offset;
    public long size;
    public long file_size;
    @Nullable
    public List<String> columns_from_path;
    @Nullable
    public List<String> columns_from_path_keys;
    @Nullable
    public TTableFormatFileDesc table_format_params;
    public long modification_time;
    @Nullable
    public TFileType file_type;
    @Nullable
    public TFileCompressType compress_type;
    @Nullable
    public String fs_name;
    private static final int __START_OFFSET_ISSET_ID = 0;
    private static final int __SIZE_ISSET_ID = 1;
    private static final int __FILE_SIZE_ISSET_ID = 2;
    private static final int __MODIFICATION_TIME_ISSET_ID = 3;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.LOAD_ID, _Fields.PATH, _Fields.START_OFFSET, _Fields.SIZE, _Fields.FILE_SIZE, _Fields.COLUMNS_FROM_PATH, _Fields.COLUMNS_FROM_PATH_KEYS, _Fields.TABLE_FORMAT_PARAMS, _Fields.MODIFICATION_TIME, _Fields.FILE_TYPE, _Fields.COMPRESS_TYPE, _Fields.FS_NAME};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TFileRangeDesc() {
        this.file_size = -1L;
    }

    public TFileRangeDesc(TFileRangeDesc other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetLoadId()) {
            this.load_id = new TUniqueId(other.load_id);
        }
        if (other.isSetPath()) {
            this.path = other.path;
        }
        this.start_offset = other.start_offset;
        this.size = other.size;
        this.file_size = other.file_size;
        if (other.isSetColumnsFromPath()) {
            ArrayList<String> __this__columns_from_path = new ArrayList<String>(other.columns_from_path);
            this.columns_from_path = __this__columns_from_path;
        }
        if (other.isSetColumnsFromPathKeys()) {
            ArrayList<String> __this__columns_from_path_keys = new ArrayList<String>(other.columns_from_path_keys);
            this.columns_from_path_keys = __this__columns_from_path_keys;
        }
        if (other.isSetTableFormatParams()) {
            this.table_format_params = new TTableFormatFileDesc(other.table_format_params);
        }
        this.modification_time = other.modification_time;
        if (other.isSetFileType()) {
            this.file_type = other.file_type;
        }
        if (other.isSetCompressType()) {
            this.compress_type = other.compress_type;
        }
        if (other.isSetFsName()) {
            this.fs_name = other.fs_name;
        }
    }

    public TFileRangeDesc deepCopy() {
        return new TFileRangeDesc(this);
    }

    public void clear() {
        this.load_id = null;
        this.path = null;
        this.setStartOffsetIsSet(false);
        this.start_offset = 0L;
        this.setSizeIsSet(false);
        this.size = 0L;
        this.file_size = -1L;
        this.columns_from_path = null;
        this.columns_from_path_keys = null;
        this.table_format_params = null;
        this.setModificationTimeIsSet(false);
        this.modification_time = 0L;
        this.file_type = null;
        this.compress_type = null;
        this.fs_name = null;
    }

    @Nullable
    public TUniqueId getLoadId() {
        return this.load_id;
    }

    public TFileRangeDesc setLoadId(@Nullable TUniqueId load_id) {
        this.load_id = load_id;
        return this;
    }

    public void unsetLoadId() {
        this.load_id = null;
    }

    public boolean isSetLoadId() {
        return this.load_id != null;
    }

    public void setLoadIdIsSet(boolean value) {
        if (!value) {
            this.load_id = null;
        }
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    public TFileRangeDesc setPath(@Nullable String path) {
        this.path = path;
        return this;
    }

    public void unsetPath() {
        this.path = null;
    }

    public boolean isSetPath() {
        return this.path != null;
    }

    public void setPathIsSet(boolean value) {
        if (!value) {
            this.path = null;
        }
    }

    public long getStartOffset() {
        return this.start_offset;
    }

    public TFileRangeDesc setStartOffset(long start_offset) {
        this.start_offset = start_offset;
        this.setStartOffsetIsSet(true);
        return this;
    }

    public void unsetStartOffset() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetStartOffset() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setStartOffsetIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public long getSize() {
        return this.size;
    }

    public TFileRangeDesc setSize(long size) {
        this.size = size;
        this.setSizeIsSet(true);
        return this;
    }

    public void unsetSize() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetSize() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setSizeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public long getFileSize() {
        return this.file_size;
    }

    public TFileRangeDesc setFileSize(long file_size) {
        this.file_size = file_size;
        this.setFileSizeIsSet(true);
        return this;
    }

    public void unsetFileSize() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetFileSize() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setFileSizeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public int getColumnsFromPathSize() {
        return this.columns_from_path == null ? 0 : this.columns_from_path.size();
    }

    @Nullable
    public Iterator<String> getColumnsFromPathIterator() {
        return this.columns_from_path == null ? null : this.columns_from_path.iterator();
    }

    public void addToColumnsFromPath(String elem) {
        if (this.columns_from_path == null) {
            this.columns_from_path = new ArrayList<String>();
        }
        this.columns_from_path.add(elem);
    }

    @Nullable
    public List<String> getColumnsFromPath() {
        return this.columns_from_path;
    }

    public TFileRangeDesc setColumnsFromPath(@Nullable List<String> columns_from_path) {
        this.columns_from_path = columns_from_path;
        return this;
    }

    public void unsetColumnsFromPath() {
        this.columns_from_path = null;
    }

    public boolean isSetColumnsFromPath() {
        return this.columns_from_path != null;
    }

    public void setColumnsFromPathIsSet(boolean value) {
        if (!value) {
            this.columns_from_path = null;
        }
    }

    public int getColumnsFromPathKeysSize() {
        return this.columns_from_path_keys == null ? 0 : this.columns_from_path_keys.size();
    }

    @Nullable
    public Iterator<String> getColumnsFromPathKeysIterator() {
        return this.columns_from_path_keys == null ? null : this.columns_from_path_keys.iterator();
    }

    public void addToColumnsFromPathKeys(String elem) {
        if (this.columns_from_path_keys == null) {
            this.columns_from_path_keys = new ArrayList<String>();
        }
        this.columns_from_path_keys.add(elem);
    }

    @Nullable
    public List<String> getColumnsFromPathKeys() {
        return this.columns_from_path_keys;
    }

    public TFileRangeDesc setColumnsFromPathKeys(@Nullable List<String> columns_from_path_keys) {
        this.columns_from_path_keys = columns_from_path_keys;
        return this;
    }

    public void unsetColumnsFromPathKeys() {
        this.columns_from_path_keys = null;
    }

    public boolean isSetColumnsFromPathKeys() {
        return this.columns_from_path_keys != null;
    }

    public void setColumnsFromPathKeysIsSet(boolean value) {
        if (!value) {
            this.columns_from_path_keys = null;
        }
    }

    @Nullable
    public TTableFormatFileDesc getTableFormatParams() {
        return this.table_format_params;
    }

    public TFileRangeDesc setTableFormatParams(@Nullable TTableFormatFileDesc table_format_params) {
        this.table_format_params = table_format_params;
        return this;
    }

    public void unsetTableFormatParams() {
        this.table_format_params = null;
    }

    public boolean isSetTableFormatParams() {
        return this.table_format_params != null;
    }

    public void setTableFormatParamsIsSet(boolean value) {
        if (!value) {
            this.table_format_params = null;
        }
    }

    public long getModificationTime() {
        return this.modification_time;
    }

    public TFileRangeDesc setModificationTime(long modification_time) {
        this.modification_time = modification_time;
        this.setModificationTimeIsSet(true);
        return this;
    }

    public void unsetModificationTime() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)3);
    }

    public boolean isSetModificationTime() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)3);
    }

    public void setModificationTimeIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)3, (boolean)value);
    }

    @Nullable
    public TFileType getFileType() {
        return this.file_type;
    }

    public TFileRangeDesc setFileType(@Nullable TFileType file_type) {
        this.file_type = file_type;
        return this;
    }

    public void unsetFileType() {
        this.file_type = null;
    }

    public boolean isSetFileType() {
        return this.file_type != null;
    }

    public void setFileTypeIsSet(boolean value) {
        if (!value) {
            this.file_type = null;
        }
    }

    @Nullable
    public TFileCompressType getCompressType() {
        return this.compress_type;
    }

    public TFileRangeDesc setCompressType(@Nullable TFileCompressType compress_type) {
        this.compress_type = compress_type;
        return this;
    }

    public void unsetCompressType() {
        this.compress_type = null;
    }

    public boolean isSetCompressType() {
        return this.compress_type != null;
    }

    public void setCompressTypeIsSet(boolean value) {
        if (!value) {
            this.compress_type = null;
        }
    }

    @Nullable
    public String getFsName() {
        return this.fs_name;
    }

    public TFileRangeDesc setFsName(@Nullable String fs_name) {
        this.fs_name = fs_name;
        return this;
    }

    public void unsetFsName() {
        this.fs_name = null;
    }

    public boolean isSetFsName() {
        return this.fs_name != null;
    }

    public void setFsNameIsSet(boolean value) {
        if (!value) {
            this.fs_name = null;
        }
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case LOAD_ID: {
                if (value == null) {
                    this.unsetLoadId();
                    break;
                }
                this.setLoadId((TUniqueId)value);
                break;
            }
            case PATH: {
                if (value == null) {
                    this.unsetPath();
                    break;
                }
                this.setPath((String)value);
                break;
            }
            case START_OFFSET: {
                if (value == null) {
                    this.unsetStartOffset();
                    break;
                }
                this.setStartOffset((Long)value);
                break;
            }
            case SIZE: {
                if (value == null) {
                    this.unsetSize();
                    break;
                }
                this.setSize((Long)value);
                break;
            }
            case FILE_SIZE: {
                if (value == null) {
                    this.unsetFileSize();
                    break;
                }
                this.setFileSize((Long)value);
                break;
            }
            case COLUMNS_FROM_PATH: {
                if (value == null) {
                    this.unsetColumnsFromPath();
                    break;
                }
                this.setColumnsFromPath((List)value);
                break;
            }
            case COLUMNS_FROM_PATH_KEYS: {
                if (value == null) {
                    this.unsetColumnsFromPathKeys();
                    break;
                }
                this.setColumnsFromPathKeys((List)value);
                break;
            }
            case TABLE_FORMAT_PARAMS: {
                if (value == null) {
                    this.unsetTableFormatParams();
                    break;
                }
                this.setTableFormatParams((TTableFormatFileDesc)value);
                break;
            }
            case MODIFICATION_TIME: {
                if (value == null) {
                    this.unsetModificationTime();
                    break;
                }
                this.setModificationTime((Long)value);
                break;
            }
            case FILE_TYPE: {
                if (value == null) {
                    this.unsetFileType();
                    break;
                }
                this.setFileType((TFileType)((Object)value));
                break;
            }
            case COMPRESS_TYPE: {
                if (value == null) {
                    this.unsetCompressType();
                    break;
                }
                this.setCompressType((TFileCompressType)((Object)value));
                break;
            }
            case FS_NAME: {
                if (value == null) {
                    this.unsetFsName();
                    break;
                }
                this.setFsName((String)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case LOAD_ID: {
                return this.getLoadId();
            }
            case PATH: {
                return this.getPath();
            }
            case START_OFFSET: {
                return this.getStartOffset();
            }
            case SIZE: {
                return this.getSize();
            }
            case FILE_SIZE: {
                return this.getFileSize();
            }
            case COLUMNS_FROM_PATH: {
                return this.getColumnsFromPath();
            }
            case COLUMNS_FROM_PATH_KEYS: {
                return this.getColumnsFromPathKeys();
            }
            case TABLE_FORMAT_PARAMS: {
                return this.getTableFormatParams();
            }
            case MODIFICATION_TIME: {
                return this.getModificationTime();
            }
            case FILE_TYPE: {
                return this.getFileType();
            }
            case COMPRESS_TYPE: {
                return this.getCompressType();
            }
            case FS_NAME: {
                return this.getFsName();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case LOAD_ID: {
                return this.isSetLoadId();
            }
            case PATH: {
                return this.isSetPath();
            }
            case START_OFFSET: {
                return this.isSetStartOffset();
            }
            case SIZE: {
                return this.isSetSize();
            }
            case FILE_SIZE: {
                return this.isSetFileSize();
            }
            case COLUMNS_FROM_PATH: {
                return this.isSetColumnsFromPath();
            }
            case COLUMNS_FROM_PATH_KEYS: {
                return this.isSetColumnsFromPathKeys();
            }
            case TABLE_FORMAT_PARAMS: {
                return this.isSetTableFormatParams();
            }
            case MODIFICATION_TIME: {
                return this.isSetModificationTime();
            }
            case FILE_TYPE: {
                return this.isSetFileType();
            }
            case COMPRESS_TYPE: {
                return this.isSetCompressType();
            }
            case FS_NAME: {
                return this.isSetFsName();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof TFileRangeDesc) {
            return this.equals((TFileRangeDesc)that);
        }
        return false;
    }

    public boolean equals(TFileRangeDesc that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_load_id = this.isSetLoadId();
        boolean that_present_load_id = that.isSetLoadId();
        if (this_present_load_id || that_present_load_id) {
            if (!this_present_load_id || !that_present_load_id) {
                return false;
            }
            if (!this.load_id.equals(that.load_id)) {
                return false;
            }
        }
        boolean this_present_path = this.isSetPath();
        boolean that_present_path = that.isSetPath();
        if (this_present_path || that_present_path) {
            if (!this_present_path || !that_present_path) {
                return false;
            }
            if (!this.path.equals(that.path)) {
                return false;
            }
        }
        boolean this_present_start_offset = this.isSetStartOffset();
        boolean that_present_start_offset = that.isSetStartOffset();
        if (this_present_start_offset || that_present_start_offset) {
            if (!this_present_start_offset || !that_present_start_offset) {
                return false;
            }
            if (this.start_offset != that.start_offset) {
                return false;
            }
        }
        boolean this_present_size = this.isSetSize();
        boolean that_present_size = that.isSetSize();
        if (this_present_size || that_present_size) {
            if (!this_present_size || !that_present_size) {
                return false;
            }
            if (this.size != that.size) {
                return false;
            }
        }
        boolean this_present_file_size = this.isSetFileSize();
        boolean that_present_file_size = that.isSetFileSize();
        if (this_present_file_size || that_present_file_size) {
            if (!this_present_file_size || !that_present_file_size) {
                return false;
            }
            if (this.file_size != that.file_size) {
                return false;
            }
        }
        boolean this_present_columns_from_path = this.isSetColumnsFromPath();
        boolean that_present_columns_from_path = that.isSetColumnsFromPath();
        if (this_present_columns_from_path || that_present_columns_from_path) {
            if (!this_present_columns_from_path || !that_present_columns_from_path) {
                return false;
            }
            if (!this.columns_from_path.equals(that.columns_from_path)) {
                return false;
            }
        }
        boolean this_present_columns_from_path_keys = this.isSetColumnsFromPathKeys();
        boolean that_present_columns_from_path_keys = that.isSetColumnsFromPathKeys();
        if (this_present_columns_from_path_keys || that_present_columns_from_path_keys) {
            if (!this_present_columns_from_path_keys || !that_present_columns_from_path_keys) {
                return false;
            }
            if (!this.columns_from_path_keys.equals(that.columns_from_path_keys)) {
                return false;
            }
        }
        boolean this_present_table_format_params = this.isSetTableFormatParams();
        boolean that_present_table_format_params = that.isSetTableFormatParams();
        if (this_present_table_format_params || that_present_table_format_params) {
            if (!this_present_table_format_params || !that_present_table_format_params) {
                return false;
            }
            if (!this.table_format_params.equals(that.table_format_params)) {
                return false;
            }
        }
        boolean this_present_modification_time = this.isSetModificationTime();
        boolean that_present_modification_time = that.isSetModificationTime();
        if (this_present_modification_time || that_present_modification_time) {
            if (!this_present_modification_time || !that_present_modification_time) {
                return false;
            }
            if (this.modification_time != that.modification_time) {
                return false;
            }
        }
        boolean this_present_file_type = this.isSetFileType();
        boolean that_present_file_type = that.isSetFileType();
        if (this_present_file_type || that_present_file_type) {
            if (!this_present_file_type || !that_present_file_type) {
                return false;
            }
            if (!this.file_type.equals((Object)that.file_type)) {
                return false;
            }
        }
        boolean this_present_compress_type = this.isSetCompressType();
        boolean that_present_compress_type = that.isSetCompressType();
        if (this_present_compress_type || that_present_compress_type) {
            if (!this_present_compress_type || !that_present_compress_type) {
                return false;
            }
            if (!this.compress_type.equals((Object)that.compress_type)) {
                return false;
            }
        }
        boolean this_present_fs_name = this.isSetFsName();
        boolean that_present_fs_name = that.isSetFsName();
        if (this_present_fs_name || that_present_fs_name) {
            if (!this_present_fs_name || !that_present_fs_name) {
                return false;
            }
            if (!this.fs_name.equals(that.fs_name)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + (this.isSetLoadId() ? 131071 : 524287);
        if (this.isSetLoadId()) {
            hashCode = hashCode * 8191 + this.load_id.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetPath() ? 131071 : 524287);
        if (this.isSetPath()) {
            hashCode = hashCode * 8191 + this.path.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetStartOffset() ? 131071 : 524287);
        if (this.isSetStartOffset()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.start_offset);
        }
        hashCode = hashCode * 8191 + (this.isSetSize() ? 131071 : 524287);
        if (this.isSetSize()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.size);
        }
        hashCode = hashCode * 8191 + (this.isSetFileSize() ? 131071 : 524287);
        if (this.isSetFileSize()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.file_size);
        }
        hashCode = hashCode * 8191 + (this.isSetColumnsFromPath() ? 131071 : 524287);
        if (this.isSetColumnsFromPath()) {
            hashCode = hashCode * 8191 + this.columns_from_path.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetColumnsFromPathKeys() ? 131071 : 524287);
        if (this.isSetColumnsFromPathKeys()) {
            hashCode = hashCode * 8191 + this.columns_from_path_keys.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetTableFormatParams() ? 131071 : 524287);
        if (this.isSetTableFormatParams()) {
            hashCode = hashCode * 8191 + this.table_format_params.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetModificationTime() ? 131071 : 524287);
        if (this.isSetModificationTime()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.modification_time);
        }
        hashCode = hashCode * 8191 + (this.isSetFileType() ? 131071 : 524287);
        if (this.isSetFileType()) {
            hashCode = hashCode * 8191 + this.file_type.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetCompressType() ? 131071 : 524287);
        if (this.isSetCompressType()) {
            hashCode = hashCode * 8191 + this.compress_type.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetFsName() ? 131071 : 524287);
        if (this.isSetFsName()) {
            hashCode = hashCode * 8191 + this.fs_name.hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(TFileRangeDesc other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetLoadId(), other.isSetLoadId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetLoadId() && (lastComparison = TBaseHelper.compareTo((Comparable)this.load_id, (Comparable)other.load_id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetPath(), other.isSetPath());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPath() && (lastComparison = TBaseHelper.compareTo((String)this.path, (String)other.path)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetStartOffset(), other.isSetStartOffset());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetStartOffset() && (lastComparison = TBaseHelper.compareTo((long)this.start_offset, (long)other.start_offset)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetSize(), other.isSetSize());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSize() && (lastComparison = TBaseHelper.compareTo((long)this.size, (long)other.size)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetFileSize(), other.isSetFileSize());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFileSize() && (lastComparison = TBaseHelper.compareTo((long)this.file_size, (long)other.file_size)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetColumnsFromPath(), other.isSetColumnsFromPath());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumnsFromPath() && (lastComparison = TBaseHelper.compareTo(this.columns_from_path, other.columns_from_path)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetColumnsFromPathKeys(), other.isSetColumnsFromPathKeys());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumnsFromPathKeys() && (lastComparison = TBaseHelper.compareTo(this.columns_from_path_keys, other.columns_from_path_keys)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetTableFormatParams(), other.isSetTableFormatParams());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTableFormatParams() && (lastComparison = TBaseHelper.compareTo((Comparable)this.table_format_params, (Comparable)other.table_format_params)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetModificationTime(), other.isSetModificationTime());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetModificationTime() && (lastComparison = TBaseHelper.compareTo((long)this.modification_time, (long)other.modification_time)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetFileType(), other.isSetFileType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFileType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.file_type), (Comparable)((Object)other.file_type))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetCompressType(), other.isSetCompressType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetCompressType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.compress_type), (Comparable)((Object)other.compress_type))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetFsName(), other.isSetFsName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetFsName() && (lastComparison = TBaseHelper.compareTo((String)this.fs_name, (String)other.fs_name)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        TFileRangeDesc.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        TFileRangeDesc.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TFileRangeDesc(");
        boolean first = true;
        if (this.isSetLoadId()) {
            sb.append("load_id:");
            if (this.load_id == null) {
                sb.append("null");
            } else {
                sb.append(this.load_id);
            }
            first = false;
        }
        if (this.isSetPath()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("path:");
            if (this.path == null) {
                sb.append("null");
            } else {
                sb.append(this.path);
            }
            first = false;
        }
        if (this.isSetStartOffset()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("start_offset:");
            sb.append(this.start_offset);
            first = false;
        }
        if (this.isSetSize()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("size:");
            sb.append(this.size);
            first = false;
        }
        if (this.isSetFileSize()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("file_size:");
            sb.append(this.file_size);
            first = false;
        }
        if (this.isSetColumnsFromPath()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("columns_from_path:");
            if (this.columns_from_path == null) {
                sb.append("null");
            } else {
                sb.append(this.columns_from_path);
            }
            first = false;
        }
        if (this.isSetColumnsFromPathKeys()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("columns_from_path_keys:");
            if (this.columns_from_path_keys == null) {
                sb.append("null");
            } else {
                sb.append(this.columns_from_path_keys);
            }
            first = false;
        }
        if (this.isSetTableFormatParams()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("table_format_params:");
            if (this.table_format_params == null) {
                sb.append("null");
            } else {
                sb.append(this.table_format_params);
            }
            first = false;
        }
        if (this.isSetModificationTime()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("modification_time:");
            sb.append(this.modification_time);
            first = false;
        }
        if (this.isSetFileType()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("file_type:");
            if (this.file_type == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.file_type);
            }
            first = false;
        }
        if (this.isSetCompressType()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("compress_type:");
            if (this.compress_type == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.compress_type);
            }
            first = false;
        }
        if (this.isSetFsName()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("fs_name:");
            if (this.fs_name == null) {
                sb.append("null");
            } else {
                sb.append(this.fs_name);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.load_id != null) {
            this.load_id.validate();
        }
        if (this.table_format_params != null) {
            this.table_format_params.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.LOAD_ID, new FieldMetaData("load_id", 2, (FieldValueMetaData)new StructMetaData(12, TUniqueId.class)));
        tmpMap.put(_Fields.PATH, new FieldMetaData("path", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.START_OFFSET, new FieldMetaData("start_offset", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.SIZE, new FieldMetaData("size", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.FILE_SIZE, new FieldMetaData("file_size", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.COLUMNS_FROM_PATH, new FieldMetaData("columns_from_path", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.COLUMNS_FROM_PATH_KEYS, new FieldMetaData("columns_from_path_keys", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.TABLE_FORMAT_PARAMS, new FieldMetaData("table_format_params", 2, (FieldValueMetaData)new StructMetaData(12, TTableFormatFileDesc.class)));
        tmpMap.put(_Fields.MODIFICATION_TIME, new FieldMetaData("modification_time", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.FILE_TYPE, new FieldMetaData("file_type", 2, (FieldValueMetaData)new EnumMetaData(16, TFileType.class)));
        tmpMap.put(_Fields.COMPRESS_TYPE, new FieldMetaData("compress_type", 2, (FieldValueMetaData)new EnumMetaData(16, TFileCompressType.class)));
        tmpMap.put(_Fields.FS_NAME, new FieldMetaData("fs_name", 2, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TFileRangeDesc.class, metaDataMap);
    }

    private static class TFileRangeDescTupleScheme
    extends TupleScheme<TFileRangeDesc> {
        private TFileRangeDescTupleScheme() {
        }

        public void write(TProtocol prot, TFileRangeDesc struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetLoadId()) {
                optionals.set(0);
            }
            if (struct.isSetPath()) {
                optionals.set(1);
            }
            if (struct.isSetStartOffset()) {
                optionals.set(2);
            }
            if (struct.isSetSize()) {
                optionals.set(3);
            }
            if (struct.isSetFileSize()) {
                optionals.set(4);
            }
            if (struct.isSetColumnsFromPath()) {
                optionals.set(5);
            }
            if (struct.isSetColumnsFromPathKeys()) {
                optionals.set(6);
            }
            if (struct.isSetTableFormatParams()) {
                optionals.set(7);
            }
            if (struct.isSetModificationTime()) {
                optionals.set(8);
            }
            if (struct.isSetFileType()) {
                optionals.set(9);
            }
            if (struct.isSetCompressType()) {
                optionals.set(10);
            }
            if (struct.isSetFsName()) {
                optionals.set(11);
            }
            oprot.writeBitSet(optionals, 12);
            if (struct.isSetLoadId()) {
                struct.load_id.write((TProtocol)oprot);
            }
            if (struct.isSetPath()) {
                oprot.writeString(struct.path);
            }
            if (struct.isSetStartOffset()) {
                oprot.writeI64(struct.start_offset);
            }
            if (struct.isSetSize()) {
                oprot.writeI64(struct.size);
            }
            if (struct.isSetFileSize()) {
                oprot.writeI64(struct.file_size);
            }
            if (struct.isSetColumnsFromPath()) {
                oprot.writeI32(struct.columns_from_path.size());
                for (String _iter266 : struct.columns_from_path) {
                    oprot.writeString(_iter266);
                }
            }
            if (struct.isSetColumnsFromPathKeys()) {
                oprot.writeI32(struct.columns_from_path_keys.size());
                for (String _iter267 : struct.columns_from_path_keys) {
                    oprot.writeString(_iter267);
                }
            }
            if (struct.isSetTableFormatParams()) {
                struct.table_format_params.write((TProtocol)oprot);
            }
            if (struct.isSetModificationTime()) {
                oprot.writeI64(struct.modification_time);
            }
            if (struct.isSetFileType()) {
                oprot.writeI32(struct.file_type.getValue());
            }
            if (struct.isSetCompressType()) {
                oprot.writeI32(struct.compress_type.getValue());
            }
            if (struct.isSetFsName()) {
                oprot.writeString(struct.fs_name);
            }
        }

        public void read(TProtocol prot, TFileRangeDesc struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(12);
            if (incoming.get(0)) {
                struct.load_id = new TUniqueId();
                struct.load_id.read((TProtocol)iprot);
                struct.setLoadIdIsSet(true);
            }
            if (incoming.get(1)) {
                struct.path = iprot.readString();
                struct.setPathIsSet(true);
            }
            if (incoming.get(2)) {
                struct.start_offset = iprot.readI64();
                struct.setStartOffsetIsSet(true);
            }
            if (incoming.get(3)) {
                struct.size = iprot.readI64();
                struct.setSizeIsSet(true);
            }
            if (incoming.get(4)) {
                struct.file_size = iprot.readI64();
                struct.setFileSizeIsSet(true);
            }
            if (incoming.get(5)) {
                TList _list268 = iprot.readListBegin((byte)11);
                struct.columns_from_path = new ArrayList<String>(_list268.size);
                for (int _i270 = 0; _i270 < _list268.size; ++_i270) {
                    String _elem269 = iprot.readString();
                    struct.columns_from_path.add(_elem269);
                }
                struct.setColumnsFromPathIsSet(true);
            }
            if (incoming.get(6)) {
                TList _list271 = iprot.readListBegin((byte)11);
                struct.columns_from_path_keys = new ArrayList<String>(_list271.size);
                for (int _i273 = 0; _i273 < _list271.size; ++_i273) {
                    String _elem272 = iprot.readString();
                    struct.columns_from_path_keys.add(_elem272);
                }
                struct.setColumnsFromPathKeysIsSet(true);
            }
            if (incoming.get(7)) {
                struct.table_format_params = new TTableFormatFileDesc();
                struct.table_format_params.read((TProtocol)iprot);
                struct.setTableFormatParamsIsSet(true);
            }
            if (incoming.get(8)) {
                struct.modification_time = iprot.readI64();
                struct.setModificationTimeIsSet(true);
            }
            if (incoming.get(9)) {
                struct.file_type = TFileType.findByValue(iprot.readI32());
                struct.setFileTypeIsSet(true);
            }
            if (incoming.get(10)) {
                struct.compress_type = TFileCompressType.findByValue(iprot.readI32());
                struct.setCompressTypeIsSet(true);
            }
            if (incoming.get(11)) {
                struct.fs_name = iprot.readString();
                struct.setFsNameIsSet(true);
            }
        }
    }

    private static class TFileRangeDescTupleSchemeFactory
    implements SchemeFactory {
        private TFileRangeDescTupleSchemeFactory() {
        }

        public TFileRangeDescTupleScheme getScheme() {
            return new TFileRangeDescTupleScheme();
        }
    }

    private static class TFileRangeDescStandardScheme
    extends StandardScheme<TFileRangeDesc> {
        private TFileRangeDescStandardScheme() {
        }

        public void read(TProtocol iprot, TFileRangeDesc struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 12) {
                            struct.load_id = new TUniqueId();
                            struct.load_id.read(iprot);
                            struct.setLoadIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.path = iprot.readString();
                            struct.setPathIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 10) {
                            struct.start_offset = iprot.readI64();
                            struct.setStartOffsetIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 10) {
                            struct.size = iprot.readI64();
                            struct.setSizeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 10) {
                            struct.file_size = iprot.readI64();
                            struct.setFileSizeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 15) {
                            TList _list258 = iprot.readListBegin();
                            struct.columns_from_path = new ArrayList<String>(_list258.size);
                            for (int _i260 = 0; _i260 < _list258.size; ++_i260) {
                                String _elem259 = iprot.readString();
                                struct.columns_from_path.add(_elem259);
                            }
                            iprot.readListEnd();
                            struct.setColumnsFromPathIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 15) {
                            TList _list261 = iprot.readListBegin();
                            struct.columns_from_path_keys = new ArrayList<String>(_list261.size);
                            for (int _i263 = 0; _i263 < _list261.size; ++_i263) {
                                String _elem262 = iprot.readString();
                                struct.columns_from_path_keys.add(_elem262);
                            }
                            iprot.readListEnd();
                            struct.setColumnsFromPathKeysIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 12) {
                            struct.table_format_params = new TTableFormatFileDesc();
                            struct.table_format_params.read(iprot);
                            struct.setTableFormatParamsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 10) {
                            struct.modification_time = iprot.readI64();
                            struct.setModificationTimeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 8) {
                            struct.file_type = TFileType.findByValue(iprot.readI32());
                            struct.setFileTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 8) {
                            struct.compress_type = TFileCompressType.findByValue(iprot.readI32());
                            struct.setCompressTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 11) {
                            struct.fs_name = iprot.readString();
                            struct.setFsNameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, TFileRangeDesc struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.load_id != null && struct.isSetLoadId()) {
                oprot.writeFieldBegin(LOAD_ID_FIELD_DESC);
                struct.load_id.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.path != null && struct.isSetPath()) {
                oprot.writeFieldBegin(PATH_FIELD_DESC);
                oprot.writeString(struct.path);
                oprot.writeFieldEnd();
            }
            if (struct.isSetStartOffset()) {
                oprot.writeFieldBegin(START_OFFSET_FIELD_DESC);
                oprot.writeI64(struct.start_offset);
                oprot.writeFieldEnd();
            }
            if (struct.isSetSize()) {
                oprot.writeFieldBegin(SIZE_FIELD_DESC);
                oprot.writeI64(struct.size);
                oprot.writeFieldEnd();
            }
            if (struct.isSetFileSize()) {
                oprot.writeFieldBegin(FILE_SIZE_FIELD_DESC);
                oprot.writeI64(struct.file_size);
                oprot.writeFieldEnd();
            }
            if (struct.columns_from_path != null && struct.isSetColumnsFromPath()) {
                oprot.writeFieldBegin(COLUMNS_FROM_PATH_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.columns_from_path.size()));
                for (String _iter264 : struct.columns_from_path) {
                    oprot.writeString(_iter264);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.columns_from_path_keys != null && struct.isSetColumnsFromPathKeys()) {
                oprot.writeFieldBegin(COLUMNS_FROM_PATH_KEYS_FIELD_DESC);
                oprot.writeListBegin(new TList(11, struct.columns_from_path_keys.size()));
                for (String _iter265 : struct.columns_from_path_keys) {
                    oprot.writeString(_iter265);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.table_format_params != null && struct.isSetTableFormatParams()) {
                oprot.writeFieldBegin(TABLE_FORMAT_PARAMS_FIELD_DESC);
                struct.table_format_params.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.isSetModificationTime()) {
                oprot.writeFieldBegin(MODIFICATION_TIME_FIELD_DESC);
                oprot.writeI64(struct.modification_time);
                oprot.writeFieldEnd();
            }
            if (struct.file_type != null && struct.isSetFileType()) {
                oprot.writeFieldBegin(FILE_TYPE_FIELD_DESC);
                oprot.writeI32(struct.file_type.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.compress_type != null && struct.isSetCompressType()) {
                oprot.writeFieldBegin(COMPRESS_TYPE_FIELD_DESC);
                oprot.writeI32(struct.compress_type.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.fs_name != null && struct.isSetFsName()) {
                oprot.writeFieldBegin(FS_NAME_FIELD_DESC);
                oprot.writeString(struct.fs_name);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TFileRangeDescStandardSchemeFactory
    implements SchemeFactory {
        private TFileRangeDescStandardSchemeFactory() {
        }

        public TFileRangeDescStandardScheme getScheme() {
            return new TFileRangeDescStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        LOAD_ID(1, "load_id"),
        PATH(2, "path"),
        START_OFFSET(3, "start_offset"),
        SIZE(4, "size"),
        FILE_SIZE(5, "file_size"),
        COLUMNS_FROM_PATH(6, "columns_from_path"),
        COLUMNS_FROM_PATH_KEYS(7, "columns_from_path_keys"),
        TABLE_FORMAT_PARAMS(8, "table_format_params"),
        MODIFICATION_TIME(9, "modification_time"),
        FILE_TYPE(10, "file_type"),
        COMPRESS_TYPE(11, "compress_type"),
        FS_NAME(12, "fs_name");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return LOAD_ID;
                }
                case 2: {
                    return PATH;
                }
                case 3: {
                    return START_OFFSET;
                }
                case 4: {
                    return SIZE;
                }
                case 5: {
                    return FILE_SIZE;
                }
                case 6: {
                    return COLUMNS_FROM_PATH;
                }
                case 7: {
                    return COLUMNS_FROM_PATH_KEYS;
                }
                case 8: {
                    return TABLE_FORMAT_PARAMS;
                }
                case 9: {
                    return MODIFICATION_TIME;
                }
                case 10: {
                    return FILE_TYPE;
                }
                case 11: {
                    return COMPRESS_TYPE;
                }
                case 12: {
                    return FS_NAME;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

