/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.thrift;

import org.apache.thrift.TEnum;
import org.apache.thrift.annotation.Nullable;

public enum TExprOpcode implements TEnum
{
    INVALID_OPCODE(0),
    COMPOUND_NOT(1),
    COMPOUND_AND(2),
    COMPOUND_OR(3),
    CAST(4),
    FILTER_IN(5),
    FILTER_NOT_IN(6),
    FILTER_NEW_IN(7),
    FILTER_NEW_NOT_IN(8),
    EQ(9),
    NE(10),
    LT(11),
    LE(12),
    GT(13),
    GE(14),
    CONDITION_IF(15),
    CONDITION_NULLIF(16),
    CONDITION_IFNULL(17),
    CONDITION_COALESCE(18),
    TIMESTAMP_DATE_FORMAT(19),
    TIMESTAMP_DAYOFMONTH(20),
    TIMESTAMP_DAYOFYEAR(21),
    TIMESTAMP_DAYS_ADD(22),
    TIMESTAMP_DAYS_SUB(23),
    TIMESTAMP_DAY_NAME(24),
    TIMESTAMP_DIFF(25),
    TIMESTAMP_FROM_DAYS(26),
    TIMESTAMP_HOUR(27),
    TIMESTAMP_HOURS_ADD(28),
    TIMESTAMP_HOURS_SUB(29),
    TIMESTAMP_MICROSECOND(30),
    TIMESTAMP_MICROSECONDS_ADD(31),
    TIMESTAMP_MICROSECONDS_SUB(32),
    TIMESTAMP_MINUTE(33),
    TIMESTAMP_MINUTES_ADD(34),
    TIMESTAMP_MINUTES_SUB(35),
    TIMESTAMP_MONTH(36),
    TIMESTAMP_MONTHS_ADD(37),
    TIMESTAMP_MONTHS_SUB(38),
    TIMESTAMP_MONT_NAME(39),
    TIMESTAMP_NOW(40),
    TIMESTAMP_SECOND(41),
    TIMESTAMP_SECONDS_ADD(42),
    TIMESTAMP_SECONDS_SUB(43),
    TIMESTAMP_STR_TO_DATE(44),
    TIMESTAMP_TO_DATE(45),
    TIMESTAMP_TO_DAYS(46),
    TIMESTAMP_WEEKOFYEAR(47),
    TIMESTAMP_WEEKS_ADD(48),
    TIMESTAMP_WEEKS_SUB(49),
    TIMESTAMP_YEAR(50),
    TIMESTAMP_YEARS_ADD(51),
    TIMESTAMP_YEARS_SUB(52),
    ADD(53),
    SUBTRACT(54),
    MULTIPLY(55),
    DIVIDE(56),
    INT_DIVIDE(57),
    MOD(58),
    BITAND(59),
    BITOR(60),
    BITXOR(61),
    BITNOT(62),
    FACTORIAL(63),
    LAST_OPCODE(64),
    EQ_FOR_NULL(65),
    RT_FILTER(66),
    MATCH_ANY(67),
    MATCH_ALL(68),
    MATCH_PHRASE(69),
    MATCH_ELEMENT_EQ(70),
    MATCH_ELEMENT_LT(71),
    MATCH_ELEMENT_GT(72),
    MATCH_ELEMENT_LE(73),
    MATCH_ELEMENT_GE(74);

    private final int value;

    private TExprOpcode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    @Nullable
    public static TExprOpcode findByValue(int value) {
        switch (value) {
            case 0: {
                return INVALID_OPCODE;
            }
            case 1: {
                return COMPOUND_NOT;
            }
            case 2: {
                return COMPOUND_AND;
            }
            case 3: {
                return COMPOUND_OR;
            }
            case 4: {
                return CAST;
            }
            case 5: {
                return FILTER_IN;
            }
            case 6: {
                return FILTER_NOT_IN;
            }
            case 7: {
                return FILTER_NEW_IN;
            }
            case 8: {
                return FILTER_NEW_NOT_IN;
            }
            case 9: {
                return EQ;
            }
            case 10: {
                return NE;
            }
            case 11: {
                return LT;
            }
            case 12: {
                return LE;
            }
            case 13: {
                return GT;
            }
            case 14: {
                return GE;
            }
            case 15: {
                return CONDITION_IF;
            }
            case 16: {
                return CONDITION_NULLIF;
            }
            case 17: {
                return CONDITION_IFNULL;
            }
            case 18: {
                return CONDITION_COALESCE;
            }
            case 19: {
                return TIMESTAMP_DATE_FORMAT;
            }
            case 20: {
                return TIMESTAMP_DAYOFMONTH;
            }
            case 21: {
                return TIMESTAMP_DAYOFYEAR;
            }
            case 22: {
                return TIMESTAMP_DAYS_ADD;
            }
            case 23: {
                return TIMESTAMP_DAYS_SUB;
            }
            case 24: {
                return TIMESTAMP_DAY_NAME;
            }
            case 25: {
                return TIMESTAMP_DIFF;
            }
            case 26: {
                return TIMESTAMP_FROM_DAYS;
            }
            case 27: {
                return TIMESTAMP_HOUR;
            }
            case 28: {
                return TIMESTAMP_HOURS_ADD;
            }
            case 29: {
                return TIMESTAMP_HOURS_SUB;
            }
            case 30: {
                return TIMESTAMP_MICROSECOND;
            }
            case 31: {
                return TIMESTAMP_MICROSECONDS_ADD;
            }
            case 32: {
                return TIMESTAMP_MICROSECONDS_SUB;
            }
            case 33: {
                return TIMESTAMP_MINUTE;
            }
            case 34: {
                return TIMESTAMP_MINUTES_ADD;
            }
            case 35: {
                return TIMESTAMP_MINUTES_SUB;
            }
            case 36: {
                return TIMESTAMP_MONTH;
            }
            case 37: {
                return TIMESTAMP_MONTHS_ADD;
            }
            case 38: {
                return TIMESTAMP_MONTHS_SUB;
            }
            case 39: {
                return TIMESTAMP_MONT_NAME;
            }
            case 40: {
                return TIMESTAMP_NOW;
            }
            case 41: {
                return TIMESTAMP_SECOND;
            }
            case 42: {
                return TIMESTAMP_SECONDS_ADD;
            }
            case 43: {
                return TIMESTAMP_SECONDS_SUB;
            }
            case 44: {
                return TIMESTAMP_STR_TO_DATE;
            }
            case 45: {
                return TIMESTAMP_TO_DATE;
            }
            case 46: {
                return TIMESTAMP_TO_DAYS;
            }
            case 47: {
                return TIMESTAMP_WEEKOFYEAR;
            }
            case 48: {
                return TIMESTAMP_WEEKS_ADD;
            }
            case 49: {
                return TIMESTAMP_WEEKS_SUB;
            }
            case 50: {
                return TIMESTAMP_YEAR;
            }
            case 51: {
                return TIMESTAMP_YEARS_ADD;
            }
            case 52: {
                return TIMESTAMP_YEARS_SUB;
            }
            case 53: {
                return ADD;
            }
            case 54: {
                return SUBTRACT;
            }
            case 55: {
                return MULTIPLY;
            }
            case 56: {
                return DIVIDE;
            }
            case 57: {
                return INT_DIVIDE;
            }
            case 58: {
                return MOD;
            }
            case 59: {
                return BITAND;
            }
            case 60: {
                return BITOR;
            }
            case 61: {
                return BITXOR;
            }
            case 62: {
                return BITNOT;
            }
            case 63: {
                return FACTORIAL;
            }
            case 64: {
                return LAST_OPCODE;
            }
            case 65: {
                return EQ_FOR_NULL;
            }
            case 66: {
                return RT_FILTER;
            }
            case 67: {
                return MATCH_ANY;
            }
            case 68: {
                return MATCH_ALL;
            }
            case 69: {
                return MATCH_PHRASE;
            }
            case 70: {
                return MATCH_ELEMENT_EQ;
            }
            case 71: {
                return MATCH_ELEMENT_LT;
            }
            case 72: {
                return MATCH_ELEMENT_GT;
            }
            case 73: {
                return MATCH_ELEMENT_LE;
            }
            case 74: {
                return MATCH_ELEMENT_GE;
            }
        }
        return null;
    }
}

