/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.thrift;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.doris.thrift.TAlterTabletType;
import org.apache.doris.thrift.TColumn;
import org.apache.doris.thrift.TOlapTableIndex;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.annotation.Nullable;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class TAlterInvertedIndexReq
implements TBase<TAlterInvertedIndexReq, _Fields>,
Serializable,
Cloneable,
Comparable<TAlterInvertedIndexReq> {
    private static final TStruct STRUCT_DESC = new TStruct("TAlterInvertedIndexReq");
    private static final TField TABLET_ID_FIELD_DESC = new TField("tablet_id", 10, 1);
    private static final TField SCHEMA_HASH_FIELD_DESC = new TField("schema_hash", 8, 2);
    private static final TField ALTER_VERSION_FIELD_DESC = new TField("alter_version", 10, 3);
    private static final TField ALTER_TABLET_TYPE_FIELD_DESC = new TField("alter_tablet_type", 8, 4);
    private static final TField IS_DROP_OP_FIELD_DESC = new TField("is_drop_op", 2, 5);
    private static final TField ALTER_INVERTED_INDEXES_FIELD_DESC = new TField("alter_inverted_indexes", 15, 6);
    private static final TField INDEXES_DESC_FIELD_DESC = new TField("indexes_desc", 15, 7);
    private static final TField COLUMNS_FIELD_DESC = new TField("columns", 15, 8);
    private static final TField JOB_ID_FIELD_DESC = new TField("job_id", 10, 9);
    private static final TField EXPIRATION_FIELD_DESC = new TField("expiration", 10, 10);
    private static final SchemeFactory STANDARD_SCHEME_FACTORY = new TAlterInvertedIndexReqStandardSchemeFactory();
    private static final SchemeFactory TUPLE_SCHEME_FACTORY = new TAlterInvertedIndexReqTupleSchemeFactory();
    public long tablet_id;
    public int schema_hash;
    public long alter_version;
    @Nullable
    public TAlterTabletType alter_tablet_type;
    public boolean is_drop_op;
    @Nullable
    public List<TOlapTableIndex> alter_inverted_indexes;
    @Nullable
    public List<TOlapTableIndex> indexes_desc;
    @Nullable
    public List<TColumn> columns;
    public long job_id;
    public long expiration;
    private static final int __TABLET_ID_ISSET_ID = 0;
    private static final int __SCHEMA_HASH_ISSET_ID = 1;
    private static final int __ALTER_VERSION_ISSET_ID = 2;
    private static final int __IS_DROP_OP_ISSET_ID = 3;
    private static final int __JOB_ID_ISSET_ID = 4;
    private static final int __EXPIRATION_ISSET_ID = 5;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals = new _Fields[]{_Fields.ALTER_VERSION, _Fields.ALTER_TABLET_TYPE, _Fields.IS_DROP_OP, _Fields.ALTER_INVERTED_INDEXES, _Fields.INDEXES_DESC, _Fields.COLUMNS, _Fields.JOB_ID, _Fields.EXPIRATION};
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public TAlterInvertedIndexReq() {
        this.alter_tablet_type = TAlterTabletType.SCHEMA_CHANGE;
        this.is_drop_op = false;
    }

    public TAlterInvertedIndexReq(long tablet_id, int schema_hash) {
        this();
        this.tablet_id = tablet_id;
        this.setTabletIdIsSet(true);
        this.schema_hash = schema_hash;
        this.setSchemaHashIsSet(true);
    }

    public TAlterInvertedIndexReq(TAlterInvertedIndexReq other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.tablet_id = other.tablet_id;
        this.schema_hash = other.schema_hash;
        this.alter_version = other.alter_version;
        if (other.isSetAlterTabletType()) {
            this.alter_tablet_type = other.alter_tablet_type;
        }
        this.is_drop_op = other.is_drop_op;
        if (other.isSetAlterInvertedIndexes()) {
            ArrayList<TOlapTableIndex> __this__alter_inverted_indexes = new ArrayList<TOlapTableIndex>(other.alter_inverted_indexes.size());
            for (TOlapTableIndex tOlapTableIndex : other.alter_inverted_indexes) {
                __this__alter_inverted_indexes.add(new TOlapTableIndex(tOlapTableIndex));
            }
            this.alter_inverted_indexes = __this__alter_inverted_indexes;
        }
        if (other.isSetIndexesDesc()) {
            ArrayList<TOlapTableIndex> __this__indexes_desc = new ArrayList<TOlapTableIndex>(other.indexes_desc.size());
            for (TOlapTableIndex tOlapTableIndex : other.indexes_desc) {
                __this__indexes_desc.add(new TOlapTableIndex(tOlapTableIndex));
            }
            this.indexes_desc = __this__indexes_desc;
        }
        if (other.isSetColumns()) {
            ArrayList<TColumn> __this__columns = new ArrayList<TColumn>(other.columns.size());
            for (TColumn tColumn : other.columns) {
                __this__columns.add(new TColumn(tColumn));
            }
            this.columns = __this__columns;
        }
        this.job_id = other.job_id;
        this.expiration = other.expiration;
    }

    public TAlterInvertedIndexReq deepCopy() {
        return new TAlterInvertedIndexReq(this);
    }

    public void clear() {
        this.setTabletIdIsSet(false);
        this.tablet_id = 0L;
        this.setSchemaHashIsSet(false);
        this.schema_hash = 0;
        this.setAlterVersionIsSet(false);
        this.alter_version = 0L;
        this.alter_tablet_type = TAlterTabletType.SCHEMA_CHANGE;
        this.is_drop_op = false;
        this.alter_inverted_indexes = null;
        this.indexes_desc = null;
        this.columns = null;
        this.setJobIdIsSet(false);
        this.job_id = 0L;
        this.setExpirationIsSet(false);
        this.expiration = 0L;
    }

    public long getTabletId() {
        return this.tablet_id;
    }

    public TAlterInvertedIndexReq setTabletId(long tablet_id) {
        this.tablet_id = tablet_id;
        this.setTabletIdIsSet(true);
        return this;
    }

    public void unsetTabletId() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetTabletId() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setTabletIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public int getSchemaHash() {
        return this.schema_hash;
    }

    public TAlterInvertedIndexReq setSchemaHash(int schema_hash) {
        this.schema_hash = schema_hash;
        this.setSchemaHashIsSet(true);
        return this;
    }

    public void unsetSchemaHash() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetSchemaHash() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setSchemaHashIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public long getAlterVersion() {
        return this.alter_version;
    }

    public TAlterInvertedIndexReq setAlterVersion(long alter_version) {
        this.alter_version = alter_version;
        this.setAlterVersionIsSet(true);
        return this;
    }

    public void unsetAlterVersion() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetAlterVersion() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setAlterVersionIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    @Nullable
    public TAlterTabletType getAlterTabletType() {
        return this.alter_tablet_type;
    }

    public TAlterInvertedIndexReq setAlterTabletType(@Nullable TAlterTabletType alter_tablet_type) {
        this.alter_tablet_type = alter_tablet_type;
        return this;
    }

    public void unsetAlterTabletType() {
        this.alter_tablet_type = null;
    }

    public boolean isSetAlterTabletType() {
        return this.alter_tablet_type != null;
    }

    public void setAlterTabletTypeIsSet(boolean value) {
        if (!value) {
            this.alter_tablet_type = null;
        }
    }

    public boolean isIsDropOp() {
        return this.is_drop_op;
    }

    public TAlterInvertedIndexReq setIsDropOp(boolean is_drop_op) {
        this.is_drop_op = is_drop_op;
        this.setIsDropOpIsSet(true);
        return this;
    }

    public void unsetIsDropOp() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)3);
    }

    public boolean isSetIsDropOp() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)3);
    }

    public void setIsDropOpIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)3, (boolean)value);
    }

    public int getAlterInvertedIndexesSize() {
        return this.alter_inverted_indexes == null ? 0 : this.alter_inverted_indexes.size();
    }

    @Nullable
    public Iterator<TOlapTableIndex> getAlterInvertedIndexesIterator() {
        return this.alter_inverted_indexes == null ? null : this.alter_inverted_indexes.iterator();
    }

    public void addToAlterInvertedIndexes(TOlapTableIndex elem) {
        if (this.alter_inverted_indexes == null) {
            this.alter_inverted_indexes = new ArrayList<TOlapTableIndex>();
        }
        this.alter_inverted_indexes.add(elem);
    }

    @Nullable
    public List<TOlapTableIndex> getAlterInvertedIndexes() {
        return this.alter_inverted_indexes;
    }

    public TAlterInvertedIndexReq setAlterInvertedIndexes(@Nullable List<TOlapTableIndex> alter_inverted_indexes) {
        this.alter_inverted_indexes = alter_inverted_indexes;
        return this;
    }

    public void unsetAlterInvertedIndexes() {
        this.alter_inverted_indexes = null;
    }

    public boolean isSetAlterInvertedIndexes() {
        return this.alter_inverted_indexes != null;
    }

    public void setAlterInvertedIndexesIsSet(boolean value) {
        if (!value) {
            this.alter_inverted_indexes = null;
        }
    }

    public int getIndexesDescSize() {
        return this.indexes_desc == null ? 0 : this.indexes_desc.size();
    }

    @Nullable
    public Iterator<TOlapTableIndex> getIndexesDescIterator() {
        return this.indexes_desc == null ? null : this.indexes_desc.iterator();
    }

    public void addToIndexesDesc(TOlapTableIndex elem) {
        if (this.indexes_desc == null) {
            this.indexes_desc = new ArrayList<TOlapTableIndex>();
        }
        this.indexes_desc.add(elem);
    }

    @Nullable
    public List<TOlapTableIndex> getIndexesDesc() {
        return this.indexes_desc;
    }

    public TAlterInvertedIndexReq setIndexesDesc(@Nullable List<TOlapTableIndex> indexes_desc) {
        this.indexes_desc = indexes_desc;
        return this;
    }

    public void unsetIndexesDesc() {
        this.indexes_desc = null;
    }

    public boolean isSetIndexesDesc() {
        return this.indexes_desc != null;
    }

    public void setIndexesDescIsSet(boolean value) {
        if (!value) {
            this.indexes_desc = null;
        }
    }

    public int getColumnsSize() {
        return this.columns == null ? 0 : this.columns.size();
    }

    @Nullable
    public Iterator<TColumn> getColumnsIterator() {
        return this.columns == null ? null : this.columns.iterator();
    }

    public void addToColumns(TColumn elem) {
        if (this.columns == null) {
            this.columns = new ArrayList<TColumn>();
        }
        this.columns.add(elem);
    }

    @Nullable
    public List<TColumn> getColumns() {
        return this.columns;
    }

    public TAlterInvertedIndexReq setColumns(@Nullable List<TColumn> columns) {
        this.columns = columns;
        return this;
    }

    public void unsetColumns() {
        this.columns = null;
    }

    public boolean isSetColumns() {
        return this.columns != null;
    }

    public void setColumnsIsSet(boolean value) {
        if (!value) {
            this.columns = null;
        }
    }

    public long getJobId() {
        return this.job_id;
    }

    public TAlterInvertedIndexReq setJobId(long job_id) {
        this.job_id = job_id;
        this.setJobIdIsSet(true);
        return this;
    }

    public void unsetJobId() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)4);
    }

    public boolean isSetJobId() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)4);
    }

    public void setJobIdIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)4, (boolean)value);
    }

    public long getExpiration() {
        return this.expiration;
    }

    public TAlterInvertedIndexReq setExpiration(long expiration) {
        this.expiration = expiration;
        this.setExpirationIsSet(true);
        return this;
    }

    public void unsetExpiration() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)5);
    }

    public boolean isSetExpiration() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)5);
    }

    public void setExpirationIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)5, (boolean)value);
    }

    public void setFieldValue(_Fields field, @Nullable Object value) {
        switch (field) {
            case TABLET_ID: {
                if (value == null) {
                    this.unsetTabletId();
                    break;
                }
                this.setTabletId((Long)value);
                break;
            }
            case SCHEMA_HASH: {
                if (value == null) {
                    this.unsetSchemaHash();
                    break;
                }
                this.setSchemaHash((Integer)value);
                break;
            }
            case ALTER_VERSION: {
                if (value == null) {
                    this.unsetAlterVersion();
                    break;
                }
                this.setAlterVersion((Long)value);
                break;
            }
            case ALTER_TABLET_TYPE: {
                if (value == null) {
                    this.unsetAlterTabletType();
                    break;
                }
                this.setAlterTabletType((TAlterTabletType)((Object)value));
                break;
            }
            case IS_DROP_OP: {
                if (value == null) {
                    this.unsetIsDropOp();
                    break;
                }
                this.setIsDropOp((Boolean)value);
                break;
            }
            case ALTER_INVERTED_INDEXES: {
                if (value == null) {
                    this.unsetAlterInvertedIndexes();
                    break;
                }
                this.setAlterInvertedIndexes((List)value);
                break;
            }
            case INDEXES_DESC: {
                if (value == null) {
                    this.unsetIndexesDesc();
                    break;
                }
                this.setIndexesDesc((List)value);
                break;
            }
            case COLUMNS: {
                if (value == null) {
                    this.unsetColumns();
                    break;
                }
                this.setColumns((List)value);
                break;
            }
            case JOB_ID: {
                if (value == null) {
                    this.unsetJobId();
                    break;
                }
                this.setJobId((Long)value);
                break;
            }
            case EXPIRATION: {
                if (value == null) {
                    this.unsetExpiration();
                    break;
                }
                this.setExpiration((Long)value);
            }
        }
    }

    @Nullable
    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TABLET_ID: {
                return this.getTabletId();
            }
            case SCHEMA_HASH: {
                return this.getSchemaHash();
            }
            case ALTER_VERSION: {
                return this.getAlterVersion();
            }
            case ALTER_TABLET_TYPE: {
                return this.getAlterTabletType();
            }
            case IS_DROP_OP: {
                return this.isIsDropOp();
            }
            case ALTER_INVERTED_INDEXES: {
                return this.getAlterInvertedIndexes();
            }
            case INDEXES_DESC: {
                return this.getIndexesDesc();
            }
            case COLUMNS: {
                return this.getColumns();
            }
            case JOB_ID: {
                return this.getJobId();
            }
            case EXPIRATION: {
                return this.getExpiration();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TABLET_ID: {
                return this.isSetTabletId();
            }
            case SCHEMA_HASH: {
                return this.isSetSchemaHash();
            }
            case ALTER_VERSION: {
                return this.isSetAlterVersion();
            }
            case ALTER_TABLET_TYPE: {
                return this.isSetAlterTabletType();
            }
            case IS_DROP_OP: {
                return this.isSetIsDropOp();
            }
            case ALTER_INVERTED_INDEXES: {
                return this.isSetAlterInvertedIndexes();
            }
            case INDEXES_DESC: {
                return this.isSetIndexesDesc();
            }
            case COLUMNS: {
                return this.isSetColumns();
            }
            case JOB_ID: {
                return this.isSetJobId();
            }
            case EXPIRATION: {
                return this.isSetExpiration();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that instanceof TAlterInvertedIndexReq) {
            return this.equals((TAlterInvertedIndexReq)that);
        }
        return false;
    }

    public boolean equals(TAlterInvertedIndexReq that) {
        if (that == null) {
            return false;
        }
        if (this == that) {
            return true;
        }
        boolean this_present_tablet_id = true;
        boolean that_present_tablet_id = true;
        if (this_present_tablet_id || that_present_tablet_id) {
            if (!this_present_tablet_id || !that_present_tablet_id) {
                return false;
            }
            if (this.tablet_id != that.tablet_id) {
                return false;
            }
        }
        boolean this_present_schema_hash = true;
        boolean that_present_schema_hash = true;
        if (this_present_schema_hash || that_present_schema_hash) {
            if (!this_present_schema_hash || !that_present_schema_hash) {
                return false;
            }
            if (this.schema_hash != that.schema_hash) {
                return false;
            }
        }
        boolean this_present_alter_version = this.isSetAlterVersion();
        boolean that_present_alter_version = that.isSetAlterVersion();
        if (this_present_alter_version || that_present_alter_version) {
            if (!this_present_alter_version || !that_present_alter_version) {
                return false;
            }
            if (this.alter_version != that.alter_version) {
                return false;
            }
        }
        boolean this_present_alter_tablet_type = this.isSetAlterTabletType();
        boolean that_present_alter_tablet_type = that.isSetAlterTabletType();
        if (this_present_alter_tablet_type || that_present_alter_tablet_type) {
            if (!this_present_alter_tablet_type || !that_present_alter_tablet_type) {
                return false;
            }
            if (!this.alter_tablet_type.equals((Object)that.alter_tablet_type)) {
                return false;
            }
        }
        boolean this_present_is_drop_op = this.isSetIsDropOp();
        boolean that_present_is_drop_op = that.isSetIsDropOp();
        if (this_present_is_drop_op || that_present_is_drop_op) {
            if (!this_present_is_drop_op || !that_present_is_drop_op) {
                return false;
            }
            if (this.is_drop_op != that.is_drop_op) {
                return false;
            }
        }
        boolean this_present_alter_inverted_indexes = this.isSetAlterInvertedIndexes();
        boolean that_present_alter_inverted_indexes = that.isSetAlterInvertedIndexes();
        if (this_present_alter_inverted_indexes || that_present_alter_inverted_indexes) {
            if (!this_present_alter_inverted_indexes || !that_present_alter_inverted_indexes) {
                return false;
            }
            if (!this.alter_inverted_indexes.equals(that.alter_inverted_indexes)) {
                return false;
            }
        }
        boolean this_present_indexes_desc = this.isSetIndexesDesc();
        boolean that_present_indexes_desc = that.isSetIndexesDesc();
        if (this_present_indexes_desc || that_present_indexes_desc) {
            if (!this_present_indexes_desc || !that_present_indexes_desc) {
                return false;
            }
            if (!this.indexes_desc.equals(that.indexes_desc)) {
                return false;
            }
        }
        boolean this_present_columns = this.isSetColumns();
        boolean that_present_columns = that.isSetColumns();
        if (this_present_columns || that_present_columns) {
            if (!this_present_columns || !that_present_columns) {
                return false;
            }
            if (!this.columns.equals(that.columns)) {
                return false;
            }
        }
        boolean this_present_job_id = this.isSetJobId();
        boolean that_present_job_id = that.isSetJobId();
        if (this_present_job_id || that_present_job_id) {
            if (!this_present_job_id || !that_present_job_id) {
                return false;
            }
            if (this.job_id != that.job_id) {
                return false;
            }
        }
        boolean this_present_expiration = this.isSetExpiration();
        boolean that_present_expiration = that.isSetExpiration();
        if (this_present_expiration || that_present_expiration) {
            if (!this_present_expiration || !that_present_expiration) {
                return false;
            }
            if (this.expiration != that.expiration) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.tablet_id);
        hashCode = hashCode * 8191 + this.schema_hash;
        hashCode = hashCode * 8191 + (this.isSetAlterVersion() ? 131071 : 524287);
        if (this.isSetAlterVersion()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.alter_version);
        }
        hashCode = hashCode * 8191 + (this.isSetAlterTabletType() ? 131071 : 524287);
        if (this.isSetAlterTabletType()) {
            hashCode = hashCode * 8191 + this.alter_tablet_type.getValue();
        }
        hashCode = hashCode * 8191 + (this.isSetIsDropOp() ? 131071 : 524287);
        if (this.isSetIsDropOp()) {
            hashCode = hashCode * 8191 + (this.is_drop_op ? 131071 : 524287);
        }
        hashCode = hashCode * 8191 + (this.isSetAlterInvertedIndexes() ? 131071 : 524287);
        if (this.isSetAlterInvertedIndexes()) {
            hashCode = hashCode * 8191 + this.alter_inverted_indexes.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetIndexesDesc() ? 131071 : 524287);
        if (this.isSetIndexesDesc()) {
            hashCode = hashCode * 8191 + this.indexes_desc.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetColumns() ? 131071 : 524287);
        if (this.isSetColumns()) {
            hashCode = hashCode * 8191 + this.columns.hashCode();
        }
        hashCode = hashCode * 8191 + (this.isSetJobId() ? 131071 : 524287);
        if (this.isSetJobId()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.job_id);
        }
        hashCode = hashCode * 8191 + (this.isSetExpiration() ? 131071 : 524287);
        if (this.isSetExpiration()) {
            hashCode = hashCode * 8191 + TBaseHelper.hashCode((long)this.expiration);
        }
        return hashCode;
    }

    @Override
    public int compareTo(TAlterInvertedIndexReq other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.compare(this.isSetTabletId(), other.isSetTabletId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTabletId() && (lastComparison = TBaseHelper.compareTo((long)this.tablet_id, (long)other.tablet_id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetSchemaHash(), other.isSetSchemaHash());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSchemaHash() && (lastComparison = TBaseHelper.compareTo((int)this.schema_hash, (int)other.schema_hash)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetAlterVersion(), other.isSetAlterVersion());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAlterVersion() && (lastComparison = TBaseHelper.compareTo((long)this.alter_version, (long)other.alter_version)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetAlterTabletType(), other.isSetAlterTabletType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAlterTabletType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.alter_tablet_type), (Comparable)((Object)other.alter_tablet_type))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetIsDropOp(), other.isSetIsDropOp());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIsDropOp() && (lastComparison = TBaseHelper.compareTo((boolean)this.is_drop_op, (boolean)other.is_drop_op)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetAlterInvertedIndexes(), other.isSetAlterInvertedIndexes());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAlterInvertedIndexes() && (lastComparison = TBaseHelper.compareTo(this.alter_inverted_indexes, other.alter_inverted_indexes)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetIndexesDesc(), other.isSetIndexesDesc());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIndexesDesc() && (lastComparison = TBaseHelper.compareTo(this.indexes_desc, other.indexes_desc)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetColumns(), other.isSetColumns());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumns() && (lastComparison = TBaseHelper.compareTo(this.columns, other.columns)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetJobId(), other.isSetJobId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetJobId() && (lastComparison = TBaseHelper.compareTo((long)this.job_id, (long)other.job_id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.compare(this.isSetExpiration(), other.isSetExpiration());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetExpiration() && (lastComparison = TBaseHelper.compareTo((long)this.expiration, (long)other.expiration)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Nullable
    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        TAlterInvertedIndexReq.scheme(iprot).read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        TAlterInvertedIndexReq.scheme(oprot).write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TAlterInvertedIndexReq(");
        boolean first = true;
        sb.append("tablet_id:");
        sb.append(this.tablet_id);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("schema_hash:");
        sb.append(this.schema_hash);
        first = false;
        if (this.isSetAlterVersion()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("alter_version:");
            sb.append(this.alter_version);
            first = false;
        }
        if (this.isSetAlterTabletType()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("alter_tablet_type:");
            if (this.alter_tablet_type == null) {
                sb.append("null");
            } else {
                sb.append((Object)this.alter_tablet_type);
            }
            first = false;
        }
        if (this.isSetIsDropOp()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("is_drop_op:");
            sb.append(this.is_drop_op);
            first = false;
        }
        if (this.isSetAlterInvertedIndexes()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("alter_inverted_indexes:");
            if (this.alter_inverted_indexes == null) {
                sb.append("null");
            } else {
                sb.append(this.alter_inverted_indexes);
            }
            first = false;
        }
        if (this.isSetIndexesDesc()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("indexes_desc:");
            if (this.indexes_desc == null) {
                sb.append("null");
            } else {
                sb.append(this.indexes_desc);
            }
            first = false;
        }
        if (this.isSetColumns()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("columns:");
            if (this.columns == null) {
                sb.append("null");
            } else {
                sb.append(this.columns);
            }
            first = false;
        }
        if (this.isSetJobId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("job_id:");
            sb.append(this.job_id);
            first = false;
        }
        if (this.isSetExpiration()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("expiration:");
            sb.append(this.expiration);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private static <S extends IScheme> S scheme(TProtocol proto) {
        return (S)(StandardScheme.class.equals((Object)proto.getScheme()) ? STANDARD_SCHEME_FACTORY : TUPLE_SCHEME_FACTORY).getScheme();
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TABLET_ID, new FieldMetaData("tablet_id", 1, new FieldValueMetaData(10, "TTabletId")));
        tmpMap.put(_Fields.SCHEMA_HASH, new FieldMetaData("schema_hash", 1, new FieldValueMetaData(8, "TSchemaHash")));
        tmpMap.put(_Fields.ALTER_VERSION, new FieldMetaData("alter_version", 2, new FieldValueMetaData(10, "TVersion")));
        tmpMap.put(_Fields.ALTER_TABLET_TYPE, new FieldMetaData("alter_tablet_type", 2, (FieldValueMetaData)new EnumMetaData(16, TAlterTabletType.class)));
        tmpMap.put(_Fields.IS_DROP_OP, new FieldMetaData("is_drop_op", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.ALTER_INVERTED_INDEXES, new FieldMetaData("alter_inverted_indexes", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, TOlapTableIndex.class))));
        tmpMap.put(_Fields.INDEXES_DESC, new FieldMetaData("indexes_desc", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, TOlapTableIndex.class))));
        tmpMap.put(_Fields.COLUMNS, new FieldMetaData("columns", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, TColumn.class))));
        tmpMap.put(_Fields.JOB_ID, new FieldMetaData("job_id", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.EXPIRATION, new FieldMetaData("expiration", 2, new FieldValueMetaData(10)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(TAlterInvertedIndexReq.class, metaDataMap);
    }

    private static class TAlterInvertedIndexReqTupleScheme
    extends TupleScheme<TAlterInvertedIndexReq> {
        private TAlterInvertedIndexReqTupleScheme() {
        }

        public void write(TProtocol prot, TAlterInvertedIndexReq struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI64(struct.tablet_id);
            oprot.writeI32(struct.schema_hash);
            BitSet optionals = new BitSet();
            if (struct.isSetAlterVersion()) {
                optionals.set(0);
            }
            if (struct.isSetAlterTabletType()) {
                optionals.set(1);
            }
            if (struct.isSetIsDropOp()) {
                optionals.set(2);
            }
            if (struct.isSetAlterInvertedIndexes()) {
                optionals.set(3);
            }
            if (struct.isSetIndexesDesc()) {
                optionals.set(4);
            }
            if (struct.isSetColumns()) {
                optionals.set(5);
            }
            if (struct.isSetJobId()) {
                optionals.set(6);
            }
            if (struct.isSetExpiration()) {
                optionals.set(7);
            }
            oprot.writeBitSet(optionals, 8);
            if (struct.isSetAlterVersion()) {
                oprot.writeI64(struct.alter_version);
            }
            if (struct.isSetAlterTabletType()) {
                oprot.writeI32(struct.alter_tablet_type.getValue());
            }
            if (struct.isSetIsDropOp()) {
                oprot.writeBool(struct.is_drop_op);
            }
            if (struct.isSetAlterInvertedIndexes()) {
                oprot.writeI32(struct.alter_inverted_indexes.size());
                for (TOlapTableIndex _iter68 : struct.alter_inverted_indexes) {
                    _iter68.write((TProtocol)oprot);
                }
            }
            if (struct.isSetIndexesDesc()) {
                oprot.writeI32(struct.indexes_desc.size());
                for (TOlapTableIndex _iter69 : struct.indexes_desc) {
                    _iter69.write((TProtocol)oprot);
                }
            }
            if (struct.isSetColumns()) {
                oprot.writeI32(struct.columns.size());
                for (TColumn _iter70 : struct.columns) {
                    _iter70.write((TProtocol)oprot);
                }
            }
            if (struct.isSetJobId()) {
                oprot.writeI64(struct.job_id);
            }
            if (struct.isSetExpiration()) {
                oprot.writeI64(struct.expiration);
            }
        }

        public void read(TProtocol prot, TAlterInvertedIndexReq struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.tablet_id = iprot.readI64();
            struct.setTabletIdIsSet(true);
            struct.schema_hash = iprot.readI32();
            struct.setSchemaHashIsSet(true);
            BitSet incoming = iprot.readBitSet(8);
            if (incoming.get(0)) {
                struct.alter_version = iprot.readI64();
                struct.setAlterVersionIsSet(true);
            }
            if (incoming.get(1)) {
                struct.alter_tablet_type = TAlterTabletType.findByValue(iprot.readI32());
                struct.setAlterTabletTypeIsSet(true);
            }
            if (incoming.get(2)) {
                struct.is_drop_op = iprot.readBool();
                struct.setIsDropOpIsSet(true);
            }
            if (incoming.get(3)) {
                TList _list71 = iprot.readListBegin((byte)12);
                struct.alter_inverted_indexes = new ArrayList<TOlapTableIndex>(_list71.size);
                for (int _i73 = 0; _i73 < _list71.size; ++_i73) {
                    TOlapTableIndex _elem72 = new TOlapTableIndex();
                    _elem72.read((TProtocol)iprot);
                    struct.alter_inverted_indexes.add(_elem72);
                }
                struct.setAlterInvertedIndexesIsSet(true);
            }
            if (incoming.get(4)) {
                TList _list74 = iprot.readListBegin((byte)12);
                struct.indexes_desc = new ArrayList<TOlapTableIndex>(_list74.size);
                for (int _i76 = 0; _i76 < _list74.size; ++_i76) {
                    TOlapTableIndex _elem75 = new TOlapTableIndex();
                    _elem75.read((TProtocol)iprot);
                    struct.indexes_desc.add(_elem75);
                }
                struct.setIndexesDescIsSet(true);
            }
            if (incoming.get(5)) {
                TList _list77 = iprot.readListBegin((byte)12);
                struct.columns = new ArrayList<TColumn>(_list77.size);
                for (int _i79 = 0; _i79 < _list77.size; ++_i79) {
                    TColumn _elem78 = new TColumn();
                    _elem78.read((TProtocol)iprot);
                    struct.columns.add(_elem78);
                }
                struct.setColumnsIsSet(true);
            }
            if (incoming.get(6)) {
                struct.job_id = iprot.readI64();
                struct.setJobIdIsSet(true);
            }
            if (incoming.get(7)) {
                struct.expiration = iprot.readI64();
                struct.setExpirationIsSet(true);
            }
        }
    }

    private static class TAlterInvertedIndexReqTupleSchemeFactory
    implements SchemeFactory {
        private TAlterInvertedIndexReqTupleSchemeFactory() {
        }

        public TAlterInvertedIndexReqTupleScheme getScheme() {
            return new TAlterInvertedIndexReqTupleScheme();
        }
    }

    private static class TAlterInvertedIndexReqStandardScheme
    extends StandardScheme<TAlterInvertedIndexReq> {
        private TAlterInvertedIndexReqStandardScheme() {
        }

        public void read(TProtocol iprot, TAlterInvertedIndexReq struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 10) {
                            struct.tablet_id = iprot.readI64();
                            struct.setTabletIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 8) {
                            struct.schema_hash = iprot.readI32();
                            struct.setSchemaHashIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 10) {
                            struct.alter_version = iprot.readI64();
                            struct.setAlterVersionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 8) {
                            struct.alter_tablet_type = TAlterTabletType.findByValue(iprot.readI32());
                            struct.setAlterTabletTypeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 2) {
                            struct.is_drop_op = iprot.readBool();
                            struct.setIsDropOpIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 15) {
                            TList _list56 = iprot.readListBegin();
                            struct.alter_inverted_indexes = new ArrayList<TOlapTableIndex>(_list56.size);
                            for (int _i58 = 0; _i58 < _list56.size; ++_i58) {
                                TOlapTableIndex _elem57 = new TOlapTableIndex();
                                _elem57.read(iprot);
                                struct.alter_inverted_indexes.add(_elem57);
                            }
                            iprot.readListEnd();
                            struct.setAlterInvertedIndexesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 15) {
                            TList _list59 = iprot.readListBegin();
                            struct.indexes_desc = new ArrayList<TOlapTableIndex>(_list59.size);
                            for (int _i61 = 0; _i61 < _list59.size; ++_i61) {
                                TOlapTableIndex _elem60 = new TOlapTableIndex();
                                _elem60.read(iprot);
                                struct.indexes_desc.add(_elem60);
                            }
                            iprot.readListEnd();
                            struct.setIndexesDescIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 15) {
                            TList _list62 = iprot.readListBegin();
                            struct.columns = new ArrayList<TColumn>(_list62.size);
                            for (int _i64 = 0; _i64 < _list62.size; ++_i64) {
                                TColumn _elem63 = new TColumn();
                                _elem63.read(iprot);
                                struct.columns.add(_elem63);
                            }
                            iprot.readListEnd();
                            struct.setColumnsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 10) {
                            struct.job_id = iprot.readI64();
                            struct.setJobIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 10) {
                            struct.expiration = iprot.readI64();
                            struct.setExpirationIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetTabletId()) {
                throw new TProtocolException("Required field 'tablet_id' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetSchemaHash()) {
                throw new TProtocolException("Required field 'schema_hash' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            struct.validate();
        }

        public void write(TProtocol oprot, TAlterInvertedIndexReq struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(TABLET_ID_FIELD_DESC);
            oprot.writeI64(struct.tablet_id);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(SCHEMA_HASH_FIELD_DESC);
            oprot.writeI32(struct.schema_hash);
            oprot.writeFieldEnd();
            if (struct.isSetAlterVersion()) {
                oprot.writeFieldBegin(ALTER_VERSION_FIELD_DESC);
                oprot.writeI64(struct.alter_version);
                oprot.writeFieldEnd();
            }
            if (struct.alter_tablet_type != null && struct.isSetAlterTabletType()) {
                oprot.writeFieldBegin(ALTER_TABLET_TYPE_FIELD_DESC);
                oprot.writeI32(struct.alter_tablet_type.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.isSetIsDropOp()) {
                oprot.writeFieldBegin(IS_DROP_OP_FIELD_DESC);
                oprot.writeBool(struct.is_drop_op);
                oprot.writeFieldEnd();
            }
            if (struct.alter_inverted_indexes != null && struct.isSetAlterInvertedIndexes()) {
                oprot.writeFieldBegin(ALTER_INVERTED_INDEXES_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.alter_inverted_indexes.size()));
                for (TOlapTableIndex _iter65 : struct.alter_inverted_indexes) {
                    _iter65.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.indexes_desc != null && struct.isSetIndexesDesc()) {
                oprot.writeFieldBegin(INDEXES_DESC_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.indexes_desc.size()));
                for (TOlapTableIndex _iter66 : struct.indexes_desc) {
                    _iter66.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.columns != null && struct.isSetColumns()) {
                oprot.writeFieldBegin(COLUMNS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.columns.size()));
                for (TColumn _iter67 : struct.columns) {
                    _iter67.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.isSetJobId()) {
                oprot.writeFieldBegin(JOB_ID_FIELD_DESC);
                oprot.writeI64(struct.job_id);
                oprot.writeFieldEnd();
            }
            if (struct.isSetExpiration()) {
                oprot.writeFieldBegin(EXPIRATION_FIELD_DESC);
                oprot.writeI64(struct.expiration);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class TAlterInvertedIndexReqStandardSchemeFactory
    implements SchemeFactory {
        private TAlterInvertedIndexReqStandardSchemeFactory() {
        }

        public TAlterInvertedIndexReqStandardScheme getScheme() {
            return new TAlterInvertedIndexReqStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TABLET_ID(1, "tablet_id"),
        SCHEMA_HASH(2, "schema_hash"),
        ALTER_VERSION(3, "alter_version"),
        ALTER_TABLET_TYPE(4, "alter_tablet_type"),
        IS_DROP_OP(5, "is_drop_op"),
        ALTER_INVERTED_INDEXES(6, "alter_inverted_indexes"),
        INDEXES_DESC(7, "indexes_desc"),
        COLUMNS(8, "columns"),
        JOB_ID(9, "job_id"),
        EXPIRATION(10, "expiration");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        @Nullable
        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TABLET_ID;
                }
                case 2: {
                    return SCHEMA_HASH;
                }
                case 3: {
                    return ALTER_VERSION;
                }
                case 4: {
                    return ALTER_TABLET_TYPE;
                }
                case 5: {
                    return IS_DROP_OP;
                }
                case 6: {
                    return ALTER_INVERTED_INDEXES;
                }
                case 7: {
                    return INDEXES_DESC;
                }
                case 8: {
                    return COLUMNS;
                }
                case 9: {
                    return JOB_ID;
                }
                case 10: {
                    return EXPIRATION;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        @Nullable
        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

