/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

public class ByteBufferNetworkInputStream
extends InputStream {
    private ArrayBlockingQueue<ByteArrayInputStream> queue;
    private ByteArrayInputStream currentInputStream;
    private volatile boolean finished = false;
    private volatile boolean closed = false;

    public ByteBufferNetworkInputStream() {
        this(32);
    }

    public ByteBufferNetworkInputStream(int capacity) {
        this.queue = new ArrayBlockingQueue(capacity);
    }

    public void fillByteBuffer(ByteBuffer buffer) throws IOException, InterruptedException {
        if (this.closed) {
            throw new IOException("Stream is already closed.");
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.bytesCopy(buffer));
        this.queue.offer(inputStream, 300L, TimeUnit.SECONDS);
    }

    public byte[] bytesCopy(ByteBuffer buffer) {
        byte[] result = new byte[buffer.limit() - buffer.position()];
        System.arraycopy(buffer.array(), buffer.position(), result, 0, result.length);
        return result;
    }

    public void markFinished() {
        this.finished = true;
    }

    private ByteArrayInputStream getNextByteArrayStream() throws IOException {
        if (this.currentInputStream == null || this.currentInputStream.available() == 0) {
            while (!this.finished || !this.queue.isEmpty()) {
                try {
                    this.currentInputStream = this.queue.poll(1L, TimeUnit.SECONDS);
                    if (this.currentInputStream == null) continue;
                    return this.currentInputStream;
                }
                catch (InterruptedException e) {
                    throw new IOException("Failed to get next stream");
                }
            }
            return null;
        }
        return this.currentInputStream;
    }

    @Override
    public int read() throws IOException {
        ByteArrayInputStream stream = this.getNextByteArrayStream();
        if (stream == null) {
            return -1;
        }
        return stream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        ByteArrayInputStream stream = this.getNextByteArrayStream();
        if (stream == null) {
            return -1;
        }
        return stream.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        ByteArrayInputStream stream = this.getNextByteArrayStream();
        if (stream == null) {
            return;
        }
        stream.close();
        while (!this.queue.isEmpty()) {
            this.queue.poll().close();
        }
    }
}

