/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.doris.common.PatternMatcherException;

public class PatternMatcher {
    public static final PatternMatcher MATCH_ANY = new PatternMatcher(Pattern.compile(".*"));
    private Pattern pattern;
    private String originString;
    private boolean caseSensitive;
    private static final Set<Character> FORBIDDEN_CHARS = Sets.newHashSet((Object[])new Character[]{Character.valueOf('<'), Character.valueOf('('), Character.valueOf('['), Character.valueOf('{'), Character.valueOf('^'), Character.valueOf('='), Character.valueOf('$'), Character.valueOf('!'), Character.valueOf('|'), Character.valueOf(']'), Character.valueOf('}'), Character.valueOf(')'), Character.valueOf('?'), Character.valueOf('*'), Character.valueOf('+'), Character.valueOf('>'), Character.valueOf('@')});

    public PatternMatcher(Pattern pattern) {
        this.pattern = pattern;
    }

    public PatternMatcher(String originString, boolean caseSensitive) {
        this.originString = caseSensitive ? originString : originString.toLowerCase(Locale.ROOT);
        this.caseSensitive = caseSensitive;
    }

    public boolean match(String candidate) {
        if (candidate == null) {
            return false;
        }
        if (this.pattern != null) {
            return this.pattern.matcher(candidate).matches();
        }
        if (this.caseSensitive) {
            return candidate.equals(this.originString);
        }
        return candidate.toLowerCase(Locale.ROOT).equals(this.originString);
    }

    public static PatternMatcher createFlatPattern(String originString, boolean caseSensitive) {
        return PatternMatcher.createFlatPattern(originString, caseSensitive, false);
    }

    public static PatternMatcher createFlatPattern(String originString, boolean caseSensitive, boolean matchAny) {
        if (matchAny) {
            return MATCH_ANY;
        }
        return new PatternMatcher(originString, caseSensitive);
    }

    private static String convertMysqlPattern(String mysqlPattern) throws PatternMatcherException {
        char ch;
        int i;
        String newMysqlPattern = mysqlPattern;
        StringBuilder sb = new StringBuilder();
        block12: for (i = 0; i < newMysqlPattern.length(); ++i) {
            ch = newMysqlPattern.charAt(i);
            PatternMatcher.checkPermittedCharactor(ch);
            switch (ch) {
                case '%': {
                    sb.append(".*");
                    continue block12;
                }
                case '.': {
                    sb.append("\\.");
                    continue block12;
                }
                case '_': {
                    sb.append(".");
                    continue block12;
                }
                case '\\': {
                    if (i == newMysqlPattern.length() - 1) {
                        sb.append('\\');
                        continue block12;
                    }
                    char nextChar = newMysqlPattern.charAt(i + 1);
                    switch (nextChar) {
                        case '%': 
                        case '\\': 
                        case '_': {
                            sb.append(nextChar);
                            ++i;
                            continue block12;
                        }
                    }
                    continue block12;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        newMysqlPattern = sb.toString();
        sb = new StringBuilder();
        block13: for (i = 0; i < newMysqlPattern.length(); ++i) {
            ch = newMysqlPattern.charAt(i);
            switch (ch) {
                case '\\': {
                    if (i == newMysqlPattern.length() - 1) {
                        sb.append('\\').append('\\');
                        continue block13;
                    }
                    if (newMysqlPattern.charAt(i + 1) == '.') {
                        sb.append('\\').append('.');
                        ++i;
                        continue block13;
                    }
                    sb.append('\\').append('\\');
                    continue block13;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private static void checkPermittedCharactor(char c) throws PatternMatcherException {
        if (FORBIDDEN_CHARS.contains(Character.valueOf(c))) {
            throw new PatternMatcherException("Forbidden charactor: '" + c + "'");
        }
    }

    public static PatternMatcher createMysqlPattern(String mysqlPattern, boolean caseSensitive) throws PatternMatcherException {
        PatternMatcher matcher;
        String newMysqlPattern = Strings.nullToEmpty((String)mysqlPattern);
        String javaPattern = PatternMatcher.convertMysqlPattern(newMysqlPattern);
        try {
            matcher = caseSensitive ? new PatternMatcher(Pattern.compile(javaPattern)) : new PatternMatcher(Pattern.compile(javaPattern, 2));
        }
        catch (Exception e) {
            throw new PatternMatcherException("Bad pattern in SQL: " + e.getMessage());
        }
        return matcher;
    }
}

