/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.doris.common.Config;
import org.apache.doris.common.ConfigException;
import org.apache.doris.common.ExperimentalUtil;
import org.apache.doris.common.LdapConfig;
import org.apache.doris.common.PatternMatcher;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConfigBase {
    private static final Logger LOG = LogManager.getLogger(ConfigBase.class);
    private static String confFile;
    private static String customConfFile;
    public static Class<? extends ConfigBase> confClass;
    public static Map<String, Field> confFields;
    private static String ldapConfFile;
    private static String ldapCustomConfFile;
    public static Class<? extends ConfigBase> ldapConfClass;
    public static Map<String, Field> ldapConfFields;
    private boolean isLdapConfig = false;

    public void init(String configFile) throws Exception {
        if (this instanceof Config) {
            confClass = this.getClass();
            confFile = configFile;
            confFields = Maps.newHashMap();
            for (Field field : confClass.getFields()) {
                ConfField confField = field.getAnnotation(ConfField.class);
                if (confField == null) continue;
                confFields.put(field.getName(), field);
                if (confField.expType() != ExperimentalUtil.ExperimentalType.EXPERIMENTAL && confField.expType() != ExperimentalUtil.ExperimentalType.EXPERIMENTAL_ONLINE) continue;
                confFields.put("experimental_" + field.getName(), field);
            }
            this.initConf(confFile);
        } else if (this instanceof LdapConfig) {
            this.isLdapConfig = true;
            ldapConfClass = this.getClass();
            ldapConfFile = configFile;
            for (Field field : ldapConfClass.getFields()) {
                ConfField confField = field.getAnnotation(ConfField.class);
                if (confField == null) continue;
                ldapConfFields.put(field.getName(), field);
                if (confField.expType() != ExperimentalUtil.ExperimentalType.EXPERIMENTAL && confField.expType() != ExperimentalUtil.ExperimentalType.EXPERIMENTAL_ONLINE) continue;
                ldapConfFields.put("experimental_" + field.getName(), field);
            }
            this.initConf(ldapConfFile);
        }
    }

    public void initCustom(String customConfFile) throws Exception {
        ConfigBase.customConfFile = customConfFile;
        File file = new File(customConfFile);
        if (file.exists() && file.isFile()) {
            this.initConf(customConfFile);
        }
    }

    private void initConf(String confFile) throws Exception {
        Properties props = new Properties();
        props.load(new FileReader(confFile));
        this.replacedByEnv(props);
        ConfigBase.setFields(props, this.isLdapConfig);
    }

    public static HashMap<String, String> dump() {
        Field[] fields;
        HashMap<String, String> map = new HashMap<String, String>();
        for (Field f : fields = confClass.getFields()) {
            ConfField anno = f.getAnnotation(ConfField.class);
            if (anno == null) continue;
            map.put(f.getName(), ConfigBase.getConfValue(f));
        }
        return map;
    }

    public static String getConfValue(Field field) {
        try {
            if (field.getType().isArray()) {
                switch (field.getType().getSimpleName()) {
                    case "boolean[]": {
                        return Arrays.toString((boolean[])field.get(null));
                    }
                    case "char[]": {
                        return Arrays.toString((char[])field.get(null));
                    }
                    case "byte[]": {
                        return Arrays.toString((byte[])field.get(null));
                    }
                    case "short[]": {
                        return Arrays.toString((short[])field.get(null));
                    }
                    case "int[]": {
                        return Arrays.toString((int[])field.get(null));
                    }
                    case "long[]": {
                        return Arrays.toString((long[])field.get(null));
                    }
                    case "float[]": {
                        return Arrays.toString((float[])field.get(null));
                    }
                    case "double[]": {
                        return Arrays.toString((double[])field.get(null));
                    }
                }
                return Arrays.toString((Object[])field.get(null));
            }
            return String.valueOf(field.get(null));
        }
        catch (Exception e) {
            return String.format("Failed to get config %s: %s", field.getName(), e.getMessage());
        }
    }

    private void replacedByEnv(Properties props) throws Exception {
        Pattern pattern = Pattern.compile("\\$\\{([^}]*)\\}");
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key);
            Matcher m = pattern.matcher(value);
            while (m.find()) {
                String envValue = System.getProperty(m.group(1));
                String string = envValue = envValue != null ? envValue : System.getenv(m.group(1));
                if (envValue != null) {
                    value = value.replace("${" + m.group(1) + "}", envValue);
                    continue;
                }
                throw new Exception("no such env variable: " + m.group(1));
            }
            props.setProperty(key, value);
        }
    }

    private static void setFields(Properties props, boolean isLdapConfig) throws Exception {
        Field[] fields;
        Class<? extends ConfigBase> theClass = isLdapConfig ? ldapConfClass : confClass;
        for (Field f : fields = theClass.getFields()) {
            String confKey;
            String confVal;
            ConfField anno = f.getAnnotation(ConfField.class);
            if (anno == null || Strings.isNullOrEmpty((String)(confVal = props.getProperty(confKey = f.getName(), props.getProperty("experimental_" + confKey))))) continue;
            ConfigBase.setConfigField(f, confVal);
        }
    }

    private static void setConfigField(Field f, String confVal) throws Exception {
        confVal = confVal.trim();
        String[] sa = confVal.split(",");
        for (int i = 0; i < sa.length; ++i) {
            sa[i] = sa[i].trim();
        }
        switch (f.getType().getSimpleName()) {
            case "short": {
                f.setShort(null, Short.parseShort(confVal));
                break;
            }
            case "int": {
                f.setInt(null, Integer.parseInt(confVal));
                break;
            }
            case "long": {
                f.setLong(null, Long.parseLong(confVal));
                break;
            }
            case "double": {
                f.setDouble(null, Double.parseDouble(confVal));
                break;
            }
            case "boolean": {
                if (!ConfigBase.isBoolean(confVal)) break;
                f.setBoolean(null, Boolean.parseBoolean(confVal));
                break;
            }
            case "String": {
                f.set(null, confVal);
                break;
            }
            case "short[]": {
                short[] sha = new short[sa.length];
                for (int i = 0; i < sha.length; ++i) {
                    sha[i] = Short.parseShort(sa[i]);
                }
                f.set(null, sha);
                break;
            }
            case "int[]": {
                int[] ia = new int[sa.length];
                for (int i = 0; i < ia.length; ++i) {
                    ia[i] = Integer.parseInt(sa[i]);
                }
                f.set(null, ia);
                break;
            }
            case "long[]": {
                long[] la = new long[sa.length];
                for (int i = 0; i < la.length; ++i) {
                    la[i] = Long.parseLong(sa[i]);
                }
                f.set(null, la);
                break;
            }
            case "double[]": {
                double[] da = new double[sa.length];
                for (int i = 0; i < da.length; ++i) {
                    da[i] = Double.parseDouble(sa[i]);
                }
                f.set(null, da);
                break;
            }
            case "boolean[]": {
                boolean[] ba = new boolean[sa.length];
                for (int i = 0; i < ba.length; ++i) {
                    if (!ConfigBase.isBoolean(sa[i])) continue;
                    ba[i] = Boolean.parseBoolean(sa[i]);
                }
                f.set(null, ba);
                break;
            }
            case "String[]": {
                f.set(null, sa);
                break;
            }
            default: {
                throw new Exception("unknown type: " + f.getType().getSimpleName());
            }
        }
    }

    private static boolean isBoolean(String s) {
        if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("false")) {
            return true;
        }
        throw new IllegalArgumentException("type mismatch");
    }

    public static synchronized void setMutableConfig(String key, String value) throws ConfigException {
        ConfField anno;
        Field field = confFields.get(key);
        if (field == null) {
            if (ldapConfFields.containsKey(key)) {
                field = ldapConfFields.get(key);
            } else {
                throw new ConfigException("Config '" + key + "' does not exist");
            }
        }
        if (!(anno = field.getAnnotation(ConfField.class)).mutable()) {
            throw new ConfigException("Config '" + key + "' is not mutable");
        }
        try {
            anno.callback().newInstance().handle(field, value);
        }
        catch (Exception e) {
            throw new ConfigException("Failed to set config '" + key + "'. err: " + e.getMessage());
        }
        LOG.info("set config {} to {}", (Object)key, (Object)value);
    }

    private static void getDisplayConfigInfo(Map<String, Field> configsToFilter, Map<String, Field> allConfigs) {
        for (Map.Entry<String, Field> e : configsToFilter.entrySet()) {
            Field f = e.getValue();
            ConfField confField = f.getAnnotation(ConfField.class);
            boolean isExperimental = e.getKey().startsWith("experimental_");
            if (isExperimental && confField.expType() != ExperimentalUtil.ExperimentalType.EXPERIMENTAL || !isExperimental && confField.expType() == ExperimentalUtil.ExperimentalType.EXPERIMENTAL) continue;
            allConfigs.put(e.getKey(), f);
        }
    }

    public static synchronized List<List<String>> getConfigInfo(PatternMatcher matcher) {
        HashMap allConfFields = Maps.newHashMap();
        ConfigBase.getDisplayConfigInfo(confFields, allConfFields);
        ConfigBase.getDisplayConfigInfo(ldapConfFields, allConfFields);
        return allConfFields.entrySet().stream().sorted(Map.Entry.comparingByKey()).flatMap(e -> {
            String confKey = (String)e.getKey();
            Field f = (Field)e.getValue();
            ConfField confField = f.getAnnotation(ConfField.class);
            if (matcher == null || matcher.match(confKey)) {
                ArrayList config = Lists.newArrayList();
                config.add(confKey);
                config.add(ConfigBase.getConfValue(f));
                config.add(f.getType().getSimpleName());
                config.add(String.valueOf(confField.mutable()));
                config.add(String.valueOf(confField.masterOnly()));
                config.add(confField.comment());
                return Stream.of(config);
            }
            return Stream.empty();
        }).collect(Collectors.toList());
    }

    public static synchronized boolean checkIsMasterOnly(String key) {
        Field f = confFields.get(key);
        if (f == null) {
            return false;
        }
        ConfField anno = f.getAnnotation(ConfField.class);
        return anno != null && anno.mutable() && anno.masterOnly();
    }

    public static synchronized void persistConfig(Map<String, String> customConf, boolean resetPersist) throws IOException {
        File file = new File(customConfFile);
        if (!file.exists()) {
            file.createNewFile();
        } else if (resetPersist) {
            PrintWriter writer = new PrintWriter(file);
            Object object = null;
            try {
                writer.print("");
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (writer != null) {
                    if (object != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        }
        Properties props = new Properties();
        props.load(new FileReader(customConfFile));
        for (Map.Entry entry : customConf.entrySet()) {
            props.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        Throwable throwable = null;
        try (FileOutputStream fos = new FileOutputStream(file);){
            props.store(fos, "THIS IS AN AUTO GENERATED CONFIG FILE.\nYou can modify this file manually, and the configurations in this file\nwill overwrite the configurations in fe.conf");
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
    }

    public static int getConfigNumByExperimentalType(ExperimentalUtil.ExperimentalType type) {
        int num = 0;
        for (Field field : Config.class.getFields()) {
            ConfField confField = field.getAnnotation(ConfField.class);
            if (confField == null || confField.expType() != type) continue;
            ++num;
        }
        return num;
    }

    static {
        ldapConfFields = Maps.newHashMap();
    }

    static class DefaultConfHandler
    implements ConfHandler {
        DefaultConfHandler() {
        }

        @Override
        public void handle(Field field, String confVal) throws Exception {
            ConfigBase.setConfigField(field, confVal);
        }
    }

    public static interface ConfHandler {
        public void handle(Field var1, String var2) throws Exception;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ConfField {
        public boolean mutable() default false;

        public boolean masterOnly() default false;

        public String comment() default "";

        public ExperimentalUtil.ExperimentalType expType() default ExperimentalUtil.ExperimentalType.NONE;

        public Class<? extends ConfHandler> callback() default DefaultConfHandler.class;

        public String[] description() default {"\u5f85\u8865\u5145", "TODO"};

        public String[] options() default {};
    }
}

