/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.common;

import org.apache.doris.common.ConfigBase;
import org.apache.doris.common.EnvUtils;
import org.apache.doris.common.ExperimentalUtil;

public class Config
extends ConfigBase {
    @ConfigBase.ConfField(description={"\u7528\u6237\u81ea\u5b9a\u4e49\u914d\u7f6e\u6587\u4ef6\u7684\u8def\u5f84\uff0c\u7528\u4e8e\u5b58\u653e fe_custom.conf\u3002\u8be5\u6587\u4ef6\u4e2d\u7684\u914d\u7f6e\u4f1a\u8986\u76d6 fe.conf \u4e2d\u7684\u914d\u7f6e", "The path of the user-defined configuration file, used to store fe_custom.conf. The configuration in this file will override the configuration in fe.conf"})
    public static String custom_config_dir = EnvUtils.getDorisHome() + "/conf";
    @ConfigBase.ConfField(description={"fe.log \u548c fe.audit.log \u7684\u6700\u5927\u6587\u4ef6\u5927\u5c0f\u3002\u8d85\u8fc7\u8fd9\u4e2a\u5927\u5c0f\u540e\uff0c\u65e5\u5fd7\u6587\u4ef6\u4f1a\u88ab\u5207\u5206", "The maximum file size of fe.log and fe.audit.log. After exceeding this size, the log file will be split"})
    public static int log_roll_size_mb = 1024;
    @ConfigBase.ConfField(description={"FE \u65e5\u5fd7\u6587\u4ef6\u7684\u5b58\u653e\u8def\u5f84\uff0c\u7528\u4e8e\u5b58\u653e fe.log\u3002", "The path of the FE log file, used to store fe.log"})
    public static String sys_log_dir = System.getenv("DORIS_HOME") + "/log";
    @ConfigBase.ConfField(description={"FE \u65e5\u5fd7\u7684\u7ea7\u522b", "The level of FE log"}, options={"INFO", "WARN", "ERROR", "FATAL"})
    public static String sys_log_level = "INFO";
    @ConfigBase.ConfField(description={"FE \u65e5\u5fd7\u7684\u8f93\u51fa\u6a21\u5f0f\uff0c\u5176\u4e2d NORMAL \u4e3a\u9ed8\u8ba4\u7684\u8f93\u51fa\u6a21\u5f0f\uff0c\u65e5\u5fd7\u540c\u6b65\u8f93\u51fa\u4e14\u5305\u542b\u4f4d\u7f6e\u4fe1\u606f\uff0cBRIEF \u6a21\u5f0f\u662f\u65e5\u5fd7\u540c\u6b65\u8f93\u51fa\u4f46\u4e0d\u5305\u542b\u4f4d\u7f6e\u4fe1\u606f\uff0cASYNC \u6a21\u5f0f\u662f\u65e5\u5fd7\u5f02\u6b65\u8f93\u51fa\u4e14\u4e0d\u5305\u542b\u4f4d\u7f6e\u4fe1\u606f\uff0c\u4e09\u79cd\u65e5\u5fd7\u8f93\u51fa\u6a21\u5f0f\u7684\u6027\u80fd\u4f9d\u6b21\u9012\u589e", "The output mode of FE log, and NORMAL mode is the default output mode, which means the logs are synchronized and contain location information. BRIEF mode is synchronized and does not contain location information. ASYNC mode is asynchronous and does not contain location information. The performance of the three log output modes increases in sequence"}, options={"NORMAL", "BRIEF", "ASYNC"})
    public static String sys_log_mode = "NORMAL";
    @ConfigBase.ConfField(description={"FE \u65e5\u5fd7\u6587\u4ef6\u7684\u6700\u5927\u6570\u91cf\u3002\u8d85\u8fc7\u8fd9\u4e2a\u6570\u91cf\u540e\uff0c\u6700\u8001\u7684\u65e5\u5fd7\u6587\u4ef6\u4f1a\u88ab\u5220\u9664", "The maximum number of FE log files. After exceeding this number, the oldest log file will be deleted"})
    public static int sys_log_roll_num = 10;
    @ConfigBase.ConfField(description={"Verbose \u6a21\u5757\u3002VERBOSE \u7ea7\u522b\u7684\u65e5\u5fd7\u662f\u901a\u8fc7 log4j \u7684 DEBUG \u7ea7\u522b\u5b9e\u73b0\u7684\u3002\u5982\u8bbe\u7f6e\u4e3a `org.apache.doris.catalog`\uff0c\u5219\u4f1a\u6253\u5370\u8fd9\u4e2a package \u4e0b\u7684\u7c7b\u7684 DEBUG \u65e5\u5fd7\u3002", "Verbose module. The VERBOSE level log is implemented by the DEBUG level of log4j. If set to `org.apache.doris.catalog`, the DEBUG log of the class under this package will be printed."})
    public static String[] sys_log_verbose_modules = new String[0];
    @ConfigBase.ConfField(description={"FE \u65e5\u5fd7\u6587\u4ef6\u7684\u5207\u5206\u5468\u671f", "The split cycle of the FE log file"}, options={"DAY", "HOUR"})
    public static String sys_log_roll_interval = "DAY";
    @ConfigBase.ConfField(description={"FE \u65e5\u5fd7\u6587\u4ef6\u7684\u6700\u5927\u5b58\u6d3b\u65f6\u95f4\u3002\u8d85\u8fc7\u8fd9\u4e2a\u65f6\u95f4\u540e\uff0c\u65e5\u5fd7\u6587\u4ef6\u4f1a\u88ab\u5220\u9664\u3002\u652f\u6301\u7684\u683c\u5f0f\u5305\u62ec\uff1a7d, 10h, 60m, 120s", "The maximum survival time of the FE log file. After exceeding this time, the log file will be deleted. Supported formats include: 7d, 10h, 60m, 120s"})
    public static String sys_log_delete_age = "7d";
    @ConfigBase.ConfField(description={"\u662f\u5426\u538b\u7f29 FE \u7684\u5386\u53f2\u65e5\u5fd7", "enable compression for FE log file"})
    public static boolean sys_log_enable_compress = false;
    @ConfigBase.ConfField(description={"FE \u5ba1\u8ba1\u65e5\u5fd7\u6587\u4ef6\u7684\u5b58\u653e\u8def\u5f84\uff0c\u7528\u4e8e\u5b58\u653e fe.audit.log\u3002", "The path of the FE audit log file, used to store fe.audit.log"})
    public static String audit_log_dir = System.getenv("DORIS_HOME") + "/log";
    @ConfigBase.ConfField(description={"FE \u5ba1\u8ba1\u65e5\u5fd7\u6587\u4ef6\u7684\u6700\u5927\u6570\u91cf\u3002\u8d85\u8fc7\u8fd9\u4e2a\u6570\u91cf\u540e\uff0c\u6700\u8001\u7684\u65e5\u5fd7\u6587\u4ef6\u4f1a\u88ab\u5220\u9664", "The maximum number of FE audit log files. After exceeding this number, the oldest log file will be deleted"})
    public static int audit_log_roll_num = 90;
    @ConfigBase.ConfField(description={"FE \u5ba1\u8ba1\u65e5\u5fd7\u6587\u4ef6\u7684\u79cd\u7c7b", "The type of FE audit log file"}, options={"slow_query", "query", "load", "stream_load"})
    public static String[] audit_log_modules = new String[]{"slow_query", "query", "load", "stream_load"};
    @ConfigBase.ConfField(mutable=true, description={"\u6162\u67e5\u8be2\u7684\u9608\u503c\uff0c\u5355\u4f4d\u4e3a\u6beb\u79d2\u3002\u5982\u679c\u4e00\u4e2a\u67e5\u8be2\u7684\u54cd\u5e94\u65f6\u95f4\u8d85\u8fc7\u8fd9\u4e2a\u9608\u503c\uff0c\u5219\u4f1a\u88ab\u8bb0\u5f55\u5728 audit log \u4e2d\u3002", "The threshold of slow query, in milliseconds. If the response time of a query exceeds this threshold, it will be recorded in audit log."})
    public static long qe_slow_log_ms = 5000L;
    @ConfigBase.ConfField(description={"FE \u5ba1\u8ba1\u65e5\u5fd7\u6587\u4ef6\u7684\u5207\u5206\u5468\u671f", "The split cycle of the FE audit log file"}, options={"DAY", "HOUR"})
    public static String audit_log_roll_interval = "DAY";
    @ConfigBase.ConfField(description={"FE \u5ba1\u8ba1\u65e5\u5fd7\u6587\u4ef6\u7684\u6700\u5927\u5b58\u6d3b\u65f6\u95f4\u3002\u8d85\u8fc7\u8fd9\u4e2a\u65f6\u95f4\u540e\uff0c\u65e5\u5fd7\u6587\u4ef6\u4f1a\u88ab\u5220\u9664\u3002\u652f\u6301\u7684\u683c\u5f0f\u5305\u62ec\uff1a7d, 10h, 60m, 120s", "The maximum survival time of the FE audit log file. After exceeding this time, the log file will be deleted. Supported formats include: 7d, 10h, 60m, 120s"})
    public static String audit_log_delete_age = "30d";
    @ConfigBase.ConfField(description={"\u662f\u5426\u538b\u7f29 FE \u7684 Audit \u65e5\u5fd7", "enable compression for FE audit log file"})
    public static boolean audit_log_enable_compress = false;
    @ConfigBase.ConfField(description={"\u63d2\u4ef6\u7684\u5b89\u88c5\u76ee\u5f55", "The installation directory of the plugin"})
    public static String plugin_dir = System.getenv("DORIS_HOME") + "/plugins";
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u662f\u5426\u542f\u7528\u63d2\u4ef6", "Whether to enable the plugin"})
    public static boolean plugin_enable = true;
    @ConfigBase.ConfField(description={"JDBC \u9a71\u52a8\u7684\u5b58\u653e\u8def\u5f84\u3002\u5728\u521b\u5efa JDBC Catalog \u65f6\uff0c\u5982\u679c\u6307\u5b9a\u7684\u9a71\u52a8\u6587\u4ef6\u8def\u5f84\u4e0d\u662f\u7edd\u5bf9\u8def\u5f84\uff0c\u5219\u4f1a\u5728\u8fd9\u4e2a\u76ee\u5f55\u4e0b\u5bfb\u627e", "The path to save jdbc drivers. When creating JDBC Catalog,if the specified driver file path is not an absolute path, Doris will find jars from this path"})
    public static String jdbc_drivers_dir = System.getenv("DORIS_HOME") + "/jdbc_drivers";
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"broker load \u65f6\uff0c\u5355\u4e2a\u8282\u70b9\u4e0a load \u6267\u884c\u8ba1\u5212\u7684\u9ed8\u8ba4\u5e76\u884c\u5ea6", "The default parallelism of the load execution plan on a single node when the broker load is submitted"})
    public static int default_load_parallelism = 1;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u5df2\u5b8c\u6210\u6216\u53d6\u6d88\u7684\u5bfc\u5165\u4f5c\u4e1a\u4fe1\u606f\u7684 label \u4f1a\u5728\u8fd9\u4e2a\u65f6\u95f4\u540e\u88ab\u5220\u9664\u3002\u88ab\u5220\u9664\u7684 label \u53ef\u4ee5\u88ab\u91cd\u7528\u3002", "Labels of finished or cancelled load jobs will be removed after this timeThe removed labels can be reused."})
    public static int label_keep_max_second = 259200;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u9488\u5bf9\u4e00\u4e9b\u9ad8\u9891\u7684\u5bfc\u5165\u4f5c\u4e1a\uff0c\u6bd4\u5982 INSERT, STREAMING LOAD, ROUTINE_LOAD_TASK, DELETE\u5982\u679c\u5bfc\u5165\u4f5c\u4e1a\u6216\u8005\u4efb\u52a1\u5df2\u7ecf\u5b8c\u6210\uff0c\u4e14\u8d85\u8fc7\u8fd9\u4e2a\u65f6\u95f4\u540e\uff0c\u4f1a\u88ab\u5220\u9664\u3002\u88ab\u5220\u9664\u7684\u4f5c\u4e1a\u6216\u8005\u4efb\u52a1\u53ef\u4ee5\u88ab\u91cd\u7528\u3002", "For some high frequency load jobs such as INSERT, STREAMING LOAD, ROUTINE_LOAD_TASK, DELETERemove the finished job or task if expired. The removed job or task can be reused."})
    public static int streaming_label_keep_max_second = 43200;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u9488\u5bf9 ALTER, EXPORT \u4f5c\u4e1a\uff0c\u5982\u679c\u4f5c\u4e1a\u5df2\u7ecf\u5b8c\u6210\uff0c\u4e14\u8d85\u8fc7\u8fd9\u4e2a\u65f6\u95f4\u540e\uff0c\u4f1a\u88ab\u5220\u9664\u3002", "For ALTER, EXPORT jobs, remove the finished job if expired."})
    public static int history_job_keep_max_second = 604800;
    @ConfigBase.ConfField(description={"\u4e8b\u52a1\u7684\u6e05\u7406\u5468\u671f\uff0c\u5355\u4f4d\u4e3a\u79d2\u3002\u6bcf\u4e2a\u5468\u671f\u5185\uff0c\u5c06\u4f1a\u6e05\u7406\u5df2\u7ecf\u7ed3\u675f\u7684\u5e76\u4e14\u8fc7\u671f\u7684\u5386\u53f2\u4e8b\u52a1\u4fe1\u606f", "The clean interval of transaction, in seconds. In each cycle, the expired history transaction will be cleaned"})
    public static int transaction_clean_interval_second = 30;
    @ConfigBase.ConfField(description={"\u5bfc\u5165\u4f5c\u4e1a\u7684\u6e05\u7406\u5468\u671f\uff0c\u5355\u4f4d\u4e3a\u79d2\u3002\u6bcf\u4e2a\u5468\u671f\u5185\uff0c\u5c06\u4f1a\u6e05\u7406\u5df2\u7ecf\u7ed3\u675f\u7684\u5e76\u4e14\u8fc7\u671f\u7684\u5bfc\u5165\u4f5c\u4e1a", "The clean interval of load job, in seconds. In each cycle, the expired history load job will be cleaned"})
    public static int label_clean_interval_second = 3600;
    @ConfigBase.ConfField(description={"\u5143\u6570\u636e\u7684\u5b58\u50a8\u76ee\u5f55", "The directory to save Doris meta data"})
    public static String meta_dir = System.getenv("DORIS_HOME") + "/doris-meta";
    @ConfigBase.ConfField(description={"\u4e34\u65f6\u6587\u4ef6\u7684\u5b58\u50a8\u76ee\u5f55", "The directory to save Doris temp data"})
    public static String tmp_dir = System.getenv("DORIS_HOME") + "/temp_dir";
    @ConfigBase.ConfField(description={"\u5143\u6570\u636e\u65e5\u5fd7\u7684\u5b58\u50a8\u7c7b\u578b\u3002BDB: \u65e5\u5fd7\u5b58\u50a8\u5728 BDBJE \u4e2d\u3002LOCAL\uff1a\u65e5\u5fd7\u5b58\u50a8\u5728\u672c\u5730\u6587\u4ef6\u4e2d\uff08\u4ec5\u7528\u4e8e\u6d4b\u8bd5\uff09", "The storage type of the metadata log. BDB: Logs are stored in BDBJE. LOCAL: logs are stored in a local file (for testing only)"}, options={"BDB", "LOCAL"})
    public static String edit_log_type = "bdb";
    @ConfigBase.ConfField(description={"BDBJE \u7684\u7aef\u53e3\u53f7", "The port of BDBJE"})
    public static int edit_log_port = 9010;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"BDBJE \u7684\u65e5\u5fd7\u6eda\u52a8\u5927\u5c0f\u3002\u5f53\u65e5\u5fd7\u6761\u76ee\u6570\u8d85\u8fc7\u8fd9\u4e2a\u503c\u540e\uff0c\u4f1a\u89e6\u53d1\u65e5\u5fd7\u6eda\u52a8", "The log roll size of BDBJE. When the number of log entries exceeds this value, the log will be rolled"})
    public static int edit_log_roll_num = 50000;
    @ConfigBase.ConfField(description={"\u5143\u6570\u636e\u540c\u6b65\u7684\u5bb9\u5fcd\u5ef6\u8fdf\u65f6\u95f4\uff0c\u5355\u4f4d\u4e3a\u79d2\u3002\u5982\u679c\u5143\u6570\u636e\u7684\u5ef6\u8fdf\u8d85\u8fc7\u8fd9\u4e2a\u503c\uff0c\u975e\u4e3b FE \u4f1a\u505c\u6b62\u63d0\u4f9b\u670d\u52a1", "The toleration delay time of meta data synchronization, in seconds. If the delay of meta data exceeds this value, non-master FE will stop offering service"})
    public static int meta_delay_toleration_second = 300;
    @ConfigBase.ConfField(description={"\u5143\u6570\u636e\u65e5\u5fd7\u7684\u5199\u540c\u6b65\u7b56\u7565\u3002\u5982\u679c\u4ec5\u90e8\u7f72\u4e00\u4e2a Follower FE\uff0c\u5219\u63a8\u8350\u8bbe\u7f6e\u4e3a `SYNC`\uff0c\u5982\u679c\u6709\u591a\u4e2a Follower FE\uff0c\u5219\u53ef\u4ee5\u8bbe\u7f6e\u4e3a `WRITE_NO_SYNC`\u3002\u53ef\u53c2\u9605\uff1ahttp://docs.oracle.com/cd/E17277_02/html/java/com/sleepycat/je/Durability.SyncPolicy.html", "The sync policy of meta data log. If you only deploy one Follower FE, set this to `SYNC`. If you deploy more than 3 Follower FE, you can set this and the following `replica_sync_policy` to `WRITE_NO_SYNC`. See: http://docs.oracle.com/cd/E17277_02/html/java/com/sleepycat/je/Durability.SyncPolicy.html"}, options={"SYNC", "NO_SYNC", "WRITE_NO_SYNC"})
    public static String master_sync_policy = "SYNC";
    @ConfigBase.ConfField(description={"\u540c `master_sync_policy`", "Same as `master_sync_policy`"}, options={"SYNC", "NO_SYNC", "WRITE_NO_SYNC"})
    public static String replica_sync_policy = "SYNC";
    @ConfigBase.ConfField(description={"BDBJE \u8282\u70b9\u95f4\u540c\u6b65\u7b56\u7565\uff0c\u53ef\u53c2\u9605\uff1ahttp://docs.oracle.com/cd/E17277_02/html/java/com/sleepycat/je/Durability.ReplicaAckPolicy.html", "The replica ack policy of bdbje. See: http://docs.oracle.com/cd/E17277_02/html/java/com/sleepycat/je/Durability.ReplicaAckPolicy.html"}, options={"ALL", "NONE", "SIMPLE_MAJORITY"})
    public static String replica_ack_policy = "SIMPLE_MAJORITY";
    @ConfigBase.ConfField(description={"BDBJE \u4e3b\u4ece\u8282\u70b9\u95f4\u5fc3\u8df3\u8d85\u65f6\u65f6\u95f4\uff0c\u5355\u4f4d\u4e3a\u79d2\u3002\u9ed8\u8ba4\u503c\u4e3a 30 \u79d2\uff0c\u4e0e BDBJE \u7684\u9ed8\u8ba4\u503c\u76f8\u540c\u3002\u5982\u679c\u7f51\u7edc\u4e0d\u7a33\u5b9a\uff0c\u6216\u8005 Java GC \u7ecf\u5e38\u5bfc\u81f4\u957f\u65f6\u95f4\u7684\u6682\u505c\uff0c\u53ef\u4ee5\u9002\u5f53\u589e\u5927\u8fd9\u4e2a\u503c\uff0c\u51cf\u5c11\u8bef\u62a5\u8d85\u65f6\u7684\u6982\u7387", "The heartbeat timeout of bdbje between master and follower, in seconds. The default is 30 seconds, which is same as default value in bdbje. If the network is experiencing transient problems, of some unexpected long java GC annoying you, you can try to increase this value to decrease the chances of false timeouts"})
    public static int bdbje_heartbeat_timeout_second = 30;
    @ConfigBase.ConfField(description={"BDBJE \u64cd\u4f5c\u7684\u9501\u8d85\u65f6\u65f6\u95f4\uff0c\u5355\u4f4d\u4e3a\u79d2\u3002\u5982\u679c FE \u7684 WARN \u65e5\u5fd7\u4e2d\u51fa\u73b0\u5927\u91cf\u7684 LockTimeoutException\uff0c\u53ef\u4ee5\u9002\u5f53\u589e\u5927\u8fd9\u4e2a\u503c", "The lock timeout of bdbje operation, in seconds. If there are many LockTimeoutException in FE WARN log, you can try to increase this value"})
    public static int bdbje_lock_timeout_second = 5;
    @ConfigBase.ConfField(description={"BDBJE \u4e3b\u4ece\u8282\u70b9\u95f4\u540c\u6b65\u7684\u8d85\u65f6\u65f6\u95f4\uff0c\u5355\u4f4d\u4e3a\u79d2\u3002\u5982\u679c\u51fa\u73b0\u5927\u91cf\u7684 ReplicaWriteException\uff0c\u53ef\u4ee5\u9002\u5f53\u589e\u5927\u8fd9\u4e2a\u503c", "The replica ack timeout of bdbje between master and follower, in seconds. If there are many ReplicaWriteException in FE WARN log, you can try to increase this value"})
    public static int bdbje_replica_ack_timeout_second = 10;
    @ConfigBase.ConfField(description={"BDBJE \u6240\u9700\u7684\u7a7a\u95f2\u78c1\u76d8\u7a7a\u95f4\u5927\u5c0f\u3002\u5982\u679c\u7a7a\u95f2\u78c1\u76d8\u7a7a\u95f4\u5c0f\u4e8e\u8fd9\u4e2a\u503c\uff0c\u5219BDBJE\u5c06\u65e0\u6cd5\u5199\u5165\u3002", "Amount of free disk space required by BDBJE. If the free disk space is less than this value, BDBJE will not be able to write."})
    public static int bdbje_reserved_disk_bytes = 0x40000000;
    @ConfigBase.ConfField(masterOnly=true, description={"\u5fc3\u8df3\u7ebf\u7a0b\u6c60\u7684\u7ebf\u7a0b\u6570", "Num of thread to handle heartbeat events"})
    public static int heartbeat_mgr_threads_num = 8;
    @ConfigBase.ConfField(masterOnly=true, description={"\u5fc3\u8df3\u7ebf\u7a0b\u6c60\u7684\u961f\u5217\u5927\u5c0f", "Queue size to store heartbeat task in heartbeat_mgr"})
    public static int heartbeat_mgr_blocking_queue_size = 1024;
    @ConfigBase.ConfField(masterOnly=true, description={"Agent\u4efb\u52a1\u7ebf\u7a0b\u6c60\u7684\u7ebf\u7a0b\u6570", "Num of thread to handle agent task in agent task thread-pool"})
    public static int max_agent_task_threads_num = 4096;
    @ConfigBase.ConfField(description={"BDBJE \u91cd\u52a0\u5165\u96c6\u7fa4\u65f6\uff0c\u6700\u591a\u56de\u6eda\u7684\u4e8b\u52a1\u6570\u3002\u5982\u679c\u56de\u6eda\u7684\u4e8b\u52a1\u6570\u8d85\u8fc7\u8fd9\u4e2a\u503c\uff0c\u5219 BDBJE \u5c06\u65e0\u6cd5\u91cd\u52a0\u5165\u96c6\u7fa4\uff0c\u9700\u8981\u624b\u52a8\u6e05\u7406 BDBJE \u7684\u6570\u636e\u3002", "The max txn number which bdbje can rollback when trying to rejoin the group. If the number of rollback txn is larger than this value, bdbje will not be able to rejoin the group, and you need to clean up bdbje data manually."})
    public static int txn_rollback_limit = 100;
    @ConfigBase.ConfField(description={"\u4f18\u5148\u4f7f\u7528\u7684\u7f51\u7edc\u5730\u5740\uff0c\u5982\u679c FE \u6709\u591a\u4e2a\u7f51\u7edc\u5730\u5740\uff0c\u53ef\u4ee5\u901a\u8fc7\u8fd9\u4e2a\u914d\u7f6e\u6765\u6307\u5b9a\u4f18\u5148\u4f7f\u7528\u7684\u7f51\u7edc\u5730\u5740\u3002\u8fd9\u662f\u4e00\u4e2a\u5206\u53f7\u5206\u9694\u7684\u5217\u8868\uff0c\u6bcf\u4e2a\u5143\u7d20\u662f\u4e00\u4e2a CIDR \u8868\u793a\u7684\u7f51\u7edc\u5730\u5740", "The preferred network address. If FE has multiple network addresses, this configuration can be used to specify the preferred network address. This is a semicolon-separated list, each element is a CIDR representation of the network address"})
    public static String priority_networks = "";
    @ConfigBase.ConfField(mutable=true, description={"\u662f\u5426\u5ffd\u7565\u5143\u6570\u636e\u5ef6\u8fdf\uff0c\u5982\u679c FE \u7684\u5143\u6570\u636e\u5ef6\u8fdf\u8d85\u8fc7\u8fd9\u4e2a\u9608\u503c\uff0c\u5219\u975e Master FE \u4ecd\u7136\u63d0\u4f9b\u8bfb\u670d\u52a1\u3002\u8fd9\u4e2a\u914d\u7f6e\u53ef\u4ee5\u7528\u4e8e\u5f53 Master FE \u56e0\u4e3a\u67d0\u4e9b\u539f\u56e0\u505c\u6b62\u4e86\u8f83\u957f\u65f6\u95f4\uff0c\u4f46\u662f\u4ecd\u7136\u5e0c\u671b\u975e Master FE \u53ef\u4ee5\u63d0\u4f9b\u8bfb\u670d\u52a1\u3002", "If true, non-master FE will ignore the meta data delay gap between Master FE and its self, even if the metadata delay gap exceeds this threshold. Non-master FE will still offer read service. This is helpful when you try to stop the Master FE for a relatively long time for some reason, but still wish the non-master FE can offer read service."})
    public static boolean ignore_meta_check = false;
    @ConfigBase.ConfField(description={"\u975e Master FE \u4e0e Master FE \u7684\u6700\u5927\u65f6\u949f\u504f\u5dee\uff0c\u5355\u4f4d\u4e3a\u6beb\u79d2\u3002\u8fd9\u4e2a\u914d\u7f6e\u7528\u4e8e\u5728\u975e Master FE \u4e0e Master FE \u4e4b\u95f4\u5efa\u7acb BDBJE \u8fde\u63a5\u65f6\u68c0\u67e5\u65f6\u949f\u504f\u5dee\uff0c\u5982\u679c\u65f6\u949f\u504f\u5dee\u8d85\u8fc7\u8fd9\u4e2a\u9608\u503c\uff0c\u5219 BDBJE \u8fde\u63a5\u4f1a\u88ab\u653e\u5f03\u3002", "The maximum clock skew between non-master FE to Master FE host, in milliseconds. This value is checked whenever a non-master FE establishes a connection to master FE via BDBJE. The connection is abandoned if the clock skew is larger than this value."})
    public static long max_bdbje_clock_delta_ms = 5000L;
    @ConfigBase.ConfField(description={"\u662f\u5426\u542f\u7528\u6240\u6709 http \u63a5\u53e3\u7684\u8ba4\u8bc1", "Whether to enable all http interface authentication"}, expType=ExperimentalUtil.ExperimentalType.EXPERIMENTAL)
    public static boolean enable_all_http_auth = false;
    @ConfigBase.ConfField(description={"FE http \u7aef\u53e3\uff0c\u76ee\u524d\u6240\u6709 FE \u7684 http \u7aef\u53e3\u5fc5\u987b\u76f8\u540c", "Fe http port, currently all FE's http port must be same"})
    public static int http_port = 8030;
    @ConfigBase.ConfField(description={"FE https \u7aef\u53e3\uff0c\u76ee\u524d\u6240\u6709 FE \u7684 https \u7aef\u53e3\u5fc5\u987b\u76f8\u540c", "Fe https port, currently all FE's https port must be same"})
    public static int https_port = 8050;
    @ConfigBase.ConfField(description={"FE https \u670d\u52a1\u7684 key store \u8def\u5f84", "The key store path of FE https service"})
    public static String key_store_path = System.getenv("DORIS_HOME") + "/conf/ssl/doris_ssl_certificate.keystore";
    @ConfigBase.ConfField(description={"FE https \u670d\u52a1\u7684 key store \u5bc6\u7801", "The key store password of FE https service"})
    public static String key_store_password = "";
    @ConfigBase.ConfField(description={"FE https \u670d\u52a1\u7684 key store \u7c7b\u578b", "The key store type of FE https service"})
    public static String key_store_type = "JKS";
    @ConfigBase.ConfField(description={"FE https \u670d\u52a1\u7684 key store \u522b\u540d", "The key store alias of FE https service"})
    public static String key_store_alias = "doris_ssl_certificate";
    @ConfigBase.ConfField(description={"\u662f\u5426\u542f\u7528 https\uff0c\u5982\u679c\u542f\u7528\uff0chttp \u7aef\u53e3\u5c06\u4e0d\u53ef\u7528", "Whether to enable https, if enabled, http port will not be available"}, expType=ExperimentalUtil.ExperimentalType.EXPERIMENTAL)
    public static boolean enable_https = false;
    @ConfigBase.ConfField(description={"Jetty \u7684 acceptor \u7ebf\u7a0b\u6570\u3002Jetty\u7684\u7ebf\u7a0b\u67b6\u6784\u6a21\u578b\u5f88\u7b80\u5355\uff0c\u5206\u4e3a\u4e09\u4e2a\u7ebf\u7a0b\u6c60\uff1aacceptor\u3001selector \u548c worker\u3002acceptor \u8d1f\u8d23\u63a5\u53d7\u65b0\u7684\u8fde\u63a5\uff0c\u7136\u540e\u4ea4\u7ed9 selector \u5904\u7406HTTP\u62a5\u6587\u534f\u8bae\u7684\u89e3\u5305\uff0c\u6700\u540e\u7531 worker \u5904\u7406\u8bf7\u6c42\u3002\u524d\u4e24\u4e2a\u7ebf\u7a0b\u6c60\u91c7\u7528\u975e\u963b\u585e\u6a21\u578b\uff0c\u5e76\u4e14\u4e00\u4e2a\u7ebf\u7a0b\u53ef\u4ee5\u5904\u7406\u5f88\u591asocket\u7684\u8bfb\u5199\uff0c\u6240\u4ee5\u7ebf\u7a0b\u6c60\u7684\u6570\u91cf\u5c11\u3002\u5bf9\u4e8e\u5927\u591a\u6570\u9879\u76ee\uff0c\u53ea\u9700\u8981 1-2 \u4e2a acceptor \u7ebf\u7a0b\uff0c2 \u5230 4 \u4e2a\u5c31\u8db3\u591f\u4e86\u3002Worker \u7684\u6570\u91cf\u53d6\u51b3\u4e8e\u5e94\u7528\u7684QPS\u548cIO\u4e8b\u4ef6\u7684\u6bd4\u4f8b\u3002\u8d8a\u9ad8QPS\uff0c\u6216\u8005IO\u5360\u6bd4\u8d8a\u9ad8\uff0c\u7b49\u5f85\u7684\u7ebf\u7a0b\u8d8a\u591a\uff0c\u9700\u8981\u7684\u7ebf\u7a0b\u603b\u6570\u8d8a\u591a\u3002", "The number of acceptor threads for Jetty. Jetty's thread architecture model is very simple, divided into three thread pools: acceptor, selector and worker. The acceptor is responsible for accepting new connections, and then handing it over to the selector to process the unpacking of the HTTP message protocol, and finally the worker processes the request. The first two thread pools adopt a non-blocking model, and one thread can handle many socket reads and writes, so the number of thread pools is small. For most projects, only 1-2 acceptor threads are needed, 2 to 4 should be enough. The number of workers depends on the ratio of QPS and IO events of the application. The higher the QPS, or the higher the IO ratio, the more threads are waiting, and the more threads are required."})
    public static int jetty_server_acceptors = 2;
    @ConfigBase.ConfField(description={"Jetty \u7684 selector \u7ebf\u7a0b\u6570\u3002", "The number of selector threads for Jetty."})
    public static int jetty_server_selectors = 4;
    @ConfigBase.ConfField(description={"Jetty \u7684 worker \u7ebf\u7a0b\u6570\u30020 \u8868\u793a\u4f7f\u7528\u9ed8\u8ba4\u7ebf\u7a0b\u6c60\u3002", "The number of worker threads for Jetty. 0 means using the default thread pool."})
    public static int jetty_server_workers = 0;
    @ConfigBase.ConfField(description={"Jetty \u7684\u7ebf\u7a0b\u6c60\u7684\u9ed8\u8ba4\u6700\u5c0f\u7ebf\u7a0b\u6570\u3002", "The default minimum number of threads for jetty."})
    public static int jetty_threadPool_minThreads = 20;
    @ConfigBase.ConfField(description={"Jetty \u7684\u7ebf\u7a0b\u6c60\u7684\u9ed8\u8ba4\u6700\u5927\u7ebf\u7a0b\u6570\u3002", "The default maximum number of threads for jetty."})
    public static int jetty_threadPool_maxThreads = 400;
    @ConfigBase.ConfField(description={"Jetty \u7684\u6700\u5927 HTTP POST \u5927\u5c0f\uff0c\u5355\u4f4d\u662f\u5b57\u8282\uff0c\u9ed8\u8ba4\u503c\u662f 100MB\u3002", "The maximum HTTP POST size of Jetty, in bytes, the default value is 100MB."})
    public static int jetty_server_max_http_post_size = 0x6400000;
    @ConfigBase.ConfField(description={"Jetty \u7684\u6700\u5927 HTTP header \u5927\u5c0f\uff0c\u5355\u4f4d\u662f\u5b57\u8282\uff0c\u9ed8\u8ba4\u503c\u662f 1MB\u3002", "The maximum HTTP header size of Jetty, in bytes, the default value is 1MB."})
    public static int jetty_server_max_http_header_size = 0x100000;
    @ConfigBase.ConfField(description={"\u662f\u5426\u7981\u7528 mini load\uff0c\u9ed8\u8ba4\u7981\u7528", "Whether to disable mini load, disabled by default"})
    public static boolean disable_mini_load = true;
    @ConfigBase.ConfField(description={"mysql nio server \u7684 backlog \u6570\u91cf\u3002\u5982\u679c\u8c03\u5927\u8fd9\u4e2a\u503c\uff0c\u5219\u9700\u540c\u65f6\u8c03\u6574 /proc/sys/net/core/somaxconn \u7684\u503c", "The backlog number of mysql nio server. If you enlarge this value, you should enlarge the value in `/proc/sys/net/core/somaxconn` at the same time"})
    public static int mysql_nio_backlog_num = 1024;
    @ConfigBase.ConfField(description={"thrift client \u7684\u8fde\u63a5\u8d85\u65f6\u65f6\u95f4\uff0c\u5355\u4f4d\u662f\u6beb\u79d2\u30020 \u8868\u793a\u4e0d\u8bbe\u7f6e\u8d85\u65f6\u65f6\u95f4\u3002", "The connection timeout of thrift client, in milliseconds. 0 means no timeout."})
    public static int thrift_client_timeout_ms = 0;
    @ConfigBase.ConfField(description={"thrift server \u7684 backlog \u6570\u91cf\u3002\u5982\u679c\u8c03\u5927\u8fd9\u4e2a\u503c\uff0c\u5219\u9700\u540c\u65f6\u8c03\u6574 /proc/sys/net/core/somaxconn \u7684\u503c", "The backlog number of thrift server. If you enlarge this value, you should enlarge the value in `/proc/sys/net/core/somaxconn` at the same time"})
    public static int thrift_backlog_num = 1024;
    @ConfigBase.ConfField(description={"FE thrift server \u7684\u7aef\u53e3\u53f7", "The port of FE thrift server"})
    public static int rpc_port = 9020;
    @ConfigBase.ConfField(description={"FE MySQL server \u7684\u7aef\u53e3\u53f7", "The port of FE MySQL server"})
    public static int query_port = 9030;
    @ConfigBase.ConfField(description={"MySQL \u670d\u52a1\u7684 IO \u7ebf\u7a0b\u6570", "The number of IO threads in MySQL service"})
    public static int mysql_service_io_threads_num = 4;
    @ConfigBase.ConfField(description={"MySQL \u670d\u52a1\u7684\u6700\u5927\u4efb\u52a1\u7ebf\u7a0b\u6570", "The max number of task threads in MySQL service"})
    public static int max_mysql_service_task_threads_num = 4096;
    @ConfigBase.ConfField(description={"BackendServiceProxy\u6570\u91cf, \u7528\u4e8e\u6c60\u5316GRPC channel", "BackendServiceProxy pool size for pooling GRPC channels."})
    public static int backend_proxy_num = 48;
    @ConfigBase.ConfField(description={"\u96c6\u7fa4 ID\uff0c\u7528\u4e8e\u5185\u90e8\u8ba4\u8bc1\u3002\u901a\u5e38\u5728\u96c6\u7fa4\u7b2c\u4e00\u6b21\u542f\u52a8\u65f6\uff0c\u4f1a\u968f\u673a\u751f\u6210\u4e00\u4e2a cluster id. \u7528\u6237\u4e5f\u53ef\u4ee5\u624b\u52a8\u6307\u5b9a\u3002", "Cluster id used for internal authentication. Usually a random integer generated when master FE start at first time. You can also specify one."})
    public static int cluster_id = -1;
    @ConfigBase.ConfField(description={"\u96c6\u7fa4 token\uff0c\u7528\u4e8e\u5185\u90e8\u8ba4\u8bc1\u3002", "Cluster token used for internal authentication."})
    public static String auth_token = "";
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u521b\u5efa\u5355\u4e2a Replica \u7684\u6700\u5927\u8d85\u65f6\u65f6\u95f4\uff0c\u5355\u4f4d\u662f\u79d2\u3002\u5982\u679c\u4f60\u8981\u521b\u5efa m \u4e2a tablet\uff0c\u6bcf\u4e2a tablet \u6709 n \u4e2a replica\u3002\u5219\u603b\u7684\u8d85\u65f6\u65f6\u95f4\u4e3a `m * n * tablet_create_timeout_second`", "Maximal waiting time for creating a single replica, in seconds. eg. if you create a table with #m tablets and #n replicas for each tablet, the create table request will run at most (m * n * tablet_create_timeout_second) before timeout"})
    public static int tablet_create_timeout_second = 2;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u521b\u5efa\u8868\u7684\u6700\u5c0f\u8d85\u65f6\u65f6\u95f4\uff0c\u5355\u4f4d\u662f\u79d2\u3002", "Minimal waiting time for creating a table, in seconds."})
    public static int min_create_table_timeout_second = 30;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u521b\u5efa\u8868\u7684\u6700\u5927\u8d85\u65f6\u65f6\u95f4\uff0c\u5355\u4f4d\u662f\u79d2\u3002", "Maximal waiting time for creating a table, in seconds."})
    public static int max_create_table_timeout_second = 3600;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u5bfc\u5165 Publish \u9636\u6bb5\u7684\u6700\u5927\u8d85\u65f6\u65f6\u95f4\uff0c\u5355\u4f4d\u662f\u79d2\u3002", "Maximal waiting time for all publish version tasks of one transaction to be finished, in seconds."})
    public static int publish_version_timeout_second = 30;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u5bfc\u5165 Publish \u9636\u6bb5\u7684\u7b49\u5f85\u65f6\u95f4\uff0c\u5355\u4f4d\u662f\u79d2\u3002\u8d85\u8fc7\u6b64\u65f6\u95f4\uff0c\u5219\u53ea\u9700\u6bcf\u4e2atablet\u5305\u542b\u4e00\u4e2a\u6210\u529f\u526f\u672c\uff0c\u5219\u5bfc\u5165\u6210\u529f\u3002\u503c\u4e3a -1 \u65f6\uff0c\u8868\u793a\u65e0\u9650\u7b49\u5f85\u3002", "Waiting time for one transaction changing to \"at least one replica success\", in seconds.If time exceeds this, and for each tablet it has at least one replica publish successful, then the load task will be successful."})
    public static int publish_wait_time_second = 300;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u63d0\u4ea4\u4e8b\u52a1\u7684\u6700\u5927\u8d85\u65f6\u65f6\u95f4\uff0c\u5355\u4f4d\u662f\u79d2\u3002\u8be5\u53c2\u6570\u4ec5\u7528\u4e8e\u4e8b\u52a1\u578b insert \u64cd\u4f5c\u4e2d\u3002", "Maximal waiting time for all data inserted before one transaction to be committed, in seconds. This parameter is only used for transactional insert operation"})
    public static int commit_timeout_second = 30;
    @ConfigBase.ConfField(masterOnly=true, description={"Publish \u4efb\u52a1\u89e6\u53d1\u7ebf\u7a0b\u7684\u6267\u884c\u95f4\u9694\uff0c\u5355\u4f4d\u662f\u6beb\u79d2\u3002", "The interval of publish task trigger thread, in milliseconds"})
    public static int publish_version_interval_ms = 10;
    @ConfigBase.ConfField(description={"thrift server \u7684\u6700\u5927 worker \u7ebf\u7a0b\u6570", "The max worker threads of thrift server"})
    public static int thrift_server_max_worker_threads = 4096;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"Delete \u64cd\u4f5c\u7684\u6700\u5927\u8d85\u65f6\u65f6\u95f4\uff0c\u5355\u4f4d\u662f\u79d2\u3002", "Maximal timeout for delete job, in seconds."})
    public static int delete_job_max_timeout_second = 300;
    @ConfigBase.ConfField(description={"load job \u8c03\u5ea6\u5668\u7684\u6267\u884c\u95f4\u9694\uff0c\u5355\u4f4d\u662f\u79d2\u3002", "The interval of load job scheduler, in seconds."})
    public static int load_checker_interval_second = 5;
    @ConfigBase.ConfField(description={"spark load job \u8c03\u5ea6\u5668\u7684\u6267\u884c\u95f4\u9694\uff0c\u5355\u4f4d\u662f\u79d2\u3002", "The interval of spark load job scheduler, in seconds."})
    public static int spark_load_checker_interval_second = 60;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"Broker load \u7684\u9ed8\u8ba4\u8d85\u65f6\u65f6\u95f4\uff0c\u5355\u4f4d\u662f\u79d2\u3002", "Default timeout for broker load job, in seconds."})
    public static int broker_load_default_timeout_second = 14400;
    @ConfigBase.ConfField(description={"\u548c Broker \u8fdb\u7a0b\u4ea4\u4e92\u7684 RPC \u7684\u8d85\u65f6\u65f6\u95f4\uff0c\u5355\u4f4d\u662f\u6beb\u79d2\u3002", "The timeout of RPC between FE and Broker, in milliseconds"})
    public static int broker_timeout_ms = 10000;
    @ConfigBase.ConfField(description={"\u4e3b\u952e\u9ad8\u5e76\u53d1\u70b9\u67e5\u77ed\u8def\u5f84\u8d85\u65f6\u65f6\u95f4\u3002", "The timeout of RPC for high concurrenty short circuit query"})
    public static int point_query_timeout_ms = 10000;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"Insert load \u7684\u9ed8\u8ba4\u8d85\u65f6\u65f6\u95f4\uff0c\u5355\u4f4d\u662f\u79d2\u3002", "Default timeout for insert load job, in seconds."})
    public static int insert_load_default_timeout_second = 14400;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"Stream load \u7684\u9ed8\u8ba4\u8d85\u65f6\u65f6\u95f4\uff0c\u5355\u4f4d\u662f\u79d2\u3002", "Default timeout for stream load job, in seconds."})
    public static int stream_load_default_timeout_second = 259200;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"Stream load \u7684\u9ed8\u8ba4\u9884\u63d0\u4ea4\u8d85\u65f6\u65f6\u95f4\uff0c\u5355\u4f4d\u662f\u79d2\u3002", "Default pre-commit timeout for stream load job, in seconds."})
    public static int stream_load_default_precommit_timeout_second = 3600;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"Load \u7684\u6700\u5927\u8d85\u65f6\u65f6\u95f4\uff0c\u5355\u4f4d\u662f\u79d2\u3002", "Maximal timeout for load job, in seconds."})
    public static int max_load_timeout_second = 259200;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"Stream load \u7684\u6700\u5927\u8d85\u65f6\u65f6\u95f4\uff0c\u5355\u4f4d\u662f\u79d2\u3002", "Maximal timeout for stream load job, in seconds."})
    public static int max_stream_load_timeout_second = 259200;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"Load \u7684\u6700\u5c0f\u8d85\u65f6\u65f6\u95f4\uff0c\u5355\u4f4d\u662f\u79d2\u3002", "Minimal timeout for load job, in seconds."})
    public static int min_load_timeout_second = 1;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"Hadoop load \u7684\u9ed8\u8ba4\u8d85\u65f6\u65f6\u95f4\uff0c\u5355\u4f4d\u662f\u79d2\u3002", "Default timeout for hadoop load job, in seconds."})
    public static int hadoop_load_default_timeout_second = 259200;
    @ConfigBase.ConfField(description={"Spark DPP \u7a0b\u5e8f\u7684\u7248\u672c", "Default spark dpp version"})
    public static String spark_dpp_version = "1.2-SNAPSHOT";
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"Spark load \u7684\u9ed8\u8ba4\u8d85\u65f6\u65f6\u95f4\uff0c\u5355\u4f4d\u662f\u79d2\u3002", "Default timeout for spark load job, in seconds."})
    public static int spark_load_default_timeout_second = 86400;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"Spark Load \u6240\u4f7f\u7528\u7684 Spark \u7a0b\u5e8f\u76ee\u5f55", "Spark dir for Spark Load"})
    public static String spark_home_default_dir = System.getenv("DORIS_HOME") + "/lib/spark2x";
    @ConfigBase.ConfField(description={"Spark load \u6240\u4f7f\u7528\u7684\u4f9d\u8d56\u9879\u76ee\u5f55", "Spark dependencies dir for Spark Load"})
    public static String spark_resource_path = "";
    @ConfigBase.ConfField(description={"Spark launcher \u65e5\u5fd7\u8def\u5f84", "Spark launcher log dir"})
    public static String spark_launcher_log_dir = sys_log_dir + "/spark_launcher_log";
    @ConfigBase.ConfField(description={"Yarn client \u7684\u8def\u5f84", "Yarn client path"})
    public static String yarn_client_path = System.getenv("DORIS_HOME") + "/lib/yarn-client/hadoop/bin/yarn";
    @ConfigBase.ConfField(description={"Yarn \u914d\u7f6e\u6587\u4ef6\u7684\u8def\u5f84", "Yarn config path"})
    public static String yarn_config_dir = System.getenv("DORIS_HOME") + "/lib/yarn-config";
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"Sync job \u7684\u6700\u5927\u63d0\u4ea4\u95f4\u9694\uff0c\u5355\u4f4d\u662f\u79d2\u3002", "Maximal intervals between two sync job's commits."})
    public static long sync_commit_interval_second = 10L;
    @ConfigBase.ConfField(description={"Sync job \u8c03\u5ea6\u5668\u7684\u6267\u884c\u95f4\u9694\uff0c\u5355\u4f4d\u662f\u79d2\u3002", "The interval of sync job scheduler, in seconds."})
    public static int sync_checker_interval_second = 5;
    @ConfigBase.ConfField(description={"Sync job \u7684\u6700\u5927\u5e76\u53d1\u6570\u3002", "Maximal concurrent num of sync job."})
    public static int max_sync_task_threads_num = 10;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"Sync job \u7684\u6700\u5c0f\u63d0\u4ea4\u4e8b\u4ef6\u6570\u3002\u5982\u679c\u6536\u5230\u7684\u4e8b\u4ef6\u6570\u5c0f\u4e8e\u8be5\u503c\uff0cSync Job \u4f1a\u7ee7\u7eed\u7b49\u5f85\u4e0b\u4e00\u6279\u6570\u636e\uff0c\u76f4\u5230\u65f6\u95f4\u8d85\u8fc7 `sync_commit_interval_second`\u3002\u8fd9\u4e2a\u503c\u5e94\u5c0f\u4e8e canal \u7684\u7f13\u51b2\u533a\u5927\u5c0f\u3002", "Min events that a sync job will commit. When receiving events less than it, SyncJob will continue to wait for the next batch of data until the time exceeds `sync_commit_interval_second`."})
    public static long min_sync_commit_size = 10000L;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"Sync job \u7684\u6700\u5c0f\u63d0\u4ea4\u5b57\u8282\u6570\u3002\u5982\u679c\u6536\u5230\u7684\u5b57\u8282\u6570\u5c0f\u4e8e\u8be5\u503c\uff0cSync Job \u4f1a\u7ee7\u7eed\u7b49\u5f85\u4e0b\u4e00\u6279\u6570\u636e\uff0c\u76f4\u5230\u65f6\u95f4\u8d85\u8fc7 `sync_commit_interval_second`\u3002\u8fd9\u4e2a\u503c\u5e94\u5c0f\u4e8e canal \u7684\u7f13\u51b2\u533a\u5927\u5c0f\u3002", "Min bytes that a sync job will commit. When receiving bytes less than it, SyncJob will continue to wait for the next batch of data until the time exceeds `sync_commit_interval_second`."})
    public static long min_bytes_sync_commit = 0xF00000L;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"Sync job \u7684\u6700\u5927\u63d0\u4ea4\u5b57\u8282\u6570\u3002\u5982\u679c\u6536\u5230\u7684\u5b57\u8282\u6570\u5927\u4e8e\u8be5\u503c\uff0cSync Job \u4f1a\u7acb\u5373\u63d0\u4ea4\u6240\u6709\u6570\u636e\u3002\u8fd9\u4e2a\u503c\u5e94\u5927\u4e8e canal \u7684\u7f13\u51b2\u533a\u5927\u5c0f\u548c `min_bytes_sync_commit`\u3002", "Max bytes that a sync job will commit. When receiving bytes larger than it, SyncJob will commit all data immediately. You should set it larger than canal memory and `min_bytes_sync_commit`."})
    public static long max_bytes_sync_commit = 0x4000000L;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"Broker Load \u7684\u6700\u5927\u7b49\u5f85 job \u6570\u91cf\u3002\u8fd9\u4e2a\u503c\u662f\u4e00\u4e2a\u671f\u671b\u503c\u3002\u5728\u67d0\u4e9b\u60c5\u51b5\u4e0b\uff0c\u6bd4\u5982\u5207\u6362 master\uff0c\u5f53\u524d\u7b49\u5f85\u7684 job \u6570\u91cf\u53ef\u80fd\u4f1a\u8d85\u8fc7\u8fd9\u4e2a\u503c\u3002", "Maximal number of waiting jobs for Broker Load. This is a desired number. In some situation, such as switch the master, the current number is maybe more than this value."})
    public static int desired_max_waiting_jobs = 100;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"FE \u4ece BE \u83b7\u53d6 Stream Load \u4f5c\u4e1a\u4fe1\u606f\u7684\u95f4\u9694\u3002", "The interval of FE fetch stream load record from BE."})
    public static int fetch_stream_load_record_interval_second = 120;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"Stream load \u7684\u9ed8\u8ba4\u6700\u5927\u8bb0\u5f55\u6570\u3002", "Default max number of recent stream load record that can be stored in memory."})
    public static int max_stream_load_record_size = 5000;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u662f\u5426\u7981\u7528 show stream load \u548c clear stream load \u547d\u4ee4\uff0c\u4ee5\u53ca\u662f\u5426\u6e05\u7406\u5185\u5b58\u4e2d\u7684 stream load \u8bb0\u5f55\u3002", "Whether to disable show stream load and clear stream load records in memory."})
    public static boolean disable_show_stream_load = false;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u662f\u5426\u542f\u7528 stream load \u548c broker load \u7684\u5355\u526f\u672c\u5199\u5165\u3002", "Whether to enable to write single replica for stream load and broker load."}, expType=ExperimentalUtil.ExperimentalType.EXPERIMENTAL)
    public static boolean enable_single_replica_load = false;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u5355\u4e2a\u6570\u636e\u5e93\u6700\u5927\u5e76\u53d1\u8fd0\u884c\u7684\u4e8b\u52a1\u6570\uff0c\u5305\u62ec prepare \u548c commit \u4e8b\u52a1\u3002", "Maximum concurrent running txn num including prepare, commit txns under a single db.", "Txn manager will reject coming txns."})
    public static int max_running_txn_num_per_db = 1000;
    @ConfigBase.ConfField(masterOnly=true, description={"pending load task \u6267\u884c\u7ebf\u7a0b\u6570\u3002\u8fd9\u4e2a\u914d\u7f6e\u53ef\u4ee5\u9650\u5236\u5f53\u524d\u7b49\u5f85\u7684\u5bfc\u5165\u4f5c\u4e1a\u6570\u3002\u5e76\u4e14\u5e94\u5c0f\u4e8e `max_running_txn_num_per_db`\u3002", "The pending load task executor pool size. This pool size limits the max running pending load tasks.", "Currently, it only limits the pending load task of broker load and spark load.", "It should be less than `max_running_txn_num_per_db`"})
    public static int async_pending_load_task_pool_size = 10;
    @ConfigBase.ConfField(masterOnly=true, description={"loading load task \u6267\u884c\u7ebf\u7a0b\u6570\u3002\u8fd9\u4e2a\u914d\u7f6e\u53ef\u4ee5\u9650\u5236\u5f53\u524d\u6b63\u5728\u5bfc\u5165\u7684\u4f5c\u4e1a\u6570\u3002", "The loading load task executor pool size. This pool size limits the max running loading load tasks.", "Currently, it only limits the loading load task of broker load."})
    public static int async_loading_load_task_pool_size = 10;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u548c `tablet_create_timeout_second` \u542b\u4e49\u76f8\u540c\uff0c\u4f46\u662f\u662f\u7528\u4e8e Delete \u64cd\u4f5c\u7684\u3002", "The same meaning as `tablet_create_timeout_second`, but used when delete a tablet."})
    public static int tablet_delete_timeout_second = 2;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u78c1\u76d8\u4f7f\u7528\u7387\u7684\u9ad8\u6c34\u4f4d\u7ebf\u3002\u7528\u4e8e\u8ba1\u7b97 BE \u7684\u8d1f\u8f7d\u5206\u6570\u3002", "The high water of disk capacity used percent. This is used for calculating load score of a backend."})
    public static double capacity_used_percent_high_water = 0.75;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u8d1f\u8f7d\u5747\u8861\u65f6\uff0c\u78c1\u76d8\u4f7f\u7528\u7387\u6700\u5927\u5dee\u503c\u3002", "The max diff of disk capacity used percent between BE. It is used for calculating load score of a backend."})
    public static double used_capacity_percent_max_diff = 0.3;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u8bbe\u7f6e\u56fa\u5b9a\u7684 BE \u8d1f\u8f7d\u5206\u6570\u4e2d\u78c1\u76d8\u4f7f\u7528\u7387\u7cfb\u6570\u3002BE \u8d1f\u8f7d\u5206\u6570\u4f1a\u7efc\u5408\u78c1\u76d8\u4f7f\u7528\u7387\u548c\u526f\u672c\u6570\u800c\u5f97\u3002\u6709\u6548\u503c\u8303\u56f4\u4e3a[0, 1]\uff0c\u5f53\u8d85\u51fa\u6b64\u8303\u56f4\u65f6\uff0c\u5219\u4f7f\u7528\u5176\u4ed6\u65b9\u6cd5\u81ea\u52a8\u8ba1\u7b97\u6b64\u7cfb\u6570\u3002", "Sets a fixed disk usage factor in the BE load fraction. The BE load score is a combination of disk usage and replica count. The valid value range is [0, 1]. When it is out of this range, other methods are used to automatically calculate this coefficient."})
    public static double backend_load_capacity_coeficient = -1.0;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"ALTER TABLE \u8bf7\u6c42\u7684\u6700\u5927\u8d85\u65f6\u65f6\u95f4\u3002\u8bbe\u7f6e\u7684\u8db3\u591f\u957f\u4ee5\u9002\u5e94\u8868\u7684\u6570\u636e\u91cf\u3002", "Maximal timeout of ALTER TABLE request. Set long enough to fit your table data size."})
    public static int alter_table_timeout_second = 2592000;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u662f\u5426\u7981\u7528\u5b58\u50a8\u4ecb\u8d28\u68c0\u67e5\u3002\u5982\u679c\u7981\u7528\uff0cReportHandler \u5c06\u4e0d\u4f1a\u68c0\u67e5 tablet \u7684\u5b58\u50a8\u4ecb\u8d28\uff0c\u5e76\u4e14\u7981\u7528\u5b58\u50a8\u4ecb\u8d28\u51b7\u5374\u529f\u80fd\u3002\u9ed8\u8ba4\u503c\u4e3a false\u3002", "When disable_storage_medium_check is true, ReportHandler would not check tablet's storage medium and disable storage cool down function."})
    public static boolean disable_storage_medium_check = false;
    @ConfigBase.ConfField(description={"\u521b\u5efa\u8868\u6216\u5206\u533a\u65f6\uff0c\u53ef\u4ee5\u6307\u5b9a\u5b58\u50a8\u4ecb\u8d28(HDD \u6216 SSD)\u3002\u5982\u679c\u672a\u6307\u5b9a\uff0c\u5219\u4f7f\u7528\u6b64\u914d\u7f6e\u6307\u5b9a\u7684\u9ed8\u8ba4\u4ecb\u8d28\u3002", "When create a table(or partition), you can specify its storage medium(HDD or SSD)."})
    public static String default_storage_medium = "HDD";
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u5220\u9664\u6570\u636e\u5e93(\u8868/\u5206\u533a)\u540e\uff0c\u53ef\u4ee5\u4f7f\u7528 RECOVER \u8bed\u53e5\u6062\u590d\u3002\u6b64\u914d\u7f6e\u6307\u5b9a\u4e86\u6570\u636e\u7684\u6700\u5927\u4fdd\u7559\u65f6\u95f4\u3002\u8d85\u8fc7\u6b64\u65f6\u95f4\uff0c\u6570\u636e\u5c06\u88ab\u6c38\u4e45\u5220\u9664\u3002", "After dropping database(table/partition), you can recover it by using RECOVER stmt.", "And this specifies the maximal data retention time. After time, the data will be deleted permanently."})
    public static long catalog_trash_expire_second = 86400L;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u5355\u4e2a broker scanner \u8bfb\u53d6\u7684\u6700\u5c0f\u5b57\u8282\u6570\u3002Broker Load \u5207\u5206\u6587\u4ef6\u65f6\uff0c\u5982\u679c\u5207\u5206\u540e\u7684\u6587\u4ef6\u5927\u5c0f\u5c0f\u4e8e\u6b64\u503c\uff0c\u5c06\u4e0d\u4f1a\u5207\u5206\u3002", "Minimal bytes that a single broker scanner will read. When splitting file in broker load, if the size of split file is less than this value, it will not be split."})
    public static long min_bytes_per_broker_scanner = 0x4000000L;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u5355\u4e2a broker scanner \u7684\u6700\u5927\u5e76\u53d1\u6570\u3002", "Maximal concurrency of broker scanners."})
    public static int max_broker_concurrency = 10;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u5bfc\u51fa\u4f5c\u4e1a\u7684\u6700\u5927\u5e76\u53d1\u6570\u3002", "Limitation of the concurrency of running export jobs."})
    public static int export_running_job_num_limit = 5;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u5bfc\u51fa\u4f5c\u4e1a\u7684\u9ed8\u8ba4\u8d85\u65f6\u65f6\u95f4\u3002", "Default timeout of export jobs."})
    public static int export_task_default_timeout_second = 7200;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u6bcf\u4e2a\u5bfc\u51fa\u4f5c\u4e1a\u7684\u9700\u8981\u5904\u7406\u7684 tablet \u6570\u91cf\u3002", "Number of tablets need to be handled per export job."})
    public static int export_tablet_num_per_task = 5;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u4e00\u81f4\u6027\u68c0\u67e5\u7684\u5f00\u59cb\u65f6\u95f4\u3002\u4e0e `consistency_check_end_time` \u914d\u5408\u4f7f\u7528\uff0c\u51b3\u5b9a\u4e00\u81f4\u6027\u68c0\u67e5\u7684\u8d77\u6b62\u65f6\u95f4\u3002\u5982\u679c\u5c06\u4e24\u4e2a\u53c2\u6570\u8bbe\u7f6e\u4e3a\u76f8\u540c\u7684\u503c\uff0c\u5219\u4e00\u81f4\u6027\u68c0\u67e5\u5c06\u4e0d\u4f1a\u88ab\u8c03\u5ea6\u3002", "Start time of consistency check. Used with `consistency_check_end_time` to decide the start and end time of consistency check. If set to the same value, consistency check will not be scheduled."})
    public static String consistency_check_start_time = "23";
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u4e00\u81f4\u6027\u68c0\u67e5\u7684\u7ed3\u675f\u65f6\u95f4\u3002\u4e0e `consistency_check_start_time` \u914d\u5408\u4f7f\u7528\uff0c\u51b3\u5b9a\u4e00\u81f4\u6027\u68c0\u67e5\u7684\u8d77\u6b62\u65f6\u95f4\u3002\u5982\u679c\u5c06\u4e24\u4e2a\u53c2\u6570\u8bbe\u7f6e\u4e3a\u76f8\u540c\u7684\u503c\uff0c\u5219\u4e00\u81f4\u6027\u68c0\u67e5\u5c06\u4e0d\u4f1a\u88ab\u8c03\u5ea6\u3002", "End time of consistency check. Used with `consistency_check_start_time` to decide the start and end time of consistency check. If set to the same value, consistency check will not be scheduled."})
    public static String consistency_check_end_time = "23";
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u5355\u4e2a\u4e00\u81f4\u6027\u68c0\u67e5\u4efb\u52a1\u7684\u9ed8\u8ba4\u8d85\u65f6\u65f6\u95f4\u3002\u8bbe\u7f6e\u7684\u8db3\u591f\u957f\u4ee5\u9002\u5e94\u8868\u7684\u6570\u636e\u91cf\u3002", "Default timeout of a single consistency check task. Set long enough to fit your tablet size."})
    public static long check_consistency_default_timeout_second = 600L;
    @ConfigBase.ConfField(description={"\u5355\u4e2a FE \u7684 MySQL Server \u7684\u6700\u5927\u8fde\u63a5\u6570\u3002", "Maximal number of connections of MySQL server per FE."})
    public static int qe_max_connection = 1024;
    @ConfigBase.ConfField(description={"MySQL \u8fde\u63a5\u8c03\u5ea6\u7ebf\u7a0b\u6c60\u7684\u6700\u5927\u7ebf\u7a0b\u6570\u3002", "Maximal number of thread in MySQL connection-scheduler-pool."})
    public static int max_connection_scheduler_threads_num = 4096;
    @ConfigBase.ConfField(mutable=true, description={"Colocate join \u6bcf\u4e2a instance \u7684\u5185\u5b58 penalty \u7cfb\u6570\u3002\u8ba1\u7b97\u65b9\u5f0f\uff1a`exec_mem_limit / min (query_colocate_join_memory_limit_penalty_factor, instance_num)`", "Colocate join PlanFragment instance memory limit penalty factor.", "The memory_limit for colocote join PlanFragment instance = `exec_mem_limit / min (query_colocate_join_memory_limit_penalty_factor, instance_num)`"})
    public static int query_colocate_join_memory_limit_penalty_factor = 1;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static boolean disable_colocate_balance = false;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u662f\u5426\u542f\u7528group\u95f4\u7684\u5747\u8861", "is allow colocate balance between all groups"})
    public static boolean disable_colocate_balance_between_groups = false;
    @ConfigBase.ConfField
    public static int meta_publish_timeout_ms = 1000;
    @ConfigBase.ConfField
    public static boolean proxy_auth_enable = false;
    @ConfigBase.ConfField
    public static String proxy_auth_magic_prefix = "x@8";
    @ConfigBase.ConfField(mutable=true)
    public static int expr_children_limit = 10000;
    @ConfigBase.ConfField(mutable=true)
    public static int expr_depth_limit = 3000;
    @Deprecated
    @ConfigBase.ConfField
    public static String backup_plugin_path = "/tools/trans_file_tool/trans_files.sh";
    @ConfigBase.ConfField
    public static String dpp_hadoop_client_path = "/lib/hadoop-client/hadoop/bin/hadoop";
    @ConfigBase.ConfField
    public static long dpp_bytes_per_reduce = 0x6400000L;
    @ConfigBase.ConfField
    public static String dpp_default_cluster = "palo-dpp";
    @ConfigBase.ConfField
    public static String dpp_default_config_str = "{hadoop_configs : 'mapred.job.priority=NORMAL;mapred.job.map.capacity=50;mapred.job.reduce.capacity=50;mapred.hce.replace.streaming=false;abaci.long.stored.job=true;dce.shuffle.enable=false;dfs.client.authserver.force_stop=true;dfs.client.auth.method=0'}";
    @ConfigBase.ConfField
    public static String dpp_config_str = "{palo-dpp : {hadoop_palo_path : '/dir',hadoop_configs : 'fs.default.name=hdfs://host:port;mapred.job.tracker=host:port;hadoop.job.ugi=user,password'}}";
    @ConfigBase.ConfField
    public static boolean enable_token_check = true;
    @ConfigBase.ConfField
    public static String enable_deploy_manager = "disable";
    @ConfigBase.ConfField
    public static boolean with_k8s_certs = false;
    @ConfigBase.ConfField
    public static String locale = "zh_CN.UTF-8";
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int backup_job_default_timeout_ms = 86400000;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int storage_high_watermark_usage_percent = 85;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static long storage_min_left_capacity_bytes = 0x80000000L;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int storage_flood_stage_usage_percent = 95;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static long storage_flood_stage_left_capacity_bytes = 0x40000000L;
    @ConfigBase.ConfField
    public static int tablet_stat_update_interval_second = 60;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static long max_bytes_per_broker_scanner = 0x7D00000000L;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static long max_unfinished_load_job = 1000L;
    @ConfigBase.ConfField(mutable=true)
    public static boolean enable_local_replica_selection = false;
    @ConfigBase.ConfField(mutable=true)
    public static boolean enable_local_replica_selection_fallback = false;
    @ConfigBase.ConfField(mutable=true)
    public static int max_query_retry_time = 1;
    @ConfigBase.ConfField(mutable=true)
    public static int max_point_query_retry_time = 2;
    @ConfigBase.ConfField(mutable=true)
    public static long catalog_try_lock_timeout_ms = 5000L;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static boolean disable_load_job = false;
    @ConfigBase.ConfField(mutable=false, masterOnly=true)
    public static int db_used_data_quota_update_interval_secs = 300;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static boolean disable_hadoop_load = false;
    @ConfigBase.ConfField
    public static long es_state_sync_interval_second = 10L;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static long iceberg_table_creation_interval_second = 10L;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static long tablet_repair_delay_factor_second = 60L;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static long tablet_further_repair_timeout_second = 1200L;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int tablet_further_repair_max_times = 5;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int schedule_slot_num_per_hdd_path = 4;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int schedule_slot_num_per_ssd_path = 8;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int schedule_batch_size = 50;
    @ConfigBase.ConfField
    public static boolean use_new_tablet_scheduler = true;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static double balance_load_score_threshold = 0.1;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static boolean disable_balance = false;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static boolean disable_disk_balance = false;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int max_scheduling_tablets = 2000;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int max_balancing_tablets = 100;
    @ConfigBase.ConfField(masterOnly=true)
    public static String tablet_rebalancer_type = "BeLoad";
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static long partition_rebalance_move_expire_after_access = 600L;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int partition_rebalance_max_moves_num_per_selection = 10;
    @ConfigBase.ConfField(masterOnly=true, mutable=true)
    public static int balance_slot_num_per_path = 1;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int report_queue_size = 100;
    @ConfigBase.ConfField
    public static boolean enable_metric_calculator = true;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int max_routine_load_job_num = 100;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int max_routine_load_task_concurrent_num = 5;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int max_routine_load_task_num_per_be = 5;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int max_small_file_number = 100;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int max_small_file_size_bytes = 0x100000;
    @ConfigBase.ConfField
    public static String small_file_dir = System.getenv("DORIS_HOME") + "/small_files";
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static boolean using_old_load_usage_pattern = false;
    @ConfigBase.ConfField(mutable=true, masterOnly=false)
    public static int max_distribution_pruner_recursion_depth = 100;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static long metadata_checkpoint_memory_threshold = 70L;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static boolean force_do_metadata_checkpoint = false;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static long dynamic_partition_check_interval_seconds = 600L;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static boolean dynamic_partition_enable = true;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int max_running_rollup_job_num_per_table = 1;
    @ConfigBase.ConfField
    public static boolean check_java_version = true;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int max_tolerable_backend_down_num = 0;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int period_of_auto_resume_min = 5;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static boolean drop_backend_after_decommission = true;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int decommission_tablet_check_threshold = 5000;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int decommission_tablet_wait_time_seconds = 3600;
    @ConfigBase.ConfField
    public static String thrift_server_type = "THREAD_POOL";
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static long agent_task_resend_wait_time_ms = 5000L;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static long min_clone_task_timeout_sec = 180L;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static long max_clone_task_timeout_sec = 7200L;
    @ConfigBase.ConfField(mutable=true, masterOnly=false)
    public static boolean cache_enable_sql_mode = true;
    @ConfigBase.ConfField(mutable=true, masterOnly=false)
    public static boolean cache_enable_partition_mode = true;
    @ConfigBase.ConfField(mutable=true, masterOnly=false)
    public static int cache_last_version_interval_second = 900;
    @ConfigBase.ConfField(mutable=true, masterOnly=false, description={"SQL/Partition Cache\u53ef\u4ee5\u7f13\u5b58\u7684\u6700\u5927\u884c\u6570\u3002", "Maximum number of rows that can be cached in SQL/Partition Cache, is 3000 by default."})
    public static int cache_result_max_row_count = 3000;
    @ConfigBase.ConfField(mutable=true, masterOnly=false, description={"SQL/Partition Cache\u53ef\u4ee5\u7f13\u5b58\u7684\u6700\u5927\u6570\u636e\u5927\u5c0f\u3002", "Maximum data size of rows that can be cached in SQL/Partition Cache, is 3000 by default."})
    public static int cache_result_max_data_size = 0x1E00000;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int max_allowed_in_element_num_of_delete = 1024;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static boolean recover_with_empty_tablet = false;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static String recover_with_skip_missing_version = "disable";
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static boolean enable_batch_delete_by_default = true;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static boolean enable_hidden_version_column_by_default = true;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static long default_db_data_quota_bytes = 0x4000000000000L;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static long default_db_replica_quota_size = 0x40000000L;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static double default_max_filter_ratio = 0.0;
    @ConfigBase.ConfField
    public static boolean enable_http_server_v2 = true;
    @ConfigBase.ConfField
    public static String http_api_extra_base_path = "";
    @ConfigBase.ConfField
    public static boolean enable_bdbje_debug_mode = false;
    @ConfigBase.ConfField(mutable=false, masterOnly=true, description={"\u662f\u5426\u5f00\u542fdebug point\u6a21\u5f0f\uff0c\u6d4b\u8bd5\u4f7f\u7528", "is enable debug points, use in test."})
    public static boolean enable_debug_points = false;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static boolean enable_access_file_without_broker = false;
    @ConfigBase.ConfField
    public static boolean enable_outfile_to_local = false;
    @ConfigBase.ConfField
    public static int grpc_max_message_size_bytes = Integer.MAX_VALUE;
    @ConfigBase.ConfField
    public static int grpc_threadmgr_threads_nums = 4096;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static short min_replication_num_per_tablet = 1;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static short max_replication_num_per_tablet = Short.MAX_VALUE;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int max_dynamic_partition_num = 500;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int max_multi_partition_num = 4096;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int max_backup_restore_job_num_per_db = 10;
    @ConfigBase.ConfField(mutable=true)
    public static int default_max_query_instances = -1;
    @ConfigBase.ConfField(mutable=false, masterOnly=true)
    public static int partition_in_memory_update_interval_secs = 300;
    @ConfigBase.ConfField(masterOnly=true)
    public static boolean enable_concurrent_update = false;
    @ConfigBase.ConfField(masterOnly=true)
    public static int lower_case_table_names = 0;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int table_name_length_limit = 64;
    @ConfigBase.ConfField(mutable=false, masterOnly=true)
    public static int default_schema_change_scheduler_interval_millisecond = 500;
    @ConfigBase.ConfField(mutable=true, masterOnly=false)
    public static boolean use_compact_thrift_rpc = true;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static boolean disable_tablet_scheduler = false;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static boolean enable_force_drop_redundant_replica = false;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static boolean repair_slow_replica = false;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static long colocate_group_relocate_delay_second = 1800L;
    @ConfigBase.ConfField
    public static boolean allow_replica_on_same_host = false;
    @ConfigBase.ConfField(mutable=true)
    public static int min_version_count_indicate_replica_compaction_too_slow = 200;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static double valid_version_count_delta_ratio_between_replicas = 0.5;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static long min_bytes_indicate_replica_too_large = 0x80000000L;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static boolean iceberg_table_creation_strict_mode = true;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int cbo_max_statistics_job_num = 20;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int max_cbo_statistics_task_timeout_sec = 300;
    @ConfigBase.ConfField(mutable=false, masterOnly=true)
    public static int cbo_concurrency_statistics_task_num = 10;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int cbo_default_sample_percentage = 10;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static boolean enable_auto_collect_statistics = true;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int auto_check_statistics_in_minutes = 5;
    @ConfigBase.ConfField(mutable=false, masterOnly=false)
    public static boolean enable_tracing = false;
    @ConfigBase.ConfField(mutable=false, masterOnly=false)
    public static String trace_exporter = "zipkin";
    @ConfigBase.ConfField(mutable=false, masterOnly=false)
    public static String trace_export_url = "http://127.0.0.1:9411/api/v2/spans";
    @ConfigBase.ConfField(mutable=true)
    public static boolean skip_compaction_slower_replica = true;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static boolean enable_quantile_state_type = true;
    @ConfigBase.ConfField
    public static boolean enable_pipeline_load = false;
    @ConfigBase.ConfField(mutable=true, expType=ExperimentalUtil.ExperimentalType.EXPERIMENTAL)
    public static boolean enable_workload_group = false;
    @ConfigBase.ConfField(mutable=true)
    public static boolean enable_query_queue = true;
    @ConfigBase.ConfField(mutable=true)
    public static boolean disable_shared_scan = false;
    @ConfigBase.ConfField(mutable=false, masterOnly=true)
    public static int backend_rpc_timeout_ms = 60000;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static boolean be_rebalancer_fuzzy_test = false;
    @ConfigBase.ConfField(mutable=true)
    public static boolean enable_date_conversion = true;
    @ConfigBase.ConfField(mutable=false, masterOnly=true)
    public static boolean enable_multi_tags = false;
    @ConfigBase.ConfField(mutable=true)
    public static boolean enable_decimal_conversion = true;
    @ConfigBase.ConfField
    public static String s3_compatible_object_storages = "s3,oss,cos,bos";
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static boolean enable_array_type = false;
    @ConfigBase.ConfField(mutable=true)
    public static long remote_fragment_exec_timeout_ms = 30000L;
    @ConfigBase.ConfField(mutable=false)
    public static int max_be_exec_version = 3;
    @ConfigBase.ConfField(mutable=false)
    public static int min_be_exec_version = 0;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int be_exec_version = max_be_exec_version;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, expType=ExperimentalUtil.ExperimentalType.EXPERIMENTAL)
    public static boolean enable_mtmv = false;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int max_running_mtmv_scheduler_task_num = 100;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int max_pending_mtmv_scheduler_task_num = 100;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static long scheduler_mtmv_job_expired = 86400L;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static long scheduler_mtmv_task_expired = 86400L;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static boolean keep_scheduler_mtmv_task_when_job_deleted = false;
    @ConfigBase.ConfField(mutable=true, masterOnly=false)
    public static boolean prefer_compute_node_for_external_table = false;
    @ConfigBase.ConfField(mutable=true, masterOnly=false)
    public static int min_backend_num_for_external_table = 3;
    @ConfigBase.ConfField(mutable=true, masterOnly=false)
    public static int max_query_profile_num = 100;
    @ConfigBase.ConfField(mutable=true, masterOnly=false)
    public static boolean disable_backend_black_list = false;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static long max_backend_heartbeat_failure_tolerance_count = 1L;
    @ConfigBase.ConfField(mutable=true, masterOnly=false)
    public static boolean disable_iceberg_hudi_table = true;
    @ConfigBase.ConfField(mutable=true, masterOnly=false)
    public static long hive_metastore_client_timeout_second = 10L;
    @ConfigBase.ConfField
    public static int statistics_simultaneously_running_task_num = 3;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static long max_replica_count_when_schema_change = 100000L;
    @ConfigBase.ConfField(mutable=false, masterOnly=false)
    public static long max_hive_partition_cache_num = 100000L;
    @ConfigBase.ConfField(mutable=false, masterOnly=false, description={"Hive\u8868\u5230\u5206\u533a\u540d\u5217\u8868\u7f13\u5b58\u7684\u6700\u5927\u6570\u91cf\u3002", "Max cache number of hive table to partition names list."})
    public static long max_hive_table_cache_num = 1000L;
    @ConfigBase.ConfField(mutable=false, masterOnly=false, description={"\u83b7\u53d6Hive\u5206\u533a\u503c\u65f6\u5019\u7684\u6700\u5927\u8fd4\u56de\u6570\u91cf\uff0c-1\u4ee3\u8868\u6ca1\u6709\u9650\u5236\u3002", "Max number of hive partition values to return while list partitions, -1 means no limitation."})
    public static short max_hive_list_partition_num = (short)-1;
    @ConfigBase.ConfField(mutable=false, masterOnly=false, description={"\u8fdc\u7a0b\u6587\u4ef6\u7cfb\u7edf\u7f13\u5b58\u7684\u6700\u5927\u6570\u91cf", "Max cache number of remote file system."})
    public static long max_remote_file_system_cache_num = 100L;
    @ConfigBase.ConfField(mutable=false, masterOnly=false)
    public static int max_external_cache_loader_thread_pool_size = 64;
    @ConfigBase.ConfField(mutable=false, masterOnly=false)
    public static long max_external_file_cache_num = 100000L;
    @ConfigBase.ConfField(mutable=false, masterOnly=false)
    public static long max_external_schema_cache_num = 10000L;
    @ConfigBase.ConfField(mutable=false, masterOnly=false)
    public static long external_cache_expire_time_minutes_after_access = 10L;
    @ConfigBase.ConfField(mutable=true, masterOnly=false)
    public static String fuzzy_test_type = "";
    @ConfigBase.ConfField(mutable=true, masterOnly=false)
    public static boolean use_fuzzy_session_variable = false;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int max_same_name_catalog_trash_num = 3;
    @ConfigBase.ConfField(mutable=false, masterOnly=true)
    public static boolean enable_storage_policy = true;
    @ConfigBase.ConfField(mutable=false, expType=ExperimentalUtil.ExperimentalType.EXPERIMENTAL)
    public static boolean enable_fqdn_mode = false;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u662f\u5426\u5f00\u542f ODBC \u5916\u8868\u529f\u80fd\uff0c\u9ed8\u8ba4\u5173\u95ed\uff0cODBC \u5916\u8868\u662f\u6dd8\u6c70\u7684\u529f\u80fd\uff0c\u8bf7\u4f7f\u7528 JDBC Catalog", "Whether to enable the ODBC appearance function, it is disabled by default, and the ODBC appearance is an obsolete feature. Please use the JDBC Catalog"})
    public static boolean enable_odbc_table = false;
    @ConfigBase.ConfField(mutable=true)
    public static boolean enable_func_pushdown = true;
    @ConfigBase.ConfField(mutable=true, expType=ExperimentalUtil.ExperimentalType.EXPERIMENTAL)
    public static boolean enable_query_hive_views = false;
    @ConfigBase.ConfField(masterOnly=true)
    public static boolean enable_hms_events_incremental_sync = false;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int hms_events_batch_size_per_rpc = 500;
    @ConfigBase.ConfField(masterOnly=true)
    public static int hms_events_polling_interval_ms = 10000;
    @ConfigBase.ConfField(masterOnly=true, mutable=true)
    public static int max_error_tablet_of_broker_load = 3;
    @ConfigBase.ConfField(mutable=false, masterOnly=false, expType=ExperimentalUtil.ExperimentalType.EXPERIMENTAL)
    public static boolean enable_ssl = false;
    @ConfigBase.ConfField(mutable=false, masterOnly=false)
    public static boolean ssl_force_client_auth = false;
    @ConfigBase.ConfField(mutable=false, masterOnly=false)
    public static String mysql_ssl_default_ca_certificate = System.getenv("DORIS_HOME") + "/mysql_ssl_default_certificate/ca_certificate.p12";
    @ConfigBase.ConfField(mutable=false, masterOnly=false)
    public static String mysql_ssl_default_server_certificate = System.getenv("DORIS_HOME") + "/mysql_ssl_default_certificate/server_certificate.p12";
    @ConfigBase.ConfField(mutable=false, masterOnly=false)
    public static String mysql_ssl_default_ca_certificate_password = "doris";
    @ConfigBase.ConfField(mutable=false, masterOnly=false)
    public static String mysql_ssl_default_server_certificate_password = "doris";
    @ConfigBase.ConfField(mutable=true)
    public static int pull_request_id = 0;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static long default_db_max_running_txn_num = -1L;
    @ConfigBase.ConfField(mutable=false, masterOnly=true)
    public static int token_queue_size = 6;
    @ConfigBase.ConfField(mutable=false, masterOnly=true)
    public static int token_generate_period_hour = 12;
    @ConfigBase.ConfField(mutable=false, masterOnly=false)
    public static String mysql_load_server_secure_path = "";
    @ConfigBase.ConfField(mutable=false, masterOnly=false)
    public static int mysql_load_in_memory_record = 20;
    @ConfigBase.ConfField(mutable=false, masterOnly=false)
    public static int mysql_load_thread_pool = 4;
    @ConfigBase.ConfField
    public static String bdbje_file_logging_level = "ALL";
    @ConfigBase.ConfField
    public static long lock_reporting_threshold_ms = 500L;
    @ConfigBase.ConfField(mutable=true)
    public static boolean infodb_support_ext_catalog = false;
    @ConfigBase.ConfField(mutable=false)
    public static boolean skip_localhost_auth_check = true;
    @ConfigBase.ConfField(mutable=true)
    public static boolean enable_round_robin_create_tablet = false;
    @ConfigBase.ConfField(mutable=true)
    public static boolean disable_decimalv2 = true;
    @ConfigBase.ConfField(mutable=true)
    public static boolean disable_datev1 = true;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u5f53\u524d\u9ed8\u8ba4\u8bbe\u7f6e\u4e3a true\uff0c\u4e0d\u652f\u6301\u5efa\u8868\u65f6\u521b\u5efa\u590d\u6742\u7c7b\u578b(array/struct/map)\u5d4c\u5957\u590d\u6742\u7c7b\u578b, \u4ec5\u652f\u6301array\u7c7b\u578b\u81ea\u8eab\u5d4c\u5957\u3002", "Now default set to true, not support create complex type(array/struct/map) nested complex type when we create table, only support array type nested array"})
    public static boolean disable_nested_complex_type = true;
    @ConfigBase.ConfField(mutable=true)
    public static int div_precision_increment = 4;
    @ConfigBase.ConfField(mutable=false)
    public static boolean enable_delete_existing_files = false;
    @ConfigBase.ConfField
    public static long stats_cache_size = 500000L;
    @ConfigBase.ConfField(mutable=true)
    public static boolean enable_query_hit_stats = false;
    @ConfigBase.ConfField(mutable=true, description={"\u8bbe\u7f6e\u4e3a true\uff0c\u5982\u679c\u67e5\u8be2\u65e0\u6cd5\u9009\u62e9\u5230\u5065\u5eb7\u526f\u672c\u65f6\uff0c\u4f1a\u6253\u5370\u51fa\u8be5tablet\u6240\u6709\u526f\u672c\u7684\u8be6\u7ec6\u4fe1\u606f\uff0c\u4ee5\u53ca\u4e0d\u53ef\u67e5\u8be2\u7684\u5177\u4f53\u539f\u56e0\u3002", "When set to true, if a query is unable to select a healthy replica, the detailed information of all the replicas of the tablet, including the specific reason why they are unqueryable, will be printed out."})
    public static boolean show_details_for_unaccessible_tablet = false;
    @ConfigBase.ConfField(mutable=false, masterOnly=false, expType=ExperimentalUtil.ExperimentalType.EXPERIMENTAL, description={"\u662f\u5426\u542f\u7528binlog\u7279\u6027", "Whether to enable binlog feature"})
    public static boolean enable_feature_binlog = false;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u662f\u5426\u7981\u6b62\u4f7f\u7528 WITH REOSOURCE \u8bed\u53e5\u521b\u5efa Catalog\u3002", "Whether to disable creating catalog with WITH RESOURCE statement."})
    public static boolean disallow_create_catalog_with_resource = true;
    @ConfigBase.ConfField(mutable=true, masterOnly=false, description={"Hive\u884c\u6570\u4f30\u7b97\u5206\u533a\u91c7\u6837\u6570", "Sample size for hive row count estimation."})
    public static int hive_stats_partition_sample_size = 3000;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u7528\u4e8e\u5f3a\u5236\u8bbe\u5b9a\u5185\u8868\u7684\u526f\u672c\u6570\uff0c\u5982\u679c\u8be5\u53c2\u6570\u5927\u4e8e\u96f6\uff0c\u5219\u7528\u6237\u5728\u5efa\u8868\u65f6\u6307\u5b9a\u7684\u526f\u672c\u6570\u5c06\u88ab\u5ffd\u7565\uff0c\u800c\u4f7f\u7528\u672c\u53c2\u6570\u8bbe\u7f6e\u7684\u503c\u3002\u540c\u65f6\uff0c\u5efa\u8868\u8bed\u53e5\u4e2d\u6307\u5b9a\u7684\u526f\u672c\u6807\u7b7e\u7b49\u53c2\u6570\u4f1a\u88ab\u5ffd\u7565\u3002\u8be5\u53c2\u6570\u4e0d\u5f71\u54cd\u5305\u62ec\u521b\u5efa\u5206\u533a\u3001\u4fee\u6539\u8868\u5c5e\u6027\u7684\u64cd\u4f5c\u3002\u8be5\u53c2\u6570\u5efa\u8bae\u4ec5\u7528\u4e8e\u6d4b\u8bd5\u73af\u5883", "Used to force the number of replicas of the internal table. If the config is greater than zero, the number of replicas specified by the user when creating the table will be ignored, and the value set by this parameter will be used. At the same time, the replica tags and other parameters specified in the create table statement will be ignored. This config does not effect the operations including creating partitions and modifying table properties. This config is recommended to be used only in the test environment"})
    public static int force_olap_table_replication_num = 0;
    @ConfigBase.ConfField
    public static long statistics_sql_mem_limit_in_bytes = 0x80000000L;
    @ConfigBase.ConfField
    public static int statistics_sql_parallel_exec_instance_num = 1;
    @ConfigBase.ConfField
    public static int cpu_resource_limit_per_analyze_task = 1;
    @ConfigBase.ConfField(mutable=true, description={"Export\u4efb\u52a1\u5141\u8bb8\u7684\u6700\u5927\u5206\u533a\u6570\u91cf", "The maximum number of partitions allowed by Export job"})
    public static int maximum_number_of_export_partitions = 2000;
    @ConfigBase.ConfField(mutable=true, description={"Export\u4efb\u52a1\u5141\u8bb8\u7684\u6700\u5927\u5e76\u884c\u6570", "The maximum parallelism allowed by Export job"})
    public static int maximum_parallelism_of_export_job = 50;
    @ConfigBase.ConfField(mutable=true, description={"\u662f\u5426\u7528 mysql \u7684 bigint \u7c7b\u578b\u6765\u8fd4\u56de Doris \u7684 largeint \u7c7b\u578b", "Whether to use mysql's bigint type to return Doris's largeint type"})
    public static boolean use_mysql_bigint_for_largeint = false;
    @ConfigBase.ConfField(description={"\u662f\u5426\u5f00\u542f\u5217\u6743\u9650", "Whether to enable col auth"})
    public static boolean enable_col_auth = false;
    @ConfigBase.ConfField
    public static boolean forbid_running_alter_job = false;
    @ConfigBase.ConfField(description={"\u6682\u65f6\u6027\u914d\u7f6e\u9879\uff0c\u5f00\u542f\u540e\u4f1a\u81ea\u52a8\u5c06\u6240\u6709\u7684olap\u8868\u4fee\u6539\u4e3a\u53eflight schema change", "temporary config filed, will make all olap tables enable light schema change"})
    public static boolean enable_convert_light_weight_schema_change = true;
    @ConfigBase.ConfField(mutable=true, masterOnly=false, description={"\u67e5\u8be2information_schema.metadata_name_ids\u8868\u65f6,\u83b7\u53d6\u4e00\u4e2a\u6570\u636e\u5e93\u4e2d\u6240\u6709\u8868\u7528\u7684\u65f6\u95f4", "When querying the information_schema.metadata_name_ids table, the time used to obtain all tables in one database"})
    public static long query_metadata_name_ids_timeout = 3L;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u662f\u5426\u7981\u6b62LocalDeployManager\u5220\u9664\u8282\u70b9", "Whether to disable LocalDeployManager drop node"})
    public static boolean disable_local_deploy_manager_drop_node = true;
    @ConfigBase.ConfField(mutable=true, description={"\u5f00\u542f file cache \u540e\uff0c\u4e00\u81f4\u6027\u54c8\u5e0c\u7b97\u6cd5\u4e2d\uff0c\u6bcf\u4e2a\u8282\u70b9\u7684\u865a\u62df\u8282\u70b9\u6570\u3002\u8be5\u503c\u8d8a\u5927\uff0c\u54c8\u5e0c\u7b97\u6cd5\u7684\u5206\u5e03\u8d8a\u5747\u5300\uff0c\u4f46\u662f\u4f1a\u589e\u52a0\u5185\u5b58\u5f00\u9500\u3002", "When file cache is enabled, the number of virtual nodes of each node in the consistent hash algorithm. The larger the value, the more uniform the distribution of the hash algorithm, but it will increase the memory overhead."})
    public static int virtual_node_number = 2048;
    @ConfigBase.ConfField(description={"\u63a7\u5236\u7edf\u8ba1\u4fe1\u606f\u7684\u81ea\u52a8\u89e6\u53d1\u4f5c\u4e1a\u6267\u884c\u8bb0\u5f55\u7684\u6301\u4e45\u5316\u884c\u6570", "Determine the persist number of automatic triggered analyze job execution status"})
    public static long analyze_record_limit = 20000L;
    @ConfigBase.ConfField(description={"Auto Buckets\u4e2d\u6700\u5c0f\u7684buckets\u6570\u76ee", "min buckets of auto bucket"})
    public static int autobucket_min_buckets = 1;
    @ConfigBase.ConfField
    public static int full_auto_analyze_simultaneously_running_task_num = 1;
    @ConfigBase.ConfField
    public static final int period_analyze_simultaneously_running_task_num = 1;
    @ConfigBase.ConfField(mutable=true, description={"Doris \u4e3a\u4e86\u517c\u7528 mysql \u5468\u8fb9\u5de5\u5177\u751f\u6001\uff0c\u4f1a\u5185\u7f6e\u4e00\u4e2a\u540d\u4e3a mysql \u7684\u6570\u636e\u5e93\uff0c\u5982\u679c\u8be5\u6570\u636e\u5e93\u4e0e\u7528\u6237\u81ea\u5efa\u6570\u636e\u5e93\u51b2\u7a81\uff0c\u8bf7\u4fee\u6539\u8fd9\u4e2a\u5b57\u6bb5\uff0c\u4e3a doris \u5185\u7f6e\u7684 mysql database \u66f4\u6362\u4e00\u4e2a\u540d\u5b57", "To ensure compatibility with the MySQL ecosystem, Doris includes a built-in database called mysql. If this database conflicts with a user's own database, please modify this field to replace the name of the Doris built-in MySQL database with a different name."})
    public static String mysqldb_replace_name = "mysql";
    @ConfigBase.ConfField(description={"\u8bbe\u7f6e\u5141\u8bb8\u8de8\u57df\u8bbf\u95ee\u7684\u7279\u5b9a\u57df\u540d,\u9ed8\u8ba4\u5141\u8bb8\u4efb\u4f55\u57df\u540d\u8de8\u57df\u8bbf\u95ee", "Set the specific domain name that allows cross-domain access. By default, any domain name is allowed cross-domain access"})
    public static String access_control_allowed_origin_domain = "*";
    @ConfigBase.ConfField(description={"\u5f00\u542fjava_udf, \u9ed8\u8ba4\u4e3atrue\u3002\u5982\u679c\u8be5\u914d\u7f6e\u4e3afalse\uff0c\u5219\u7981\u6b62\u521b\u5efa\u548c\u4f7f\u7528java_udf\u3002\u5728\u4e00\u4e9b\u573a\u666f\u4e0b\u5173\u95ed\u8be5\u914d\u7f6e\u53ef\u9632\u6b62\u547d\u4ee4\u6ce8\u5165\u653b\u51fb\u3002", "Used to enable java_udf, default is true. if this configuration is false, creation and use of java_udf is disabled. in some scenarios it may be necessary to disable this configuration to prevent command injection attacks."})
    public static boolean enable_java_udf = true;
    @ConfigBase.ConfField(description={"\u662f\u5426\u5ffd\u7565 Image \u6587\u4ef6\u4e2d\u672a\u77e5\u7684\u6a21\u5757\u3002\u5982\u679c\u4e3a true\uff0c\u4e0d\u5728 PersistMetaModules.MODULE_NAMES \u4e2d\u7684\u5143\u6570\u636e\u6a21\u5757\u5c06\u88ab\u5ffd\u7565\u5e76\u8df3\u8fc7\u3002\u9ed8\u8ba4\u4e3a false\uff0c\u5982\u679c Image \u6587\u4ef6\u4e2d\u5305\u542b\u672a\u77e5\u7684\u6a21\u5757\uff0cDoris \u5c06\u4f1a\u629b\u51fa\u5f02\u5e38\u3002\u8be5\u53c2\u6570\u4e3b\u8981\u7528\u4e8e\u964d\u7ea7\u64cd\u4f5c\u4e2d\uff0c\u8001\u7248\u672c\u53ef\u4ee5\u517c\u5bb9\u65b0\u7248\u672c\u7684 Image \u6587\u4ef6\u3002", "Whether to ignore unknown modules in Image file. If true, metadata modules not in PersistMetaModules.MODULE_NAMES will be ignored and skipped. Default is false, if Image file contains unknown modules, Doris will throw exception. This parameter is mainly used in downgrade operation, old version can be compatible with new version Image file."})
    public static boolean ignore_unknown_metadata_module = false;
    @ConfigBase.ConfField(mutable=true, masterOnly=true, description={"\u4ece\u4e3b\u8282\u70b9\u540c\u6b65image\u6587\u4ef6\u7684\u8d85\u65f6\u65f6\u95f4\uff0c\u7528\u6237\u53ef\u6839\u636e${meta_dir}/image\u6587\u4ef6\u5939\u4e0b\u9762\u7684image\u6587\u4ef6\u5927\u5c0f\u548c\u8282\u70b9\u95f4\u7684\u7f51\u7edc\u73af\u5883\u8c03\u6574\uff0c\u5355\u4f4d\u4e3a\u79d2\uff0c\u9ed8\u8ba4\u503c300", "The timeout for FE Follower/Observer synchronizing an image file from the FE Master, can be adjusted by the user on the size of image file in the ${meta_dir}/image and the network environment between nodes. The default values is 300."})
    public static int sync_image_timeout_second = 300;
    @ConfigBase.ConfField(mutable=true, masterOnly=true)
    public static int publish_topic_info_interval_ms = 30000;
    @ConfigBase.ConfField(description={"\u9650\u5236fe\u8282\u70b9thrift server\u53ef\u4ee5\u63a5\u6536\u7684\u6700\u5927\u5305\u5927\u5c0f,\u9ed8\u8ba420M,\u8bbe\u7f6e\u4e3a-1\u8868\u793a\u4e0d\u9650\u5236", "the max package size fe thrift server can receive,avoid accepting erroror too large package causing OOM,default 20000000(20M),set -1 for unlimited. "})
    public static int fe_thrift_max_pkg_bytes = 20000000;
}

