/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.doris.catalog.AggStateType;
import org.apache.doris.catalog.AnyElementType;
import org.apache.doris.catalog.AnyStructType;
import org.apache.doris.catalog.AnyType;
import org.apache.doris.catalog.ArrayType;
import org.apache.doris.catalog.MapType;
import org.apache.doris.catalog.MultiRowType;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.StructField;
import org.apache.doris.catalog.StructType;
import org.apache.doris.catalog.TypeException;
import org.apache.doris.catalog.VariantType;
import org.apache.doris.common.Pair;
import org.apache.doris.thrift.TColumnType;
import org.apache.doris.thrift.TPrimitiveType;
import org.apache.doris.thrift.TScalarType;
import org.apache.doris.thrift.TStructField;
import org.apache.doris.thrift.TTypeDesc;
import org.apache.doris.thrift.TTypeNode;
import org.apache.doris.thrift.TTypeNodeType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;

public abstract class Type {
    public static int MAX_NESTING_DEPTH;
    public static final ScalarType INVALID;
    public static final ScalarType UNSUPPORTED;
    public static final ScalarType NULL;
    public static final ScalarType BOOLEAN;
    public static final ScalarType TINYINT;
    public static final ScalarType SMALLINT;
    public static final ScalarType INT;
    public static final ScalarType BIGINT;
    public static final ScalarType LARGEINT;
    public static final ScalarType FLOAT;
    public static final ScalarType DOUBLE;
    public static final ScalarType DATE;
    public static final ScalarType DATETIME;
    public static final ScalarType DATEV2;
    public static final ScalarType TIMEV2;
    public static final ScalarType TIME;
    public static final ScalarType STRING;
    public static final ScalarType DEFAULT_DECIMALV2;
    public static final ScalarType MAX_DECIMALV2_TYPE;
    public static final ScalarType DEFAULT_DECIMAL32;
    public static final ScalarType DEFAULT_DECIMAL64;
    public static final ScalarType DEFAULT_DECIMAL128;
    public static final ScalarType DEFAULT_DECIMALV3;
    public static final ScalarType DEFAULT_DATETIMEV2;
    public static final ScalarType DATETIMEV2;
    public static final ScalarType DATETIMEV2_WITH_MAX_SCALAR;
    public static final ScalarType DEFAULT_TIMEV2;
    public static final ScalarType DECIMALV2;
    public static final ScalarType DECIMAL32;
    public static final ScalarType DECIMAL64;
    public static final ScalarType DECIMAL128;
    public static final ScalarType JSONB;
    public static final ScalarType DEFAULT_VARCHAR;
    public static final ScalarType VARCHAR;
    public static final ScalarType HLL;
    public static final ScalarType CHAR;
    public static final ScalarType BITMAP;
    public static final ScalarType QUANTILE_STATE;
    public static final AggStateType AGG_STATE;
    public static final ScalarType LAMBDA_FUNCTION;
    public static final ScalarType ALL;
    public static final MapType MAP;
    public static final ArrayType ARRAY;
    public static final StructType GENERIC_STRUCT;
    public static final StructType STRUCT;
    public static final VariantType VARIANT;
    public static final AnyType ANY_STRUCT_TYPE;
    public static final AnyType ANY_ELEMENT_TYPE;
    private static final Logger LOG;
    private static final ArrayList<ScalarType> integerTypes;
    private static final ArrayList<ScalarType> stringTypes;
    private static final ArrayList<ScalarType> numericTypes;
    private static final ArrayList<ScalarType> numericDateTimeTypes;
    private static final ArrayList<ScalarType> supportedTypes;
    private static final ArrayList<Type> arraySubTypes;
    private static final ArrayList<Type> mapSubTypes;
    private static final ArrayList<Type> structSubTypes;
    private static final ArrayList<ScalarType> trivialTypes;
    public static final Set<Class> DATE_SUPPORTED_JAVA_TYPE;
    public static final Set<Class> DATETIME_SUPPORTED_JAVA_TYPE;
    public static final ImmutableMap<PrimitiveType, Set<Class>> PrimitiveTypeToJavaClassType;
    public static final String OnlyMetricTypeErrorMsg = "Doris hll, bitmap, array, map, struct, jsonb column must use with specific function, and don't support filter, group by or order by. please run 'help hll' or 'help bitmap' or 'help array' or 'help map' or 'help struct' or 'help jsonb' in your mysql client.";
    protected static PrimitiveType[][] compatibilityMatrix;
    protected static PrimitiveType[][] strictCompatibilityMatrix;

    public static ArrayList<ScalarType> getIntegerTypes() {
        return integerTypes;
    }

    public static ArrayList<ScalarType> getStringTypes() {
        return stringTypes;
    }

    public static ArrayList<ScalarType> getNumericTypes() {
        return numericTypes;
    }

    public static ArrayList<ScalarType> getNumericDateTimeTypes() {
        return numericDateTimeTypes;
    }

    public static ArrayList<ScalarType> getTrivialTypes() {
        return trivialTypes;
    }

    public static ArrayList<ScalarType> getSupportedTypes() {
        return supportedTypes;
    }

    public static ArrayList<Type> getArraySubTypes() {
        return arraySubTypes;
    }

    public static ArrayList<Type> getMapSubTypes() {
        return mapSubTypes;
    }

    public static ArrayList<Type> getStructSubTypes() {
        return structSubTypes;
    }

    public boolean supportSubType(Type subType) {
        return false;
    }

    public final String toSql() {
        return this.toSql(0);
    }

    protected abstract String toSql(int var1);

    public String prettyPrint() {
        return this.prettyPrint(0);
    }

    protected abstract String prettyPrint(int var1);

    public boolean isInvalid() {
        return this.isScalarType(PrimitiveType.INVALID_TYPE);
    }

    public boolean isValid() {
        return !this.isInvalid();
    }

    public boolean isNull() {
        return this.isScalarType(PrimitiveType.NULL_TYPE);
    }

    public boolean isBoolean() {
        return this.isScalarType(PrimitiveType.BOOLEAN);
    }

    public boolean isDecimalV2() {
        return this.isScalarType(PrimitiveType.DECIMALV2);
    }

    public boolean typeContainsPrecision() {
        if (PrimitiveType.typeWithPrecision.contains((Object)this.getPrimitiveType())) {
            return true;
        }
        if (this.isStructType()) {
            for (StructField field : ((StructType)this).getFields()) {
                if (!PrimitiveType.typeWithPrecision.contains((Object)field.getType().getPrimitiveType())) continue;
                return true;
            }
        } else {
            if (this.isMapType()) {
                return PrimitiveType.typeWithPrecision.contains((Object)((MapType)this).getKeyType().getPrimitiveType()) || PrimitiveType.typeWithPrecision.contains((Object)((MapType)this).getValueType().getPrimitiveType());
            }
            if (this.isArrayType()) {
                return PrimitiveType.typeWithPrecision.contains((Object)((ArrayType)this).getItemType().getPrimitiveType());
            }
        }
        return false;
    }

    public boolean isDecimalV3OrContainsDecimalV3() {
        if (this.isDecimalV3()) {
            return true;
        }
        if (this.isStructType()) {
            for (StructField field : ((StructType)this).getFields()) {
                if (!field.getType().isDecimalV3()) continue;
                return true;
            }
        } else {
            if (this.isMapType()) {
                return ((MapType)this).getKeyType().isDecimalV3() || ((MapType)this).getValueType().isDecimalV3();
            }
            if (this.isArrayType()) {
                return ((ArrayType)this).getItemType().isDecimalV3();
            }
        }
        return false;
    }

    public boolean isDecimalV3() {
        return this.isScalarType(PrimitiveType.DECIMAL32) || this.isScalarType(PrimitiveType.DECIMAL64) || this.isScalarType(PrimitiveType.DECIMAL128);
    }

    public boolean isDatetimeV2() {
        return this.isScalarType(PrimitiveType.DATETIMEV2);
    }

    public boolean isDateLike() {
        return this.isScalarType(PrimitiveType.DATETIME) || this.isScalarType(PrimitiveType.DATETIMEV2) || this.isScalarType(PrimitiveType.DATE) || this.isScalarType(PrimitiveType.DATEV2);
    }

    public boolean isTimeV2() {
        return this.isScalarType(PrimitiveType.TIMEV2);
    }

    public boolean isWildcardDecimal() {
        return false;
    }

    public boolean isWildcardVarchar() {
        return false;
    }

    public boolean isWildcardChar() {
        return false;
    }

    public boolean isStringType() {
        return this.isScalarType(PrimitiveType.VARCHAR) || this.isScalarType(PrimitiveType.CHAR) || this.isScalarType(PrimitiveType.STRING);
    }

    public boolean isVarcharOrStringType() {
        return this.isScalarType(PrimitiveType.VARCHAR) || this.isScalarType(PrimitiveType.STRING);
    }

    public boolean isVarchar() {
        return this.isScalarType(PrimitiveType.VARCHAR);
    }

    public boolean isJsonbType() {
        return this.isScalarType(PrimitiveType.JSONB);
    }

    public boolean isOnlyMetricType() {
        return this.isObjectStored() || this.isComplexType() || this.isJsonbType();
    }

    public boolean isHllType() {
        return this.isScalarType(PrimitiveType.HLL);
    }

    public boolean isBitmapType() {
        return this.isScalarType(PrimitiveType.BITMAP);
    }

    public boolean isQuantileStateType() {
        return this.isScalarType(PrimitiveType.QUANTILE_STATE);
    }

    public boolean isLambdaFunctionType() {
        return this.isScalarType(PrimitiveType.LAMBDA_FUNCTION);
    }

    public boolean isObjectStored() {
        return this.isHllType() || this.isBitmapType() || this.isQuantileStateType();
    }

    public boolean isScalarType() {
        return this instanceof ScalarType;
    }

    public boolean isScalarType(PrimitiveType t) {
        return this.isScalarType() && ((ScalarType)this).getPrimitiveType() == t;
    }

    public boolean isFixedPointType() {
        return this.isScalarType(PrimitiveType.TINYINT) || this.isScalarType(PrimitiveType.SMALLINT) || this.isScalarType(PrimitiveType.INT) || this.isScalarType(PrimitiveType.BIGINT) || this.isScalarType(PrimitiveType.LARGEINT);
    }

    public boolean isFloatingPointType() {
        return this.isScalarType(PrimitiveType.FLOAT) || this.isScalarType(PrimitiveType.DOUBLE);
    }

    public boolean isIntegerType() {
        return this.isScalarType(PrimitiveType.TINYINT) || this.isScalarType(PrimitiveType.SMALLINT) || this.isScalarType(PrimitiveType.INT) || this.isScalarType(PrimitiveType.BIGINT);
    }

    public boolean isInteger32Type() {
        return this.isScalarType(PrimitiveType.TINYINT) || this.isScalarType(PrimitiveType.SMALLINT) || this.isScalarType(PrimitiveType.INT);
    }

    public boolean isBigIntType() {
        return this.isScalarType(PrimitiveType.BIGINT);
    }

    public boolean isLargeIntType() {
        return this.isScalarType(PrimitiveType.LARGEINT);
    }

    public boolean isFixedLengthType() {
        return false;
    }

    public boolean isNumericType() {
        return this.isFixedPointType() || this.isFloatingPointType() || this.isDecimalV2() || this.isDecimalV3();
    }

    public boolean isNativeType() {
        return this.isFixedPointType() || this.isFloatingPointType() || this.isBoolean();
    }

    public boolean isDateType() {
        return this.isScalarType(PrimitiveType.DATE) || this.isScalarType(PrimitiveType.DATETIME) || this.isScalarType(PrimitiveType.DATEV2) || this.isScalarType(PrimitiveType.DATETIMEV2);
    }

    public boolean isDateOrDateTime() {
        return this.isScalarType(PrimitiveType.DATE) || this.isScalarType(PrimitiveType.DATETIME);
    }

    public boolean isDatetime() {
        return this.isScalarType(PrimitiveType.DATETIME);
    }

    public boolean isTime() {
        return this.isScalarType(PrimitiveType.TIME);
    }

    public boolean isComplexType() {
        return this.isStructType() || this.isCollectionType();
    }

    public boolean isVariantType() {
        return this instanceof VariantType;
    }

    public boolean isCollectionType() {
        return this.isMapType() || this.isArrayType() || this.isMultiRowType();
    }

    public boolean isMapType() {
        return this instanceof MapType;
    }

    public boolean isArrayType() {
        return this instanceof ArrayType;
    }

    public boolean isAggStateType() {
        return this.isScalarType(PrimitiveType.AGG_STATE);
    }

    public boolean isMultiRowType() {
        return this instanceof MultiRowType;
    }

    public boolean isStructType() {
        return this instanceof StructType;
    }

    public boolean isAnyType() {
        return this instanceof AnyType;
    }

    public boolean isDate() {
        return this.isScalarType(PrimitiveType.DATE);
    }

    public boolean isDateV2() {
        return this.isScalarType(PrimitiveType.DATEV2);
    }

    public boolean isDateV2OrDateTimeV2() {
        return this.isScalarType(PrimitiveType.DATEV2) || this.isScalarType(PrimitiveType.DATETIMEV2);
    }

    public boolean hasTemplateType() {
        return false;
    }

    public boolean needExpandTemplateType() {
        return false;
    }

    public Type specializeTemplateType(Type specificType, Map<String, Type> specializedTypeMap, boolean useSpecializedType) throws TypeException {
        if (this.hasTemplateType()) {
            throw new TypeException("specializeTemplateType not implemented");
        }
        return this;
    }

    public void collectTemplateExpandSize(Type[] args, Map<String, Integer> expandSizeMap) throws TypeException {
    }

    public List<Type> expandVariadicTemplateType(Map<String, Integer> expandSizeMap) {
        return Lists.newArrayList((Object[])new Type[]{this});
    }

    public boolean isSupported() {
        return true;
    }

    public int getLength() {
        return -1;
    }

    public int getRawLength() {
        return -1;
    }

    public boolean supportsTablePartitioning() {
        return false;
    }

    public PrimitiveType getPrimitiveType() {
        return PrimitiveType.INVALID_TYPE;
    }

    public int getSlotSize() {
        if (this.isCollectionType()) {
            return 16;
        }
        throw new IllegalStateException("getSlotSize() not implemented for type " + this.toSql());
    }

    public TTypeDesc toThrift() {
        TTypeDesc container = new TTypeDesc();
        container.setTypes(new ArrayList<TTypeNode>());
        this.toThrift(container);
        return container;
    }

    public TColumnType toColumnTypeThrift() {
        return null;
    }

    public abstract void toThrift(TTypeDesc var1);

    public boolean matchesType(Type t) {
        return false;
    }

    public static boolean isImplicitlyCastable(Type t1, Type t2, boolean strict) {
        if (t1.isScalarType() && t2.isScalarType()) {
            return ScalarType.isImplicitlyCastable((ScalarType)t1, (ScalarType)t2, strict);
        }
        if (t1.isComplexType() || t2.isComplexType()) {
            if (t1.isArrayType() && t2.isArrayType() || t1.isMapType() && t2.isMapType() || t1.isStructType() && t2.isStructType()) {
                return t1.matchesType(t2);
            }
            return false;
        }
        return false;
    }

    public static boolean canCastTo(Type sourceType, Type targetType) {
        if (sourceType.isScalarType() && targetType.isScalarType()) {
            return ScalarType.canCastTo((ScalarType)sourceType, (ScalarType)targetType);
        }
        if (sourceType.isArrayType() && targetType.isArrayType()) {
            return ArrayType.canCastTo((ArrayType)sourceType, (ArrayType)targetType);
        }
        if (sourceType.isMapType() && targetType.isMapType()) {
            return MapType.canCastTo((MapType)sourceType, (MapType)targetType);
        }
        if (targetType.isArrayType() && !((ArrayType)targetType).getItemType().isScalarType() && !sourceType.isNull() && !sourceType.isStringType()) {
            return false;
        }
        if ((targetType.isStructType() || targetType.isMapType()) && sourceType.isStringType()) {
            return true;
        }
        if (sourceType.isStructType() && targetType.isStructType()) {
            return StructType.canCastTo((StructType)sourceType, (StructType)targetType);
        }
        return sourceType.isNull() || sourceType.getPrimitiveType().isCharFamily();
    }

    public static Type getAssignmentCompatibleType(Type t1, Type t2, boolean strict) {
        if (t1.isScalarType() && t2.isScalarType()) {
            return ScalarType.getAssignmentCompatibleType((ScalarType)t1, (ScalarType)t2, strict);
        }
        if (t1.isArrayType() && t2.isArrayType()) {
            return ArrayType.getAssignmentCompatibleType((ArrayType)t1, (ArrayType)t2, strict);
        }
        if (t1.isMapType() && t2.isMapType()) {
            return MapType.getAssignmentCompatibleType((MapType)t1, (MapType)t2, strict);
        }
        if (t1.isStructType() && t2.isStructType()) {
            return StructType.getAssignmentCompatibleType((StructType)t1, (StructType)t2, strict);
        }
        if (t1.isComplexType() && t2.isNull()) {
            return t1;
        }
        if (t1.isNull() && t2.isComplexType()) {
            return t2;
        }
        return ScalarType.INVALID;
    }

    public static Type getNextNumType(Type t) {
        switch (t.getPrimitiveType()) {
            case BOOLEAN: {
                return TINYINT;
            }
            case TINYINT: {
                return SMALLINT;
            }
            case SMALLINT: {
                return INT;
            }
            case INT: {
                return BIGINT;
            }
            case BIGINT: {
                return BIGINT;
            }
            case LARGEINT: {
                return LARGEINT;
            }
            case FLOAT: {
                return DOUBLE;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case DECIMALV2: {
                return MAX_DECIMALV2_TYPE;
            }
            case DECIMAL32: {
                return DECIMAL32;
            }
            case DECIMAL64: {
                return DECIMAL64;
            }
            case DECIMAL128: {
                return DECIMAL128;
            }
        }
        return INVALID;
    }

    public boolean exceedsMaxNestingDepth() {
        return this.exceedsMaxNestingDepth(0);
    }

    private boolean exceedsMaxNestingDepth(int d) {
        if (d > MAX_NESTING_DEPTH) {
            return true;
        }
        if (this.isStructType()) {
            StructType structType = (StructType)this;
            for (StructField f : structType.getFields()) {
                if (!f.getType().exceedsMaxNestingDepth(d + 1)) continue;
                return true;
            }
        } else {
            if (this.isArrayType()) {
                ArrayType arrayType = (ArrayType)this;
                Type itemType = arrayType.getItemType();
                return itemType.exceedsMaxNestingDepth(d + 1);
            }
            if (this.isMultiRowType()) {
                MultiRowType multiRowType = (MultiRowType)this;
                return multiRowType.getItemType().exceedsMaxNestingDepth(d + 1);
            }
            if (this.isMapType()) {
                MapType mapType = (MapType)this;
                return mapType.getValueType().exceedsMaxNestingDepth(d + 1);
            }
            Preconditions.checkState((boolean)this.isScalarType());
        }
        return false;
    }

    public static Type fromPrimitiveType(PrimitiveType type) {
        switch (type) {
            case BOOLEAN: {
                return BOOLEAN;
            }
            case TINYINT: {
                return TINYINT;
            }
            case SMALLINT: {
                return SMALLINT;
            }
            case INT: {
                return INT;
            }
            case BIGINT: {
                return BIGINT;
            }
            case LARGEINT: {
                return LARGEINT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case DATE: {
                return DATE;
            }
            case DATETIME: {
                return DATETIME;
            }
            case TIME: {
                return TIME;
            }
            case DATEV2: {
                return DATEV2;
            }
            case DATETIMEV2: {
                return DATETIMEV2;
            }
            case TIMEV2: {
                return TIMEV2;
            }
            case DECIMALV2: {
                return DECIMALV2;
            }
            case DECIMAL32: {
                return DECIMAL32;
            }
            case DECIMAL64: {
                return DECIMAL64;
            }
            case DECIMAL128: {
                return DECIMAL128;
            }
            case CHAR: {
                return CHAR;
            }
            case VARCHAR: {
                return VARCHAR;
            }
            case JSONB: {
                return JSONB;
            }
            case STRING: {
                return STRING;
            }
            case HLL: {
                return HLL;
            }
            case ARRAY: {
                return ArrayType.create();
            }
            case MAP: {
                return new MapType();
            }
            case STRUCT: {
                return new StructType();
            }
            case BITMAP: {
                return BITMAP;
            }
            case QUANTILE_STATE: {
                return QUANTILE_STATE;
            }
            case VARIANT: {
                return new VariantType();
            }
            case LAMBDA_FUNCTION: {
                return LAMBDA_FUNCTION;
            }
            case AGG_STATE: {
                return AGG_STATE;
            }
        }
        return null;
    }

    public static List<TTypeDesc> toThrift(Type[] types) {
        return Type.toThrift(Lists.newArrayList((Object[])types));
    }

    public static List<TTypeDesc> toThrift(ArrayList<Type> types) {
        ArrayList result = Lists.newArrayList();
        for (Type t : types) {
            result.add(t.toThrift());
        }
        return result;
    }

    public static List<TTypeDesc> toThrift(ArrayList<Type> types, ArrayList<Type> realTypes) {
        ArrayList result = Lists.newArrayList();
        for (int i = 0; i < types.size(); ++i) {
            if (PrimitiveType.typeWithPrecision.contains((Object)realTypes.get(i).getPrimitiveType())) {
                result.add(realTypes.get(i).toThrift());
                continue;
            }
            result.add(types.get(i).toThrift());
        }
        return result;
    }

    public static Type fromThrift(TTypeDesc thrift) {
        Preconditions.checkState((thrift.types.size() > 0 ? 1 : 0) != 0);
        Pair<Type, Integer> t = Type.fromThrift(thrift, 0);
        Preconditions.checkState((boolean)((Integer)t.second).equals(thrift.getTypesSize()));
        return (Type)t.first;
    }

    protected static Pair<Type, Integer> fromThrift(TTypeDesc col, int nodeIdx) {
        TTypeNode node = col.getTypes().get(nodeIdx);
        Type type = null;
        int tmpNodeIdx = nodeIdx;
        switch (node.getType()) {
            case SCALAR: {
                Preconditions.checkState((boolean)node.isSetScalarType());
                TScalarType scalarType = node.getScalarType();
                if (scalarType.getType() == TPrimitiveType.CHAR) {
                    Preconditions.checkState((boolean)scalarType.isSetLen());
                    type = ScalarType.createCharType(scalarType.getLen());
                } else if (scalarType.getType() == TPrimitiveType.VARCHAR) {
                    Preconditions.checkState((boolean)scalarType.isSetLen());
                    type = ScalarType.createVarcharType(scalarType.getLen());
                } else if (scalarType.getType() == TPrimitiveType.HLL) {
                    type = ScalarType.createHllType();
                } else if (scalarType.getType() == TPrimitiveType.DECIMALV2) {
                    Preconditions.checkState((scalarType.isSetPrecision() && scalarType.isSetPrecision() ? 1 : 0) != 0);
                    type = ScalarType.createDecimalType(scalarType.getPrecision(), scalarType.getScale());
                } else if (scalarType.getType() == TPrimitiveType.DECIMAL32 || scalarType.getType() == TPrimitiveType.DECIMAL64 || scalarType.getType() == TPrimitiveType.DECIMAL128I) {
                    Preconditions.checkState((scalarType.isSetPrecision() && scalarType.isSetScale() ? 1 : 0) != 0);
                    type = ScalarType.createDecimalV3Type(scalarType.getPrecision(), scalarType.getScale());
                } else if (scalarType.getType() == TPrimitiveType.DATETIMEV2) {
                    Preconditions.checkState((scalarType.isSetPrecision() && scalarType.isSetScale() ? 1 : 0) != 0);
                    type = ScalarType.createDatetimeV2Type(scalarType.getScale());
                } else if (scalarType.getType() == TPrimitiveType.TIMEV2) {
                    Preconditions.checkState((scalarType.isSetPrecision() && scalarType.isSetScale() ? 1 : 0) != 0);
                    type = ScalarType.createTimeV2Type(scalarType.getScale());
                } else {
                    type = ScalarType.createType(PrimitiveType.fromThrift(scalarType.getType()));
                }
                ++tmpNodeIdx;
                break;
            }
            case ARRAY: {
                Preconditions.checkState((tmpNodeIdx + 1 < col.getTypesSize() ? 1 : 0) != 0);
                Pair<Type, Integer> childType = Type.fromThrift(col, tmpNodeIdx + 1);
                type = new ArrayType((Type)childType.first);
                tmpNodeIdx = (Integer)childType.second;
                break;
            }
            case MAP: {
                Preconditions.checkState((tmpNodeIdx + 2 < col.getTypesSize() ? 1 : 0) != 0);
                Pair<Type, Integer> keyType = Type.fromThrift(col, tmpNodeIdx + 1);
                Pair<Type, Integer> valueType = Type.fromThrift(col, (Integer)keyType.second);
                type = new MapType((Type)keyType.first, (Type)valueType.first);
                tmpNodeIdx = (Integer)valueType.second;
                break;
            }
            case STRUCT: {
                Preconditions.checkState((tmpNodeIdx + node.getStructFieldsSize() < col.getTypesSize() ? 1 : 0) != 0);
                ArrayList structFields = Lists.newArrayList();
                ++tmpNodeIdx;
                for (int i = 0; i < node.getStructFieldsSize(); ++i) {
                    TStructField thriftField = node.getStructFields().get(i);
                    String name = thriftField.getName();
                    String comment = null;
                    if (thriftField.isSetComment()) {
                        comment = thriftField.getComment();
                    }
                    Pair<Type, Integer> res = Type.fromThrift(col, tmpNodeIdx);
                    tmpNodeIdx = (Integer)res.second;
                    structFields.add(new StructField(name, (Type)res.first, comment, true));
                }
                type = new StructType(structFields);
                break;
            }
        }
        return Pair.of(type, tmpNodeIdx);
    }

    public TPrimitiveType getTPrimitiveType(TTypeDesc ttype) {
        Preconditions.checkState((ttype.getTypesSize() == 1 ? 1 : 0) != 0);
        Preconditions.checkState((ttype.types.get(0).getType() == TTypeNodeType.SCALAR ? 1 : 0) != 0);
        return ttype.types.get((int)0).scalar_type.getType();
    }

    public Integer getColumnSize() {
        if (!this.isScalarType()) {
            return null;
        }
        if (this.isNumericType()) {
            return this.getPrecision();
        }
        ScalarType t = (ScalarType)this;
        switch (t.getPrimitiveType()) {
            case CHAR: 
            case VARCHAR: 
            case STRING: 
            case HLL: {
                return t.getLength();
            }
        }
        return null;
    }

    public int getColumnStringRepSize() throws TypeException {
        if (this.isScalarType(PrimitiveType.FLOAT)) {
            return 24;
        }
        if (this.isScalarType(PrimitiveType.DOUBLE)) {
            return 32;
        }
        if (this.isNumericType()) {
            int size = this.getPrecision() + 1;
            if (this.isScalarType(PrimitiveType.DECIMALV2) || this.isDecimalV3()) {
                ++size;
            }
            return size;
        }
        ScalarType t = (ScalarType)this;
        switch (t.getPrimitiveType()) {
            case CHAR: 
            case VARCHAR: {
                return t.getLength();
            }
            case STRING: {
                return Integer.MAX_VALUE;
            }
        }
        throw new TypeException("Can not change " + (Object)((Object)t.getPrimitiveType()) + " to char/varchar/string");
    }

    public Integer getPrecision() {
        if (!this.isScalarType()) {
            return null;
        }
        ScalarType t = (ScalarType)this;
        switch (t.getPrimitiveType()) {
            case TINYINT: {
                return 3;
            }
            case SMALLINT: {
                return 5;
            }
            case INT: {
                return 10;
            }
            case BIGINT: {
                return 19;
            }
            case LARGEINT: {
                return 39;
            }
            case FLOAT: {
                return 7;
            }
            case DOUBLE: {
                return 15;
            }
            case DECIMALV2: 
            case DECIMAL32: 
            case DECIMAL64: 
            case DECIMAL128: 
            case DATETIMEV2: 
            case TIMEV2: {
                return t.decimalPrecision();
            }
        }
        return null;
    }

    public Integer getDecimalDigits() {
        if (!this.isScalarType()) {
            return null;
        }
        ScalarType t = (ScalarType)this;
        switch (t.getPrimitiveType()) {
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: {
                return 0;
            }
            case FLOAT: {
                return 7;
            }
            case DOUBLE: {
                return 15;
            }
            case DECIMALV2: 
            case DECIMAL32: 
            case DECIMAL64: 
            case DECIMAL128: 
            case DATETIMEV2: 
            case TIMEV2: {
                return t.decimalScale();
            }
        }
        return null;
    }

    public Integer getNumPrecRadix() {
        if (!this.isScalarType()) {
            return null;
        }
        ScalarType t = (ScalarType)this;
        switch (t.getPrimitiveType()) {
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case DECIMALV2: 
            case DECIMAL32: 
            case DECIMAL64: 
            case DECIMAL128: {
                return 10;
            }
        }
        return null;
    }

    public Type getResultType() {
        switch (this.getPrimitiveType()) {
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: {
                return BIGINT;
            }
            case LARGEINT: {
                return LARGEINT;
            }
            case FLOAT: 
            case DOUBLE: {
                return DOUBLE;
            }
            case DATE: 
            case DATETIME: 
            case TIME: 
            case DATEV2: 
            case DATETIMEV2: 
            case TIMEV2: 
            case CHAR: 
            case VARCHAR: 
            case HLL: 
            case BITMAP: 
            case QUANTILE_STATE: {
                return VARCHAR;
            }
            case DECIMALV2: {
                return DECIMALV2;
            }
            case DECIMAL32: {
                return DECIMAL32;
            }
            case DECIMAL64: {
                return DECIMAL64;
            }
            case DECIMAL128: {
                return DECIMAL128;
            }
            case STRING: {
                return STRING;
            }
            case JSONB: {
                return JSONB;
            }
        }
        return INVALID;
    }

    public static Type getCmpType(Type t1, Type t2) {
        if (t1.getPrimitiveType() == PrimitiveType.NULL_TYPE) {
            return t2;
        }
        if (t2.getPrimitiveType() == PrimitiveType.NULL_TYPE) {
            return t1;
        }
        PrimitiveType t1ResultType = t1.getResultType().getPrimitiveType();
        PrimitiveType t2ResultType = t2.getResultType().getPrimitiveType();
        if (Type.canCompareDate(t1.getPrimitiveType(), t2.getPrimitiveType())) {
            return Type.getDateComparisonResultType((ScalarType)t1, (ScalarType)t2);
        }
        if (t1ResultType == PrimitiveType.VARCHAR && t2ResultType == PrimitiveType.VARCHAR) {
            return VARCHAR;
        }
        if (t1ResultType == PrimitiveType.STRING && t2ResultType == PrimitiveType.STRING || t1ResultType == PrimitiveType.STRING && t2ResultType == PrimitiveType.VARCHAR || t1ResultType == PrimitiveType.VARCHAR && t2ResultType == PrimitiveType.STRING) {
            return STRING;
        }
        if (t1ResultType == PrimitiveType.JSONB && t2ResultType == PrimitiveType.JSONB) {
            return JSONB;
        }
        if (t1ResultType == PrimitiveType.JSONB && t2ResultType == PrimitiveType.VARCHAR || t1ResultType == PrimitiveType.VARCHAR && t2ResultType == PrimitiveType.JSONB) {
            return VARCHAR;
        }
        if (t1ResultType == PrimitiveType.JSONB && t2ResultType == PrimitiveType.STRING || t1ResultType == PrimitiveType.STRING && t2ResultType == PrimitiveType.JSONB) {
            return STRING;
        }
        if (t1.getPrimitiveType().isFixedPointType() && t2.getPrimitiveType().isCharFamily() || t2.getPrimitiveType().isFixedPointType() && t1.getPrimitiveType().isCharFamily()) {
            return VARCHAR;
        }
        if (t1ResultType == PrimitiveType.BIGINT && t2ResultType == PrimitiveType.BIGINT) {
            return Type.getAssignmentCompatibleType(t1, t2, false);
        }
        if (t1.getPrimitiveType().isDecimalV3Type() && t2.getPrimitiveType().isDecimalV3Type()) {
            int resultPrecision = Math.max(t1.getPrecision(), t2.getPrecision());
            PrimitiveType resultDecimalType = resultPrecision <= 9 ? PrimitiveType.DECIMAL32 : (resultPrecision <= 18 ? PrimitiveType.DECIMAL64 : PrimitiveType.DECIMAL128);
            if (resultPrecision <= 38) {
                return ScalarType.createDecimalType(resultDecimalType, resultPrecision, Math.max(((ScalarType)t1).getScalarScale(), ((ScalarType)t2).getScalarScale()));
            }
            return DOUBLE;
        }
        if (t1ResultType.isDecimalV3Type() || t2ResultType.isDecimalV3Type()) {
            return Type.getAssignmentCompatibleType(t1, t2, false);
        }
        if (!(t1ResultType != PrimitiveType.BIGINT && t1ResultType != PrimitiveType.DECIMALV2 || t2ResultType != PrimitiveType.BIGINT && t2ResultType != PrimitiveType.DECIMALV2)) {
            return DECIMALV2;
        }
        if (!(t1ResultType != PrimitiveType.BIGINT && t1ResultType != PrimitiveType.LARGEINT || t2ResultType != PrimitiveType.BIGINT && t2ResultType != PrimitiveType.LARGEINT)) {
            return LARGEINT;
        }
        return DOUBLE;
    }

    private static boolean canCompareDate(PrimitiveType t1, PrimitiveType t2) {
        if (t1.isDateType()) {
            return t2.isDateType() || t2.isStringType() || t2.isIntegerType();
        }
        if (t2.isDateType()) {
            return t1.isStringType() || t1.isIntegerType();
        }
        return false;
    }

    private static Type getDateComparisonResultType(ScalarType t1, ScalarType t2) {
        if (t1.isDate() && t2.isDate()) {
            return DATE;
        }
        if (t1.isDateV2() && t2.isDate() || t1.isDate() && t2.isDateV2()) {
            return DATEV2;
        }
        if (t1.isDateV2() && t2.isDateV2()) {
            return DATEV2;
        }
        if (t1.isDatetime() && t2.isDatetime()) {
            return DATETIME;
        }
        if (t1.isDatetime() && t2.isDatetimeV2()) {
            return t2;
        }
        if (t1.isDatetimeV2() && t2.isDatetime()) {
            return t1;
        }
        if (t1.isDatetimeV2() && t2.isDatetimeV2()) {
            return t1.decimalScale() > t2.decimalScale() ? t1 : t2;
        }
        if (t1.isDatetimeV2()) {
            return t1;
        }
        if (t2.isDatetimeV2()) {
            return t2;
        }
        if (t2.isDateV2() || t1.isDateV2()) {
            return DATETIMEV2;
        }
        return DATETIME;
    }

    public Type getMaxResolutionType() {
        Preconditions.checkState((boolean)true, (Object)"must implemented");
        return null;
    }

    public Type getNumResultType() {
        switch (this.getPrimitiveType()) {
            case BOOLEAN: 
            case TINYINT: 
            case SMALLINT: 
            case INT: 
            case BIGINT: 
            case DATE: 
            case DATETIME: 
            case DATEV2: 
            case DATETIMEV2: {
                return BIGINT;
            }
            case LARGEINT: {
                return LARGEINT;
            }
            case FLOAT: 
            case DOUBLE: 
            case TIME: 
            case TIMEV2: 
            case CHAR: 
            case VARCHAR: 
            case STRING: 
            case HLL: {
                return DOUBLE;
            }
            case DECIMALV2: {
                return DECIMALV2;
            }
            case DECIMAL32: {
                return DECIMAL32;
            }
            case DECIMAL64: {
                return DECIMAL64;
            }
            case DECIMAL128: {
                return DECIMAL128;
            }
        }
        return INVALID;
    }

    public int getIndexSize() {
        if (this.getPrimitiveType() == PrimitiveType.CHAR) {
            return this.getLength();
        }
        return this.getPrimitiveType().getOlapColumnIndexSize();
    }

    public static boolean matchExactType(Type type1, Type type2) {
        return Type.matchExactType(type1, type2, false);
    }

    public static boolean matchExactType(Type type1, Type type2, boolean ignorePrecision) {
        if (type1.matchesType(type2)) {
            if (PrimitiveType.typeWithPrecision.contains((Object)type2.getPrimitiveType())) {
                if (((ScalarType)type2).decimalPrecision() == ((ScalarType)type1).decimalPrecision() && ((ScalarType)type2).decimalScale() == ((ScalarType)type1).decimalScale()) {
                    return true;
                }
                if (((ScalarType)type2).decimalScale() == ((ScalarType)type1).decimalScale() && ignorePrecision) {
                    return Type.isSameDecimalTypeWithDifferentPrecision(((ScalarType)type2).decimalPrecision(), ((ScalarType)type1).decimalPrecision());
                }
            } else {
                if (type2.isArrayType()) {
                    if (((ArrayType)type2).getContainsNull() != ((ArrayType)type1).getContainsNull()) {
                        return false;
                    }
                    return Type.matchExactType(((ArrayType)type2).getItemType(), ((ArrayType)type1).getItemType());
                }
                if (type2.isMapType()) {
                    if (((MapType)type2).getIsKeyContainsNull() != ((MapType)type1).getIsKeyContainsNull()) {
                        return false;
                    }
                    if (((MapType)type2).getIsValueContainsNull() != ((MapType)type1).getIsValueContainsNull()) {
                        return false;
                    }
                    return Type.matchExactType(((MapType)type2).getKeyType(), ((MapType)type1).getKeyType()) && Type.matchExactType(((MapType)type2).getValueType(), ((MapType)type1).getValueType());
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isSameDecimalTypeWithDifferentPrecision(int precision1, int precision2) {
        if (precision1 <= 9 && precision2 <= 9) {
            return true;
        }
        if (precision1 > 9 && precision2 > 9 && precision1 <= 18 && precision2 <= 18) {
            return true;
        }
        return precision1 > 18 && precision2 > 18 && precision1 <= 38 && precision2 <= 38;
    }

    static {
        int i;
        MAX_NESTING_DEPTH = 9;
        INVALID = new ScalarType(PrimitiveType.INVALID_TYPE);
        UNSUPPORTED = new ScalarType(PrimitiveType.UNSUPPORTED);
        NULL = new ScalarType(PrimitiveType.NULL_TYPE);
        BOOLEAN = new ScalarType(PrimitiveType.BOOLEAN);
        TINYINT = new ScalarType(PrimitiveType.TINYINT);
        SMALLINT = new ScalarType(PrimitiveType.SMALLINT);
        INT = new ScalarType(PrimitiveType.INT);
        BIGINT = new ScalarType(PrimitiveType.BIGINT);
        LARGEINT = new ScalarType(PrimitiveType.LARGEINT);
        FLOAT = new ScalarType(PrimitiveType.FLOAT);
        DOUBLE = new ScalarType(PrimitiveType.DOUBLE);
        DATE = new ScalarType(PrimitiveType.DATE);
        DATETIME = new ScalarType(PrimitiveType.DATETIME);
        DATEV2 = new ScalarType(PrimitiveType.DATEV2);
        TIMEV2 = new ScalarType(PrimitiveType.TIMEV2);
        TIME = new ScalarType(PrimitiveType.TIME);
        STRING = ScalarType.createStringType();
        DEFAULT_DECIMALV2 = ScalarType.createDecimalType(PrimitiveType.DECIMALV2, 9, 0);
        MAX_DECIMALV2_TYPE = ScalarType.createDecimalType(PrimitiveType.DECIMALV2, 27, 9);
        DEFAULT_DECIMAL32 = ScalarType.createDecimalType(PrimitiveType.DECIMAL32, 9, 0);
        DEFAULT_DECIMAL64 = ScalarType.createDecimalType(PrimitiveType.DECIMAL64, 18, 0);
        DEFAULT_DECIMAL128 = ScalarType.createDecimalType(PrimitiveType.DECIMAL128, 38, 0);
        DEFAULT_DECIMALV3 = DEFAULT_DECIMAL32;
        DATETIMEV2 = DEFAULT_DATETIMEV2 = ScalarType.createDatetimeV2Type(0);
        DATETIMEV2_WITH_MAX_SCALAR = ScalarType.createDatetimeV2Type(6);
        DEFAULT_TIMEV2 = ScalarType.createTimeV2Type(0);
        DECIMALV2 = DEFAULT_DECIMALV2;
        DECIMAL32 = DEFAULT_DECIMAL32;
        DECIMAL64 = DEFAULT_DECIMAL64;
        DECIMAL128 = DEFAULT_DECIMAL128;
        JSONB = new ScalarType(PrimitiveType.JSONB);
        DEFAULT_VARCHAR = ScalarType.createVarcharType(-1);
        VARCHAR = ScalarType.createVarcharType(-1);
        HLL = ScalarType.createHllType();
        CHAR = ScalarType.createCharType(-1);
        BITMAP = new ScalarType(PrimitiveType.BITMAP);
        QUANTILE_STATE = new ScalarType(PrimitiveType.QUANTILE_STATE);
        AGG_STATE = new AggStateType(null, null, null, null);
        LAMBDA_FUNCTION = new ScalarType(PrimitiveType.LAMBDA_FUNCTION);
        ALL = new ScalarType(PrimitiveType.ALL);
        MAP = new MapType();
        ARRAY = ArrayType.create();
        GENERIC_STRUCT = new StructType(Lists.newArrayList((Object[])new StructField[]{new StructField("generic_struct", new ScalarType(PrimitiveType.NULL_TYPE))}));
        STRUCT = new StructType();
        VARIANT = new VariantType();
        ANY_STRUCT_TYPE = new AnyStructType();
        ANY_ELEMENT_TYPE = new AnyElementType();
        LOG = LogManager.getLogger(Type.class);
        integerTypes = Lists.newArrayList();
        integerTypes.add(TINYINT);
        integerTypes.add(SMALLINT);
        integerTypes.add(INT);
        integerTypes.add(BIGINT);
        integerTypes.add(LARGEINT);
        stringTypes = Lists.newArrayList();
        stringTypes.add(CHAR);
        stringTypes.add(VARCHAR);
        stringTypes.add(STRING);
        numericTypes = Lists.newArrayList();
        numericTypes.addAll(integerTypes);
        numericTypes.add(FLOAT);
        numericTypes.add(DOUBLE);
        numericTypes.add(MAX_DECIMALV2_TYPE);
        numericTypes.add(DECIMAL32);
        numericTypes.add(DECIMAL64);
        numericTypes.add(DECIMAL128);
        numericDateTimeTypes = Lists.newArrayList();
        numericDateTimeTypes.add(DATE);
        numericDateTimeTypes.add(DATETIME);
        numericDateTimeTypes.add(DATEV2);
        numericDateTimeTypes.add(DATETIMEV2);
        numericDateTimeTypes.add(TIME);
        numericDateTimeTypes.add(TIMEV2);
        numericDateTimeTypes.addAll(numericTypes);
        trivialTypes = Lists.newArrayList();
        trivialTypes.addAll(numericTypes);
        trivialTypes.add(BOOLEAN);
        trivialTypes.add(VARCHAR);
        trivialTypes.add(STRING);
        trivialTypes.add(CHAR);
        trivialTypes.add(DATE);
        trivialTypes.add(DATETIME);
        trivialTypes.add(DATEV2);
        trivialTypes.add(DATETIMEV2);
        trivialTypes.add(TIME);
        trivialTypes.add(TIMEV2);
        trivialTypes.add(JSONB);
        supportedTypes = Lists.newArrayList();
        supportedTypes.addAll(trivialTypes);
        supportedTypes.add(NULL);
        supportedTypes.add(HLL);
        supportedTypes.add(BITMAP);
        supportedTypes.add(QUANTILE_STATE);
        supportedTypes.add(AGG_STATE);
        arraySubTypes = Lists.newArrayList();
        arraySubTypes.add(BOOLEAN);
        arraySubTypes.addAll(integerTypes);
        arraySubTypes.add(FLOAT);
        arraySubTypes.add(DOUBLE);
        arraySubTypes.add(DECIMALV2);
        arraySubTypes.add(DATE);
        arraySubTypes.add(DATETIME);
        arraySubTypes.add(DATEV2);
        arraySubTypes.add(DATETIMEV2);
        arraySubTypes.add(CHAR);
        arraySubTypes.add(VARCHAR);
        arraySubTypes.add(STRING);
        arraySubTypes.add(DECIMAL32);
        arraySubTypes.add(DECIMAL64);
        arraySubTypes.add(DECIMAL128);
        mapSubTypes = Lists.newArrayList();
        mapSubTypes.add(BOOLEAN);
        mapSubTypes.addAll(integerTypes);
        mapSubTypes.add(FLOAT);
        mapSubTypes.add(DOUBLE);
        mapSubTypes.add(DECIMALV2);
        mapSubTypes.add(DECIMAL32);
        mapSubTypes.add(DECIMAL64);
        mapSubTypes.add(DECIMAL128);
        mapSubTypes.add(DATE);
        mapSubTypes.add(DATETIME);
        mapSubTypes.add(DATEV2);
        mapSubTypes.add(DATETIMEV2);
        mapSubTypes.add(CHAR);
        mapSubTypes.add(VARCHAR);
        mapSubTypes.add(STRING);
        mapSubTypes.add(NULL);
        structSubTypes = Lists.newArrayList();
        structSubTypes.add(BOOLEAN);
        structSubTypes.addAll(integerTypes);
        structSubTypes.add(FLOAT);
        structSubTypes.add(DOUBLE);
        structSubTypes.add(DECIMALV2);
        structSubTypes.add(DECIMAL32);
        structSubTypes.add(DECIMAL64);
        structSubTypes.add(DECIMAL128);
        structSubTypes.add(DATE);
        structSubTypes.add(DATETIME);
        structSubTypes.add(DATEV2);
        structSubTypes.add(DATETIMEV2);
        structSubTypes.add(CHAR);
        structSubTypes.add(VARCHAR);
        structSubTypes.add(STRING);
        DATE_SUPPORTED_JAVA_TYPE = Sets.newHashSet((Object[])new Class[]{LocalDate.class, Date.class, org.joda.time.LocalDate.class});
        DATETIME_SUPPORTED_JAVA_TYPE = Sets.newHashSet((Object[])new Class[]{LocalDateTime.class, DateTime.class, org.joda.time.LocalDateTime.class});
        PrimitiveTypeToJavaClassType = new ImmutableMap.Builder().put((Object)PrimitiveType.BOOLEAN, (Object)Sets.newHashSet((Object[])new Class[]{Boolean.class, Boolean.TYPE})).put((Object)PrimitiveType.TINYINT, (Object)Sets.newHashSet((Object[])new Class[]{Byte.class, Byte.TYPE})).put((Object)PrimitiveType.SMALLINT, (Object)Sets.newHashSet((Object[])new Class[]{Short.class, Short.TYPE})).put((Object)PrimitiveType.INT, (Object)Sets.newHashSet((Object[])new Class[]{Integer.class, Integer.TYPE})).put((Object)PrimitiveType.FLOAT, (Object)Sets.newHashSet((Object[])new Class[]{Float.class, Float.TYPE})).put((Object)PrimitiveType.DOUBLE, (Object)Sets.newHashSet((Object[])new Class[]{Double.class, Double.TYPE})).put((Object)PrimitiveType.BIGINT, (Object)Sets.newHashSet((Object[])new Class[]{Long.class, Long.TYPE})).put((Object)PrimitiveType.CHAR, (Object)Sets.newHashSet((Object[])new Class[]{String.class})).put((Object)PrimitiveType.VARCHAR, (Object)Sets.newHashSet((Object[])new Class[]{String.class})).put((Object)PrimitiveType.STRING, (Object)Sets.newHashSet((Object[])new Class[]{String.class})).put((Object)PrimitiveType.DATE, DATE_SUPPORTED_JAVA_TYPE).put((Object)PrimitiveType.DATEV2, DATE_SUPPORTED_JAVA_TYPE).put((Object)PrimitiveType.DATETIME, DATETIME_SUPPORTED_JAVA_TYPE).put((Object)PrimitiveType.DATETIMEV2, DATETIME_SUPPORTED_JAVA_TYPE).put((Object)PrimitiveType.LARGEINT, (Object)Sets.newHashSet((Object[])new Class[]{BigInteger.class})).put((Object)PrimitiveType.DECIMALV2, (Object)Sets.newHashSet((Object[])new Class[]{BigDecimal.class})).put((Object)PrimitiveType.DECIMAL32, (Object)Sets.newHashSet((Object[])new Class[]{BigDecimal.class})).put((Object)PrimitiveType.DECIMAL64, (Object)Sets.newHashSet((Object[])new Class[]{BigDecimal.class})).put((Object)PrimitiveType.DECIMAL128, (Object)Sets.newHashSet((Object[])new Class[]{BigDecimal.class})).put((Object)PrimitiveType.ARRAY, (Object)Sets.newHashSet((Object[])new Class[]{ArrayList.class})).put((Object)PrimitiveType.MAP, (Object)Sets.newHashSet((Object[])new Class[]{HashMap.class})).build();
        compatibilityMatrix = new PrimitiveType[PrimitiveType.values().length][PrimitiveType.values().length];
        strictCompatibilityMatrix = new PrimitiveType[PrimitiveType.values().length][PrimitiveType.values().length];
        for (i = 0; i < PrimitiveType.values().length; ++i) {
            Type.compatibilityMatrix[i][i] = PrimitiveType.values()[i];
        }
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.TINYINT.ordinal()] = PrimitiveType.TINYINT;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.SMALLINT.ordinal()] = PrimitiveType.SMALLINT;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.INT.ordinal()] = PrimitiveType.INT;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.BIGINT.ordinal()] = PrimitiveType.BIGINT;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.LARGEINT.ordinal()] = PrimitiveType.LARGEINT;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.FLOAT.ordinal()] = PrimitiveType.FLOAT;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.DOUBLE.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.DATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.DATETIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.DATEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.DATETIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.TIMEV2.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.CHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.VARCHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.TIME.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.JSONB.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.QUANTILE_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.DECIMAL32.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.DECIMAL64.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.DECIMAL128.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BOOLEAN.ordinal()][Type.AGG_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.SMALLINT.ordinal()] = PrimitiveType.SMALLINT;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.INT.ordinal()] = PrimitiveType.INT;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.BIGINT.ordinal()] = PrimitiveType.BIGINT;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.LARGEINT.ordinal()] = PrimitiveType.LARGEINT;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.FLOAT.ordinal()] = PrimitiveType.FLOAT;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.DOUBLE.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.DATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.DATETIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.DATEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.DATETIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.TIMEV2.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.CHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.VARCHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.DECIMALV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.DECIMAL32.ordinal()] = PrimitiveType.DECIMAL32;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.DECIMAL64.ordinal()] = PrimitiveType.DECIMAL64;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.DECIMAL128.ordinal()] = PrimitiveType.DECIMAL128;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.TIME.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.JSONB.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.QUANTILE_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TINYINT.ordinal()][Type.AGG_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.INT.ordinal()] = PrimitiveType.INT;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.BIGINT.ordinal()] = PrimitiveType.BIGINT;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.LARGEINT.ordinal()] = PrimitiveType.LARGEINT;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.FLOAT.ordinal()] = PrimitiveType.FLOAT;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.DOUBLE.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.DATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.DATETIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.DATEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.DATETIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.TIMEV2.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.CHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.VARCHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.DECIMALV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.DECIMAL32.ordinal()] = PrimitiveType.DECIMAL32;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.DECIMAL64.ordinal()] = PrimitiveType.DECIMAL64;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.DECIMAL128.ordinal()] = PrimitiveType.DECIMAL128;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.TIME.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.JSONB.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.QUANTILE_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.SMALLINT.ordinal()][Type.AGG_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.BIGINT.ordinal()] = PrimitiveType.BIGINT;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.LARGEINT.ordinal()] = PrimitiveType.LARGEINT;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.FLOAT.ordinal()] = PrimitiveType.FLOAT;
        Type.strictCompatibilityMatrix[Type.INT.ordinal()][Type.FLOAT.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.DOUBLE.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.DATE.ordinal()] = PrimitiveType.INT;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.DATETIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.DATEV2.ordinal()] = PrimitiveType.INT;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.DATETIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.TIMEV2.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.CHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.VARCHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.DECIMALV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.DECIMAL32.ordinal()] = PrimitiveType.DECIMAL32;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.DECIMAL64.ordinal()] = PrimitiveType.DECIMAL64;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.DECIMAL128.ordinal()] = PrimitiveType.DECIMAL128;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.TIME.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.JSONB.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.QUANTILE_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.INT.ordinal()][Type.AGG_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.LARGEINT.ordinal()] = PrimitiveType.LARGEINT;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.FLOAT.ordinal()] = PrimitiveType.FLOAT;
        Type.strictCompatibilityMatrix[Type.BIGINT.ordinal()][Type.FLOAT.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.DOUBLE.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.DATE.ordinal()] = PrimitiveType.BIGINT;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.DATETIME.ordinal()] = PrimitiveType.BIGINT;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.DATEV2.ordinal()] = PrimitiveType.BIGINT;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.DATETIMEV2.ordinal()] = PrimitiveType.BIGINT;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.TIMEV2.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.CHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.VARCHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.DECIMALV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.DECIMAL32.ordinal()] = PrimitiveType.DECIMAL64;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.DECIMAL64.ordinal()] = PrimitiveType.DECIMAL64;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.DECIMAL128.ordinal()] = PrimitiveType.DECIMAL128;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.TIME.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.JSONB.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.QUANTILE_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BIGINT.ordinal()][Type.AGG_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.FLOAT.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.DOUBLE.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.DATE.ordinal()] = PrimitiveType.LARGEINT;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.DATETIME.ordinal()] = PrimitiveType.LARGEINT;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.DATEV2.ordinal()] = PrimitiveType.LARGEINT;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.DATETIMEV2.ordinal()] = PrimitiveType.LARGEINT;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.TIMEV2.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.CHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.VARCHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.DECIMALV2.ordinal()] = PrimitiveType.DECIMALV2;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.DECIMAL32.ordinal()] = PrimitiveType.DECIMAL128;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.DECIMAL64.ordinal()] = PrimitiveType.DECIMAL128;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.DECIMAL128.ordinal()] = PrimitiveType.DECIMAL128;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.TIME.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.JSONB.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.QUANTILE_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.LARGEINT.ordinal()][Type.AGG_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.FLOAT.ordinal()][Type.DOUBLE.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.FLOAT.ordinal()][Type.DATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.FLOAT.ordinal()][Type.DATETIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.FLOAT.ordinal()][Type.DATEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.FLOAT.ordinal()][Type.DATETIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.FLOAT.ordinal()][Type.TIMEV2.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.FLOAT.ordinal()][Type.CHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.FLOAT.ordinal()][Type.VARCHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.FLOAT.ordinal()][Type.DECIMALV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.FLOAT.ordinal()][Type.DECIMAL32.ordinal()] = PrimitiveType.DECIMAL128;
        Type.compatibilityMatrix[Type.FLOAT.ordinal()][Type.DECIMAL64.ordinal()] = PrimitiveType.DECIMAL128;
        Type.compatibilityMatrix[Type.FLOAT.ordinal()][Type.DECIMAL128.ordinal()] = PrimitiveType.DECIMAL128;
        Type.compatibilityMatrix[Type.FLOAT.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.FLOAT.ordinal()][Type.TIME.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.FLOAT.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.FLOAT.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.FLOAT.ordinal()][Type.JSONB.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.FLOAT.ordinal()][Type.QUANTILE_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.FLOAT.ordinal()][Type.AGG_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DOUBLE.ordinal()][Type.DATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DOUBLE.ordinal()][Type.DATETIME.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.DOUBLE.ordinal()][Type.CHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DOUBLE.ordinal()][Type.VARCHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DOUBLE.ordinal()][Type.DECIMALV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DOUBLE.ordinal()][Type.DECIMAL32.ordinal()] = PrimitiveType.DECIMAL128;
        Type.compatibilityMatrix[Type.DOUBLE.ordinal()][Type.DECIMAL64.ordinal()] = PrimitiveType.DECIMAL128;
        Type.compatibilityMatrix[Type.DOUBLE.ordinal()][Type.DECIMAL128.ordinal()] = PrimitiveType.DECIMAL128;
        Type.compatibilityMatrix[Type.DOUBLE.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DOUBLE.ordinal()][Type.TIME.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.DOUBLE.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DOUBLE.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DOUBLE.ordinal()][Type.JSONB.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DOUBLE.ordinal()][Type.QUANTILE_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DOUBLE.ordinal()][Type.DATEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DOUBLE.ordinal()][Type.DATETIMEV2.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.DOUBLE.ordinal()][Type.TIMEV2.ordinal()] = PrimitiveType.DOUBLE;
        Type.compatibilityMatrix[Type.DOUBLE.ordinal()][Type.AGG_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATE.ordinal()][Type.DATETIME.ordinal()] = PrimitiveType.DATETIME;
        Type.compatibilityMatrix[Type.DATE.ordinal()][Type.DATEV2.ordinal()] = PrimitiveType.DATEV2;
        Type.compatibilityMatrix[Type.DATE.ordinal()][Type.DATETIMEV2.ordinal()] = PrimitiveType.DATETIMEV2;
        Type.compatibilityMatrix[Type.DATE.ordinal()][Type.CHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATE.ordinal()][Type.VARCHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATE.ordinal()][Type.DECIMALV2.ordinal()] = PrimitiveType.DECIMALV2;
        Type.compatibilityMatrix[Type.DATE.ordinal()][Type.DECIMAL32.ordinal()] = PrimitiveType.DECIMAL32;
        Type.compatibilityMatrix[Type.DATE.ordinal()][Type.DECIMAL64.ordinal()] = PrimitiveType.DECIMAL64;
        Type.compatibilityMatrix[Type.DATE.ordinal()][Type.DECIMAL128.ordinal()] = PrimitiveType.DECIMAL128;
        Type.compatibilityMatrix[Type.DATE.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATE.ordinal()][Type.TIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATE.ordinal()][Type.TIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATE.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATE.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATE.ordinal()][Type.JSONB.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATE.ordinal()][Type.QUANTILE_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATE.ordinal()][Type.AGG_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATEV2.ordinal()][Type.DATE.ordinal()] = PrimitiveType.DATEV2;
        Type.compatibilityMatrix[Type.DATEV2.ordinal()][Type.DATETIME.ordinal()] = PrimitiveType.DATETIMEV2;
        Type.compatibilityMatrix[Type.DATEV2.ordinal()][Type.DATETIMEV2.ordinal()] = PrimitiveType.DATETIMEV2;
        Type.compatibilityMatrix[Type.DATEV2.ordinal()][Type.CHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATEV2.ordinal()][Type.VARCHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATEV2.ordinal()][Type.DECIMALV2.ordinal()] = PrimitiveType.DECIMALV2;
        Type.compatibilityMatrix[Type.DATEV2.ordinal()][Type.DECIMAL32.ordinal()] = PrimitiveType.DECIMAL32;
        Type.compatibilityMatrix[Type.DATEV2.ordinal()][Type.DECIMAL64.ordinal()] = PrimitiveType.DECIMAL64;
        Type.compatibilityMatrix[Type.DATEV2.ordinal()][Type.DECIMAL128.ordinal()] = PrimitiveType.DECIMAL128;
        Type.compatibilityMatrix[Type.DATEV2.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATEV2.ordinal()][Type.TIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATEV2.ordinal()][Type.TIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATEV2.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATEV2.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATEV2.ordinal()][Type.JSONB.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATEV2.ordinal()][Type.QUANTILE_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATEV2.ordinal()][Type.AGG_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATETIME.ordinal()][Type.CHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATETIME.ordinal()][Type.DATETIMEV2.ordinal()] = PrimitiveType.DATETIMEV2;
        Type.compatibilityMatrix[Type.DATETIME.ordinal()][Type.DATEV2.ordinal()] = PrimitiveType.DATETIMEV2;
        Type.compatibilityMatrix[Type.DATETIME.ordinal()][Type.VARCHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATETIME.ordinal()][Type.DECIMALV2.ordinal()] = PrimitiveType.DECIMALV2;
        Type.compatibilityMatrix[Type.DATETIME.ordinal()][Type.DECIMAL32.ordinal()] = PrimitiveType.DECIMAL64;
        Type.compatibilityMatrix[Type.DATETIME.ordinal()][Type.DECIMAL64.ordinal()] = PrimitiveType.DECIMAL64;
        Type.compatibilityMatrix[Type.DATETIME.ordinal()][Type.DECIMAL128.ordinal()] = PrimitiveType.DECIMAL128;
        Type.compatibilityMatrix[Type.DATETIME.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATETIME.ordinal()][Type.TIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATETIME.ordinal()][Type.TIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATETIME.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATETIME.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATETIME.ordinal()][Type.JSONB.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATETIME.ordinal()][Type.QUANTILE_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATETIME.ordinal()][Type.AGG_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATETIMEV2.ordinal()][Type.CHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATETIMEV2.ordinal()][Type.DATETIME.ordinal()] = PrimitiveType.DATETIMEV2;
        Type.compatibilityMatrix[Type.DATETIMEV2.ordinal()][Type.DATEV2.ordinal()] = PrimitiveType.DATETIMEV2;
        Type.compatibilityMatrix[Type.DATETIMEV2.ordinal()][Type.VARCHAR.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATETIMEV2.ordinal()][Type.DECIMALV2.ordinal()] = PrimitiveType.DECIMALV2;
        Type.compatibilityMatrix[Type.DATETIMEV2.ordinal()][Type.DECIMAL32.ordinal()] = PrimitiveType.DECIMAL64;
        Type.compatibilityMatrix[Type.DATETIMEV2.ordinal()][Type.DECIMAL64.ordinal()] = PrimitiveType.DECIMAL64;
        Type.compatibilityMatrix[Type.DATETIMEV2.ordinal()][Type.DECIMAL128.ordinal()] = PrimitiveType.DECIMAL128;
        Type.compatibilityMatrix[Type.DATETIMEV2.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATETIMEV2.ordinal()][Type.TIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATETIMEV2.ordinal()][Type.TIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATETIMEV2.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATETIMEV2.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATETIMEV2.ordinal()][Type.JSONB.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATETIMEV2.ordinal()][Type.QUANTILE_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DATETIMEV2.ordinal()][Type.AGG_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.CHAR.ordinal()][Type.VARCHAR.ordinal()] = PrimitiveType.VARCHAR;
        Type.compatibilityMatrix[Type.CHAR.ordinal()][Type.DATEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.CHAR.ordinal()][Type.DATETIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.CHAR.ordinal()][Type.DECIMALV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.CHAR.ordinal()][Type.DECIMAL32.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.CHAR.ordinal()][Type.DECIMAL64.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.CHAR.ordinal()][Type.DECIMAL128.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.CHAR.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.CHAR.ordinal()][Type.TIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.CHAR.ordinal()][Type.TIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.CHAR.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.CHAR.ordinal()][Type.STRING.ordinal()] = PrimitiveType.STRING;
        Type.compatibilityMatrix[Type.CHAR.ordinal()][Type.JSONB.ordinal()] = PrimitiveType.CHAR;
        Type.compatibilityMatrix[Type.CHAR.ordinal()][Type.QUANTILE_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.CHAR.ordinal()][Type.AGG_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.VARCHAR.ordinal()][Type.DECIMALV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.VARCHAR.ordinal()][Type.DECIMAL32.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.VARCHAR.ordinal()][Type.DECIMAL64.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.VARCHAR.ordinal()][Type.DECIMAL128.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.VARCHAR.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.VARCHAR.ordinal()][Type.TIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.VARCHAR.ordinal()][Type.TIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.VARCHAR.ordinal()][Type.DATETIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.VARCHAR.ordinal()][Type.DATEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.VARCHAR.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.VARCHAR.ordinal()][Type.STRING.ordinal()] = PrimitiveType.STRING;
        Type.compatibilityMatrix[Type.VARCHAR.ordinal()][Type.JSONB.ordinal()] = PrimitiveType.VARCHAR;
        Type.compatibilityMatrix[Type.VARCHAR.ordinal()][Type.QUANTILE_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.VARCHAR.ordinal()][Type.AGG_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.STRING.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.STRING.ordinal()][Type.TIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.STRING.ordinal()][Type.TIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.STRING.ordinal()][Type.DATEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.STRING.ordinal()][Type.DATETIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.STRING.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.STRING.ordinal()][Type.QUANTILE_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.STRING.ordinal()][Type.DECIMAL32.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.STRING.ordinal()][Type.DECIMAL64.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.STRING.ordinal()][Type.DECIMAL128.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.STRING.ordinal()][Type.JSONB.ordinal()] = PrimitiveType.STRING;
        Type.compatibilityMatrix[Type.STRING.ordinal()][Type.AGG_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.JSONB.ordinal()][Type.DECIMALV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.JSONB.ordinal()][Type.DECIMAL32.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.JSONB.ordinal()][Type.DECIMAL64.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.JSONB.ordinal()][Type.DECIMAL128.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.JSONB.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.JSONB.ordinal()][Type.TIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.JSONB.ordinal()][Type.TIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.JSONB.ordinal()][Type.DATEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.JSONB.ordinal()][Type.DATETIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.JSONB.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.JSONB.ordinal()][Type.QUANTILE_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.JSONB.ordinal()][Type.STRING.ordinal()] = PrimitiveType.STRING;
        Type.compatibilityMatrix[Type.JSONB.ordinal()][Type.CHAR.ordinal()] = PrimitiveType.CHAR;
        Type.compatibilityMatrix[Type.JSONB.ordinal()][Type.VARCHAR.ordinal()] = PrimitiveType.VARCHAR;
        Type.compatibilityMatrix[Type.JSONB.ordinal()][Type.AGG_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMALV2.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMALV2.ordinal()][Type.TIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMALV2.ordinal()][Type.TIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMALV2.ordinal()][Type.DATEV2.ordinal()] = PrimitiveType.DECIMALV2;
        Type.compatibilityMatrix[Type.DECIMALV2.ordinal()][Type.DATETIMEV2.ordinal()] = PrimitiveType.DECIMALV2;
        Type.compatibilityMatrix[Type.DECIMALV2.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMALV2.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMALV2.ordinal()][Type.JSONB.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMALV2.ordinal()][Type.QUANTILE_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMALV2.ordinal()][Type.DECIMAL32.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMALV2.ordinal()][Type.DECIMAL64.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMALV2.ordinal()][Type.DECIMAL128.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMALV2.ordinal()][Type.AGG_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMAL32.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMAL32.ordinal()][Type.TIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMAL32.ordinal()][Type.TIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMAL32.ordinal()][Type.DATEV2.ordinal()] = PrimitiveType.DECIMAL32;
        Type.compatibilityMatrix[Type.DECIMAL32.ordinal()][Type.DATETIMEV2.ordinal()] = PrimitiveType.DECIMAL32;
        Type.compatibilityMatrix[Type.DECIMAL32.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMAL32.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMAL32.ordinal()][Type.QUANTILE_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMAL32.ordinal()][Type.DECIMALV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMAL32.ordinal()][Type.DECIMAL64.ordinal()] = PrimitiveType.DECIMAL64;
        Type.compatibilityMatrix[Type.DECIMAL32.ordinal()][Type.DECIMAL128.ordinal()] = PrimitiveType.DECIMAL128;
        Type.compatibilityMatrix[Type.DECIMAL32.ordinal()][Type.AGG_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMAL64.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMAL64.ordinal()][Type.TIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMAL64.ordinal()][Type.TIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMAL64.ordinal()][Type.DATEV2.ordinal()] = PrimitiveType.DECIMAL64;
        Type.compatibilityMatrix[Type.DECIMAL64.ordinal()][Type.DATETIMEV2.ordinal()] = PrimitiveType.DECIMAL64;
        Type.compatibilityMatrix[Type.DECIMAL64.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMAL64.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMAL64.ordinal()][Type.QUANTILE_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMAL64.ordinal()][Type.DECIMALV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMAL64.ordinal()][Type.DECIMAL32.ordinal()] = PrimitiveType.DECIMAL64;
        Type.compatibilityMatrix[Type.DECIMAL64.ordinal()][Type.DECIMAL128.ordinal()] = PrimitiveType.DECIMAL128;
        Type.compatibilityMatrix[Type.DECIMAL64.ordinal()][Type.AGG_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMAL128.ordinal()][Type.HLL.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMAL128.ordinal()][Type.TIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMAL128.ordinal()][Type.TIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMAL128.ordinal()][Type.DATEV2.ordinal()] = PrimitiveType.DECIMAL128;
        Type.compatibilityMatrix[Type.DECIMAL128.ordinal()][Type.DATETIMEV2.ordinal()] = PrimitiveType.DECIMAL128;
        Type.compatibilityMatrix[Type.DECIMAL128.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMAL128.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMAL128.ordinal()][Type.QUANTILE_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMAL128.ordinal()][Type.DECIMALV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.DECIMAL128.ordinal()][Type.DECIMAL32.ordinal()] = PrimitiveType.DECIMAL128;
        Type.compatibilityMatrix[Type.DECIMAL128.ordinal()][Type.DECIMAL64.ordinal()] = PrimitiveType.DECIMAL128;
        Type.compatibilityMatrix[Type.DECIMAL128.ordinal()][Type.AGG_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.HLL.ordinal()][Type.TIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.HLL.ordinal()][Type.TIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.HLL.ordinal()][Type.DATEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.HLL.ordinal()][Type.DATETIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.HLL.ordinal()][Type.BITMAP.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.HLL.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.HLL.ordinal()][Type.JSONB.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.HLL.ordinal()][Type.QUANTILE_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.HLL.ordinal()][Type.DECIMAL32.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.HLL.ordinal()][Type.DECIMAL64.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.HLL.ordinal()][Type.DECIMAL128.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.HLL.ordinal()][Type.AGG_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BITMAP.ordinal()][Type.TIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BITMAP.ordinal()][Type.TIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BITMAP.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BITMAP.ordinal()][Type.JSONB.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BITMAP.ordinal()][Type.QUANTILE_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BITMAP.ordinal()][Type.DATEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BITMAP.ordinal()][Type.DATETIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BITMAP.ordinal()][Type.DECIMAL32.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BITMAP.ordinal()][Type.DECIMAL64.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BITMAP.ordinal()][Type.DECIMAL128.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.BITMAP.ordinal()][Type.AGG_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.QUANTILE_STATE.ordinal()][Type.JSONB.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.QUANTILE_STATE.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.QUANTILE_STATE.ordinal()][Type.DATEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.QUANTILE_STATE.ordinal()][Type.DATETIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.QUANTILE_STATE.ordinal()][Type.DECIMAL32.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.QUANTILE_STATE.ordinal()][Type.DECIMAL64.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.QUANTILE_STATE.ordinal()][Type.DECIMAL128.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.QUANTILE_STATE.ordinal()][Type.AGG_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.AGG_STATE.ordinal()][Type.JSONB.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.AGG_STATE.ordinal()][Type.STRING.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.AGG_STATE.ordinal()][Type.DATEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.AGG_STATE.ordinal()][Type.DATETIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.AGG_STATE.ordinal()][Type.DECIMAL32.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.AGG_STATE.ordinal()][Type.DECIMAL64.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.AGG_STATE.ordinal()][Type.DECIMAL128.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TIME.ordinal()][Type.TIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TIME.ordinal()][Type.TIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TIME.ordinal()][Type.DECIMAL32.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TIME.ordinal()][Type.DECIMAL64.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TIME.ordinal()][Type.DECIMAL128.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TIME.ordinal()][Type.DATEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TIME.ordinal()][Type.DATETIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TIME.ordinal()][Type.AGG_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TIMEV2.ordinal()][Type.TIMEV2.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TIMEV2.ordinal()][Type.TIME.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TIMEV2.ordinal()][Type.DECIMAL32.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TIMEV2.ordinal()][Type.DECIMAL64.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TIMEV2.ordinal()][Type.DECIMAL128.ordinal()] = PrimitiveType.INVALID_TYPE;
        Type.compatibilityMatrix[Type.TIMEV2.ordinal()][Type.AGG_STATE.ordinal()] = PrimitiveType.INVALID_TYPE;
        for (i = 0; i < PrimitiveType.values().length - 2; ++i) {
            for (int j = i; j < PrimitiveType.values().length - 2; ++j) {
                PrimitiveType t1 = PrimitiveType.values()[i];
                PrimitiveType t2 = PrimitiveType.values()[j];
                if (t1 == PrimitiveType.INVALID_TYPE || t2 == PrimitiveType.INVALID_TYPE || t1 == PrimitiveType.NULL_TYPE || t2 == PrimitiveType.NULL_TYPE || t1 == PrimitiveType.ARRAY || t2 == PrimitiveType.ARRAY || t1 == PrimitiveType.DECIMALV2 || t2 == PrimitiveType.DECIMALV2 || t1 == PrimitiveType.TIME || t2 == PrimitiveType.TIME || t1 == PrimitiveType.TIMEV2 || t2 == PrimitiveType.TIMEV2 || t1 == PrimitiveType.MAP || t2 == PrimitiveType.MAP || t1 == PrimitiveType.STRUCT || t2 == PrimitiveType.STRUCT || t1 == PrimitiveType.TEMPLATE || t2 == PrimitiveType.TEMPLATE || t1 == PrimitiveType.UNSUPPORTED || t2 == PrimitiveType.UNSUPPORTED || t1 == PrimitiveType.VARIANT || t2 == PrimitiveType.VARIANT || t1 == PrimitiveType.LAMBDA_FUNCTION || t2 == PrimitiveType.LAMBDA_FUNCTION) continue;
                Preconditions.checkNotNull((Object)((Object)compatibilityMatrix[i][j]));
            }
        }
    }
}

