/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.Type;
import org.apache.doris.catalog.TypeException;
import org.apache.doris.thrift.TColumnType;
import org.apache.doris.thrift.TTypeDesc;

public class TemplateType
extends Type {
    @SerializedName(value="name")
    private final String name;
    @SerializedName(value="isVariadic")
    private final boolean isVariadic;

    public TemplateType(String name, boolean isVariadic) {
        this.name = name;
        this.isVariadic = isVariadic;
    }

    public TemplateType(String name) {
        this(name, false);
    }

    @Override
    public PrimitiveType getPrimitiveType() {
        return PrimitiveType.TEMPLATE;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TemplateType)) {
            return false;
        }
        TemplateType o = (TemplateType)other;
        return o.name.equals(this.name) && o.isVariadic == this.isVariadic;
    }

    @Override
    public boolean matchesType(Type t) {
        return false;
    }

    @Override
    public boolean hasTemplateType() {
        return true;
    }

    @Override
    public boolean needExpandTemplateType() {
        return this.isVariadic;
    }

    @Override
    public Type specializeTemplateType(Type specificType, Map<String, Type> specializedTypeMap, boolean useSpecializedType) throws TypeException {
        if (specificType.hasTemplateType() && !specificType.isNull()) {
            throw new TypeException(specificType + " should not hasTemplateType");
        }
        Type specializedType = specializedTypeMap.get(this.name);
        if (useSpecializedType) {
            if (specializedType == null) {
                throw new TypeException("template type " + this.name + " is not specialized yet");
            }
            return specializedType;
        }
        if (!(specializedType == null || specificType.equals(specializedType) || specificType.matchesType(specializedType) || Type.isImplicitlyCastable(specificType, specializedType, true) || Type.canCastTo(specificType, specializedType))) {
            throw new TypeException(String.format("can not specialize template type %s to %s since it's already specialized as %s", this.name, specificType, specializedType));
        }
        if (specializedType == null) {
            specializedTypeMap.put(this.name, specificType);
        }
        return specializedTypeMap.get(this.name);
    }

    @Override
    public void collectTemplateExpandSize(Type[] args, Map<String, Integer> expandSizeMap) throws TypeException {
        Preconditions.checkState((boolean)this.isVariadic);
        expandSizeMap.computeIfAbsent(this.name, k -> args.length);
        if (expandSizeMap.get(this.name) != args.length) {
            throw new TypeException(String.format("can not expand variadic template type %s to %s size since it's already expand as %s size", this.name, args.length, expandSizeMap.get(this.name)));
        }
    }

    @Override
    public List<Type> expandVariadicTemplateType(Map<String, Integer> expandSizeMap) {
        if (this.needExpandTemplateType() && expandSizeMap.containsKey(this.name)) {
            ArrayList types = Lists.newArrayList();
            int size = expandSizeMap.get(this.name);
            for (int index = 0; index < size; ++index) {
                types.add(new TemplateType(this.name + "_" + index));
            }
            return types;
        }
        return Lists.newArrayList((Object[])new Type[]{this});
    }

    @Override
    public String toSql(int depth) {
        return this.name;
    }

    public String toString() {
        return this.toSql(0).toUpperCase();
    }

    @Override
    protected String prettyPrint(int lpad) {
        String leftPadding = Strings.repeat((String)" ", (int)lpad);
        return leftPadding + this.toSql();
    }

    @Override
    public boolean supportSubType(Type subType) {
        throw new RuntimeException("supportSubType not implementd for TemplateType");
    }

    @Override
    public void toThrift(TTypeDesc container) {
        throw new RuntimeException("can not call toThrift on TemplateType");
    }

    @Override
    public TColumnType toColumnTypeThrift() {
        throw new RuntimeException("can not call toColumnTypeThrift on TemplateType");
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

