/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.doris.catalog.PrimitiveType;
import org.apache.doris.catalog.ScalarType;
import org.apache.doris.catalog.StructField;
import org.apache.doris.catalog.Type;
import org.apache.doris.catalog.TypeException;
import org.apache.doris.thrift.TColumnType;
import org.apache.doris.thrift.TStructField;
import org.apache.doris.thrift.TTypeDesc;
import org.apache.doris.thrift.TTypeNode;
import org.apache.doris.thrift.TTypeNodeType;

public class StructType
extends Type {
    @SerializedName(value="fieldMap")
    private final HashMap<String, StructField> fieldMap = Maps.newHashMap();
    @SerializedName(value="fields")
    private final ArrayList<StructField> fields;

    public StructType(ArrayList<StructField> fields) {
        Preconditions.checkNotNull(fields);
        this.fields = fields;
        for (int i = 0; i < this.fields.size(); ++i) {
            this.fields.get(i).setPosition(i);
            this.fieldMap.put(this.fields.get(i).getName().toLowerCase(), this.fields.get(i));
        }
    }

    public StructType(List<Type> types) {
        Preconditions.checkNotNull(types);
        ArrayList<StructField> newFields = new ArrayList<StructField>();
        for (Type type : types) {
            newFields.add(new StructField(type));
        }
        this.fields = newFields;
    }

    public StructType(Type ... types) {
        this(Arrays.asList(types));
    }

    public StructType() {
        this.fields = Lists.newArrayList();
    }

    @Override
    public String toSql(int depth) {
        if (depth >= MAX_NESTING_DEPTH) {
            return "STRUCT<...>";
        }
        ArrayList fieldsSql = Lists.newArrayList();
        for (StructField f : this.fields) {
            fieldsSql.add(f.toSql(depth + 1));
        }
        return String.format("STRUCT<%s>", Joiner.on((String)",").join((Iterable)fieldsSql));
    }

    @Override
    protected String prettyPrint(int lpad) {
        String leftPadding = Strings.repeat((String)" ", (int)lpad);
        ArrayList fieldsSql = Lists.newArrayList();
        for (StructField f : this.fields) {
            fieldsSql.add(f.prettyPrint(lpad + 2));
        }
        return String.format("%sSTRUCT<\n%s\n%s>", leftPadding, Joiner.on((String)",\n").join((Iterable)fieldsSql), leftPadding);
    }

    public static boolean canCastTo(StructType type, StructType targetType) {
        if (type.fields.size() != targetType.fields.size()) {
            return false;
        }
        for (int i = 0; i < type.fields.size(); ++i) {
            if (StructField.canCastTo(type.fields.get(i), targetType.fields.get(i))) continue;
            return false;
        }
        return true;
    }

    public static Type getAssignmentCompatibleType(StructType t1, StructType t2, boolean strict) {
        ArrayList<StructField> fieldsLeft = t1.getFields();
        ArrayList<StructField> fieldsRight = t2.getFields();
        ArrayList<StructField> fieldsRes = new ArrayList<StructField>();
        for (int i = 0; i < t1.getFields().size(); ++i) {
            StructField leftField = fieldsLeft.get(i);
            StructField rightField = fieldsRight.get(i);
            Type itemCompatibleType = Type.getAssignmentCompatibleType(leftField.getType(), rightField.getType(), strict);
            if (itemCompatibleType.isInvalid()) {
                return ScalarType.INVALID;
            }
            fieldsRes.add(new StructField(StringUtils.isEmpty((CharSequence)leftField.getName()) ? rightField.getName() : leftField.getName(), itemCompatibleType, StringUtils.isEmpty((CharSequence)leftField.getComment()) ? rightField.getComment() : leftField.getComment(), leftField.getContainsNull() || rightField.getContainsNull()));
        }
        return new StructType(fieldsRes);
    }

    @Override
    public boolean isSupported() {
        for (StructField f : this.fields) {
            if (f.getType().isSupported()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean supportSubType(Type subType) {
        for (Type supportedType : Type.getStructSubTypes()) {
            if (subType.getPrimitiveType() != supportedType.getPrimitiveType()) continue;
            return true;
        }
        return false;
    }

    public void addField(StructField field) {
        field.setPosition(this.fields.size());
        this.fields.add(field);
        this.fieldMap.put(field.getName().toLowerCase(), field);
    }

    public ArrayList<StructField> getFields() {
        return this.fields;
    }

    public StructField getField(String fieldName) {
        return this.fieldMap.get(fieldName.toLowerCase());
    }

    public void clearFields() {
        this.fields.clear();
        this.fieldMap.clear();
    }

    @Override
    public PrimitiveType getPrimitiveType() {
        return PrimitiveType.STRUCT;
    }

    @Override
    public boolean matchesType(Type t) {
        if (this.equals(t)) {
            return true;
        }
        if (t.isAnyType()) {
            return t.matchesType(this);
        }
        if (!t.isStructType()) {
            return false;
        }
        StructType other = (StructType)t;
        if (other.getFields().size() == 1 && Objects.equals(other.getFields().get((int)0).name, Type.GENERIC_STRUCT.getFields().get((int)0).name)) {
            return true;
        }
        if (this.fields.size() != other.getFields().size()) {
            return false;
        }
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get(i).matchesField(((StructType)t).getFields().get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasTemplateType() {
        for (StructField field : this.fields) {
            if (!field.type.hasTemplateType()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Type specializeTemplateType(Type specificType, Map<String, Type> specializedTypeMap, boolean useSpecializedType) throws TypeException {
        StructType specificStructType = null;
        if (specificType instanceof StructType) {
            specificStructType = (StructType)specificType;
        } else if (!useSpecializedType) {
            throw new TypeException(specificType + " is not StructType");
        }
        ArrayList newTypes = Lists.newArrayList();
        for (int i = 0; i < this.fields.size(); ++i) {
            if (!this.fields.get((int)i).type.hasTemplateType()) continue;
            newTypes.add(this.fields.get((int)i).type.specializeTemplateType(specificStructType != null ? specificStructType.fields.get((int)i).type : specificType, specializedTypeMap, useSpecializedType));
        }
        StructType newStructType = new StructType(newTypes);
        if (Type.canCastTo(specificType, newStructType) || useSpecializedType && !(specificType instanceof StructType)) {
            return newStructType;
        }
        throw new TypeException(specificType + " can not cast to specialize type " + newStructType);
    }

    @Override
    public boolean needExpandTemplateType() {
        Preconditions.checkNotNull(this.fields);
        return this.fields.get((int)(this.fields.size() - 1)).type.needExpandTemplateType();
    }

    @Override
    public void collectTemplateExpandSize(Type[] args, Map<String, Integer> expandSizeMap) throws TypeException {
        Preconditions.checkState((boolean)this.needExpandTemplateType());
        if (args == null || args.length == 0) {
            throw new TypeException("can not expand template type in struct since input args is empty.");
        }
        if (!(args[0] instanceof StructType)) {
            throw new TypeException(args[0] + " is not StructType");
        }
        StructType structType = (StructType)args[0];
        if (structType.fields.size() < this.fields.size()) {
            throw new TypeException("the field size of input struct type " + structType + " is less than struct template " + this);
        }
        Type[] types = (Type[])structType.fields.subList(this.fields.size() - 1, structType.fields.size()).stream().map(field -> field.type).toArray(Type[]::new);
        this.fields.get((int)(this.fields.size() - 1)).type.collectTemplateExpandSize(types, expandSizeMap);
    }

    @Override
    public List<Type> expandVariadicTemplateType(Map<String, Integer> expandSizeMap) {
        Type type = this.fields.get((int)(this.fields.size() - 1)).type;
        if (type.needExpandTemplateType()) {
            List<Type> types = this.fields.subList(0, this.fields.size() - 1).stream().map(field -> field.type).collect(Collectors.toList());
            types.addAll(type.expandVariadicTemplateType(expandSizeMap));
            return Lists.newArrayList((Object[])new Type[]{new StructType(types)});
        }
        return Lists.newArrayList((Object[])new Type[]{this});
    }

    public StructType replaceFieldsWithNames(List<String> names) {
        Preconditions.checkState((names.size() == this.fields.size() ? 1 : 0) != 0);
        ArrayList newFields = Lists.newArrayList();
        for (int i = 0; i < names.size(); ++i) {
            newFields.add(new StructField(names.get(i), this.fields.get((int)i).type));
        }
        return new StructType(newFields);
    }

    public boolean equals(Object other) {
        if (!(other instanceof StructType)) {
            return false;
        }
        StructType otherStructType = (StructType)other;
        return otherStructType.getFields().equals(this.fields);
    }

    @Override
    public void toThrift(TTypeDesc container) {
        TTypeNode node = new TTypeNode();
        container.types.add(node);
        Preconditions.checkNotNull(this.fields);
        Preconditions.checkState((!this.fields.isEmpty() ? 1 : 0) != 0);
        node.setType(TTypeNodeType.STRUCT);
        node.setStructFields(new ArrayList<TStructField>());
        for (StructField field : this.fields) {
            field.toThrift(container, node);
        }
    }

    public String toString() {
        ArrayList fieldsSql = Lists.newArrayList();
        for (StructField f : this.fields) {
            fieldsSql.add(f.toString());
        }
        return String.format("STRUCT<%s>", Joiner.on((String)",").join((Iterable)fieldsSql));
    }

    @Override
    public TColumnType toColumnTypeThrift() {
        TColumnType thrift = new TColumnType();
        thrift.type = PrimitiveType.STRUCT.toThrift();
        return thrift;
    }

    @Override
    public boolean isFixedLengthType() {
        return false;
    }

    @Override
    public boolean supportsTablePartitioning() {
        return false;
    }

    @Override
    public int getSlotSize() {
        return PrimitiveType.STRUCT.getSlotSize();
    }
}

