/*
 * Decompiled with CFR 0.152.
 */
package org.apache.doris.catalog;

import com.google.common.base.Strings;
import com.google.gson.annotations.SerializedName;
import org.apache.commons.lang3.StringUtils;
import org.apache.doris.catalog.Type;
import org.apache.doris.thrift.TStructField;
import org.apache.doris.thrift.TTypeDesc;
import org.apache.doris.thrift.TTypeNode;

public class StructField {
    @SerializedName(value="name")
    protected final String name;
    @SerializedName(value="type")
    protected final Type type;
    @SerializedName(value="comment")
    protected final String comment;
    @SerializedName(value="position")
    protected int position;
    @SerializedName(value="containsNull")
    private final boolean containsNull;
    private static final String DEFAULT_FIELD_NAME = "col";

    public StructField(String name, Type type, String comment, boolean containsNull) {
        this.name = name.toLowerCase();
        this.type = type;
        this.comment = comment;
        this.containsNull = containsNull;
    }

    public StructField(String name, Type type) {
        this(name, type, null, true);
    }

    public StructField(String name, Type type, String comment) {
        this(name, type, comment, true);
    }

    public StructField(Type type) {
        this(DEFAULT_FIELD_NAME, type, null, true);
    }

    public String getComment() {
        return this.comment;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public boolean getContainsNull() {
        return this.containsNull;
    }

    public String toSql(int depth) {
        String typeSql = depth < Type.MAX_NESTING_DEPTH ? (!this.containsNull ? "not_null(" + this.type.toSql(depth) + ")" : this.type.toSql(depth)) : "...";
        StringBuilder sb = new StringBuilder(this.name);
        if (this.type != null) {
            sb.append(":").append(typeSql);
        }
        if (StringUtils.isNotBlank((CharSequence)this.comment)) {
            sb.append(String.format(" COMMENT '%s'", this.comment));
        }
        return sb.toString();
    }

    public String prettyPrint(int lpad) {
        String leftPadding = Strings.repeat((String)" ", (int)lpad);
        StringBuilder sb = new StringBuilder(leftPadding + this.name);
        if (this.type != null) {
            String typeStr = this.type.prettyPrint(lpad);
            typeStr = typeStr.substring(lpad);
            sb.append(":").append(typeStr);
        }
        if (StringUtils.isNotBlank((CharSequence)this.comment)) {
            sb.append(String.format(" COMMENT '%s'", this.comment));
        }
        return sb.toString();
    }

    public static boolean canCastTo(StructField field, StructField targetField) {
        if (targetField.containsNull != field.containsNull) {
            return false;
        }
        if (targetField.type.isStringType() && field.type.isStringType()) {
            return true;
        }
        return Type.canCastTo(field.type, targetField.type);
    }

    public boolean matchesField(StructField f) {
        if (this.equals(f)) {
            return true;
        }
        return this.type.matchesType(f.getType()) && this.containsNull == f.getContainsNull();
    }

    public void toThrift(TTypeDesc container, TTypeNode node) {
        TStructField field = new TStructField();
        field.setName(this.name);
        field.setContainsNull(this.containsNull);
        node.struct_fields.add(field);
        this.type.toThrift(container);
    }

    public boolean equals(Object other) {
        if (!(other instanceof StructField)) {
            return false;
        }
        StructField otherStructField = (StructField)other;
        return otherStructField.name.equals(this.name) && otherStructField.type.equals(this.type) && otherStructField.containsNull == this.containsNull;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        if (this.type != null) {
            sb.append(":").append(this.type);
        }
        if (StringUtils.isNotBlank((CharSequence)this.comment)) {
            sb.append(String.format(" COMMENT '%s'", this.comment));
        }
        return sb.toString();
    }
}

